# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CacheArgs', 'Cache']

@pulumi.input_type
class CacheArgs:
    def __init__(__self__, *,
                 cache_size_in_gb: pulumi.Input[builtins.int],
                 resource_group_name: pulumi.Input[builtins.str],
                 sku_name: pulumi.Input[builtins.str],
                 subnet_id: pulumi.Input[builtins.str],
                 automatically_rotate_key_to_latest_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 default_access_policy: Optional[pulumi.Input['CacheDefaultAccessPolicyArgs']] = None,
                 directory_active_directory: Optional[pulumi.Input['CacheDirectoryActiveDirectoryArgs']] = None,
                 directory_flat_file: Optional[pulumi.Input['CacheDirectoryFlatFileArgs']] = None,
                 directory_ldap: Optional[pulumi.Input['CacheDirectoryLdapArgs']] = None,
                 dns: Optional[pulumi.Input['CacheDnsArgs']] = None,
                 identity: Optional[pulumi.Input['CacheIdentityArgs']] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mtu: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ntp_server: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Cache resource.
        :param pulumi.Input[builtins.int] cache_size_in_gb: The size of the HPC Cache, in GB. Possible values are `3072`, `6144`, `12288`, `21623`, `24576`, `43246`, `49152` and `86491`. Changing this forces a new resource to be created.
               
               > **Note:** The `21623`, `43246` and `86491` sizes are restricted to read only resources.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which to create the HPC Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku_name: The SKU of HPC Cache to use. Possible values are (ReadWrite) - `Standard_2G`, `Standard_4G` `Standard_8G` or (ReadOnly) - `Standard_L4_5G`, `Standard_L9G`, and `Standard_L16G`. Changing this forces a new resource to be created.
               
               > **Note:** The read-only SKUs have restricted cache sizes. `Standard_L4_5G` must be set to `21623`. `Standard_L9G` to `43246` and `Standard_L16G` to `86491`.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet for the HPC Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] automatically_rotate_key_to_latest_enabled: Specifies whether the HPC Cache automatically rotates Encryption Key to the latest version.
        :param pulumi.Input['CacheDefaultAccessPolicyArgs'] default_access_policy: A `default_access_policy` block as defined below.
        :param pulumi.Input['CacheDirectoryActiveDirectoryArgs'] directory_active_directory: A `directory_active_directory` block as defined below.
        :param pulumi.Input['CacheDirectoryFlatFileArgs'] directory_flat_file: A `directory_flat_file` block as defined below.
        :param pulumi.Input['CacheDirectoryLdapArgs'] directory_ldap: A `directory_ldap` block as defined below.
               
               > **Note:** Only one of `directory_active_directory`, `directory_flat_file` and `directory_ldap` can be set.
        :param pulumi.Input['CacheDnsArgs'] dns: A `dns` block as defined below.
        :param pulumi.Input['CacheIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to encrypt the data in this HPC Cache.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure Region where the HPC Cache should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] mtu: The IPv4 maximum transmission unit configured for the subnet of the HPC Cache. Possible values range from 576 - 1500. Defaults to `1500`.
        :param pulumi.Input[builtins.str] name: The name of the HPC Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ntp_server: The NTP server IP Address or FQDN for the HPC Cache. Defaults to `time.windows.com`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the HPC Cache.
        """
        pulumi.set(__self__, "cache_size_in_gb", cache_size_in_gb)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if automatically_rotate_key_to_latest_enabled is not None:
            pulumi.set(__self__, "automatically_rotate_key_to_latest_enabled", automatically_rotate_key_to_latest_enabled)
        if default_access_policy is not None:
            pulumi.set(__self__, "default_access_policy", default_access_policy)
        if directory_active_directory is not None:
            pulumi.set(__self__, "directory_active_directory", directory_active_directory)
        if directory_flat_file is not None:
            pulumi.set(__self__, "directory_flat_file", directory_flat_file)
        if directory_ldap is not None:
            pulumi.set(__self__, "directory_ldap", directory_ldap)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ntp_server is not None:
            pulumi.set(__self__, "ntp_server", ntp_server)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cacheSizeInGb")
    def cache_size_in_gb(self) -> pulumi.Input[builtins.int]:
        """
        The size of the HPC Cache, in GB. Possible values are `3072`, `6144`, `12288`, `21623`, `24576`, `43246`, `49152` and `86491`. Changing this forces a new resource to be created.

        > **Note:** The `21623`, `43246` and `86491` sizes are restricted to read only resources.
        """
        return pulumi.get(self, "cache_size_in_gb")

    @cache_size_in_gb.setter
    def cache_size_in_gb(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "cache_size_in_gb", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group in which to create the HPC Cache. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[builtins.str]:
        """
        The SKU of HPC Cache to use. Possible values are (ReadWrite) - `Standard_2G`, `Standard_4G` `Standard_8G` or (ReadOnly) - `Standard_L4_5G`, `Standard_L9G`, and `Standard_L16G`. Changing this forces a new resource to be created.

        > **Note:** The read-only SKUs have restricted cache sizes. `Standard_L4_5G` must be set to `21623`. `Standard_L9G` to `43246` and `Standard_L16G` to `86491`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sku_name", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Subnet for the HPC Cache. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="automaticallyRotateKeyToLatestEnabled")
    def automatically_rotate_key_to_latest_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the HPC Cache automatically rotates Encryption Key to the latest version.
        """
        return pulumi.get(self, "automatically_rotate_key_to_latest_enabled")

    @automatically_rotate_key_to_latest_enabled.setter
    def automatically_rotate_key_to_latest_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "automatically_rotate_key_to_latest_enabled", value)

    @property
    @pulumi.getter(name="defaultAccessPolicy")
    def default_access_policy(self) -> Optional[pulumi.Input['CacheDefaultAccessPolicyArgs']]:
        """
        A `default_access_policy` block as defined below.
        """
        return pulumi.get(self, "default_access_policy")

    @default_access_policy.setter
    def default_access_policy(self, value: Optional[pulumi.Input['CacheDefaultAccessPolicyArgs']]):
        pulumi.set(self, "default_access_policy", value)

    @property
    @pulumi.getter(name="directoryActiveDirectory")
    def directory_active_directory(self) -> Optional[pulumi.Input['CacheDirectoryActiveDirectoryArgs']]:
        """
        A `directory_active_directory` block as defined below.
        """
        return pulumi.get(self, "directory_active_directory")

    @directory_active_directory.setter
    def directory_active_directory(self, value: Optional[pulumi.Input['CacheDirectoryActiveDirectoryArgs']]):
        pulumi.set(self, "directory_active_directory", value)

    @property
    @pulumi.getter(name="directoryFlatFile")
    def directory_flat_file(self) -> Optional[pulumi.Input['CacheDirectoryFlatFileArgs']]:
        """
        A `directory_flat_file` block as defined below.
        """
        return pulumi.get(self, "directory_flat_file")

    @directory_flat_file.setter
    def directory_flat_file(self, value: Optional[pulumi.Input['CacheDirectoryFlatFileArgs']]):
        pulumi.set(self, "directory_flat_file", value)

    @property
    @pulumi.getter(name="directoryLdap")
    def directory_ldap(self) -> Optional[pulumi.Input['CacheDirectoryLdapArgs']]:
        """
        A `directory_ldap` block as defined below.

        > **Note:** Only one of `directory_active_directory`, `directory_flat_file` and `directory_ldap` can be set.
        """
        return pulumi.get(self, "directory_ldap")

    @directory_ldap.setter
    def directory_ldap(self, value: Optional[pulumi.Input['CacheDirectoryLdapArgs']]):
        pulumi.set(self, "directory_ldap", value)

    @property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input['CacheDnsArgs']]:
        """
        A `dns` block as defined below.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input['CacheDnsArgs']]):
        pulumi.set(self, "dns", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['CacheIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['CacheIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Key Vault Key which should be used to encrypt the data in this HPC Cache.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure Region where the HPC Cache should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The IPv4 maximum transmission unit configured for the subnet of the HPC Cache. Possible values range from 576 - 1500. Defaults to `1500`.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the HPC Cache. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ntpServer")
    def ntp_server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The NTP server IP Address or FQDN for the HPC Cache. Defaults to `time.windows.com`.
        """
        return pulumi.get(self, "ntp_server")

    @ntp_server.setter
    def ntp_server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ntp_server", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the HPC Cache.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CacheState:
    def __init__(__self__, *,
                 automatically_rotate_key_to_latest_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cache_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 default_access_policy: Optional[pulumi.Input['CacheDefaultAccessPolicyArgs']] = None,
                 directory_active_directory: Optional[pulumi.Input['CacheDirectoryActiveDirectoryArgs']] = None,
                 directory_flat_file: Optional[pulumi.Input['CacheDirectoryFlatFileArgs']] = None,
                 directory_ldap: Optional[pulumi.Input['CacheDirectoryLdapArgs']] = None,
                 dns: Optional[pulumi.Input['CacheDnsArgs']] = None,
                 identity: Optional[pulumi.Input['CacheIdentityArgs']] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mount_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 mtu: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ntp_server: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Cache resources.
        :param pulumi.Input[builtins.bool] automatically_rotate_key_to_latest_enabled: Specifies whether the HPC Cache automatically rotates Encryption Key to the latest version.
        :param pulumi.Input[builtins.int] cache_size_in_gb: The size of the HPC Cache, in GB. Possible values are `3072`, `6144`, `12288`, `21623`, `24576`, `43246`, `49152` and `86491`. Changing this forces a new resource to be created.
               
               > **Note:** The `21623`, `43246` and `86491` sizes are restricted to read only resources.
        :param pulumi.Input['CacheDefaultAccessPolicyArgs'] default_access_policy: A `default_access_policy` block as defined below.
        :param pulumi.Input['CacheDirectoryActiveDirectoryArgs'] directory_active_directory: A `directory_active_directory` block as defined below.
        :param pulumi.Input['CacheDirectoryFlatFileArgs'] directory_flat_file: A `directory_flat_file` block as defined below.
        :param pulumi.Input['CacheDirectoryLdapArgs'] directory_ldap: A `directory_ldap` block as defined below.
               
               > **Note:** Only one of `directory_active_directory`, `directory_flat_file` and `directory_ldap` can be set.
        :param pulumi.Input['CacheDnsArgs'] dns: A `dns` block as defined below.
        :param pulumi.Input['CacheIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to encrypt the data in this HPC Cache.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure Region where the HPC Cache should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] mount_addresses: A list of IP Addresses where the HPC Cache can be mounted.
        :param pulumi.Input[builtins.int] mtu: The IPv4 maximum transmission unit configured for the subnet of the HPC Cache. Possible values range from 576 - 1500. Defaults to `1500`.
        :param pulumi.Input[builtins.str] name: The name of the HPC Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ntp_server: The NTP server IP Address or FQDN for the HPC Cache. Defaults to `time.windows.com`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which to create the HPC Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku_name: The SKU of HPC Cache to use. Possible values are (ReadWrite) - `Standard_2G`, `Standard_4G` `Standard_8G` or (ReadOnly) - `Standard_L4_5G`, `Standard_L9G`, and `Standard_L16G`. Changing this forces a new resource to be created.
               
               > **Note:** The read-only SKUs have restricted cache sizes. `Standard_L4_5G` must be set to `21623`. `Standard_L9G` to `43246` and `Standard_L16G` to `86491`.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet for the HPC Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the HPC Cache.
        """
        if automatically_rotate_key_to_latest_enabled is not None:
            pulumi.set(__self__, "automatically_rotate_key_to_latest_enabled", automatically_rotate_key_to_latest_enabled)
        if cache_size_in_gb is not None:
            pulumi.set(__self__, "cache_size_in_gb", cache_size_in_gb)
        if default_access_policy is not None:
            pulumi.set(__self__, "default_access_policy", default_access_policy)
        if directory_active_directory is not None:
            pulumi.set(__self__, "directory_active_directory", directory_active_directory)
        if directory_flat_file is not None:
            pulumi.set(__self__, "directory_flat_file", directory_flat_file)
        if directory_ldap is not None:
            pulumi.set(__self__, "directory_ldap", directory_ldap)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mount_addresses is not None:
            pulumi.set(__self__, "mount_addresses", mount_addresses)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ntp_server is not None:
            pulumi.set(__self__, "ntp_server", ntp_server)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="automaticallyRotateKeyToLatestEnabled")
    def automatically_rotate_key_to_latest_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the HPC Cache automatically rotates Encryption Key to the latest version.
        """
        return pulumi.get(self, "automatically_rotate_key_to_latest_enabled")

    @automatically_rotate_key_to_latest_enabled.setter
    def automatically_rotate_key_to_latest_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "automatically_rotate_key_to_latest_enabled", value)

    @property
    @pulumi.getter(name="cacheSizeInGb")
    def cache_size_in_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The size of the HPC Cache, in GB. Possible values are `3072`, `6144`, `12288`, `21623`, `24576`, `43246`, `49152` and `86491`. Changing this forces a new resource to be created.

        > **Note:** The `21623`, `43246` and `86491` sizes are restricted to read only resources.
        """
        return pulumi.get(self, "cache_size_in_gb")

    @cache_size_in_gb.setter
    def cache_size_in_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cache_size_in_gb", value)

    @property
    @pulumi.getter(name="defaultAccessPolicy")
    def default_access_policy(self) -> Optional[pulumi.Input['CacheDefaultAccessPolicyArgs']]:
        """
        A `default_access_policy` block as defined below.
        """
        return pulumi.get(self, "default_access_policy")

    @default_access_policy.setter
    def default_access_policy(self, value: Optional[pulumi.Input['CacheDefaultAccessPolicyArgs']]):
        pulumi.set(self, "default_access_policy", value)

    @property
    @pulumi.getter(name="directoryActiveDirectory")
    def directory_active_directory(self) -> Optional[pulumi.Input['CacheDirectoryActiveDirectoryArgs']]:
        """
        A `directory_active_directory` block as defined below.
        """
        return pulumi.get(self, "directory_active_directory")

    @directory_active_directory.setter
    def directory_active_directory(self, value: Optional[pulumi.Input['CacheDirectoryActiveDirectoryArgs']]):
        pulumi.set(self, "directory_active_directory", value)

    @property
    @pulumi.getter(name="directoryFlatFile")
    def directory_flat_file(self) -> Optional[pulumi.Input['CacheDirectoryFlatFileArgs']]:
        """
        A `directory_flat_file` block as defined below.
        """
        return pulumi.get(self, "directory_flat_file")

    @directory_flat_file.setter
    def directory_flat_file(self, value: Optional[pulumi.Input['CacheDirectoryFlatFileArgs']]):
        pulumi.set(self, "directory_flat_file", value)

    @property
    @pulumi.getter(name="directoryLdap")
    def directory_ldap(self) -> Optional[pulumi.Input['CacheDirectoryLdapArgs']]:
        """
        A `directory_ldap` block as defined below.

        > **Note:** Only one of `directory_active_directory`, `directory_flat_file` and `directory_ldap` can be set.
        """
        return pulumi.get(self, "directory_ldap")

    @directory_ldap.setter
    def directory_ldap(self, value: Optional[pulumi.Input['CacheDirectoryLdapArgs']]):
        pulumi.set(self, "directory_ldap", value)

    @property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input['CacheDnsArgs']]:
        """
        A `dns` block as defined below.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input['CacheDnsArgs']]):
        pulumi.set(self, "dns", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['CacheIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['CacheIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Key Vault Key which should be used to encrypt the data in this HPC Cache.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure Region where the HPC Cache should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mountAddresses")
    def mount_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of IP Addresses where the HPC Cache can be mounted.
        """
        return pulumi.get(self, "mount_addresses")

    @mount_addresses.setter
    def mount_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "mount_addresses", value)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The IPv4 maximum transmission unit configured for the subnet of the HPC Cache. Possible values range from 576 - 1500. Defaults to `1500`.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the HPC Cache. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ntpServer")
    def ntp_server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The NTP server IP Address or FQDN for the HPC Cache. Defaults to `time.windows.com`.
        """
        return pulumi.get(self, "ntp_server")

    @ntp_server.setter
    def ntp_server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ntp_server", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group in which to create the HPC Cache. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SKU of HPC Cache to use. Possible values are (ReadWrite) - `Standard_2G`, `Standard_4G` `Standard_8G` or (ReadOnly) - `Standard_L4_5G`, `Standard_L9G`, and `Standard_L16G`. Changing this forces a new resource to be created.

        > **Note:** The read-only SKUs have restricted cache sizes. `Standard_L4_5G` must be set to `21623`. `Standard_L9G` to `43246` and `Standard_L16G` to `86491`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Subnet for the HPC Cache. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the HPC Cache.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:hpc/cache:Cache")
class Cache(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatically_rotate_key_to_latest_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cache_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 default_access_policy: Optional[pulumi.Input[Union['CacheDefaultAccessPolicyArgs', 'CacheDefaultAccessPolicyArgsDict']]] = None,
                 directory_active_directory: Optional[pulumi.Input[Union['CacheDirectoryActiveDirectoryArgs', 'CacheDirectoryActiveDirectoryArgsDict']]] = None,
                 directory_flat_file: Optional[pulumi.Input[Union['CacheDirectoryFlatFileArgs', 'CacheDirectoryFlatFileArgsDict']]] = None,
                 directory_ldap: Optional[pulumi.Input[Union['CacheDirectoryLdapArgs', 'CacheDirectoryLdapArgsDict']]] = None,
                 dns: Optional[pulumi.Input[Union['CacheDnsArgs', 'CacheDnsArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['CacheIdentityArgs', 'CacheIdentityArgsDict']]] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mtu: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ntp_server: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a HPC Cache.

        !> **Note:** The `hpc.Cache` resource has been deprecated because the service is retiring on 2025-09-30. This resource will be removed in v5.0 of the AzureRM Provider. See https://aka.ms/hpccacheretirement for more information.

        > **Note:** By request of the service team the provider no longer automatically registers the `Microsoft.StorageCache` Resource Provider for this resource. To register it you can run `az provider register --namespace 'Microsoft.StorageCache'`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="examplevn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="examplesubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        example_cache = azure.hpc.Cache("example",
            name="examplehpccache",
            resource_group_name=example.name,
            location=example.location,
            cache_size_in_gb=3072,
            subnet_id=example_subnet.id,
            sku_name="Standard_2G")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageCache`: 2023-05-01

        ## Import

        HPC Caches can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hpc/cache:Cache example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroupName/providers/Microsoft.StorageCache/caches/cacheName
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] automatically_rotate_key_to_latest_enabled: Specifies whether the HPC Cache automatically rotates Encryption Key to the latest version.
        :param pulumi.Input[builtins.int] cache_size_in_gb: The size of the HPC Cache, in GB. Possible values are `3072`, `6144`, `12288`, `21623`, `24576`, `43246`, `49152` and `86491`. Changing this forces a new resource to be created.
               
               > **Note:** The `21623`, `43246` and `86491` sizes are restricted to read only resources.
        :param pulumi.Input[Union['CacheDefaultAccessPolicyArgs', 'CacheDefaultAccessPolicyArgsDict']] default_access_policy: A `default_access_policy` block as defined below.
        :param pulumi.Input[Union['CacheDirectoryActiveDirectoryArgs', 'CacheDirectoryActiveDirectoryArgsDict']] directory_active_directory: A `directory_active_directory` block as defined below.
        :param pulumi.Input[Union['CacheDirectoryFlatFileArgs', 'CacheDirectoryFlatFileArgsDict']] directory_flat_file: A `directory_flat_file` block as defined below.
        :param pulumi.Input[Union['CacheDirectoryLdapArgs', 'CacheDirectoryLdapArgsDict']] directory_ldap: A `directory_ldap` block as defined below.
               
               > **Note:** Only one of `directory_active_directory`, `directory_flat_file` and `directory_ldap` can be set.
        :param pulumi.Input[Union['CacheDnsArgs', 'CacheDnsArgsDict']] dns: A `dns` block as defined below.
        :param pulumi.Input[Union['CacheIdentityArgs', 'CacheIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to encrypt the data in this HPC Cache.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure Region where the HPC Cache should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] mtu: The IPv4 maximum transmission unit configured for the subnet of the HPC Cache. Possible values range from 576 - 1500. Defaults to `1500`.
        :param pulumi.Input[builtins.str] name: The name of the HPC Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ntp_server: The NTP server IP Address or FQDN for the HPC Cache. Defaults to `time.windows.com`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which to create the HPC Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku_name: The SKU of HPC Cache to use. Possible values are (ReadWrite) - `Standard_2G`, `Standard_4G` `Standard_8G` or (ReadOnly) - `Standard_L4_5G`, `Standard_L9G`, and `Standard_L16G`. Changing this forces a new resource to be created.
               
               > **Note:** The read-only SKUs have restricted cache sizes. `Standard_L4_5G` must be set to `21623`. `Standard_L9G` to `43246` and `Standard_L16G` to `86491`.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet for the HPC Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the HPC Cache.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CacheArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a HPC Cache.

        !> **Note:** The `hpc.Cache` resource has been deprecated because the service is retiring on 2025-09-30. This resource will be removed in v5.0 of the AzureRM Provider. See https://aka.ms/hpccacheretirement for more information.

        > **Note:** By request of the service team the provider no longer automatically registers the `Microsoft.StorageCache` Resource Provider for this resource. To register it you can run `az provider register --namespace 'Microsoft.StorageCache'`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="examplevn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="examplesubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        example_cache = azure.hpc.Cache("example",
            name="examplehpccache",
            resource_group_name=example.name,
            location=example.location,
            cache_size_in_gb=3072,
            subnet_id=example_subnet.id,
            sku_name="Standard_2G")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageCache`: 2023-05-01

        ## Import

        HPC Caches can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hpc/cache:Cache example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroupName/providers/Microsoft.StorageCache/caches/cacheName
        ```

        :param str resource_name: The name of the resource.
        :param CacheArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CacheArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatically_rotate_key_to_latest_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cache_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 default_access_policy: Optional[pulumi.Input[Union['CacheDefaultAccessPolicyArgs', 'CacheDefaultAccessPolicyArgsDict']]] = None,
                 directory_active_directory: Optional[pulumi.Input[Union['CacheDirectoryActiveDirectoryArgs', 'CacheDirectoryActiveDirectoryArgsDict']]] = None,
                 directory_flat_file: Optional[pulumi.Input[Union['CacheDirectoryFlatFileArgs', 'CacheDirectoryFlatFileArgsDict']]] = None,
                 directory_ldap: Optional[pulumi.Input[Union['CacheDirectoryLdapArgs', 'CacheDirectoryLdapArgsDict']]] = None,
                 dns: Optional[pulumi.Input[Union['CacheDnsArgs', 'CacheDnsArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['CacheIdentityArgs', 'CacheIdentityArgsDict']]] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mtu: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ntp_server: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CacheArgs.__new__(CacheArgs)

            __props__.__dict__["automatically_rotate_key_to_latest_enabled"] = automatically_rotate_key_to_latest_enabled
            if cache_size_in_gb is None and not opts.urn:
                raise TypeError("Missing required property 'cache_size_in_gb'")
            __props__.__dict__["cache_size_in_gb"] = cache_size_in_gb
            __props__.__dict__["default_access_policy"] = default_access_policy
            __props__.__dict__["directory_active_directory"] = directory_active_directory
            __props__.__dict__["directory_flat_file"] = directory_flat_file
            __props__.__dict__["directory_ldap"] = directory_ldap
            __props__.__dict__["dns"] = dns
            __props__.__dict__["identity"] = identity
            __props__.__dict__["key_vault_key_id"] = key_vault_key_id
            __props__.__dict__["location"] = location
            __props__.__dict__["mtu"] = mtu
            __props__.__dict__["name"] = name
            __props__.__dict__["ntp_server"] = ntp_server
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["mount_addresses"] = None
        super(Cache, __self__).__init__(
            'azure:hpc/cache:Cache',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automatically_rotate_key_to_latest_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            cache_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
            default_access_policy: Optional[pulumi.Input[Union['CacheDefaultAccessPolicyArgs', 'CacheDefaultAccessPolicyArgsDict']]] = None,
            directory_active_directory: Optional[pulumi.Input[Union['CacheDirectoryActiveDirectoryArgs', 'CacheDirectoryActiveDirectoryArgsDict']]] = None,
            directory_flat_file: Optional[pulumi.Input[Union['CacheDirectoryFlatFileArgs', 'CacheDirectoryFlatFileArgsDict']]] = None,
            directory_ldap: Optional[pulumi.Input[Union['CacheDirectoryLdapArgs', 'CacheDirectoryLdapArgsDict']]] = None,
            dns: Optional[pulumi.Input[Union['CacheDnsArgs', 'CacheDnsArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['CacheIdentityArgs', 'CacheIdentityArgsDict']]] = None,
            key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            mount_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            mtu: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            ntp_server: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            sku_name: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Cache':
        """
        Get an existing Cache resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] automatically_rotate_key_to_latest_enabled: Specifies whether the HPC Cache automatically rotates Encryption Key to the latest version.
        :param pulumi.Input[builtins.int] cache_size_in_gb: The size of the HPC Cache, in GB. Possible values are `3072`, `6144`, `12288`, `21623`, `24576`, `43246`, `49152` and `86491`. Changing this forces a new resource to be created.
               
               > **Note:** The `21623`, `43246` and `86491` sizes are restricted to read only resources.
        :param pulumi.Input[Union['CacheDefaultAccessPolicyArgs', 'CacheDefaultAccessPolicyArgsDict']] default_access_policy: A `default_access_policy` block as defined below.
        :param pulumi.Input[Union['CacheDirectoryActiveDirectoryArgs', 'CacheDirectoryActiveDirectoryArgsDict']] directory_active_directory: A `directory_active_directory` block as defined below.
        :param pulumi.Input[Union['CacheDirectoryFlatFileArgs', 'CacheDirectoryFlatFileArgsDict']] directory_flat_file: A `directory_flat_file` block as defined below.
        :param pulumi.Input[Union['CacheDirectoryLdapArgs', 'CacheDirectoryLdapArgsDict']] directory_ldap: A `directory_ldap` block as defined below.
               
               > **Note:** Only one of `directory_active_directory`, `directory_flat_file` and `directory_ldap` can be set.
        :param pulumi.Input[Union['CacheDnsArgs', 'CacheDnsArgsDict']] dns: A `dns` block as defined below.
        :param pulumi.Input[Union['CacheIdentityArgs', 'CacheIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to encrypt the data in this HPC Cache.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure Region where the HPC Cache should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] mount_addresses: A list of IP Addresses where the HPC Cache can be mounted.
        :param pulumi.Input[builtins.int] mtu: The IPv4 maximum transmission unit configured for the subnet of the HPC Cache. Possible values range from 576 - 1500. Defaults to `1500`.
        :param pulumi.Input[builtins.str] name: The name of the HPC Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ntp_server: The NTP server IP Address or FQDN for the HPC Cache. Defaults to `time.windows.com`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in which to create the HPC Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku_name: The SKU of HPC Cache to use. Possible values are (ReadWrite) - `Standard_2G`, `Standard_4G` `Standard_8G` or (ReadOnly) - `Standard_L4_5G`, `Standard_L9G`, and `Standard_L16G`. Changing this forces a new resource to be created.
               
               > **Note:** The read-only SKUs have restricted cache sizes. `Standard_L4_5G` must be set to `21623`. `Standard_L9G` to `43246` and `Standard_L16G` to `86491`.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet for the HPC Cache. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the HPC Cache.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CacheState.__new__(_CacheState)

        __props__.__dict__["automatically_rotate_key_to_latest_enabled"] = automatically_rotate_key_to_latest_enabled
        __props__.__dict__["cache_size_in_gb"] = cache_size_in_gb
        __props__.__dict__["default_access_policy"] = default_access_policy
        __props__.__dict__["directory_active_directory"] = directory_active_directory
        __props__.__dict__["directory_flat_file"] = directory_flat_file
        __props__.__dict__["directory_ldap"] = directory_ldap
        __props__.__dict__["dns"] = dns
        __props__.__dict__["identity"] = identity
        __props__.__dict__["key_vault_key_id"] = key_vault_key_id
        __props__.__dict__["location"] = location
        __props__.__dict__["mount_addresses"] = mount_addresses
        __props__.__dict__["mtu"] = mtu
        __props__.__dict__["name"] = name
        __props__.__dict__["ntp_server"] = ntp_server
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        return Cache(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="automaticallyRotateKeyToLatestEnabled")
    def automatically_rotate_key_to_latest_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the HPC Cache automatically rotates Encryption Key to the latest version.
        """
        return pulumi.get(self, "automatically_rotate_key_to_latest_enabled")

    @property
    @pulumi.getter(name="cacheSizeInGb")
    def cache_size_in_gb(self) -> pulumi.Output[builtins.int]:
        """
        The size of the HPC Cache, in GB. Possible values are `3072`, `6144`, `12288`, `21623`, `24576`, `43246`, `49152` and `86491`. Changing this forces a new resource to be created.

        > **Note:** The `21623`, `43246` and `86491` sizes are restricted to read only resources.
        """
        return pulumi.get(self, "cache_size_in_gb")

    @property
    @pulumi.getter(name="defaultAccessPolicy")
    def default_access_policy(self) -> pulumi.Output['outputs.CacheDefaultAccessPolicy']:
        """
        A `default_access_policy` block as defined below.
        """
        return pulumi.get(self, "default_access_policy")

    @property
    @pulumi.getter(name="directoryActiveDirectory")
    def directory_active_directory(self) -> pulumi.Output[Optional['outputs.CacheDirectoryActiveDirectory']]:
        """
        A `directory_active_directory` block as defined below.
        """
        return pulumi.get(self, "directory_active_directory")

    @property
    @pulumi.getter(name="directoryFlatFile")
    def directory_flat_file(self) -> pulumi.Output[Optional['outputs.CacheDirectoryFlatFile']]:
        """
        A `directory_flat_file` block as defined below.
        """
        return pulumi.get(self, "directory_flat_file")

    @property
    @pulumi.getter(name="directoryLdap")
    def directory_ldap(self) -> pulumi.Output[Optional['outputs.CacheDirectoryLdap']]:
        """
        A `directory_ldap` block as defined below.

        > **Note:** Only one of `directory_active_directory`, `directory_flat_file` and `directory_ldap` can be set.
        """
        return pulumi.get(self, "directory_ldap")

    @property
    @pulumi.getter
    def dns(self) -> pulumi.Output[Optional['outputs.CacheDns']]:
        """
        A `dns` block as defined below.
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.CacheIdentity']]:
        """
        An `identity` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the Key Vault Key which should be used to encrypt the data in this HPC Cache.
        """
        return pulumi.get(self, "key_vault_key_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure Region where the HPC Cache should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mountAddresses")
    def mount_addresses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of IP Addresses where the HPC Cache can be mounted.
        """
        return pulumi.get(self, "mount_addresses")

    @property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The IPv4 maximum transmission unit configured for the subnet of the HPC Cache. Possible values range from 576 - 1500. Defaults to `1500`.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the HPC Cache. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ntpServer")
    def ntp_server(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The NTP server IP Address or FQDN for the HPC Cache. Defaults to `time.windows.com`.
        """
        return pulumi.get(self, "ntp_server")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group in which to create the HPC Cache. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[builtins.str]:
        """
        The SKU of HPC Cache to use. Possible values are (ReadWrite) - `Standard_2G`, `Standard_4G` `Standard_8G` or (ReadOnly) - `Standard_L4_5G`, `Standard_L9G`, and `Standard_L16G`. Changing this forces a new resource to be created.

        > **Note:** The read-only SKUs have restricted cache sizes. `Standard_L4_5G` must be set to `21623`. `Standard_L9G` to `43246` and `Standard_L16G` to `86491`.
        """
        return pulumi.get(self, "sku_name")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Subnet for the HPC Cache. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the HPC Cache.
        """
        return pulumi.get(self, "tags")

