# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DpsSharedAccessPolicyArgs', 'DpsSharedAccessPolicy']

@pulumi.input_type
class DpsSharedAccessPolicyArgs:
    def __init__(__self__, *,
                 iothub_dps_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 enrollment_read: Optional[pulumi.Input[builtins.bool]] = None,
                 enrollment_write: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 registration_read: Optional[pulumi.Input[builtins.bool]] = None,
                 registration_write: Optional[pulumi.Input[builtins.bool]] = None,
                 service_config: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a DpsSharedAccessPolicy resource.
        :param pulumi.Input[builtins.str] iothub_dps_name: The name of the IoT Hub Device Provisioning service to which this Shared Access Policy belongs. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group under which the IotHub Shared Access Policy resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] enrollment_read: Adds `EnrollmentRead` permission to this Shared Access Account. It allows read access to enrollment data.
               
               > **Note:** When `enrollment_read` is set to `true`, `registration_read` must also be set to true. This is a limitation of the Azure REST API
        :param pulumi.Input[builtins.bool] enrollment_write: Adds `EnrollmentWrite` permission to this Shared Access Account. It allows write access to enrollment data.
               
               > **Note:** When `registration_write` is set to `true`, `enrollment_read`, `registration_read`, and `registration_write` must also be set to true. This is a requirement of the Azure API.
        :param pulumi.Input[builtins.str] name: Specifies the name of the IotHub Shared Access Policy resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] registration_read: Adds `RegistrationStatusRead` permission to this Shared Access Account. It allows read access to device registrations.
        :param pulumi.Input[builtins.bool] registration_write: Adds `RegistrationStatusWrite` permission to this Shared Access Account. It allows write access to device registrations.
               
               > **Note:** When `registration_write` is set to `true`, `registration_read` must also be set to true. This is a requirement of the Azure API.
        :param pulumi.Input[builtins.bool] service_config: Adds `ServiceConfig` permission to this Shared Access Account. It allows configuration of the Device Provisioning Service.
               
               > **Note:** At least one of `registration_read`, `registration_write`, `service_config`, `enrollment_read`, `enrollment_write` permissions must be set to `true`.
        """
        pulumi.set(__self__, "iothub_dps_name", iothub_dps_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if enrollment_read is not None:
            pulumi.set(__self__, "enrollment_read", enrollment_read)
        if enrollment_write is not None:
            pulumi.set(__self__, "enrollment_write", enrollment_write)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if registration_read is not None:
            pulumi.set(__self__, "registration_read", registration_read)
        if registration_write is not None:
            pulumi.set(__self__, "registration_write", registration_write)
        if service_config is not None:
            pulumi.set(__self__, "service_config", service_config)

    @property
    @pulumi.getter(name="iothubDpsName")
    def iothub_dps_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the IoT Hub Device Provisioning service to which this Shared Access Policy belongs. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_dps_name")

    @iothub_dps_name.setter
    def iothub_dps_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "iothub_dps_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group under which the IotHub Shared Access Policy resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="enrollmentRead")
    def enrollment_read(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Adds `EnrollmentRead` permission to this Shared Access Account. It allows read access to enrollment data.

        > **Note:** When `enrollment_read` is set to `true`, `registration_read` must also be set to true. This is a limitation of the Azure REST API
        """
        return pulumi.get(self, "enrollment_read")

    @enrollment_read.setter
    def enrollment_read(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enrollment_read", value)

    @property
    @pulumi.getter(name="enrollmentWrite")
    def enrollment_write(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Adds `EnrollmentWrite` permission to this Shared Access Account. It allows write access to enrollment data.

        > **Note:** When `registration_write` is set to `true`, `enrollment_read`, `registration_read`, and `registration_write` must also be set to true. This is a requirement of the Azure API.
        """
        return pulumi.get(self, "enrollment_write")

    @enrollment_write.setter
    def enrollment_write(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enrollment_write", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the IotHub Shared Access Policy resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="registrationRead")
    def registration_read(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Adds `RegistrationStatusRead` permission to this Shared Access Account. It allows read access to device registrations.
        """
        return pulumi.get(self, "registration_read")

    @registration_read.setter
    def registration_read(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "registration_read", value)

    @property
    @pulumi.getter(name="registrationWrite")
    def registration_write(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Adds `RegistrationStatusWrite` permission to this Shared Access Account. It allows write access to device registrations.

        > **Note:** When `registration_write` is set to `true`, `registration_read` must also be set to true. This is a requirement of the Azure API.
        """
        return pulumi.get(self, "registration_write")

    @registration_write.setter
    def registration_write(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "registration_write", value)

    @property
    @pulumi.getter(name="serviceConfig")
    def service_config(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Adds `ServiceConfig` permission to this Shared Access Account. It allows configuration of the Device Provisioning Service.

        > **Note:** At least one of `registration_read`, `registration_write`, `service_config`, `enrollment_read`, `enrollment_write` permissions must be set to `true`.
        """
        return pulumi.get(self, "service_config")

    @service_config.setter
    def service_config(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "service_config", value)


@pulumi.input_type
class _DpsSharedAccessPolicyState:
    def __init__(__self__, *,
                 enrollment_read: Optional[pulumi.Input[builtins.bool]] = None,
                 enrollment_write: Optional[pulumi.Input[builtins.bool]] = None,
                 iothub_dps_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 primary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 primary_key: Optional[pulumi.Input[builtins.str]] = None,
                 registration_read: Optional[pulumi.Input[builtins.bool]] = None,
                 registration_write: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_key: Optional[pulumi.Input[builtins.str]] = None,
                 service_config: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering DpsSharedAccessPolicy resources.
        :param pulumi.Input[builtins.bool] enrollment_read: Adds `EnrollmentRead` permission to this Shared Access Account. It allows read access to enrollment data.
               
               > **Note:** When `enrollment_read` is set to `true`, `registration_read` must also be set to true. This is a limitation of the Azure REST API
        :param pulumi.Input[builtins.bool] enrollment_write: Adds `EnrollmentWrite` permission to this Shared Access Account. It allows write access to enrollment data.
               
               > **Note:** When `registration_write` is set to `true`, `enrollment_read`, `registration_read`, and `registration_write` must also be set to true. This is a requirement of the Azure API.
        :param pulumi.Input[builtins.str] iothub_dps_name: The name of the IoT Hub Device Provisioning service to which this Shared Access Policy belongs. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the IotHub Shared Access Policy resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] primary_connection_string: The primary connection string of the Shared Access Policy.
        :param pulumi.Input[builtins.str] primary_key: The primary key used to create the authentication token.
        :param pulumi.Input[builtins.bool] registration_read: Adds `RegistrationStatusRead` permission to this Shared Access Account. It allows read access to device registrations.
        :param pulumi.Input[builtins.bool] registration_write: Adds `RegistrationStatusWrite` permission to this Shared Access Account. It allows write access to device registrations.
               
               > **Note:** When `registration_write` is set to `true`, `registration_read` must also be set to true. This is a requirement of the Azure API.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group under which the IotHub Shared Access Policy resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] secondary_connection_string: The secondary connection string of the Shared Access Policy.
        :param pulumi.Input[builtins.str] secondary_key: The secondary key used to create the authentication token.
        :param pulumi.Input[builtins.bool] service_config: Adds `ServiceConfig` permission to this Shared Access Account. It allows configuration of the Device Provisioning Service.
               
               > **Note:** At least one of `registration_read`, `registration_write`, `service_config`, `enrollment_read`, `enrollment_write` permissions must be set to `true`.
        """
        if enrollment_read is not None:
            pulumi.set(__self__, "enrollment_read", enrollment_read)
        if enrollment_write is not None:
            pulumi.set(__self__, "enrollment_write", enrollment_write)
        if iothub_dps_name is not None:
            pulumi.set(__self__, "iothub_dps_name", iothub_dps_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_connection_string is not None:
            pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if registration_read is not None:
            pulumi.set(__self__, "registration_read", registration_read)
        if registration_write is not None:
            pulumi.set(__self__, "registration_write", registration_write)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_connection_string is not None:
            pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)
        if service_config is not None:
            pulumi.set(__self__, "service_config", service_config)

    @property
    @pulumi.getter(name="enrollmentRead")
    def enrollment_read(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Adds `EnrollmentRead` permission to this Shared Access Account. It allows read access to enrollment data.

        > **Note:** When `enrollment_read` is set to `true`, `registration_read` must also be set to true. This is a limitation of the Azure REST API
        """
        return pulumi.get(self, "enrollment_read")

    @enrollment_read.setter
    def enrollment_read(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enrollment_read", value)

    @property
    @pulumi.getter(name="enrollmentWrite")
    def enrollment_write(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Adds `EnrollmentWrite` permission to this Shared Access Account. It allows write access to enrollment data.

        > **Note:** When `registration_write` is set to `true`, `enrollment_read`, `registration_read`, and `registration_write` must also be set to true. This is a requirement of the Azure API.
        """
        return pulumi.get(self, "enrollment_write")

    @enrollment_write.setter
    def enrollment_write(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enrollment_write", value)

    @property
    @pulumi.getter(name="iothubDpsName")
    def iothub_dps_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the IoT Hub Device Provisioning service to which this Shared Access Policy belongs. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_dps_name")

    @iothub_dps_name.setter
    def iothub_dps_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iothub_dps_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the IotHub Shared Access Policy resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary connection string of the Shared Access Policy.
        """
        return pulumi.get(self, "primary_connection_string")

    @primary_connection_string.setter
    def primary_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_connection_string", value)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary key used to create the authentication token.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter(name="registrationRead")
    def registration_read(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Adds `RegistrationStatusRead` permission to this Shared Access Account. It allows read access to device registrations.
        """
        return pulumi.get(self, "registration_read")

    @registration_read.setter
    def registration_read(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "registration_read", value)

    @property
    @pulumi.getter(name="registrationWrite")
    def registration_write(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Adds `RegistrationStatusWrite` permission to this Shared Access Account. It allows write access to device registrations.

        > **Note:** When `registration_write` is set to `true`, `registration_read` must also be set to true. This is a requirement of the Azure API.
        """
        return pulumi.get(self, "registration_write")

    @registration_write.setter
    def registration_write(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "registration_write", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group under which the IotHub Shared Access Policy resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secondary connection string of the Shared Access Policy.
        """
        return pulumi.get(self, "secondary_connection_string")

    @secondary_connection_string.setter
    def secondary_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_connection_string", value)

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secondary key used to create the authentication token.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_key", value)

    @property
    @pulumi.getter(name="serviceConfig")
    def service_config(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Adds `ServiceConfig` permission to this Shared Access Account. It allows configuration of the Device Provisioning Service.

        > **Note:** At least one of `registration_read`, `registration_write`, `service_config`, `enrollment_read`, `enrollment_write` permissions must be set to `true`.
        """
        return pulumi.get(self, "service_config")

    @service_config.setter
    def service_config(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "service_config", value)


@pulumi.type_token("azure:iot/dpsSharedAccessPolicy:DpsSharedAccessPolicy")
class DpsSharedAccessPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enrollment_read: Optional[pulumi.Input[builtins.bool]] = None,
                 enrollment_write: Optional[pulumi.Input[builtins.bool]] = None,
                 iothub_dps_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 registration_read: Optional[pulumi.Input[builtins.bool]] = None,
                 registration_write: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_config: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Manages an IotHub Device Provisioning Service Shared Access Policy

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_iot_hub_dps = azure.iot.IotHubDps("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "S1",
                "capacity": 1,
            })
        example_dps_shared_access_policy = azure.iot.DpsSharedAccessPolicy("example",
            name="example",
            resource_group_name=example.name,
            iothub_dps_name=example_iot_hub_dps.name,
            enrollment_write=True,
            enrollment_read=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Devices`: 2022-02-05

        ## Import

        IoTHub Device Provisioning Service Shared Access Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/dpsSharedAccessPolicy:DpsSharedAccessPolicy shared_access_policy1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/provisioningServices/dps1/keys/shared_access_policy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enrollment_read: Adds `EnrollmentRead` permission to this Shared Access Account. It allows read access to enrollment data.
               
               > **Note:** When `enrollment_read` is set to `true`, `registration_read` must also be set to true. This is a limitation of the Azure REST API
        :param pulumi.Input[builtins.bool] enrollment_write: Adds `EnrollmentWrite` permission to this Shared Access Account. It allows write access to enrollment data.
               
               > **Note:** When `registration_write` is set to `true`, `enrollment_read`, `registration_read`, and `registration_write` must also be set to true. This is a requirement of the Azure API.
        :param pulumi.Input[builtins.str] iothub_dps_name: The name of the IoT Hub Device Provisioning service to which this Shared Access Policy belongs. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the IotHub Shared Access Policy resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] registration_read: Adds `RegistrationStatusRead` permission to this Shared Access Account. It allows read access to device registrations.
        :param pulumi.Input[builtins.bool] registration_write: Adds `RegistrationStatusWrite` permission to this Shared Access Account. It allows write access to device registrations.
               
               > **Note:** When `registration_write` is set to `true`, `registration_read` must also be set to true. This is a requirement of the Azure API.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group under which the IotHub Shared Access Policy resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] service_config: Adds `ServiceConfig` permission to this Shared Access Account. It allows configuration of the Device Provisioning Service.
               
               > **Note:** At least one of `registration_read`, `registration_write`, `service_config`, `enrollment_read`, `enrollment_write` permissions must be set to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DpsSharedAccessPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IotHub Device Provisioning Service Shared Access Policy

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_iot_hub_dps = azure.iot.IotHubDps("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "S1",
                "capacity": 1,
            })
        example_dps_shared_access_policy = azure.iot.DpsSharedAccessPolicy("example",
            name="example",
            resource_group_name=example.name,
            iothub_dps_name=example_iot_hub_dps.name,
            enrollment_write=True,
            enrollment_read=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Devices`: 2022-02-05

        ## Import

        IoTHub Device Provisioning Service Shared Access Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/dpsSharedAccessPolicy:DpsSharedAccessPolicy shared_access_policy1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/provisioningServices/dps1/keys/shared_access_policy1
        ```

        :param str resource_name: The name of the resource.
        :param DpsSharedAccessPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DpsSharedAccessPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enrollment_read: Optional[pulumi.Input[builtins.bool]] = None,
                 enrollment_write: Optional[pulumi.Input[builtins.bool]] = None,
                 iothub_dps_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 registration_read: Optional[pulumi.Input[builtins.bool]] = None,
                 registration_write: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_config: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DpsSharedAccessPolicyArgs.__new__(DpsSharedAccessPolicyArgs)

            __props__.__dict__["enrollment_read"] = enrollment_read
            __props__.__dict__["enrollment_write"] = enrollment_write
            if iothub_dps_name is None and not opts.urn:
                raise TypeError("Missing required property 'iothub_dps_name'")
            __props__.__dict__["iothub_dps_name"] = iothub_dps_name
            __props__.__dict__["name"] = name
            __props__.__dict__["registration_read"] = registration_read
            __props__.__dict__["registration_write"] = registration_write
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["service_config"] = service_config
            __props__.__dict__["primary_connection_string"] = None
            __props__.__dict__["primary_key"] = None
            __props__.__dict__["secondary_connection_string"] = None
            __props__.__dict__["secondary_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryConnectionString", "primaryKey", "secondaryConnectionString", "secondaryKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DpsSharedAccessPolicy, __self__).__init__(
            'azure:iot/dpsSharedAccessPolicy:DpsSharedAccessPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enrollment_read: Optional[pulumi.Input[builtins.bool]] = None,
            enrollment_write: Optional[pulumi.Input[builtins.bool]] = None,
            iothub_dps_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            primary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            primary_key: Optional[pulumi.Input[builtins.str]] = None,
            registration_read: Optional[pulumi.Input[builtins.bool]] = None,
            registration_write: Optional[pulumi.Input[builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            secondary_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            secondary_key: Optional[pulumi.Input[builtins.str]] = None,
            service_config: Optional[pulumi.Input[builtins.bool]] = None) -> 'DpsSharedAccessPolicy':
        """
        Get an existing DpsSharedAccessPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enrollment_read: Adds `EnrollmentRead` permission to this Shared Access Account. It allows read access to enrollment data.
               
               > **Note:** When `enrollment_read` is set to `true`, `registration_read` must also be set to true. This is a limitation of the Azure REST API
        :param pulumi.Input[builtins.bool] enrollment_write: Adds `EnrollmentWrite` permission to this Shared Access Account. It allows write access to enrollment data.
               
               > **Note:** When `registration_write` is set to `true`, `enrollment_read`, `registration_read`, and `registration_write` must also be set to true. This is a requirement of the Azure API.
        :param pulumi.Input[builtins.str] iothub_dps_name: The name of the IoT Hub Device Provisioning service to which this Shared Access Policy belongs. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the IotHub Shared Access Policy resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] primary_connection_string: The primary connection string of the Shared Access Policy.
        :param pulumi.Input[builtins.str] primary_key: The primary key used to create the authentication token.
        :param pulumi.Input[builtins.bool] registration_read: Adds `RegistrationStatusRead` permission to this Shared Access Account. It allows read access to device registrations.
        :param pulumi.Input[builtins.bool] registration_write: Adds `RegistrationStatusWrite` permission to this Shared Access Account. It allows write access to device registrations.
               
               > **Note:** When `registration_write` is set to `true`, `registration_read` must also be set to true. This is a requirement of the Azure API.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group under which the IotHub Shared Access Policy resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] secondary_connection_string: The secondary connection string of the Shared Access Policy.
        :param pulumi.Input[builtins.str] secondary_key: The secondary key used to create the authentication token.
        :param pulumi.Input[builtins.bool] service_config: Adds `ServiceConfig` permission to this Shared Access Account. It allows configuration of the Device Provisioning Service.
               
               > **Note:** At least one of `registration_read`, `registration_write`, `service_config`, `enrollment_read`, `enrollment_write` permissions must be set to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DpsSharedAccessPolicyState.__new__(_DpsSharedAccessPolicyState)

        __props__.__dict__["enrollment_read"] = enrollment_read
        __props__.__dict__["enrollment_write"] = enrollment_write
        __props__.__dict__["iothub_dps_name"] = iothub_dps_name
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_connection_string"] = primary_connection_string
        __props__.__dict__["primary_key"] = primary_key
        __props__.__dict__["registration_read"] = registration_read
        __props__.__dict__["registration_write"] = registration_write
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secondary_connection_string"] = secondary_connection_string
        __props__.__dict__["secondary_key"] = secondary_key
        __props__.__dict__["service_config"] = service_config
        return DpsSharedAccessPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enrollmentRead")
    def enrollment_read(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Adds `EnrollmentRead` permission to this Shared Access Account. It allows read access to enrollment data.

        > **Note:** When `enrollment_read` is set to `true`, `registration_read` must also be set to true. This is a limitation of the Azure REST API
        """
        return pulumi.get(self, "enrollment_read")

    @property
    @pulumi.getter(name="enrollmentWrite")
    def enrollment_write(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Adds `EnrollmentWrite` permission to this Shared Access Account. It allows write access to enrollment data.

        > **Note:** When `registration_write` is set to `true`, `enrollment_read`, `registration_read`, and `registration_write` must also be set to true. This is a requirement of the Azure API.
        """
        return pulumi.get(self, "enrollment_write")

    @property
    @pulumi.getter(name="iothubDpsName")
    def iothub_dps_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the IoT Hub Device Provisioning service to which this Shared Access Policy belongs. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_dps_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the IotHub Shared Access Policy resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        The primary connection string of the Shared Access Policy.
        """
        return pulumi.get(self, "primary_connection_string")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> pulumi.Output[builtins.str]:
        """
        The primary key used to create the authentication token.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter(name="registrationRead")
    def registration_read(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Adds `RegistrationStatusRead` permission to this Shared Access Account. It allows read access to device registrations.
        """
        return pulumi.get(self, "registration_read")

    @property
    @pulumi.getter(name="registrationWrite")
    def registration_write(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Adds `RegistrationStatusWrite` permission to this Shared Access Account. It allows write access to device registrations.

        > **Note:** When `registration_write` is set to `true`, `registration_read` must also be set to true. This is a requirement of the Azure API.
        """
        return pulumi.get(self, "registration_write")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group under which the IotHub Shared Access Policy resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        The secondary connection string of the Shared Access Policy.
        """
        return pulumi.get(self, "secondary_connection_string")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> pulumi.Output[builtins.str]:
        """
        The secondary key used to create the authentication token.
        """
        return pulumi.get(self, "secondary_key")

    @property
    @pulumi.getter(name="serviceConfig")
    def service_config(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Adds `ServiceConfig` permission to this Shared Access Account. It allows configuration of the Device Provisioning Service.

        > **Note:** At least one of `registration_read`, `registration_write`, `service_config`, `enrollment_read`, `enrollment_write` permissions must be set to `true`.
        """
        return pulumi.get(self, "service_config")

