# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IotHubCertificateArgs', 'IotHubCertificate']

@pulumi.input_type
class IotHubCertificateArgs:
    def __init__(__self__, *,
                 certificate_content: pulumi.Input[builtins.str],
                 iot_dps_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 is_verified: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a IotHubCertificate resource.
        :param pulumi.Input[builtins.str] certificate_content: The Base-64 representation of the X509 leaf certificate .cer file or just a .pem file content.
        :param pulumi.Input[builtins.str] iot_dps_name: The name of the IoT Device Provisioning Service that this certificate will be attached to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group under which the Iot Device Provisioning Service Certificate resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] is_verified: Specifies if the certificate is created in verified state. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Iot Device Provisioning Service Certificate resource. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "certificate_content", certificate_content)
        pulumi.set(__self__, "iot_dps_name", iot_dps_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if is_verified is not None:
            pulumi.set(__self__, "is_verified", is_verified)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> pulumi.Input[builtins.str]:
        """
        The Base-64 representation of the X509 leaf certificate .cer file or just a .pem file content.
        """
        return pulumi.get(self, "certificate_content")

    @certificate_content.setter
    def certificate_content(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "certificate_content", value)

    @property
    @pulumi.getter(name="iotDpsName")
    def iot_dps_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the IoT Device Provisioning Service that this certificate will be attached to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iot_dps_name")

    @iot_dps_name.setter
    def iot_dps_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "iot_dps_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group under which the Iot Device Provisioning Service Certificate resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="isVerified")
    def is_verified(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the certificate is created in verified state. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "is_verified")

    @is_verified.setter
    def is_verified(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_verified", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Iot Device Provisioning Service Certificate resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _IotHubCertificateState:
    def __init__(__self__, *,
                 certificate_content: Optional[pulumi.Input[builtins.str]] = None,
                 iot_dps_name: Optional[pulumi.Input[builtins.str]] = None,
                 is_verified: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering IotHubCertificate resources.
        :param pulumi.Input[builtins.str] certificate_content: The Base-64 representation of the X509 leaf certificate .cer file or just a .pem file content.
        :param pulumi.Input[builtins.str] iot_dps_name: The name of the IoT Device Provisioning Service that this certificate will be attached to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] is_verified: Specifies if the certificate is created in verified state. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Iot Device Provisioning Service Certificate resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group under which the Iot Device Provisioning Service Certificate resource has to be created. Changing this forces a new resource to be created.
        """
        if certificate_content is not None:
            pulumi.set(__self__, "certificate_content", certificate_content)
        if iot_dps_name is not None:
            pulumi.set(__self__, "iot_dps_name", iot_dps_name)
        if is_verified is not None:
            pulumi.set(__self__, "is_verified", is_verified)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Base-64 representation of the X509 leaf certificate .cer file or just a .pem file content.
        """
        return pulumi.get(self, "certificate_content")

    @certificate_content.setter
    def certificate_content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_content", value)

    @property
    @pulumi.getter(name="iotDpsName")
    def iot_dps_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the IoT Device Provisioning Service that this certificate will be attached to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iot_dps_name")

    @iot_dps_name.setter
    def iot_dps_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iot_dps_name", value)

    @property
    @pulumi.getter(name="isVerified")
    def is_verified(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the certificate is created in verified state. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "is_verified")

    @is_verified.setter
    def is_verified(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_verified", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Iot Device Provisioning Service Certificate resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group under which the Iot Device Provisioning Service Certificate resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:iot/iotHubCertificate:IotHubCertificate")
class IotHubCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_content: Optional[pulumi.Input[builtins.str]] = None,
                 iot_dps_name: Optional[pulumi.Input[builtins.str]] = None,
                 is_verified: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an IotHub Device Provisioning Service Certificate.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_iot_hub_dps = azure.iot.IotHubDps("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "S1",
                "capacity": 1,
            })
        example_iot_hub_certificate = azure.iot.IotHubCertificate("example",
            name="example",
            resource_group_name=example.name,
            iot_dps_name=example_iot_hub_dps.name,
            certificate_content=std.filebase64(input="example.cer").result)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Devices`: 2022-02-05

        ## Import

        IoTHub Device Provisioning Service Certificates can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/iotHubCertificate:IotHubCertificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/provisioningServices/example/certificates/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] certificate_content: The Base-64 representation of the X509 leaf certificate .cer file or just a .pem file content.
        :param pulumi.Input[builtins.str] iot_dps_name: The name of the IoT Device Provisioning Service that this certificate will be attached to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] is_verified: Specifies if the certificate is created in verified state. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Iot Device Provisioning Service Certificate resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group under which the Iot Device Provisioning Service Certificate resource has to be created. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IotHubCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IotHub Device Provisioning Service Certificate.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_iot_hub_dps = azure.iot.IotHubDps("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "S1",
                "capacity": 1,
            })
        example_iot_hub_certificate = azure.iot.IotHubCertificate("example",
            name="example",
            resource_group_name=example.name,
            iot_dps_name=example_iot_hub_dps.name,
            certificate_content=std.filebase64(input="example.cer").result)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Devices`: 2022-02-05

        ## Import

        IoTHub Device Provisioning Service Certificates can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/iotHubCertificate:IotHubCertificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/provisioningServices/example/certificates/example
        ```

        :param str resource_name: The name of the resource.
        :param IotHubCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IotHubCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_content: Optional[pulumi.Input[builtins.str]] = None,
                 iot_dps_name: Optional[pulumi.Input[builtins.str]] = None,
                 is_verified: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IotHubCertificateArgs.__new__(IotHubCertificateArgs)

            if certificate_content is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_content'")
            __props__.__dict__["certificate_content"] = None if certificate_content is None else pulumi.Output.secret(certificate_content)
            if iot_dps_name is None and not opts.urn:
                raise TypeError("Missing required property 'iot_dps_name'")
            __props__.__dict__["iot_dps_name"] = iot_dps_name
            __props__.__dict__["is_verified"] = is_verified
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["certificateContent"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IotHubCertificate, __self__).__init__(
            'azure:iot/iotHubCertificate:IotHubCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_content: Optional[pulumi.Input[builtins.str]] = None,
            iot_dps_name: Optional[pulumi.Input[builtins.str]] = None,
            is_verified: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None) -> 'IotHubCertificate':
        """
        Get an existing IotHubCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] certificate_content: The Base-64 representation of the X509 leaf certificate .cer file or just a .pem file content.
        :param pulumi.Input[builtins.str] iot_dps_name: The name of the IoT Device Provisioning Service that this certificate will be attached to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] is_verified: Specifies if the certificate is created in verified state. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Iot Device Provisioning Service Certificate resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group under which the Iot Device Provisioning Service Certificate resource has to be created. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IotHubCertificateState.__new__(_IotHubCertificateState)

        __props__.__dict__["certificate_content"] = certificate_content
        __props__.__dict__["iot_dps_name"] = iot_dps_name
        __props__.__dict__["is_verified"] = is_verified
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        return IotHubCertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> pulumi.Output[builtins.str]:
        """
        The Base-64 representation of the X509 leaf certificate .cer file or just a .pem file content.
        """
        return pulumi.get(self, "certificate_content")

    @property
    @pulumi.getter(name="iotDpsName")
    def iot_dps_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the IoT Device Provisioning Service that this certificate will be attached to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iot_dps_name")

    @property
    @pulumi.getter(name="isVerified")
    def is_verified(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies if the certificate is created in verified state. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "is_verified")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Iot Device Provisioning Service Certificate resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group under which the Iot Device Provisioning Service Certificate resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

