# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IotHubDeviceUpdateInstanceArgs', 'IotHubDeviceUpdateInstance']

@pulumi.input_type
class IotHubDeviceUpdateInstanceArgs:
    def __init__(__self__, *,
                 device_update_account_id: pulumi.Input[builtins.str],
                 iothub_id: pulumi.Input[builtins.str],
                 diagnostic_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 diagnostic_storage_account: Optional[pulumi.Input['IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a IotHubDeviceUpdateInstance resource.
        :param pulumi.Input[builtins.str] device_update_account_id: Specifies the ID of the IoT Hub Device Update Account where the IoT Hub Device Update Instance exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] iothub_id: Specifies the ID of the IoT Hub associated with the IoT Hub Device Update Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] diagnostic_enabled: Whether the diagnostic log collection is enabled. Possible values are `true` and `false`. Defaults to `false`.
        :param pulumi.Input['IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs'] diagnostic_storage_account: A `diagnostic_storage_account` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this IoT Hub Device Update Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the IoT Hub Device Update Instance.
        """
        pulumi.set(__self__, "device_update_account_id", device_update_account_id)
        pulumi.set(__self__, "iothub_id", iothub_id)
        if diagnostic_enabled is not None:
            pulumi.set(__self__, "diagnostic_enabled", diagnostic_enabled)
        if diagnostic_storage_account is not None:
            pulumi.set(__self__, "diagnostic_storage_account", diagnostic_storage_account)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="deviceUpdateAccountId")
    def device_update_account_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of the IoT Hub Device Update Account where the IoT Hub Device Update Instance exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "device_update_account_id")

    @device_update_account_id.setter
    def device_update_account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "device_update_account_id", value)

    @property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of the IoT Hub associated with the IoT Hub Device Update Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_id")

    @iothub_id.setter
    def iothub_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "iothub_id", value)

    @property
    @pulumi.getter(name="diagnosticEnabled")
    def diagnostic_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the diagnostic log collection is enabled. Possible values are `true` and `false`. Defaults to `false`.
        """
        return pulumi.get(self, "diagnostic_enabled")

    @diagnostic_enabled.setter
    def diagnostic_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "diagnostic_enabled", value)

    @property
    @pulumi.getter(name="diagnosticStorageAccount")
    def diagnostic_storage_account(self) -> Optional[pulumi.Input['IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs']]:
        """
        A `diagnostic_storage_account` block as defined below.
        """
        return pulumi.get(self, "diagnostic_storage_account")

    @diagnostic_storage_account.setter
    def diagnostic_storage_account(self, value: Optional[pulumi.Input['IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs']]):
        pulumi.set(self, "diagnostic_storage_account", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this IoT Hub Device Update Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the IoT Hub Device Update Instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _IotHubDeviceUpdateInstanceState:
    def __init__(__self__, *,
                 device_update_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 diagnostic_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 diagnostic_storage_account: Optional[pulumi.Input['IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs']] = None,
                 iothub_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering IotHubDeviceUpdateInstance resources.
        :param pulumi.Input[builtins.str] device_update_account_id: Specifies the ID of the IoT Hub Device Update Account where the IoT Hub Device Update Instance exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] diagnostic_enabled: Whether the diagnostic log collection is enabled. Possible values are `true` and `false`. Defaults to `false`.
        :param pulumi.Input['IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs'] diagnostic_storage_account: A `diagnostic_storage_account` block as defined below.
        :param pulumi.Input[builtins.str] iothub_id: Specifies the ID of the IoT Hub associated with the IoT Hub Device Update Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this IoT Hub Device Update Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the IoT Hub Device Update Instance.
        """
        if device_update_account_id is not None:
            pulumi.set(__self__, "device_update_account_id", device_update_account_id)
        if diagnostic_enabled is not None:
            pulumi.set(__self__, "diagnostic_enabled", diagnostic_enabled)
        if diagnostic_storage_account is not None:
            pulumi.set(__self__, "diagnostic_storage_account", diagnostic_storage_account)
        if iothub_id is not None:
            pulumi.set(__self__, "iothub_id", iothub_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="deviceUpdateAccountId")
    def device_update_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the IoT Hub Device Update Account where the IoT Hub Device Update Instance exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "device_update_account_id")

    @device_update_account_id.setter
    def device_update_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "device_update_account_id", value)

    @property
    @pulumi.getter(name="diagnosticEnabled")
    def diagnostic_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the diagnostic log collection is enabled. Possible values are `true` and `false`. Defaults to `false`.
        """
        return pulumi.get(self, "diagnostic_enabled")

    @diagnostic_enabled.setter
    def diagnostic_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "diagnostic_enabled", value)

    @property
    @pulumi.getter(name="diagnosticStorageAccount")
    def diagnostic_storage_account(self) -> Optional[pulumi.Input['IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs']]:
        """
        A `diagnostic_storage_account` block as defined below.
        """
        return pulumi.get(self, "diagnostic_storage_account")

    @diagnostic_storage_account.setter
    def diagnostic_storage_account(self, value: Optional[pulumi.Input['IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs']]):
        pulumi.set(self, "diagnostic_storage_account", value)

    @property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the IoT Hub associated with the IoT Hub Device Update Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_id")

    @iothub_id.setter
    def iothub_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iothub_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this IoT Hub Device Update Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the IoT Hub Device Update Instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:iot/iotHubDeviceUpdateInstance:IotHubDeviceUpdateInstance")
class IotHubDeviceUpdateInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device_update_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 diagnostic_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 diagnostic_storage_account: Optional[pulumi.Input[Union['IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs', 'IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgsDict']]] = None,
                 iothub_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an IoT Hub Device Update Instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="East US")
        example_iot_hub_device_update_account = azure.iot.IotHubDeviceUpdateAccount("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_io_t_hub = azure.iot.IoTHub("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "S1",
                "capacity": 1,
            })
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_iot_hub_device_update_instance = azure.iot.IotHubDeviceUpdateInstance("example",
            name="example",
            device_update_account_id=example_iot_hub_device_update_account.id,
            iothub_id=example_io_t_hub.id,
            diagnostic_enabled=True,
            diagnostic_storage_account={
                "connection_string": example_account.primary_connection_string,
                "id": example_account.id,
            },
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DeviceUpdate`: 2022-10-01

        ## Import

        IoT Hub Device Update Instance can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/iotHubDeviceUpdateInstance:IotHubDeviceUpdateInstance example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.DeviceUpdate/accounts/account1/instances/instance1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] device_update_account_id: Specifies the ID of the IoT Hub Device Update Account where the IoT Hub Device Update Instance exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] diagnostic_enabled: Whether the diagnostic log collection is enabled. Possible values are `true` and `false`. Defaults to `false`.
        :param pulumi.Input[Union['IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs', 'IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgsDict']] diagnostic_storage_account: A `diagnostic_storage_account` block as defined below.
        :param pulumi.Input[builtins.str] iothub_id: Specifies the ID of the IoT Hub associated with the IoT Hub Device Update Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this IoT Hub Device Update Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the IoT Hub Device Update Instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IotHubDeviceUpdateInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IoT Hub Device Update Instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="East US")
        example_iot_hub_device_update_account = azure.iot.IotHubDeviceUpdateAccount("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_io_t_hub = azure.iot.IoTHub("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "S1",
                "capacity": 1,
            })
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_iot_hub_device_update_instance = azure.iot.IotHubDeviceUpdateInstance("example",
            name="example",
            device_update_account_id=example_iot_hub_device_update_account.id,
            iothub_id=example_io_t_hub.id,
            diagnostic_enabled=True,
            diagnostic_storage_account={
                "connection_string": example_account.primary_connection_string,
                "id": example_account.id,
            },
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DeviceUpdate`: 2022-10-01

        ## Import

        IoT Hub Device Update Instance can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/iotHubDeviceUpdateInstance:IotHubDeviceUpdateInstance example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.DeviceUpdate/accounts/account1/instances/instance1
        ```

        :param str resource_name: The name of the resource.
        :param IotHubDeviceUpdateInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IotHubDeviceUpdateInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device_update_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 diagnostic_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 diagnostic_storage_account: Optional[pulumi.Input[Union['IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs', 'IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgsDict']]] = None,
                 iothub_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IotHubDeviceUpdateInstanceArgs.__new__(IotHubDeviceUpdateInstanceArgs)

            if device_update_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'device_update_account_id'")
            __props__.__dict__["device_update_account_id"] = device_update_account_id
            __props__.__dict__["diagnostic_enabled"] = diagnostic_enabled
            __props__.__dict__["diagnostic_storage_account"] = diagnostic_storage_account
            if iothub_id is None and not opts.urn:
                raise TypeError("Missing required property 'iothub_id'")
            __props__.__dict__["iothub_id"] = iothub_id
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
        super(IotHubDeviceUpdateInstance, __self__).__init__(
            'azure:iot/iotHubDeviceUpdateInstance:IotHubDeviceUpdateInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            device_update_account_id: Optional[pulumi.Input[builtins.str]] = None,
            diagnostic_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            diagnostic_storage_account: Optional[pulumi.Input[Union['IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs', 'IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgsDict']]] = None,
            iothub_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'IotHubDeviceUpdateInstance':
        """
        Get an existing IotHubDeviceUpdateInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] device_update_account_id: Specifies the ID of the IoT Hub Device Update Account where the IoT Hub Device Update Instance exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] diagnostic_enabled: Whether the diagnostic log collection is enabled. Possible values are `true` and `false`. Defaults to `false`.
        :param pulumi.Input[Union['IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs', 'IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgsDict']] diagnostic_storage_account: A `diagnostic_storage_account` block as defined below.
        :param pulumi.Input[builtins.str] iothub_id: Specifies the ID of the IoT Hub associated with the IoT Hub Device Update Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this IoT Hub Device Update Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the IoT Hub Device Update Instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IotHubDeviceUpdateInstanceState.__new__(_IotHubDeviceUpdateInstanceState)

        __props__.__dict__["device_update_account_id"] = device_update_account_id
        __props__.__dict__["diagnostic_enabled"] = diagnostic_enabled
        __props__.__dict__["diagnostic_storage_account"] = diagnostic_storage_account
        __props__.__dict__["iothub_id"] = iothub_id
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        return IotHubDeviceUpdateInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deviceUpdateAccountId")
    def device_update_account_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ID of the IoT Hub Device Update Account where the IoT Hub Device Update Instance exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "device_update_account_id")

    @property
    @pulumi.getter(name="diagnosticEnabled")
    def diagnostic_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the diagnostic log collection is enabled. Possible values are `true` and `false`. Defaults to `false`.
        """
        return pulumi.get(self, "diagnostic_enabled")

    @property
    @pulumi.getter(name="diagnosticStorageAccount")
    def diagnostic_storage_account(self) -> pulumi.Output[Optional['outputs.IotHubDeviceUpdateInstanceDiagnosticStorageAccount']]:
        """
        A `diagnostic_storage_account` block as defined below.
        """
        return pulumi.get(self, "diagnostic_storage_account")

    @property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ID of the IoT Hub associated with the IoT Hub Device Update Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name which should be used for this IoT Hub Device Update Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the IoT Hub Device Update Instance.
        """
        return pulumi.get(self, "tags")

