# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'IoTHubCloudToDevice',
    'IoTHubCloudToDeviceFeedback',
    'IoTHubEndpoint',
    'IoTHubEnrichment',
    'IoTHubFallbackRoute',
    'IoTHubFileUpload',
    'IoTHubIdentity',
    'IoTHubNetworkRuleSet',
    'IoTHubNetworkRuleSetIpRule',
    'IoTHubRoute',
    'IoTHubSharedAccessPolicy',
    'IoTHubSku',
    'IotHubDeviceUpdateAccountIdentity',
    'IotHubDeviceUpdateInstanceDiagnosticStorageAccount',
    'IotHubDpsIpFilterRule',
    'IotHubDpsLinkedHub',
    'IotHubDpsSku',
    'SecurityDeviceGroupAllowRule',
    'SecurityDeviceGroupRangeRule',
    'SecuritySolutionAdditionalWorkspace',
    'SecuritySolutionRecommendationsEnabled',
    'GetIotHubIdentityResult',
]

@pulumi.output_type
class IoTHubCloudToDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "maxDeliveryCount":
            suggest = "max_delivery_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IoTHubCloudToDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IoTHubCloudToDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IoTHubCloudToDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_ttl: Optional[builtins.str] = None,
                 feedbacks: Optional[Sequence['outputs.IoTHubCloudToDeviceFeedback']] = None,
                 max_delivery_count: Optional[builtins.int] = None):
        """
        :param builtins.str default_ttl: The default time to live for cloud-to-device messages, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        :param Sequence['IoTHubCloudToDeviceFeedbackArgs'] feedbacks: A `feedback` block as defined below.
        :param builtins.int max_delivery_count: The maximum delivery count for cloud-to-device per-device queues. This value must be between `1` and `100`. Defaults to `10`.
        """
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if feedbacks is not None:
            pulumi.set(__self__, "feedbacks", feedbacks)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[builtins.str]:
        """
        The default time to live for cloud-to-device messages, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter
    def feedbacks(self) -> Optional[Sequence['outputs.IoTHubCloudToDeviceFeedback']]:
        """
        A `feedback` block as defined below.
        """
        return pulumi.get(self, "feedbacks")

    @property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[builtins.int]:
        """
        The maximum delivery count for cloud-to-device per-device queues. This value must be between `1` and `100`. Defaults to `10`.
        """
        return pulumi.get(self, "max_delivery_count")


@pulumi.output_type
class IoTHubCloudToDeviceFeedback(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lockDuration":
            suggest = "lock_duration"
        elif key == "maxDeliveryCount":
            suggest = "max_delivery_count"
        elif key == "timeToLive":
            suggest = "time_to_live"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IoTHubCloudToDeviceFeedback. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IoTHubCloudToDeviceFeedback.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IoTHubCloudToDeviceFeedback.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lock_duration: Optional[builtins.str] = None,
                 max_delivery_count: Optional[builtins.int] = None,
                 time_to_live: Optional[builtins.str] = None):
        """
        :param builtins.str lock_duration: The lock duration for the feedback queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT60S`.
        :param builtins.int max_delivery_count: The maximum delivery count for the feedback queue. This value must be between `1` and `100`. Defaults to `10`.
        :param builtins.str time_to_live: The retention time for service-bound feedback messages, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        """
        if lock_duration is not None:
            pulumi.set(__self__, "lock_duration", lock_duration)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        if time_to_live is not None:
            pulumi.set(__self__, "time_to_live", time_to_live)

    @property
    @pulumi.getter(name="lockDuration")
    def lock_duration(self) -> Optional[builtins.str]:
        """
        The lock duration for the feedback queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT60S`.
        """
        return pulumi.get(self, "lock_duration")

    @property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[builtins.int]:
        """
        The maximum delivery count for the feedback queue. This value must be between `1` and `100`. Defaults to `10`.
        """
        return pulumi.get(self, "max_delivery_count")

    @property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> Optional[builtins.str]:
        """
        The retention time for service-bound feedback messages, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        """
        return pulumi.get(self, "time_to_live")


@pulumi.output_type
class IoTHubEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "batchFrequencyInSeconds":
            suggest = "batch_frequency_in_seconds"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "endpointUri":
            suggest = "endpoint_uri"
        elif key == "entityPath":
            suggest = "entity_path"
        elif key == "fileNameFormat":
            suggest = "file_name_format"
        elif key == "identityId":
            suggest = "identity_id"
        elif key == "maxChunkSizeInBytes":
            suggest = "max_chunk_size_in_bytes"
        elif key == "resourceGroupName":
            suggest = "resource_group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IoTHubEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IoTHubEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IoTHubEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 type: builtins.str,
                 authentication_type: Optional[builtins.str] = None,
                 batch_frequency_in_seconds: Optional[builtins.int] = None,
                 connection_string: Optional[builtins.str] = None,
                 container_name: Optional[builtins.str] = None,
                 encoding: Optional[builtins.str] = None,
                 endpoint_uri: Optional[builtins.str] = None,
                 entity_path: Optional[builtins.str] = None,
                 file_name_format: Optional[builtins.str] = None,
                 identity_id: Optional[builtins.str] = None,
                 max_chunk_size_in_bytes: Optional[builtins.int] = None,
                 resource_group_name: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`.
        :param builtins.str type: The type of the endpoint. Possible values are `AzureIotHub.StorageContainer`, `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        :param builtins.str authentication_type: The type used to authenticate against the endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param builtins.int batch_frequency_in_seconds: Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`.
        :param builtins.str connection_string: The connection string for the endpoint. This attribute is mandatory and can only be specified when `authentication_type` is `keyBased`.
        :param builtins.str container_name: The name of storage container in the storage account. This attribute is mandatory for endpoint type `AzureIotHub.StorageContainer`.
        :param builtins.str encoding: Encoding that is used to serialize messages to blobs. Supported values are `Avro`, `AvroDeflate` and `JSON`. Default value is `Avro`. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`. Changing this forces a new resource to be created.
        :param builtins.str endpoint_uri: URI of the Service Bus or Event Hubs Namespace endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased` for endpoint type `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        :param builtins.str entity_path: Name of the Service Bus Queue/Topic or Event Hub. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased` for endpoint type `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        :param builtins.str file_name_format: File name format for the blob. All parameters are mandatory but can be reordered. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`. Defaults to `{iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}`.
        :param builtins.str identity_id: The ID of the User Managed Identity used to authenticate against the endpoint.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.
               
               > **Note:** An IoT Hub can only be updated to use the System-Assigned Managed Identity for `endpoint` since it is not possible to grant access to the endpoint until after creation. The extracted resources `azurerm_iothub_endpoint_*` can be used to configure Endpoints with the IoT Hub's System-Assigned Managed Identity without the need for an update.
        :param builtins.int max_chunk_size_in_bytes: Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB). This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`.
        :param builtins.str resource_group_name: The resource group in which the endpoint will be created.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if batch_frequency_in_seconds is not None:
            pulumi.set(__self__, "batch_frequency_in_seconds", batch_frequency_in_seconds)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if entity_path is not None:
            pulumi.set(__self__, "entity_path", entity_path)
        if file_name_format is not None:
            pulumi.set(__self__, "file_name_format", file_name_format)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if max_chunk_size_in_bytes is not None:
            pulumi.set(__self__, "max_chunk_size_in_bytes", max_chunk_size_in_bytes)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the endpoint. Possible values are `AzureIotHub.StorageContainer`, `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[builtins.str]:
        """
        The type used to authenticate against the endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="batchFrequencyInSeconds")
    def batch_frequency_in_seconds(self) -> Optional[builtins.int]:
        """
        Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`.
        """
        return pulumi.get(self, "batch_frequency_in_seconds")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[builtins.str]:
        """
        The connection string for the endpoint. This attribute is mandatory and can only be specified when `authentication_type` is `keyBased`.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[builtins.str]:
        """
        The name of storage container in the storage account. This attribute is mandatory for endpoint type `AzureIotHub.StorageContainer`.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[builtins.str]:
        """
        Encoding that is used to serialize messages to blobs. Supported values are `Avro`, `AvroDeflate` and `JSON`. Default value is `Avro`. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[builtins.str]:
        """
        URI of the Service Bus or Event Hubs Namespace endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased` for endpoint type `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="entityPath")
    def entity_path(self) -> Optional[builtins.str]:
        """
        Name of the Service Bus Queue/Topic or Event Hub. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased` for endpoint type `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        """
        return pulumi.get(self, "entity_path")

    @property
    @pulumi.getter(name="fileNameFormat")
    def file_name_format(self) -> Optional[builtins.str]:
        """
        File name format for the blob. All parameters are mandatory but can be reordered. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`. Defaults to `{iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}`.
        """
        return pulumi.get(self, "file_name_format")

    @property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[builtins.str]:
        """
        The ID of the User Managed Identity used to authenticate against the endpoint.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.

        > **Note:** An IoT Hub can only be updated to use the System-Assigned Managed Identity for `endpoint` since it is not possible to grant access to the endpoint until after creation. The extracted resources `azurerm_iothub_endpoint_*` can be used to configure Endpoints with the IoT Hub's System-Assigned Managed Identity without the need for an update.
        """
        return pulumi.get(self, "identity_id")

    @property
    @pulumi.getter(name="maxChunkSizeInBytes")
    def max_chunk_size_in_bytes(self) -> Optional[builtins.int]:
        """
        Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB). This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`.
        """
        return pulumi.get(self, "max_chunk_size_in_bytes")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[builtins.str]:
        """
        The resource group in which the endpoint will be created.
        """
        return pulumi.get(self, "resource_group_name")


@pulumi.output_type
class IoTHubEnrichment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointNames":
            suggest = "endpoint_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IoTHubEnrichment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IoTHubEnrichment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IoTHubEnrichment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_names: Sequence[builtins.str],
                 key: builtins.str,
                 value: builtins.str):
        """
        :param Sequence[builtins.str] endpoint_names: The list of endpoints which will be enriched.
        :param builtins.str key: The key of the enrichment.
        :param builtins.str value: The value of the enrichment. Value can be any static string, the name of the IoT Hub sending the message (use `$iothubname`) or information from the device twin (ex: `$twin.tags.latitude`)
        """
        pulumi.set(__self__, "endpoint_names", endpoint_names)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> Sequence[builtins.str]:
        """
        The list of endpoints which will be enriched.
        """
        return pulumi.get(self, "endpoint_names")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the enrichment.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the enrichment. Value can be any static string, the name of the IoT Hub sending the message (use `$iothubname`) or information from the device twin (ex: `$twin.tags.latitude`)
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class IoTHubFallbackRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointNames":
            suggest = "endpoint_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IoTHubFallbackRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IoTHubFallbackRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IoTHubFallbackRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: Optional[builtins.str] = None,
                 enabled: Optional[builtins.bool] = None,
                 endpoint_names: Optional[Sequence[builtins.str]] = None,
                 source: Optional[builtins.str] = None):
        """
        :param builtins.str condition: The condition that is evaluated to apply the routing rule. Defaults to `true`. For grammar, see: <https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language>.
        :param builtins.bool enabled: Used to specify whether the fallback route is enabled. Defaults to `true`.
        :param Sequence[builtins.str] endpoint_names: The endpoints to which messages that satisfy the condition are routed. Currently only 1 endpoint is allowed.
        :param builtins.str source: The source that the routing rule is to be applied to, such as `DeviceMessages`. Possible values include: `Invalid`, `DeviceMessages`, `TwinChangeEvents`, `DeviceLifecycleEvents`, `DeviceConnectionStateEvents`, `DeviceJobLifecycleEvents` and `DigitalTwinChangeEvents`. Defaults to `DeviceMessages`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if endpoint_names is not None:
            pulumi.set(__self__, "endpoint_names", endpoint_names)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def condition(self) -> Optional[builtins.str]:
        """
        The condition that is evaluated to apply the routing rule. Defaults to `true`. For grammar, see: <https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language>.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Used to specify whether the fallback route is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> Optional[Sequence[builtins.str]]:
        """
        The endpoints to which messages that satisfy the condition are routed. Currently only 1 endpoint is allowed.
        """
        return pulumi.get(self, "endpoint_names")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        The source that the routing rule is to be applied to, such as `DeviceMessages`. Possible values include: `Invalid`, `DeviceMessages`, `TwinChangeEvents`, `DeviceLifecycleEvents`, `DeviceConnectionStateEvents`, `DeviceJobLifecycleEvents` and `DigitalTwinChangeEvents`. Defaults to `DeviceMessages`.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class IoTHubFileUpload(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "identityId":
            suggest = "identity_id"
        elif key == "lockDuration":
            suggest = "lock_duration"
        elif key == "maxDeliveryCount":
            suggest = "max_delivery_count"
        elif key == "sasTtl":
            suggest = "sas_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IoTHubFileUpload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IoTHubFileUpload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IoTHubFileUpload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: builtins.str,
                 container_name: builtins.str,
                 authentication_type: Optional[builtins.str] = None,
                 default_ttl: Optional[builtins.str] = None,
                 identity_id: Optional[builtins.str] = None,
                 lock_duration: Optional[builtins.str] = None,
                 max_delivery_count: Optional[builtins.int] = None,
                 notifications: Optional[builtins.bool] = None,
                 sas_ttl: Optional[builtins.str] = None):
        """
        :param builtins.str connection_string: The connection string for the Azure Storage account to which files are uploaded.
        :param builtins.str container_name: The name of the root container where the files should be uploaded to. The container need not exist but should be creatable using the connection_string specified.
        :param builtins.str authentication_type: The type used to authenticate against the storage account. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param builtins.str default_ttl: The period of time for which a file upload notification message is available to consume before it expires, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        :param builtins.str identity_id: The ID of the User Managed Identity used to authenticate against the storage account.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.
               
               > **Note:** An IoT Hub can only be updated to use the System-Assigned Managed Identity for `file_upload` since it is not possible to grant access to the endpoint until after creation.
        :param builtins.str lock_duration: The lock duration for the file upload notifications queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT1M`.
        :param builtins.int max_delivery_count: The number of times the IoT Hub attempts to deliver a file upload notification message. Defaults to `10`.
        :param builtins.bool notifications: Used to specify whether file notifications are sent to IoT Hub on upload. Defaults to `false`.
        :param builtins.str sas_ttl: The period of time for which the SAS URI generated by IoT Hub for file upload is valid, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 24 hours. Defaults to `PT1H`.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "container_name", container_name)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if lock_duration is not None:
            pulumi.set(__self__, "lock_duration", lock_duration)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if sas_ttl is not None:
            pulumi.set(__self__, "sas_ttl", sas_ttl)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> builtins.str:
        """
        The connection string for the Azure Storage account to which files are uploaded.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> builtins.str:
        """
        The name of the root container where the files should be uploaded to. The container need not exist but should be creatable using the connection_string specified.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[builtins.str]:
        """
        The type used to authenticate against the storage account. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[builtins.str]:
        """
        The period of time for which a file upload notification message is available to consume before it expires, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[builtins.str]:
        """
        The ID of the User Managed Identity used to authenticate against the storage account.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.

        > **Note:** An IoT Hub can only be updated to use the System-Assigned Managed Identity for `file_upload` since it is not possible to grant access to the endpoint until after creation.
        """
        return pulumi.get(self, "identity_id")

    @property
    @pulumi.getter(name="lockDuration")
    def lock_duration(self) -> Optional[builtins.str]:
        """
        The lock duration for the file upload notifications queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT1M`.
        """
        return pulumi.get(self, "lock_duration")

    @property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[builtins.int]:
        """
        The number of times the IoT Hub attempts to deliver a file upload notification message. Defaults to `10`.
        """
        return pulumi.get(self, "max_delivery_count")

    @property
    @pulumi.getter
    def notifications(self) -> Optional[builtins.bool]:
        """
        Used to specify whether file notifications are sent to IoT Hub on upload. Defaults to `false`.
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter(name="sasTtl")
    def sas_ttl(self) -> Optional[builtins.str]:
        """
        The period of time for which the SAS URI generated by IoT Hub for file upload is valid, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 24 hours. Defaults to `PT1H`.
        """
        return pulumi.get(self, "sas_ttl")


@pulumi.output_type
class IoTHubIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IoTHubIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IoTHubIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IoTHubIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this IoT Hub. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this IoT Hub.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this IoT Hub. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this IoT Hub.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class IoTHubNetworkRuleSet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyToBuiltinEventhubEndpoint":
            suggest = "apply_to_builtin_eventhub_endpoint"
        elif key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IoTHubNetworkRuleSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IoTHubNetworkRuleSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IoTHubNetworkRuleSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_to_builtin_eventhub_endpoint: Optional[builtins.bool] = None,
                 default_action: Optional[builtins.str] = None,
                 ip_rules: Optional[Sequence['outputs.IoTHubNetworkRuleSetIpRule']] = None):
        """
        :param builtins.bool apply_to_builtin_eventhub_endpoint: Determines if Network Rule Set is also applied to the BuiltIn EventHub EndPoint of the IotHub. Defaults to `false`.
        :param builtins.str default_action: Default Action for Network Rule Set. Possible values are `DefaultActionDeny`, `DefaultActionAllow`. Defaults to `DefaultActionDeny`.
        :param Sequence['IoTHubNetworkRuleSetIpRuleArgs'] ip_rules: One or more `ip_rule` blocks as defined below.
        """
        if apply_to_builtin_eventhub_endpoint is not None:
            pulumi.set(__self__, "apply_to_builtin_eventhub_endpoint", apply_to_builtin_eventhub_endpoint)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)

    @property
    @pulumi.getter(name="applyToBuiltinEventhubEndpoint")
    def apply_to_builtin_eventhub_endpoint(self) -> Optional[builtins.bool]:
        """
        Determines if Network Rule Set is also applied to the BuiltIn EventHub EndPoint of the IotHub. Defaults to `false`.
        """
        return pulumi.get(self, "apply_to_builtin_eventhub_endpoint")

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[builtins.str]:
        """
        Default Action for Network Rule Set. Possible values are `DefaultActionDeny`, `DefaultActionAllow`. Defaults to `DefaultActionDeny`.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence['outputs.IoTHubNetworkRuleSetIpRule']]:
        """
        One or more `ip_rule` blocks as defined below.
        """
        return pulumi.get(self, "ip_rules")


@pulumi.output_type
class IoTHubNetworkRuleSetIpRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IoTHubNetworkRuleSetIpRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IoTHubNetworkRuleSetIpRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IoTHubNetworkRuleSetIpRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_mask: builtins.str,
                 name: builtins.str,
                 action: Optional[builtins.str] = None):
        """
        :param builtins.str ip_mask: The IP address range in CIDR notation for the ip rule.
        :param builtins.str name: The name of the ip rule.
        :param builtins.str action: The desired action for requests captured by this rule. Possible values are `Allow`. Defaults to `Allow`.
        """
        pulumi.set(__self__, "ip_mask", ip_mask)
        pulumi.set(__self__, "name", name)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> builtins.str:
        """
        The IP address range in CIDR notation for the ip rule.
        """
        return pulumi.get(self, "ip_mask")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the ip rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def action(self) -> Optional[builtins.str]:
        """
        The desired action for requests captured by this rule. Possible values are `Allow`. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class IoTHubRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointNames":
            suggest = "endpoint_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IoTHubRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IoTHubRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IoTHubRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 endpoint_names: Sequence[builtins.str],
                 name: builtins.str,
                 source: builtins.str,
                 condition: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Used to specify whether a route is enabled.
        :param Sequence[builtins.str] endpoint_names: The list of endpoints to which messages that satisfy the condition are routed.
        :param builtins.str name: The name of the route.
        :param builtins.str source: The source that the routing rule is to be applied to, such as `DeviceMessages`. Possible values include: `Invalid`, `DeviceMessages`, `TwinChangeEvents`, `DeviceLifecycleEvents`, `DeviceConnectionStateEvents`, `DeviceJobLifecycleEvents` and `DigitalTwinChangeEvents`.
        :param builtins.str condition: The condition that is evaluated to apply the routing rule. Defaults to `true`. For grammar, see: <https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language>.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "endpoint_names", endpoint_names)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Used to specify whether a route is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> Sequence[builtins.str]:
        """
        The list of endpoints to which messages that satisfy the condition are routed.
        """
        return pulumi.get(self, "endpoint_names")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the route.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        """
        The source that the routing rule is to be applied to, such as `DeviceMessages`. Possible values include: `Invalid`, `DeviceMessages`, `TwinChangeEvents`, `DeviceLifecycleEvents`, `DeviceConnectionStateEvents`, `DeviceJobLifecycleEvents` and `DigitalTwinChangeEvents`.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def condition(self) -> Optional[builtins.str]:
        """
        The condition that is evaluated to apply the routing rule. Defaults to `true`. For grammar, see: <https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language>.
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class IoTHubSharedAccessPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"
        elif key == "primaryKey":
            suggest = "primary_key"
        elif key == "secondaryKey":
            suggest = "secondary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IoTHubSharedAccessPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IoTHubSharedAccessPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IoTHubSharedAccessPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: Optional[builtins.str] = None,
                 permissions: Optional[builtins.str] = None,
                 primary_key: Optional[builtins.str] = None,
                 secondary_key: Optional[builtins.str] = None):
        """
        :param builtins.str key_name: The name of the shared access policy.
        :param builtins.str permissions: The permissions assigned to the shared access policy.
        :param builtins.str primary_key: The primary key.
        :param builtins.str secondary_key: The secondary key.
        """
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[builtins.str]:
        """
        The name of the shared access policy.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[builtins.str]:
        """
        The permissions assigned to the shared access policy.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[builtins.str]:
        """
        The primary key.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[builtins.str]:
        """
        The secondary key.
        """
        return pulumi.get(self, "secondary_key")


@pulumi.output_type
class IoTHubSku(dict):
    def __init__(__self__, *,
                 capacity: builtins.int,
                 name: builtins.str):
        """
        :param builtins.int capacity: The number of provisioned IoT Hub units.
               
               > **Note:** Only one IotHub can be on the `Free` tier per subscription.
        :param builtins.str name: The name of the sku. Possible values are `B1`, `B2`, `B3`, `F1`, `S1`, `S2`, and `S3`.
               
               > **Note:** The `F1` sku is on `Free` tier.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def capacity(self) -> builtins.int:
        """
        The number of provisioned IoT Hub units.

        > **Note:** Only one IotHub can be on the `Free` tier per subscription.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the sku. Possible values are `B1`, `B2`, `B3`, `F1`, `S1`, `S2`, and `S3`.

        > **Note:** The `F1` sku is on `Free` tier.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class IotHubDeviceUpdateAccountIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotHubDeviceUpdateAccountIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotHubDeviceUpdateAccountIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotHubDeviceUpdateAccountIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this IoT Hub Device Update Account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[builtins.str] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this IoT Hub Device Update Account.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param builtins.str principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this IoT Hub Device Update Account.
        :param builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this IoT Hub Device Update Account.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this IoT Hub Device Update Account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this IoT Hub Device Update Account.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this IoT Hub Device Update Account.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this IoT Hub Device Update Account.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class IotHubDeviceUpdateInstanceDiagnosticStorageAccount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotHubDeviceUpdateInstanceDiagnosticStorageAccount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotHubDeviceUpdateInstanceDiagnosticStorageAccount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotHubDeviceUpdateInstanceDiagnosticStorageAccount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: builtins.str,
                 id: builtins.str):
        """
        :param builtins.str connection_string: Connection String of the Diagnostic Storage Account.
        :param builtins.str id: Resource ID of the Diagnostic Storage Account.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> builtins.str:
        """
        Connection String of the Diagnostic Storage Account.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Resource ID of the Diagnostic Storage Account.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class IotHubDpsIpFilterRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotHubDpsIpFilterRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotHubDpsIpFilterRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotHubDpsIpFilterRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: builtins.str,
                 ip_mask: builtins.str,
                 name: builtins.str,
                 target: Optional[builtins.str] = None):
        """
        :param builtins.str action: The desired action for requests captured by this rule. Possible values are `Accept`, `Reject`
        :param builtins.str ip_mask: The IP address range in CIDR notation for the rule.
        :param builtins.str name: The name of the filter.
        :param builtins.str target: Target for requests captured by this rule. Possible values are `all`, `deviceApi` and `serviceApi`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip_mask", ip_mask)
        pulumi.set(__self__, "name", name)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        The desired action for requests captured by this rule. Possible values are `Accept`, `Reject`
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> builtins.str:
        """
        The IP address range in CIDR notation for the rule.
        """
        return pulumi.get(self, "ip_mask")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the filter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.str]:
        """
        Target for requests captured by this rule. Possible values are `all`, `deviceApi` and `serviceApi`.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class IotHubDpsLinkedHub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "allocationWeight":
            suggest = "allocation_weight"
        elif key == "applyAllocationPolicy":
            suggest = "apply_allocation_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotHubDpsLinkedHub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotHubDpsLinkedHub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotHubDpsLinkedHub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: builtins.str,
                 location: builtins.str,
                 allocation_weight: Optional[builtins.int] = None,
                 apply_allocation_policy: Optional[builtins.bool] = None,
                 hostname: Optional[builtins.str] = None):
        """
        :param builtins.str connection_string: The connection string to connect to the IoT Hub.
        :param builtins.str location: The location of the IoT hub.
        :param builtins.int allocation_weight: The weight applied to the IoT Hub. Defaults to `1`.
        :param builtins.bool apply_allocation_policy: Determines whether to apply allocation policies to the IoT Hub. Defaults to `true`.
        :param builtins.str hostname: The IoT Hub hostname.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "location", location)
        if allocation_weight is not None:
            pulumi.set(__self__, "allocation_weight", allocation_weight)
        if apply_allocation_policy is not None:
            pulumi.set(__self__, "apply_allocation_policy", apply_allocation_policy)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> builtins.str:
        """
        The connection string to connect to the IoT Hub.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location of the IoT hub.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="allocationWeight")
    def allocation_weight(self) -> Optional[builtins.int]:
        """
        The weight applied to the IoT Hub. Defaults to `1`.
        """
        return pulumi.get(self, "allocation_weight")

    @property
    @pulumi.getter(name="applyAllocationPolicy")
    def apply_allocation_policy(self) -> Optional[builtins.bool]:
        """
        Determines whether to apply allocation policies to the IoT Hub. Defaults to `true`.
        """
        return pulumi.get(self, "apply_allocation_policy")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[builtins.str]:
        """
        The IoT Hub hostname.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class IotHubDpsSku(dict):
    def __init__(__self__, *,
                 capacity: builtins.int,
                 name: builtins.str):
        """
        :param builtins.int capacity: The number of provisioned IoT Device Provisioning Service units.
        :param builtins.str name: The name of the sku. Currently can only be set to `S1`.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def capacity(self) -> builtins.int:
        """
        The number of provisioned IoT Device Provisioning Service units.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the sku. Currently can only be set to `S1`.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SecurityDeviceGroupAllowRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionFromIpsNotAlloweds":
            suggest = "connection_from_ips_not_alloweds"
        elif key == "connectionToIpsNotAlloweds":
            suggest = "connection_to_ips_not_alloweds"
        elif key == "localUsersNotAlloweds":
            suggest = "local_users_not_alloweds"
        elif key == "processesNotAlloweds":
            suggest = "processes_not_alloweds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityDeviceGroupAllowRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityDeviceGroupAllowRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityDeviceGroupAllowRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_from_ips_not_alloweds: Optional[Sequence[builtins.str]] = None,
                 connection_to_ips_not_alloweds: Optional[Sequence[builtins.str]] = None,
                 local_users_not_alloweds: Optional[Sequence[builtins.str]] = None,
                 processes_not_alloweds: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] connection_from_ips_not_alloweds: Specifies which IP is not allowed to be connected to in current device group for inbound connection.
        :param Sequence[builtins.str] connection_to_ips_not_alloweds: Specifies which IP is not allowed to be connected to in current device group for outbound connection.
        :param Sequence[builtins.str] local_users_not_alloweds: Specifies which local user is not allowed to login in current device group.
        :param Sequence[builtins.str] processes_not_alloweds: Specifies which process is not allowed to be executed in current device group.
        """
        if connection_from_ips_not_alloweds is not None:
            pulumi.set(__self__, "connection_from_ips_not_alloweds", connection_from_ips_not_alloweds)
        if connection_to_ips_not_alloweds is not None:
            pulumi.set(__self__, "connection_to_ips_not_alloweds", connection_to_ips_not_alloweds)
        if local_users_not_alloweds is not None:
            pulumi.set(__self__, "local_users_not_alloweds", local_users_not_alloweds)
        if processes_not_alloweds is not None:
            pulumi.set(__self__, "processes_not_alloweds", processes_not_alloweds)

    @property
    @pulumi.getter(name="connectionFromIpsNotAlloweds")
    def connection_from_ips_not_alloweds(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies which IP is not allowed to be connected to in current device group for inbound connection.
        """
        return pulumi.get(self, "connection_from_ips_not_alloweds")

    @property
    @pulumi.getter(name="connectionToIpsNotAlloweds")
    def connection_to_ips_not_alloweds(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies which IP is not allowed to be connected to in current device group for outbound connection.
        """
        return pulumi.get(self, "connection_to_ips_not_alloweds")

    @property
    @pulumi.getter(name="localUsersNotAlloweds")
    def local_users_not_alloweds(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies which local user is not allowed to login in current device group.
        """
        return pulumi.get(self, "local_users_not_alloweds")

    @property
    @pulumi.getter(name="processesNotAlloweds")
    def processes_not_alloweds(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies which process is not allowed to be executed in current device group.
        """
        return pulumi.get(self, "processes_not_alloweds")


@pulumi.output_type
class SecurityDeviceGroupRangeRule(dict):
    def __init__(__self__, *,
                 duration: builtins.str,
                 max: builtins.int,
                 min: builtins.int,
                 type: builtins.str):
        """
        :param builtins.str duration: Specifies the time range. represented in ISO 8601 duration format.
        :param builtins.int max: The maximum threshold in the given time window.
        :param builtins.int min: The minimum threshold in the given time window.
        :param builtins.str type: The type of supported rule type. Possible Values are `ActiveConnectionsNotInAllowedRange`, `AmqpC2DMessagesNotInAllowedRange`, `MqttC2DMessagesNotInAllowedRange`, `HttpC2DMessagesNotInAllowedRange`, `AmqpC2DRejectedMessagesNotInAllowedRange`, `MqttC2DRejectedMessagesNotInAllowedRange`, `HttpC2DRejectedMessagesNotInAllowedRange`, `AmqpD2CMessagesNotInAllowedRange`, `MqttD2CMessagesNotInAllowedRange`, `HttpD2CMessagesNotInAllowedRange`, `DirectMethodInvokesNotInAllowedRange`, `FailedLocalLoginsNotInAllowedRange`, `FileUploadsNotInAllowedRange`, `QueuePurgesNotInAllowedRange`, `TwinUpdatesNotInAllowedRange` and `UnauthorizedOperationsNotInAllowedRange`.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def duration(self) -> builtins.str:
        """
        Specifies the time range. represented in ISO 8601 duration format.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def max(self) -> builtins.int:
        """
        The maximum threshold in the given time window.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> builtins.int:
        """
        The minimum threshold in the given time window.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of supported rule type. Possible Values are `ActiveConnectionsNotInAllowedRange`, `AmqpC2DMessagesNotInAllowedRange`, `MqttC2DMessagesNotInAllowedRange`, `HttpC2DMessagesNotInAllowedRange`, `AmqpC2DRejectedMessagesNotInAllowedRange`, `MqttC2DRejectedMessagesNotInAllowedRange`, `HttpC2DRejectedMessagesNotInAllowedRange`, `AmqpD2CMessagesNotInAllowedRange`, `MqttD2CMessagesNotInAllowedRange`, `HttpD2CMessagesNotInAllowedRange`, `DirectMethodInvokesNotInAllowedRange`, `FailedLocalLoginsNotInAllowedRange`, `FileUploadsNotInAllowedRange`, `QueuePurgesNotInAllowedRange`, `TwinUpdatesNotInAllowedRange` and `UnauthorizedOperationsNotInAllowedRange`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SecuritySolutionAdditionalWorkspace(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataTypes":
            suggest = "data_types"
        elif key == "workspaceId":
            suggest = "workspace_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecuritySolutionAdditionalWorkspace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecuritySolutionAdditionalWorkspace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecuritySolutionAdditionalWorkspace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_types: Sequence[builtins.str],
                 workspace_id: builtins.str):
        """
        :param Sequence[builtins.str] data_types: A list of data types which sent to workspace. Possible values are `Alerts` and `RawEvents`.
        :param builtins.str workspace_id: The resource ID of the Log Analytics Workspace.
        """
        pulumi.set(__self__, "data_types", data_types)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="dataTypes")
    def data_types(self) -> Sequence[builtins.str]:
        """
        A list of data types which sent to workspace. Possible values are `Alerts` and `RawEvents`.
        """
        return pulumi.get(self, "data_types")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> builtins.str:
        """
        The resource ID of the Log Analytics Workspace.
        """
        return pulumi.get(self, "workspace_id")


@pulumi.output_type
class SecuritySolutionRecommendationsEnabled(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acrAuthentication":
            suggest = "acr_authentication"
        elif key == "agentSendUnutilizedMsg":
            suggest = "agent_send_unutilized_msg"
        elif key == "edgeHubMemOptimize":
            suggest = "edge_hub_mem_optimize"
        elif key == "edgeLoggingOption":
            suggest = "edge_logging_option"
        elif key == "inconsistentModuleSettings":
            suggest = "inconsistent_module_settings"
        elif key == "installAgent":
            suggest = "install_agent"
        elif key == "ipFilterDenyAll":
            suggest = "ip_filter_deny_all"
        elif key == "ipFilterPermissiveRule":
            suggest = "ip_filter_permissive_rule"
        elif key == "openPorts":
            suggest = "open_ports"
        elif key == "permissiveFirewallPolicy":
            suggest = "permissive_firewall_policy"
        elif key == "permissiveInputFirewallRules":
            suggest = "permissive_input_firewall_rules"
        elif key == "permissiveOutputFirewallRules":
            suggest = "permissive_output_firewall_rules"
        elif key == "privilegedDockerOptions":
            suggest = "privileged_docker_options"
        elif key == "sharedCredentials":
            suggest = "shared_credentials"
        elif key == "vulnerableTlsCipherSuite":
            suggest = "vulnerable_tls_cipher_suite"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecuritySolutionRecommendationsEnabled. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecuritySolutionRecommendationsEnabled.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecuritySolutionRecommendationsEnabled.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acr_authentication: Optional[builtins.bool] = None,
                 agent_send_unutilized_msg: Optional[builtins.bool] = None,
                 baseline: Optional[builtins.bool] = None,
                 edge_hub_mem_optimize: Optional[builtins.bool] = None,
                 edge_logging_option: Optional[builtins.bool] = None,
                 inconsistent_module_settings: Optional[builtins.bool] = None,
                 install_agent: Optional[builtins.bool] = None,
                 ip_filter_deny_all: Optional[builtins.bool] = None,
                 ip_filter_permissive_rule: Optional[builtins.bool] = None,
                 open_ports: Optional[builtins.bool] = None,
                 permissive_firewall_policy: Optional[builtins.bool] = None,
                 permissive_input_firewall_rules: Optional[builtins.bool] = None,
                 permissive_output_firewall_rules: Optional[builtins.bool] = None,
                 privileged_docker_options: Optional[builtins.bool] = None,
                 shared_credentials: Optional[builtins.bool] = None,
                 vulnerable_tls_cipher_suite: Optional[builtins.bool] = None):
        """
        :param builtins.bool acr_authentication: Is Principal Authentication enabled for the ACR repository? Defaults to `true`.
        :param builtins.bool agent_send_unutilized_msg: Is Agent send underutilized messages enabled? Defaults to `true`.
        :param builtins.bool baseline: Is Security related system configuration issues identified? Defaults to `true`.
        :param builtins.bool edge_hub_mem_optimize: Is IoT Edge Hub memory optimized? Defaults to `true`.
        :param builtins.bool edge_logging_option: Is logging configured for IoT Edge module? Defaults to `true`.
        :param builtins.bool inconsistent_module_settings: Is inconsistent module settings enabled for SecurityGroup? Defaults to `true`.
        :param builtins.bool install_agent: is Azure IoT Security agent installed? Defaults to `true`.
        :param builtins.bool ip_filter_deny_all: Is Default IP filter policy denied? Defaults to `true`.
        :param builtins.bool ip_filter_permissive_rule: Is IP filter rule source allowable IP range too large? Defaults to `true`.
        :param builtins.bool open_ports: Is any ports open on the device? Defaults to `true`.
        :param builtins.bool permissive_firewall_policy: Does firewall policy exist which allow necessary communication to/from the device? Defaults to `true`.
        :param builtins.bool permissive_input_firewall_rules: Is only necessary addresses or ports are permitted in? Defaults to `true`.
        :param builtins.bool permissive_output_firewall_rules: Is only necessary addresses or ports are permitted out? Defaults to `true`.
        :param builtins.bool privileged_docker_options: Is high level permissions are needed for the module? Defaults to `true`.
        :param builtins.bool shared_credentials: Is any credentials shared among devices? Defaults to `true`.
        :param builtins.bool vulnerable_tls_cipher_suite: Does TLS cipher suite need to be updated? Defaults to `true`.
        """
        if acr_authentication is not None:
            pulumi.set(__self__, "acr_authentication", acr_authentication)
        if agent_send_unutilized_msg is not None:
            pulumi.set(__self__, "agent_send_unutilized_msg", agent_send_unutilized_msg)
        if baseline is not None:
            pulumi.set(__self__, "baseline", baseline)
        if edge_hub_mem_optimize is not None:
            pulumi.set(__self__, "edge_hub_mem_optimize", edge_hub_mem_optimize)
        if edge_logging_option is not None:
            pulumi.set(__self__, "edge_logging_option", edge_logging_option)
        if inconsistent_module_settings is not None:
            pulumi.set(__self__, "inconsistent_module_settings", inconsistent_module_settings)
        if install_agent is not None:
            pulumi.set(__self__, "install_agent", install_agent)
        if ip_filter_deny_all is not None:
            pulumi.set(__self__, "ip_filter_deny_all", ip_filter_deny_all)
        if ip_filter_permissive_rule is not None:
            pulumi.set(__self__, "ip_filter_permissive_rule", ip_filter_permissive_rule)
        if open_ports is not None:
            pulumi.set(__self__, "open_ports", open_ports)
        if permissive_firewall_policy is not None:
            pulumi.set(__self__, "permissive_firewall_policy", permissive_firewall_policy)
        if permissive_input_firewall_rules is not None:
            pulumi.set(__self__, "permissive_input_firewall_rules", permissive_input_firewall_rules)
        if permissive_output_firewall_rules is not None:
            pulumi.set(__self__, "permissive_output_firewall_rules", permissive_output_firewall_rules)
        if privileged_docker_options is not None:
            pulumi.set(__self__, "privileged_docker_options", privileged_docker_options)
        if shared_credentials is not None:
            pulumi.set(__self__, "shared_credentials", shared_credentials)
        if vulnerable_tls_cipher_suite is not None:
            pulumi.set(__self__, "vulnerable_tls_cipher_suite", vulnerable_tls_cipher_suite)

    @property
    @pulumi.getter(name="acrAuthentication")
    def acr_authentication(self) -> Optional[builtins.bool]:
        """
        Is Principal Authentication enabled for the ACR repository? Defaults to `true`.
        """
        return pulumi.get(self, "acr_authentication")

    @property
    @pulumi.getter(name="agentSendUnutilizedMsg")
    def agent_send_unutilized_msg(self) -> Optional[builtins.bool]:
        """
        Is Agent send underutilized messages enabled? Defaults to `true`.
        """
        return pulumi.get(self, "agent_send_unutilized_msg")

    @property
    @pulumi.getter
    def baseline(self) -> Optional[builtins.bool]:
        """
        Is Security related system configuration issues identified? Defaults to `true`.
        """
        return pulumi.get(self, "baseline")

    @property
    @pulumi.getter(name="edgeHubMemOptimize")
    def edge_hub_mem_optimize(self) -> Optional[builtins.bool]:
        """
        Is IoT Edge Hub memory optimized? Defaults to `true`.
        """
        return pulumi.get(self, "edge_hub_mem_optimize")

    @property
    @pulumi.getter(name="edgeLoggingOption")
    def edge_logging_option(self) -> Optional[builtins.bool]:
        """
        Is logging configured for IoT Edge module? Defaults to `true`.
        """
        return pulumi.get(self, "edge_logging_option")

    @property
    @pulumi.getter(name="inconsistentModuleSettings")
    def inconsistent_module_settings(self) -> Optional[builtins.bool]:
        """
        Is inconsistent module settings enabled for SecurityGroup? Defaults to `true`.
        """
        return pulumi.get(self, "inconsistent_module_settings")

    @property
    @pulumi.getter(name="installAgent")
    def install_agent(self) -> Optional[builtins.bool]:
        """
        is Azure IoT Security agent installed? Defaults to `true`.
        """
        return pulumi.get(self, "install_agent")

    @property
    @pulumi.getter(name="ipFilterDenyAll")
    def ip_filter_deny_all(self) -> Optional[builtins.bool]:
        """
        Is Default IP filter policy denied? Defaults to `true`.
        """
        return pulumi.get(self, "ip_filter_deny_all")

    @property
    @pulumi.getter(name="ipFilterPermissiveRule")
    def ip_filter_permissive_rule(self) -> Optional[builtins.bool]:
        """
        Is IP filter rule source allowable IP range too large? Defaults to `true`.
        """
        return pulumi.get(self, "ip_filter_permissive_rule")

    @property
    @pulumi.getter(name="openPorts")
    def open_ports(self) -> Optional[builtins.bool]:
        """
        Is any ports open on the device? Defaults to `true`.
        """
        return pulumi.get(self, "open_ports")

    @property
    @pulumi.getter(name="permissiveFirewallPolicy")
    def permissive_firewall_policy(self) -> Optional[builtins.bool]:
        """
        Does firewall policy exist which allow necessary communication to/from the device? Defaults to `true`.
        """
        return pulumi.get(self, "permissive_firewall_policy")

    @property
    @pulumi.getter(name="permissiveInputFirewallRules")
    def permissive_input_firewall_rules(self) -> Optional[builtins.bool]:
        """
        Is only necessary addresses or ports are permitted in? Defaults to `true`.
        """
        return pulumi.get(self, "permissive_input_firewall_rules")

    @property
    @pulumi.getter(name="permissiveOutputFirewallRules")
    def permissive_output_firewall_rules(self) -> Optional[builtins.bool]:
        """
        Is only necessary addresses or ports are permitted out? Defaults to `true`.
        """
        return pulumi.get(self, "permissive_output_firewall_rules")

    @property
    @pulumi.getter(name="privilegedDockerOptions")
    def privileged_docker_options(self) -> Optional[builtins.bool]:
        """
        Is high level permissions are needed for the module? Defaults to `true`.
        """
        return pulumi.get(self, "privileged_docker_options")

    @property
    @pulumi.getter(name="sharedCredentials")
    def shared_credentials(self) -> Optional[builtins.bool]:
        """
        Is any credentials shared among devices? Defaults to `true`.
        """
        return pulumi.get(self, "shared_credentials")

    @property
    @pulumi.getter(name="vulnerableTlsCipherSuite")
    def vulnerable_tls_cipher_suite(self) -> Optional[builtins.bool]:
        """
        Does TLS cipher suite need to be updated? Defaults to `true`.
        """
        return pulumi.get(self, "vulnerable_tls_cipher_suite")


@pulumi.output_type
class GetIotHubIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: The list of User Managed Identity IDs which are assigned to the Virtual Machine.
        :param builtins.str principal_id: The ID of the System Managed Service Principal assigned to the Virtual Machine.
        :param builtins.str tenant_id: The ID of the Tenant of the System Managed Service Principal assigned to the Virtual Machine.
        :param builtins.str type: The identity type of the Managed Identity assigned to the Virtual Machine.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        The list of User Managed Identity IDs which are assigned to the Virtual Machine.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        """
        The ID of the System Managed Service Principal assigned to the Virtual Machine.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The ID of the Tenant of the System Managed Service Principal assigned to the Virtual Machine.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The identity type of the Managed Identity assigned to the Virtual Machine.
        """
        return pulumi.get(self, "type")


