# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertifiateArgs', 'Certifiate']

@pulumi.input_type
class CertifiateArgs:
    def __init__(__self__, *,
                 key_vault_id: pulumi.Input[builtins.str],
                 certificate: Optional[pulumi.Input['CertifiateCertificateArgs']] = None,
                 certificate_policy: Optional[pulumi.Input['CertifiateCertificatePolicyArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Certifiate resource.
        :param pulumi.Input[builtins.str] key_vault_id: The ID of the Key Vault where the Certificate should be created. Changing this forces a new resource to be created.
        :param pulumi.Input['CertifiateCertificateArgs'] certificate: A `certificate` block as defined below, used to Import an existing certificate. Changing this will create a new version of the Key Vault Certificate.
        :param pulumi.Input['CertifiateCertificatePolicyArgs'] certificate_policy: A `certificate_policy` block as defined below. Changing this (except the `lifetime_action` field) will create a new version of the Key Vault Certificate.
               
               > **NOTE:** When creating a Key Vault Certificate, at least one of `certificate` or `certificate_policy` is required. Provide `certificate` to import an existing certificate, `certificate_policy` to generate a new certificate.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Key Vault Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_policy is not None:
            pulumi.set(__self__, "certificate_policy", certificate_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Key Vault where the Certificate should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_vault_id", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input['CertifiateCertificateArgs']]:
        """
        A `certificate` block as defined below, used to Import an existing certificate. Changing this will create a new version of the Key Vault Certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input['CertifiateCertificateArgs']]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="certificatePolicy")
    def certificate_policy(self) -> Optional[pulumi.Input['CertifiateCertificatePolicyArgs']]:
        """
        A `certificate_policy` block as defined below. Changing this (except the `lifetime_action` field) will create a new version of the Key Vault Certificate.

        > **NOTE:** When creating a Key Vault Certificate, at least one of `certificate` or `certificate_policy` is required. Provide `certificate` to import an existing certificate, `certificate_policy` to generate a new certificate.
        """
        return pulumi.get(self, "certificate_policy")

    @certificate_policy.setter
    def certificate_policy(self, value: Optional[pulumi.Input['CertifiateCertificatePolicyArgs']]):
        pulumi.set(self, "certificate_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Key Vault Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CertifiateState:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input['CertifiateCertificateArgs']] = None,
                 certificate_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['CertifiateCertificateAttributeArgs']]]] = None,
                 certificate_data: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_data_base64: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_policy: Optional[pulumi.Input['CertifiateCertificatePolicyArgs']] = None,
                 key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_manager_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_manager_versionless_id: Optional[pulumi.Input[builtins.str]] = None,
                 secret_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 thumbprint: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 versionless_id: Optional[pulumi.Input[builtins.str]] = None,
                 versionless_secret_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Certifiate resources.
        :param pulumi.Input['CertifiateCertificateArgs'] certificate: A `certificate` block as defined below, used to Import an existing certificate. Changing this will create a new version of the Key Vault Certificate.
        :param pulumi.Input[Sequence[pulumi.Input['CertifiateCertificateAttributeArgs']]] certificate_attributes: A `certificate_attribute` block as defined below.
        :param pulumi.Input[builtins.str] certificate_data: The raw Key Vault Certificate data represented as a hexadecimal string.
        :param pulumi.Input[builtins.str] certificate_data_base64: The Base64 encoded Key Vault Certificate data.
        :param pulumi.Input['CertifiateCertificatePolicyArgs'] certificate_policy: A `certificate_policy` block as defined below. Changing this (except the `lifetime_action` field) will create a new version of the Key Vault Certificate.
               
               > **NOTE:** When creating a Key Vault Certificate, at least one of `certificate` or `certificate_policy` is required. Provide `certificate` to import an existing certificate, `certificate_policy` to generate a new certificate.
        :param pulumi.Input[builtins.str] key_vault_id: The ID of the Key Vault where the Certificate should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Key Vault Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_manager_id: The (Versioned) ID for this Key Vault Certificate. This property points to a specific version of a Key Vault Certificate, as such using this won't auto-rotate values if used in other Azure Services.
        :param pulumi.Input[builtins.str] resource_manager_versionless_id: The Versionless ID of the Key Vault Certificate. This property allows other Azure Services (that support it) to auto-rotate their value when the Key Vault Certificate is updated.
        :param pulumi.Input[builtins.str] secret_id: The ID of the associated Key Vault Secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] thumbprint: The X509 Thumbprint of the Key Vault Certificate represented as a hexadecimal string.
        :param pulumi.Input[builtins.str] version: The current version of the Key Vault Certificate.
        :param pulumi.Input[builtins.str] versionless_id: The Base ID of the Key Vault Certificate.
        :param pulumi.Input[builtins.str] versionless_secret_id: The Base ID of the Key Vault Secret.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_attributes is not None:
            pulumi.set(__self__, "certificate_attributes", certificate_attributes)
        if certificate_data is not None:
            pulumi.set(__self__, "certificate_data", certificate_data)
        if certificate_data_base64 is not None:
            pulumi.set(__self__, "certificate_data_base64", certificate_data_base64)
        if certificate_policy is not None:
            pulumi.set(__self__, "certificate_policy", certificate_policy)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_manager_id is not None:
            pulumi.set(__self__, "resource_manager_id", resource_manager_id)
        if resource_manager_versionless_id is not None:
            pulumi.set(__self__, "resource_manager_versionless_id", resource_manager_versionless_id)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if versionless_id is not None:
            pulumi.set(__self__, "versionless_id", versionless_id)
        if versionless_secret_id is not None:
            pulumi.set(__self__, "versionless_secret_id", versionless_secret_id)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input['CertifiateCertificateArgs']]:
        """
        A `certificate` block as defined below, used to Import an existing certificate. Changing this will create a new version of the Key Vault Certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input['CertifiateCertificateArgs']]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="certificateAttributes")
    def certificate_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertifiateCertificateAttributeArgs']]]]:
        """
        A `certificate_attribute` block as defined below.
        """
        return pulumi.get(self, "certificate_attributes")

    @certificate_attributes.setter
    def certificate_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertifiateCertificateAttributeArgs']]]]):
        pulumi.set(self, "certificate_attributes", value)

    @property
    @pulumi.getter(name="certificateData")
    def certificate_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The raw Key Vault Certificate data represented as a hexadecimal string.
        """
        return pulumi.get(self, "certificate_data")

    @certificate_data.setter
    def certificate_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_data", value)

    @property
    @pulumi.getter(name="certificateDataBase64")
    def certificate_data_base64(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Base64 encoded Key Vault Certificate data.
        """
        return pulumi.get(self, "certificate_data_base64")

    @certificate_data_base64.setter
    def certificate_data_base64(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_data_base64", value)

    @property
    @pulumi.getter(name="certificatePolicy")
    def certificate_policy(self) -> Optional[pulumi.Input['CertifiateCertificatePolicyArgs']]:
        """
        A `certificate_policy` block as defined below. Changing this (except the `lifetime_action` field) will create a new version of the Key Vault Certificate.

        > **NOTE:** When creating a Key Vault Certificate, at least one of `certificate` or `certificate_policy` is required. Provide `certificate` to import an existing certificate, `certificate_policy` to generate a new certificate.
        """
        return pulumi.get(self, "certificate_policy")

    @certificate_policy.setter
    def certificate_policy(self, value: Optional[pulumi.Input['CertifiateCertificatePolicyArgs']]):
        pulumi.set(self, "certificate_policy", value)

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Key Vault where the Certificate should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Key Vault Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceManagerId")
    def resource_manager_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The (Versioned) ID for this Key Vault Certificate. This property points to a specific version of a Key Vault Certificate, as such using this won't auto-rotate values if used in other Azure Services.
        """
        return pulumi.get(self, "resource_manager_id")

    @resource_manager_id.setter
    def resource_manager_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_manager_id", value)

    @property
    @pulumi.getter(name="resourceManagerVersionlessId")
    def resource_manager_versionless_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Versionless ID of the Key Vault Certificate. This property allows other Azure Services (that support it) to auto-rotate their value when the Key Vault Certificate is updated.
        """
        return pulumi.get(self, "resource_manager_versionless_id")

    @resource_manager_versionless_id.setter
    def resource_manager_versionless_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_manager_versionless_id", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the associated Key Vault Secret.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The X509 Thumbprint of the Key Vault Certificate represented as a hexadecimal string.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "thumbprint", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current version of the Key Vault Certificate.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="versionlessId")
    def versionless_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Base ID of the Key Vault Certificate.
        """
        return pulumi.get(self, "versionless_id")

    @versionless_id.setter
    def versionless_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "versionless_id", value)

    @property
    @pulumi.getter(name="versionlessSecretId")
    def versionless_secret_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Base ID of the Key Vault Secret.
        """
        return pulumi.get(self, "versionless_secret_id")

    @versionless_secret_id.setter
    def versionless_secret_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "versionless_secret_id", value)


warnings.warn("""azure.keyvault.Certifiate has been deprecated in favor of azure.keyvault.Certificate""", DeprecationWarning)


@pulumi.type_token("azure:keyvault/certifiate:Certifiate")
class Certifiate(pulumi.CustomResource):
    warnings.warn("""azure.keyvault.Certifiate has been deprecated in favor of azure.keyvault.Certificate""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[Union['CertifiateCertificateArgs', 'CertifiateCertificateArgsDict']]] = None,
                 certificate_policy: Optional[pulumi.Input[Union['CertifiateCertificatePolicyArgs', 'CertifiateCertificatePolicyArgsDict']]] = None,
                 key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Key Vault Certificate.

        ## Example Usage

        ### Importing A PFX)

        > **Note:** this example assumed the PFX file is located in the same directory at `certificate-to-import.pfx`.

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "certificate_permissions": [
                    "Create",
                    "Delete",
                    "DeleteIssuers",
                    "Get",
                    "GetIssuers",
                    "Import",
                    "List",
                    "ListIssuers",
                    "ManageContacts",
                    "ManageIssuers",
                    "SetIssuers",
                    "Update",
                ],
                "key_permissions": [
                    "Backup",
                    "Create",
                    "Decrypt",
                    "Delete",
                    "Encrypt",
                    "Get",
                    "Import",
                    "List",
                    "Purge",
                    "Recover",
                    "Restore",
                    "Sign",
                    "UnwrapKey",
                    "Update",
                    "Verify",
                    "WrapKey",
                ],
                "secret_permissions": [
                    "Backup",
                    "Delete",
                    "Get",
                    "List",
                    "Purge",
                    "Recover",
                    "Restore",
                    "Set",
                ],
            }])
        example_certificate = azure.keyvault.Certificate("example",
            name="imported-cert",
            key_vault_id=example_key_vault.id,
            certificate={
                "contents": std.filebase64(input="certificate-to-import.pfx").result,
                "password": "",
            })
        ```

        ### Generating a new certificate

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            soft_delete_retention_days=7,
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "certificate_permissions": [
                    "Create",
                    "Delete",
                    "DeleteIssuers",
                    "Get",
                    "GetIssuers",
                    "Import",
                    "List",
                    "ListIssuers",
                    "ManageContacts",
                    "ManageIssuers",
                    "Purge",
                    "SetIssuers",
                    "Update",
                ],
                "key_permissions": [
                    "Backup",
                    "Create",
                    "Decrypt",
                    "Delete",
                    "Encrypt",
                    "Get",
                    "Import",
                    "List",
                    "Purge",
                    "Recover",
                    "Restore",
                    "Sign",
                    "UnwrapKey",
                    "Update",
                    "Verify",
                    "WrapKey",
                ],
                "secret_permissions": [
                    "Backup",
                    "Delete",
                    "Get",
                    "List",
                    "Purge",
                    "Recover",
                    "Restore",
                    "Set",
                ],
            }])
        example_certificate = azure.keyvault.Certificate("example",
            name="generated-cert",
            key_vault_id=example_key_vault.id,
            certificate_policy={
                "issuer_parameters": {
                    "name": "Self",
                },
                "key_properties": {
                    "exportable": True,
                    "key_size": 2048,
                    "key_type": "RSA",
                    "reuse_key": True,
                },
                "lifetime_actions": [{
                    "action": {
                        "action_type": "AutoRenew",
                    },
                    "trigger": {
                        "days_before_expiry": 30,
                    },
                }],
                "secret_properties": {
                    "content_type": "application/x-pkcs12",
                },
                "x509_certificate_properties": {
                    "extended_key_usages": ["1.3.6.1.5.5.7.3.1"],
                    "key_usages": [
                        "cRLSign",
                        "dataEncipherment",
                        "digitalSignature",
                        "keyAgreement",
                        "keyCertSign",
                        "keyEncipherment",
                    ],
                    "subject_alternative_names": {
                        "dns_names": [
                            "internal.contoso.com",
                            "domain.hello.world",
                        ],
                    },
                    "subject": "CN=hello-world",
                    "validity_in_months": 12,
                },
            })
        ```

        ## Import

        Key Vault Certificates can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/certifiate:Certifiate example "https://example-keyvault.vault.azure.net/certificates/example/fdf067c93bbb4b22bff4d8b7a9a56217"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CertifiateCertificateArgs', 'CertifiateCertificateArgsDict']] certificate: A `certificate` block as defined below, used to Import an existing certificate. Changing this will create a new version of the Key Vault Certificate.
        :param pulumi.Input[Union['CertifiateCertificatePolicyArgs', 'CertifiateCertificatePolicyArgsDict']] certificate_policy: A `certificate_policy` block as defined below. Changing this (except the `lifetime_action` field) will create a new version of the Key Vault Certificate.
               
               > **NOTE:** When creating a Key Vault Certificate, at least one of `certificate` or `certificate_policy` is required. Provide `certificate` to import an existing certificate, `certificate_policy` to generate a new certificate.
        :param pulumi.Input[builtins.str] key_vault_id: The ID of the Key Vault where the Certificate should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Key Vault Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertifiateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Key Vault Certificate.

        ## Example Usage

        ### Importing A PFX)

        > **Note:** this example assumed the PFX file is located in the same directory at `certificate-to-import.pfx`.

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "certificate_permissions": [
                    "Create",
                    "Delete",
                    "DeleteIssuers",
                    "Get",
                    "GetIssuers",
                    "Import",
                    "List",
                    "ListIssuers",
                    "ManageContacts",
                    "ManageIssuers",
                    "SetIssuers",
                    "Update",
                ],
                "key_permissions": [
                    "Backup",
                    "Create",
                    "Decrypt",
                    "Delete",
                    "Encrypt",
                    "Get",
                    "Import",
                    "List",
                    "Purge",
                    "Recover",
                    "Restore",
                    "Sign",
                    "UnwrapKey",
                    "Update",
                    "Verify",
                    "WrapKey",
                ],
                "secret_permissions": [
                    "Backup",
                    "Delete",
                    "Get",
                    "List",
                    "Purge",
                    "Recover",
                    "Restore",
                    "Set",
                ],
            }])
        example_certificate = azure.keyvault.Certificate("example",
            name="imported-cert",
            key_vault_id=example_key_vault.id,
            certificate={
                "contents": std.filebase64(input="certificate-to-import.pfx").result,
                "password": "",
            })
        ```

        ### Generating a new certificate

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            soft_delete_retention_days=7,
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "certificate_permissions": [
                    "Create",
                    "Delete",
                    "DeleteIssuers",
                    "Get",
                    "GetIssuers",
                    "Import",
                    "List",
                    "ListIssuers",
                    "ManageContacts",
                    "ManageIssuers",
                    "Purge",
                    "SetIssuers",
                    "Update",
                ],
                "key_permissions": [
                    "Backup",
                    "Create",
                    "Decrypt",
                    "Delete",
                    "Encrypt",
                    "Get",
                    "Import",
                    "List",
                    "Purge",
                    "Recover",
                    "Restore",
                    "Sign",
                    "UnwrapKey",
                    "Update",
                    "Verify",
                    "WrapKey",
                ],
                "secret_permissions": [
                    "Backup",
                    "Delete",
                    "Get",
                    "List",
                    "Purge",
                    "Recover",
                    "Restore",
                    "Set",
                ],
            }])
        example_certificate = azure.keyvault.Certificate("example",
            name="generated-cert",
            key_vault_id=example_key_vault.id,
            certificate_policy={
                "issuer_parameters": {
                    "name": "Self",
                },
                "key_properties": {
                    "exportable": True,
                    "key_size": 2048,
                    "key_type": "RSA",
                    "reuse_key": True,
                },
                "lifetime_actions": [{
                    "action": {
                        "action_type": "AutoRenew",
                    },
                    "trigger": {
                        "days_before_expiry": 30,
                    },
                }],
                "secret_properties": {
                    "content_type": "application/x-pkcs12",
                },
                "x509_certificate_properties": {
                    "extended_key_usages": ["1.3.6.1.5.5.7.3.1"],
                    "key_usages": [
                        "cRLSign",
                        "dataEncipherment",
                        "digitalSignature",
                        "keyAgreement",
                        "keyCertSign",
                        "keyEncipherment",
                    ],
                    "subject_alternative_names": {
                        "dns_names": [
                            "internal.contoso.com",
                            "domain.hello.world",
                        ],
                    },
                    "subject": "CN=hello-world",
                    "validity_in_months": 12,
                },
            })
        ```

        ## Import

        Key Vault Certificates can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/certifiate:Certifiate example "https://example-keyvault.vault.azure.net/certificates/example/fdf067c93bbb4b22bff4d8b7a9a56217"
        ```

        :param str resource_name: The name of the resource.
        :param CertifiateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertifiateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[Union['CertifiateCertificateArgs', 'CertifiateCertificateArgsDict']]] = None,
                 certificate_policy: Optional[pulumi.Input[Union['CertifiateCertificatePolicyArgs', 'CertifiateCertificatePolicyArgsDict']]] = None,
                 key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        pulumi.log.warn("""Certifiate is deprecated: azure.keyvault.Certifiate has been deprecated in favor of azure.keyvault.Certificate""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertifiateArgs.__new__(CertifiateArgs)

            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["certificate_policy"] = certificate_policy
            if key_vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_vault_id'")
            __props__.__dict__["key_vault_id"] = key_vault_id
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["certificate_attributes"] = None
            __props__.__dict__["certificate_data"] = None
            __props__.__dict__["certificate_data_base64"] = None
            __props__.__dict__["resource_manager_id"] = None
            __props__.__dict__["resource_manager_versionless_id"] = None
            __props__.__dict__["secret_id"] = None
            __props__.__dict__["thumbprint"] = None
            __props__.__dict__["version"] = None
            __props__.__dict__["versionless_id"] = None
            __props__.__dict__["versionless_secret_id"] = None
        super(Certifiate, __self__).__init__(
            'azure:keyvault/certifiate:Certifiate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate: Optional[pulumi.Input[Union['CertifiateCertificateArgs', 'CertifiateCertificateArgsDict']]] = None,
            certificate_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertifiateCertificateAttributeArgs', 'CertifiateCertificateAttributeArgsDict']]]]] = None,
            certificate_data: Optional[pulumi.Input[builtins.str]] = None,
            certificate_data_base64: Optional[pulumi.Input[builtins.str]] = None,
            certificate_policy: Optional[pulumi.Input[Union['CertifiateCertificatePolicyArgs', 'CertifiateCertificatePolicyArgsDict']]] = None,
            key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_manager_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_manager_versionless_id: Optional[pulumi.Input[builtins.str]] = None,
            secret_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            thumbprint: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None,
            versionless_id: Optional[pulumi.Input[builtins.str]] = None,
            versionless_secret_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Certifiate':
        """
        Get an existing Certifiate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CertifiateCertificateArgs', 'CertifiateCertificateArgsDict']] certificate: A `certificate` block as defined below, used to Import an existing certificate. Changing this will create a new version of the Key Vault Certificate.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertifiateCertificateAttributeArgs', 'CertifiateCertificateAttributeArgsDict']]]] certificate_attributes: A `certificate_attribute` block as defined below.
        :param pulumi.Input[builtins.str] certificate_data: The raw Key Vault Certificate data represented as a hexadecimal string.
        :param pulumi.Input[builtins.str] certificate_data_base64: The Base64 encoded Key Vault Certificate data.
        :param pulumi.Input[Union['CertifiateCertificatePolicyArgs', 'CertifiateCertificatePolicyArgsDict']] certificate_policy: A `certificate_policy` block as defined below. Changing this (except the `lifetime_action` field) will create a new version of the Key Vault Certificate.
               
               > **NOTE:** When creating a Key Vault Certificate, at least one of `certificate` or `certificate_policy` is required. Provide `certificate` to import an existing certificate, `certificate_policy` to generate a new certificate.
        :param pulumi.Input[builtins.str] key_vault_id: The ID of the Key Vault where the Certificate should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Key Vault Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_manager_id: The (Versioned) ID for this Key Vault Certificate. This property points to a specific version of a Key Vault Certificate, as such using this won't auto-rotate values if used in other Azure Services.
        :param pulumi.Input[builtins.str] resource_manager_versionless_id: The Versionless ID of the Key Vault Certificate. This property allows other Azure Services (that support it) to auto-rotate their value when the Key Vault Certificate is updated.
        :param pulumi.Input[builtins.str] secret_id: The ID of the associated Key Vault Secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] thumbprint: The X509 Thumbprint of the Key Vault Certificate represented as a hexadecimal string.
        :param pulumi.Input[builtins.str] version: The current version of the Key Vault Certificate.
        :param pulumi.Input[builtins.str] versionless_id: The Base ID of the Key Vault Certificate.
        :param pulumi.Input[builtins.str] versionless_secret_id: The Base ID of the Key Vault Secret.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertifiateState.__new__(_CertifiateState)

        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["certificate_attributes"] = certificate_attributes
        __props__.__dict__["certificate_data"] = certificate_data
        __props__.__dict__["certificate_data_base64"] = certificate_data_base64
        __props__.__dict__["certificate_policy"] = certificate_policy
        __props__.__dict__["key_vault_id"] = key_vault_id
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_manager_id"] = resource_manager_id
        __props__.__dict__["resource_manager_versionless_id"] = resource_manager_versionless_id
        __props__.__dict__["secret_id"] = secret_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["thumbprint"] = thumbprint
        __props__.__dict__["version"] = version
        __props__.__dict__["versionless_id"] = versionless_id
        __props__.__dict__["versionless_secret_id"] = versionless_secret_id
        return Certifiate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[Optional['outputs.CertifiateCertificate']]:
        """
        A `certificate` block as defined below, used to Import an existing certificate. Changing this will create a new version of the Key Vault Certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificateAttributes")
    def certificate_attributes(self) -> pulumi.Output[Sequence['outputs.CertifiateCertificateAttribute']]:
        """
        A `certificate_attribute` block as defined below.
        """
        return pulumi.get(self, "certificate_attributes")

    @property
    @pulumi.getter(name="certificateData")
    def certificate_data(self) -> pulumi.Output[builtins.str]:
        """
        The raw Key Vault Certificate data represented as a hexadecimal string.
        """
        return pulumi.get(self, "certificate_data")

    @property
    @pulumi.getter(name="certificateDataBase64")
    def certificate_data_base64(self) -> pulumi.Output[builtins.str]:
        """
        The Base64 encoded Key Vault Certificate data.
        """
        return pulumi.get(self, "certificate_data_base64")

    @property
    @pulumi.getter(name="certificatePolicy")
    def certificate_policy(self) -> pulumi.Output['outputs.CertifiateCertificatePolicy']:
        """
        A `certificate_policy` block as defined below. Changing this (except the `lifetime_action` field) will create a new version of the Key Vault Certificate.

        > **NOTE:** When creating a Key Vault Certificate, at least one of `certificate` or `certificate_policy` is required. Provide `certificate` to import an existing certificate, `certificate_policy` to generate a new certificate.
        """
        return pulumi.get(self, "certificate_policy")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Key Vault where the Certificate should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Key Vault Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceManagerId")
    def resource_manager_id(self) -> pulumi.Output[builtins.str]:
        """
        The (Versioned) ID for this Key Vault Certificate. This property points to a specific version of a Key Vault Certificate, as such using this won't auto-rotate values if used in other Azure Services.
        """
        return pulumi.get(self, "resource_manager_id")

    @property
    @pulumi.getter(name="resourceManagerVersionlessId")
    def resource_manager_versionless_id(self) -> pulumi.Output[builtins.str]:
        """
        The Versionless ID of the Key Vault Certificate. This property allows other Azure Services (that support it) to auto-rotate their value when the Key Vault Certificate is updated.
        """
        return pulumi.get(self, "resource_manager_versionless_id")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the associated Key Vault Secret.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Output[builtins.str]:
        """
        The X509 Thumbprint of the Key Vault Certificate represented as a hexadecimal string.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        The current version of the Key Vault Certificate.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="versionlessId")
    def versionless_id(self) -> pulumi.Output[builtins.str]:
        """
        The Base ID of the Key Vault Certificate.
        """
        return pulumi.get(self, "versionless_id")

    @property
    @pulumi.getter(name="versionlessSecretId")
    def versionless_secret_id(self) -> pulumi.Output[builtins.str]:
        """
        The Base ID of the Key Vault Secret.
        """
        return pulumi.get(self, "versionless_secret_id")

