# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

@pulumi.output_type
class GetCertificateResult:
    """
    A collection of values returned by getCertificate.
    """
    def __init__(__self__, certificate_data=None, certificate_data_base64=None, certificate_policies=None, expires=None, id=None, key_vault_id=None, name=None, not_before=None, resource_manager_id=None, resource_manager_versionless_id=None, secret_id=None, tags=None, thumbprint=None, version=None, versionless_id=None, versionless_secret_id=None):
        if certificate_data and not isinstance(certificate_data, str):
            raise TypeError("Expected argument 'certificate_data' to be a str")
        pulumi.set(__self__, "certificate_data", certificate_data)
        if certificate_data_base64 and not isinstance(certificate_data_base64, str):
            raise TypeError("Expected argument 'certificate_data_base64' to be a str")
        pulumi.set(__self__, "certificate_data_base64", certificate_data_base64)
        if certificate_policies and not isinstance(certificate_policies, list):
            raise TypeError("Expected argument 'certificate_policies' to be a list")
        pulumi.set(__self__, "certificate_policies", certificate_policies)
        if expires and not isinstance(expires, str):
            raise TypeError("Expected argument 'expires' to be a str")
        pulumi.set(__self__, "expires", expires)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_vault_id and not isinstance(key_vault_id, str):
            raise TypeError("Expected argument 'key_vault_id' to be a str")
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if not_before and not isinstance(not_before, str):
            raise TypeError("Expected argument 'not_before' to be a str")
        pulumi.set(__self__, "not_before", not_before)
        if resource_manager_id and not isinstance(resource_manager_id, str):
            raise TypeError("Expected argument 'resource_manager_id' to be a str")
        pulumi.set(__self__, "resource_manager_id", resource_manager_id)
        if resource_manager_versionless_id and not isinstance(resource_manager_versionless_id, str):
            raise TypeError("Expected argument 'resource_manager_versionless_id' to be a str")
        pulumi.set(__self__, "resource_manager_versionless_id", resource_manager_versionless_id)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if thumbprint and not isinstance(thumbprint, str):
            raise TypeError("Expected argument 'thumbprint' to be a str")
        pulumi.set(__self__, "thumbprint", thumbprint)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if versionless_id and not isinstance(versionless_id, str):
            raise TypeError("Expected argument 'versionless_id' to be a str")
        pulumi.set(__self__, "versionless_id", versionless_id)
        if versionless_secret_id and not isinstance(versionless_secret_id, str):
            raise TypeError("Expected argument 'versionless_secret_id' to be a str")
        pulumi.set(__self__, "versionless_secret_id", versionless_secret_id)

    @property
    @pulumi.getter(name="certificateData")
    def certificate_data(self) -> builtins.str:
        """
        The raw Key Vault Certificate data represented as a hexadecimal string.
        """
        return pulumi.get(self, "certificate_data")

    @property
    @pulumi.getter(name="certificateDataBase64")
    def certificate_data_base64(self) -> builtins.str:
        """
        The raw Key Vault Certificate data represented as a base64 string.
        """
        return pulumi.get(self, "certificate_data_base64")

    @property
    @pulumi.getter(name="certificatePolicies")
    def certificate_policies(self) -> Sequence['outputs.GetCertificateCertificatePolicyResult']:
        """
        A `certificate_policy` block as defined below.
        """
        return pulumi.get(self, "certificate_policies")

    @property
    @pulumi.getter
    def expires(self) -> builtins.str:
        """
        Expiry date of certificate in RFC3339 format.
        """
        return pulumi.get(self, "expires")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> builtins.str:
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Certificate Issuer.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> builtins.str:
        """
        Not Before date of certificate in RFC3339 format.
        """
        return pulumi.get(self, "not_before")

    @property
    @pulumi.getter(name="resourceManagerId")
    def resource_manager_id(self) -> builtins.str:
        """
        The (Versioned) ID for this Key Vault Certificate. This property points to a specific version of a Key Vault Certificate, as such using this won't auto-rotate values if used in other Azure Services.
        """
        return pulumi.get(self, "resource_manager_id")

    @property
    @pulumi.getter(name="resourceManagerVersionlessId")
    def resource_manager_versionless_id(self) -> builtins.str:
        """
        The Versionless ID of the Key Vault Certificate. This property allows other Azure Services (that support it) to auto-rotate their value when the Key Vault Certificate is updated.
        """
        return pulumi.get(self, "resource_manager_versionless_id")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> builtins.str:
        """
        The ID of the associated Key Vault Secret.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def thumbprint(self) -> builtins.str:
        """
        The X509 Thumbprint of the Key Vault Certificate represented as a hexadecimal string.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        The current version of the Key Vault Certificate.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="versionlessId")
    def versionless_id(self) -> builtins.str:
        """
        The Base ID of the Key Vault Certificate.
        """
        return pulumi.get(self, "versionless_id")

    @property
    @pulumi.getter(name="versionlessSecretId")
    def versionless_secret_id(self) -> builtins.str:
        """
        The Base ID of the Key Vault Secret.
        """
        return pulumi.get(self, "versionless_secret_id")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            certificate_data=self.certificate_data,
            certificate_data_base64=self.certificate_data_base64,
            certificate_policies=self.certificate_policies,
            expires=self.expires,
            id=self.id,
            key_vault_id=self.key_vault_id,
            name=self.name,
            not_before=self.not_before,
            resource_manager_id=self.resource_manager_id,
            resource_manager_versionless_id=self.resource_manager_versionless_id,
            secret_id=self.secret_id,
            tags=self.tags,
            thumbprint=self.thumbprint,
            version=self.version,
            versionless_id=self.versionless_id,
            versionless_secret_id=self.versionless_secret_id)


def get_certificate(key_vault_id: Optional[builtins.str] = None,
                    name: Optional[builtins.str] = None,
                    version: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    Use this data source to access information about an existing Key Vault Certificate.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.keyvault.get_key_vault(name="examplekv",
        resource_group_name="some-resource-group")
    example_get_certificate = azure.keyvault.get_certificate(name="secret-sauce",
        key_vault_id=example.id)
    pulumi.export("certificateThumbprint", example_get_certificate.thumbprint)
    ```


    :param builtins.str key_vault_id: Specifies the ID of the Key Vault instance where the Secret resides, available on the `keyvault.KeyVault` Data Source / Resource.
    :param builtins.str name: Specifies the name of the Key Vault Certificate.
    :param builtins.str version: Specifies the version of the certificate to look up.  (Defaults to latest)
           
           > **Note:** The vault must be in the same subscription as the provider. If the vault is in another subscription, you must create an aliased provider for that subscription.
    """
    __args__ = dict()
    __args__['keyVaultId'] = key_vault_id
    __args__['name'] = name
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:keyvault/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        certificate_data=pulumi.get(__ret__, 'certificate_data'),
        certificate_data_base64=pulumi.get(__ret__, 'certificate_data_base64'),
        certificate_policies=pulumi.get(__ret__, 'certificate_policies'),
        expires=pulumi.get(__ret__, 'expires'),
        id=pulumi.get(__ret__, 'id'),
        key_vault_id=pulumi.get(__ret__, 'key_vault_id'),
        name=pulumi.get(__ret__, 'name'),
        not_before=pulumi.get(__ret__, 'not_before'),
        resource_manager_id=pulumi.get(__ret__, 'resource_manager_id'),
        resource_manager_versionless_id=pulumi.get(__ret__, 'resource_manager_versionless_id'),
        secret_id=pulumi.get(__ret__, 'secret_id'),
        tags=pulumi.get(__ret__, 'tags'),
        thumbprint=pulumi.get(__ret__, 'thumbprint'),
        version=pulumi.get(__ret__, 'version'),
        versionless_id=pulumi.get(__ret__, 'versionless_id'),
        versionless_secret_id=pulumi.get(__ret__, 'versionless_secret_id'))
def get_certificate_output(key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                           name: Optional[pulumi.Input[builtins.str]] = None,
                           version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificateResult]:
    """
    Use this data source to access information about an existing Key Vault Certificate.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.keyvault.get_key_vault(name="examplekv",
        resource_group_name="some-resource-group")
    example_get_certificate = azure.keyvault.get_certificate(name="secret-sauce",
        key_vault_id=example.id)
    pulumi.export("certificateThumbprint", example_get_certificate.thumbprint)
    ```


    :param builtins.str key_vault_id: Specifies the ID of the Key Vault instance where the Secret resides, available on the `keyvault.KeyVault` Data Source / Resource.
    :param builtins.str name: Specifies the name of the Key Vault Certificate.
    :param builtins.str version: Specifies the version of the certificate to look up.  (Defaults to latest)
           
           > **Note:** The vault must be in the same subscription as the provider. If the vault is in another subscription, you must create an aliased provider for that subscription.
    """
    __args__ = dict()
    __args__['keyVaultId'] = key_vault_id
    __args__['name'] = name
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:keyvault/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult)
    return __ret__.apply(lambda __response__: GetCertificateResult(
        certificate_data=pulumi.get(__response__, 'certificate_data'),
        certificate_data_base64=pulumi.get(__response__, 'certificate_data_base64'),
        certificate_policies=pulumi.get(__response__, 'certificate_policies'),
        expires=pulumi.get(__response__, 'expires'),
        id=pulumi.get(__response__, 'id'),
        key_vault_id=pulumi.get(__response__, 'key_vault_id'),
        name=pulumi.get(__response__, 'name'),
        not_before=pulumi.get(__response__, 'not_before'),
        resource_manager_id=pulumi.get(__response__, 'resource_manager_id'),
        resource_manager_versionless_id=pulumi.get(__response__, 'resource_manager_versionless_id'),
        secret_id=pulumi.get(__response__, 'secret_id'),
        tags=pulumi.get(__response__, 'tags'),
        thumbprint=pulumi.get(__response__, 'thumbprint'),
        version=pulumi.get(__response__, 'version'),
        versionless_id=pulumi.get(__response__, 'versionless_id'),
        versionless_secret_id=pulumi.get(__response__, 'versionless_secret_id')))
