# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetKeyResult',
    'AwaitableGetKeyResult',
    'get_key',
    'get_key_output',
]

@pulumi.output_type
class GetKeyResult:
    """
    A collection of values returned by getKey.
    """
    def __init__(__self__, curve=None, e=None, id=None, key_opts=None, key_size=None, key_type=None, key_vault_id=None, n=None, name=None, public_key_openssh=None, public_key_pem=None, resource_id=None, resource_versionless_id=None, tags=None, version=None, versionless_id=None, x=None, y=None):
        if curve and not isinstance(curve, str):
            raise TypeError("Expected argument 'curve' to be a str")
        pulumi.set(__self__, "curve", curve)
        if e and not isinstance(e, str):
            raise TypeError("Expected argument 'e' to be a str")
        pulumi.set(__self__, "e", e)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_opts and not isinstance(key_opts, list):
            raise TypeError("Expected argument 'key_opts' to be a list")
        pulumi.set(__self__, "key_opts", key_opts)
        if key_size and not isinstance(key_size, int):
            raise TypeError("Expected argument 'key_size' to be a int")
        pulumi.set(__self__, "key_size", key_size)
        if key_type and not isinstance(key_type, str):
            raise TypeError("Expected argument 'key_type' to be a str")
        pulumi.set(__self__, "key_type", key_type)
        if key_vault_id and not isinstance(key_vault_id, str):
            raise TypeError("Expected argument 'key_vault_id' to be a str")
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        if n and not isinstance(n, str):
            raise TypeError("Expected argument 'n' to be a str")
        pulumi.set(__self__, "n", n)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_key_openssh and not isinstance(public_key_openssh, str):
            raise TypeError("Expected argument 'public_key_openssh' to be a str")
        pulumi.set(__self__, "public_key_openssh", public_key_openssh)
        if public_key_pem and not isinstance(public_key_pem, str):
            raise TypeError("Expected argument 'public_key_pem' to be a str")
        pulumi.set(__self__, "public_key_pem", public_key_pem)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if resource_versionless_id and not isinstance(resource_versionless_id, str):
            raise TypeError("Expected argument 'resource_versionless_id' to be a str")
        pulumi.set(__self__, "resource_versionless_id", resource_versionless_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if versionless_id and not isinstance(versionless_id, str):
            raise TypeError("Expected argument 'versionless_id' to be a str")
        pulumi.set(__self__, "versionless_id", versionless_id)
        if x and not isinstance(x, str):
            raise TypeError("Expected argument 'x' to be a str")
        pulumi.set(__self__, "x", x)
        if y and not isinstance(y, str):
            raise TypeError("Expected argument 'y' to be a str")
        pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def curve(self) -> builtins.str:
        """
        The EC Curve name of this Key Vault Key.
        """
        return pulumi.get(self, "curve")

    @property
    @pulumi.getter
    def e(self) -> builtins.str:
        """
        The RSA public exponent of this Key Vault Key.
        """
        return pulumi.get(self, "e")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyOpts")
    def key_opts(self) -> Sequence[builtins.str]:
        """
        A list of JSON web key operations assigned to this Key Vault Key
        """
        return pulumi.get(self, "key_opts")

    @property
    @pulumi.getter(name="keySize")
    def key_size(self) -> builtins.int:
        """
        Specifies the Size of this Key Vault Key.
        """
        return pulumi.get(self, "key_size")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> builtins.str:
        """
        Specifies the Key Type of this Key Vault Key
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> builtins.str:
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter
    def n(self) -> builtins.str:
        """
        The RSA modulus of this Key Vault Key.
        """
        return pulumi.get(self, "n")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicKeyOpenssh")
    def public_key_openssh(self) -> builtins.str:
        """
        The OpenSSH encoded public key of this Key Vault Key.
        """
        return pulumi.get(self, "public_key_openssh")

    @property
    @pulumi.getter(name="publicKeyPem")
    def public_key_pem(self) -> builtins.str:
        """
        The PEM encoded public key of this Key Vault Key.
        """
        return pulumi.get(self, "public_key_pem")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        The (Versioned) ID for this Key Vault Key. This property points to a specific version of a Key Vault Key, as such using this won't auto-rotate values if used in other Azure Services.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceVersionlessId")
    def resource_versionless_id(self) -> builtins.str:
        """
        The Versionless ID of the Key Vault Key. This property allows other Azure Services (that support it) to auto-rotate their value when the Key Vault Key is updated.
        """
        return pulumi.get(self, "resource_versionless_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to this Key Vault Key.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        The current version of the Key Vault Key.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="versionlessId")
    def versionless_id(self) -> builtins.str:
        """
        The Base ID of the Key Vault Key.
        """
        return pulumi.get(self, "versionless_id")

    @property
    @pulumi.getter
    def x(self) -> builtins.str:
        """
        The EC X component of this Key Vault Key.
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> builtins.str:
        """
        The EC Y component of this Key Vault Key.
        """
        return pulumi.get(self, "y")


class AwaitableGetKeyResult(GetKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyResult(
            curve=self.curve,
            e=self.e,
            id=self.id,
            key_opts=self.key_opts,
            key_size=self.key_size,
            key_type=self.key_type,
            key_vault_id=self.key_vault_id,
            n=self.n,
            name=self.name,
            public_key_openssh=self.public_key_openssh,
            public_key_pem=self.public_key_pem,
            resource_id=self.resource_id,
            resource_versionless_id=self.resource_versionless_id,
            tags=self.tags,
            version=self.version,
            versionless_id=self.versionless_id,
            x=self.x,
            y=self.y)


def get_key(key_vault_id: Optional[builtins.str] = None,
            name: Optional[builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyResult:
    """
    Use this data source to access information about an existing Key Vault Key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.keyvault.get_key(name="secret-sauce",
        key_vault_id=existing["id"])
    pulumi.export("keyType", example.key_type)
    ```


    :param builtins.str key_vault_id: Specifies the ID of the Key Vault instance where the Secret resides, available on the `keyvault.KeyVault` Data Source / Resource.
           
           > **Note:** The vault must be in the same subscription as the provider. If the vault is in another subscription, you must create an aliased provider for that subscription.
    :param builtins.str name: Specifies the name of the Key Vault Key.
    """
    __args__ = dict()
    __args__['keyVaultId'] = key_vault_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:keyvault/getKey:getKey', __args__, opts=opts, typ=GetKeyResult).value

    return AwaitableGetKeyResult(
        curve=pulumi.get(__ret__, 'curve'),
        e=pulumi.get(__ret__, 'e'),
        id=pulumi.get(__ret__, 'id'),
        key_opts=pulumi.get(__ret__, 'key_opts'),
        key_size=pulumi.get(__ret__, 'key_size'),
        key_type=pulumi.get(__ret__, 'key_type'),
        key_vault_id=pulumi.get(__ret__, 'key_vault_id'),
        n=pulumi.get(__ret__, 'n'),
        name=pulumi.get(__ret__, 'name'),
        public_key_openssh=pulumi.get(__ret__, 'public_key_openssh'),
        public_key_pem=pulumi.get(__ret__, 'public_key_pem'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        resource_versionless_id=pulumi.get(__ret__, 'resource_versionless_id'),
        tags=pulumi.get(__ret__, 'tags'),
        version=pulumi.get(__ret__, 'version'),
        versionless_id=pulumi.get(__ret__, 'versionless_id'),
        x=pulumi.get(__ret__, 'x'),
        y=pulumi.get(__ret__, 'y'))
def get_key_output(key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                   name: Optional[pulumi.Input[builtins.str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeyResult]:
    """
    Use this data source to access information about an existing Key Vault Key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.keyvault.get_key(name="secret-sauce",
        key_vault_id=existing["id"])
    pulumi.export("keyType", example.key_type)
    ```


    :param builtins.str key_vault_id: Specifies the ID of the Key Vault instance where the Secret resides, available on the `keyvault.KeyVault` Data Source / Resource.
           
           > **Note:** The vault must be in the same subscription as the provider. If the vault is in another subscription, you must create an aliased provider for that subscription.
    :param builtins.str name: Specifies the name of the Key Vault Key.
    """
    __args__ = dict()
    __args__['keyVaultId'] = key_vault_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:keyvault/getKey:getKey', __args__, opts=opts, typ=GetKeyResult)
    return __ret__.apply(lambda __response__: GetKeyResult(
        curve=pulumi.get(__response__, 'curve'),
        e=pulumi.get(__response__, 'e'),
        id=pulumi.get(__response__, 'id'),
        key_opts=pulumi.get(__response__, 'key_opts'),
        key_size=pulumi.get(__response__, 'key_size'),
        key_type=pulumi.get(__response__, 'key_type'),
        key_vault_id=pulumi.get(__response__, 'key_vault_id'),
        n=pulumi.get(__response__, 'n'),
        name=pulumi.get(__response__, 'name'),
        public_key_openssh=pulumi.get(__response__, 'public_key_openssh'),
        public_key_pem=pulumi.get(__response__, 'public_key_pem'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        resource_versionless_id=pulumi.get(__response__, 'resource_versionless_id'),
        tags=pulumi.get(__response__, 'tags'),
        version=pulumi.get(__response__, 'version'),
        versionless_id=pulumi.get(__response__, 'versionless_id'),
        x=pulumi.get(__response__, 'x'),
        y=pulumi.get(__response__, 'y')))
