# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetManagedHardwareSecurityModuleKeyResult',
    'AwaitableGetManagedHardwareSecurityModuleKeyResult',
    'get_managed_hardware_security_module_key',
    'get_managed_hardware_security_module_key_output',
]

@pulumi.output_type
class GetManagedHardwareSecurityModuleKeyResult:
    """
    A collection of values returned by getManagedHardwareSecurityModuleKey.
    """
    def __init__(__self__, curve=None, expiration_date=None, id=None, key_opts=None, key_size=None, key_type=None, managed_hsm_id=None, name=None, not_before_date=None, tags=None, version=None, versioned_id=None):
        if curve and not isinstance(curve, str):
            raise TypeError("Expected argument 'curve' to be a str")
        pulumi.set(__self__, "curve", curve)
        if expiration_date and not isinstance(expiration_date, str):
            raise TypeError("Expected argument 'expiration_date' to be a str")
        pulumi.set(__self__, "expiration_date", expiration_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_opts and not isinstance(key_opts, list):
            raise TypeError("Expected argument 'key_opts' to be a list")
        pulumi.set(__self__, "key_opts", key_opts)
        if key_size and not isinstance(key_size, int):
            raise TypeError("Expected argument 'key_size' to be a int")
        pulumi.set(__self__, "key_size", key_size)
        if key_type and not isinstance(key_type, str):
            raise TypeError("Expected argument 'key_type' to be a str")
        pulumi.set(__self__, "key_type", key_type)
        if managed_hsm_id and not isinstance(managed_hsm_id, str):
            raise TypeError("Expected argument 'managed_hsm_id' to be a str")
        pulumi.set(__self__, "managed_hsm_id", managed_hsm_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if not_before_date and not isinstance(not_before_date, str):
            raise TypeError("Expected argument 'not_before_date' to be a str")
        pulumi.set(__self__, "not_before_date", not_before_date)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if versioned_id and not isinstance(versioned_id, str):
            raise TypeError("Expected argument 'versioned_id' to be a str")
        pulumi.set(__self__, "versioned_id", versioned_id)

    @property
    @pulumi.getter
    def curve(self) -> builtins.str:
        """
        The EC Curve name of this Managed Hardware Security Module Key.
        """
        return pulumi.get(self, "curve")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> builtins.str:
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyOpts")
    def key_opts(self) -> Sequence[builtins.str]:
        """
        A list of JSON web key operations assigned to this Managed Hardware Security Module Key
        """
        return pulumi.get(self, "key_opts")

    @property
    @pulumi.getter(name="keySize")
    def key_size(self) -> builtins.int:
        """
        Specifies the Size of this Managed Hardware Security Module Key.
        """
        return pulumi.get(self, "key_size")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> builtins.str:
        """
        Specifies the Key Type of this Managed Hardware Security Module Key
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="managedHsmId")
    def managed_hsm_id(self) -> builtins.str:
        return pulumi.get(self, "managed_hsm_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notBeforeDate")
    def not_before_date(self) -> builtins.str:
        return pulumi.get(self, "not_before_date")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to this Managed Hardware Security Module Key.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        The current version of the Managed Hardware Security Module Key.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="versionedId")
    def versioned_id(self) -> builtins.str:
        """
        The versioned ID of the Managed Hardware Security Module Key.
        """
        return pulumi.get(self, "versioned_id")


class AwaitableGetManagedHardwareSecurityModuleKeyResult(GetManagedHardwareSecurityModuleKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedHardwareSecurityModuleKeyResult(
            curve=self.curve,
            expiration_date=self.expiration_date,
            id=self.id,
            key_opts=self.key_opts,
            key_size=self.key_size,
            key_type=self.key_type,
            managed_hsm_id=self.managed_hsm_id,
            name=self.name,
            not_before_date=self.not_before_date,
            tags=self.tags,
            version=self.version,
            versioned_id=self.versioned_id)


def get_managed_hardware_security_module_key(managed_hsm_id: Optional[builtins.str] = None,
                                             name: Optional[builtins.str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedHardwareSecurityModuleKeyResult:
    """
    Use this data source to access information about an existing Managed Hardware Security Module Key.

    > **Note:** All arguments including the secret value will be stored in the raw state as plain-text.
    [Read more about sensitive data in state](https://www.terraform.io/docs/state/sensitive-data.html).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.keyvault.get_managed_hardware_security_module_key(managed_hsm_id=example_azurerm_key_vault_managed_hardware_security_module["id"],
        name=example_azurerm_key_vault_managed_hardware_security_module_key["name"])
    pulumi.export("hsm-key-vesrion", example.version)
    ```


    :param builtins.str managed_hsm_id: Specifies the ID of the Managed Hardware Security Module instance where the Secret resides, available on the `keyvault.ManagedHardwareSecurityModuleKey` Data Source / Resource.
           
           > **Note:** The Managed Hardware Security Module must be in the same subscription as the provider. If the Managed Hardware Security Module is in another subscription, you must create an aliased provider for that subscription.
    :param builtins.str name: Specifies the name of the Managed Hardware Security Module Key.
    """
    __args__ = dict()
    __args__['managedHsmId'] = managed_hsm_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:keyvault/getManagedHardwareSecurityModuleKey:getManagedHardwareSecurityModuleKey', __args__, opts=opts, typ=GetManagedHardwareSecurityModuleKeyResult).value

    return AwaitableGetManagedHardwareSecurityModuleKeyResult(
        curve=pulumi.get(__ret__, 'curve'),
        expiration_date=pulumi.get(__ret__, 'expiration_date'),
        id=pulumi.get(__ret__, 'id'),
        key_opts=pulumi.get(__ret__, 'key_opts'),
        key_size=pulumi.get(__ret__, 'key_size'),
        key_type=pulumi.get(__ret__, 'key_type'),
        managed_hsm_id=pulumi.get(__ret__, 'managed_hsm_id'),
        name=pulumi.get(__ret__, 'name'),
        not_before_date=pulumi.get(__ret__, 'not_before_date'),
        tags=pulumi.get(__ret__, 'tags'),
        version=pulumi.get(__ret__, 'version'),
        versioned_id=pulumi.get(__ret__, 'versioned_id'))
def get_managed_hardware_security_module_key_output(managed_hsm_id: Optional[pulumi.Input[builtins.str]] = None,
                                                    name: Optional[pulumi.Input[builtins.str]] = None,
                                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedHardwareSecurityModuleKeyResult]:
    """
    Use this data source to access information about an existing Managed Hardware Security Module Key.

    > **Note:** All arguments including the secret value will be stored in the raw state as plain-text.
    [Read more about sensitive data in state](https://www.terraform.io/docs/state/sensitive-data.html).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.keyvault.get_managed_hardware_security_module_key(managed_hsm_id=example_azurerm_key_vault_managed_hardware_security_module["id"],
        name=example_azurerm_key_vault_managed_hardware_security_module_key["name"])
    pulumi.export("hsm-key-vesrion", example.version)
    ```


    :param builtins.str managed_hsm_id: Specifies the ID of the Managed Hardware Security Module instance where the Secret resides, available on the `keyvault.ManagedHardwareSecurityModuleKey` Data Source / Resource.
           
           > **Note:** The Managed Hardware Security Module must be in the same subscription as the provider. If the Managed Hardware Security Module is in another subscription, you must create an aliased provider for that subscription.
    :param builtins.str name: Specifies the name of the Managed Hardware Security Module Key.
    """
    __args__ = dict()
    __args__['managedHsmId'] = managed_hsm_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:keyvault/getManagedHardwareSecurityModuleKey:getManagedHardwareSecurityModuleKey', __args__, opts=opts, typ=GetManagedHardwareSecurityModuleKeyResult)
    return __ret__.apply(lambda __response__: GetManagedHardwareSecurityModuleKeyResult(
        curve=pulumi.get(__response__, 'curve'),
        expiration_date=pulumi.get(__response__, 'expiration_date'),
        id=pulumi.get(__response__, 'id'),
        key_opts=pulumi.get(__response__, 'key_opts'),
        key_size=pulumi.get(__response__, 'key_size'),
        key_type=pulumi.get(__response__, 'key_type'),
        managed_hsm_id=pulumi.get(__response__, 'managed_hsm_id'),
        name=pulumi.get(__response__, 'name'),
        not_before_date=pulumi.get(__response__, 'not_before_date'),
        tags=pulumi.get(__response__, 'tags'),
        version=pulumi.get(__response__, 'version'),
        versioned_id=pulumi.get(__response__, 'versioned_id')))
