# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KeyArgs', 'Key']

@pulumi.input_type
class KeyArgs:
    def __init__(__self__, *,
                 key_opts: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 key_type: pulumi.Input[builtins.str],
                 key_vault_id: pulumi.Input[builtins.str],
                 curve: Optional[pulumi.Input[builtins.str]] = None,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 key_size: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 not_before_date: Optional[pulumi.Input[builtins.str]] = None,
                 rotation_policy: Optional[pulumi.Input['KeyRotationPolicyArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Key resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] key_opts: A list of JSON web key operations. Possible values include: `decrypt`, `encrypt`, `sign`, `unwrapKey`, `verify` and `wrapKey`. Please note these values are case sensitive.
        :param pulumi.Input[builtins.str] key_type: Specifies the Key Type to use for this Key Vault Key. Possible values are `EC` (Elliptic Curve), `EC-HSM`, `RSA` and `RSA-HSM`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_vault_id: The ID of the Key Vault where the Key should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] curve: Specifies the curve to use when creating an `EC` key. Possible values are `P-256`, `P-256K`, `P-384`, and `P-521`. This field will be required in a future release if `key_type` is `EC` or `EC-HSM`. The API will default to `P-256` if nothing is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] expiration_date: Expiration UTC datetime (Y-m-d'T'H:M:S'Z').
               
               > **Note:** Removing this field from the config forces a new resource to be created.
        :param pulumi.Input[builtins.int] key_size: Specifies the Size of the RSA key to create in bytes. For example, 1024 or 2048. *Note*: This field is required if `key_type` is `RSA` or `RSA-HSM`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Key Vault Key. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] not_before_date: Key not usable before the provided UTC datetime (Y-m-d'T'H:M:S'Z').
               
               > **Note:** Once `expiration_date` is set, it's not possible to unset the key even if it is deleted & recreated as underlying Azure API uses the restore of the purged key.
        :param pulumi.Input['KeyRotationPolicyArgs'] rotation_policy: A `rotation_policy` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "key_opts", key_opts)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        if curve is not None:
            pulumi.set(__self__, "curve", curve)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if key_size is not None:
            pulumi.set(__self__, "key_size", key_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if not_before_date is not None:
            pulumi.set(__self__, "not_before_date", not_before_date)
        if rotation_policy is not None:
            pulumi.set(__self__, "rotation_policy", rotation_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="keyOpts")
    def key_opts(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of JSON web key operations. Possible values include: `decrypt`, `encrypt`, `sign`, `unwrapKey`, `verify` and `wrapKey`. Please note these values are case sensitive.
        """
        return pulumi.get(self, "key_opts")

    @key_opts.setter
    def key_opts(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "key_opts", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Key Type to use for this Key Vault Key. Possible values are `EC` (Elliptic Curve), `EC-HSM`, `RSA` and `RSA-HSM`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Key Vault where the Key should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_vault_id", value)

    @property
    @pulumi.getter
    def curve(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the curve to use when creating an `EC` key. Possible values are `P-256`, `P-256K`, `P-384`, and `P-521`. This field will be required in a future release if `key_type` is `EC` or `EC-HSM`. The API will default to `P-256` if nothing is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "curve")

    @curve.setter
    def curve(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "curve", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Expiration UTC datetime (Y-m-d'T'H:M:S'Z').

        > **Note:** Removing this field from the config forces a new resource to be created.
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="keySize")
    def key_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the Size of the RSA key to create in bytes. For example, 1024 or 2048. *Note*: This field is required if `key_type` is `RSA` or `RSA-HSM`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_size")

    @key_size.setter
    def key_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "key_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Key Vault Key. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notBeforeDate")
    def not_before_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key not usable before the provided UTC datetime (Y-m-d'T'H:M:S'Z').

        > **Note:** Once `expiration_date` is set, it's not possible to unset the key even if it is deleted & recreated as underlying Azure API uses the restore of the purged key.
        """
        return pulumi.get(self, "not_before_date")

    @not_before_date.setter
    def not_before_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "not_before_date", value)

    @property
    @pulumi.getter(name="rotationPolicy")
    def rotation_policy(self) -> Optional[pulumi.Input['KeyRotationPolicyArgs']]:
        """
        A `rotation_policy` block as defined below.
        """
        return pulumi.get(self, "rotation_policy")

    @rotation_policy.setter
    def rotation_policy(self, value: Optional[pulumi.Input['KeyRotationPolicyArgs']]):
        pulumi.set(self, "rotation_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _KeyState:
    def __init__(__self__, *,
                 curve: Optional[pulumi.Input[builtins.str]] = None,
                 e: Optional[pulumi.Input[builtins.str]] = None,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 key_opts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 key_size: Optional[pulumi.Input[builtins.int]] = None,
                 key_type: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 n: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 not_before_date: Optional[pulumi.Input[builtins.str]] = None,
                 public_key_openssh: Optional[pulumi.Input[builtins.str]] = None,
                 public_key_pem: Optional[pulumi.Input[builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_versionless_id: Optional[pulumi.Input[builtins.str]] = None,
                 rotation_policy: Optional[pulumi.Input['KeyRotationPolicyArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 versionless_id: Optional[pulumi.Input[builtins.str]] = None,
                 x: Optional[pulumi.Input[builtins.str]] = None,
                 y: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Key resources.
        :param pulumi.Input[builtins.str] curve: Specifies the curve to use when creating an `EC` key. Possible values are `P-256`, `P-256K`, `P-384`, and `P-521`. This field will be required in a future release if `key_type` is `EC` or `EC-HSM`. The API will default to `P-256` if nothing is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] e: The RSA public exponent of this Key Vault Key.
        :param pulumi.Input[builtins.str] expiration_date: Expiration UTC datetime (Y-m-d'T'H:M:S'Z').
               
               > **Note:** Removing this field from the config forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] key_opts: A list of JSON web key operations. Possible values include: `decrypt`, `encrypt`, `sign`, `unwrapKey`, `verify` and `wrapKey`. Please note these values are case sensitive.
        :param pulumi.Input[builtins.int] key_size: Specifies the Size of the RSA key to create in bytes. For example, 1024 or 2048. *Note*: This field is required if `key_type` is `RSA` or `RSA-HSM`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_type: Specifies the Key Type to use for this Key Vault Key. Possible values are `EC` (Elliptic Curve), `EC-HSM`, `RSA` and `RSA-HSM`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_vault_id: The ID of the Key Vault where the Key should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] n: The RSA modulus of this Key Vault Key.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Key Vault Key. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] not_before_date: Key not usable before the provided UTC datetime (Y-m-d'T'H:M:S'Z').
               
               > **Note:** Once `expiration_date` is set, it's not possible to unset the key even if it is deleted & recreated as underlying Azure API uses the restore of the purged key.
        :param pulumi.Input[builtins.str] public_key_openssh: The OpenSSH encoded public key of this Key Vault Key.
        :param pulumi.Input[builtins.str] public_key_pem: The PEM encoded public key of this Key Vault Key.
        :param pulumi.Input[builtins.str] resource_id: The (Versioned) ID for this Key Vault Key. This property points to a specific version of a Key Vault Key, as such using this won't auto-rotate values if used in other Azure Services.
        :param pulumi.Input[builtins.str] resource_versionless_id: The Versionless ID of the Key Vault Key. This property allows other Azure Services (that support it) to auto-rotate their value when the Key Vault Key is updated.
        :param pulumi.Input['KeyRotationPolicyArgs'] rotation_policy: A `rotation_policy` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] version: The current version of the Key Vault Key.
        :param pulumi.Input[builtins.str] versionless_id: The Base ID of the Key Vault Key.
        :param pulumi.Input[builtins.str] x: The EC X component of this Key Vault Key.
        :param pulumi.Input[builtins.str] y: The EC Y component of this Key Vault Key.
        """
        if curve is not None:
            pulumi.set(__self__, "curve", curve)
        if e is not None:
            pulumi.set(__self__, "e", e)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if key_opts is not None:
            pulumi.set(__self__, "key_opts", key_opts)
        if key_size is not None:
            pulumi.set(__self__, "key_size", key_size)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if n is not None:
            pulumi.set(__self__, "n", n)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if not_before_date is not None:
            pulumi.set(__self__, "not_before_date", not_before_date)
        if public_key_openssh is not None:
            pulumi.set(__self__, "public_key_openssh", public_key_openssh)
        if public_key_pem is not None:
            pulumi.set(__self__, "public_key_pem", public_key_pem)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_versionless_id is not None:
            pulumi.set(__self__, "resource_versionless_id", resource_versionless_id)
        if rotation_policy is not None:
            pulumi.set(__self__, "rotation_policy", rotation_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if versionless_id is not None:
            pulumi.set(__self__, "versionless_id", versionless_id)
        if x is not None:
            pulumi.set(__self__, "x", x)
        if y is not None:
            pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def curve(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the curve to use when creating an `EC` key. Possible values are `P-256`, `P-256K`, `P-384`, and `P-521`. This field will be required in a future release if `key_type` is `EC` or `EC-HSM`. The API will default to `P-256` if nothing is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "curve")

    @curve.setter
    def curve(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "curve", value)

    @property
    @pulumi.getter
    def e(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The RSA public exponent of this Key Vault Key.
        """
        return pulumi.get(self, "e")

    @e.setter
    def e(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "e", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Expiration UTC datetime (Y-m-d'T'H:M:S'Z').

        > **Note:** Removing this field from the config forces a new resource to be created.
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="keyOpts")
    def key_opts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of JSON web key operations. Possible values include: `decrypt`, `encrypt`, `sign`, `unwrapKey`, `verify` and `wrapKey`. Please note these values are case sensitive.
        """
        return pulumi.get(self, "key_opts")

    @key_opts.setter
    def key_opts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "key_opts", value)

    @property
    @pulumi.getter(name="keySize")
    def key_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the Size of the RSA key to create in bytes. For example, 1024 or 2048. *Note*: This field is required if `key_type` is `RSA` or `RSA-HSM`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_size")

    @key_size.setter
    def key_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "key_size", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Key Type to use for this Key Vault Key. Possible values are `EC` (Elliptic Curve), `EC-HSM`, `RSA` and `RSA-HSM`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Key Vault where the Key should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_id", value)

    @property
    @pulumi.getter
    def n(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The RSA modulus of this Key Vault Key.
        """
        return pulumi.get(self, "n")

    @n.setter
    def n(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "n", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Key Vault Key. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notBeforeDate")
    def not_before_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key not usable before the provided UTC datetime (Y-m-d'T'H:M:S'Z').

        > **Note:** Once `expiration_date` is set, it's not possible to unset the key even if it is deleted & recreated as underlying Azure API uses the restore of the purged key.
        """
        return pulumi.get(self, "not_before_date")

    @not_before_date.setter
    def not_before_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "not_before_date", value)

    @property
    @pulumi.getter(name="publicKeyOpenssh")
    def public_key_openssh(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OpenSSH encoded public key of this Key Vault Key.
        """
        return pulumi.get(self, "public_key_openssh")

    @public_key_openssh.setter
    def public_key_openssh(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_key_openssh", value)

    @property
    @pulumi.getter(name="publicKeyPem")
    def public_key_pem(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PEM encoded public key of this Key Vault Key.
        """
        return pulumi.get(self, "public_key_pem")

    @public_key_pem.setter
    def public_key_pem(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_key_pem", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The (Versioned) ID for this Key Vault Key. This property points to a specific version of a Key Vault Key, as such using this won't auto-rotate values if used in other Azure Services.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceVersionlessId")
    def resource_versionless_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Versionless ID of the Key Vault Key. This property allows other Azure Services (that support it) to auto-rotate their value when the Key Vault Key is updated.
        """
        return pulumi.get(self, "resource_versionless_id")

    @resource_versionless_id.setter
    def resource_versionless_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_versionless_id", value)

    @property
    @pulumi.getter(name="rotationPolicy")
    def rotation_policy(self) -> Optional[pulumi.Input['KeyRotationPolicyArgs']]:
        """
        A `rotation_policy` block as defined below.
        """
        return pulumi.get(self, "rotation_policy")

    @rotation_policy.setter
    def rotation_policy(self, value: Optional[pulumi.Input['KeyRotationPolicyArgs']]):
        pulumi.set(self, "rotation_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current version of the Key Vault Key.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="versionlessId")
    def versionless_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Base ID of the Key Vault Key.
        """
        return pulumi.get(self, "versionless_id")

    @versionless_id.setter
    def versionless_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "versionless_id", value)

    @property
    @pulumi.getter
    def x(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The EC X component of this Key Vault Key.
        """
        return pulumi.get(self, "x")

    @x.setter
    def x(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "x", value)

    @property
    @pulumi.getter
    def y(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The EC Y component of this Key Vault Key.
        """
        return pulumi.get(self, "y")

    @y.setter
    def y(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "y", value)


@pulumi.type_token("azure:keyvault/key:Key")
class Key(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 curve: Optional[pulumi.Input[builtins.str]] = None,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 key_opts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 key_size: Optional[pulumi.Input[builtins.int]] = None,
                 key_type: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 not_before_date: Optional[pulumi.Input[builtins.str]] = None,
                 rotation_policy: Optional[pulumi.Input[Union['KeyRotationPolicyArgs', 'KeyRotationPolicyArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Key Vault Key.

        ## Example Usage

        > **Note:** To use this resource, your client should have RBAC roles with permissions like `Key Vault Crypto Officer` or `Key Vault Administrator` or an assigned Key Vault Access Policy with permissions `Create`,`Delete`,`Get`,`Purge`,`Recover`,`Update` and `GetRotationPolicy` for keys without Rotation Policy. Include `SetRotationPolicy` for keys with Rotation Policy.

        > **Note:** The Azure Provider includes a Feature Toggle which will purge a Key Vault Key resource on destroy, rather than the default soft-delete. See `purge_soft_deleted_keys_on_destroy` for more information.

        ### Additional Examples

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            soft_delete_retention_days=7,
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "key_permissions": [
                    "Create",
                    "Delete",
                    "Get",
                    "Purge",
                    "Recover",
                    "Update",
                    "GetRotationPolicy",
                    "SetRotationPolicy",
                ],
                "secret_permissions": ["Set"],
            }])
        generated = azure.keyvault.Key("generated",
            name="generated-certificate",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            rotation_policy={
                "automatic": {
                    "time_before_expiry": "P30D",
                },
                "expire_after": "P90D",
                "notify_before_expiry": "P29D",
            })
        ```

        ## Import

        Key Vault Key which is Enabled can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/key:Key example "https://example-keyvault.vault.azure.net/keys/example/fdf067c93bbb4b22bff4d8b7a9a56217"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] curve: Specifies the curve to use when creating an `EC` key. Possible values are `P-256`, `P-256K`, `P-384`, and `P-521`. This field will be required in a future release if `key_type` is `EC` or `EC-HSM`. The API will default to `P-256` if nothing is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] expiration_date: Expiration UTC datetime (Y-m-d'T'H:M:S'Z').
               
               > **Note:** Removing this field from the config forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] key_opts: A list of JSON web key operations. Possible values include: `decrypt`, `encrypt`, `sign`, `unwrapKey`, `verify` and `wrapKey`. Please note these values are case sensitive.
        :param pulumi.Input[builtins.int] key_size: Specifies the Size of the RSA key to create in bytes. For example, 1024 or 2048. *Note*: This field is required if `key_type` is `RSA` or `RSA-HSM`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_type: Specifies the Key Type to use for this Key Vault Key. Possible values are `EC` (Elliptic Curve), `EC-HSM`, `RSA` and `RSA-HSM`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_vault_id: The ID of the Key Vault where the Key should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Key Vault Key. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] not_before_date: Key not usable before the provided UTC datetime (Y-m-d'T'H:M:S'Z').
               
               > **Note:** Once `expiration_date` is set, it's not possible to unset the key even if it is deleted & recreated as underlying Azure API uses the restore of the purged key.
        :param pulumi.Input[Union['KeyRotationPolicyArgs', 'KeyRotationPolicyArgsDict']] rotation_policy: A `rotation_policy` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Key Vault Key.

        ## Example Usage

        > **Note:** To use this resource, your client should have RBAC roles with permissions like `Key Vault Crypto Officer` or `Key Vault Administrator` or an assigned Key Vault Access Policy with permissions `Create`,`Delete`,`Get`,`Purge`,`Recover`,`Update` and `GetRotationPolicy` for keys without Rotation Policy. Include `SetRotationPolicy` for keys with Rotation Policy.

        > **Note:** The Azure Provider includes a Feature Toggle which will purge a Key Vault Key resource on destroy, rather than the default soft-delete. See `purge_soft_deleted_keys_on_destroy` for more information.

        ### Additional Examples

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            soft_delete_retention_days=7,
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "key_permissions": [
                    "Create",
                    "Delete",
                    "Get",
                    "Purge",
                    "Recover",
                    "Update",
                    "GetRotationPolicy",
                    "SetRotationPolicy",
                ],
                "secret_permissions": ["Set"],
            }])
        generated = azure.keyvault.Key("generated",
            name="generated-certificate",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            rotation_policy={
                "automatic": {
                    "time_before_expiry": "P30D",
                },
                "expire_after": "P90D",
                "notify_before_expiry": "P29D",
            })
        ```

        ## Import

        Key Vault Key which is Enabled can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/key:Key example "https://example-keyvault.vault.azure.net/keys/example/fdf067c93bbb4b22bff4d8b7a9a56217"
        ```

        :param str resource_name: The name of the resource.
        :param KeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 curve: Optional[pulumi.Input[builtins.str]] = None,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 key_opts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 key_size: Optional[pulumi.Input[builtins.int]] = None,
                 key_type: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 not_before_date: Optional[pulumi.Input[builtins.str]] = None,
                 rotation_policy: Optional[pulumi.Input[Union['KeyRotationPolicyArgs', 'KeyRotationPolicyArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyArgs.__new__(KeyArgs)

            __props__.__dict__["curve"] = curve
            __props__.__dict__["expiration_date"] = expiration_date
            if key_opts is None and not opts.urn:
                raise TypeError("Missing required property 'key_opts'")
            __props__.__dict__["key_opts"] = key_opts
            __props__.__dict__["key_size"] = key_size
            if key_type is None and not opts.urn:
                raise TypeError("Missing required property 'key_type'")
            __props__.__dict__["key_type"] = key_type
            if key_vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_vault_id'")
            __props__.__dict__["key_vault_id"] = key_vault_id
            __props__.__dict__["name"] = name
            __props__.__dict__["not_before_date"] = not_before_date
            __props__.__dict__["rotation_policy"] = rotation_policy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["e"] = None
            __props__.__dict__["n"] = None
            __props__.__dict__["public_key_openssh"] = None
            __props__.__dict__["public_key_pem"] = None
            __props__.__dict__["resource_id"] = None
            __props__.__dict__["resource_versionless_id"] = None
            __props__.__dict__["version"] = None
            __props__.__dict__["versionless_id"] = None
            __props__.__dict__["x"] = None
            __props__.__dict__["y"] = None
        super(Key, __self__).__init__(
            'azure:keyvault/key:Key',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            curve: Optional[pulumi.Input[builtins.str]] = None,
            e: Optional[pulumi.Input[builtins.str]] = None,
            expiration_date: Optional[pulumi.Input[builtins.str]] = None,
            key_opts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            key_size: Optional[pulumi.Input[builtins.int]] = None,
            key_type: Optional[pulumi.Input[builtins.str]] = None,
            key_vault_id: Optional[pulumi.Input[builtins.str]] = None,
            n: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            not_before_date: Optional[pulumi.Input[builtins.str]] = None,
            public_key_openssh: Optional[pulumi.Input[builtins.str]] = None,
            public_key_pem: Optional[pulumi.Input[builtins.str]] = None,
            resource_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_versionless_id: Optional[pulumi.Input[builtins.str]] = None,
            rotation_policy: Optional[pulumi.Input[Union['KeyRotationPolicyArgs', 'KeyRotationPolicyArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None,
            versionless_id: Optional[pulumi.Input[builtins.str]] = None,
            x: Optional[pulumi.Input[builtins.str]] = None,
            y: Optional[pulumi.Input[builtins.str]] = None) -> 'Key':
        """
        Get an existing Key resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] curve: Specifies the curve to use when creating an `EC` key. Possible values are `P-256`, `P-256K`, `P-384`, and `P-521`. This field will be required in a future release if `key_type` is `EC` or `EC-HSM`. The API will default to `P-256` if nothing is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] e: The RSA public exponent of this Key Vault Key.
        :param pulumi.Input[builtins.str] expiration_date: Expiration UTC datetime (Y-m-d'T'H:M:S'Z').
               
               > **Note:** Removing this field from the config forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] key_opts: A list of JSON web key operations. Possible values include: `decrypt`, `encrypt`, `sign`, `unwrapKey`, `verify` and `wrapKey`. Please note these values are case sensitive.
        :param pulumi.Input[builtins.int] key_size: Specifies the Size of the RSA key to create in bytes. For example, 1024 or 2048. *Note*: This field is required if `key_type` is `RSA` or `RSA-HSM`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_type: Specifies the Key Type to use for this Key Vault Key. Possible values are `EC` (Elliptic Curve), `EC-HSM`, `RSA` and `RSA-HSM`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_vault_id: The ID of the Key Vault where the Key should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] n: The RSA modulus of this Key Vault Key.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Key Vault Key. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] not_before_date: Key not usable before the provided UTC datetime (Y-m-d'T'H:M:S'Z').
               
               > **Note:** Once `expiration_date` is set, it's not possible to unset the key even if it is deleted & recreated as underlying Azure API uses the restore of the purged key.
        :param pulumi.Input[builtins.str] public_key_openssh: The OpenSSH encoded public key of this Key Vault Key.
        :param pulumi.Input[builtins.str] public_key_pem: The PEM encoded public key of this Key Vault Key.
        :param pulumi.Input[builtins.str] resource_id: The (Versioned) ID for this Key Vault Key. This property points to a specific version of a Key Vault Key, as such using this won't auto-rotate values if used in other Azure Services.
        :param pulumi.Input[builtins.str] resource_versionless_id: The Versionless ID of the Key Vault Key. This property allows other Azure Services (that support it) to auto-rotate their value when the Key Vault Key is updated.
        :param pulumi.Input[Union['KeyRotationPolicyArgs', 'KeyRotationPolicyArgsDict']] rotation_policy: A `rotation_policy` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] version: The current version of the Key Vault Key.
        :param pulumi.Input[builtins.str] versionless_id: The Base ID of the Key Vault Key.
        :param pulumi.Input[builtins.str] x: The EC X component of this Key Vault Key.
        :param pulumi.Input[builtins.str] y: The EC Y component of this Key Vault Key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyState.__new__(_KeyState)

        __props__.__dict__["curve"] = curve
        __props__.__dict__["e"] = e
        __props__.__dict__["expiration_date"] = expiration_date
        __props__.__dict__["key_opts"] = key_opts
        __props__.__dict__["key_size"] = key_size
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["key_vault_id"] = key_vault_id
        __props__.__dict__["n"] = n
        __props__.__dict__["name"] = name
        __props__.__dict__["not_before_date"] = not_before_date
        __props__.__dict__["public_key_openssh"] = public_key_openssh
        __props__.__dict__["public_key_pem"] = public_key_pem
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["resource_versionless_id"] = resource_versionless_id
        __props__.__dict__["rotation_policy"] = rotation_policy
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        __props__.__dict__["versionless_id"] = versionless_id
        __props__.__dict__["x"] = x
        __props__.__dict__["y"] = y
        return Key(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def curve(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the curve to use when creating an `EC` key. Possible values are `P-256`, `P-256K`, `P-384`, and `P-521`. This field will be required in a future release if `key_type` is `EC` or `EC-HSM`. The API will default to `P-256` if nothing is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "curve")

    @property
    @pulumi.getter
    def e(self) -> pulumi.Output[builtins.str]:
        """
        The RSA public exponent of this Key Vault Key.
        """
        return pulumi.get(self, "e")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Expiration UTC datetime (Y-m-d'T'H:M:S'Z').

        > **Note:** Removing this field from the config forces a new resource to be created.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="keyOpts")
    def key_opts(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of JSON web key operations. Possible values include: `decrypt`, `encrypt`, `sign`, `unwrapKey`, `verify` and `wrapKey`. Please note these values are case sensitive.
        """
        return pulumi.get(self, "key_opts")

    @property
    @pulumi.getter(name="keySize")
    def key_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the Size of the RSA key to create in bytes. For example, 1024 or 2048. *Note*: This field is required if `key_type` is `RSA` or `RSA-HSM`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_size")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Key Type to use for this Key Vault Key. Possible values are `EC` (Elliptic Curve), `EC-HSM`, `RSA` and `RSA-HSM`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Key Vault where the Key should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter
    def n(self) -> pulumi.Output[builtins.str]:
        """
        The RSA modulus of this Key Vault Key.
        """
        return pulumi.get(self, "n")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Key Vault Key. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notBeforeDate")
    def not_before_date(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Key not usable before the provided UTC datetime (Y-m-d'T'H:M:S'Z').

        > **Note:** Once `expiration_date` is set, it's not possible to unset the key even if it is deleted & recreated as underlying Azure API uses the restore of the purged key.
        """
        return pulumi.get(self, "not_before_date")

    @property
    @pulumi.getter(name="publicKeyOpenssh")
    def public_key_openssh(self) -> pulumi.Output[builtins.str]:
        """
        The OpenSSH encoded public key of this Key Vault Key.
        """
        return pulumi.get(self, "public_key_openssh")

    @property
    @pulumi.getter(name="publicKeyPem")
    def public_key_pem(self) -> pulumi.Output[builtins.str]:
        """
        The PEM encoded public key of this Key Vault Key.
        """
        return pulumi.get(self, "public_key_pem")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The (Versioned) ID for this Key Vault Key. This property points to a specific version of a Key Vault Key, as such using this won't auto-rotate values if used in other Azure Services.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceVersionlessId")
    def resource_versionless_id(self) -> pulumi.Output[builtins.str]:
        """
        The Versionless ID of the Key Vault Key. This property allows other Azure Services (that support it) to auto-rotate their value when the Key Vault Key is updated.
        """
        return pulumi.get(self, "resource_versionless_id")

    @property
    @pulumi.getter(name="rotationPolicy")
    def rotation_policy(self) -> pulumi.Output[Optional['outputs.KeyRotationPolicy']]:
        """
        A `rotation_policy` block as defined below.
        """
        return pulumi.get(self, "rotation_policy")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        The current version of the Key Vault Key.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="versionlessId")
    def versionless_id(self) -> pulumi.Output[builtins.str]:
        """
        The Base ID of the Key Vault Key.
        """
        return pulumi.get(self, "versionless_id")

    @property
    @pulumi.getter
    def x(self) -> pulumi.Output[builtins.str]:
        """
        The EC X component of this Key Vault Key.
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> pulumi.Output[builtins.str]:
        """
        The EC Y component of this Key Vault Key.
        """
        return pulumi.get(self, "y")

