# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NatRuleArgs', 'NatRule']

@pulumi.input_type
class NatRuleArgs:
    def __init__(__self__, *,
                 backend_port: pulumi.Input[builtins.int],
                 frontend_ip_configuration_name: pulumi.Input[builtins.str],
                 loadbalancer_id: pulumi.Input[builtins.str],
                 protocol: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 backend_address_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_floating_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[builtins.bool]] = None,
                 frontend_port: Optional[pulumi.Input[builtins.int]] = None,
                 frontend_port_end: Optional[pulumi.Input[builtins.int]] = None,
                 frontend_port_start: Optional[pulumi.Input[builtins.int]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NatRule resource.
        :param pulumi.Input[builtins.int] backend_port: The port used for internal connections on the endpoint. Possible values range between 1 and 65535, inclusive.
        :param pulumi.Input[builtins.str] frontend_ip_configuration_name: The name of the frontend IP configuration exposing this rule.
        :param pulumi.Input[builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the NAT Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] protocol: The transport protocol for the external endpoint. Possible values are `Udp`, `Tcp` or `All`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] backend_address_pool_id: Specifies a reference to backendAddressPool resource.
        :param pulumi.Input[builtins.bool] enable_floating_ip: Are the Floating IPs enabled for this Load Balancer Rule? A "floating” IP is reassigned to a secondary server in case the primary server fails. Required to configure a SQL AlwaysOn Availability Group. Defaults to `false`.
        :param pulumi.Input[builtins.bool] enable_tcp_reset: Is TCP Reset enabled for this Load Balancer Rule?
        :param pulumi.Input[builtins.int] frontend_port: The port for the external endpoint. Port numbers for each Rule must be unique within the Load Balancer. Possible values range between 1 and 65534, inclusive.
        :param pulumi.Input[builtins.int] frontend_port_end: The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534, inclusive.
        :param pulumi.Input[builtins.int] frontend_port_start: The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534, inclusive.
        :param pulumi.Input[builtins.int] idle_timeout_in_minutes: Specifies the idle timeout in minutes for TCP connections. Valid values are between `4` and `30` minutes. Defaults to `4` minutes.
        :param pulumi.Input[builtins.str] name: Specifies the name of the NAT Rule. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_ip_configuration_name", frontend_ip_configuration_name)
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if backend_address_pool_id is not None:
            pulumi.set(__self__, "backend_address_pool_id", backend_address_pool_id)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if frontend_port_end is not None:
            pulumi.set(__self__, "frontend_port_end", frontend_port_end)
        if frontend_port_start is not None:
            pulumi.set(__self__, "frontend_port_start", frontend_port_start)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> pulumi.Input[builtins.int]:
        """
        The port used for internal connections on the endpoint. Possible values range between 1 and 65535, inclusive.
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="frontendIpConfigurationName")
    def frontend_ip_configuration_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the frontend IP configuration exposing this rule.
        """
        return pulumi.get(self, "frontend_ip_configuration_name")

    @frontend_ip_configuration_name.setter
    def frontend_ip_configuration_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "frontend_ip_configuration_name", value)

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Load Balancer in which to create the NAT Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "loadbalancer_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        The transport protocol for the external endpoint. Possible values are `Udp`, `Tcp` or `All`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="backendAddressPoolId")
    def backend_address_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a reference to backendAddressPool resource.
        """
        return pulumi.get(self, "backend_address_pool_id")

    @backend_address_pool_id.setter
    def backend_address_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backend_address_pool_id", value)

    @property
    @pulumi.getter(name="enableFloatingIp")
    def enable_floating_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Are the Floating IPs enabled for this Load Balancer Rule? A "floating” IP is reassigned to a secondary server in case the primary server fails. Required to configure a SQL AlwaysOn Availability Group. Defaults to `false`.
        """
        return pulumi.get(self, "enable_floating_ip")

    @enable_floating_ip.setter
    def enable_floating_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_floating_ip", value)

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is TCP Reset enabled for this Load Balancer Rule?
        """
        return pulumi.get(self, "enable_tcp_reset")

    @enable_tcp_reset.setter
    def enable_tcp_reset(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_tcp_reset", value)

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port for the external endpoint. Port numbers for each Rule must be unique within the Load Balancer. Possible values range between 1 and 65534, inclusive.
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "frontend_port", value)

    @property
    @pulumi.getter(name="frontendPortEnd")
    def frontend_port_end(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534, inclusive.
        """
        return pulumi.get(self, "frontend_port_end")

    @frontend_port_end.setter
    def frontend_port_end(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "frontend_port_end", value)

    @property
    @pulumi.getter(name="frontendPortStart")
    def frontend_port_start(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534, inclusive.
        """
        return pulumi.get(self, "frontend_port_start")

    @frontend_port_start.setter
    def frontend_port_start(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "frontend_port_start", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the idle timeout in minutes for TCP connections. Valid values are between `4` and `30` minutes. Defaults to `4` minutes.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the NAT Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NatRuleState:
    def __init__(__self__, *,
                 backend_address_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 backend_ip_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 backend_port: Optional[pulumi.Input[builtins.int]] = None,
                 enable_floating_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[builtins.bool]] = None,
                 frontend_ip_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_ip_configuration_name: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_port: Optional[pulumi.Input[builtins.int]] = None,
                 frontend_port_end: Optional[pulumi.Input[builtins.int]] = None,
                 frontend_port_start: Optional[pulumi.Input[builtins.int]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 loadbalancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NatRule resources.
        :param pulumi.Input[builtins.str] backend_address_pool_id: Specifies a reference to backendAddressPool resource.
        :param pulumi.Input[builtins.int] backend_port: The port used for internal connections on the endpoint. Possible values range between 1 and 65535, inclusive.
        :param pulumi.Input[builtins.bool] enable_floating_ip: Are the Floating IPs enabled for this Load Balancer Rule? A "floating” IP is reassigned to a secondary server in case the primary server fails. Required to configure a SQL AlwaysOn Availability Group. Defaults to `false`.
        :param pulumi.Input[builtins.bool] enable_tcp_reset: Is TCP Reset enabled for this Load Balancer Rule?
        :param pulumi.Input[builtins.str] frontend_ip_configuration_name: The name of the frontend IP configuration exposing this rule.
        :param pulumi.Input[builtins.int] frontend_port: The port for the external endpoint. Port numbers for each Rule must be unique within the Load Balancer. Possible values range between 1 and 65534, inclusive.
        :param pulumi.Input[builtins.int] frontend_port_end: The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534, inclusive.
        :param pulumi.Input[builtins.int] frontend_port_start: The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534, inclusive.
        :param pulumi.Input[builtins.int] idle_timeout_in_minutes: Specifies the idle timeout in minutes for TCP connections. Valid values are between `4` and `30` minutes. Defaults to `4` minutes.
        :param pulumi.Input[builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the NAT Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the NAT Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] protocol: The transport protocol for the external endpoint. Possible values are `Udp`, `Tcp` or `All`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        """
        if backend_address_pool_id is not None:
            pulumi.set(__self__, "backend_address_pool_id", backend_address_pool_id)
        if backend_ip_configuration_id is not None:
            pulumi.set(__self__, "backend_ip_configuration_id", backend_ip_configuration_id)
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if frontend_ip_configuration_id is not None:
            pulumi.set(__self__, "frontend_ip_configuration_id", frontend_ip_configuration_id)
        if frontend_ip_configuration_name is not None:
            pulumi.set(__self__, "frontend_ip_configuration_name", frontend_ip_configuration_name)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if frontend_port_end is not None:
            pulumi.set(__self__, "frontend_port_end", frontend_port_end)
        if frontend_port_start is not None:
            pulumi.set(__self__, "frontend_port_start", frontend_port_start)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if loadbalancer_id is not None:
            pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @property
    @pulumi.getter(name="backendAddressPoolId")
    def backend_address_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a reference to backendAddressPool resource.
        """
        return pulumi.get(self, "backend_address_pool_id")

    @backend_address_pool_id.setter
    def backend_address_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backend_address_pool_id", value)

    @property
    @pulumi.getter(name="backendIpConfigurationId")
    def backend_ip_configuration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "backend_ip_configuration_id")

    @backend_ip_configuration_id.setter
    def backend_ip_configuration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backend_ip_configuration_id", value)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port used for internal connections on the endpoint. Possible values range between 1 and 65535, inclusive.
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="enableFloatingIp")
    def enable_floating_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Are the Floating IPs enabled for this Load Balancer Rule? A "floating” IP is reassigned to a secondary server in case the primary server fails. Required to configure a SQL AlwaysOn Availability Group. Defaults to `false`.
        """
        return pulumi.get(self, "enable_floating_ip")

    @enable_floating_ip.setter
    def enable_floating_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_floating_ip", value)

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is TCP Reset enabled for this Load Balancer Rule?
        """
        return pulumi.get(self, "enable_tcp_reset")

    @enable_tcp_reset.setter
    def enable_tcp_reset(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_tcp_reset", value)

    @property
    @pulumi.getter(name="frontendIpConfigurationId")
    def frontend_ip_configuration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "frontend_ip_configuration_id")

    @frontend_ip_configuration_id.setter
    def frontend_ip_configuration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frontend_ip_configuration_id", value)

    @property
    @pulumi.getter(name="frontendIpConfigurationName")
    def frontend_ip_configuration_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the frontend IP configuration exposing this rule.
        """
        return pulumi.get(self, "frontend_ip_configuration_name")

    @frontend_ip_configuration_name.setter
    def frontend_ip_configuration_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frontend_ip_configuration_name", value)

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port for the external endpoint. Port numbers for each Rule must be unique within the Load Balancer. Possible values range between 1 and 65534, inclusive.
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "frontend_port", value)

    @property
    @pulumi.getter(name="frontendPortEnd")
    def frontend_port_end(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534, inclusive.
        """
        return pulumi.get(self, "frontend_port_end")

    @frontend_port_end.setter
    def frontend_port_end(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "frontend_port_end", value)

    @property
    @pulumi.getter(name="frontendPortStart")
    def frontend_port_start(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534, inclusive.
        """
        return pulumi.get(self, "frontend_port_start")

    @frontend_port_start.setter
    def frontend_port_start(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "frontend_port_start", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the idle timeout in minutes for TCP connections. Valid values are between `4` and `30` minutes. Defaults to `4` minutes.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Load Balancer in which to create the NAT Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "loadbalancer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the NAT Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The transport protocol for the external endpoint. Possible values are `Udp`, `Tcp` or `All`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:lb/natRule:NatRule")
class NatRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_address_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 backend_port: Optional[pulumi.Input[builtins.int]] = None,
                 enable_floating_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[builtins.bool]] = None,
                 frontend_ip_configuration_name: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_port: Optional[pulumi.Input[builtins.int]] = None,
                 frontend_port_end: Optional[pulumi.Input[builtins.int]] = None,
                 frontend_port_start: Optional[pulumi.Input[builtins.int]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 loadbalancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Load Balancer NAT Rule.

        > **Note:** This resource cannot be used with with virtual machine scale sets, instead use the `lb.NatPool` resource.

        > **Note:** When using this resource, the Load Balancer needs to have a FrontEnd IP Configuration Attached

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="LoadBalancerRG",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="PublicIPForLB",
            location="West US",
            resource_group_name=example.name,
            allocation_method="Static")
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="TestLoadBalancer",
            location="West US",
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": "PublicIPAddress",
                "public_ip_address_id": example_public_ip.id,
            }])
        example_backend_address_pool = azure.lb.BackendAddressPool("example",
            loadbalancer_id=example_load_balancer.id,
            name="be")
        example_nat_rule = azure.lb.NatRule("example",
            resource_group_name=example.name,
            loadbalancer_id=example_load_balancer.id,
            name="RDPAccess",
            protocol="Tcp",
            frontend_port=3389,
            backend_port=3389,
            frontend_ip_configuration_name="PublicIPAddress")
        example1 = azure.lb.NatRule("example1",
            resource_group_name=example.name,
            loadbalancer_id=example_load_balancer.id,
            name="RDPAccess",
            protocol="Tcp",
            frontend_port_start=3000,
            frontend_port_end=3389,
            backend_port=3389,
            backend_address_pool_id=example_backend_address_pool.id,
            frontend_ip_configuration_name="PublicIPAddress")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2023-09-01

        ## Import

        Load Balancer NAT Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:lb/natRule:NatRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/loadBalancers/lb1/inboundNatRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backend_address_pool_id: Specifies a reference to backendAddressPool resource.
        :param pulumi.Input[builtins.int] backend_port: The port used for internal connections on the endpoint. Possible values range between 1 and 65535, inclusive.
        :param pulumi.Input[builtins.bool] enable_floating_ip: Are the Floating IPs enabled for this Load Balancer Rule? A "floating” IP is reassigned to a secondary server in case the primary server fails. Required to configure a SQL AlwaysOn Availability Group. Defaults to `false`.
        :param pulumi.Input[builtins.bool] enable_tcp_reset: Is TCP Reset enabled for this Load Balancer Rule?
        :param pulumi.Input[builtins.str] frontend_ip_configuration_name: The name of the frontend IP configuration exposing this rule.
        :param pulumi.Input[builtins.int] frontend_port: The port for the external endpoint. Port numbers for each Rule must be unique within the Load Balancer. Possible values range between 1 and 65534, inclusive.
        :param pulumi.Input[builtins.int] frontend_port_end: The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534, inclusive.
        :param pulumi.Input[builtins.int] frontend_port_start: The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534, inclusive.
        :param pulumi.Input[builtins.int] idle_timeout_in_minutes: Specifies the idle timeout in minutes for TCP connections. Valid values are between `4` and `30` minutes. Defaults to `4` minutes.
        :param pulumi.Input[builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the NAT Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the NAT Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] protocol: The transport protocol for the external endpoint. Possible values are `Udp`, `Tcp` or `All`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NatRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Load Balancer NAT Rule.

        > **Note:** This resource cannot be used with with virtual machine scale sets, instead use the `lb.NatPool` resource.

        > **Note:** When using this resource, the Load Balancer needs to have a FrontEnd IP Configuration Attached

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="LoadBalancerRG",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="PublicIPForLB",
            location="West US",
            resource_group_name=example.name,
            allocation_method="Static")
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="TestLoadBalancer",
            location="West US",
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": "PublicIPAddress",
                "public_ip_address_id": example_public_ip.id,
            }])
        example_backend_address_pool = azure.lb.BackendAddressPool("example",
            loadbalancer_id=example_load_balancer.id,
            name="be")
        example_nat_rule = azure.lb.NatRule("example",
            resource_group_name=example.name,
            loadbalancer_id=example_load_balancer.id,
            name="RDPAccess",
            protocol="Tcp",
            frontend_port=3389,
            backend_port=3389,
            frontend_ip_configuration_name="PublicIPAddress")
        example1 = azure.lb.NatRule("example1",
            resource_group_name=example.name,
            loadbalancer_id=example_load_balancer.id,
            name="RDPAccess",
            protocol="Tcp",
            frontend_port_start=3000,
            frontend_port_end=3389,
            backend_port=3389,
            backend_address_pool_id=example_backend_address_pool.id,
            frontend_ip_configuration_name="PublicIPAddress")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2023-09-01

        ## Import

        Load Balancer NAT Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:lb/natRule:NatRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/loadBalancers/lb1/inboundNatRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param NatRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NatRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_address_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 backend_port: Optional[pulumi.Input[builtins.int]] = None,
                 enable_floating_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[builtins.bool]] = None,
                 frontend_ip_configuration_name: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_port: Optional[pulumi.Input[builtins.int]] = None,
                 frontend_port_end: Optional[pulumi.Input[builtins.int]] = None,
                 frontend_port_start: Optional[pulumi.Input[builtins.int]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 loadbalancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NatRuleArgs.__new__(NatRuleArgs)

            __props__.__dict__["backend_address_pool_id"] = backend_address_pool_id
            if backend_port is None and not opts.urn:
                raise TypeError("Missing required property 'backend_port'")
            __props__.__dict__["backend_port"] = backend_port
            __props__.__dict__["enable_floating_ip"] = enable_floating_ip
            __props__.__dict__["enable_tcp_reset"] = enable_tcp_reset
            if frontend_ip_configuration_name is None and not opts.urn:
                raise TypeError("Missing required property 'frontend_ip_configuration_name'")
            __props__.__dict__["frontend_ip_configuration_name"] = frontend_ip_configuration_name
            __props__.__dict__["frontend_port"] = frontend_port
            __props__.__dict__["frontend_port_end"] = frontend_port_end
            __props__.__dict__["frontend_port_start"] = frontend_port_start
            __props__.__dict__["idle_timeout_in_minutes"] = idle_timeout_in_minutes
            if loadbalancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'loadbalancer_id'")
            __props__.__dict__["loadbalancer_id"] = loadbalancer_id
            __props__.__dict__["name"] = name
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["backend_ip_configuration_id"] = None
            __props__.__dict__["frontend_ip_configuration_id"] = None
        super(NatRule, __self__).__init__(
            'azure:lb/natRule:NatRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend_address_pool_id: Optional[pulumi.Input[builtins.str]] = None,
            backend_ip_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
            backend_port: Optional[pulumi.Input[builtins.int]] = None,
            enable_floating_ip: Optional[pulumi.Input[builtins.bool]] = None,
            enable_tcp_reset: Optional[pulumi.Input[builtins.bool]] = None,
            frontend_ip_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
            frontend_ip_configuration_name: Optional[pulumi.Input[builtins.str]] = None,
            frontend_port: Optional[pulumi.Input[builtins.int]] = None,
            frontend_port_end: Optional[pulumi.Input[builtins.int]] = None,
            frontend_port_start: Optional[pulumi.Input[builtins.int]] = None,
            idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
            loadbalancer_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None) -> 'NatRule':
        """
        Get an existing NatRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backend_address_pool_id: Specifies a reference to backendAddressPool resource.
        :param pulumi.Input[builtins.int] backend_port: The port used for internal connections on the endpoint. Possible values range between 1 and 65535, inclusive.
        :param pulumi.Input[builtins.bool] enable_floating_ip: Are the Floating IPs enabled for this Load Balancer Rule? A "floating” IP is reassigned to a secondary server in case the primary server fails. Required to configure a SQL AlwaysOn Availability Group. Defaults to `false`.
        :param pulumi.Input[builtins.bool] enable_tcp_reset: Is TCP Reset enabled for this Load Balancer Rule?
        :param pulumi.Input[builtins.str] frontend_ip_configuration_name: The name of the frontend IP configuration exposing this rule.
        :param pulumi.Input[builtins.int] frontend_port: The port for the external endpoint. Port numbers for each Rule must be unique within the Load Balancer. Possible values range between 1 and 65534, inclusive.
        :param pulumi.Input[builtins.int] frontend_port_end: The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534, inclusive.
        :param pulumi.Input[builtins.int] frontend_port_start: The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534, inclusive.
        :param pulumi.Input[builtins.int] idle_timeout_in_minutes: Specifies the idle timeout in minutes for TCP connections. Valid values are between `4` and `30` minutes. Defaults to `4` minutes.
        :param pulumi.Input[builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the NAT Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the NAT Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] protocol: The transport protocol for the external endpoint. Possible values are `Udp`, `Tcp` or `All`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NatRuleState.__new__(_NatRuleState)

        __props__.__dict__["backend_address_pool_id"] = backend_address_pool_id
        __props__.__dict__["backend_ip_configuration_id"] = backend_ip_configuration_id
        __props__.__dict__["backend_port"] = backend_port
        __props__.__dict__["enable_floating_ip"] = enable_floating_ip
        __props__.__dict__["enable_tcp_reset"] = enable_tcp_reset
        __props__.__dict__["frontend_ip_configuration_id"] = frontend_ip_configuration_id
        __props__.__dict__["frontend_ip_configuration_name"] = frontend_ip_configuration_name
        __props__.__dict__["frontend_port"] = frontend_port
        __props__.__dict__["frontend_port_end"] = frontend_port_end
        __props__.__dict__["frontend_port_start"] = frontend_port_start
        __props__.__dict__["idle_timeout_in_minutes"] = idle_timeout_in_minutes
        __props__.__dict__["loadbalancer_id"] = loadbalancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["resource_group_name"] = resource_group_name
        return NatRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backendAddressPoolId")
    def backend_address_pool_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies a reference to backendAddressPool resource.
        """
        return pulumi.get(self, "backend_address_pool_id")

    @property
    @pulumi.getter(name="backendIpConfigurationId")
    def backend_ip_configuration_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "backend_ip_configuration_id")

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> pulumi.Output[builtins.int]:
        """
        The port used for internal connections on the endpoint. Possible values range between 1 and 65535, inclusive.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="enableFloatingIp")
    def enable_floating_ip(self) -> pulumi.Output[builtins.bool]:
        """
        Are the Floating IPs enabled for this Load Balancer Rule? A "floating” IP is reassigned to a secondary server in case the primary server fails. Required to configure a SQL AlwaysOn Availability Group. Defaults to `false`.
        """
        return pulumi.get(self, "enable_floating_ip")

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is TCP Reset enabled for this Load Balancer Rule?
        """
        return pulumi.get(self, "enable_tcp_reset")

    @property
    @pulumi.getter(name="frontendIpConfigurationId")
    def frontend_ip_configuration_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "frontend_ip_configuration_id")

    @property
    @pulumi.getter(name="frontendIpConfigurationName")
    def frontend_ip_configuration_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the frontend IP configuration exposing this rule.
        """
        return pulumi.get(self, "frontend_ip_configuration_name")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The port for the external endpoint. Port numbers for each Rule must be unique within the Load Balancer. Possible values range between 1 and 65534, inclusive.
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter(name="frontendPortEnd")
    def frontend_port_end(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534, inclusive.
        """
        return pulumi.get(self, "frontend_port_end")

    @property
    @pulumi.getter(name="frontendPortStart")
    def frontend_port_start(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534, inclusive.
        """
        return pulumi.get(self, "frontend_port_start")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the idle timeout in minutes for TCP connections. Valid values are between `4` and `30` minutes. Defaults to `4` minutes.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Load Balancer in which to create the NAT Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the NAT Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        The transport protocol for the external endpoint. Possible values are `Udp`, `Tcp` or `All`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

