# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BackendAddressPoolAddressInboundNatRulePortMapping',
    'BackendAddressPoolTunnelInterface',
    'LoadBalancerFrontendIpConfiguration',
    'OutboundRuleFrontendIpConfiguration',
    'GetBackendAddressPoolBackendAddressResult',
    'GetBackendAddressPoolBackendAddressInboundNatRulePortMappingResult',
    'GetBackendAddressPoolBackendIpConfigurationResult',
    'GetLBFrontendIpConfigurationResult',
    'GetLBOutboundRuleFrontendIpConfigurationResult',
]

@pulumi.output_type
class BackendAddressPoolAddressInboundNatRulePortMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPort":
            suggest = "backend_port"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "inboundNatRuleName":
            suggest = "inbound_nat_rule_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendAddressPoolAddressInboundNatRulePortMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendAddressPoolAddressInboundNatRulePortMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendAddressPoolAddressInboundNatRulePortMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_port: Optional[builtins.int] = None,
                 frontend_port: Optional[builtins.int] = None,
                 inbound_nat_rule_name: Optional[builtins.str] = None):
        """
        :param builtins.int backend_port: The Backend Port of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool Address.
        :param builtins.int frontend_port: The Frontend Port of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool Address.
        :param builtins.str inbound_nat_rule_name: The name of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool Address.
        """
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if inbound_nat_rule_name is not None:
            pulumi.set(__self__, "inbound_nat_rule_name", inbound_nat_rule_name)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[builtins.int]:
        """
        The Backend Port of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool Address.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional[builtins.int]:
        """
        The Frontend Port of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool Address.
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter(name="inboundNatRuleName")
    def inbound_nat_rule_name(self) -> Optional[builtins.str]:
        """
        The name of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool Address.
        """
        return pulumi.get(self, "inbound_nat_rule_name")


@pulumi.output_type
class BackendAddressPoolTunnelInterface(dict):
    def __init__(__self__, *,
                 identifier: builtins.int,
                 port: builtins.int,
                 protocol: builtins.str,
                 type: builtins.str):
        """
        :param builtins.int identifier: The unique identifier of this Gateway Load Balancer Tunnel Interface.
        :param builtins.int port: The port number that this Gateway Load Balancer Tunnel Interface listens to.
        :param builtins.str protocol: The protocol used for this Gateway Load Balancer Tunnel Interface. Possible values are `None`, `Native` and `VXLAN`.
        :param builtins.str type: The traffic type of this Gateway Load Balancer Tunnel Interface. Possible values are `None`, `Internal` and `External`.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def identifier(self) -> builtins.int:
        """
        The unique identifier of this Gateway Load Balancer Tunnel Interface.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port number that this Gateway Load Balancer Tunnel Interface listens to.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        The protocol used for this Gateway Load Balancer Tunnel Interface. Possible values are `None`, `Native` and `VXLAN`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The traffic type of this Gateway Load Balancer Tunnel Interface. Possible values are `None`, `Internal` and `External`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LoadBalancerFrontendIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gatewayLoadBalancerFrontendIpConfigurationId":
            suggest = "gateway_load_balancer_frontend_ip_configuration_id"
        elif key == "inboundNatRules":
            suggest = "inbound_nat_rules"
        elif key == "loadBalancerRules":
            suggest = "load_balancer_rules"
        elif key == "outboundRules":
            suggest = "outbound_rules"
        elif key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "privateIpAddressAllocation":
            suggest = "private_ip_address_allocation"
        elif key == "privateIpAddressVersion":
            suggest = "private_ip_address_version"
        elif key == "publicIpAddressId":
            suggest = "public_ip_address_id"
        elif key == "publicIpPrefixId":
            suggest = "public_ip_prefix_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerFrontendIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerFrontendIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerFrontendIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 gateway_load_balancer_frontend_ip_configuration_id: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 inbound_nat_rules: Optional[Sequence[builtins.str]] = None,
                 load_balancer_rules: Optional[Sequence[builtins.str]] = None,
                 outbound_rules: Optional[Sequence[builtins.str]] = None,
                 private_ip_address: Optional[builtins.str] = None,
                 private_ip_address_allocation: Optional[builtins.str] = None,
                 private_ip_address_version: Optional[builtins.str] = None,
                 public_ip_address_id: Optional[builtins.str] = None,
                 public_ip_prefix_id: Optional[builtins.str] = None,
                 subnet_id: Optional[builtins.str] = None,
                 zones: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: Specifies the name of the frontend IP configuration.
        :param builtins.str gateway_load_balancer_frontend_ip_configuration_id: The Frontend IP Configuration ID of a Gateway SKU Load Balancer.
        :param builtins.str id: The id of the Frontend IP Configuration.
        :param Sequence[builtins.str] inbound_nat_rules: The list of IDs of inbound rules that use this frontend IP.
        :param Sequence[builtins.str] load_balancer_rules: The list of IDs of load balancing rules that use this frontend IP.
        :param Sequence[builtins.str] outbound_rules: The list of IDs outbound rules that use this frontend IP.
        :param builtins.str private_ip_address: Private IP Address to assign to the Load Balancer. The last one and first four IPs in any range are reserved and cannot be manually assigned.
        :param builtins.str private_ip_address_allocation: The allocation method for the Private IP Address used by this Load Balancer. Possible values as `Dynamic` and `Static`.
        :param builtins.str private_ip_address_version: The version of IP that the Private IP Address is. Possible values are `IPv4` or `IPv6`.
        :param builtins.str public_ip_address_id: The ID of a Public IP Address which should be associated with the Load Balancer.
        :param builtins.str public_ip_prefix_id: The ID of a Public IP Prefix which should be associated with the Load Balancer. Public IP Prefix can only be used with outbound rules.
        :param builtins.str subnet_id: The ID of the Subnet which should be associated with the IP Configuration.
        :param Sequence[builtins.str] zones: Specifies a list of Availability Zones in which the IP Address for this Load Balancer should be located.
               
               > **Note:** Availability Zones are only supported with a [Standard SKU](https://docs.microsoft.com/azure/load-balancer/load-balancer-standard-availability-zones) and [in select regions](https://docs.microsoft.com/azure/availability-zones/az-overview) at this time.
        """
        pulumi.set(__self__, "name", name)
        if gateway_load_balancer_frontend_ip_configuration_id is not None:
            pulumi.set(__self__, "gateway_load_balancer_frontend_ip_configuration_id", gateway_load_balancer_frontend_ip_configuration_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if inbound_nat_rules is not None:
            pulumi.set(__self__, "inbound_nat_rules", inbound_nat_rules)
        if load_balancer_rules is not None:
            pulumi.set(__self__, "load_balancer_rules", load_balancer_rules)
        if outbound_rules is not None:
            pulumi.set(__self__, "outbound_rules", outbound_rules)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_address_allocation is not None:
            pulumi.set(__self__, "private_ip_address_allocation", private_ip_address_allocation)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)
        if public_ip_address_id is not None:
            pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        if public_ip_prefix_id is not None:
            pulumi.set(__self__, "public_ip_prefix_id", public_ip_prefix_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the name of the frontend IP configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="gatewayLoadBalancerFrontendIpConfigurationId")
    def gateway_load_balancer_frontend_ip_configuration_id(self) -> Optional[builtins.str]:
        """
        The Frontend IP Configuration ID of a Gateway SKU Load Balancer.
        """
        return pulumi.get(self, "gateway_load_balancer_frontend_ip_configuration_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The id of the Frontend IP Configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inboundNatRules")
    def inbound_nat_rules(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of IDs of inbound rules that use this frontend IP.
        """
        return pulumi.get(self, "inbound_nat_rules")

    @property
    @pulumi.getter(name="loadBalancerRules")
    def load_balancer_rules(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of IDs of load balancing rules that use this frontend IP.
        """
        return pulumi.get(self, "load_balancer_rules")

    @property
    @pulumi.getter(name="outboundRules")
    def outbound_rules(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of IDs outbound rules that use this frontend IP.
        """
        return pulumi.get(self, "outbound_rules")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[builtins.str]:
        """
        Private IP Address to assign to the Load Balancer. The last one and first four IPs in any range are reserved and cannot be manually assigned.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIpAddressAllocation")
    def private_ip_address_allocation(self) -> Optional[builtins.str]:
        """
        The allocation method for the Private IP Address used by this Load Balancer. Possible values as `Dynamic` and `Static`.
        """
        return pulumi.get(self, "private_ip_address_allocation")

    @property
    @pulumi.getter(name="privateIpAddressVersion")
    def private_ip_address_version(self) -> Optional[builtins.str]:
        """
        The version of IP that the Private IP Address is. Possible values are `IPv4` or `IPv6`.
        """
        return pulumi.get(self, "private_ip_address_version")

    @property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> Optional[builtins.str]:
        """
        The ID of a Public IP Address which should be associated with the Load Balancer.
        """
        return pulumi.get(self, "public_ip_address_id")

    @property
    @pulumi.getter(name="publicIpPrefixId")
    def public_ip_prefix_id(self) -> Optional[builtins.str]:
        """
        The ID of a Public IP Prefix which should be associated with the Load Balancer. Public IP Prefix can only be used with outbound rules.
        """
        return pulumi.get(self, "public_ip_prefix_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[builtins.str]:
        """
        The ID of the Subnet which should be associated with the IP Configuration.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of Availability Zones in which the IP Address for this Load Balancer should be located.

        > **Note:** Availability Zones are only supported with a [Standard SKU](https://docs.microsoft.com/azure/load-balancer/load-balancer-standard-availability-zones) and [in select regions](https://docs.microsoft.com/azure/availability-zones/az-overview) at this time.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class OutboundRuleFrontendIpConfiguration(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the Frontend IP Configuration.
        :param builtins.str id: The ID of the Load Balancer Outbound Rule.
        """
        pulumi.set(__self__, "name", name)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Frontend IP Configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Load Balancer Outbound Rule.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetBackendAddressPoolBackendAddressResult(dict):
    def __init__(__self__, *,
                 inbound_nat_rule_port_mappings: Sequence['outputs.GetBackendAddressPoolBackendAddressInboundNatRulePortMappingResult'],
                 ip_address: builtins.str,
                 name: builtins.str,
                 virtual_network_id: builtins.str):
        """
        :param Sequence['GetBackendAddressPoolBackendAddressInboundNatRulePortMappingArgs'] inbound_nat_rule_port_mappings: A list of `inbound_nat_rule_port_mapping` block as defined below.
        :param builtins.str ip_address: The Static IP address for this Load Balancer within the Virtual Network.
        :param builtins.str name: Specifies the name of the Backend Address Pool.
        :param builtins.str virtual_network_id: The ID of the Virtual Network where the Backend Address of the Load Balancer exists.
        """
        pulumi.set(__self__, "inbound_nat_rule_port_mappings", inbound_nat_rule_port_mappings)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @property
    @pulumi.getter(name="inboundNatRulePortMappings")
    def inbound_nat_rule_port_mappings(self) -> Sequence['outputs.GetBackendAddressPoolBackendAddressInboundNatRulePortMappingResult']:
        """
        A list of `inbound_nat_rule_port_mapping` block as defined below.
        """
        return pulumi.get(self, "inbound_nat_rule_port_mappings")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        The Static IP address for this Load Balancer within the Virtual Network.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the name of the Backend Address Pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> builtins.str:
        """
        The ID of the Virtual Network where the Backend Address of the Load Balancer exists.
        """
        return pulumi.get(self, "virtual_network_id")


@pulumi.output_type
class GetBackendAddressPoolBackendAddressInboundNatRulePortMappingResult(dict):
    def __init__(__self__, *,
                 backend_port: builtins.int,
                 frontend_port: builtins.int,
                 inbound_nat_rule_name: builtins.str):
        """
        :param builtins.int backend_port: The Backend Port of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool Address.
        :param builtins.int frontend_port: The Frontend Port of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool Address.
        :param builtins.str inbound_nat_rule_name: The name of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool Address.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "inbound_nat_rule_name", inbound_nat_rule_name)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> builtins.int:
        """
        The Backend Port of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool Address.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> builtins.int:
        """
        The Frontend Port of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool Address.
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter(name="inboundNatRuleName")
    def inbound_nat_rule_name(self) -> builtins.str:
        """
        The name of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool Address.
        """
        return pulumi.get(self, "inbound_nat_rule_name")


@pulumi.output_type
class GetBackendAddressPoolBackendIpConfigurationResult(dict):
    def __init__(__self__, *,
                 id: builtins.str):
        """
        :param builtins.str id: The ID of the Backend Address Pool.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Backend Address Pool.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetLBFrontendIpConfigurationResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 name: builtins.str,
                 private_ip_address: builtins.str,
                 private_ip_address_allocation: builtins.str,
                 private_ip_address_version: builtins.str,
                 public_ip_address_id: builtins.str,
                 subnet_id: builtins.str,
                 zones: Sequence[builtins.str]):
        """
        :param builtins.str id: The id of the Frontend IP Configuration.
        :param builtins.str name: Specifies the name of the Load Balancer.
        :param builtins.str private_ip_address: Private IP Address to assign to the Load Balancer.
        :param builtins.str private_ip_address_allocation: The allocation method for the Private IP Address used by this Load Balancer.
        :param builtins.str private_ip_address_version: The Private IP Address Version, either `IPv4` or `IPv6`.
        :param builtins.str public_ip_address_id: The ID of a  Public IP Address which is associated with this Load Balancer.
        :param builtins.str subnet_id: The ID of the Subnet which is associated with the IP Configuration.
        :param Sequence[builtins.str] zones: A list of Availability Zones which the Load Balancer's IP Addresses should be created in.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "private_ip_address_allocation", private_ip_address_allocation)
        pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)
        pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the Frontend IP Configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the name of the Load Balancer.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> builtins.str:
        """
        Private IP Address to assign to the Load Balancer.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIpAddressAllocation")
    def private_ip_address_allocation(self) -> builtins.str:
        """
        The allocation method for the Private IP Address used by this Load Balancer.
        """
        return pulumi.get(self, "private_ip_address_allocation")

    @property
    @pulumi.getter(name="privateIpAddressVersion")
    def private_ip_address_version(self) -> builtins.str:
        """
        The Private IP Address Version, either `IPv4` or `IPv6`.
        """
        return pulumi.get(self, "private_ip_address_version")

    @property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> builtins.str:
        """
        The ID of a  Public IP Address which is associated with this Load Balancer.
        """
        return pulumi.get(self, "public_ip_address_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The ID of the Subnet which is associated with the IP Configuration.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def zones(self) -> Sequence[builtins.str]:
        """
        A list of Availability Zones which the Load Balancer's IP Addresses should be created in.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class GetLBOutboundRuleFrontendIpConfigurationResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str id: The ID of the Frontend IP Configuration.
        :param builtins.str name: The name of this Load Balancer Outbound Rule.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Frontend IP Configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of this Load Balancer Outbound Rule.
        """
        return pulumi.get(self, "name")


