# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 backend_port: pulumi.Input[builtins.int],
                 frontend_ip_configuration_name: pulumi.Input[builtins.str],
                 frontend_port: pulumi.Input[builtins.int],
                 loadbalancer_id: pulumi.Input[builtins.str],
                 protocol: pulumi.Input[builtins.str],
                 backend_address_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 disable_outbound_snat: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_floating_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[builtins.bool]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 load_distribution: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 probe_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input[builtins.int] backend_port: The port used for internal connections on the endpoint. Possible values range between 0 and 65535, inclusive. A port of `0` means "Any Port".
        :param pulumi.Input[builtins.str] frontend_ip_configuration_name: The name of the frontend IP configuration to which the rule is associated.
        :param pulumi.Input[builtins.int] frontend_port: The port for the external endpoint. Port numbers for each Rule must be unique within the Load Balancer. Possible values range between 0 and 65534, inclusive. A port of `0` means "Any Port".
        :param pulumi.Input[builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] protocol: The transport protocol for the external endpoint. Possible values are `Tcp`, `Udp` or `All`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backend_address_pool_ids: A list of reference to a Backend Address Pool over which this Load Balancing Rule operates.
               
               > **Note:** In most cases users can only set one Backend Address Pool ID in the `backend_address_pool_ids`. Especially, when the sku of the LB is `Gateway`, users can set up to two IDs in the `backend_address_pool_ids`.
        :param pulumi.Input[builtins.bool] disable_outbound_snat: Is snat enabled for this Load Balancer Rule? Default `false`.
        :param pulumi.Input[builtins.bool] enable_floating_ip: Are the Floating IPs enabled for this Load Balancer Rule? A "floating” IP is reassigned to a secondary server in case the primary server fails. Required to configure a SQL AlwaysOn Availability Group. Defaults to `false`.
        :param pulumi.Input[builtins.bool] enable_tcp_reset: Is TCP Reset enabled for this Load Balancer Rule?
        :param pulumi.Input[builtins.int] idle_timeout_in_minutes: Specifies the idle timeout in minutes for TCP connections. Valid values are between `4` and `100` minutes. Defaults to `4` minutes.
        :param pulumi.Input[builtins.str] load_distribution: Specifies the load balancing distribution type to be used by the Load Balancer. Possible values are: `Default` – The load balancer is configured to use a 5 tuple hash to map traffic to available servers. `SourceIP` – The load balancer is configured to use a 2 tuple hash to map traffic to available servers. `SourceIPProtocol` – The load balancer is configured to use a 3 tuple hash to map traffic to available servers. Also known as Session Persistence, where in the Azure portal the options are called `None`, `Client IP` and `Client IP and Protocol` respectively. Defaults to `Default`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the LB Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] probe_id: A reference to a Probe used by this Load Balancing Rule.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_ip_configuration_name", frontend_ip_configuration_name)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        pulumi.set(__self__, "protocol", protocol)
        if backend_address_pool_ids is not None:
            pulumi.set(__self__, "backend_address_pool_ids", backend_address_pool_ids)
        if disable_outbound_snat is not None:
            pulumi.set(__self__, "disable_outbound_snat", disable_outbound_snat)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if load_distribution is not None:
            pulumi.set(__self__, "load_distribution", load_distribution)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if probe_id is not None:
            pulumi.set(__self__, "probe_id", probe_id)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> pulumi.Input[builtins.int]:
        """
        The port used for internal connections on the endpoint. Possible values range between 0 and 65535, inclusive. A port of `0` means "Any Port".
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="frontendIpConfigurationName")
    def frontend_ip_configuration_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the frontend IP configuration to which the rule is associated.
        """
        return pulumi.get(self, "frontend_ip_configuration_name")

    @frontend_ip_configuration_name.setter
    def frontend_ip_configuration_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "frontend_ip_configuration_name", value)

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> pulumi.Input[builtins.int]:
        """
        The port for the external endpoint. Port numbers for each Rule must be unique within the Load Balancer. Possible values range between 0 and 65534, inclusive. A port of `0` means "Any Port".
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "frontend_port", value)

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Load Balancer in which to create the Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "loadbalancer_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        The transport protocol for the external endpoint. Possible values are `Tcp`, `Udp` or `All`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="backendAddressPoolIds")
    def backend_address_pool_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of reference to a Backend Address Pool over which this Load Balancing Rule operates.

        > **Note:** In most cases users can only set one Backend Address Pool ID in the `backend_address_pool_ids`. Especially, when the sku of the LB is `Gateway`, users can set up to two IDs in the `backend_address_pool_ids`.
        """
        return pulumi.get(self, "backend_address_pool_ids")

    @backend_address_pool_ids.setter
    def backend_address_pool_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "backend_address_pool_ids", value)

    @property
    @pulumi.getter(name="disableOutboundSnat")
    def disable_outbound_snat(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is snat enabled for this Load Balancer Rule? Default `false`.
        """
        return pulumi.get(self, "disable_outbound_snat")

    @disable_outbound_snat.setter
    def disable_outbound_snat(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_outbound_snat", value)

    @property
    @pulumi.getter(name="enableFloatingIp")
    def enable_floating_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Are the Floating IPs enabled for this Load Balancer Rule? A "floating” IP is reassigned to a secondary server in case the primary server fails. Required to configure a SQL AlwaysOn Availability Group. Defaults to `false`.
        """
        return pulumi.get(self, "enable_floating_ip")

    @enable_floating_ip.setter
    def enable_floating_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_floating_ip", value)

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is TCP Reset enabled for this Load Balancer Rule?
        """
        return pulumi.get(self, "enable_tcp_reset")

    @enable_tcp_reset.setter
    def enable_tcp_reset(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_tcp_reset", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the idle timeout in minutes for TCP connections. Valid values are between `4` and `100` minutes. Defaults to `4` minutes.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="loadDistribution")
    def load_distribution(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the load balancing distribution type to be used by the Load Balancer. Possible values are: `Default` – The load balancer is configured to use a 5 tuple hash to map traffic to available servers. `SourceIP` – The load balancer is configured to use a 2 tuple hash to map traffic to available servers. `SourceIPProtocol` – The load balancer is configured to use a 3 tuple hash to map traffic to available servers. Also known as Session Persistence, where in the Azure portal the options are called `None`, `Client IP` and `Client IP and Protocol` respectively. Defaults to `Default`.
        """
        return pulumi.get(self, "load_distribution")

    @load_distribution.setter
    def load_distribution(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "load_distribution", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the LB Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="probeId")
    def probe_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to a Probe used by this Load Balancing Rule.
        """
        return pulumi.get(self, "probe_id")

    @probe_id.setter
    def probe_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "probe_id", value)


@pulumi.input_type
class _RuleState:
    def __init__(__self__, *,
                 backend_address_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 backend_port: Optional[pulumi.Input[builtins.int]] = None,
                 disable_outbound_snat: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_floating_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[builtins.bool]] = None,
                 frontend_ip_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_ip_configuration_name: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_port: Optional[pulumi.Input[builtins.int]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 load_distribution: Optional[pulumi.Input[builtins.str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 probe_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Rule resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backend_address_pool_ids: A list of reference to a Backend Address Pool over which this Load Balancing Rule operates.
               
               > **Note:** In most cases users can only set one Backend Address Pool ID in the `backend_address_pool_ids`. Especially, when the sku of the LB is `Gateway`, users can set up to two IDs in the `backend_address_pool_ids`.
        :param pulumi.Input[builtins.int] backend_port: The port used for internal connections on the endpoint. Possible values range between 0 and 65535, inclusive. A port of `0` means "Any Port".
        :param pulumi.Input[builtins.bool] disable_outbound_snat: Is snat enabled for this Load Balancer Rule? Default `false`.
        :param pulumi.Input[builtins.bool] enable_floating_ip: Are the Floating IPs enabled for this Load Balancer Rule? A "floating” IP is reassigned to a secondary server in case the primary server fails. Required to configure a SQL AlwaysOn Availability Group. Defaults to `false`.
        :param pulumi.Input[builtins.bool] enable_tcp_reset: Is TCP Reset enabled for this Load Balancer Rule?
        :param pulumi.Input[builtins.str] frontend_ip_configuration_name: The name of the frontend IP configuration to which the rule is associated.
        :param pulumi.Input[builtins.int] frontend_port: The port for the external endpoint. Port numbers for each Rule must be unique within the Load Balancer. Possible values range between 0 and 65534, inclusive. A port of `0` means "Any Port".
        :param pulumi.Input[builtins.int] idle_timeout_in_minutes: Specifies the idle timeout in minutes for TCP connections. Valid values are between `4` and `100` minutes. Defaults to `4` minutes.
        :param pulumi.Input[builtins.str] load_distribution: Specifies the load balancing distribution type to be used by the Load Balancer. Possible values are: `Default` – The load balancer is configured to use a 5 tuple hash to map traffic to available servers. `SourceIP` – The load balancer is configured to use a 2 tuple hash to map traffic to available servers. `SourceIPProtocol` – The load balancer is configured to use a 3 tuple hash to map traffic to available servers. Also known as Session Persistence, where in the Azure portal the options are called `None`, `Client IP` and `Client IP and Protocol` respectively. Defaults to `Default`.
        :param pulumi.Input[builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the LB Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] probe_id: A reference to a Probe used by this Load Balancing Rule.
        :param pulumi.Input[builtins.str] protocol: The transport protocol for the external endpoint. Possible values are `Tcp`, `Udp` or `All`.
        """
        if backend_address_pool_ids is not None:
            pulumi.set(__self__, "backend_address_pool_ids", backend_address_pool_ids)
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if disable_outbound_snat is not None:
            pulumi.set(__self__, "disable_outbound_snat", disable_outbound_snat)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if frontend_ip_configuration_id is not None:
            pulumi.set(__self__, "frontend_ip_configuration_id", frontend_ip_configuration_id)
        if frontend_ip_configuration_name is not None:
            pulumi.set(__self__, "frontend_ip_configuration_name", frontend_ip_configuration_name)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if load_distribution is not None:
            pulumi.set(__self__, "load_distribution", load_distribution)
        if loadbalancer_id is not None:
            pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if probe_id is not None:
            pulumi.set(__self__, "probe_id", probe_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="backendAddressPoolIds")
    def backend_address_pool_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of reference to a Backend Address Pool over which this Load Balancing Rule operates.

        > **Note:** In most cases users can only set one Backend Address Pool ID in the `backend_address_pool_ids`. Especially, when the sku of the LB is `Gateway`, users can set up to two IDs in the `backend_address_pool_ids`.
        """
        return pulumi.get(self, "backend_address_pool_ids")

    @backend_address_pool_ids.setter
    def backend_address_pool_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "backend_address_pool_ids", value)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port used for internal connections on the endpoint. Possible values range between 0 and 65535, inclusive. A port of `0` means "Any Port".
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="disableOutboundSnat")
    def disable_outbound_snat(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is snat enabled for this Load Balancer Rule? Default `false`.
        """
        return pulumi.get(self, "disable_outbound_snat")

    @disable_outbound_snat.setter
    def disable_outbound_snat(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_outbound_snat", value)

    @property
    @pulumi.getter(name="enableFloatingIp")
    def enable_floating_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Are the Floating IPs enabled for this Load Balancer Rule? A "floating” IP is reassigned to a secondary server in case the primary server fails. Required to configure a SQL AlwaysOn Availability Group. Defaults to `false`.
        """
        return pulumi.get(self, "enable_floating_ip")

    @enable_floating_ip.setter
    def enable_floating_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_floating_ip", value)

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is TCP Reset enabled for this Load Balancer Rule?
        """
        return pulumi.get(self, "enable_tcp_reset")

    @enable_tcp_reset.setter
    def enable_tcp_reset(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_tcp_reset", value)

    @property
    @pulumi.getter(name="frontendIpConfigurationId")
    def frontend_ip_configuration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "frontend_ip_configuration_id")

    @frontend_ip_configuration_id.setter
    def frontend_ip_configuration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frontend_ip_configuration_id", value)

    @property
    @pulumi.getter(name="frontendIpConfigurationName")
    def frontend_ip_configuration_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the frontend IP configuration to which the rule is associated.
        """
        return pulumi.get(self, "frontend_ip_configuration_name")

    @frontend_ip_configuration_name.setter
    def frontend_ip_configuration_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frontend_ip_configuration_name", value)

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port for the external endpoint. Port numbers for each Rule must be unique within the Load Balancer. Possible values range between 0 and 65534, inclusive. A port of `0` means "Any Port".
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "frontend_port", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the idle timeout in minutes for TCP connections. Valid values are between `4` and `100` minutes. Defaults to `4` minutes.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="loadDistribution")
    def load_distribution(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the load balancing distribution type to be used by the Load Balancer. Possible values are: `Default` – The load balancer is configured to use a 5 tuple hash to map traffic to available servers. `SourceIP` – The load balancer is configured to use a 2 tuple hash to map traffic to available servers. `SourceIPProtocol` – The load balancer is configured to use a 3 tuple hash to map traffic to available servers. Also known as Session Persistence, where in the Azure portal the options are called `None`, `Client IP` and `Client IP and Protocol` respectively. Defaults to `Default`.
        """
        return pulumi.get(self, "load_distribution")

    @load_distribution.setter
    def load_distribution(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "load_distribution", value)

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Load Balancer in which to create the Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "loadbalancer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the LB Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="probeId")
    def probe_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A reference to a Probe used by this Load Balancing Rule.
        """
        return pulumi.get(self, "probe_id")

    @probe_id.setter
    def probe_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "probe_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The transport protocol for the external endpoint. Possible values are `Tcp`, `Udp` or `All`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)


@pulumi.type_token("azure:lb/rule:Rule")
class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_address_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 backend_port: Optional[pulumi.Input[builtins.int]] = None,
                 disable_outbound_snat: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_floating_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[builtins.bool]] = None,
                 frontend_ip_configuration_name: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_port: Optional[pulumi.Input[builtins.int]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 load_distribution: Optional[pulumi.Input[builtins.str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 probe_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Load Balancer Rule.

        > **Note:** When using this resource, the Load Balancer needs to have a FrontEnd IP Configuration Attached

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="LoadBalancerRG",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="PublicIPForLB",
            location="West US",
            resource_group_name=example.name,
            allocation_method="Static")
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="TestLoadBalancer",
            location="West US",
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": "PublicIPAddress",
                "public_ip_address_id": example_public_ip.id,
            }])
        example_rule = azure.lb.Rule("example",
            loadbalancer_id=example_load_balancer.id,
            name="LBRule",
            protocol="Tcp",
            frontend_port=3389,
            backend_port=3389,
            frontend_ip_configuration_name="PublicIPAddress")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2023-09-01

        ## Import

        Load Balancer Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:lb/rule:Rule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/loadBalancers/lb1/loadBalancingRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backend_address_pool_ids: A list of reference to a Backend Address Pool over which this Load Balancing Rule operates.
               
               > **Note:** In most cases users can only set one Backend Address Pool ID in the `backend_address_pool_ids`. Especially, when the sku of the LB is `Gateway`, users can set up to two IDs in the `backend_address_pool_ids`.
        :param pulumi.Input[builtins.int] backend_port: The port used for internal connections on the endpoint. Possible values range between 0 and 65535, inclusive. A port of `0` means "Any Port".
        :param pulumi.Input[builtins.bool] disable_outbound_snat: Is snat enabled for this Load Balancer Rule? Default `false`.
        :param pulumi.Input[builtins.bool] enable_floating_ip: Are the Floating IPs enabled for this Load Balancer Rule? A "floating” IP is reassigned to a secondary server in case the primary server fails. Required to configure a SQL AlwaysOn Availability Group. Defaults to `false`.
        :param pulumi.Input[builtins.bool] enable_tcp_reset: Is TCP Reset enabled for this Load Balancer Rule?
        :param pulumi.Input[builtins.str] frontend_ip_configuration_name: The name of the frontend IP configuration to which the rule is associated.
        :param pulumi.Input[builtins.int] frontend_port: The port for the external endpoint. Port numbers for each Rule must be unique within the Load Balancer. Possible values range between 0 and 65534, inclusive. A port of `0` means "Any Port".
        :param pulumi.Input[builtins.int] idle_timeout_in_minutes: Specifies the idle timeout in minutes for TCP connections. Valid values are between `4` and `100` minutes. Defaults to `4` minutes.
        :param pulumi.Input[builtins.str] load_distribution: Specifies the load balancing distribution type to be used by the Load Balancer. Possible values are: `Default` – The load balancer is configured to use a 5 tuple hash to map traffic to available servers. `SourceIP` – The load balancer is configured to use a 2 tuple hash to map traffic to available servers. `SourceIPProtocol` – The load balancer is configured to use a 3 tuple hash to map traffic to available servers. Also known as Session Persistence, where in the Azure portal the options are called `None`, `Client IP` and `Client IP and Protocol` respectively. Defaults to `Default`.
        :param pulumi.Input[builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the LB Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] probe_id: A reference to a Probe used by this Load Balancing Rule.
        :param pulumi.Input[builtins.str] protocol: The transport protocol for the external endpoint. Possible values are `Tcp`, `Udp` or `All`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Load Balancer Rule.

        > **Note:** When using this resource, the Load Balancer needs to have a FrontEnd IP Configuration Attached

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="LoadBalancerRG",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="PublicIPForLB",
            location="West US",
            resource_group_name=example.name,
            allocation_method="Static")
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="TestLoadBalancer",
            location="West US",
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": "PublicIPAddress",
                "public_ip_address_id": example_public_ip.id,
            }])
        example_rule = azure.lb.Rule("example",
            loadbalancer_id=example_load_balancer.id,
            name="LBRule",
            protocol="Tcp",
            frontend_port=3389,
            backend_port=3389,
            frontend_ip_configuration_name="PublicIPAddress")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2023-09-01

        ## Import

        Load Balancer Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:lb/rule:Rule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/loadBalancers/lb1/loadBalancingRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_address_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 backend_port: Optional[pulumi.Input[builtins.int]] = None,
                 disable_outbound_snat: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_floating_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[builtins.bool]] = None,
                 frontend_ip_configuration_name: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_port: Optional[pulumi.Input[builtins.int]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 load_distribution: Optional[pulumi.Input[builtins.str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 probe_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            __props__.__dict__["backend_address_pool_ids"] = backend_address_pool_ids
            if backend_port is None and not opts.urn:
                raise TypeError("Missing required property 'backend_port'")
            __props__.__dict__["backend_port"] = backend_port
            __props__.__dict__["disable_outbound_snat"] = disable_outbound_snat
            __props__.__dict__["enable_floating_ip"] = enable_floating_ip
            __props__.__dict__["enable_tcp_reset"] = enable_tcp_reset
            if frontend_ip_configuration_name is None and not opts.urn:
                raise TypeError("Missing required property 'frontend_ip_configuration_name'")
            __props__.__dict__["frontend_ip_configuration_name"] = frontend_ip_configuration_name
            if frontend_port is None and not opts.urn:
                raise TypeError("Missing required property 'frontend_port'")
            __props__.__dict__["frontend_port"] = frontend_port
            __props__.__dict__["idle_timeout_in_minutes"] = idle_timeout_in_minutes
            __props__.__dict__["load_distribution"] = load_distribution
            if loadbalancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'loadbalancer_id'")
            __props__.__dict__["loadbalancer_id"] = loadbalancer_id
            __props__.__dict__["name"] = name
            __props__.__dict__["probe_id"] = probe_id
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["frontend_ip_configuration_id"] = None
        super(Rule, __self__).__init__(
            'azure:lb/rule:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend_address_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            backend_port: Optional[pulumi.Input[builtins.int]] = None,
            disable_outbound_snat: Optional[pulumi.Input[builtins.bool]] = None,
            enable_floating_ip: Optional[pulumi.Input[builtins.bool]] = None,
            enable_tcp_reset: Optional[pulumi.Input[builtins.bool]] = None,
            frontend_ip_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
            frontend_ip_configuration_name: Optional[pulumi.Input[builtins.str]] = None,
            frontend_port: Optional[pulumi.Input[builtins.int]] = None,
            idle_timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
            load_distribution: Optional[pulumi.Input[builtins.str]] = None,
            loadbalancer_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            probe_id: Optional[pulumi.Input[builtins.str]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backend_address_pool_ids: A list of reference to a Backend Address Pool over which this Load Balancing Rule operates.
               
               > **Note:** In most cases users can only set one Backend Address Pool ID in the `backend_address_pool_ids`. Especially, when the sku of the LB is `Gateway`, users can set up to two IDs in the `backend_address_pool_ids`.
        :param pulumi.Input[builtins.int] backend_port: The port used for internal connections on the endpoint. Possible values range between 0 and 65535, inclusive. A port of `0` means "Any Port".
        :param pulumi.Input[builtins.bool] disable_outbound_snat: Is snat enabled for this Load Balancer Rule? Default `false`.
        :param pulumi.Input[builtins.bool] enable_floating_ip: Are the Floating IPs enabled for this Load Balancer Rule? A "floating” IP is reassigned to a secondary server in case the primary server fails. Required to configure a SQL AlwaysOn Availability Group. Defaults to `false`.
        :param pulumi.Input[builtins.bool] enable_tcp_reset: Is TCP Reset enabled for this Load Balancer Rule?
        :param pulumi.Input[builtins.str] frontend_ip_configuration_name: The name of the frontend IP configuration to which the rule is associated.
        :param pulumi.Input[builtins.int] frontend_port: The port for the external endpoint. Port numbers for each Rule must be unique within the Load Balancer. Possible values range between 0 and 65534, inclusive. A port of `0` means "Any Port".
        :param pulumi.Input[builtins.int] idle_timeout_in_minutes: Specifies the idle timeout in minutes for TCP connections. Valid values are between `4` and `100` minutes. Defaults to `4` minutes.
        :param pulumi.Input[builtins.str] load_distribution: Specifies the load balancing distribution type to be used by the Load Balancer. Possible values are: `Default` – The load balancer is configured to use a 5 tuple hash to map traffic to available servers. `SourceIP` – The load balancer is configured to use a 2 tuple hash to map traffic to available servers. `SourceIPProtocol` – The load balancer is configured to use a 3 tuple hash to map traffic to available servers. Also known as Session Persistence, where in the Azure portal the options are called `None`, `Client IP` and `Client IP and Protocol` respectively. Defaults to `Default`.
        :param pulumi.Input[builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the LB Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] probe_id: A reference to a Probe used by this Load Balancing Rule.
        :param pulumi.Input[builtins.str] protocol: The transport protocol for the external endpoint. Possible values are `Tcp`, `Udp` or `All`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleState.__new__(_RuleState)

        __props__.__dict__["backend_address_pool_ids"] = backend_address_pool_ids
        __props__.__dict__["backend_port"] = backend_port
        __props__.__dict__["disable_outbound_snat"] = disable_outbound_snat
        __props__.__dict__["enable_floating_ip"] = enable_floating_ip
        __props__.__dict__["enable_tcp_reset"] = enable_tcp_reset
        __props__.__dict__["frontend_ip_configuration_id"] = frontend_ip_configuration_id
        __props__.__dict__["frontend_ip_configuration_name"] = frontend_ip_configuration_name
        __props__.__dict__["frontend_port"] = frontend_port
        __props__.__dict__["idle_timeout_in_minutes"] = idle_timeout_in_minutes
        __props__.__dict__["load_distribution"] = load_distribution
        __props__.__dict__["loadbalancer_id"] = loadbalancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["probe_id"] = probe_id
        __props__.__dict__["protocol"] = protocol
        return Rule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backendAddressPoolIds")
    def backend_address_pool_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of reference to a Backend Address Pool over which this Load Balancing Rule operates.

        > **Note:** In most cases users can only set one Backend Address Pool ID in the `backend_address_pool_ids`. Especially, when the sku of the LB is `Gateway`, users can set up to two IDs in the `backend_address_pool_ids`.
        """
        return pulumi.get(self, "backend_address_pool_ids")

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> pulumi.Output[builtins.int]:
        """
        The port used for internal connections on the endpoint. Possible values range between 0 and 65535, inclusive. A port of `0` means "Any Port".
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="disableOutboundSnat")
    def disable_outbound_snat(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is snat enabled for this Load Balancer Rule? Default `false`.
        """
        return pulumi.get(self, "disable_outbound_snat")

    @property
    @pulumi.getter(name="enableFloatingIp")
    def enable_floating_ip(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Are the Floating IPs enabled for this Load Balancer Rule? A "floating” IP is reassigned to a secondary server in case the primary server fails. Required to configure a SQL AlwaysOn Availability Group. Defaults to `false`.
        """
        return pulumi.get(self, "enable_floating_ip")

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is TCP Reset enabled for this Load Balancer Rule?
        """
        return pulumi.get(self, "enable_tcp_reset")

    @property
    @pulumi.getter(name="frontendIpConfigurationId")
    def frontend_ip_configuration_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "frontend_ip_configuration_id")

    @property
    @pulumi.getter(name="frontendIpConfigurationName")
    def frontend_ip_configuration_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the frontend IP configuration to which the rule is associated.
        """
        return pulumi.get(self, "frontend_ip_configuration_name")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> pulumi.Output[builtins.int]:
        """
        The port for the external endpoint. Port numbers for each Rule must be unique within the Load Balancer. Possible values range between 0 and 65534, inclusive. A port of `0` means "Any Port".
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the idle timeout in minutes for TCP connections. Valid values are between `4` and `100` minutes. Defaults to `4` minutes.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="loadDistribution")
    def load_distribution(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the load balancing distribution type to be used by the Load Balancer. Possible values are: `Default` – The load balancer is configured to use a 5 tuple hash to map traffic to available servers. `SourceIP` – The load balancer is configured to use a 2 tuple hash to map traffic to available servers. `SourceIPProtocol` – The load balancer is configured to use a 3 tuple hash to map traffic to available servers. Also known as Session Persistence, where in the Azure portal the options are called `None`, `Client IP` and `Client IP and Protocol` respectively. Defaults to `Default`.
        """
        return pulumi.get(self, "load_distribution")

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Load Balancer in which to create the Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the LB Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="probeId")
    def probe_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A reference to a Probe used by this Load Balancing Rule.
        """
        return pulumi.get(self, "probe_id")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        The transport protocol for the external endpoint. Possible values are `Tcp`, `Udp` or `All`.
        """
        return pulumi.get(self, "protocol")

