# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadTestArgs', 'LoadTest']

@pulumi.input_type
class LoadTestArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption: Optional[pulumi.Input['LoadTestEncryptionArgs']] = None,
                 identity: Optional[pulumi.Input['LoadTestIdentityArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a LoadTest resource.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Load Test should exist. Changing this forces a new Load Test to be created.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input['LoadTestEncryptionArgs'] encryption: An `encryption` block as defined below. Changing this forces a new Load Test to be created.
        :param pulumi.Input['LoadTestIdentityArgs'] identity: An `identity` block as defined below. Specifies the Managed Identity which should be assigned to this Load Test.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Load Test should exist. Changing this forces a new Load Test to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of this Load Test. Changing this forces a new Load Test to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Load Test.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the Resource Group within which this Load Test should exist. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['LoadTestEncryptionArgs']]:
        """
        An `encryption` block as defined below. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['LoadTestEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['LoadTestIdentityArgs']]:
        """
        An `identity` block as defined below. Specifies the Managed Identity which should be assigned to this Load Test.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['LoadTestIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Load Test should exist. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of this Load Test. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Load Test.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LoadTestState:
    def __init__(__self__, *,
                 data_plane_uri: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption: Optional[pulumi.Input['LoadTestEncryptionArgs']] = None,
                 identity: Optional[pulumi.Input['LoadTestIdentityArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering LoadTest resources.
        :param pulumi.Input[builtins.str] data_plane_uri: Resource data plane URI.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input['LoadTestEncryptionArgs'] encryption: An `encryption` block as defined below. Changing this forces a new Load Test to be created.
        :param pulumi.Input['LoadTestIdentityArgs'] identity: An `identity` block as defined below. Specifies the Managed Identity which should be assigned to this Load Test.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Load Test should exist. Changing this forces a new Load Test to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of this Load Test. Changing this forces a new Load Test to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Load Test should exist. Changing this forces a new Load Test to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Load Test.
        """
        if data_plane_uri is not None:
            pulumi.set(__self__, "data_plane_uri", data_plane_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataPlaneUri")
    def data_plane_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource data plane URI.
        """
        return pulumi.get(self, "data_plane_uri")

    @data_plane_uri.setter
    def data_plane_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_plane_uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['LoadTestEncryptionArgs']]:
        """
        An `encryption` block as defined below. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['LoadTestEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['LoadTestIdentityArgs']]:
        """
        An `identity` block as defined below. Specifies the Managed Identity which should be assigned to this Load Test.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['LoadTestIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Load Test should exist. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of this Load Test. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Resource Group within which this Load Test should exist. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Load Test.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:loadtest/loadTest:LoadTest")
class LoadTest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption: Optional[pulumi.Input[Union['LoadTestEncryptionArgs', 'LoadTestEncryptionArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['LoadTestIdentityArgs', 'LoadTestIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        <!-- Note: This documentation is generated. Any manual changes will be overwritten -->

        Manages a Load Test Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_load_test = azure.loadtest.LoadTest("example",
            location=example.location,
            name="example",
            resource_group_name=example.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.LoadTestService`: 2022-12-01

        ## Import

        An existing Load Test can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:loadtest/loadTest:LoadTest example /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LoadTestService/loadTests/{loadTestName}
        ```

        * Where `{subscriptionId}` is the ID of the Azure Subscription where the Load Test exists. For example `12345678-1234-9876-4563-123456789012`.

        * Where `{resourceGroupName}` is the name of Resource Group where this Load Test exists. For example `example-resource-group`.

        * Where `{loadTestName}` is the name of the Load Test. For example `loadTestValue`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input[Union['LoadTestEncryptionArgs', 'LoadTestEncryptionArgsDict']] encryption: An `encryption` block as defined below. Changing this forces a new Load Test to be created.
        :param pulumi.Input[Union['LoadTestIdentityArgs', 'LoadTestIdentityArgsDict']] identity: An `identity` block as defined below. Specifies the Managed Identity which should be assigned to this Load Test.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Load Test should exist. Changing this forces a new Load Test to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of this Load Test. Changing this forces a new Load Test to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Load Test should exist. Changing this forces a new Load Test to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Load Test.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadTestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- Note: This documentation is generated. Any manual changes will be overwritten -->

        Manages a Load Test Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_load_test = azure.loadtest.LoadTest("example",
            location=example.location,
            name="example",
            resource_group_name=example.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.LoadTestService`: 2022-12-01

        ## Import

        An existing Load Test can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:loadtest/loadTest:LoadTest example /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LoadTestService/loadTests/{loadTestName}
        ```

        * Where `{subscriptionId}` is the ID of the Azure Subscription where the Load Test exists. For example `12345678-1234-9876-4563-123456789012`.

        * Where `{resourceGroupName}` is the name of Resource Group where this Load Test exists. For example `example-resource-group`.

        * Where `{loadTestName}` is the name of the Load Test. For example `loadTestValue`.

        :param str resource_name: The name of the resource.
        :param LoadTestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadTestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption: Optional[pulumi.Input[Union['LoadTestEncryptionArgs', 'LoadTestEncryptionArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['LoadTestIdentityArgs', 'LoadTestIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadTestArgs.__new__(LoadTestArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["data_plane_uri"] = None
        super(LoadTest, __self__).__init__(
            'azure:loadtest/loadTest:LoadTest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_plane_uri: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            encryption: Optional[pulumi.Input[Union['LoadTestEncryptionArgs', 'LoadTestEncryptionArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['LoadTestIdentityArgs', 'LoadTestIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'LoadTest':
        """
        Get an existing LoadTest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] data_plane_uri: Resource data plane URI.
        :param pulumi.Input[builtins.str] description: Description of the resource.
        :param pulumi.Input[Union['LoadTestEncryptionArgs', 'LoadTestEncryptionArgsDict']] encryption: An `encryption` block as defined below. Changing this forces a new Load Test to be created.
        :param pulumi.Input[Union['LoadTestIdentityArgs', 'LoadTestIdentityArgsDict']] identity: An `identity` block as defined below. Specifies the Managed Identity which should be assigned to this Load Test.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Load Test should exist. Changing this forces a new Load Test to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of this Load Test. Changing this forces a new Load Test to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Load Test should exist. Changing this forces a new Load Test to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Load Test.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadTestState.__new__(_LoadTestState)

        __props__.__dict__["data_plane_uri"] = data_plane_uri
        __props__.__dict__["description"] = description
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return LoadTest(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataPlaneUri")
    def data_plane_uri(self) -> pulumi.Output[builtins.str]:
        """
        Resource data plane URI.
        """
        return pulumi.get(self, "data_plane_uri")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Optional['outputs.LoadTestEncryption']]:
        """
        An `encryption` block as defined below. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.LoadTestIdentity']]:
        """
        An `identity` block as defined below. Specifies the Managed Identity which should be assigned to this Load Test.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Load Test should exist. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of this Load Test. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Resource Group within which this Load Test should exist. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Load Test.
        """
        return pulumi.get(self, "tags")

