# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ActionHttpArgs', 'ActionHttp']

@pulumi.input_type
class ActionHttpArgs:
    def __init__(__self__, *,
                 logic_app_id: pulumi.Input[builtins.str],
                 method: pulumi.Input[builtins.str],
                 uri: pulumi.Input[builtins.str],
                 body: Optional[pulumi.Input[builtins.str]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 queries: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 run_afters: Optional[pulumi.Input[Sequence[pulumi.Input['ActionHttpRunAfterArgs']]]] = None):
        """
        The set of arguments for constructing a ActionHttp resource.
        :param pulumi.Input[builtins.str] logic_app_id: Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] method: Specifies the HTTP Method which should be used for this HTTP Action. Possible values include `DELETE`, `GET`, `PATCH`, `POST` and `PUT`.
        :param pulumi.Input[builtins.str] uri: Specifies the URI which will be called when this HTTP Action is triggered.
        :param pulumi.Input[builtins.str] body: Specifies the HTTP Body that should be sent to the `uri` when this HTTP Action is triggered.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] headers: Specifies a Map of Key-Value Pairs that should be sent to the `uri` when this HTTP Action is triggered.
        :param pulumi.Input[builtins.str] name: Specifies the name of the HTTP Action to be created within the Logic App Workflow. Changing this forces a new resource to be created.
               
               > **NOTE:** This name must be unique across all Actions within the Logic App Workflow.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] queries: Specifies a Map of Key-Value Pairs that should be sent to the `uri` when this HTTP Action is triggered.
        :param pulumi.Input[Sequence[pulumi.Input['ActionHttpRunAfterArgs']]] run_afters: Specifies the place of the HTTP Action in the Logic App Workflow. If not specified, the HTTP Action is right after the Trigger. A `run_after` block is as defined below.
        """
        pulumi.set(__self__, "logic_app_id", logic_app_id)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "uri", uri)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if run_afters is not None:
            pulumi.set(__self__, "run_afters", run_afters)

    @property
    @pulumi.getter(name="logicAppId")
    def logic_app_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "logic_app_id")

    @logic_app_id.setter
    def logic_app_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "logic_app_id", value)

    @property
    @pulumi.getter
    def method(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the HTTP Method which should be used for this HTTP Action. Possible values include `DELETE`, `GET`, `PATCH`, `POST` and `PUT`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the URI which will be called when this HTTP Action is triggered.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the HTTP Body that should be sent to the `uri` when this HTTP Action is triggered.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies a Map of Key-Value Pairs that should be sent to the `uri` when this HTTP Action is triggered.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the HTTP Action to be created within the Logic App Workflow. Changing this forces a new resource to be created.

        > **NOTE:** This name must be unique across all Actions within the Logic App Workflow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies a Map of Key-Value Pairs that should be sent to the `uri` when this HTTP Action is triggered.
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "queries", value)

    @property
    @pulumi.getter(name="runAfters")
    def run_afters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionHttpRunAfterArgs']]]]:
        """
        Specifies the place of the HTTP Action in the Logic App Workflow. If not specified, the HTTP Action is right after the Trigger. A `run_after` block is as defined below.
        """
        return pulumi.get(self, "run_afters")

    @run_afters.setter
    def run_afters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionHttpRunAfterArgs']]]]):
        pulumi.set(self, "run_afters", value)


@pulumi.input_type
class _ActionHttpState:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input[builtins.str]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 logic_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 queries: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 run_afters: Optional[pulumi.Input[Sequence[pulumi.Input['ActionHttpRunAfterArgs']]]] = None,
                 uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ActionHttp resources.
        :param pulumi.Input[builtins.str] body: Specifies the HTTP Body that should be sent to the `uri` when this HTTP Action is triggered.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] headers: Specifies a Map of Key-Value Pairs that should be sent to the `uri` when this HTTP Action is triggered.
        :param pulumi.Input[builtins.str] logic_app_id: Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] method: Specifies the HTTP Method which should be used for this HTTP Action. Possible values include `DELETE`, `GET`, `PATCH`, `POST` and `PUT`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the HTTP Action to be created within the Logic App Workflow. Changing this forces a new resource to be created.
               
               > **NOTE:** This name must be unique across all Actions within the Logic App Workflow.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] queries: Specifies a Map of Key-Value Pairs that should be sent to the `uri` when this HTTP Action is triggered.
        :param pulumi.Input[Sequence[pulumi.Input['ActionHttpRunAfterArgs']]] run_afters: Specifies the place of the HTTP Action in the Logic App Workflow. If not specified, the HTTP Action is right after the Trigger. A `run_after` block is as defined below.
        :param pulumi.Input[builtins.str] uri: Specifies the URI which will be called when this HTTP Action is triggered.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if logic_app_id is not None:
            pulumi.set(__self__, "logic_app_id", logic_app_id)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if run_afters is not None:
            pulumi.set(__self__, "run_afters", run_afters)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the HTTP Body that should be sent to the `uri` when this HTTP Action is triggered.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies a Map of Key-Value Pairs that should be sent to the `uri` when this HTTP Action is triggered.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="logicAppId")
    def logic_app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "logic_app_id")

    @logic_app_id.setter
    def logic_app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logic_app_id", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the HTTP Method which should be used for this HTTP Action. Possible values include `DELETE`, `GET`, `PATCH`, `POST` and `PUT`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the HTTP Action to be created within the Logic App Workflow. Changing this forces a new resource to be created.

        > **NOTE:** This name must be unique across all Actions within the Logic App Workflow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Specifies a Map of Key-Value Pairs that should be sent to the `uri` when this HTTP Action is triggered.
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "queries", value)

    @property
    @pulumi.getter(name="runAfters")
    def run_afters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionHttpRunAfterArgs']]]]:
        """
        Specifies the place of the HTTP Action in the Logic App Workflow. If not specified, the HTTP Action is right after the Trigger. A `run_after` block is as defined below.
        """
        return pulumi.get(self, "run_afters")

    @run_afters.setter
    def run_afters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionHttpRunAfterArgs']]]]):
        pulumi.set(self, "run_afters", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the URI which will be called when this HTTP Action is triggered.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uri", value)


@pulumi.type_token("azure:logicapps/actionHttp:ActionHttp")
class ActionHttp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[builtins.str]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 logic_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 queries: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 run_afters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionHttpRunAfterArgs', 'ActionHttpRunAfterArgsDict']]]]] = None,
                 uri: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an HTTP Action within a Logic App Workflow

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="workflow-resources",
            location="West Europe")
        example_workflow = azure.logicapps.Workflow("example",
            name="workflow1",
            location=example.location,
            resource_group_name=example.name)
        example_action_http = azure.logicapps.ActionHttp("example",
            name="webhook",
            logic_app_id=example_workflow.id,
            method="GET",
            uri="http://example.com/some-webhook")
        ```

        ## Import

        Logic App HTTP Actions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/actionHttp:ActionHttp webhook1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Logic/workflows/workflow1/actions/webhook1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] body: Specifies the HTTP Body that should be sent to the `uri` when this HTTP Action is triggered.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] headers: Specifies a Map of Key-Value Pairs that should be sent to the `uri` when this HTTP Action is triggered.
        :param pulumi.Input[builtins.str] logic_app_id: Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] method: Specifies the HTTP Method which should be used for this HTTP Action. Possible values include `DELETE`, `GET`, `PATCH`, `POST` and `PUT`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the HTTP Action to be created within the Logic App Workflow. Changing this forces a new resource to be created.
               
               > **NOTE:** This name must be unique across all Actions within the Logic App Workflow.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] queries: Specifies a Map of Key-Value Pairs that should be sent to the `uri` when this HTTP Action is triggered.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionHttpRunAfterArgs', 'ActionHttpRunAfterArgsDict']]]] run_afters: Specifies the place of the HTTP Action in the Logic App Workflow. If not specified, the HTTP Action is right after the Trigger. A `run_after` block is as defined below.
        :param pulumi.Input[builtins.str] uri: Specifies the URI which will be called when this HTTP Action is triggered.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ActionHttpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an HTTP Action within a Logic App Workflow

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="workflow-resources",
            location="West Europe")
        example_workflow = azure.logicapps.Workflow("example",
            name="workflow1",
            location=example.location,
            resource_group_name=example.name)
        example_action_http = azure.logicapps.ActionHttp("example",
            name="webhook",
            logic_app_id=example_workflow.id,
            method="GET",
            uri="http://example.com/some-webhook")
        ```

        ## Import

        Logic App HTTP Actions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/actionHttp:ActionHttp webhook1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Logic/workflows/workflow1/actions/webhook1
        ```

        :param str resource_name: The name of the resource.
        :param ActionHttpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActionHttpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[builtins.str]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 logic_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 queries: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 run_afters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionHttpRunAfterArgs', 'ActionHttpRunAfterArgsDict']]]]] = None,
                 uri: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActionHttpArgs.__new__(ActionHttpArgs)

            __props__.__dict__["body"] = body
            __props__.__dict__["headers"] = headers
            if logic_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'logic_app_id'")
            __props__.__dict__["logic_app_id"] = logic_app_id
            if method is None and not opts.urn:
                raise TypeError("Missing required property 'method'")
            __props__.__dict__["method"] = method
            __props__.__dict__["name"] = name
            __props__.__dict__["queries"] = queries
            __props__.__dict__["run_afters"] = run_afters
            if uri is None and not opts.urn:
                raise TypeError("Missing required property 'uri'")
            __props__.__dict__["uri"] = uri
        super(ActionHttp, __self__).__init__(
            'azure:logicapps/actionHttp:ActionHttp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            body: Optional[pulumi.Input[builtins.str]] = None,
            headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            logic_app_id: Optional[pulumi.Input[builtins.str]] = None,
            method: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            queries: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            run_afters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionHttpRunAfterArgs', 'ActionHttpRunAfterArgsDict']]]]] = None,
            uri: Optional[pulumi.Input[builtins.str]] = None) -> 'ActionHttp':
        """
        Get an existing ActionHttp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] body: Specifies the HTTP Body that should be sent to the `uri` when this HTTP Action is triggered.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] headers: Specifies a Map of Key-Value Pairs that should be sent to the `uri` when this HTTP Action is triggered.
        :param pulumi.Input[builtins.str] logic_app_id: Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] method: Specifies the HTTP Method which should be used for this HTTP Action. Possible values include `DELETE`, `GET`, `PATCH`, `POST` and `PUT`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the HTTP Action to be created within the Logic App Workflow. Changing this forces a new resource to be created.
               
               > **NOTE:** This name must be unique across all Actions within the Logic App Workflow.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] queries: Specifies a Map of Key-Value Pairs that should be sent to the `uri` when this HTTP Action is triggered.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionHttpRunAfterArgs', 'ActionHttpRunAfterArgsDict']]]] run_afters: Specifies the place of the HTTP Action in the Logic App Workflow. If not specified, the HTTP Action is right after the Trigger. A `run_after` block is as defined below.
        :param pulumi.Input[builtins.str] uri: Specifies the URI which will be called when this HTTP Action is triggered.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActionHttpState.__new__(_ActionHttpState)

        __props__.__dict__["body"] = body
        __props__.__dict__["headers"] = headers
        __props__.__dict__["logic_app_id"] = logic_app_id
        __props__.__dict__["method"] = method
        __props__.__dict__["name"] = name
        __props__.__dict__["queries"] = queries
        __props__.__dict__["run_afters"] = run_afters
        __props__.__dict__["uri"] = uri
        return ActionHttp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def body(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the HTTP Body that should be sent to the `uri` when this HTTP Action is triggered.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Specifies a Map of Key-Value Pairs that should be sent to the `uri` when this HTTP Action is triggered.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="logicAppId")
    def logic_app_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "logic_app_id")

    @property
    @pulumi.getter
    def method(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the HTTP Method which should be used for this HTTP Action. Possible values include `DELETE`, `GET`, `PATCH`, `POST` and `PUT`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the HTTP Action to be created within the Logic App Workflow. Changing this forces a new resource to be created.

        > **NOTE:** This name must be unique across all Actions within the Logic App Workflow.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def queries(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Specifies a Map of Key-Value Pairs that should be sent to the `uri` when this HTTP Action is triggered.
        """
        return pulumi.get(self, "queries")

    @property
    @pulumi.getter(name="runAfters")
    def run_afters(self) -> pulumi.Output[Optional[Sequence['outputs.ActionHttpRunAfter']]]:
        """
        Specifies the place of the HTTP Action in the Logic App Workflow. If not specified, the HTTP Action is right after the Trigger. A `run_after` block is as defined below.
        """
        return pulumi.get(self, "run_afters")

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the URI which will be called when this HTTP Action is triggered.
        """
        return pulumi.get(self, "uri")

