# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetWorkflowResult',
    'AwaitableGetWorkflowResult',
    'get_workflow',
    'get_workflow_output',
]

@pulumi.output_type
class GetWorkflowResult:
    """
    A collection of values returned by getWorkflow.
    """
    def __init__(__self__, access_endpoint=None, connector_endpoint_ip_addresses=None, connector_outbound_ip_addresses=None, id=None, identities=None, location=None, logic_app_integration_account_id=None, name=None, parameters=None, resource_group_name=None, tags=None, workflow_endpoint_ip_addresses=None, workflow_outbound_ip_addresses=None, workflow_schema=None, workflow_version=None):
        if access_endpoint and not isinstance(access_endpoint, str):
            raise TypeError("Expected argument 'access_endpoint' to be a str")
        pulumi.set(__self__, "access_endpoint", access_endpoint)
        if connector_endpoint_ip_addresses and not isinstance(connector_endpoint_ip_addresses, list):
            raise TypeError("Expected argument 'connector_endpoint_ip_addresses' to be a list")
        pulumi.set(__self__, "connector_endpoint_ip_addresses", connector_endpoint_ip_addresses)
        if connector_outbound_ip_addresses and not isinstance(connector_outbound_ip_addresses, list):
            raise TypeError("Expected argument 'connector_outbound_ip_addresses' to be a list")
        pulumi.set(__self__, "connector_outbound_ip_addresses", connector_outbound_ip_addresses)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if logic_app_integration_account_id and not isinstance(logic_app_integration_account_id, str):
            raise TypeError("Expected argument 'logic_app_integration_account_id' to be a str")
        pulumi.set(__self__, "logic_app_integration_account_id", logic_app_integration_account_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if workflow_endpoint_ip_addresses and not isinstance(workflow_endpoint_ip_addresses, list):
            raise TypeError("Expected argument 'workflow_endpoint_ip_addresses' to be a list")
        pulumi.set(__self__, "workflow_endpoint_ip_addresses", workflow_endpoint_ip_addresses)
        if workflow_outbound_ip_addresses and not isinstance(workflow_outbound_ip_addresses, list):
            raise TypeError("Expected argument 'workflow_outbound_ip_addresses' to be a list")
        pulumi.set(__self__, "workflow_outbound_ip_addresses", workflow_outbound_ip_addresses)
        if workflow_schema and not isinstance(workflow_schema, str):
            raise TypeError("Expected argument 'workflow_schema' to be a str")
        pulumi.set(__self__, "workflow_schema", workflow_schema)
        if workflow_version and not isinstance(workflow_version, str):
            raise TypeError("Expected argument 'workflow_version' to be a str")
        pulumi.set(__self__, "workflow_version", workflow_version)

    @property
    @pulumi.getter(name="accessEndpoint")
    def access_endpoint(self) -> builtins.str:
        """
        The Access Endpoint for the Logic App Workflow
        """
        return pulumi.get(self, "access_endpoint")

    @property
    @pulumi.getter(name="connectorEndpointIpAddresses")
    def connector_endpoint_ip_addresses(self) -> Sequence[builtins.str]:
        """
        The list of access endpoint IP addresses of connector.
        """
        return pulumi.get(self, "connector_endpoint_ip_addresses")

    @property
    @pulumi.getter(name="connectorOutboundIpAddresses")
    def connector_outbound_ip_addresses(self) -> Sequence[builtins.str]:
        """
        The list of outgoing IP addresses of connector.
        """
        return pulumi.get(self, "connector_outbound_ip_addresses")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetWorkflowIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure location where the Logic App Workflow exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="logicAppIntegrationAccountId")
    def logic_app_integration_account_id(self) -> builtins.str:
        """
        The ID of the integration account linked by this Logic App Workflow.
        """
        return pulumi.get(self, "logic_app_integration_account_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Mapping[str, builtins.str]:
        """
        A map of Key-Value pairs.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="workflowEndpointIpAddresses")
    def workflow_endpoint_ip_addresses(self) -> Sequence[builtins.str]:
        """
        The list of access endpoint IP addresses of workflow.
        """
        return pulumi.get(self, "workflow_endpoint_ip_addresses")

    @property
    @pulumi.getter(name="workflowOutboundIpAddresses")
    def workflow_outbound_ip_addresses(self) -> Sequence[builtins.str]:
        """
        The list of outgoing IP addresses of workflow.
        """
        return pulumi.get(self, "workflow_outbound_ip_addresses")

    @property
    @pulumi.getter(name="workflowSchema")
    def workflow_schema(self) -> builtins.str:
        """
        The Schema used for this Logic App Workflow.
        """
        return pulumi.get(self, "workflow_schema")

    @property
    @pulumi.getter(name="workflowVersion")
    def workflow_version(self) -> builtins.str:
        """
        The version of the Schema used for this Logic App Workflow. Defaults to `1.0.0.0`.
        """
        return pulumi.get(self, "workflow_version")


class AwaitableGetWorkflowResult(GetWorkflowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkflowResult(
            access_endpoint=self.access_endpoint,
            connector_endpoint_ip_addresses=self.connector_endpoint_ip_addresses,
            connector_outbound_ip_addresses=self.connector_outbound_ip_addresses,
            id=self.id,
            identities=self.identities,
            location=self.location,
            logic_app_integration_account_id=self.logic_app_integration_account_id,
            name=self.name,
            parameters=self.parameters,
            resource_group_name=self.resource_group_name,
            tags=self.tags,
            workflow_endpoint_ip_addresses=self.workflow_endpoint_ip_addresses,
            workflow_outbound_ip_addresses=self.workflow_outbound_ip_addresses,
            workflow_schema=self.workflow_schema,
            workflow_version=self.workflow_version)


def get_workflow(name: Optional[builtins.str] = None,
                 resource_group_name: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkflowResult:
    """
    Use this data source to access information about an existing Logic App Workflow.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.logicapps.get_workflow(name="workflow1",
        resource_group_name="my-resource-group")
    pulumi.export("accessEndpoint", example.access_endpoint)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Logic`: 2019-05-01


    :param builtins.str name: The name of the Logic App Workflow.
    :param builtins.str resource_group_name: The name of the Resource Group in which the Logic App Workflow exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:logicapps/getWorkflow:getWorkflow', __args__, opts=opts, typ=GetWorkflowResult).value

    return AwaitableGetWorkflowResult(
        access_endpoint=pulumi.get(__ret__, 'access_endpoint'),
        connector_endpoint_ip_addresses=pulumi.get(__ret__, 'connector_endpoint_ip_addresses'),
        connector_outbound_ip_addresses=pulumi.get(__ret__, 'connector_outbound_ip_addresses'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        logic_app_integration_account_id=pulumi.get(__ret__, 'logic_app_integration_account_id'),
        name=pulumi.get(__ret__, 'name'),
        parameters=pulumi.get(__ret__, 'parameters'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'),
        workflow_endpoint_ip_addresses=pulumi.get(__ret__, 'workflow_endpoint_ip_addresses'),
        workflow_outbound_ip_addresses=pulumi.get(__ret__, 'workflow_outbound_ip_addresses'),
        workflow_schema=pulumi.get(__ret__, 'workflow_schema'),
        workflow_version=pulumi.get(__ret__, 'workflow_version'))
def get_workflow_output(name: Optional[pulumi.Input[builtins.str]] = None,
                        resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkflowResult]:
    """
    Use this data source to access information about an existing Logic App Workflow.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.logicapps.get_workflow(name="workflow1",
        resource_group_name="my-resource-group")
    pulumi.export("accessEndpoint", example.access_endpoint)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Logic`: 2019-05-01


    :param builtins.str name: The name of the Logic App Workflow.
    :param builtins.str resource_group_name: The name of the Resource Group in which the Logic App Workflow exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:logicapps/getWorkflow:getWorkflow', __args__, opts=opts, typ=GetWorkflowResult)
    return __ret__.apply(lambda __response__: GetWorkflowResult(
        access_endpoint=pulumi.get(__response__, 'access_endpoint'),
        connector_endpoint_ip_addresses=pulumi.get(__response__, 'connector_endpoint_ip_addresses'),
        connector_outbound_ip_addresses=pulumi.get(__response__, 'connector_outbound_ip_addresses'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        logic_app_integration_account_id=pulumi.get(__response__, 'logic_app_integration_account_id'),
        name=pulumi.get(__response__, 'name'),
        parameters=pulumi.get(__response__, 'parameters'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags'),
        workflow_endpoint_ip_addresses=pulumi.get(__response__, 'workflow_endpoint_ip_addresses'),
        workflow_outbound_ip_addresses=pulumi.get(__response__, 'workflow_outbound_ip_addresses'),
        workflow_schema=pulumi.get(__response__, 'workflow_schema'),
        workflow_version=pulumi.get(__response__, 'workflow_version')))
