# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IntegrationAccountMapArgs', 'IntegrationAccountMap']

@pulumi.input_type
class IntegrationAccountMapArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[builtins.str],
                 integration_account_name: pulumi.Input[builtins.str],
                 map_type: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a IntegrationAccountMap resource.
        :param pulumi.Input[builtins.str] content: The content of the Logic App Integration Account Map.
        :param pulumi.Input[builtins.str] integration_account_name: The name of the Logic App Integration Account. Changing this forces a new Logic App Integration Account Map to be created.
        :param pulumi.Input[builtins.str] map_type: The type of the Logic App Integration Account Map. Possible values are `Liquid`, `NotSpecified`, `Xslt`, `Xslt30` and `Xslt20`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account Map should exist. Changing this forces a new Logic App Integration Account Map to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: The metadata of the Logic App Integration Account Map.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Logic App Integration Account Map. Changing this forces a new Logic App Integration Account Map to be created.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "integration_account_name", integration_account_name)
        pulumi.set(__self__, "map_type", map_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[builtins.str]:
        """
        The content of the Logic App Integration Account Map.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="integrationAccountName")
    def integration_account_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Logic App Integration Account. Changing this forces a new Logic App Integration Account Map to be created.
        """
        return pulumi.get(self, "integration_account_name")

    @integration_account_name.setter
    def integration_account_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "integration_account_name", value)

    @property
    @pulumi.getter(name="mapType")
    def map_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the Logic App Integration Account Map. Possible values are `Liquid`, `NotSpecified`, `Xslt`, `Xslt30` and `Xslt20`.
        """
        return pulumi.get(self, "map_type")

    @map_type.setter
    def map_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "map_type", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Logic App Integration Account Map should exist. Changing this forces a new Logic App Integration Account Map to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The metadata of the Logic App Integration Account Map.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Logic App Integration Account Map. Changing this forces a new Logic App Integration Account Map to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _IntegrationAccountMapState:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 integration_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 map_type: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering IntegrationAccountMap resources.
        :param pulumi.Input[builtins.str] content: The content of the Logic App Integration Account Map.
        :param pulumi.Input[builtins.str] integration_account_name: The name of the Logic App Integration Account. Changing this forces a new Logic App Integration Account Map to be created.
        :param pulumi.Input[builtins.str] map_type: The type of the Logic App Integration Account Map. Possible values are `Liquid`, `NotSpecified`, `Xslt`, `Xslt30` and `Xslt20`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: The metadata of the Logic App Integration Account Map.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Logic App Integration Account Map. Changing this forces a new Logic App Integration Account Map to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account Map should exist. Changing this forces a new Logic App Integration Account Map to be created.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if integration_account_name is not None:
            pulumi.set(__self__, "integration_account_name", integration_account_name)
        if map_type is not None:
            pulumi.set(__self__, "map_type", map_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The content of the Logic App Integration Account Map.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="integrationAccountName")
    def integration_account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Logic App Integration Account. Changing this forces a new Logic App Integration Account Map to be created.
        """
        return pulumi.get(self, "integration_account_name")

    @integration_account_name.setter
    def integration_account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_account_name", value)

    @property
    @pulumi.getter(name="mapType")
    def map_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the Logic App Integration Account Map. Possible values are `Liquid`, `NotSpecified`, `Xslt`, `Xslt30` and `Xslt20`.
        """
        return pulumi.get(self, "map_type")

    @map_type.setter
    def map_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "map_type", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The metadata of the Logic App Integration Account Map.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Logic App Integration Account Map. Changing this forces a new Logic App Integration Account Map to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Logic App Integration Account Map should exist. Changing this forces a new Logic App Integration Account Map to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:logicapps/integrationAccountMap:IntegrationAccountMap")
class IntegrationAccountMap(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 integration_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 map_type: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Logic App Integration Account Map.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_integration_account = azure.logicapps.IntegrationAccount("example",
            name="example-ia",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Standard")
        example_integration_account_map = azure.logicapps.IntegrationAccountMap("example",
            name="example-iamap",
            resource_group_name=example.name,
            integration_account_name=example_integration_account.name,
            map_type="Xslt",
            content=std.file(input="testdata/integration_account_map_content.xsd").result)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Logic`: 2019-05-01

        ## Import

        Logic App Integration Account Maps can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/integrationAccountMap:IntegrationAccountMap example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Logic/integrationAccounts/account1/maps/map1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] content: The content of the Logic App Integration Account Map.
        :param pulumi.Input[builtins.str] integration_account_name: The name of the Logic App Integration Account. Changing this forces a new Logic App Integration Account Map to be created.
        :param pulumi.Input[builtins.str] map_type: The type of the Logic App Integration Account Map. Possible values are `Liquid`, `NotSpecified`, `Xslt`, `Xslt30` and `Xslt20`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: The metadata of the Logic App Integration Account Map.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Logic App Integration Account Map. Changing this forces a new Logic App Integration Account Map to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account Map should exist. Changing this forces a new Logic App Integration Account Map to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationAccountMapArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Logic App Integration Account Map.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_integration_account = azure.logicapps.IntegrationAccount("example",
            name="example-ia",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Standard")
        example_integration_account_map = azure.logicapps.IntegrationAccountMap("example",
            name="example-iamap",
            resource_group_name=example.name,
            integration_account_name=example_integration_account.name,
            map_type="Xslt",
            content=std.file(input="testdata/integration_account_map_content.xsd").result)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Logic`: 2019-05-01

        ## Import

        Logic App Integration Account Maps can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/integrationAccountMap:IntegrationAccountMap example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Logic/integrationAccounts/account1/maps/map1
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationAccountMapArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationAccountMapArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 integration_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 map_type: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationAccountMapArgs.__new__(IntegrationAccountMapArgs)

            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            if integration_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'integration_account_name'")
            __props__.__dict__["integration_account_name"] = integration_account_name
            if map_type is None and not opts.urn:
                raise TypeError("Missing required property 'map_type'")
            __props__.__dict__["map_type"] = map_type
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        super(IntegrationAccountMap, __self__).__init__(
            'azure:logicapps/integrationAccountMap:IntegrationAccountMap',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content: Optional[pulumi.Input[builtins.str]] = None,
            integration_account_name: Optional[pulumi.Input[builtins.str]] = None,
            map_type: Optional[pulumi.Input[builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None) -> 'IntegrationAccountMap':
        """
        Get an existing IntegrationAccountMap resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] content: The content of the Logic App Integration Account Map.
        :param pulumi.Input[builtins.str] integration_account_name: The name of the Logic App Integration Account. Changing this forces a new Logic App Integration Account Map to be created.
        :param pulumi.Input[builtins.str] map_type: The type of the Logic App Integration Account Map. Possible values are `Liquid`, `NotSpecified`, `Xslt`, `Xslt30` and `Xslt20`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: The metadata of the Logic App Integration Account Map.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Logic App Integration Account Map. Changing this forces a new Logic App Integration Account Map to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account Map should exist. Changing this forces a new Logic App Integration Account Map to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationAccountMapState.__new__(_IntegrationAccountMapState)

        __props__.__dict__["content"] = content
        __props__.__dict__["integration_account_name"] = integration_account_name
        __props__.__dict__["map_type"] = map_type
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        return IntegrationAccountMap(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[builtins.str]:
        """
        The content of the Logic App Integration Account Map.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="integrationAccountName")
    def integration_account_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Logic App Integration Account. Changing this forces a new Logic App Integration Account Map to be created.
        """
        return pulumi.get(self, "integration_account_name")

    @property
    @pulumi.getter(name="mapType")
    def map_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the Logic App Integration Account Map. Possible values are `Liquid`, `NotSpecified`, `Xslt`, `Xslt30` and `Xslt20`.
        """
        return pulumi.get(self, "map_type")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The metadata of the Logic App Integration Account Map.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Logic App Integration Account Map. Changing this forces a new Logic App Integration Account Map to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Logic App Integration Account Map should exist. Changing this forces a new Logic App Integration Account Map to be created.
        """
        return pulumi.get(self, "resource_group_name")

