# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TriggerRecurrenceArgs', 'TriggerRecurrence']

@pulumi.input_type
class TriggerRecurrenceArgs:
    def __init__(__self__, *,
                 frequency: pulumi.Input[builtins.str],
                 interval: pulumi.Input[builtins.int],
                 logic_app_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input['TriggerRecurrenceScheduleArgs']] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a TriggerRecurrence resource.
        :param pulumi.Input[builtins.str] frequency: Specifies the Frequency at which this Trigger should be run. Possible values include `Month`, `Week`, `Day`, `Hour`, `Minute` and `Second`.
        :param pulumi.Input[builtins.int] interval: Specifies interval used for the Frequency, for example a value of `4` for `interval` and `hour` for `frequency` would run the Trigger every 4 hours.
        :param pulumi.Input[builtins.str] logic_app_id: Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Recurrence Triggers to be created within the Logic App Workflow. Changing this forces a new resource to be created.
               
               > **NOTE:** This name must be unique across all Triggers within the Logic App Workflow.
        :param pulumi.Input['TriggerRecurrenceScheduleArgs'] schedule: A `schedule` block as specified below.
        :param pulumi.Input[builtins.str] start_time: Specifies the start date and time for this trigger in RFC3339 format: `2000-01-02T03:04:05Z`.
        :param pulumi.Input[builtins.str] time_zone: Specifies the time zone for this trigger. Supported time zone options are listed [here](https://support.microsoft.com/en-us/help/973627/microsoft-time-zone-index-values)
        """
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "logic_app_id", logic_app_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Frequency at which this Trigger should be run. Possible values include `Month`, `Week`, `Day`, `Hour`, `Minute` and `Second`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Input[builtins.int]:
        """
        Specifies interval used for the Frequency, for example a value of `4` for `interval` and `hour` for `frequency` would run the Trigger every 4 hours.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="logicAppId")
    def logic_app_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "logic_app_id")

    @logic_app_id.setter
    def logic_app_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "logic_app_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Recurrence Triggers to be created within the Logic App Workflow. Changing this forces a new resource to be created.

        > **NOTE:** This name must be unique across all Triggers within the Logic App Workflow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['TriggerRecurrenceScheduleArgs']]:
        """
        A `schedule` block as specified below.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['TriggerRecurrenceScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the start date and time for this trigger in RFC3339 format: `2000-01-02T03:04:05Z`.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the time zone for this trigger. Supported time zone options are listed [here](https://support.microsoft.com/en-us/help/973627/microsoft-time-zone-index-values)
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _TriggerRecurrenceState:
    def __init__(__self__, *,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 logic_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input['TriggerRecurrenceScheduleArgs']] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering TriggerRecurrence resources.
        :param pulumi.Input[builtins.str] frequency: Specifies the Frequency at which this Trigger should be run. Possible values include `Month`, `Week`, `Day`, `Hour`, `Minute` and `Second`.
        :param pulumi.Input[builtins.int] interval: Specifies interval used for the Frequency, for example a value of `4` for `interval` and `hour` for `frequency` would run the Trigger every 4 hours.
        :param pulumi.Input[builtins.str] logic_app_id: Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Recurrence Triggers to be created within the Logic App Workflow. Changing this forces a new resource to be created.
               
               > **NOTE:** This name must be unique across all Triggers within the Logic App Workflow.
        :param pulumi.Input['TriggerRecurrenceScheduleArgs'] schedule: A `schedule` block as specified below.
        :param pulumi.Input[builtins.str] start_time: Specifies the start date and time for this trigger in RFC3339 format: `2000-01-02T03:04:05Z`.
        :param pulumi.Input[builtins.str] time_zone: Specifies the time zone for this trigger. Supported time zone options are listed [here](https://support.microsoft.com/en-us/help/973627/microsoft-time-zone-index-values)
        """
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if logic_app_id is not None:
            pulumi.set(__self__, "logic_app_id", logic_app_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Frequency at which this Trigger should be run. Possible values include `Month`, `Week`, `Day`, `Hour`, `Minute` and `Second`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies interval used for the Frequency, for example a value of `4` for `interval` and `hour` for `frequency` would run the Trigger every 4 hours.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="logicAppId")
    def logic_app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "logic_app_id")

    @logic_app_id.setter
    def logic_app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logic_app_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Recurrence Triggers to be created within the Logic App Workflow. Changing this forces a new resource to be created.

        > **NOTE:** This name must be unique across all Triggers within the Logic App Workflow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['TriggerRecurrenceScheduleArgs']]:
        """
        A `schedule` block as specified below.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['TriggerRecurrenceScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the start date and time for this trigger in RFC3339 format: `2000-01-02T03:04:05Z`.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the time zone for this trigger. Supported time zone options are listed [here](https://support.microsoft.com/en-us/help/973627/microsoft-time-zone-index-values)
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.type_token("azure:logicapps/triggerRecurrence:TriggerRecurrence")
class TriggerRecurrence(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 logic_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['TriggerRecurrenceScheduleArgs', 'TriggerRecurrenceScheduleArgsDict']]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Recurrence Trigger within a Logic App Workflow

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="workflow-resources",
            location="West Europe")
        example_workflow = azure.logicapps.Workflow("example",
            name="workflow1",
            location=example.location,
            resource_group_name=example.name)
        example_trigger_recurrence = azure.logicapps.TriggerRecurrence("example",
            name="run-every-day",
            logic_app_id=example_workflow.id,
            frequency="Day",
            interval=1)
        ```

        ## Import

        Logic App Recurrence Triggers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/triggerRecurrence:TriggerRecurrence daily /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Logic/workflows/workflow1/triggers/daily
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] frequency: Specifies the Frequency at which this Trigger should be run. Possible values include `Month`, `Week`, `Day`, `Hour`, `Minute` and `Second`.
        :param pulumi.Input[builtins.int] interval: Specifies interval used for the Frequency, for example a value of `4` for `interval` and `hour` for `frequency` would run the Trigger every 4 hours.
        :param pulumi.Input[builtins.str] logic_app_id: Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Recurrence Triggers to be created within the Logic App Workflow. Changing this forces a new resource to be created.
               
               > **NOTE:** This name must be unique across all Triggers within the Logic App Workflow.
        :param pulumi.Input[Union['TriggerRecurrenceScheduleArgs', 'TriggerRecurrenceScheduleArgsDict']] schedule: A `schedule` block as specified below.
        :param pulumi.Input[builtins.str] start_time: Specifies the start date and time for this trigger in RFC3339 format: `2000-01-02T03:04:05Z`.
        :param pulumi.Input[builtins.str] time_zone: Specifies the time zone for this trigger. Supported time zone options are listed [here](https://support.microsoft.com/en-us/help/973627/microsoft-time-zone-index-values)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TriggerRecurrenceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Recurrence Trigger within a Logic App Workflow

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="workflow-resources",
            location="West Europe")
        example_workflow = azure.logicapps.Workflow("example",
            name="workflow1",
            location=example.location,
            resource_group_name=example.name)
        example_trigger_recurrence = azure.logicapps.TriggerRecurrence("example",
            name="run-every-day",
            logic_app_id=example_workflow.id,
            frequency="Day",
            interval=1)
        ```

        ## Import

        Logic App Recurrence Triggers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/triggerRecurrence:TriggerRecurrence daily /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Logic/workflows/workflow1/triggers/daily
        ```

        :param str resource_name: The name of the resource.
        :param TriggerRecurrenceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TriggerRecurrenceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 logic_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['TriggerRecurrenceScheduleArgs', 'TriggerRecurrenceScheduleArgsDict']]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TriggerRecurrenceArgs.__new__(TriggerRecurrenceArgs)

            if frequency is None and not opts.urn:
                raise TypeError("Missing required property 'frequency'")
            __props__.__dict__["frequency"] = frequency
            if interval is None and not opts.urn:
                raise TypeError("Missing required property 'interval'")
            __props__.__dict__["interval"] = interval
            if logic_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'logic_app_id'")
            __props__.__dict__["logic_app_id"] = logic_app_id
            __props__.__dict__["name"] = name
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["time_zone"] = time_zone
        super(TriggerRecurrence, __self__).__init__(
            'azure:logicapps/triggerRecurrence:TriggerRecurrence',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            frequency: Optional[pulumi.Input[builtins.str]] = None,
            interval: Optional[pulumi.Input[builtins.int]] = None,
            logic_app_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            schedule: Optional[pulumi.Input[Union['TriggerRecurrenceScheduleArgs', 'TriggerRecurrenceScheduleArgsDict']]] = None,
            start_time: Optional[pulumi.Input[builtins.str]] = None,
            time_zone: Optional[pulumi.Input[builtins.str]] = None) -> 'TriggerRecurrence':
        """
        Get an existing TriggerRecurrence resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] frequency: Specifies the Frequency at which this Trigger should be run. Possible values include `Month`, `Week`, `Day`, `Hour`, `Minute` and `Second`.
        :param pulumi.Input[builtins.int] interval: Specifies interval used for the Frequency, for example a value of `4` for `interval` and `hour` for `frequency` would run the Trigger every 4 hours.
        :param pulumi.Input[builtins.str] logic_app_id: Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Recurrence Triggers to be created within the Logic App Workflow. Changing this forces a new resource to be created.
               
               > **NOTE:** This name must be unique across all Triggers within the Logic App Workflow.
        :param pulumi.Input[Union['TriggerRecurrenceScheduleArgs', 'TriggerRecurrenceScheduleArgsDict']] schedule: A `schedule` block as specified below.
        :param pulumi.Input[builtins.str] start_time: Specifies the start date and time for this trigger in RFC3339 format: `2000-01-02T03:04:05Z`.
        :param pulumi.Input[builtins.str] time_zone: Specifies the time zone for this trigger. Supported time zone options are listed [here](https://support.microsoft.com/en-us/help/973627/microsoft-time-zone-index-values)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TriggerRecurrenceState.__new__(_TriggerRecurrenceState)

        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["interval"] = interval
        __props__.__dict__["logic_app_id"] = logic_app_id
        __props__.__dict__["name"] = name
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["time_zone"] = time_zone
        return TriggerRecurrence(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Frequency at which this Trigger should be run. Possible values include `Month`, `Week`, `Day`, `Hour`, `Minute` and `Second`.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[builtins.int]:
        """
        Specifies interval used for the Frequency, for example a value of `4` for `interval` and `hour` for `frequency` would run the Trigger every 4 hours.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="logicAppId")
    def logic_app_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "logic_app_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Recurrence Triggers to be created within the Logic App Workflow. Changing this forces a new resource to be created.

        > **NOTE:** This name must be unique across all Triggers within the Logic App Workflow.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.TriggerRecurrenceSchedule']]:
        """
        A `schedule` block as specified below.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the start date and time for this trigger in RFC3339 format: `2000-01-02T03:04:05Z`.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the time zone for this trigger. Supported time zone options are listed [here](https://support.microsoft.com/en-us/help/973627/microsoft-time-zone-index-values)
        """
        return pulumi.get(self, "time_zone")

