# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComputeInstanceArgs', 'ComputeInstance']

@pulumi.input_type
class ComputeInstanceArgs:
    def __init__(__self__, *,
                 machine_learning_workspace_id: pulumi.Input[builtins.str],
                 virtual_machine_size: pulumi.Input[builtins.str],
                 assign_to_user: Optional[pulumi.Input['ComputeInstanceAssignToUserArgs']] = None,
                 authorization_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input['ComputeInstanceIdentityArgs']] = None,
                 local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_public_ip_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ssh: Optional[pulumi.Input['ComputeInstanceSshArgs']] = None,
                 subnet_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ComputeInstance resource.
        :param pulumi.Input[builtins.str] machine_learning_workspace_id: The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] virtual_machine_size: The Virtual Machine Size. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input['ComputeInstanceAssignToUserArgs'] assign_to_user: A `assign_to_user` block as defined below. A user explicitly assigned to a personal compute instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] authorization_type: The Compute Instance Authorization type. Possible values include: `personal`. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] description: The description of the Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input['ComputeInstanceIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.bool] local_auth_enabled: Whether local authentication methods is enabled. Defaults to `true`. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.bool] node_public_ip_enabled: Whether the compute instance will have a public ip. To set this to false a `subnet_resource_id` needs to be set. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input['ComputeInstanceSshArgs'] ssh: A `ssh` block as defined below. Specifies policy and settings for SSH access. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] subnet_resource_id: Virtual network subnet resource ID the compute nodes belong to. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        pulumi.set(__self__, "machine_learning_workspace_id", machine_learning_workspace_id)
        pulumi.set(__self__, "virtual_machine_size", virtual_machine_size)
        if assign_to_user is not None:
            pulumi.set(__self__, "assign_to_user", assign_to_user)
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_auth_enabled is not None:
            pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_public_ip_enabled is not None:
            pulumi.set(__self__, "node_public_ip_enabled", node_public_ip_enabled)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)
        if subnet_resource_id is not None:
            pulumi.set(__self__, "subnet_resource_id", subnet_resource_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="machineLearningWorkspaceId")
    def machine_learning_workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "machine_learning_workspace_id")

    @machine_learning_workspace_id.setter
    def machine_learning_workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "machine_learning_workspace_id", value)

    @property
    @pulumi.getter(name="virtualMachineSize")
    def virtual_machine_size(self) -> pulumi.Input[builtins.str]:
        """
        The Virtual Machine Size. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "virtual_machine_size")

    @virtual_machine_size.setter
    def virtual_machine_size(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "virtual_machine_size", value)

    @property
    @pulumi.getter(name="assignToUser")
    def assign_to_user(self) -> Optional[pulumi.Input['ComputeInstanceAssignToUserArgs']]:
        """
        A `assign_to_user` block as defined below. A user explicitly assigned to a personal compute instance. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "assign_to_user")

    @assign_to_user.setter
    def assign_to_user(self, value: Optional[pulumi.Input['ComputeInstanceAssignToUserArgs']]):
        pulumi.set(self, "assign_to_user", value)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Compute Instance Authorization type. Possible values include: `personal`. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ComputeInstanceIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ComputeInstanceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether local authentication methods is enabled. Defaults to `true`. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "local_auth_enabled")

    @local_auth_enabled.setter
    def local_auth_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_auth_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodePublicIpEnabled")
    def node_public_ip_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the compute instance will have a public ip. To set this to false a `subnet_resource_id` needs to be set. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "node_public_ip_enabled")

    @node_public_ip_enabled.setter
    def node_public_ip_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "node_public_ip_enabled", value)

    @property
    @pulumi.getter
    def ssh(self) -> Optional[pulumi.Input['ComputeInstanceSshArgs']]:
        """
        A `ssh` block as defined below. Specifies policy and settings for SSH access. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "ssh")

    @ssh.setter
    def ssh(self, value: Optional[pulumi.Input['ComputeInstanceSshArgs']]):
        pulumi.set(self, "ssh", value)

    @property
    @pulumi.getter(name="subnetResourceId")
    def subnet_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Virtual network subnet resource ID the compute nodes belong to. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "subnet_resource_id")

    @subnet_resource_id.setter
    def subnet_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_resource_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ComputeInstanceState:
    def __init__(__self__, *,
                 assign_to_user: Optional[pulumi.Input['ComputeInstanceAssignToUserArgs']] = None,
                 authorization_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input['ComputeInstanceIdentityArgs']] = None,
                 local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 machine_learning_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_public_ip_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ssh: Optional[pulumi.Input['ComputeInstanceSshArgs']] = None,
                 subnet_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_machine_size: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ComputeInstance resources.
        :param pulumi.Input['ComputeInstanceAssignToUserArgs'] assign_to_user: A `assign_to_user` block as defined below. A user explicitly assigned to a personal compute instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] authorization_type: The Compute Instance Authorization type. Possible values include: `personal`. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] description: The description of the Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input['ComputeInstanceIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.bool] local_auth_enabled: Whether local authentication methods is enabled. Defaults to `true`. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] machine_learning_workspace_id: The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.bool] node_public_ip_enabled: Whether the compute instance will have a public ip. To set this to false a `subnet_resource_id` needs to be set. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input['ComputeInstanceSshArgs'] ssh: A `ssh` block as defined below. Specifies policy and settings for SSH access. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] subnet_resource_id: Virtual network subnet resource ID the compute nodes belong to. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] virtual_machine_size: The Virtual Machine Size. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        if assign_to_user is not None:
            pulumi.set(__self__, "assign_to_user", assign_to_user)
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_auth_enabled is not None:
            pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if machine_learning_workspace_id is not None:
            pulumi.set(__self__, "machine_learning_workspace_id", machine_learning_workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_public_ip_enabled is not None:
            pulumi.set(__self__, "node_public_ip_enabled", node_public_ip_enabled)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)
        if subnet_resource_id is not None:
            pulumi.set(__self__, "subnet_resource_id", subnet_resource_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_machine_size is not None:
            pulumi.set(__self__, "virtual_machine_size", virtual_machine_size)

    @property
    @pulumi.getter(name="assignToUser")
    def assign_to_user(self) -> Optional[pulumi.Input['ComputeInstanceAssignToUserArgs']]:
        """
        A `assign_to_user` block as defined below. A user explicitly assigned to a personal compute instance. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "assign_to_user")

    @assign_to_user.setter
    def assign_to_user(self, value: Optional[pulumi.Input['ComputeInstanceAssignToUserArgs']]):
        pulumi.set(self, "assign_to_user", value)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Compute Instance Authorization type. Possible values include: `personal`. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ComputeInstanceIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ComputeInstanceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether local authentication methods is enabled. Defaults to `true`. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "local_auth_enabled")

    @local_auth_enabled.setter
    def local_auth_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_auth_enabled", value)

    @property
    @pulumi.getter(name="machineLearningWorkspaceId")
    def machine_learning_workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "machine_learning_workspace_id")

    @machine_learning_workspace_id.setter
    def machine_learning_workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "machine_learning_workspace_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodePublicIpEnabled")
    def node_public_ip_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the compute instance will have a public ip. To set this to false a `subnet_resource_id` needs to be set. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "node_public_ip_enabled")

    @node_public_ip_enabled.setter
    def node_public_ip_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "node_public_ip_enabled", value)

    @property
    @pulumi.getter
    def ssh(self) -> Optional[pulumi.Input['ComputeInstanceSshArgs']]:
        """
        A `ssh` block as defined below. Specifies policy and settings for SSH access. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "ssh")

    @ssh.setter
    def ssh(self, value: Optional[pulumi.Input['ComputeInstanceSshArgs']]):
        pulumi.set(self, "ssh", value)

    @property
    @pulumi.getter(name="subnetResourceId")
    def subnet_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Virtual network subnet resource ID the compute nodes belong to. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "subnet_resource_id")

    @subnet_resource_id.setter
    def subnet_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_resource_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="virtualMachineSize")
    def virtual_machine_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Virtual Machine Size. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "virtual_machine_size")

    @virtual_machine_size.setter
    def virtual_machine_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_machine_size", value)


@pulumi.type_token("azure:machinelearning/computeInstance:ComputeInstance")
class ComputeInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_to_user: Optional[pulumi.Input[Union['ComputeInstanceAssignToUserArgs', 'ComputeInstanceAssignToUserArgsDict']]] = None,
                 authorization_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ComputeInstanceIdentityArgs', 'ComputeInstanceIdentityArgsDict']]] = None,
                 local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 machine_learning_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_public_ip_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ssh: Optional[pulumi.Input[Union['ComputeInstanceSshArgs', 'ComputeInstanceSshArgsDict']]] = None,
                 subnet_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_machine_size: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Machine Learning Compute Instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="west europe",
            tags={
                "stage": "example",
            })
        example_insights = azure.appinsights.Insights("example",
            name="example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-kv",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        example_account = azure.storage.Account("example",
            name="examplesa",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="LRS")
        example_workspace = azure.machinelearning.Workspace("example",
            name="example-mlw",
            location=example.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            identity={
                "type": "SystemAssigned",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.1.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.1.0.0/24"])
        config = pulumi.Config()
        ssh_key = config.get("sshKey")
        if ssh_key is None:
            ssh_key = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCqaZoyiz1qbdOQ8xEf6uEu1cCwYowo5FHtsBhqLoDnnp7KUTEBN+L2NxRIfQ781rxV6Iq5jSav6b2Q8z5KiseOlvKA/RF2wqU0UPYqQviQhLmW6THTpmrv/YkUCuzxDpsH7DUDhZcwySLKVVe0Qm3+5N2Ta6UYH3lsDf9R9wTP2K/+vAnflKebuypNlmocIvakFWoZda18FOmsOoIVXQ8HWFNCuw9ZCunMSN62QGamCe3dL5cXlkgHYv7ekJE15IA9aOJcM7e90oeTqo+7HTcWfdu0qQqPWY5ujyMw/llas8tsXY85LFqRnr3gJ02bAscjc477+X+j/gkpFoN1QEmt terraform@demo.tld"
        example_compute_instance = azure.machinelearning.ComputeInstance("example",
            name="example",
            machine_learning_workspace_id=example_workspace.id,
            virtual_machine_size="STANDARD_DS2_V2",
            authorization_type="personal",
            ssh={
                "public_key": ssh_key,
            },
            subnet_resource_id=example_subnet.id,
            description="foo",
            tags={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MachineLearningServices`: 2024-04-01

        ## Import

        Machine Learning Compute Instances can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:machinelearning/computeInstance:ComputeInstance example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.MachineLearningServices/workspaces/workspace1/computes/compute1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ComputeInstanceAssignToUserArgs', 'ComputeInstanceAssignToUserArgsDict']] assign_to_user: A `assign_to_user` block as defined below. A user explicitly assigned to a personal compute instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] authorization_type: The Compute Instance Authorization type. Possible values include: `personal`. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] description: The description of the Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[Union['ComputeInstanceIdentityArgs', 'ComputeInstanceIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.bool] local_auth_enabled: Whether local authentication methods is enabled. Defaults to `true`. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] machine_learning_workspace_id: The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.bool] node_public_ip_enabled: Whether the compute instance will have a public ip. To set this to false a `subnet_resource_id` needs to be set. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[Union['ComputeInstanceSshArgs', 'ComputeInstanceSshArgsDict']] ssh: A `ssh` block as defined below. Specifies policy and settings for SSH access. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] subnet_resource_id: Virtual network subnet resource ID the compute nodes belong to. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] virtual_machine_size: The Virtual Machine Size. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Machine Learning Compute Instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="west europe",
            tags={
                "stage": "example",
            })
        example_insights = azure.appinsights.Insights("example",
            name="example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-kv",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        example_account = azure.storage.Account("example",
            name="examplesa",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="LRS")
        example_workspace = azure.machinelearning.Workspace("example",
            name="example-mlw",
            location=example.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            identity={
                "type": "SystemAssigned",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.1.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.1.0.0/24"])
        config = pulumi.Config()
        ssh_key = config.get("sshKey")
        if ssh_key is None:
            ssh_key = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCqaZoyiz1qbdOQ8xEf6uEu1cCwYowo5FHtsBhqLoDnnp7KUTEBN+L2NxRIfQ781rxV6Iq5jSav6b2Q8z5KiseOlvKA/RF2wqU0UPYqQviQhLmW6THTpmrv/YkUCuzxDpsH7DUDhZcwySLKVVe0Qm3+5N2Ta6UYH3lsDf9R9wTP2K/+vAnflKebuypNlmocIvakFWoZda18FOmsOoIVXQ8HWFNCuw9ZCunMSN62QGamCe3dL5cXlkgHYv7ekJE15IA9aOJcM7e90oeTqo+7HTcWfdu0qQqPWY5ujyMw/llas8tsXY85LFqRnr3gJ02bAscjc477+X+j/gkpFoN1QEmt terraform@demo.tld"
        example_compute_instance = azure.machinelearning.ComputeInstance("example",
            name="example",
            machine_learning_workspace_id=example_workspace.id,
            virtual_machine_size="STANDARD_DS2_V2",
            authorization_type="personal",
            ssh={
                "public_key": ssh_key,
            },
            subnet_resource_id=example_subnet.id,
            description="foo",
            tags={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MachineLearningServices`: 2024-04-01

        ## Import

        Machine Learning Compute Instances can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:machinelearning/computeInstance:ComputeInstance example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.MachineLearningServices/workspaces/workspace1/computes/compute1
        ```

        :param str resource_name: The name of the resource.
        :param ComputeInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_to_user: Optional[pulumi.Input[Union['ComputeInstanceAssignToUserArgs', 'ComputeInstanceAssignToUserArgsDict']]] = None,
                 authorization_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ComputeInstanceIdentityArgs', 'ComputeInstanceIdentityArgsDict']]] = None,
                 local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 machine_learning_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_public_ip_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ssh: Optional[pulumi.Input[Union['ComputeInstanceSshArgs', 'ComputeInstanceSshArgsDict']]] = None,
                 subnet_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_machine_size: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeInstanceArgs.__new__(ComputeInstanceArgs)

            __props__.__dict__["assign_to_user"] = assign_to_user
            __props__.__dict__["authorization_type"] = authorization_type
            __props__.__dict__["description"] = description
            __props__.__dict__["identity"] = identity
            __props__.__dict__["local_auth_enabled"] = local_auth_enabled
            if machine_learning_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'machine_learning_workspace_id'")
            __props__.__dict__["machine_learning_workspace_id"] = machine_learning_workspace_id
            __props__.__dict__["name"] = name
            __props__.__dict__["node_public_ip_enabled"] = node_public_ip_enabled
            __props__.__dict__["ssh"] = ssh
            __props__.__dict__["subnet_resource_id"] = subnet_resource_id
            __props__.__dict__["tags"] = tags
            if virtual_machine_size is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_machine_size'")
            __props__.__dict__["virtual_machine_size"] = virtual_machine_size
        super(ComputeInstance, __self__).__init__(
            'azure:machinelearning/computeInstance:ComputeInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assign_to_user: Optional[pulumi.Input[Union['ComputeInstanceAssignToUserArgs', 'ComputeInstanceAssignToUserArgsDict']]] = None,
            authorization_type: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ComputeInstanceIdentityArgs', 'ComputeInstanceIdentityArgsDict']]] = None,
            local_auth_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            machine_learning_workspace_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            node_public_ip_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            ssh: Optional[pulumi.Input[Union['ComputeInstanceSshArgs', 'ComputeInstanceSshArgsDict']]] = None,
            subnet_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            virtual_machine_size: Optional[pulumi.Input[builtins.str]] = None) -> 'ComputeInstance':
        """
        Get an existing ComputeInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ComputeInstanceAssignToUserArgs', 'ComputeInstanceAssignToUserArgsDict']] assign_to_user: A `assign_to_user` block as defined below. A user explicitly assigned to a personal compute instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] authorization_type: The Compute Instance Authorization type. Possible values include: `personal`. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] description: The description of the Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[Union['ComputeInstanceIdentityArgs', 'ComputeInstanceIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.bool] local_auth_enabled: Whether local authentication methods is enabled. Defaults to `true`. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] machine_learning_workspace_id: The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.bool] node_public_ip_enabled: Whether the compute instance will have a public ip. To set this to false a `subnet_resource_id` needs to be set. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[Union['ComputeInstanceSshArgs', 'ComputeInstanceSshArgsDict']] ssh: A `ssh` block as defined below. Specifies policy and settings for SSH access. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] subnet_resource_id: Virtual network subnet resource ID the compute nodes belong to. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        :param pulumi.Input[builtins.str] virtual_machine_size: The Virtual Machine Size. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeInstanceState.__new__(_ComputeInstanceState)

        __props__.__dict__["assign_to_user"] = assign_to_user
        __props__.__dict__["authorization_type"] = authorization_type
        __props__.__dict__["description"] = description
        __props__.__dict__["identity"] = identity
        __props__.__dict__["local_auth_enabled"] = local_auth_enabled
        __props__.__dict__["machine_learning_workspace_id"] = machine_learning_workspace_id
        __props__.__dict__["name"] = name
        __props__.__dict__["node_public_ip_enabled"] = node_public_ip_enabled
        __props__.__dict__["ssh"] = ssh
        __props__.__dict__["subnet_resource_id"] = subnet_resource_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_machine_size"] = virtual_machine_size
        return ComputeInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="assignToUser")
    def assign_to_user(self) -> pulumi.Output[Optional['outputs.ComputeInstanceAssignToUser']]:
        """
        A `assign_to_user` block as defined below. A user explicitly assigned to a personal compute instance. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "assign_to_user")

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Compute Instance Authorization type. Possible values include: `personal`. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ComputeInstanceIdentity']]:
        """
        An `identity` block as defined below. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether local authentication methods is enabled. Defaults to `true`. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "local_auth_enabled")

    @property
    @pulumi.getter(name="machineLearningWorkspaceId")
    def machine_learning_workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "machine_learning_workspace_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodePublicIpEnabled")
    def node_public_ip_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the compute instance will have a public ip. To set this to false a `subnet_resource_id` needs to be set. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "node_public_ip_enabled")

    @property
    @pulumi.getter
    def ssh(self) -> pulumi.Output[Optional['outputs.ComputeInstanceSsh']]:
        """
        A `ssh` block as defined below. Specifies policy and settings for SSH access. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "ssh")

    @property
    @pulumi.getter(name="subnetResourceId")
    def subnet_resource_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Virtual network subnet resource ID the compute nodes belong to. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "subnet_resource_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Machine Learning Compute Instance. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="virtualMachineSize")
    def virtual_machine_size(self) -> pulumi.Output[builtins.str]:
        """
        The Virtual Machine Size. Changing this forces a new Machine Learning Compute Instance to be created.
        """
        return pulumi.get(self, "virtual_machine_size")

