# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DatastoreDatalakeGen2Args', 'DatastoreDatalakeGen2']

@pulumi.input_type
class DatastoreDatalakeGen2Args:
    def __init__(__self__, *,
                 storage_container_id: pulumi.Input[builtins.str],
                 workspace_id: pulumi.Input[builtins.str],
                 authority_url: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_data_identity: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DatastoreDatalakeGen2 resource.
        :param pulumi.Input[builtins.str] storage_container_id: The ID of the Storage Account Container. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[builtins.str] authority_url: An URL used for authentication.
        :param pulumi.Input[builtins.str] client_id: The object ID of the Service Principal.
        :param pulumi.Input[builtins.str] client_secret: The secret of the Service Principal.
        :param pulumi.Input[builtins.str] description: Text used to describe the asset. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[builtins.str] name: The name of the Machine Learning DataStore. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[builtins.str] service_data_identity: Specifies which identity to use when retrieving data from the specified source. Defaults to `None`. Possible values are `None`, `WorkspaceSystemAssignedIdentity` and `WorkspaceUserAssignedIdentity`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Machine Learning DataStore. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[builtins.str] tenant_id: The ID of the Tenant which the Service Principal belongs to.
        """
        pulumi.set(__self__, "storage_container_id", storage_container_id)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_data_identity is not None:
            pulumi.set(__self__, "service_data_identity", service_data_identity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="storageContainerId")
    def storage_container_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Storage Account Container. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "storage_container_id")

    @storage_container_id.setter
    def storage_container_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_container_id", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @authority_url.setter
    def authority_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authority_url", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The object ID of the Service Principal.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret of the Service Principal.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Text used to describe the asset. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Machine Learning DataStore. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceDataIdentity")
    def service_data_identity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which identity to use when retrieving data from the specified source. Defaults to `None`. Possible values are `None`, `WorkspaceSystemAssignedIdentity` and `WorkspaceUserAssignedIdentity`.
        """
        return pulumi.get(self, "service_data_identity")

    @service_data_identity.setter
    def service_data_identity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_data_identity", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Machine Learning DataStore. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Tenant which the Service Principal belongs to.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _DatastoreDatalakeGen2State:
    def __init__(__self__, *,
                 authority_url: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_data_identity: Optional[pulumi.Input[builtins.str]] = None,
                 storage_container_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatastoreDatalakeGen2 resources.
        :param pulumi.Input[builtins.str] authority_url: An URL used for authentication.
        :param pulumi.Input[builtins.str] client_id: The object ID of the Service Principal.
        :param pulumi.Input[builtins.str] client_secret: The secret of the Service Principal.
        :param pulumi.Input[builtins.str] description: Text used to describe the asset. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[builtins.bool] is_default: Indicates whether this Machines Learning DataStore is the default for the Workspace.
        :param pulumi.Input[builtins.str] name: The name of the Machine Learning DataStore. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[builtins.str] service_data_identity: Specifies which identity to use when retrieving data from the specified source. Defaults to `None`. Possible values are `None`, `WorkspaceSystemAssignedIdentity` and `WorkspaceUserAssignedIdentity`.
        :param pulumi.Input[builtins.str] storage_container_id: The ID of the Storage Account Container. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Machine Learning DataStore. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[builtins.str] tenant_id: The ID of the Tenant which the Service Principal belongs to.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning DataStore to be created.
        """
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_data_identity is not None:
            pulumi.set(__self__, "service_data_identity", service_data_identity)
        if storage_container_id is not None:
            pulumi.set(__self__, "storage_container_id", storage_container_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @authority_url.setter
    def authority_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authority_url", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The object ID of the Service Principal.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret of the Service Principal.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Text used to describe the asset. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether this Machines Learning DataStore is the default for the Workspace.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Machine Learning DataStore. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceDataIdentity")
    def service_data_identity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which identity to use when retrieving data from the specified source. Defaults to `None`. Possible values are `None`, `WorkspaceSystemAssignedIdentity` and `WorkspaceUserAssignedIdentity`.
        """
        return pulumi.get(self, "service_data_identity")

    @service_data_identity.setter
    def service_data_identity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_data_identity", value)

    @property
    @pulumi.getter(name="storageContainerId")
    def storage_container_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Storage Account Container. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "storage_container_id")

    @storage_container_id.setter
    def storage_container_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_container_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Machine Learning DataStore. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Tenant which the Service Principal belongs to.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("azure:machinelearning/datastoreDatalakeGen2:DatastoreDatalakeGen2")
class DatastoreDatalakeGen2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authority_url: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_data_identity: Optional[pulumi.Input[builtins.str]] = None,
                 storage_container_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Machine Learning Data Lake Gen2 DataStore.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="workspace-example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="workspaceexamplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium")
        example_account = azure.storage.Account("example",
            name="workspacestorageaccount",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="GRS")
        example_workspace = azure.machinelearning.Workspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            identity={
                "type": "SystemAssigned",
            })
        example_container = azure.storage.Container("example",
            name="example-container",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_datastore_datalake_gen2 = azure.machinelearning.DatastoreDatalakeGen2("example",
            name="example-datastore",
            workspace_id=example_workspace.id,
            storage_container_id=example_container.resource_manager_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MachineLearningServices`: 2024-04-01

        ## Import

        Machine Learning DataStores can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:machinelearning/datastoreDatalakeGen2:DatastoreDatalakeGen2 example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.MachineLearningServices/workspaces/mlw1/dataStores/datastore1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authority_url: An URL used for authentication.
        :param pulumi.Input[builtins.str] client_id: The object ID of the Service Principal.
        :param pulumi.Input[builtins.str] client_secret: The secret of the Service Principal.
        :param pulumi.Input[builtins.str] description: Text used to describe the asset. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[builtins.str] name: The name of the Machine Learning DataStore. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[builtins.str] service_data_identity: Specifies which identity to use when retrieving data from the specified source. Defaults to `None`. Possible values are `None`, `WorkspaceSystemAssignedIdentity` and `WorkspaceUserAssignedIdentity`.
        :param pulumi.Input[builtins.str] storage_container_id: The ID of the Storage Account Container. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Machine Learning DataStore. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[builtins.str] tenant_id: The ID of the Tenant which the Service Principal belongs to.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning DataStore to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatastoreDatalakeGen2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Machine Learning Data Lake Gen2 DataStore.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="workspace-example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="workspaceexamplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium")
        example_account = azure.storage.Account("example",
            name="workspacestorageaccount",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="GRS")
        example_workspace = azure.machinelearning.Workspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            identity={
                "type": "SystemAssigned",
            })
        example_container = azure.storage.Container("example",
            name="example-container",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_datastore_datalake_gen2 = azure.machinelearning.DatastoreDatalakeGen2("example",
            name="example-datastore",
            workspace_id=example_workspace.id,
            storage_container_id=example_container.resource_manager_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MachineLearningServices`: 2024-04-01

        ## Import

        Machine Learning DataStores can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:machinelearning/datastoreDatalakeGen2:DatastoreDatalakeGen2 example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.MachineLearningServices/workspaces/mlw1/dataStores/datastore1
        ```

        :param str resource_name: The name of the resource.
        :param DatastoreDatalakeGen2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatastoreDatalakeGen2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authority_url: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_data_identity: Optional[pulumi.Input[builtins.str]] = None,
                 storage_container_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatastoreDatalakeGen2Args.__new__(DatastoreDatalakeGen2Args)

            __props__.__dict__["authority_url"] = authority_url
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["service_data_identity"] = service_data_identity
            if storage_container_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_container_id'")
            __props__.__dict__["storage_container_id"] = storage_container_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenant_id"] = tenant_id
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["is_default"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DatastoreDatalakeGen2, __self__).__init__(
            'azure:machinelearning/datastoreDatalakeGen2:DatastoreDatalakeGen2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authority_url: Optional[pulumi.Input[builtins.str]] = None,
            client_id: Optional[pulumi.Input[builtins.str]] = None,
            client_secret: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            is_default: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            service_data_identity: Optional[pulumi.Input[builtins.str]] = None,
            storage_container_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tenant_id: Optional[pulumi.Input[builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[builtins.str]] = None) -> 'DatastoreDatalakeGen2':
        """
        Get an existing DatastoreDatalakeGen2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authority_url: An URL used for authentication.
        :param pulumi.Input[builtins.str] client_id: The object ID of the Service Principal.
        :param pulumi.Input[builtins.str] client_secret: The secret of the Service Principal.
        :param pulumi.Input[builtins.str] description: Text used to describe the asset. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[builtins.bool] is_default: Indicates whether this Machines Learning DataStore is the default for the Workspace.
        :param pulumi.Input[builtins.str] name: The name of the Machine Learning DataStore. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[builtins.str] service_data_identity: Specifies which identity to use when retrieving data from the specified source. Defaults to `None`. Possible values are `None`, `WorkspaceSystemAssignedIdentity` and `WorkspaceUserAssignedIdentity`.
        :param pulumi.Input[builtins.str] storage_container_id: The ID of the Storage Account Container. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Machine Learning DataStore. Changing this forces a new Machine Learning DataStore to be created.
        :param pulumi.Input[builtins.str] tenant_id: The ID of the Tenant which the Service Principal belongs to.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning DataStore to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatastoreDatalakeGen2State.__new__(_DatastoreDatalakeGen2State)

        __props__.__dict__["authority_url"] = authority_url
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["description"] = description
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        __props__.__dict__["service_data_identity"] = service_data_identity
        __props__.__dict__["storage_container_id"] = storage_container_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["workspace_id"] = workspace_id
        return DatastoreDatalakeGen2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The object ID of the Service Principal.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The secret of the Service Principal.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Text used to describe the asset. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether this Machines Learning DataStore is the default for the Workspace.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Machine Learning DataStore. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceDataIdentity")
    def service_data_identity(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies which identity to use when retrieving data from the specified source. Defaults to `None`. Possible values are `None`, `WorkspaceSystemAssignedIdentity` and `WorkspaceUserAssignedIdentity`.
        """
        return pulumi.get(self, "service_data_identity")

    @property
    @pulumi.getter(name="storageContainerId")
    def storage_container_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Storage Account Container. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "storage_container_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Machine Learning DataStore. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the Tenant which the Service Principal belongs to.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning DataStore to be created.
        """
        return pulumi.get(self, "workspace_id")

