# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AssignmentVirtualMachineArgs', 'AssignmentVirtualMachine']

@pulumi.input_type
class AssignmentVirtualMachineArgs:
    def __init__(__self__, *,
                 maintenance_configuration_id: pulumi.Input[builtins.str],
                 virtual_machine_id: pulumi.Input[builtins.str],
                 location: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AssignmentVirtualMachine resource.
        :param pulumi.Input[builtins.str] maintenance_configuration_id: Specifies the ID of the Maintenance Configuration Resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] virtual_machine_id: Specifies the Virtual Machine ID to which the Maintenance Configuration will be assigned. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "maintenance_configuration_id", maintenance_configuration_id)
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="maintenanceConfigurationId")
    def maintenance_configuration_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the ID of the Maintenance Configuration Resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maintenance_configuration_id")

    @maintenance_configuration_id.setter
    def maintenance_configuration_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "maintenance_configuration_id", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Virtual Machine ID to which the Maintenance Configuration will be assigned. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class _AssignmentVirtualMachineState:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AssignmentVirtualMachine resources.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] maintenance_configuration_id: Specifies the ID of the Maintenance Configuration Resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] virtual_machine_id: Specifies the Virtual Machine ID to which the Maintenance Configuration will be assigned. Changing this forces a new resource to be created.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_configuration_id is not None:
            pulumi.set(__self__, "maintenance_configuration_id", maintenance_configuration_id)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maintenanceConfigurationId")
    def maintenance_configuration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the Maintenance Configuration Resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maintenance_configuration_id")

    @maintenance_configuration_id.setter
    def maintenance_configuration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_configuration_id", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Virtual Machine ID to which the Maintenance Configuration will be assigned. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_machine_id", value)


@pulumi.type_token("azure:maintenance/assignmentVirtualMachine:AssignmentVirtualMachine")
class AssignmentVirtualMachine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a maintenance assignment to virtual machine.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="example-machine",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_F2",
            admin_username="adminuser",
            network_interface_ids=[example_network_interface.id],
            admin_ssh_keys=[{
                "username": "adminuser",
                "public_key": std.file(input="~/.ssh/id_rsa.pub").result,
            }],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_configuration = azure.maintenance.Configuration("example",
            name="example-mc",
            resource_group_name=example.name,
            location=example.location,
            scope="All")
        example_assignment_virtual_machine = azure.maintenance.AssignmentVirtualMachine("example",
            location=example.location,
            maintenance_configuration_id=example_configuration.id,
            virtual_machine_id=example_linux_virtual_machine.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Maintenance`: 2023-04-01

        ## Import

        Maintenance Assignment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:maintenance/assignmentVirtualMachine:AssignmentVirtualMachine example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.Compute/virtualMachines/vm1/providers/Microsoft.Maintenance/configurationAssignments/assign1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] maintenance_configuration_id: Specifies the ID of the Maintenance Configuration Resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] virtual_machine_id: Specifies the Virtual Machine ID to which the Maintenance Configuration will be assigned. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssignmentVirtualMachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a maintenance assignment to virtual machine.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="example-machine",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_F2",
            admin_username="adminuser",
            network_interface_ids=[example_network_interface.id],
            admin_ssh_keys=[{
                "username": "adminuser",
                "public_key": std.file(input="~/.ssh/id_rsa.pub").result,
            }],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_configuration = azure.maintenance.Configuration("example",
            name="example-mc",
            resource_group_name=example.name,
            location=example.location,
            scope="All")
        example_assignment_virtual_machine = azure.maintenance.AssignmentVirtualMachine("example",
            location=example.location,
            maintenance_configuration_id=example_configuration.id,
            virtual_machine_id=example_linux_virtual_machine.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Maintenance`: 2023-04-01

        ## Import

        Maintenance Assignment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:maintenance/assignmentVirtualMachine:AssignmentVirtualMachine example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.Compute/virtualMachines/vm1/providers/Microsoft.Maintenance/configurationAssignments/assign1
        ```

        :param str resource_name: The name of the resource.
        :param AssignmentVirtualMachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssignmentVirtualMachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssignmentVirtualMachineArgs.__new__(AssignmentVirtualMachineArgs)

            __props__.__dict__["location"] = location
            if maintenance_configuration_id is None and not opts.urn:
                raise TypeError("Missing required property 'maintenance_configuration_id'")
            __props__.__dict__["maintenance_configuration_id"] = maintenance_configuration_id
            if virtual_machine_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_machine_id'")
            __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        super(AssignmentVirtualMachine, __self__).__init__(
            'azure:maintenance/assignmentVirtualMachine:AssignmentVirtualMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            maintenance_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
            virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None) -> 'AssignmentVirtualMachine':
        """
        Get an existing AssignmentVirtualMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] maintenance_configuration_id: Specifies the ID of the Maintenance Configuration Resource. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] virtual_machine_id: Specifies the Virtual Machine ID to which the Maintenance Configuration will be assigned. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssignmentVirtualMachineState.__new__(_AssignmentVirtualMachineState)

        __props__.__dict__["location"] = location
        __props__.__dict__["maintenance_configuration_id"] = maintenance_configuration_id
        __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        return AssignmentVirtualMachine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maintenanceConfigurationId")
    def maintenance_configuration_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the ID of the Maintenance Configuration Resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maintenance_configuration_id")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Virtual Machine ID to which the Maintenance Configuration will be assigned. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

