# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AssignmentDynamicScopeFilter',
    'AssignmentDynamicScopeFilterTag',
    'ConfigurationInstallPatches',
    'ConfigurationInstallPatchesLinux',
    'ConfigurationInstallPatchesWindow',
    'ConfigurationWindow',
    'GetConfigurationInstallPatchResult',
    'GetConfigurationInstallPatchLinuxResult',
    'GetConfigurationInstallPatchWindowResult',
    'GetConfigurationWindowResult',
    'GetPublicConfigurationsConfigResult',
]

@pulumi.output_type
class AssignmentDynamicScopeFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osTypes":
            suggest = "os_types"
        elif key == "resourceGroups":
            suggest = "resource_groups"
        elif key == "resourceTypes":
            suggest = "resource_types"
        elif key == "tagFilter":
            suggest = "tag_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssignmentDynamicScopeFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssignmentDynamicScopeFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssignmentDynamicScopeFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 locations: Optional[Sequence[builtins.str]] = None,
                 os_types: Optional[Sequence[builtins.str]] = None,
                 resource_groups: Optional[Sequence[builtins.str]] = None,
                 resource_types: Optional[Sequence[builtins.str]] = None,
                 tag_filter: Optional[builtins.str] = None,
                 tags: Optional[Sequence['outputs.AssignmentDynamicScopeFilterTag']] = None):
        """
        :param Sequence[builtins.str] locations: Specifies a list of locations to scope the query to.
        :param Sequence[builtins.str] os_types: Specifies a list of allowed operating systems.
        :param Sequence[builtins.str] resource_groups: Specifies a list of allowed resource groups.
        :param Sequence[builtins.str] resource_types: Specifies a list of allowed resources.
        :param builtins.str tag_filter: Filter VMs by `Any` or `All` specified tags. Defaults to `Any`.
        :param Sequence['AssignmentDynamicScopeFilterTagArgs'] tags: A mapping of tags for the VM
        """
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if os_types is not None:
            pulumi.set(__self__, "os_types", os_types)
        if resource_groups is not None:
            pulumi.set(__self__, "resource_groups", resource_groups)
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)
        if tag_filter is not None:
            pulumi.set(__self__, "tag_filter", tag_filter)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of locations to scope the query to.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="osTypes")
    def os_types(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of allowed operating systems.
        """
        return pulumi.get(self, "os_types")

    @property
    @pulumi.getter(name="resourceGroups")
    def resource_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of allowed resource groups.
        """
        return pulumi.get(self, "resource_groups")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of allowed resources.
        """
        return pulumi.get(self, "resource_types")

    @property
    @pulumi.getter(name="tagFilter")
    def tag_filter(self) -> Optional[builtins.str]:
        """
        Filter VMs by `Any` or `All` specified tags. Defaults to `Any`.
        """
        return pulumi.get(self, "tag_filter")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.AssignmentDynamicScopeFilterTag']]:
        """
        A mapping of tags for the VM
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class AssignmentDynamicScopeFilterTag(dict):
    def __init__(__self__, *,
                 tag: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str tag: Specifies the tag to filter by.
        :param Sequence[builtins.str] values: Specifies a list of values the defined tag can have.
        """
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def tag(self) -> builtins.str:
        """
        Specifies the tag to filter by.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Specifies a list of values the defined tag can have.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ConfigurationInstallPatches(dict):
    def __init__(__self__, *,
                 linuxes: Optional[Sequence['outputs.ConfigurationInstallPatchesLinux']] = None,
                 reboot: Optional[builtins.str] = None,
                 windows: Optional[Sequence['outputs.ConfigurationInstallPatchesWindow']] = None):
        """
        :param Sequence['ConfigurationInstallPatchesLinuxArgs'] linuxes: A `linux` block as defined above. This property only applies when `scope` is set to `InGuestPatch`
        :param builtins.str reboot: Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after the patch operation is completed. Possible values are `Always`, `IfRequired` and `Never`. This property only applies when `scope` is set to `InGuestPatch`.
        :param Sequence['ConfigurationInstallPatchesWindowArgs'] windows: A `windows` block as defined above. This property only applies when `scope` is set to `InGuestPatch`
        """
        if linuxes is not None:
            pulumi.set(__self__, "linuxes", linuxes)
        if reboot is not None:
            pulumi.set(__self__, "reboot", reboot)
        if windows is not None:
            pulumi.set(__self__, "windows", windows)

    @property
    @pulumi.getter
    def linuxes(self) -> Optional[Sequence['outputs.ConfigurationInstallPatchesLinux']]:
        """
        A `linux` block as defined above. This property only applies when `scope` is set to `InGuestPatch`
        """
        return pulumi.get(self, "linuxes")

    @property
    @pulumi.getter
    def reboot(self) -> Optional[builtins.str]:
        """
        Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after the patch operation is completed. Possible values are `Always`, `IfRequired` and `Never`. This property only applies when `scope` is set to `InGuestPatch`.
        """
        return pulumi.get(self, "reboot")

    @property
    @pulumi.getter
    def windows(self) -> Optional[Sequence['outputs.ConfigurationInstallPatchesWindow']]:
        """
        A `windows` block as defined above. This property only applies when `scope` is set to `InGuestPatch`
        """
        return pulumi.get(self, "windows")


@pulumi.output_type
class ConfigurationInstallPatchesLinux(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "classificationsToIncludes":
            suggest = "classifications_to_includes"
        elif key == "packageNamesMaskToExcludes":
            suggest = "package_names_mask_to_excludes"
        elif key == "packageNamesMaskToIncludes":
            suggest = "package_names_mask_to_includes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationInstallPatchesLinux. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationInstallPatchesLinux.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationInstallPatchesLinux.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classifications_to_includes: Optional[Sequence[builtins.str]] = None,
                 package_names_mask_to_excludes: Optional[Sequence[builtins.str]] = None,
                 package_names_mask_to_includes: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] classifications_to_includes: List of Classification category of patches to be patched. Possible values are `Critical`, `Security` and `Other`.
        :param Sequence[builtins.str] package_names_mask_to_excludes: List of package names to be excluded from patching.
        :param Sequence[builtins.str] package_names_mask_to_includes: List of package names to be included for patching.
        """
        if classifications_to_includes is not None:
            pulumi.set(__self__, "classifications_to_includes", classifications_to_includes)
        if package_names_mask_to_excludes is not None:
            pulumi.set(__self__, "package_names_mask_to_excludes", package_names_mask_to_excludes)
        if package_names_mask_to_includes is not None:
            pulumi.set(__self__, "package_names_mask_to_includes", package_names_mask_to_includes)

    @property
    @pulumi.getter(name="classificationsToIncludes")
    def classifications_to_includes(self) -> Optional[Sequence[builtins.str]]:
        """
        List of Classification category of patches to be patched. Possible values are `Critical`, `Security` and `Other`.
        """
        return pulumi.get(self, "classifications_to_includes")

    @property
    @pulumi.getter(name="packageNamesMaskToExcludes")
    def package_names_mask_to_excludes(self) -> Optional[Sequence[builtins.str]]:
        """
        List of package names to be excluded from patching.
        """
        return pulumi.get(self, "package_names_mask_to_excludes")

    @property
    @pulumi.getter(name="packageNamesMaskToIncludes")
    def package_names_mask_to_includes(self) -> Optional[Sequence[builtins.str]]:
        """
        List of package names to be included for patching.
        """
        return pulumi.get(self, "package_names_mask_to_includes")


@pulumi.output_type
class ConfigurationInstallPatchesWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "classificationsToIncludes":
            suggest = "classifications_to_includes"
        elif key == "kbNumbersToExcludes":
            suggest = "kb_numbers_to_excludes"
        elif key == "kbNumbersToIncludes":
            suggest = "kb_numbers_to_includes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationInstallPatchesWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationInstallPatchesWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationInstallPatchesWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classifications_to_includes: Optional[Sequence[builtins.str]] = None,
                 kb_numbers_to_excludes: Optional[Sequence[builtins.str]] = None,
                 kb_numbers_to_includes: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] classifications_to_includes: List of Classification category of patches to be patched. Possible values are `Critical`, `Security`, `UpdateRollup`, `FeaturePack`, `ServicePack`, `Definition`, `Tools` and `Updates`.
        :param Sequence[builtins.str] kb_numbers_to_excludes: List of KB numbers to be excluded from patching.
        :param Sequence[builtins.str] kb_numbers_to_includes: List of KB numbers to be included for patching.
        """
        if classifications_to_includes is not None:
            pulumi.set(__self__, "classifications_to_includes", classifications_to_includes)
        if kb_numbers_to_excludes is not None:
            pulumi.set(__self__, "kb_numbers_to_excludes", kb_numbers_to_excludes)
        if kb_numbers_to_includes is not None:
            pulumi.set(__self__, "kb_numbers_to_includes", kb_numbers_to_includes)

    @property
    @pulumi.getter(name="classificationsToIncludes")
    def classifications_to_includes(self) -> Optional[Sequence[builtins.str]]:
        """
        List of Classification category of patches to be patched. Possible values are `Critical`, `Security`, `UpdateRollup`, `FeaturePack`, `ServicePack`, `Definition`, `Tools` and `Updates`.
        """
        return pulumi.get(self, "classifications_to_includes")

    @property
    @pulumi.getter(name="kbNumbersToExcludes")
    def kb_numbers_to_excludes(self) -> Optional[Sequence[builtins.str]]:
        """
        List of KB numbers to be excluded from patching.
        """
        return pulumi.get(self, "kb_numbers_to_excludes")

    @property
    @pulumi.getter(name="kbNumbersToIncludes")
    def kb_numbers_to_includes(self) -> Optional[Sequence[builtins.str]]:
        """
        List of KB numbers to be included for patching.
        """
        return pulumi.get(self, "kb_numbers_to_includes")


@pulumi.output_type
class ConfigurationWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startDateTime":
            suggest = "start_date_time"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "expirationDateTime":
            suggest = "expiration_date_time"
        elif key == "recurEvery":
            suggest = "recur_every"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_date_time: builtins.str,
                 time_zone: builtins.str,
                 duration: Optional[builtins.str] = None,
                 expiration_date_time: Optional[builtins.str] = None,
                 recur_every: Optional[builtins.str] = None):
        """
        :param builtins.str start_date_time: Effective start date of the maintenance window in YYYY-MM-DD hh:mm format.
        :param builtins.str time_zone: The time zone for the maintenance window. A list of timezones can be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
        :param builtins.str duration: The duration of the maintenance window in HH:mm format.
        :param builtins.str expiration_date_time: Effective expiration date of the maintenance window in YYYY-MM-DD hh:mm format.
        :param builtins.str recur_every: The rate at which a maintenance window is expected to recur. The rate can be expressed as daily, weekly, or monthly schedules.
        """
        pulumi.set(__self__, "start_date_time", start_date_time)
        pulumi.set(__self__, "time_zone", time_zone)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if expiration_date_time is not None:
            pulumi.set(__self__, "expiration_date_time", expiration_date_time)
        if recur_every is not None:
            pulumi.set(__self__, "recur_every", recur_every)

    @property
    @pulumi.getter(name="startDateTime")
    def start_date_time(self) -> builtins.str:
        """
        Effective start date of the maintenance window in YYYY-MM-DD hh:mm format.
        """
        return pulumi.get(self, "start_date_time")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        The time zone for the maintenance window. A list of timezones can be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def duration(self) -> Optional[builtins.str]:
        """
        The duration of the maintenance window in HH:mm format.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="expirationDateTime")
    def expiration_date_time(self) -> Optional[builtins.str]:
        """
        Effective expiration date of the maintenance window in YYYY-MM-DD hh:mm format.
        """
        return pulumi.get(self, "expiration_date_time")

    @property
    @pulumi.getter(name="recurEvery")
    def recur_every(self) -> Optional[builtins.str]:
        """
        The rate at which a maintenance window is expected to recur. The rate can be expressed as daily, weekly, or monthly schedules.
        """
        return pulumi.get(self, "recur_every")


@pulumi.output_type
class GetConfigurationInstallPatchResult(dict):
    def __init__(__self__, *,
                 linuxes: Sequence['outputs.GetConfigurationInstallPatchLinuxResult'],
                 reboot: builtins.str,
                 windows: Sequence['outputs.GetConfigurationInstallPatchWindowResult']):
        """
        :param Sequence['GetConfigurationInstallPatchLinuxArgs'] linuxes: A `linux` block as defined below.
        :param builtins.str reboot: Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after the patch operation is completed.
        :param Sequence['GetConfigurationInstallPatchWindowArgs'] windows: A `windows` block as defined below.
        """
        pulumi.set(__self__, "linuxes", linuxes)
        pulumi.set(__self__, "reboot", reboot)
        pulumi.set(__self__, "windows", windows)

    @property
    @pulumi.getter
    def linuxes(self) -> Sequence['outputs.GetConfigurationInstallPatchLinuxResult']:
        """
        A `linux` block as defined below.
        """
        return pulumi.get(self, "linuxes")

    @property
    @pulumi.getter
    def reboot(self) -> builtins.str:
        """
        Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after the patch operation is completed.
        """
        return pulumi.get(self, "reboot")

    @property
    @pulumi.getter
    def windows(self) -> Sequence['outputs.GetConfigurationInstallPatchWindowResult']:
        """
        A `windows` block as defined below.
        """
        return pulumi.get(self, "windows")


@pulumi.output_type
class GetConfigurationInstallPatchLinuxResult(dict):
    def __init__(__self__, *,
                 classifications_to_includes: Sequence[builtins.str],
                 package_names_mask_to_excludes: Sequence[builtins.str],
                 package_names_mask_to_includes: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] classifications_to_includes: List of Classification category of patches to be patched.
        :param Sequence[builtins.str] package_names_mask_to_excludes: List of package names to be excluded from patching.
        :param Sequence[builtins.str] package_names_mask_to_includes: List of package names to be included for patching.
        """
        pulumi.set(__self__, "classifications_to_includes", classifications_to_includes)
        pulumi.set(__self__, "package_names_mask_to_excludes", package_names_mask_to_excludes)
        pulumi.set(__self__, "package_names_mask_to_includes", package_names_mask_to_includes)

    @property
    @pulumi.getter(name="classificationsToIncludes")
    def classifications_to_includes(self) -> Sequence[builtins.str]:
        """
        List of Classification category of patches to be patched.
        """
        return pulumi.get(self, "classifications_to_includes")

    @property
    @pulumi.getter(name="packageNamesMaskToExcludes")
    def package_names_mask_to_excludes(self) -> Sequence[builtins.str]:
        """
        List of package names to be excluded from patching.
        """
        return pulumi.get(self, "package_names_mask_to_excludes")

    @property
    @pulumi.getter(name="packageNamesMaskToIncludes")
    def package_names_mask_to_includes(self) -> Sequence[builtins.str]:
        """
        List of package names to be included for patching.
        """
        return pulumi.get(self, "package_names_mask_to_includes")


@pulumi.output_type
class GetConfigurationInstallPatchWindowResult(dict):
    def __init__(__self__, *,
                 classifications_to_includes: Sequence[builtins.str],
                 kb_numbers_to_excludes: Sequence[builtins.str],
                 kb_numbers_to_includes: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] classifications_to_includes: List of Classification category of patches to be patched.
        :param Sequence[builtins.str] kb_numbers_to_excludes: List of KB numbers to be excluded from patching.
        :param Sequence[builtins.str] kb_numbers_to_includes: List of KB numbers to be included for patching.
        """
        pulumi.set(__self__, "classifications_to_includes", classifications_to_includes)
        pulumi.set(__self__, "kb_numbers_to_excludes", kb_numbers_to_excludes)
        pulumi.set(__self__, "kb_numbers_to_includes", kb_numbers_to_includes)

    @property
    @pulumi.getter(name="classificationsToIncludes")
    def classifications_to_includes(self) -> Sequence[builtins.str]:
        """
        List of Classification category of patches to be patched.
        """
        return pulumi.get(self, "classifications_to_includes")

    @property
    @pulumi.getter(name="kbNumbersToExcludes")
    def kb_numbers_to_excludes(self) -> Sequence[builtins.str]:
        """
        List of KB numbers to be excluded from patching.
        """
        return pulumi.get(self, "kb_numbers_to_excludes")

    @property
    @pulumi.getter(name="kbNumbersToIncludes")
    def kb_numbers_to_includes(self) -> Sequence[builtins.str]:
        """
        List of KB numbers to be included for patching.
        """
        return pulumi.get(self, "kb_numbers_to_includes")


@pulumi.output_type
class GetConfigurationWindowResult(dict):
    def __init__(__self__, *,
                 duration: builtins.str,
                 expiration_date_time: builtins.str,
                 recur_every: builtins.str,
                 start_date_time: builtins.str,
                 time_zone: builtins.str):
        """
        :param builtins.str duration: The duration of the maintenance window.
        :param builtins.str expiration_date_time: Effective expiration date of the maintenance window.
        :param builtins.str recur_every: The rate at which a maintenance window is expected to recur.
        :param builtins.str start_date_time: Effective start date of the maintenance window.
        :param builtins.str time_zone: The time zone for the maintenance window.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "expiration_date_time", expiration_date_time)
        pulumi.set(__self__, "recur_every", recur_every)
        pulumi.set(__self__, "start_date_time", start_date_time)
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def duration(self) -> builtins.str:
        """
        The duration of the maintenance window.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="expirationDateTime")
    def expiration_date_time(self) -> builtins.str:
        """
        Effective expiration date of the maintenance window.
        """
        return pulumi.get(self, "expiration_date_time")

    @property
    @pulumi.getter(name="recurEvery")
    def recur_every(self) -> builtins.str:
        """
        The rate at which a maintenance window is expected to recur.
        """
        return pulumi.get(self, "recur_every")

    @property
    @pulumi.getter(name="startDateTime")
    def start_date_time(self) -> builtins.str:
        """
        Effective start date of the maintenance window.
        """
        return pulumi.get(self, "start_date_time")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        The time zone for the maintenance window.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class GetPublicConfigurationsConfigResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 duration: builtins.str,
                 id: builtins.str,
                 location: builtins.str,
                 maintenance_scope: builtins.str,
                 name: builtins.str,
                 recur_every: builtins.str,
                 time_zone: builtins.str):
        """
        :param builtins.str description: A description of the Public Maintenance Configuration.
        :param builtins.str duration: The duration of the Public Maintenance Configuration window.
        :param builtins.str id: The id of the Public Maintenance Configuration.
        :param builtins.str location: The Azure location to filter the list of Public Maintenance Configurations against.
        :param builtins.str maintenance_scope: The scope of the Public Maintenance Configuration.
        :param builtins.str name: The name of the Public Maintenance Configuration.
        :param builtins.str recur_every: The recurring window to filter the list of Public Maintenance Configurations against. Possible values are `Monday-Thursday` and `Friday-Sunday`
        :param builtins.str time_zone: The time zone for the maintenance window.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "maintenance_scope", maintenance_scope)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "recur_every", recur_every)
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A description of the Public Maintenance Configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def duration(self) -> builtins.str:
        """
        The duration of the Public Maintenance Configuration window.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the Public Maintenance Configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure location to filter the list of Public Maintenance Configurations against.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maintenanceScope")
    def maintenance_scope(self) -> builtins.str:
        """
        The scope of the Public Maintenance Configuration.
        """
        return pulumi.get(self, "maintenance_scope")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Public Maintenance Configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recurEvery")
    def recur_every(self) -> builtins.str:
        """
        The recurring window to filter the list of Public Maintenance Configurations against. Possible values are `Monday-Thursday` and `Friday-Sunday`
        """
        return pulumi.get(self, "recur_every")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        The time zone for the maintenance window.
        """
        return pulumi.get(self, "time_zone")


