# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'FileSystemEncryptionKeyArgs',
    'FileSystemEncryptionKeyArgsDict',
    'FileSystemHsmSettingArgs',
    'FileSystemHsmSettingArgsDict',
    'FileSystemIdentityArgs',
    'FileSystemIdentityArgsDict',
    'FileSystemMaintenanceWindowArgs',
    'FileSystemMaintenanceWindowArgsDict',
]

MYPY = False

if not MYPY:
    class FileSystemEncryptionKeyArgsDict(TypedDict):
        key_url: pulumi.Input[builtins.str]
        """
        The URL to the Key Vault Key used as the Encryption Key. This can be found as `id` on the `keyvault.Key` resource.
        """
        source_vault_id: pulumi.Input[builtins.str]
        """
        The ID of the source Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource.
        """
elif False:
    FileSystemEncryptionKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FileSystemEncryptionKeyArgs:
    def __init__(__self__, *,
                 key_url: pulumi.Input[builtins.str],
                 source_vault_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] key_url: The URL to the Key Vault Key used as the Encryption Key. This can be found as `id` on the `keyvault.Key` resource.
        :param pulumi.Input[builtins.str] source_vault_id: The ID of the source Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource.
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> pulumi.Input[builtins.str]:
        """
        The URL to the Key Vault Key used as the Encryption Key. This can be found as `id` on the `keyvault.Key` resource.
        """
        return pulumi.get(self, "key_url")

    @key_url.setter
    def key_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_url", value)

    @property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the source Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource.
        """
        return pulumi.get(self, "source_vault_id")

    @source_vault_id.setter
    def source_vault_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_vault_id", value)


if not MYPY:
    class FileSystemHsmSettingArgsDict(TypedDict):
        container_id: pulumi.Input[builtins.str]
        """
        The resource ID of the storage container that is used for hydrating the namespace and archiving from the namespace. Changing this forces a new resource to be created.
        """
        logging_container_id: pulumi.Input[builtins.str]
        """
        The resource ID of the storage container that is used for logging events and errors. Changing this forces a new resource to be created.
        """
        import_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        The import prefix for the Azure Managed Lustre File System. Only blobs in the non-logging container that start with this path/prefix get hydrated into the cluster namespace. Changing this forces a new resource to be created.

        > **Note:** The roles `Contributor` and `Storage Blob Data Contributor` must be added to the Service Principal `HPC Cache Resource Provider` for the Storage Account. See official docs for more information.
        """
elif False:
    FileSystemHsmSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FileSystemHsmSettingArgs:
    def __init__(__self__, *,
                 container_id: pulumi.Input[builtins.str],
                 logging_container_id: pulumi.Input[builtins.str],
                 import_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] container_id: The resource ID of the storage container that is used for hydrating the namespace and archiving from the namespace. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] logging_container_id: The resource ID of the storage container that is used for logging events and errors. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] import_prefix: The import prefix for the Azure Managed Lustre File System. Only blobs in the non-logging container that start with this path/prefix get hydrated into the cluster namespace. Changing this forces a new resource to be created.
               
               > **Note:** The roles `Contributor` and `Storage Blob Data Contributor` must be added to the Service Principal `HPC Cache Resource Provider` for the Storage Account. See official docs for more information.
        """
        pulumi.set(__self__, "container_id", container_id)
        pulumi.set(__self__, "logging_container_id", logging_container_id)
        if import_prefix is not None:
            pulumi.set(__self__, "import_prefix", import_prefix)

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> pulumi.Input[builtins.str]:
        """
        The resource ID of the storage container that is used for hydrating the namespace and archiving from the namespace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "container_id", value)

    @property
    @pulumi.getter(name="loggingContainerId")
    def logging_container_id(self) -> pulumi.Input[builtins.str]:
        """
        The resource ID of the storage container that is used for logging events and errors. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "logging_container_id")

    @logging_container_id.setter
    def logging_container_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "logging_container_id", value)

    @property
    @pulumi.getter(name="importPrefix")
    def import_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The import prefix for the Azure Managed Lustre File System. Only blobs in the non-logging container that start with this path/prefix get hydrated into the cluster namespace. Changing this forces a new resource to be created.

        > **Note:** The roles `Contributor` and `Storage Blob Data Contributor` must be added to the Service Principal `HPC Cache Resource Provider` for the Storage Account. See official docs for more information.
        """
        return pulumi.get(self, "import_prefix")

    @import_prefix.setter
    def import_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "import_prefix", value)


if not MYPY:
    class FileSystemIdentityArgsDict(TypedDict):
        identity_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of User Assigned Managed Identity IDs to be assigned to this Azure Managed Lustre File System. Changing this forces a new resource to be created.
        """
        type: pulumi.Input[builtins.str]
        """
        The type of Managed Service Identity that should be configured on this Azure Managed Lustre File System. Only possible value is `UserAssigned`. Changing this forces a new resource to be created.
        """
elif False:
    FileSystemIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FileSystemIdentityArgs:
    def __init__(__self__, *,
                 identity_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 type: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this Azure Managed Lustre File System. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] type: The type of Managed Service Identity that should be configured on this Azure Managed Lustre File System. Only possible value is `UserAssigned`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this Azure Managed Lustre File System. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of Managed Service Identity that should be configured on this Azure Managed Lustre File System. Only possible value is `UserAssigned`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class FileSystemMaintenanceWindowArgsDict(TypedDict):
        day_of_week: pulumi.Input[builtins.str]
        """
        The day of the week on which the maintenance window will occur. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` and `Saturday`.
        """
        time_of_day_in_utc: pulumi.Input[builtins.str]
        """
        The time of day (in UTC) to start the maintenance window.
        """
elif False:
    FileSystemMaintenanceWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FileSystemMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day_of_week: pulumi.Input[builtins.str],
                 time_of_day_in_utc: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] day_of_week: The day of the week on which the maintenance window will occur. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` and `Saturday`.
        :param pulumi.Input[builtins.str] time_of_day_in_utc: The time of day (in UTC) to start the maintenance window.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "time_of_day_in_utc", time_of_day_in_utc)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Input[builtins.str]:
        """
        The day of the week on which the maintenance window will occur. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` and `Saturday`.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter(name="timeOfDayInUtc")
    def time_of_day_in_utc(self) -> pulumi.Input[builtins.str]:
        """
        The time of day (in UTC) to start the maintenance window.
        """
        return pulumi.get(self, "time_of_day_in_utc")

    @time_of_day_in_utc.setter
    def time_of_day_in_utc(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "time_of_day_in_utc", value)


