# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GroupPolicyAssignmentIdentity',
    'GroupPolicyAssignmentNonComplianceMessage',
    'GroupPolicyAssignmentOverride',
    'GroupPolicyAssignmentOverrideSelector',
    'GroupPolicyAssignmentResourceSelector',
    'GroupPolicyAssignmentResourceSelectorSelector',
]

@pulumi.output_type
class GroupPolicyAssignmentIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupPolicyAssignmentIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupPolicyAssignmentIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupPolicyAssignmentIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: The Type of Managed Identity which should be added to this Policy Definition. Possible values are `SystemAssigned` and `UserAssigned`.
        :param Sequence[builtins.str] identity_ids: A list of User Managed Identity IDs which should be assigned to the Policy Definition.
               
               > **Note:** This is required when `type` is set to `UserAssigned`.
        :param builtins.str principal_id: The Principal ID of the Policy Assignment for this Management Group.
        :param builtins.str tenant_id: The Tenant ID of the Policy Assignment for this Management Group.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The Type of Managed Identity which should be added to this Policy Definition. Possible values are `SystemAssigned` and `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of User Managed Identity IDs which should be assigned to the Policy Definition.

        > **Note:** This is required when `type` is set to `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID of the Policy Assignment for this Management Group.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID of the Policy Assignment for this Management Group.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class GroupPolicyAssignmentNonComplianceMessage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyDefinitionReferenceId":
            suggest = "policy_definition_reference_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupPolicyAssignmentNonComplianceMessage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupPolicyAssignmentNonComplianceMessage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupPolicyAssignmentNonComplianceMessage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: builtins.str,
                 policy_definition_reference_id: Optional[builtins.str] = None):
        """
        :param builtins.str content: The non-compliance message text. When assigning policy sets (initiatives), unless `policy_definition_reference_id` is specified then this message will be the default for all policies.
        :param builtins.str policy_definition_reference_id: When assigning policy sets (initiatives), this is the ID of the policy definition that the non-compliance message applies to.
        """
        pulumi.set(__self__, "content", content)
        if policy_definition_reference_id is not None:
            pulumi.set(__self__, "policy_definition_reference_id", policy_definition_reference_id)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        The non-compliance message text. When assigning policy sets (initiatives), unless `policy_definition_reference_id` is specified then this message will be the default for all policies.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="policyDefinitionReferenceId")
    def policy_definition_reference_id(self) -> Optional[builtins.str]:
        """
        When assigning policy sets (initiatives), this is the ID of the policy definition that the non-compliance message applies to.
        """
        return pulumi.get(self, "policy_definition_reference_id")


@pulumi.output_type
class GroupPolicyAssignmentOverride(dict):
    def __init__(__self__, *,
                 value: builtins.str,
                 selectors: Optional[Sequence['outputs.GroupPolicyAssignmentOverrideSelector']] = None):
        """
        :param builtins.str value: Specifies the value to override the policy property. Possible values for `policyEffect` override listed [policy effects](https://learn.microsoft.com/en-us/azure/governance/policy/concepts/effects).
        :param Sequence['GroupPolicyAssignmentOverrideSelectorArgs'] selectors: One or more `override_selector` block as defined below.
        """
        pulumi.set(__self__, "value", value)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Specifies the value to override the policy property. Possible values for `policyEffect` override listed [policy effects](https://learn.microsoft.com/en-us/azure/governance/policy/concepts/effects).
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def selectors(self) -> Optional[Sequence['outputs.GroupPolicyAssignmentOverrideSelector']]:
        """
        One or more `override_selector` block as defined below.
        """
        return pulumi.get(self, "selectors")


@pulumi.output_type
class GroupPolicyAssignmentOverrideSelector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notIns":
            suggest = "not_ins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupPolicyAssignmentOverrideSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupPolicyAssignmentOverrideSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupPolicyAssignmentOverrideSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ins: Optional[Sequence[builtins.str]] = None,
                 kind: Optional[builtins.str] = None,
                 not_ins: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str kind: Specifies which characteristic will narrow down the set of evaluated resources. Possible values are `resourceLocation`, `resourceType` and `resourceWithoutLocation`.
        """
        if ins is not None:
            pulumi.set(__self__, "ins", ins)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if not_ins is not None:
            pulumi.set(__self__, "not_ins", not_ins)

    @property
    @pulumi.getter
    def ins(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "ins")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Specifies which characteristic will narrow down the set of evaluated resources. Possible values are `resourceLocation`, `resourceType` and `resourceWithoutLocation`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="notIns")
    def not_ins(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "not_ins")


@pulumi.output_type
class GroupPolicyAssignmentResourceSelector(dict):
    def __init__(__self__, *,
                 selectors: Sequence['outputs.GroupPolicyAssignmentResourceSelectorSelector'],
                 name: Optional[builtins.str] = None):
        """
        :param Sequence['GroupPolicyAssignmentResourceSelectorSelectorArgs'] selectors: One or more `resource_selector` block as defined below.
        :param builtins.str name: Specifies a name for the resource selector.
        """
        pulumi.set(__self__, "selectors", selectors)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def selectors(self) -> Sequence['outputs.GroupPolicyAssignmentResourceSelectorSelector']:
        """
        One or more `resource_selector` block as defined below.
        """
        return pulumi.get(self, "selectors")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Specifies a name for the resource selector.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GroupPolicyAssignmentResourceSelectorSelector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notIns":
            suggest = "not_ins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupPolicyAssignmentResourceSelectorSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupPolicyAssignmentResourceSelectorSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupPolicyAssignmentResourceSelectorSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: builtins.str,
                 ins: Optional[Sequence[builtins.str]] = None,
                 not_ins: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str kind: Specifies which characteristic will narrow down the set of evaluated resources. Possible values are `resourceLocation`, `resourceType` and `resourceWithoutLocation`.
        """
        pulumi.set(__self__, "kind", kind)
        if ins is not None:
            pulumi.set(__self__, "ins", ins)
        if not_ins is not None:
            pulumi.set(__self__, "not_ins", not_ins)

    @property
    @pulumi.getter
    def kind(self) -> builtins.str:
        """
        Specifies which characteristic will narrow down the set of evaluated resources. Possible values are `resourceLocation`, `resourceType` and `resourceWithoutLocation`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def ins(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "ins")

    @property
    @pulumi.getter(name="notIns")
    def not_ins(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "not_ins")


