# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AgreementArgs', 'Agreement']

@pulumi.input_type
class AgreementArgs:
    def __init__(__self__, *,
                 offer: pulumi.Input[builtins.str],
                 plan: pulumi.Input[builtins.str],
                 publisher: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a Agreement resource.
        :param pulumi.Input[builtins.str] offer: The Offer of the Marketplace Image. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] plan: The Plan of the Marketplace Image. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] publisher: The Publisher of the Marketplace Image. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def offer(self) -> pulumi.Input[builtins.str]:
        """
        The Offer of the Marketplace Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Input[builtins.str]:
        """
        The Plan of the Marketplace Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[builtins.str]:
        """
        The Publisher of the Marketplace Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "publisher", value)


@pulumi.input_type
class _AgreementState:
    def __init__(__self__, *,
                 license_text_link: Optional[pulumi.Input[builtins.str]] = None,
                 offer: Optional[pulumi.Input[builtins.str]] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 privacy_policy_link: Optional[pulumi.Input[builtins.str]] = None,
                 publisher: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Agreement resources.
        :param pulumi.Input[builtins.str] offer: The Offer of the Marketplace Image. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] plan: The Plan of the Marketplace Image. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] publisher: The Publisher of the Marketplace Image. Changing this forces a new resource to be created.
        """
        if license_text_link is not None:
            pulumi.set(__self__, "license_text_link", license_text_link)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if privacy_policy_link is not None:
            pulumi.set(__self__, "privacy_policy_link", privacy_policy_link)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter(name="licenseTextLink")
    def license_text_link(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "license_text_link")

    @license_text_link.setter
    def license_text_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license_text_link", value)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Offer of the Marketplace Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Plan of the Marketplace Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="privacyPolicyLink")
    def privacy_policy_link(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "privacy_policy_link")

    @privacy_policy_link.setter
    def privacy_policy_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "privacy_policy_link", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Publisher of the Marketplace Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "publisher", value)


@pulumi.type_token("azure:marketplace/agreement:Agreement")
class Agreement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 offer: Optional[pulumi.Input[builtins.str]] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 publisher: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Allows accepting the Legal Terms for a Marketplace Image.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        barracuda = azure.marketplace.Agreement("barracuda",
            publisher="barracudanetworks",
            offer="waf",
            plan="hourly")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MarketplaceOrdering`: 2015-06-01

        ## Import

        Marketplace Agreement can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:marketplace/agreement:Agreement example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.MarketplaceOrdering/agreements/publisher1/offers/offer1/plans/plan1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] offer: The Offer of the Marketplace Image. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] plan: The Plan of the Marketplace Image. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] publisher: The Publisher of the Marketplace Image. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgreementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows accepting the Legal Terms for a Marketplace Image.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        barracuda = azure.marketplace.Agreement("barracuda",
            publisher="barracudanetworks",
            offer="waf",
            plan="hourly")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MarketplaceOrdering`: 2015-06-01

        ## Import

        Marketplace Agreement can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:marketplace/agreement:Agreement example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.MarketplaceOrdering/agreements/publisher1/offers/offer1/plans/plan1
        ```

        :param str resource_name: The name of the resource.
        :param AgreementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgreementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 offer: Optional[pulumi.Input[builtins.str]] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 publisher: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgreementArgs.__new__(AgreementArgs)

            if offer is None and not opts.urn:
                raise TypeError("Missing required property 'offer'")
            __props__.__dict__["offer"] = offer
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            if publisher is None and not opts.urn:
                raise TypeError("Missing required property 'publisher'")
            __props__.__dict__["publisher"] = publisher
            __props__.__dict__["license_text_link"] = None
            __props__.__dict__["privacy_policy_link"] = None
        super(Agreement, __self__).__init__(
            'azure:marketplace/agreement:Agreement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            license_text_link: Optional[pulumi.Input[builtins.str]] = None,
            offer: Optional[pulumi.Input[builtins.str]] = None,
            plan: Optional[pulumi.Input[builtins.str]] = None,
            privacy_policy_link: Optional[pulumi.Input[builtins.str]] = None,
            publisher: Optional[pulumi.Input[builtins.str]] = None) -> 'Agreement':
        """
        Get an existing Agreement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] offer: The Offer of the Marketplace Image. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] plan: The Plan of the Marketplace Image. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] publisher: The Publisher of the Marketplace Image. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgreementState.__new__(_AgreementState)

        __props__.__dict__["license_text_link"] = license_text_link
        __props__.__dict__["offer"] = offer
        __props__.__dict__["plan"] = plan
        __props__.__dict__["privacy_policy_link"] = privacy_policy_link
        __props__.__dict__["publisher"] = publisher
        return Agreement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="licenseTextLink")
    def license_text_link(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "license_text_link")

    @property
    @pulumi.getter
    def offer(self) -> pulumi.Output[builtins.str]:
        """
        The Offer of the Marketplace Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[builtins.str]:
        """
        The Plan of the Marketplace Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="privacyPolicyLink")
    def privacy_policy_link(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "privacy_policy_link")

    @property
    @pulumi.getter
    def publisher(self) -> pulumi.Output[builtins.str]:
        """
        The Publisher of the Marketplace Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

