# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RoleAssignmentArgs', 'RoleAssignment']

@pulumi.input_type
class RoleAssignmentArgs:
    def __init__(__self__, *,
                 principal_id: pulumi.Input[builtins.str],
                 condition: Optional[pulumi.Input[builtins.str]] = None,
                 condition_version: Optional[pulumi.Input[builtins.str]] = None,
                 delegated_managed_identity_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_definition_name: Optional[pulumi.Input[builtins.str]] = None,
                 skip_service_principal_aad_check: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a RoleAssignment resource.
        :param pulumi.Input[builtins.str] principal_id: The ID of the Principal (User, Group or Service Principal) to assign the Role Definition to. Changing this forces a new resource to be created.
               
               > **Note:** The Principal ID is also known as the Object ID (i.e. not the "Application ID" for applications). To assign Azure roles, the Principal must have `Microsoft.Authorization/roleAssignments/write` permissions. See [documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/role-assignments-portal) for more information.
        :param pulumi.Input[builtins.str] condition: The condition that limits the resources that the role can be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] condition_version: The version of the condition. Possible values are `1.0` or `2.0`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] delegated_managed_identity_resource_id: The delegated Azure Resource ID which contains a Managed Identity. Changing this forces a new resource to be created.
               
               > **Note:** This field is only used in cross tenant scenarios.
        :param pulumi.Input[builtins.str] description: The description for this Role Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: A unique UUID/GUID for this Role Assignment - one will be generated if not specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] role_definition_id: The Scoped-ID of the Role Definition. Changing this forces a new resource to be created. Conflicts with `role_definition_name`.
        :param pulumi.Input[builtins.str] role_definition_name: The name of a built-in Role. Changing this forces a new resource to be created. Conflicts with `role_definition_id`.
               
               > **Note:** To assign `Marketplace Admin` role, the calling Principal must first be assigned Privileged Role Administrator (like `Owner` role) or Global Administrator. See [documentation](https://learn.microsoft.com/en-us/marketplace/create-manage-private-azure-marketplace-new#prerequisites) for more information.
        :param pulumi.Input[builtins.bool] skip_service_principal_aad_check: If the `principal_id` is a newly provisioned `Service Principal` set this value to `true` to skip the `Azure Active Directory` check which may fail due to replication lag. This argument is only valid if the `principal_id` is a `Service Principal` identity. Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** This field takes effect only when `principal_id` is a `Service Principal` identity.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if condition_version is not None:
            pulumi.set(__self__, "condition_version", condition_version)
        if delegated_managed_identity_resource_id is not None:
            pulumi.set(__self__, "delegated_managed_identity_resource_id", delegated_managed_identity_resource_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_definition_id is not None:
            pulumi.set(__self__, "role_definition_id", role_definition_id)
        if role_definition_name is not None:
            pulumi.set(__self__, "role_definition_name", role_definition_name)
        if skip_service_principal_aad_check is not None:
            pulumi.set(__self__, "skip_service_principal_aad_check", skip_service_principal_aad_check)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Principal (User, Group or Service Principal) to assign the Role Definition to. Changing this forces a new resource to be created.

        > **Note:** The Principal ID is also known as the Object ID (i.e. not the "Application ID" for applications). To assign Azure roles, the Principal must have `Microsoft.Authorization/roleAssignments/write` permissions. See [documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/role-assignments-portal) for more information.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The condition that limits the resources that the role can be assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="conditionVersion")
    def condition_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the condition. Possible values are `1.0` or `2.0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "condition_version")

    @condition_version.setter
    def condition_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_version", value)

    @property
    @pulumi.getter(name="delegatedManagedIdentityResourceId")
    def delegated_managed_identity_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The delegated Azure Resource ID which contains a Managed Identity. Changing this forces a new resource to be created.

        > **Note:** This field is only used in cross tenant scenarios.
        """
        return pulumi.get(self, "delegated_managed_identity_resource_id")

    @delegated_managed_identity_resource_id.setter
    def delegated_managed_identity_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delegated_managed_identity_resource_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for this Role Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique UUID/GUID for this Role Assignment - one will be generated if not specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Scoped-ID of the Role Definition. Changing this forces a new resource to be created. Conflicts with `role_definition_name`.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_definition_id", value)

    @property
    @pulumi.getter(name="roleDefinitionName")
    def role_definition_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a built-in Role. Changing this forces a new resource to be created. Conflicts with `role_definition_id`.

        > **Note:** To assign `Marketplace Admin` role, the calling Principal must first be assigned Privileged Role Administrator (like `Owner` role) or Global Administrator. See [documentation](https://learn.microsoft.com/en-us/marketplace/create-manage-private-azure-marketplace-new#prerequisites) for more information.
        """
        return pulumi.get(self, "role_definition_name")

    @role_definition_name.setter
    def role_definition_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_definition_name", value)

    @property
    @pulumi.getter(name="skipServicePrincipalAadCheck")
    def skip_service_principal_aad_check(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If the `principal_id` is a newly provisioned `Service Principal` set this value to `true` to skip the `Azure Active Directory` check which may fail due to replication lag. This argument is only valid if the `principal_id` is a `Service Principal` identity. Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** This field takes effect only when `principal_id` is a `Service Principal` identity.
        """
        return pulumi.get(self, "skip_service_principal_aad_check")

    @skip_service_principal_aad_check.setter
    def skip_service_principal_aad_check(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_service_principal_aad_check", value)


@pulumi.input_type
class _RoleAssignmentState:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input[builtins.str]] = None,
                 condition_version: Optional[pulumi.Input[builtins.str]] = None,
                 delegated_managed_identity_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_definition_name: Optional[pulumi.Input[builtins.str]] = None,
                 skip_service_principal_aad_check: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering RoleAssignment resources.
        :param pulumi.Input[builtins.str] condition: The condition that limits the resources that the role can be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] condition_version: The version of the condition. Possible values are `1.0` or `2.0`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] delegated_managed_identity_resource_id: The delegated Azure Resource ID which contains a Managed Identity. Changing this forces a new resource to be created.
               
               > **Note:** This field is only used in cross tenant scenarios.
        :param pulumi.Input[builtins.str] description: The description for this Role Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: A unique UUID/GUID for this Role Assignment - one will be generated if not specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] principal_id: The ID of the Principal (User, Group or Service Principal) to assign the Role Definition to. Changing this forces a new resource to be created.
               
               > **Note:** The Principal ID is also known as the Object ID (i.e. not the "Application ID" for applications). To assign Azure roles, the Principal must have `Microsoft.Authorization/roleAssignments/write` permissions. See [documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/role-assignments-portal) for more information.
        :param pulumi.Input[builtins.str] principal_type: The type of the `principal_id`, e.g. User, Group, Service Principal, Application, etc.
        :param pulumi.Input[builtins.str] role_definition_id: The Scoped-ID of the Role Definition. Changing this forces a new resource to be created. Conflicts with `role_definition_name`.
        :param pulumi.Input[builtins.str] role_definition_name: The name of a built-in Role. Changing this forces a new resource to be created. Conflicts with `role_definition_id`.
               
               > **Note:** To assign `Marketplace Admin` role, the calling Principal must first be assigned Privileged Role Administrator (like `Owner` role) or Global Administrator. See [documentation](https://learn.microsoft.com/en-us/marketplace/create-manage-private-azure-marketplace-new#prerequisites) for more information.
        :param pulumi.Input[builtins.bool] skip_service_principal_aad_check: If the `principal_id` is a newly provisioned `Service Principal` set this value to `true` to skip the `Azure Active Directory` check which may fail due to replication lag. This argument is only valid if the `principal_id` is a `Service Principal` identity. Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** This field takes effect only when `principal_id` is a `Service Principal` identity.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if condition_version is not None:
            pulumi.set(__self__, "condition_version", condition_version)
        if delegated_managed_identity_resource_id is not None:
            pulumi.set(__self__, "delegated_managed_identity_resource_id", delegated_managed_identity_resource_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if principal_type is not None:
            pulumi.set(__self__, "principal_type", principal_type)
        if role_definition_id is not None:
            pulumi.set(__self__, "role_definition_id", role_definition_id)
        if role_definition_name is not None:
            pulumi.set(__self__, "role_definition_name", role_definition_name)
        if skip_service_principal_aad_check is not None:
            pulumi.set(__self__, "skip_service_principal_aad_check", skip_service_principal_aad_check)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The condition that limits the resources that the role can be assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="conditionVersion")
    def condition_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the condition. Possible values are `1.0` or `2.0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "condition_version")

    @condition_version.setter
    def condition_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "condition_version", value)

    @property
    @pulumi.getter(name="delegatedManagedIdentityResourceId")
    def delegated_managed_identity_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The delegated Azure Resource ID which contains a Managed Identity. Changing this forces a new resource to be created.

        > **Note:** This field is only used in cross tenant scenarios.
        """
        return pulumi.get(self, "delegated_managed_identity_resource_id")

    @delegated_managed_identity_resource_id.setter
    def delegated_managed_identity_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delegated_managed_identity_resource_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for this Role Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique UUID/GUID for this Role Assignment - one will be generated if not specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Principal (User, Group or Service Principal) to assign the Role Definition to. Changing this forces a new resource to be created.

        > **Note:** The Principal ID is also known as the Object ID (i.e. not the "Application ID" for applications). To assign Azure roles, the Principal must have `Microsoft.Authorization/roleAssignments/write` permissions. See [documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/role-assignments-portal) for more information.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the `principal_id`, e.g. User, Group, Service Principal, Application, etc.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_type", value)

    @property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Scoped-ID of the Role Definition. Changing this forces a new resource to be created. Conflicts with `role_definition_name`.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_definition_id", value)

    @property
    @pulumi.getter(name="roleDefinitionName")
    def role_definition_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a built-in Role. Changing this forces a new resource to be created. Conflicts with `role_definition_id`.

        > **Note:** To assign `Marketplace Admin` role, the calling Principal must first be assigned Privileged Role Administrator (like `Owner` role) or Global Administrator. See [documentation](https://learn.microsoft.com/en-us/marketplace/create-manage-private-azure-marketplace-new#prerequisites) for more information.
        """
        return pulumi.get(self, "role_definition_name")

    @role_definition_name.setter
    def role_definition_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_definition_name", value)

    @property
    @pulumi.getter(name="skipServicePrincipalAadCheck")
    def skip_service_principal_aad_check(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If the `principal_id` is a newly provisioned `Service Principal` set this value to `true` to skip the `Azure Active Directory` check which may fail due to replication lag. This argument is only valid if the `principal_id` is a `Service Principal` identity. Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** This field takes effect only when `principal_id` is a `Service Principal` identity.
        """
        return pulumi.get(self, "skip_service_principal_aad_check")

    @skip_service_principal_aad_check.setter
    def skip_service_principal_aad_check(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_service_principal_aad_check", value)


@pulumi.type_token("azure:marketplace/roleAssignment:RoleAssignment")
class RoleAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[builtins.str]] = None,
                 condition_version: Optional[pulumi.Input[builtins.str]] = None,
                 delegated_managed_identity_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_definition_name: Optional[pulumi.Input[builtins.str]] = None,
                 skip_service_principal_aad_check: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Assigns a given Principal (User or Group) to a given Role in a Private Azure Marketplace.

        ## Example Usage

        ### Using A Role Definition Name)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.get_client_config()
        example_role_assignment = azure.marketplace.RoleAssignment("example",
            role_definition_name="Marketplace Admin",
            principal_id=example.object_id)
        ```

        ### Using A Role Definition ID)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.get_client_config()
        example_get_role_definition = azure.authorization.get_role_definition(name="Log Analytics Reader")
        example_role_assignment = azure.marketplace.RoleAssignment("example",
            role_definition_id=example_get_role_definition.id,
            principal_id=example.object_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Authorization`: 2022-05-01-preview, 2022-04-01

        ## Import

        Role Assignments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:marketplace/roleAssignment:RoleAssignment example /providers/Microsoft.Marketplace/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000
        ```

        text

        /providers/Microsoft.Marketplace/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000|00000000-0000-0000-0000-000000000000

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] condition: The condition that limits the resources that the role can be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] condition_version: The version of the condition. Possible values are `1.0` or `2.0`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] delegated_managed_identity_resource_id: The delegated Azure Resource ID which contains a Managed Identity. Changing this forces a new resource to be created.
               
               > **Note:** This field is only used in cross tenant scenarios.
        :param pulumi.Input[builtins.str] description: The description for this Role Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: A unique UUID/GUID for this Role Assignment - one will be generated if not specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] principal_id: The ID of the Principal (User, Group or Service Principal) to assign the Role Definition to. Changing this forces a new resource to be created.
               
               > **Note:** The Principal ID is also known as the Object ID (i.e. not the "Application ID" for applications). To assign Azure roles, the Principal must have `Microsoft.Authorization/roleAssignments/write` permissions. See [documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/role-assignments-portal) for more information.
        :param pulumi.Input[builtins.str] role_definition_id: The Scoped-ID of the Role Definition. Changing this forces a new resource to be created. Conflicts with `role_definition_name`.
        :param pulumi.Input[builtins.str] role_definition_name: The name of a built-in Role. Changing this forces a new resource to be created. Conflicts with `role_definition_id`.
               
               > **Note:** To assign `Marketplace Admin` role, the calling Principal must first be assigned Privileged Role Administrator (like `Owner` role) or Global Administrator. See [documentation](https://learn.microsoft.com/en-us/marketplace/create-manage-private-azure-marketplace-new#prerequisites) for more information.
        :param pulumi.Input[builtins.bool] skip_service_principal_aad_check: If the `principal_id` is a newly provisioned `Service Principal` set this value to `true` to skip the `Azure Active Directory` check which may fail due to replication lag. This argument is only valid if the `principal_id` is a `Service Principal` identity. Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** This field takes effect only when `principal_id` is a `Service Principal` identity.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoleAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Assigns a given Principal (User or Group) to a given Role in a Private Azure Marketplace.

        ## Example Usage

        ### Using A Role Definition Name)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.get_client_config()
        example_role_assignment = azure.marketplace.RoleAssignment("example",
            role_definition_name="Marketplace Admin",
            principal_id=example.object_id)
        ```

        ### Using A Role Definition ID)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.get_client_config()
        example_get_role_definition = azure.authorization.get_role_definition(name="Log Analytics Reader")
        example_role_assignment = azure.marketplace.RoleAssignment("example",
            role_definition_id=example_get_role_definition.id,
            principal_id=example.object_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Authorization`: 2022-05-01-preview, 2022-04-01

        ## Import

        Role Assignments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:marketplace/roleAssignment:RoleAssignment example /providers/Microsoft.Marketplace/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000
        ```

        text

        /providers/Microsoft.Marketplace/providers/Microsoft.Authorization/roleAssignments/00000000-0000-0000-0000-000000000000|00000000-0000-0000-0000-000000000000

        :param str resource_name: The name of the resource.
        :param RoleAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[builtins.str]] = None,
                 condition_version: Optional[pulumi.Input[builtins.str]] = None,
                 delegated_managed_identity_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_definition_name: Optional[pulumi.Input[builtins.str]] = None,
                 skip_service_principal_aad_check: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleAssignmentArgs.__new__(RoleAssignmentArgs)

            __props__.__dict__["condition"] = condition
            __props__.__dict__["condition_version"] = condition_version
            __props__.__dict__["delegated_managed_identity_resource_id"] = delegated_managed_identity_resource_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
            __props__.__dict__["role_definition_id"] = role_definition_id
            __props__.__dict__["role_definition_name"] = role_definition_name
            __props__.__dict__["skip_service_principal_aad_check"] = skip_service_principal_aad_check
            __props__.__dict__["principal_type"] = None
        super(RoleAssignment, __self__).__init__(
            'azure:marketplace/roleAssignment:RoleAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            condition: Optional[pulumi.Input[builtins.str]] = None,
            condition_version: Optional[pulumi.Input[builtins.str]] = None,
            delegated_managed_identity_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            principal_id: Optional[pulumi.Input[builtins.str]] = None,
            principal_type: Optional[pulumi.Input[builtins.str]] = None,
            role_definition_id: Optional[pulumi.Input[builtins.str]] = None,
            role_definition_name: Optional[pulumi.Input[builtins.str]] = None,
            skip_service_principal_aad_check: Optional[pulumi.Input[builtins.bool]] = None) -> 'RoleAssignment':
        """
        Get an existing RoleAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] condition: The condition that limits the resources that the role can be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] condition_version: The version of the condition. Possible values are `1.0` or `2.0`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] delegated_managed_identity_resource_id: The delegated Azure Resource ID which contains a Managed Identity. Changing this forces a new resource to be created.
               
               > **Note:** This field is only used in cross tenant scenarios.
        :param pulumi.Input[builtins.str] description: The description for this Role Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: A unique UUID/GUID for this Role Assignment - one will be generated if not specified. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] principal_id: The ID of the Principal (User, Group or Service Principal) to assign the Role Definition to. Changing this forces a new resource to be created.
               
               > **Note:** The Principal ID is also known as the Object ID (i.e. not the "Application ID" for applications). To assign Azure roles, the Principal must have `Microsoft.Authorization/roleAssignments/write` permissions. See [documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/role-assignments-portal) for more information.
        :param pulumi.Input[builtins.str] principal_type: The type of the `principal_id`, e.g. User, Group, Service Principal, Application, etc.
        :param pulumi.Input[builtins.str] role_definition_id: The Scoped-ID of the Role Definition. Changing this forces a new resource to be created. Conflicts with `role_definition_name`.
        :param pulumi.Input[builtins.str] role_definition_name: The name of a built-in Role. Changing this forces a new resource to be created. Conflicts with `role_definition_id`.
               
               > **Note:** To assign `Marketplace Admin` role, the calling Principal must first be assigned Privileged Role Administrator (like `Owner` role) or Global Administrator. See [documentation](https://learn.microsoft.com/en-us/marketplace/create-manage-private-azure-marketplace-new#prerequisites) for more information.
        :param pulumi.Input[builtins.bool] skip_service_principal_aad_check: If the `principal_id` is a newly provisioned `Service Principal` set this value to `true` to skip the `Azure Active Directory` check which may fail due to replication lag. This argument is only valid if the `principal_id` is a `Service Principal` identity. Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** This field takes effect only when `principal_id` is a `Service Principal` identity.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleAssignmentState.__new__(_RoleAssignmentState)

        __props__.__dict__["condition"] = condition
        __props__.__dict__["condition_version"] = condition_version
        __props__.__dict__["delegated_managed_identity_resource_id"] = delegated_managed_identity_resource_id
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["principal_id"] = principal_id
        __props__.__dict__["principal_type"] = principal_type
        __props__.__dict__["role_definition_id"] = role_definition_id
        __props__.__dict__["role_definition_name"] = role_definition_name
        __props__.__dict__["skip_service_principal_aad_check"] = skip_service_principal_aad_check
        return RoleAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The condition that limits the resources that the role can be assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="conditionVersion")
    def condition_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of the condition. Possible values are `1.0` or `2.0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "condition_version")

    @property
    @pulumi.getter(name="delegatedManagedIdentityResourceId")
    def delegated_managed_identity_resource_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The delegated Azure Resource ID which contains a Managed Identity. Changing this forces a new resource to be created.

        > **Note:** This field is only used in cross tenant scenarios.
        """
        return pulumi.get(self, "delegated_managed_identity_resource_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description for this Role Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique UUID/GUID for this Role Assignment - one will be generated if not specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Principal (User, Group or Service Principal) to assign the Role Definition to. Changing this forces a new resource to be created.

        > **Note:** The Principal ID is also known as the Object ID (i.e. not the "Application ID" for applications). To assign Azure roles, the Principal must have `Microsoft.Authorization/roleAssignments/write` permissions. See [documentation](https://learn.microsoft.com/en-us/azure/role-based-access-control/role-assignments-portal) for more information.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the `principal_id`, e.g. User, Group, Service Principal, Application, etc.
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Scoped-ID of the Role Definition. Changing this forces a new resource to be created. Conflicts with `role_definition_name`.
        """
        return pulumi.get(self, "role_definition_id")

    @property
    @pulumi.getter(name="roleDefinitionName")
    def role_definition_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of a built-in Role. Changing this forces a new resource to be created. Conflicts with `role_definition_id`.

        > **Note:** To assign `Marketplace Admin` role, the calling Principal must first be assigned Privileged Role Administrator (like `Owner` role) or Global Administrator. See [documentation](https://learn.microsoft.com/en-us/marketplace/create-manage-private-azure-marketplace-new#prerequisites) for more information.
        """
        return pulumi.get(self, "role_definition_name")

    @property
    @pulumi.getter(name="skipServicePrincipalAadCheck")
    def skip_service_principal_aad_check(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If the `principal_id` is a newly provisioned `Service Principal` set this value to `true` to skip the `Azure Active Directory` check which may fail due to replication lag. This argument is only valid if the `principal_id` is a `Service Principal` identity. Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** This field takes effect only when `principal_id` is a `Service Principal` identity.
        """
        return pulumi.get(self, "skip_service_principal_aad_check")

