# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkArgs', 'Network']

@pulumi.input_type
class NetworkArgs:
    def __init__(__self__, *,
                 mobile_country_code: pulumi.Input[builtins.str],
                 mobile_network_code: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Network resource.
        :param pulumi.Input[builtins.str] mobile_country_code: Mobile country code (MCC), defined in https://www.itu.int/rec/T-REC-E.212 . Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] mobile_network_code: Mobile network code (MNC), defined in https://www.itu.int/rec/T-REC-E.212 . Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Mobile Network should exist. Changing this forces a new Mobile Network to be created.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Mobile Network should exist. Changing this forces a new Mobile Network to be created. The possible values are `eastus` and `northeurope`.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Mobile Network. Changing this forces a new Mobile Network to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network.
        """
        pulumi.set(__self__, "mobile_country_code", mobile_country_code)
        pulumi.set(__self__, "mobile_network_code", mobile_network_code)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="mobileCountryCode")
    def mobile_country_code(self) -> pulumi.Input[builtins.str]:
        """
        Mobile country code (MCC), defined in https://www.itu.int/rec/T-REC-E.212 . Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mobile_country_code")

    @mobile_country_code.setter
    def mobile_country_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mobile_country_code", value)

    @property
    @pulumi.getter(name="mobileNetworkCode")
    def mobile_network_code(self) -> pulumi.Input[builtins.str]:
        """
        Mobile network code (MNC), defined in https://www.itu.int/rec/T-REC-E.212 . Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mobile_network_code")

    @mobile_network_code.setter
    def mobile_network_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mobile_network_code", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the Resource Group where the Mobile Network should exist. Changing this forces a new Mobile Network to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the Mobile Network should exist. Changing this forces a new Mobile Network to be created. The possible values are `eastus` and `northeurope`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Mobile Network. Changing this forces a new Mobile Network to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NetworkState:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_country_code: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_network_code: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_key: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Network resources.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Mobile Network should exist. Changing this forces a new Mobile Network to be created. The possible values are `eastus` and `northeurope`.
        :param pulumi.Input[builtins.str] mobile_country_code: Mobile country code (MCC), defined in https://www.itu.int/rec/T-REC-E.212 . Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] mobile_network_code: Mobile network code (MNC), defined in https://www.itu.int/rec/T-REC-E.212 . Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Mobile Network. Changing this forces a new Mobile Network to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Mobile Network should exist. Changing this forces a new Mobile Network to be created.
        :param pulumi.Input[builtins.str] service_key: The mobile network resource identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mobile_country_code is not None:
            pulumi.set(__self__, "mobile_country_code", mobile_country_code)
        if mobile_network_code is not None:
            pulumi.set(__self__, "mobile_network_code", mobile_network_code)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_key is not None:
            pulumi.set(__self__, "service_key", service_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the Mobile Network should exist. Changing this forces a new Mobile Network to be created. The possible values are `eastus` and `northeurope`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mobileCountryCode")
    def mobile_country_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Mobile country code (MCC), defined in https://www.itu.int/rec/T-REC-E.212 . Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mobile_country_code")

    @mobile_country_code.setter
    def mobile_country_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mobile_country_code", value)

    @property
    @pulumi.getter(name="mobileNetworkCode")
    def mobile_network_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Mobile network code (MNC), defined in https://www.itu.int/rec/T-REC-E.212 . Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mobile_network_code")

    @mobile_network_code.setter
    def mobile_network_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mobile_network_code", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Mobile Network. Changing this forces a new Mobile Network to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Resource Group where the Mobile Network should exist. Changing this forces a new Mobile Network to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mobile network resource identifier.
        """
        return pulumi.get(self, "service_key")

    @service_key.setter
    def service_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_key", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:mobile/network:Network")
class Network(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_country_code: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_network_code: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Mobile Network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="east us")
        example_network = azure.mobile.Network("example",
            name="example-mn",
            resource_group_name=example.name,
            location=example.location,
            mobile_country_code="001",
            mobile_network_code="01",
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MobileNetwork`: 2022-11-01

        ## Import

        Mobile Network can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mobile/network:Network example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.MobileNetwork/mobileNetworks/mobileNetwork1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Mobile Network should exist. Changing this forces a new Mobile Network to be created. The possible values are `eastus` and `northeurope`.
        :param pulumi.Input[builtins.str] mobile_country_code: Mobile country code (MCC), defined in https://www.itu.int/rec/T-REC-E.212 . Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] mobile_network_code: Mobile network code (MNC), defined in https://www.itu.int/rec/T-REC-E.212 . Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Mobile Network. Changing this forces a new Mobile Network to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Mobile Network should exist. Changing this forces a new Mobile Network to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Mobile Network.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="east us")
        example_network = azure.mobile.Network("example",
            name="example-mn",
            resource_group_name=example.name,
            location=example.location,
            mobile_country_code="001",
            mobile_network_code="01",
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MobileNetwork`: 2022-11-01

        ## Import

        Mobile Network can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mobile/network:Network example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.MobileNetwork/mobileNetworks/mobileNetwork1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_country_code: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_network_code: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkArgs.__new__(NetworkArgs)

            __props__.__dict__["location"] = location
            if mobile_country_code is None and not opts.urn:
                raise TypeError("Missing required property 'mobile_country_code'")
            __props__.__dict__["mobile_country_code"] = mobile_country_code
            if mobile_network_code is None and not opts.urn:
                raise TypeError("Missing required property 'mobile_network_code'")
            __props__.__dict__["mobile_network_code"] = mobile_network_code
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["service_key"] = None
        super(Network, __self__).__init__(
            'azure:mobile/network:Network',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            mobile_country_code: Optional[pulumi.Input[builtins.str]] = None,
            mobile_network_code: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            service_key: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Network':
        """
        Get an existing Network resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Mobile Network should exist. Changing this forces a new Mobile Network to be created. The possible values are `eastus` and `northeurope`.
        :param pulumi.Input[builtins.str] mobile_country_code: Mobile country code (MCC), defined in https://www.itu.int/rec/T-REC-E.212 . Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] mobile_network_code: Mobile network code (MNC), defined in https://www.itu.int/rec/T-REC-E.212 . Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Mobile Network. Changing this forces a new Mobile Network to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Mobile Network should exist. Changing this forces a new Mobile Network to be created.
        :param pulumi.Input[builtins.str] service_key: The mobile network resource identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkState.__new__(_NetworkState)

        __props__.__dict__["location"] = location
        __props__.__dict__["mobile_country_code"] = mobile_country_code
        __props__.__dict__["mobile_network_code"] = mobile_network_code
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["service_key"] = service_key
        __props__.__dict__["tags"] = tags
        return Network(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Azure Region where the Mobile Network should exist. Changing this forces a new Mobile Network to be created. The possible values are `eastus` and `northeurope`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mobileCountryCode")
    def mobile_country_code(self) -> pulumi.Output[builtins.str]:
        """
        Mobile country code (MCC), defined in https://www.itu.int/rec/T-REC-E.212 . Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mobile_country_code")

    @property
    @pulumi.getter(name="mobileNetworkCode")
    def mobile_network_code(self) -> pulumi.Output[builtins.str]:
        """
        Mobile network code (MNC), defined in https://www.itu.int/rec/T-REC-E.212 . Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mobile_network_code")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name which should be used for this Mobile Network. Changing this forces a new Mobile Network to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Resource Group where the Mobile Network should exist. Changing this forces a new Mobile Network to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> pulumi.Output[builtins.str]:
        """
        The mobile network resource identifier.
        """
        return pulumi.get(self, "service_key")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network.
        """
        return pulumi.get(self, "tags")

