# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkSimPolicyArgs', 'NetworkSimPolicy']

@pulumi.input_type
class NetworkSimPolicyArgs:
    def __init__(__self__, *,
                 default_slice_id: pulumi.Input[builtins.str],
                 mobile_network_id: pulumi.Input[builtins.str],
                 slices: pulumi.Input[Sequence[pulumi.Input['NetworkSimPolicySliceArgs']]],
                 user_equipment_aggregate_maximum_bit_rate: pulumi.Input['NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs'],
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rat_frequency_selection_priority_index: Optional[pulumi.Input[builtins.int]] = None,
                 registration_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a NetworkSimPolicy resource.
        :param pulumi.Input[builtins.str] default_slice_id: The ID of default slice to use if the UE does not explicitly specify it. This slice must exist in the `slice` block.
        :param pulumi.Input[builtins.str] mobile_network_id: The ID of the Mobile Network which the Sim Policy belongs to. Changing this forces a new Mobile Network Sim Policies to be created.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkSimPolicySliceArgs']]] slices: An array of `slice` block as defined below. The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
        :param pulumi.Input['NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs'] user_equipment_aggregate_maximum_bit_rate: A `user_equipment_aggregate_maximum_bit_rate` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Mobile Network Sim Policy should exist. Changing this forces a new Mobile Network Sim Policies to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Mobile Network Sim Policies. Changing this forces a new Mobile Network Sim Policies to be created.
        :param pulumi.Input[builtins.int] rat_frequency_selection_priority_index: RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413.
        :param pulumi.Input[builtins.int] registration_timer_in_seconds: Interval for the user equipment periodic registration update procedure. Defaults to `3240`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Sim Policies.
        """
        pulumi.set(__self__, "default_slice_id", default_slice_id)
        pulumi.set(__self__, "mobile_network_id", mobile_network_id)
        pulumi.set(__self__, "slices", slices)
        pulumi.set(__self__, "user_equipment_aggregate_maximum_bit_rate", user_equipment_aggregate_maximum_bit_rate)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rat_frequency_selection_priority_index is not None:
            pulumi.set(__self__, "rat_frequency_selection_priority_index", rat_frequency_selection_priority_index)
        if registration_timer_in_seconds is not None:
            pulumi.set(__self__, "registration_timer_in_seconds", registration_timer_in_seconds)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="defaultSliceId")
    def default_slice_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of default slice to use if the UE does not explicitly specify it. This slice must exist in the `slice` block.
        """
        return pulumi.get(self, "default_slice_id")

    @default_slice_id.setter
    def default_slice_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "default_slice_id", value)

    @property
    @pulumi.getter(name="mobileNetworkId")
    def mobile_network_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Mobile Network which the Sim Policy belongs to. Changing this forces a new Mobile Network Sim Policies to be created.
        """
        return pulumi.get(self, "mobile_network_id")

    @mobile_network_id.setter
    def mobile_network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mobile_network_id", value)

    @property
    @pulumi.getter
    def slices(self) -> pulumi.Input[Sequence[pulumi.Input['NetworkSimPolicySliceArgs']]]:
        """
        An array of `slice` block as defined below. The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
        """
        return pulumi.get(self, "slices")

    @slices.setter
    def slices(self, value: pulumi.Input[Sequence[pulumi.Input['NetworkSimPolicySliceArgs']]]):
        pulumi.set(self, "slices", value)

    @property
    @pulumi.getter(name="userEquipmentAggregateMaximumBitRate")
    def user_equipment_aggregate_maximum_bit_rate(self) -> pulumi.Input['NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs']:
        """
        A `user_equipment_aggregate_maximum_bit_rate` block as defined below.
        """
        return pulumi.get(self, "user_equipment_aggregate_maximum_bit_rate")

    @user_equipment_aggregate_maximum_bit_rate.setter
    def user_equipment_aggregate_maximum_bit_rate(self, value: pulumi.Input['NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs']):
        pulumi.set(self, "user_equipment_aggregate_maximum_bit_rate", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the Mobile Network Sim Policy should exist. Changing this forces a new Mobile Network Sim Policies to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Mobile Network Sim Policies. Changing this forces a new Mobile Network Sim Policies to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ratFrequencySelectionPriorityIndex")
    def rat_frequency_selection_priority_index(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413.
        """
        return pulumi.get(self, "rat_frequency_selection_priority_index")

    @rat_frequency_selection_priority_index.setter
    def rat_frequency_selection_priority_index(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rat_frequency_selection_priority_index", value)

    @property
    @pulumi.getter(name="registrationTimerInSeconds")
    def registration_timer_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Interval for the user equipment periodic registration update procedure. Defaults to `3240`.
        """
        return pulumi.get(self, "registration_timer_in_seconds")

    @registration_timer_in_seconds.setter
    def registration_timer_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "registration_timer_in_seconds", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Sim Policies.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NetworkSimPolicyState:
    def __init__(__self__, *,
                 default_slice_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rat_frequency_selection_priority_index: Optional[pulumi.Input[builtins.int]] = None,
                 registration_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 slices: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSimPolicySliceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_equipment_aggregate_maximum_bit_rate: Optional[pulumi.Input['NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs']] = None):
        """
        Input properties used for looking up and filtering NetworkSimPolicy resources.
        :param pulumi.Input[builtins.str] default_slice_id: The ID of default slice to use if the UE does not explicitly specify it. This slice must exist in the `slice` block.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Mobile Network Sim Policy should exist. Changing this forces a new Mobile Network Sim Policies to be created.
        :param pulumi.Input[builtins.str] mobile_network_id: The ID of the Mobile Network which the Sim Policy belongs to. Changing this forces a new Mobile Network Sim Policies to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Mobile Network Sim Policies. Changing this forces a new Mobile Network Sim Policies to be created.
        :param pulumi.Input[builtins.int] rat_frequency_selection_priority_index: RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413.
        :param pulumi.Input[builtins.int] registration_timer_in_seconds: Interval for the user equipment periodic registration update procedure. Defaults to `3240`.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkSimPolicySliceArgs']]] slices: An array of `slice` block as defined below. The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Sim Policies.
        :param pulumi.Input['NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs'] user_equipment_aggregate_maximum_bit_rate: A `user_equipment_aggregate_maximum_bit_rate` block as defined below.
        """
        if default_slice_id is not None:
            pulumi.set(__self__, "default_slice_id", default_slice_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mobile_network_id is not None:
            pulumi.set(__self__, "mobile_network_id", mobile_network_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rat_frequency_selection_priority_index is not None:
            pulumi.set(__self__, "rat_frequency_selection_priority_index", rat_frequency_selection_priority_index)
        if registration_timer_in_seconds is not None:
            pulumi.set(__self__, "registration_timer_in_seconds", registration_timer_in_seconds)
        if slices is not None:
            pulumi.set(__self__, "slices", slices)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_equipment_aggregate_maximum_bit_rate is not None:
            pulumi.set(__self__, "user_equipment_aggregate_maximum_bit_rate", user_equipment_aggregate_maximum_bit_rate)

    @property
    @pulumi.getter(name="defaultSliceId")
    def default_slice_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of default slice to use if the UE does not explicitly specify it. This slice must exist in the `slice` block.
        """
        return pulumi.get(self, "default_slice_id")

    @default_slice_id.setter
    def default_slice_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_slice_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the Mobile Network Sim Policy should exist. Changing this forces a new Mobile Network Sim Policies to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mobileNetworkId")
    def mobile_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Mobile Network which the Sim Policy belongs to. Changing this forces a new Mobile Network Sim Policies to be created.
        """
        return pulumi.get(self, "mobile_network_id")

    @mobile_network_id.setter
    def mobile_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mobile_network_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Mobile Network Sim Policies. Changing this forces a new Mobile Network Sim Policies to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ratFrequencySelectionPriorityIndex")
    def rat_frequency_selection_priority_index(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413.
        """
        return pulumi.get(self, "rat_frequency_selection_priority_index")

    @rat_frequency_selection_priority_index.setter
    def rat_frequency_selection_priority_index(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rat_frequency_selection_priority_index", value)

    @property
    @pulumi.getter(name="registrationTimerInSeconds")
    def registration_timer_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Interval for the user equipment periodic registration update procedure. Defaults to `3240`.
        """
        return pulumi.get(self, "registration_timer_in_seconds")

    @registration_timer_in_seconds.setter
    def registration_timer_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "registration_timer_in_seconds", value)

    @property
    @pulumi.getter
    def slices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSimPolicySliceArgs']]]]:
        """
        An array of `slice` block as defined below. The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
        """
        return pulumi.get(self, "slices")

    @slices.setter
    def slices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSimPolicySliceArgs']]]]):
        pulumi.set(self, "slices", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Sim Policies.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userEquipmentAggregateMaximumBitRate")
    def user_equipment_aggregate_maximum_bit_rate(self) -> Optional[pulumi.Input['NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs']]:
        """
        A `user_equipment_aggregate_maximum_bit_rate` block as defined below.
        """
        return pulumi.get(self, "user_equipment_aggregate_maximum_bit_rate")

    @user_equipment_aggregate_maximum_bit_rate.setter
    def user_equipment_aggregate_maximum_bit_rate(self, value: Optional[pulumi.Input['NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs']]):
        pulumi.set(self, "user_equipment_aggregate_maximum_bit_rate", value)


@pulumi.type_token("azure:mobile/networkSimPolicy:NetworkSimPolicy")
class NetworkSimPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_slice_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rat_frequency_selection_priority_index: Optional[pulumi.Input[builtins.int]] = None,
                 registration_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 slices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkSimPolicySliceArgs', 'NetworkSimPolicySliceArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_equipment_aggregate_maximum_bit_rate: Optional[pulumi.Input[Union['NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs', 'NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Mobile Network Sim Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_network = azure.mobile.Network("example",
            name="example-mn",
            location=example.location,
            resource_group_name=example.name,
            mobile_country_code="001",
            mobile_network_code="01")
        example_network_data_network = azure.mobile.NetworkDataNetwork("example",
            name="example-mndn",
            mobile_network_id=example_network.id,
            location=example.location)
        example_network_service = azure.mobile.NetworkService("example",
            name="example-mns",
            mobile_network_id=example_network.id,
            location=example.location,
            service_precedence=0,
            pcc_rules=[{
                "name": "default-rule",
                "precedence": 1,
                "traffic_control_enabled": True,
                "service_data_flow_templates": [{
                    "direction": "Uplink",
                    "name": "IP-to-server",
                    "ports": [],
                    "protocols": ["ip"],
                    "remote_ip_lists": ["10.3.4.0/24"],
                }],
            }])
        example_network_slice = azure.mobile.NetworkSlice("example",
            name="example-mns",
            mobile_network_id=example_network.id,
            location=example.location,
            single_network_slice_selection_assistance_information={
                "slice_service_type": 1,
            })
        example_network_sim_policy = azure.mobile.NetworkSimPolicy("example",
            name="example-mnsp",
            mobile_network_id=example_network.id,
            location=example.location,
            registration_timer_in_seconds=3240,
            default_slice_id=example_network_slice.id,
            slices=[{
                "default_data_network_id": example_network_data_network.id,
                "slice_id": example_network_slice.id,
                "data_networks": [{
                    "data_network_id": example_network_data_network.id,
                    "allocation_and_retention_priority_level": 9,
                    "default_session_type": "IPv4",
                    "qos_indicator": 9,
                    "preemption_capability": "NotPreempt",
                    "preemption_vulnerability": "Preemptable",
                    "allowed_services_ids": [example_network_service.id],
                    "session_aggregate_maximum_bit_rate": {
                        "downlink": "1 Gbps",
                        "uplink": "500 Mbps",
                    },
                }],
            }],
            user_equipment_aggregate_maximum_bit_rate={
                "downlink": "1 Gbps",
                "uplink": "500 Mbps",
            },
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MobileNetwork`: 2022-11-01

        ## Import

        Mobile Network Sim Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mobile/networkSimPolicy:NetworkSimPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.MobileNetwork/mobileNetworks/mobileNetwork1/simPolicies/simPolicy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] default_slice_id: The ID of default slice to use if the UE does not explicitly specify it. This slice must exist in the `slice` block.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Mobile Network Sim Policy should exist. Changing this forces a new Mobile Network Sim Policies to be created.
        :param pulumi.Input[builtins.str] mobile_network_id: The ID of the Mobile Network which the Sim Policy belongs to. Changing this forces a new Mobile Network Sim Policies to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Mobile Network Sim Policies. Changing this forces a new Mobile Network Sim Policies to be created.
        :param pulumi.Input[builtins.int] rat_frequency_selection_priority_index: RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413.
        :param pulumi.Input[builtins.int] registration_timer_in_seconds: Interval for the user equipment periodic registration update procedure. Defaults to `3240`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkSimPolicySliceArgs', 'NetworkSimPolicySliceArgsDict']]]] slices: An array of `slice` block as defined below. The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Sim Policies.
        :param pulumi.Input[Union['NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs', 'NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgsDict']] user_equipment_aggregate_maximum_bit_rate: A `user_equipment_aggregate_maximum_bit_rate` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkSimPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Mobile Network Sim Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_network = azure.mobile.Network("example",
            name="example-mn",
            location=example.location,
            resource_group_name=example.name,
            mobile_country_code="001",
            mobile_network_code="01")
        example_network_data_network = azure.mobile.NetworkDataNetwork("example",
            name="example-mndn",
            mobile_network_id=example_network.id,
            location=example.location)
        example_network_service = azure.mobile.NetworkService("example",
            name="example-mns",
            mobile_network_id=example_network.id,
            location=example.location,
            service_precedence=0,
            pcc_rules=[{
                "name": "default-rule",
                "precedence": 1,
                "traffic_control_enabled": True,
                "service_data_flow_templates": [{
                    "direction": "Uplink",
                    "name": "IP-to-server",
                    "ports": [],
                    "protocols": ["ip"],
                    "remote_ip_lists": ["10.3.4.0/24"],
                }],
            }])
        example_network_slice = azure.mobile.NetworkSlice("example",
            name="example-mns",
            mobile_network_id=example_network.id,
            location=example.location,
            single_network_slice_selection_assistance_information={
                "slice_service_type": 1,
            })
        example_network_sim_policy = azure.mobile.NetworkSimPolicy("example",
            name="example-mnsp",
            mobile_network_id=example_network.id,
            location=example.location,
            registration_timer_in_seconds=3240,
            default_slice_id=example_network_slice.id,
            slices=[{
                "default_data_network_id": example_network_data_network.id,
                "slice_id": example_network_slice.id,
                "data_networks": [{
                    "data_network_id": example_network_data_network.id,
                    "allocation_and_retention_priority_level": 9,
                    "default_session_type": "IPv4",
                    "qos_indicator": 9,
                    "preemption_capability": "NotPreempt",
                    "preemption_vulnerability": "Preemptable",
                    "allowed_services_ids": [example_network_service.id],
                    "session_aggregate_maximum_bit_rate": {
                        "downlink": "1 Gbps",
                        "uplink": "500 Mbps",
                    },
                }],
            }],
            user_equipment_aggregate_maximum_bit_rate={
                "downlink": "1 Gbps",
                "uplink": "500 Mbps",
            },
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MobileNetwork`: 2022-11-01

        ## Import

        Mobile Network Sim Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mobile/networkSimPolicy:NetworkSimPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.MobileNetwork/mobileNetworks/mobileNetwork1/simPolicies/simPolicy1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkSimPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkSimPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_slice_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 rat_frequency_selection_priority_index: Optional[pulumi.Input[builtins.int]] = None,
                 registration_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 slices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkSimPolicySliceArgs', 'NetworkSimPolicySliceArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_equipment_aggregate_maximum_bit_rate: Optional[pulumi.Input[Union['NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs', 'NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkSimPolicyArgs.__new__(NetworkSimPolicyArgs)

            if default_slice_id is None and not opts.urn:
                raise TypeError("Missing required property 'default_slice_id'")
            __props__.__dict__["default_slice_id"] = default_slice_id
            __props__.__dict__["location"] = location
            if mobile_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'mobile_network_id'")
            __props__.__dict__["mobile_network_id"] = mobile_network_id
            __props__.__dict__["name"] = name
            __props__.__dict__["rat_frequency_selection_priority_index"] = rat_frequency_selection_priority_index
            __props__.__dict__["registration_timer_in_seconds"] = registration_timer_in_seconds
            if slices is None and not opts.urn:
                raise TypeError("Missing required property 'slices'")
            __props__.__dict__["slices"] = slices
            __props__.__dict__["tags"] = tags
            if user_equipment_aggregate_maximum_bit_rate is None and not opts.urn:
                raise TypeError("Missing required property 'user_equipment_aggregate_maximum_bit_rate'")
            __props__.__dict__["user_equipment_aggregate_maximum_bit_rate"] = user_equipment_aggregate_maximum_bit_rate
        super(NetworkSimPolicy, __self__).__init__(
            'azure:mobile/networkSimPolicy:NetworkSimPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_slice_id: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            mobile_network_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            rat_frequency_selection_priority_index: Optional[pulumi.Input[builtins.int]] = None,
            registration_timer_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            slices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkSimPolicySliceArgs', 'NetworkSimPolicySliceArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            user_equipment_aggregate_maximum_bit_rate: Optional[pulumi.Input[Union['NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs', 'NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgsDict']]] = None) -> 'NetworkSimPolicy':
        """
        Get an existing NetworkSimPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] default_slice_id: The ID of default slice to use if the UE does not explicitly specify it. This slice must exist in the `slice` block.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Mobile Network Sim Policy should exist. Changing this forces a new Mobile Network Sim Policies to be created.
        :param pulumi.Input[builtins.str] mobile_network_id: The ID of the Mobile Network which the Sim Policy belongs to. Changing this forces a new Mobile Network Sim Policies to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Mobile Network Sim Policies. Changing this forces a new Mobile Network Sim Policies to be created.
        :param pulumi.Input[builtins.int] rat_frequency_selection_priority_index: RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413.
        :param pulumi.Input[builtins.int] registration_timer_in_seconds: Interval for the user equipment periodic registration update procedure. Defaults to `3240`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkSimPolicySliceArgs', 'NetworkSimPolicySliceArgsDict']]]] slices: An array of `slice` block as defined below. The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Sim Policies.
        :param pulumi.Input[Union['NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs', 'NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgsDict']] user_equipment_aggregate_maximum_bit_rate: A `user_equipment_aggregate_maximum_bit_rate` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkSimPolicyState.__new__(_NetworkSimPolicyState)

        __props__.__dict__["default_slice_id"] = default_slice_id
        __props__.__dict__["location"] = location
        __props__.__dict__["mobile_network_id"] = mobile_network_id
        __props__.__dict__["name"] = name
        __props__.__dict__["rat_frequency_selection_priority_index"] = rat_frequency_selection_priority_index
        __props__.__dict__["registration_timer_in_seconds"] = registration_timer_in_seconds
        __props__.__dict__["slices"] = slices
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_equipment_aggregate_maximum_bit_rate"] = user_equipment_aggregate_maximum_bit_rate
        return NetworkSimPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultSliceId")
    def default_slice_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of default slice to use if the UE does not explicitly specify it. This slice must exist in the `slice` block.
        """
        return pulumi.get(self, "default_slice_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Azure Region where the Mobile Network Sim Policy should exist. Changing this forces a new Mobile Network Sim Policies to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mobileNetworkId")
    def mobile_network_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Mobile Network which the Sim Policy belongs to. Changing this forces a new Mobile Network Sim Policies to be created.
        """
        return pulumi.get(self, "mobile_network_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Mobile Network Sim Policies. Changing this forces a new Mobile Network Sim Policies to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ratFrequencySelectionPriorityIndex")
    def rat_frequency_selection_priority_index(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413.
        """
        return pulumi.get(self, "rat_frequency_selection_priority_index")

    @property
    @pulumi.getter(name="registrationTimerInSeconds")
    def registration_timer_in_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Interval for the user equipment periodic registration update procedure. Defaults to `3240`.
        """
        return pulumi.get(self, "registration_timer_in_seconds")

    @property
    @pulumi.getter
    def slices(self) -> pulumi.Output[Sequence['outputs.NetworkSimPolicySlice']]:
        """
        An array of `slice` block as defined below. The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
        """
        return pulumi.get(self, "slices")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Sim Policies.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userEquipmentAggregateMaximumBitRate")
    def user_equipment_aggregate_maximum_bit_rate(self) -> pulumi.Output['outputs.NetworkSimPolicyUserEquipmentAggregateMaximumBitRate']:
        """
        A `user_equipment_aggregate_maximum_bit_rate` block as defined below.
        """
        return pulumi.get(self, "user_equipment_aggregate_maximum_bit_rate")

