# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkSiteArgs', 'NetworkSite']

@pulumi.input_type
class NetworkSiteArgs:
    def __init__(__self__, *,
                 mobile_network_id: pulumi.Input[builtins.str],
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a NetworkSite resource.
        :param pulumi.Input[builtins.str] mobile_network_id: the ID of the Mobile Network which the Mobile Network Site belongs to. Changing this forces a new Mobile Network Site to be created.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Mobile Network Site should exist. Changing this forces a new Mobile Network Site to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Mobile Network Site. Changing this forces a new Mobile Network Site to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Site.
        """
        pulumi.set(__self__, "mobile_network_id", mobile_network_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="mobileNetworkId")
    def mobile_network_id(self) -> pulumi.Input[builtins.str]:
        """
        the ID of the Mobile Network which the Mobile Network Site belongs to. Changing this forces a new Mobile Network Site to be created.
        """
        return pulumi.get(self, "mobile_network_id")

    @mobile_network_id.setter
    def mobile_network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mobile_network_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Mobile Network Site should exist. Changing this forces a new Mobile Network Site to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Mobile Network Site. Changing this forces a new Mobile Network Site to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Site.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NetworkSiteState:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_function_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NetworkSite resources.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Mobile Network Site should exist. Changing this forces a new Mobile Network Site to be created.
        :param pulumi.Input[builtins.str] mobile_network_id: the ID of the Mobile Network which the Mobile Network Site belongs to. Changing this forces a new Mobile Network Site to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Mobile Network Site. Changing this forces a new Mobile Network Site to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] network_function_ids: An array of Id of Network Functions deployed on the site.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Site.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mobile_network_id is not None:
            pulumi.set(__self__, "mobile_network_id", mobile_network_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_function_ids is not None:
            pulumi.set(__self__, "network_function_ids", network_function_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Mobile Network Site should exist. Changing this forces a new Mobile Network Site to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mobileNetworkId")
    def mobile_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        the ID of the Mobile Network which the Mobile Network Site belongs to. Changing this forces a new Mobile Network Site to be created.
        """
        return pulumi.get(self, "mobile_network_id")

    @mobile_network_id.setter
    def mobile_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mobile_network_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Mobile Network Site. Changing this forces a new Mobile Network Site to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkFunctionIds")
    def network_function_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of Id of Network Functions deployed on the site.
        """
        return pulumi.get(self, "network_function_ids")

    @network_function_ids.setter
    def network_function_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "network_function_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Site.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:mobile/networkSite:NetworkSite")
class NetworkSite(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Mobile Network Site.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_device = azure.databoxedge.Device("example",
            name="example-device",
            resource_group_name=example.name,
            location=example.location,
            sku_name="EdgeP_Base-Standard")
        example_network = azure.mobile.Network("example",
            name="example-mn",
            location=example.location,
            resource_group_name=example.name,
            mobile_country_code="001",
            mobile_network_code="01")
        example_network_site = azure.mobile.NetworkSite("example",
            name="example-mns",
            mobile_network_id=example_network.id,
            location=example.location,
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MobileNetwork`: 2022-11-01

        ## Import

        Mobile Network Site can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mobile/networkSite:NetworkSite example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.MobileNetwork/mobileNetworks/mobileNetwork1/sites/site1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Mobile Network Site should exist. Changing this forces a new Mobile Network Site to be created.
        :param pulumi.Input[builtins.str] mobile_network_id: the ID of the Mobile Network which the Mobile Network Site belongs to. Changing this forces a new Mobile Network Site to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Mobile Network Site. Changing this forces a new Mobile Network Site to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Site.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkSiteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Mobile Network Site.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_device = azure.databoxedge.Device("example",
            name="example-device",
            resource_group_name=example.name,
            location=example.location,
            sku_name="EdgeP_Base-Standard")
        example_network = azure.mobile.Network("example",
            name="example-mn",
            location=example.location,
            resource_group_name=example.name,
            mobile_country_code="001",
            mobile_network_code="01")
        example_network_site = azure.mobile.NetworkSite("example",
            name="example-mns",
            mobile_network_id=example_network.id,
            location=example.location,
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MobileNetwork`: 2022-11-01

        ## Import

        Mobile Network Site can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mobile/networkSite:NetworkSite example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.MobileNetwork/mobileNetworks/mobileNetwork1/sites/site1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkSiteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkSiteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkSiteArgs.__new__(NetworkSiteArgs)

            __props__.__dict__["location"] = location
            if mobile_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'mobile_network_id'")
            __props__.__dict__["mobile_network_id"] = mobile_network_id
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["network_function_ids"] = None
        super(NetworkSite, __self__).__init__(
            'azure:mobile/networkSite:NetworkSite',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            mobile_network_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_function_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'NetworkSite':
        """
        Get an existing NetworkSite resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Mobile Network Site should exist. Changing this forces a new Mobile Network Site to be created.
        :param pulumi.Input[builtins.str] mobile_network_id: the ID of the Mobile Network which the Mobile Network Site belongs to. Changing this forces a new Mobile Network Site to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Mobile Network Site. Changing this forces a new Mobile Network Site to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] network_function_ids: An array of Id of Network Functions deployed on the site.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Site.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkSiteState.__new__(_NetworkSiteState)

        __props__.__dict__["location"] = location
        __props__.__dict__["mobile_network_id"] = mobile_network_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_function_ids"] = network_function_ids
        __props__.__dict__["tags"] = tags
        return NetworkSite(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Mobile Network Site should exist. Changing this forces a new Mobile Network Site to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mobileNetworkId")
    def mobile_network_id(self) -> pulumi.Output[builtins.str]:
        """
        the ID of the Mobile Network which the Mobile Network Site belongs to. Changing this forces a new Mobile Network Site to be created.
        """
        return pulumi.get(self, "mobile_network_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Mobile Network Site. Changing this forces a new Mobile Network Site to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFunctionIds")
    def network_function_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        An array of Id of Network Functions deployed on the site.
        """
        return pulumi.get(self, "network_function_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Site.
        """
        return pulumi.get(self, "tags")

