# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'NetworkAttachedDataNetworkNetworkAddressPortTranslation',
    'NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange',
    'NetworkPacketCoreControlPlaneIdentity',
    'NetworkPacketCoreControlPlaneLocalDiagnosticsAccess',
    'NetworkPacketCoreControlPlanePlatform',
    'NetworkServicePccRule',
    'NetworkServicePccRuleQosPolicy',
    'NetworkServicePccRuleQosPolicyGuaranteedBitRate',
    'NetworkServicePccRuleQosPolicyMaximumBitRate',
    'NetworkServicePccRuleServiceDataFlowTemplate',
    'NetworkServiceServiceQosPolicy',
    'NetworkServiceServiceQosPolicyMaximumBitRate',
    'NetworkSimGroupIdentity',
    'NetworkSimPolicySlice',
    'NetworkSimPolicySliceDataNetwork',
    'NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate',
    'NetworkSimPolicyUserEquipmentAggregateMaximumBitRate',
    'NetworkSimStaticIpConfiguration',
    'NetworkSliceSingleNetworkSliceSelectionAssistanceInformation',
    'GetNetworkAttachedDataNetworkNetworkAddressPortTranslationResult',
    'GetNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeResult',
    'GetNetworkPacketCoreControlPlaneIdentityResult',
    'GetNetworkPacketCoreControlPlaneLocalDiagnosticsAccessResult',
    'GetNetworkPacketCoreControlPlanePlatformResult',
    'GetNetworkServicePccRuleResult',
    'GetNetworkServicePccRuleQosPolicyResult',
    'GetNetworkServicePccRuleQosPolicyGuaranteedBitRateResult',
    'GetNetworkServicePccRuleQosPolicyMaximumBitRateResult',
    'GetNetworkServicePccRuleServiceDataFlowTemplateResult',
    'GetNetworkServiceServiceQosPolicyResult',
    'GetNetworkServiceServiceQosPolicyMaximumBitRateResult',
    'GetNetworkSimGroupIdentityResult',
    'GetNetworkSimPolicySliceResult',
    'GetNetworkSimPolicySliceDataNetworkResult',
    'GetNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateResult',
    'GetNetworkSimPolicyUserEquipmentAggregateMaximumBitRateResult',
    'GetNetworkSimStaticIpConfigurationResult',
    'GetNetworkSliceSingleNetworkSliceSelectionAssistanceInformationResult',
]

@pulumi.output_type
class NetworkAttachedDataNetworkNetworkAddressPortTranslation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "icmpPinholeTimeoutInSeconds":
            suggest = "icmp_pinhole_timeout_in_seconds"
        elif key == "pinholeMaximumNumber":
            suggest = "pinhole_maximum_number"
        elif key == "portRange":
            suggest = "port_range"
        elif key == "tcpPinholeTimeoutInSeconds":
            suggest = "tcp_pinhole_timeout_in_seconds"
        elif key == "tcpPortReuseMinimumHoldTimeInSeconds":
            suggest = "tcp_port_reuse_minimum_hold_time_in_seconds"
        elif key == "udpPinholeTimeoutInSeconds":
            suggest = "udp_pinhole_timeout_in_seconds"
        elif key == "udpPortReuseMinimumHoldTimeInSeconds":
            suggest = "udp_port_reuse_minimum_hold_time_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAttachedDataNetworkNetworkAddressPortTranslation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAttachedDataNetworkNetworkAddressPortTranslation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAttachedDataNetworkNetworkAddressPortTranslation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 icmp_pinhole_timeout_in_seconds: Optional[builtins.int] = None,
                 pinhole_maximum_number: Optional[builtins.int] = None,
                 port_range: Optional['outputs.NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange'] = None,
                 tcp_pinhole_timeout_in_seconds: Optional[builtins.int] = None,
                 tcp_port_reuse_minimum_hold_time_in_seconds: Optional[builtins.int] = None,
                 udp_pinhole_timeout_in_seconds: Optional[builtins.int] = None,
                 udp_port_reuse_minimum_hold_time_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.int icmp_pinhole_timeout_in_seconds: Pinhole timeout for ICMP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        :param builtins.int pinhole_maximum_number: Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface. Must be between 1 and 65536.
        :param 'NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeArgs' port_range: A `port_range` block as defined below.
        :param builtins.int tcp_pinhole_timeout_in_seconds: Pinhole timeout for TCP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        :param builtins.int tcp_port_reuse_minimum_hold_time_in_seconds: Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Defaults to `120`.
        :param builtins.int udp_pinhole_timeout_in_seconds: Pinhole timeout for UDP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        :param builtins.int udp_port_reuse_minimum_hold_time_in_seconds: Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Defaults to `60`.
        """
        if icmp_pinhole_timeout_in_seconds is not None:
            pulumi.set(__self__, "icmp_pinhole_timeout_in_seconds", icmp_pinhole_timeout_in_seconds)
        if pinhole_maximum_number is not None:
            pulumi.set(__self__, "pinhole_maximum_number", pinhole_maximum_number)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if tcp_pinhole_timeout_in_seconds is not None:
            pulumi.set(__self__, "tcp_pinhole_timeout_in_seconds", tcp_pinhole_timeout_in_seconds)
        if tcp_port_reuse_minimum_hold_time_in_seconds is not None:
            pulumi.set(__self__, "tcp_port_reuse_minimum_hold_time_in_seconds", tcp_port_reuse_minimum_hold_time_in_seconds)
        if udp_pinhole_timeout_in_seconds is not None:
            pulumi.set(__self__, "udp_pinhole_timeout_in_seconds", udp_pinhole_timeout_in_seconds)
        if udp_port_reuse_minimum_hold_time_in_seconds is not None:
            pulumi.set(__self__, "udp_port_reuse_minimum_hold_time_in_seconds", udp_port_reuse_minimum_hold_time_in_seconds)

    @property
    @pulumi.getter(name="icmpPinholeTimeoutInSeconds")
    def icmp_pinhole_timeout_in_seconds(self) -> Optional[builtins.int]:
        """
        Pinhole timeout for ICMP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        """
        return pulumi.get(self, "icmp_pinhole_timeout_in_seconds")

    @property
    @pulumi.getter(name="pinholeMaximumNumber")
    def pinhole_maximum_number(self) -> Optional[builtins.int]:
        """
        Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface. Must be between 1 and 65536.
        """
        return pulumi.get(self, "pinhole_maximum_number")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional['outputs.NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange']:
        """
        A `port_range` block as defined below.
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter(name="tcpPinholeTimeoutInSeconds")
    def tcp_pinhole_timeout_in_seconds(self) -> Optional[builtins.int]:
        """
        Pinhole timeout for TCP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        """
        return pulumi.get(self, "tcp_pinhole_timeout_in_seconds")

    @property
    @pulumi.getter(name="tcpPortReuseMinimumHoldTimeInSeconds")
    def tcp_port_reuse_minimum_hold_time_in_seconds(self) -> Optional[builtins.int]:
        """
        Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Defaults to `120`.
        """
        return pulumi.get(self, "tcp_port_reuse_minimum_hold_time_in_seconds")

    @property
    @pulumi.getter(name="udpPinholeTimeoutInSeconds")
    def udp_pinhole_timeout_in_seconds(self) -> Optional[builtins.int]:
        """
        Pinhole timeout for UDP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        """
        return pulumi.get(self, "udp_pinhole_timeout_in_seconds")

    @property
    @pulumi.getter(name="udpPortReuseMinimumHoldTimeInSeconds")
    def udp_port_reuse_minimum_hold_time_in_seconds(self) -> Optional[builtins.int]:
        """
        Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Defaults to `60`.
        """
        return pulumi.get(self, "udp_port_reuse_minimum_hold_time_in_seconds")


@pulumi.output_type
class NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange(dict):
    def __init__(__self__, *,
                 maximum: Optional[builtins.int] = None,
                 minimum: Optional[builtins.int] = None):
        """
        :param builtins.int maximum: Specifies the maximum port number.
        :param builtins.int minimum: Specifies the minimum port number.
        """
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter
    def maximum(self) -> Optional[builtins.int]:
        """
        Specifies the maximum port number.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[builtins.int]:
        """
        Specifies the minimum port number.
        """
        return pulumi.get(self, "minimum")


@pulumi.output_type
class NetworkPacketCoreControlPlaneIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPacketCoreControlPlaneIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPacketCoreControlPlaneIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPacketCoreControlPlaneIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: A list of the IDs for User Assigned Managed Identity resources to be assigned.
        :param builtins.str type: Specifies the type of Managed Service Identity. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        A list of the IDs for User Assigned Managed Identity resources to be assigned.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NetworkPacketCoreControlPlaneLocalDiagnosticsAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "httpsServerCertificateUrl":
            suggest = "https_server_certificate_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPacketCoreControlPlaneLocalDiagnosticsAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPacketCoreControlPlaneLocalDiagnosticsAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPacketCoreControlPlaneLocalDiagnosticsAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: builtins.str,
                 https_server_certificate_url: Optional[builtins.str] = None):
        """
        :param builtins.str authentication_type: How to authenticate users to access local diagnostics APIs. Possible values are `AAD` and `Password`.
        :param builtins.str https_server_certificate_url: The versionless certificate URL used to secure local access to packet core diagnostics over local APIs by the Kubernetes ingress.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if https_server_certificate_url is not None:
            pulumi.set(__self__, "https_server_certificate_url", https_server_certificate_url)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> builtins.str:
        """
        How to authenticate users to access local diagnostics APIs. Possible values are `AAD` and `Password`.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="httpsServerCertificateUrl")
    def https_server_certificate_url(self) -> Optional[builtins.str]:
        """
        The versionless certificate URL used to secure local access to packet core diagnostics over local APIs by the Kubernetes ingress.
        """
        return pulumi.get(self, "https_server_certificate_url")


@pulumi.output_type
class NetworkPacketCoreControlPlanePlatform(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "arcKubernetesClusterId":
            suggest = "arc_kubernetes_cluster_id"
        elif key == "customLocationId":
            suggest = "custom_location_id"
        elif key == "edgeDeviceId":
            suggest = "edge_device_id"
        elif key == "stackHciClusterId":
            suggest = "stack_hci_cluster_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPacketCoreControlPlanePlatform. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPacketCoreControlPlanePlatform.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPacketCoreControlPlanePlatform.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 arc_kubernetes_cluster_id: Optional[builtins.str] = None,
                 custom_location_id: Optional[builtins.str] = None,
                 edge_device_id: Optional[builtins.str] = None,
                 stack_hci_cluster_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the platform type where the packet core is deployed. Possible values are `AKS-HCI`, `3P-AZURE-STACK-HCI` and `BaseVM`.
        :param builtins.str arc_kubernetes_cluster_id: The ID of the Azure Arc connected cluster where the packet core is deployed.
        :param builtins.str custom_location_id: The ID of the Azure Arc custom location where the packet core is deployed.
               
               > **Note:** At least one of `edge_device_id`, `arc_kubernetes_cluster_id`, `stack_hci_cluster_id` and `custom_location_id` should be specified. If multiple are set, they must be consistent with each other.
        :param builtins.str edge_device_id: The ID of the Azure Stack Edge device where the packet core is deployed. If the device is part of a fault-tolerant pair, either device in the pair can be specified.
        :param builtins.str stack_hci_cluster_id: The ID of the Azure Stack HCI cluster where the packet core is deployed.
        """
        pulumi.set(__self__, "type", type)
        if arc_kubernetes_cluster_id is not None:
            pulumi.set(__self__, "arc_kubernetes_cluster_id", arc_kubernetes_cluster_id)
        if custom_location_id is not None:
            pulumi.set(__self__, "custom_location_id", custom_location_id)
        if edge_device_id is not None:
            pulumi.set(__self__, "edge_device_id", edge_device_id)
        if stack_hci_cluster_id is not None:
            pulumi.set(__self__, "stack_hci_cluster_id", stack_hci_cluster_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the platform type where the packet core is deployed. Possible values are `AKS-HCI`, `3P-AZURE-STACK-HCI` and `BaseVM`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="arcKubernetesClusterId")
    def arc_kubernetes_cluster_id(self) -> Optional[builtins.str]:
        """
        The ID of the Azure Arc connected cluster where the packet core is deployed.
        """
        return pulumi.get(self, "arc_kubernetes_cluster_id")

    @property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> Optional[builtins.str]:
        """
        The ID of the Azure Arc custom location where the packet core is deployed.

        > **Note:** At least one of `edge_device_id`, `arc_kubernetes_cluster_id`, `stack_hci_cluster_id` and `custom_location_id` should be specified. If multiple are set, they must be consistent with each other.
        """
        return pulumi.get(self, "custom_location_id")

    @property
    @pulumi.getter(name="edgeDeviceId")
    def edge_device_id(self) -> Optional[builtins.str]:
        """
        The ID of the Azure Stack Edge device where the packet core is deployed. If the device is part of a fault-tolerant pair, either device in the pair can be specified.
        """
        return pulumi.get(self, "edge_device_id")

    @property
    @pulumi.getter(name="stackHciClusterId")
    def stack_hci_cluster_id(self) -> Optional[builtins.str]:
        """
        The ID of the Azure Stack HCI cluster where the packet core is deployed.
        """
        return pulumi.get(self, "stack_hci_cluster_id")


@pulumi.output_type
class NetworkServicePccRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceDataFlowTemplates":
            suggest = "service_data_flow_templates"
        elif key == "qosPolicy":
            suggest = "qos_policy"
        elif key == "trafficControlEnabled":
            suggest = "traffic_control_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkServicePccRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkServicePccRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkServicePccRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 precedence: builtins.int,
                 service_data_flow_templates: Sequence['outputs.NetworkServicePccRuleServiceDataFlowTemplate'],
                 qos_policy: Optional['outputs.NetworkServicePccRuleQosPolicy'] = None,
                 traffic_control_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Specifies the name of the rule. This must be unique within the parent service. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        :param builtins.int precedence: A precedence value that is used to decide between data flow policy rules when identifying the QoS values to use for a particular SIM. A lower value means a higher priority. This value should be unique among all data flow policy rules configured in the mobile network. Must be between `0` and `255`.
        :param Sequence['NetworkServicePccRuleServiceDataFlowTemplateArgs'] service_data_flow_templates: A `service_data_flow_template` block as defined below. The set of service data flow templates to use for this PCC rule.
        :param 'NetworkServicePccRuleQosPolicyArgs' qos_policy: A `qos_policy` block as defined below. The QoS policy to use for packets matching this rule. If this field is not specified then the Service will define the QoS settings.
        :param builtins.bool traffic_control_enabled: Determines whether flows that match this data flow policy rule are permitted. Defaults to `true`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "precedence", precedence)
        pulumi.set(__self__, "service_data_flow_templates", service_data_flow_templates)
        if qos_policy is not None:
            pulumi.set(__self__, "qos_policy", qos_policy)
        if traffic_control_enabled is not None:
            pulumi.set(__self__, "traffic_control_enabled", traffic_control_enabled)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the name of the rule. This must be unique within the parent service. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def precedence(self) -> builtins.int:
        """
        A precedence value that is used to decide between data flow policy rules when identifying the QoS values to use for a particular SIM. A lower value means a higher priority. This value should be unique among all data flow policy rules configured in the mobile network. Must be between `0` and `255`.
        """
        return pulumi.get(self, "precedence")

    @property
    @pulumi.getter(name="serviceDataFlowTemplates")
    def service_data_flow_templates(self) -> Sequence['outputs.NetworkServicePccRuleServiceDataFlowTemplate']:
        """
        A `service_data_flow_template` block as defined below. The set of service data flow templates to use for this PCC rule.
        """
        return pulumi.get(self, "service_data_flow_templates")

    @property
    @pulumi.getter(name="qosPolicy")
    def qos_policy(self) -> Optional['outputs.NetworkServicePccRuleQosPolicy']:
        """
        A `qos_policy` block as defined below. The QoS policy to use for packets matching this rule. If this field is not specified then the Service will define the QoS settings.
        """
        return pulumi.get(self, "qos_policy")

    @property
    @pulumi.getter(name="trafficControlEnabled")
    def traffic_control_enabled(self) -> Optional[builtins.bool]:
        """
        Determines whether flows that match this data flow policy rule are permitted. Defaults to `true`.
        """
        return pulumi.get(self, "traffic_control_enabled")


@pulumi.output_type
class NetworkServicePccRuleQosPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumBitRate":
            suggest = "maximum_bit_rate"
        elif key == "qosIndicator":
            suggest = "qos_indicator"
        elif key == "allocationAndRetentionPriorityLevel":
            suggest = "allocation_and_retention_priority_level"
        elif key == "guaranteedBitRate":
            suggest = "guaranteed_bit_rate"
        elif key == "preemptionCapability":
            suggest = "preemption_capability"
        elif key == "preemptionVulnerability":
            suggest = "preemption_vulnerability"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkServicePccRuleQosPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkServicePccRuleQosPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkServicePccRuleQosPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_bit_rate: 'outputs.NetworkServicePccRuleQosPolicyMaximumBitRate',
                 qos_indicator: builtins.int,
                 allocation_and_retention_priority_level: Optional[builtins.int] = None,
                 guaranteed_bit_rate: Optional['outputs.NetworkServicePccRuleQosPolicyGuaranteedBitRate'] = None,
                 preemption_capability: Optional[builtins.str] = None,
                 preemption_vulnerability: Optional[builtins.str] = None):
        """
        :param 'NetworkServicePccRuleQosPolicyMaximumBitRateArgs' maximum_bit_rate: A `maximum_bit_rate` block as defined below. The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        :param builtins.int qos_indicator: The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        :param builtins.int allocation_and_retention_priority_level: QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param 'NetworkServicePccRuleQosPolicyGuaranteedBitRateArgs' guaranteed_bit_rate: A `guaranteed_bit_rate` block as defined below. The Guaranteed Bit Rate (GBR) for all service data flows that use this PCC Rule. If it's not specified, there will be no GBR set for the PCC Rule that uses this QoS definition.
        :param builtins.str preemption_capability: The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`, Defaults to `NotPreempt`.
        :param builtins.str preemption_vulnerability: The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`. Defaults to `Preemptable`.
        """
        pulumi.set(__self__, "maximum_bit_rate", maximum_bit_rate)
        pulumi.set(__self__, "qos_indicator", qos_indicator)
        if allocation_and_retention_priority_level is not None:
            pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        if guaranteed_bit_rate is not None:
            pulumi.set(__self__, "guaranteed_bit_rate", guaranteed_bit_rate)
        if preemption_capability is not None:
            pulumi.set(__self__, "preemption_capability", preemption_capability)
        if preemption_vulnerability is not None:
            pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)

    @property
    @pulumi.getter(name="maximumBitRate")
    def maximum_bit_rate(self) -> 'outputs.NetworkServicePccRuleQosPolicyMaximumBitRate':
        """
        A `maximum_bit_rate` block as defined below. The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        """
        return pulumi.get(self, "maximum_bit_rate")

    @property
    @pulumi.getter(name="qosIndicator")
    def qos_indicator(self) -> builtins.int:
        """
        The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        """
        return pulumi.get(self, "qos_indicator")

    @property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> Optional[builtins.int]:
        """
        QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @property
    @pulumi.getter(name="guaranteedBitRate")
    def guaranteed_bit_rate(self) -> Optional['outputs.NetworkServicePccRuleQosPolicyGuaranteedBitRate']:
        """
        A `guaranteed_bit_rate` block as defined below. The Guaranteed Bit Rate (GBR) for all service data flows that use this PCC Rule. If it's not specified, there will be no GBR set for the PCC Rule that uses this QoS definition.
        """
        return pulumi.get(self, "guaranteed_bit_rate")

    @property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> Optional[builtins.str]:
        """
        The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`, Defaults to `NotPreempt`.
        """
        return pulumi.get(self, "preemption_capability")

    @property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> Optional[builtins.str]:
        """
        The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`. Defaults to `Preemptable`.
        """
        return pulumi.get(self, "preemption_vulnerability")


@pulumi.output_type
class NetworkServicePccRuleQosPolicyGuaranteedBitRate(dict):
    def __init__(__self__, *,
                 downlink: builtins.str,
                 uplink: builtins.str):
        """
        :param builtins.str downlink: Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        :param builtins.str uplink: Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @property
    @pulumi.getter
    def downlink(self) -> builtins.str:
        """
        Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "downlink")

    @property
    @pulumi.getter
    def uplink(self) -> builtins.str:
        """
        Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "uplink")


@pulumi.output_type
class NetworkServicePccRuleQosPolicyMaximumBitRate(dict):
    def __init__(__self__, *,
                 downlink: builtins.str,
                 uplink: builtins.str):
        """
        :param builtins.str downlink: Downlink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        :param builtins.str uplink: Uplink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @property
    @pulumi.getter
    def downlink(self) -> builtins.str:
        """
        Downlink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "downlink")

    @property
    @pulumi.getter
    def uplink(self) -> builtins.str:
        """
        Uplink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "uplink")


@pulumi.output_type
class NetworkServicePccRuleServiceDataFlowTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "remoteIpLists":
            suggest = "remote_ip_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkServicePccRuleServiceDataFlowTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkServicePccRuleServiceDataFlowTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkServicePccRuleServiceDataFlowTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 direction: builtins.str,
                 name: builtins.str,
                 protocols: Sequence[builtins.str],
                 remote_ip_lists: Sequence[builtins.str],
                 ports: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str direction: Specifies the direction of this flow. Possible values are `Uplink`, `Downlink` and `Bidirectional`.
        :param builtins.str name: Specifies the name of the data flow template. This must be unique within the parent data flow policy rule. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        :param Sequence[builtins.str] protocols: A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
        :param Sequence[builtins.str] remote_ip_lists: Specifies the remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which the packet core instance will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, `192.0.2.54/24`).
        :param Sequence[builtins.str] ports: The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. If it is not specified then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "remote_ip_lists", remote_ip_lists)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def direction(self) -> builtins.str:
        """
        Specifies the direction of this flow. Possible values are `Uplink`, `Downlink` and `Bidirectional`.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the name of the data flow template. This must be unique within the parent data flow policy rule. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> Sequence[builtins.str]:
        """
        A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="remoteIpLists")
    def remote_ip_lists(self) -> Sequence[builtins.str]:
        """
        Specifies the remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which the packet core instance will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, `192.0.2.54/24`).
        """
        return pulumi.get(self, "remote_ip_lists")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence[builtins.str]]:
        """
        The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. If it is not specified then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class NetworkServiceServiceQosPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumBitRate":
            suggest = "maximum_bit_rate"
        elif key == "allocationAndRetentionPriorityLevel":
            suggest = "allocation_and_retention_priority_level"
        elif key == "preemptionCapability":
            suggest = "preemption_capability"
        elif key == "preemptionVulnerability":
            suggest = "preemption_vulnerability"
        elif key == "qosIndicator":
            suggest = "qos_indicator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkServiceServiceQosPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkServiceServiceQosPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkServiceServiceQosPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_bit_rate: 'outputs.NetworkServiceServiceQosPolicyMaximumBitRate',
                 allocation_and_retention_priority_level: Optional[builtins.int] = None,
                 preemption_capability: Optional[builtins.str] = None,
                 preemption_vulnerability: Optional[builtins.str] = None,
                 qos_indicator: Optional[builtins.int] = None):
        """
        :param 'NetworkServiceServiceQosPolicyMaximumBitRateArgs' maximum_bit_rate: A `maximum_bit_rate` block as defined below. The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        :param builtins.int allocation_and_retention_priority_level: QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. Defaults to `9`. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param builtins.str preemption_capability: The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`,.
        :param builtins.str preemption_vulnerability: The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`.
        :param builtins.int qos_indicator: The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        """
        pulumi.set(__self__, "maximum_bit_rate", maximum_bit_rate)
        if allocation_and_retention_priority_level is not None:
            pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        if preemption_capability is not None:
            pulumi.set(__self__, "preemption_capability", preemption_capability)
        if preemption_vulnerability is not None:
            pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)
        if qos_indicator is not None:
            pulumi.set(__self__, "qos_indicator", qos_indicator)

    @property
    @pulumi.getter(name="maximumBitRate")
    def maximum_bit_rate(self) -> 'outputs.NetworkServiceServiceQosPolicyMaximumBitRate':
        """
        A `maximum_bit_rate` block as defined below. The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        """
        return pulumi.get(self, "maximum_bit_rate")

    @property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> Optional[builtins.int]:
        """
        QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. Defaults to `9`. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> Optional[builtins.str]:
        """
        The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`,.
        """
        return pulumi.get(self, "preemption_capability")

    @property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> Optional[builtins.str]:
        """
        The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`.
        """
        return pulumi.get(self, "preemption_vulnerability")

    @property
    @pulumi.getter(name="qosIndicator")
    def qos_indicator(self) -> Optional[builtins.int]:
        """
        The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        """
        return pulumi.get(self, "qos_indicator")


@pulumi.output_type
class NetworkServiceServiceQosPolicyMaximumBitRate(dict):
    def __init__(__self__, *,
                 downlink: builtins.str,
                 uplink: builtins.str):
        """
        :param builtins.str downlink: Downlink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        :param builtins.str uplink: Uplink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @property
    @pulumi.getter
    def downlink(self) -> builtins.str:
        """
        Downlink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "downlink")

    @property
    @pulumi.getter
    def uplink(self) -> builtins.str:
        """
        Uplink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "uplink")


@pulumi.output_type
class NetworkSimGroupIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkSimGroupIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkSimGroupIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkSimGroupIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: A list of IDs for User Assigned Managed Identity resources to be assigned.
        :param builtins.str type: Specifies the type of Managed Service Identity. Possible value is `UserAssigned`.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        A list of IDs for User Assigned Managed Identity resources to be assigned.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity. Possible value is `UserAssigned`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NetworkSimPolicySlice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataNetworks":
            suggest = "data_networks"
        elif key == "defaultDataNetworkId":
            suggest = "default_data_network_id"
        elif key == "sliceId":
            suggest = "slice_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkSimPolicySlice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkSimPolicySlice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkSimPolicySlice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_networks: Sequence['outputs.NetworkSimPolicySliceDataNetwork'],
                 default_data_network_id: builtins.str,
                 slice_id: builtins.str):
        """
        :param Sequence['NetworkSimPolicySliceDataNetworkArgs'] data_networks: An array of `data_network` block as defined below.
        :param builtins.str default_data_network_id: The ID of default data network to use if the user equipment does not explicitly specify it. Configuration for this object must exist in the `data_network` block.
        :param builtins.str slice_id: The ID of the slice that these settings apply to.
        """
        pulumi.set(__self__, "data_networks", data_networks)
        pulumi.set(__self__, "default_data_network_id", default_data_network_id)
        pulumi.set(__self__, "slice_id", slice_id)

    @property
    @pulumi.getter(name="dataNetworks")
    def data_networks(self) -> Sequence['outputs.NetworkSimPolicySliceDataNetwork']:
        """
        An array of `data_network` block as defined below.
        """
        return pulumi.get(self, "data_networks")

    @property
    @pulumi.getter(name="defaultDataNetworkId")
    def default_data_network_id(self) -> builtins.str:
        """
        The ID of default data network to use if the user equipment does not explicitly specify it. Configuration for this object must exist in the `data_network` block.
        """
        return pulumi.get(self, "default_data_network_id")

    @property
    @pulumi.getter(name="sliceId")
    def slice_id(self) -> builtins.str:
        """
        The ID of the slice that these settings apply to.
        """
        return pulumi.get(self, "slice_id")


@pulumi.output_type
class NetworkSimPolicySliceDataNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedServicesIds":
            suggest = "allowed_services_ids"
        elif key == "dataNetworkId":
            suggest = "data_network_id"
        elif key == "qosIndicator":
            suggest = "qos_indicator"
        elif key == "sessionAggregateMaximumBitRate":
            suggest = "session_aggregate_maximum_bit_rate"
        elif key == "additionalAllowedSessionTypes":
            suggest = "additional_allowed_session_types"
        elif key == "allocationAndRetentionPriorityLevel":
            suggest = "allocation_and_retention_priority_level"
        elif key == "defaultSessionType":
            suggest = "default_session_type"
        elif key == "maxBufferedPackets":
            suggest = "max_buffered_packets"
        elif key == "preemptionCapability":
            suggest = "preemption_capability"
        elif key == "preemptionVulnerability":
            suggest = "preemption_vulnerability"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkSimPolicySliceDataNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkSimPolicySliceDataNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkSimPolicySliceDataNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_services_ids: Sequence[builtins.str],
                 data_network_id: builtins.str,
                 qos_indicator: builtins.int,
                 session_aggregate_maximum_bit_rate: 'outputs.NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate',
                 additional_allowed_session_types: Optional[Sequence[builtins.str]] = None,
                 allocation_and_retention_priority_level: Optional[builtins.int] = None,
                 default_session_type: Optional[builtins.str] = None,
                 max_buffered_packets: Optional[builtins.int] = None,
                 preemption_capability: Optional[builtins.str] = None,
                 preemption_vulnerability: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] allowed_services_ids: An array of IDs of services that can be used as part of this SIM policy. The array must not contain duplicate items and must contain at least one item.
        :param builtins.str data_network_id: The ID of Mobile Network Data Network which these settings apply to.
        :param builtins.int qos_indicator: The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics, it controls QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        :param 'NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateArgs' session_aggregate_maximum_bit_rate: A `session_aggregate_maximum_bit_rate` block as defined below.
        :param Sequence[builtins.str] additional_allowed_session_types: Allowed session types in addition to the default session type. Must not duplicate the default session type. Possible values are `IPv4` and `IPv6`.
        :param builtins.int allocation_and_retention_priority_level: Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. `1` is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param builtins.str default_session_type: The default PDU session type, which is used if the user equipment does not request a specific session type. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`.
        :param builtins.int max_buffered_packets: The maximum number of downlink packets to buffer at the user plane for High Latency Communication - Extended Buffering. Defaults to `10`, Must be at least `0`, See 3GPP TS29.272 v15.10.0 section 7.3.188 for a full description. This maximum is not guaranteed because there is a internal limit on buffered packets across all PDU sessions.
        :param builtins.str preemption_capability: The Preemption Capability of a QoS Flow, it controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`, Defaults to `NotPreempt`.
        :param builtins.str preemption_vulnerability: The Preemption Vulnerability of a QoS Flow, it controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`. Defaults to `NotPreemptable`.
        """
        pulumi.set(__self__, "allowed_services_ids", allowed_services_ids)
        pulumi.set(__self__, "data_network_id", data_network_id)
        pulumi.set(__self__, "qos_indicator", qos_indicator)
        pulumi.set(__self__, "session_aggregate_maximum_bit_rate", session_aggregate_maximum_bit_rate)
        if additional_allowed_session_types is not None:
            pulumi.set(__self__, "additional_allowed_session_types", additional_allowed_session_types)
        if allocation_and_retention_priority_level is not None:
            pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        if default_session_type is not None:
            pulumi.set(__self__, "default_session_type", default_session_type)
        if max_buffered_packets is not None:
            pulumi.set(__self__, "max_buffered_packets", max_buffered_packets)
        if preemption_capability is not None:
            pulumi.set(__self__, "preemption_capability", preemption_capability)
        if preemption_vulnerability is not None:
            pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)

    @property
    @pulumi.getter(name="allowedServicesIds")
    def allowed_services_ids(self) -> Sequence[builtins.str]:
        """
        An array of IDs of services that can be used as part of this SIM policy. The array must not contain duplicate items and must contain at least one item.
        """
        return pulumi.get(self, "allowed_services_ids")

    @property
    @pulumi.getter(name="dataNetworkId")
    def data_network_id(self) -> builtins.str:
        """
        The ID of Mobile Network Data Network which these settings apply to.
        """
        return pulumi.get(self, "data_network_id")

    @property
    @pulumi.getter(name="qosIndicator")
    def qos_indicator(self) -> builtins.int:
        """
        The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics, it controls QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        """
        return pulumi.get(self, "qos_indicator")

    @property
    @pulumi.getter(name="sessionAggregateMaximumBitRate")
    def session_aggregate_maximum_bit_rate(self) -> 'outputs.NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate':
        """
        A `session_aggregate_maximum_bit_rate` block as defined below.
        """
        return pulumi.get(self, "session_aggregate_maximum_bit_rate")

    @property
    @pulumi.getter(name="additionalAllowedSessionTypes")
    def additional_allowed_session_types(self) -> Optional[Sequence[builtins.str]]:
        """
        Allowed session types in addition to the default session type. Must not duplicate the default session type. Possible values are `IPv4` and `IPv6`.
        """
        return pulumi.get(self, "additional_allowed_session_types")

    @property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> Optional[builtins.int]:
        """
        Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. `1` is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @property
    @pulumi.getter(name="defaultSessionType")
    def default_session_type(self) -> Optional[builtins.str]:
        """
        The default PDU session type, which is used if the user equipment does not request a specific session type. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`.
        """
        return pulumi.get(self, "default_session_type")

    @property
    @pulumi.getter(name="maxBufferedPackets")
    def max_buffered_packets(self) -> Optional[builtins.int]:
        """
        The maximum number of downlink packets to buffer at the user plane for High Latency Communication - Extended Buffering. Defaults to `10`, Must be at least `0`, See 3GPP TS29.272 v15.10.0 section 7.3.188 for a full description. This maximum is not guaranteed because there is a internal limit on buffered packets across all PDU sessions.
        """
        return pulumi.get(self, "max_buffered_packets")

    @property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> Optional[builtins.str]:
        """
        The Preemption Capability of a QoS Flow, it controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`, Defaults to `NotPreempt`.
        """
        return pulumi.get(self, "preemption_capability")

    @property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> Optional[builtins.str]:
        """
        The Preemption Vulnerability of a QoS Flow, it controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`. Defaults to `NotPreemptable`.
        """
        return pulumi.get(self, "preemption_vulnerability")


@pulumi.output_type
class NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate(dict):
    def __init__(__self__, *,
                 downlink: builtins.str,
                 uplink: builtins.str):
        """
        :param builtins.str downlink: Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        :param builtins.str uplink: Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @property
    @pulumi.getter
    def downlink(self) -> builtins.str:
        """
        Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "downlink")

    @property
    @pulumi.getter
    def uplink(self) -> builtins.str:
        """
        Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "uplink")


@pulumi.output_type
class NetworkSimPolicyUserEquipmentAggregateMaximumBitRate(dict):
    def __init__(__self__, *,
                 downlink: builtins.str,
                 uplink: builtins.str):
        """
        :param builtins.str downlink: Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        :param builtins.str uplink: Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @property
    @pulumi.getter
    def downlink(self) -> builtins.str:
        """
        Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "downlink")

    @property
    @pulumi.getter
    def uplink(self) -> builtins.str:
        """
        Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "uplink")


@pulumi.output_type
class NetworkSimStaticIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attachedDataNetworkId":
            suggest = "attached_data_network_id"
        elif key == "sliceId":
            suggest = "slice_id"
        elif key == "staticIpv4Address":
            suggest = "static_ipv4_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkSimStaticIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkSimStaticIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkSimStaticIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attached_data_network_id: builtins.str,
                 slice_id: builtins.str,
                 static_ipv4_address: Optional[builtins.str] = None):
        """
        :param builtins.str attached_data_network_id: The ID of attached data network on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address.
        :param builtins.str slice_id: The ID of network slice on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address.
        :param builtins.str static_ipv4_address: The IPv4 address assigned to the SIM at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attached data network.
        """
        pulumi.set(__self__, "attached_data_network_id", attached_data_network_id)
        pulumi.set(__self__, "slice_id", slice_id)
        if static_ipv4_address is not None:
            pulumi.set(__self__, "static_ipv4_address", static_ipv4_address)

    @property
    @pulumi.getter(name="attachedDataNetworkId")
    def attached_data_network_id(self) -> builtins.str:
        """
        The ID of attached data network on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address.
        """
        return pulumi.get(self, "attached_data_network_id")

    @property
    @pulumi.getter(name="sliceId")
    def slice_id(self) -> builtins.str:
        """
        The ID of network slice on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address.
        """
        return pulumi.get(self, "slice_id")

    @property
    @pulumi.getter(name="staticIpv4Address")
    def static_ipv4_address(self) -> Optional[builtins.str]:
        """
        The IPv4 address assigned to the SIM at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attached data network.
        """
        return pulumi.get(self, "static_ipv4_address")


@pulumi.output_type
class NetworkSliceSingleNetworkSliceSelectionAssistanceInformation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sliceServiceType":
            suggest = "slice_service_type"
        elif key == "sliceDifferentiator":
            suggest = "slice_differentiator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkSliceSingleNetworkSliceSelectionAssistanceInformation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkSliceSingleNetworkSliceSelectionAssistanceInformation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkSliceSingleNetworkSliceSelectionAssistanceInformation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 slice_service_type: builtins.int,
                 slice_differentiator: Optional[builtins.str] = None):
        """
        :param builtins.int slice_service_type: Slice/service type (SST). Must be between `0` and `255`.
        :param builtins.str slice_differentiator: Slice differentiator (SD). Must be a 6 digit hex string.
        """
        pulumi.set(__self__, "slice_service_type", slice_service_type)
        if slice_differentiator is not None:
            pulumi.set(__self__, "slice_differentiator", slice_differentiator)

    @property
    @pulumi.getter(name="sliceServiceType")
    def slice_service_type(self) -> builtins.int:
        """
        Slice/service type (SST). Must be between `0` and `255`.
        """
        return pulumi.get(self, "slice_service_type")

    @property
    @pulumi.getter(name="sliceDifferentiator")
    def slice_differentiator(self) -> Optional[builtins.str]:
        """
        Slice differentiator (SD). Must be a 6 digit hex string.
        """
        return pulumi.get(self, "slice_differentiator")


@pulumi.output_type
class GetNetworkAttachedDataNetworkNetworkAddressPortTranslationResult(dict):
    def __init__(__self__, *,
                 icmp_pinhole_timeout_in_seconds: builtins.int,
                 port_ranges: Sequence['outputs.GetNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeResult'],
                 tcp_pinhole_timeout_in_seconds: builtins.int,
                 tcp_port_reuse_minimum_hold_time_in_seconds: builtins.int,
                 udp_pinhole_timeout_in_seconds: builtins.int,
                 udp_port_reuse_minimum_hold_time_in_seconds: builtins.int,
                 pinhole_maximum_number: Optional[builtins.int] = None):
        """
        :param Sequence['GetNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeArgs'] port_ranges: A `port_range` block as defined below.
        :param builtins.int tcp_port_reuse_minimum_hold_time_in_seconds: Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused.
        :param builtins.int udp_port_reuse_minimum_hold_time_in_seconds: Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused.
        """
        pulumi.set(__self__, "icmp_pinhole_timeout_in_seconds", icmp_pinhole_timeout_in_seconds)
        pulumi.set(__self__, "port_ranges", port_ranges)
        pulumi.set(__self__, "tcp_pinhole_timeout_in_seconds", tcp_pinhole_timeout_in_seconds)
        pulumi.set(__self__, "tcp_port_reuse_minimum_hold_time_in_seconds", tcp_port_reuse_minimum_hold_time_in_seconds)
        pulumi.set(__self__, "udp_pinhole_timeout_in_seconds", udp_pinhole_timeout_in_seconds)
        pulumi.set(__self__, "udp_port_reuse_minimum_hold_time_in_seconds", udp_port_reuse_minimum_hold_time_in_seconds)
        if pinhole_maximum_number is not None:
            pulumi.set(__self__, "pinhole_maximum_number", pinhole_maximum_number)

    @property
    @pulumi.getter(name="icmpPinholeTimeoutInSeconds")
    def icmp_pinhole_timeout_in_seconds(self) -> builtins.int:
        return pulumi.get(self, "icmp_pinhole_timeout_in_seconds")

    @property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> Sequence['outputs.GetNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeResult']:
        """
        A `port_range` block as defined below.
        """
        return pulumi.get(self, "port_ranges")

    @property
    @pulumi.getter(name="tcpPinholeTimeoutInSeconds")
    def tcp_pinhole_timeout_in_seconds(self) -> builtins.int:
        return pulumi.get(self, "tcp_pinhole_timeout_in_seconds")

    @property
    @pulumi.getter(name="tcpPortReuseMinimumHoldTimeInSeconds")
    def tcp_port_reuse_minimum_hold_time_in_seconds(self) -> builtins.int:
        """
        Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused.
        """
        return pulumi.get(self, "tcp_port_reuse_minimum_hold_time_in_seconds")

    @property
    @pulumi.getter(name="udpPinholeTimeoutInSeconds")
    def udp_pinhole_timeout_in_seconds(self) -> builtins.int:
        return pulumi.get(self, "udp_pinhole_timeout_in_seconds")

    @property
    @pulumi.getter(name="udpPortReuseMinimumHoldTimeInSeconds")
    def udp_port_reuse_minimum_hold_time_in_seconds(self) -> builtins.int:
        """
        Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused.
        """
        return pulumi.get(self, "udp_port_reuse_minimum_hold_time_in_seconds")

    @property
    @pulumi.getter(name="pinholeMaximumNumber")
    def pinhole_maximum_number(self) -> Optional[builtins.int]:
        return pulumi.get(self, "pinhole_maximum_number")


@pulumi.output_type
class GetNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeResult(dict):
    def __init__(__self__, *,
                 maximum: builtins.int,
                 minimum: builtins.int):
        """
        :param builtins.int maximum: The maximum port number.
        :param builtins.int minimum: The minimum port number.
        """
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter
    def maximum(self) -> builtins.int:
        """
        The maximum port number.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> builtins.int:
        """
        The minimum port number.
        """
        return pulumi.get(self, "minimum")


@pulumi.output_type
class GetNetworkPacketCoreControlPlaneIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: A list of User Assigned Managed Identity IDs assigned to this resource.
        :param builtins.str type: The platform type where the packet core is deployed.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        A list of User Assigned Managed Identity IDs assigned to this resource.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The platform type where the packet core is deployed.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkPacketCoreControlPlaneLocalDiagnosticsAccessResult(dict):
    def __init__(__self__, *,
                 authentication_type: builtins.str,
                 https_server_certificate_url: builtins.str):
        """
        :param builtins.str authentication_type: How to authenticate users who access local diagnostics APIs.
        :param builtins.str https_server_certificate_url: The versionless certificate URL used to secure local access to packet core diagnostics over local APIs by the Kubernetes ingress.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "https_server_certificate_url", https_server_certificate_url)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> builtins.str:
        """
        How to authenticate users who access local diagnostics APIs.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="httpsServerCertificateUrl")
    def https_server_certificate_url(self) -> builtins.str:
        """
        The versionless certificate URL used to secure local access to packet core diagnostics over local APIs by the Kubernetes ingress.
        """
        return pulumi.get(self, "https_server_certificate_url")


@pulumi.output_type
class GetNetworkPacketCoreControlPlanePlatformResult(dict):
    def __init__(__self__, *,
                 arc_kubernetes_cluster_id: builtins.str,
                 custom_location_id: builtins.str,
                 edge_device_id: builtins.str,
                 stack_hci_cluster_id: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str arc_kubernetes_cluster_id: The ID of Azure Arc connected cluster where the packet core is deployed.
        :param builtins.str custom_location_id: The ID of Azure Arc custom location where the packet core is deployed.
        :param builtins.str edge_device_id: The ID of Azure Stack Edge device where the packet core is deployed.
        :param builtins.str stack_hci_cluster_id: The ID of Azure Stack HCI cluster where the packet core is deployed.
        :param builtins.str type: The platform type where the packet core is deployed.
        """
        pulumi.set(__self__, "arc_kubernetes_cluster_id", arc_kubernetes_cluster_id)
        pulumi.set(__self__, "custom_location_id", custom_location_id)
        pulumi.set(__self__, "edge_device_id", edge_device_id)
        pulumi.set(__self__, "stack_hci_cluster_id", stack_hci_cluster_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="arcKubernetesClusterId")
    def arc_kubernetes_cluster_id(self) -> builtins.str:
        """
        The ID of Azure Arc connected cluster where the packet core is deployed.
        """
        return pulumi.get(self, "arc_kubernetes_cluster_id")

    @property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> builtins.str:
        """
        The ID of Azure Arc custom location where the packet core is deployed.
        """
        return pulumi.get(self, "custom_location_id")

    @property
    @pulumi.getter(name="edgeDeviceId")
    def edge_device_id(self) -> builtins.str:
        """
        The ID of Azure Stack Edge device where the packet core is deployed.
        """
        return pulumi.get(self, "edge_device_id")

    @property
    @pulumi.getter(name="stackHciClusterId")
    def stack_hci_cluster_id(self) -> builtins.str:
        """
        The ID of Azure Stack HCI cluster where the packet core is deployed.
        """
        return pulumi.get(self, "stack_hci_cluster_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The platform type where the packet core is deployed.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkServicePccRuleResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 precedence: builtins.int,
                 qos_policies: Sequence['outputs.GetNetworkServicePccRuleQosPolicyResult'],
                 service_data_flow_templates: Sequence['outputs.GetNetworkServicePccRuleServiceDataFlowTemplateResult'],
                 traffic_control_enabled: builtins.bool):
        """
        :param builtins.str name: Specifies the name which should be used for this Mobile Network Service.
        :param builtins.int precedence: A precedence value that is used to decide between data flow policy rules when identifying the QoS values to use for a particular SIM. A lower value means a higher priority.
        :param Sequence['GetNetworkServicePccRuleQosPolicyArgs'] qos_policies: A `rule_qos_policy` block as defined below. The QoS policy to use for packets matching this rule.
        :param Sequence['GetNetworkServicePccRuleServiceDataFlowTemplateArgs'] service_data_flow_templates: A `service_data_flow_template` block as defined below. The set of service data flow templates to use for this PCC rule.
        :param builtins.bool traffic_control_enabled: Determines whether flows that match this data flow policy rule are permitted.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "precedence", precedence)
        pulumi.set(__self__, "qos_policies", qos_policies)
        pulumi.set(__self__, "service_data_flow_templates", service_data_flow_templates)
        pulumi.set(__self__, "traffic_control_enabled", traffic_control_enabled)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the name which should be used for this Mobile Network Service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def precedence(self) -> builtins.int:
        """
        A precedence value that is used to decide between data flow policy rules when identifying the QoS values to use for a particular SIM. A lower value means a higher priority.
        """
        return pulumi.get(self, "precedence")

    @property
    @pulumi.getter(name="qosPolicies")
    def qos_policies(self) -> Sequence['outputs.GetNetworkServicePccRuleQosPolicyResult']:
        """
        A `rule_qos_policy` block as defined below. The QoS policy to use for packets matching this rule.
        """
        return pulumi.get(self, "qos_policies")

    @property
    @pulumi.getter(name="serviceDataFlowTemplates")
    def service_data_flow_templates(self) -> Sequence['outputs.GetNetworkServicePccRuleServiceDataFlowTemplateResult']:
        """
        A `service_data_flow_template` block as defined below. The set of service data flow templates to use for this PCC rule.
        """
        return pulumi.get(self, "service_data_flow_templates")

    @property
    @pulumi.getter(name="trafficControlEnabled")
    def traffic_control_enabled(self) -> builtins.bool:
        """
        Determines whether flows that match this data flow policy rule are permitted.
        """
        return pulumi.get(self, "traffic_control_enabled")


@pulumi.output_type
class GetNetworkServicePccRuleQosPolicyResult(dict):
    def __init__(__self__, *,
                 allocation_and_retention_priority_level: builtins.int,
                 guaranteed_bit_rates: Sequence['outputs.GetNetworkServicePccRuleQosPolicyGuaranteedBitRateResult'],
                 maximum_bit_rates: Sequence['outputs.GetNetworkServicePccRuleQosPolicyMaximumBitRateResult'],
                 preemption_capability: builtins.str,
                 preemption_vulnerability: builtins.str,
                 qos_indicator: builtins.int):
        """
        :param builtins.int allocation_and_retention_priority_level: QoS Flow allocation and retention priority (ARP) level.
        :param Sequence['GetNetworkServicePccRuleQosPolicyGuaranteedBitRateArgs'] guaranteed_bit_rates: A `guaranteed_bit_rate` block as defined below. The Guaranteed Bit Rate (GBR) for all service data flows that use this PCC Rule.
        :param Sequence['GetNetworkServicePccRuleQosPolicyMaximumBitRateArgs'] maximum_bit_rates: A `maximum_bit_rate` block as defined below. The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        :param builtins.str preemption_capability: The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param builtins.str preemption_vulnerability: The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param builtins.int qos_indicator: The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers.
        """
        pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        pulumi.set(__self__, "guaranteed_bit_rates", guaranteed_bit_rates)
        pulumi.set(__self__, "maximum_bit_rates", maximum_bit_rates)
        pulumi.set(__self__, "preemption_capability", preemption_capability)
        pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)
        pulumi.set(__self__, "qos_indicator", qos_indicator)

    @property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> builtins.int:
        """
        QoS Flow allocation and retention priority (ARP) level.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @property
    @pulumi.getter(name="guaranteedBitRates")
    def guaranteed_bit_rates(self) -> Sequence['outputs.GetNetworkServicePccRuleQosPolicyGuaranteedBitRateResult']:
        """
        A `guaranteed_bit_rate` block as defined below. The Guaranteed Bit Rate (GBR) for all service data flows that use this PCC Rule.
        """
        return pulumi.get(self, "guaranteed_bit_rates")

    @property
    @pulumi.getter(name="maximumBitRates")
    def maximum_bit_rates(self) -> Sequence['outputs.GetNetworkServicePccRuleQosPolicyMaximumBitRateResult']:
        """
        A `maximum_bit_rate` block as defined below. The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        """
        return pulumi.get(self, "maximum_bit_rates")

    @property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> builtins.str:
        """
        The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_capability")

    @property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> builtins.str:
        """
        The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_vulnerability")

    @property
    @pulumi.getter(name="qosIndicator")
    def qos_indicator(self) -> builtins.int:
        """
        The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers.
        """
        return pulumi.get(self, "qos_indicator")


@pulumi.output_type
class GetNetworkServicePccRuleQosPolicyGuaranteedBitRateResult(dict):
    def __init__(__self__, *,
                 downlink: builtins.str,
                 uplink: builtins.str):
        """
        :param builtins.str downlink: Downlink bit rate.
        :param builtins.str uplink: Uplink bit rate.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @property
    @pulumi.getter
    def downlink(self) -> builtins.str:
        """
        Downlink bit rate.
        """
        return pulumi.get(self, "downlink")

    @property
    @pulumi.getter
    def uplink(self) -> builtins.str:
        """
        Uplink bit rate.
        """
        return pulumi.get(self, "uplink")


@pulumi.output_type
class GetNetworkServicePccRuleQosPolicyMaximumBitRateResult(dict):
    def __init__(__self__, *,
                 downlink: builtins.str,
                 uplink: builtins.str):
        """
        :param builtins.str downlink: Downlink bit rate.
        :param builtins.str uplink: Uplink bit rate.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @property
    @pulumi.getter
    def downlink(self) -> builtins.str:
        """
        Downlink bit rate.
        """
        return pulumi.get(self, "downlink")

    @property
    @pulumi.getter
    def uplink(self) -> builtins.str:
        """
        Uplink bit rate.
        """
        return pulumi.get(self, "uplink")


@pulumi.output_type
class GetNetworkServicePccRuleServiceDataFlowTemplateResult(dict):
    def __init__(__self__, *,
                 direction: builtins.str,
                 name: builtins.str,
                 ports: Sequence[builtins.str],
                 protocols: Sequence[builtins.str],
                 remote_ip_lists: Sequence[builtins.str]):
        """
        :param builtins.str direction: The direction of this flow. Possible values are `Uplink`, `Downlink` and `Bidirectional`.
        :param builtins.str name: Specifies the name which should be used for this Mobile Network Service.
        :param Sequence[builtins.str] ports: The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges.
        :param Sequence[builtins.str] protocols: A list of the allowed protocol(s) for this flow.
        :param Sequence[builtins.str] remote_ip_lists: The remote IP address(es) to which UEs will connect for this flow.
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "remote_ip_lists", remote_ip_lists)

    @property
    @pulumi.getter
    def direction(self) -> builtins.str:
        """
        The direction of this flow. Possible values are `Uplink`, `Downlink` and `Bidirectional`.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the name which should be used for this Mobile Network Service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Sequence[builtins.str]:
        """
        The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def protocols(self) -> Sequence[builtins.str]:
        """
        A list of the allowed protocol(s) for this flow.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="remoteIpLists")
    def remote_ip_lists(self) -> Sequence[builtins.str]:
        """
        The remote IP address(es) to which UEs will connect for this flow.
        """
        return pulumi.get(self, "remote_ip_lists")


@pulumi.output_type
class GetNetworkServiceServiceQosPolicyResult(dict):
    def __init__(__self__, *,
                 allocation_and_retention_priority_level: builtins.int,
                 maximum_bit_rates: Sequence['outputs.GetNetworkServiceServiceQosPolicyMaximumBitRateResult'],
                 preemption_capability: builtins.str,
                 preemption_vulnerability: builtins.str,
                 qos_indicator: builtins.int):
        """
        :param builtins.int allocation_and_retention_priority_level: QoS Flow allocation and retention priority (ARP) level.
        :param Sequence['GetNetworkServiceServiceQosPolicyMaximumBitRateArgs'] maximum_bit_rates: A `maximum_bit_rate` block as defined below. The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        :param builtins.str preemption_capability: The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param builtins.str preemption_vulnerability: The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param builtins.int qos_indicator: The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers.
        """
        pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        pulumi.set(__self__, "maximum_bit_rates", maximum_bit_rates)
        pulumi.set(__self__, "preemption_capability", preemption_capability)
        pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)
        pulumi.set(__self__, "qos_indicator", qos_indicator)

    @property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> builtins.int:
        """
        QoS Flow allocation and retention priority (ARP) level.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @property
    @pulumi.getter(name="maximumBitRates")
    def maximum_bit_rates(self) -> Sequence['outputs.GetNetworkServiceServiceQosPolicyMaximumBitRateResult']:
        """
        A `maximum_bit_rate` block as defined below. The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        """
        return pulumi.get(self, "maximum_bit_rates")

    @property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> builtins.str:
        """
        The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_capability")

    @property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> builtins.str:
        """
        The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_vulnerability")

    @property
    @pulumi.getter(name="qosIndicator")
    def qos_indicator(self) -> builtins.int:
        """
        The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers.
        """
        return pulumi.get(self, "qos_indicator")


@pulumi.output_type
class GetNetworkServiceServiceQosPolicyMaximumBitRateResult(dict):
    def __init__(__self__, *,
                 downlink: builtins.str,
                 uplink: builtins.str):
        """
        :param builtins.str downlink: Downlink bit rate.
        :param builtins.str uplink: Uplink bit rate.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @property
    @pulumi.getter
    def downlink(self) -> builtins.str:
        """
        Downlink bit rate.
        """
        return pulumi.get(self, "downlink")

    @property
    @pulumi.getter
    def uplink(self) -> builtins.str:
        """
        Uplink bit rate.
        """
        return pulumi.get(self, "uplink")


@pulumi.output_type
class GetNetworkSimGroupIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: A list of User Assigned Managed Identity IDs assigned to this resource.
        :param builtins.str type: The type of Managed Service Identity. Possible values are `SystemAssigned`, `UserAssigned`.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        A list of User Assigned Managed Identity IDs assigned to this resource.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of Managed Service Identity. Possible values are `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkSimPolicySliceResult(dict):
    def __init__(__self__, *,
                 data_networks: Sequence['outputs.GetNetworkSimPolicySliceDataNetworkResult'],
                 default_data_network_id: builtins.str,
                 slice_id: builtins.str):
        """
        :param Sequence['GetNetworkSimPolicySliceDataNetworkArgs'] data_networks: An array of `data_network` block as defined below.
        :param builtins.str default_data_network_id: The ID of default data network to use if the UE does not explicitly specify it.
        :param builtins.str slice_id: The ID of the slice that these settings apply to.
        """
        pulumi.set(__self__, "data_networks", data_networks)
        pulumi.set(__self__, "default_data_network_id", default_data_network_id)
        pulumi.set(__self__, "slice_id", slice_id)

    @property
    @pulumi.getter(name="dataNetworks")
    def data_networks(self) -> Sequence['outputs.GetNetworkSimPolicySliceDataNetworkResult']:
        """
        An array of `data_network` block as defined below.
        """
        return pulumi.get(self, "data_networks")

    @property
    @pulumi.getter(name="defaultDataNetworkId")
    def default_data_network_id(self) -> builtins.str:
        """
        The ID of default data network to use if the UE does not explicitly specify it.
        """
        return pulumi.get(self, "default_data_network_id")

    @property
    @pulumi.getter(name="sliceId")
    def slice_id(self) -> builtins.str:
        """
        The ID of the slice that these settings apply to.
        """
        return pulumi.get(self, "slice_id")


@pulumi.output_type
class GetNetworkSimPolicySliceDataNetworkResult(dict):
    def __init__(__self__, *,
                 additional_allowed_session_types: Sequence[builtins.str],
                 allocation_and_retention_priority_level: builtins.int,
                 allowed_services_ids: Sequence[builtins.str],
                 data_network_id: builtins.str,
                 default_session_type: builtins.str,
                 max_buffered_packets: builtins.int,
                 preemption_capability: builtins.str,
                 preemption_vulnerability: builtins.str,
                 qos_indicator: builtins.int,
                 session_aggregate_maximum_bit_rates: Sequence['outputs.GetNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateResult']):
        """
        :param Sequence[builtins.str] additional_allowed_session_types: Allowed session types in addition to the default session type.
        :param builtins.int allocation_and_retention_priority_level: Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param Sequence[builtins.str] allowed_services_ids: An array of IDs of services that can be used as part of this SIM policy.
        :param builtins.str data_network_id: The ID of Mobile Network Data Network which these settings apply to.
        :param builtins.str default_session_type: The default PDU session type, which is used if the UE does not request a specific session type.
        :param builtins.int max_buffered_packets: The maximum number of downlink packets to buffer at the user plane for High Latency Communication - Extended Buffering.
        :param builtins.str preemption_capability: The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param builtins.str preemption_vulnerability: The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param builtins.int qos_indicator: The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers.
        :param Sequence['GetNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateArgs'] session_aggregate_maximum_bit_rates: A `session_aggregate_maximum_bit_rate` block as defined below.
        """
        pulumi.set(__self__, "additional_allowed_session_types", additional_allowed_session_types)
        pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        pulumi.set(__self__, "allowed_services_ids", allowed_services_ids)
        pulumi.set(__self__, "data_network_id", data_network_id)
        pulumi.set(__self__, "default_session_type", default_session_type)
        pulumi.set(__self__, "max_buffered_packets", max_buffered_packets)
        pulumi.set(__self__, "preemption_capability", preemption_capability)
        pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)
        pulumi.set(__self__, "qos_indicator", qos_indicator)
        pulumi.set(__self__, "session_aggregate_maximum_bit_rates", session_aggregate_maximum_bit_rates)

    @property
    @pulumi.getter(name="additionalAllowedSessionTypes")
    def additional_allowed_session_types(self) -> Sequence[builtins.str]:
        """
        Allowed session types in addition to the default session type.
        """
        return pulumi.get(self, "additional_allowed_session_types")

    @property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> builtins.int:
        """
        Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @property
    @pulumi.getter(name="allowedServicesIds")
    def allowed_services_ids(self) -> Sequence[builtins.str]:
        """
        An array of IDs of services that can be used as part of this SIM policy.
        """
        return pulumi.get(self, "allowed_services_ids")

    @property
    @pulumi.getter(name="dataNetworkId")
    def data_network_id(self) -> builtins.str:
        """
        The ID of Mobile Network Data Network which these settings apply to.
        """
        return pulumi.get(self, "data_network_id")

    @property
    @pulumi.getter(name="defaultSessionType")
    def default_session_type(self) -> builtins.str:
        """
        The default PDU session type, which is used if the UE does not request a specific session type.
        """
        return pulumi.get(self, "default_session_type")

    @property
    @pulumi.getter(name="maxBufferedPackets")
    def max_buffered_packets(self) -> builtins.int:
        """
        The maximum number of downlink packets to buffer at the user plane for High Latency Communication - Extended Buffering.
        """
        return pulumi.get(self, "max_buffered_packets")

    @property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> builtins.str:
        """
        The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_capability")

    @property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> builtins.str:
        """
        The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_vulnerability")

    @property
    @pulumi.getter(name="qosIndicator")
    def qos_indicator(self) -> builtins.int:
        """
        The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers.
        """
        return pulumi.get(self, "qos_indicator")

    @property
    @pulumi.getter(name="sessionAggregateMaximumBitRates")
    def session_aggregate_maximum_bit_rates(self) -> Sequence['outputs.GetNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateResult']:
        """
        A `session_aggregate_maximum_bit_rate` block as defined below.
        """
        return pulumi.get(self, "session_aggregate_maximum_bit_rates")


@pulumi.output_type
class GetNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateResult(dict):
    def __init__(__self__, *,
                 downlink: builtins.str,
                 uplink: builtins.str):
        """
        :param builtins.str downlink: Downlink bit rate.
        :param builtins.str uplink: Uplink bit rate.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @property
    @pulumi.getter
    def downlink(self) -> builtins.str:
        """
        Downlink bit rate.
        """
        return pulumi.get(self, "downlink")

    @property
    @pulumi.getter
    def uplink(self) -> builtins.str:
        """
        Uplink bit rate.
        """
        return pulumi.get(self, "uplink")


@pulumi.output_type
class GetNetworkSimPolicyUserEquipmentAggregateMaximumBitRateResult(dict):
    def __init__(__self__, *,
                 downlink: builtins.str,
                 uplink: builtins.str):
        """
        :param builtins.str downlink: Downlink bit rate.
        :param builtins.str uplink: Uplink bit rate.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @property
    @pulumi.getter
    def downlink(self) -> builtins.str:
        """
        Downlink bit rate.
        """
        return pulumi.get(self, "downlink")

    @property
    @pulumi.getter
    def uplink(self) -> builtins.str:
        """
        Uplink bit rate.
        """
        return pulumi.get(self, "uplink")


@pulumi.output_type
class GetNetworkSimStaticIpConfigurationResult(dict):
    def __init__(__self__, *,
                 attached_data_network_id: builtins.str,
                 slice_id: builtins.str,
                 static_ipv4_address: builtins.str):
        """
        :param builtins.str attached_data_network_id: The ID of attached data network on which the static.
        :param builtins.str static_ipv4_address: The IPv4 address assigned to the SIM at this network scope.
        """
        pulumi.set(__self__, "attached_data_network_id", attached_data_network_id)
        pulumi.set(__self__, "slice_id", slice_id)
        pulumi.set(__self__, "static_ipv4_address", static_ipv4_address)

    @property
    @pulumi.getter(name="attachedDataNetworkId")
    def attached_data_network_id(self) -> builtins.str:
        """
        The ID of attached data network on which the static.
        """
        return pulumi.get(self, "attached_data_network_id")

    @property
    @pulumi.getter(name="sliceId")
    def slice_id(self) -> builtins.str:
        return pulumi.get(self, "slice_id")

    @property
    @pulumi.getter(name="staticIpv4Address")
    def static_ipv4_address(self) -> builtins.str:
        """
        The IPv4 address assigned to the SIM at this network scope.
        """
        return pulumi.get(self, "static_ipv4_address")


@pulumi.output_type
class GetNetworkSliceSingleNetworkSliceSelectionAssistanceInformationResult(dict):
    def __init__(__self__, *,
                 slice_differentiator: builtins.str,
                 slice_service_type: builtins.int):
        """
        :param builtins.str slice_differentiator: Slice differentiator (SD).
        :param builtins.int slice_service_type: Slice/service type (SST).
        """
        pulumi.set(__self__, "slice_differentiator", slice_differentiator)
        pulumi.set(__self__, "slice_service_type", slice_service_type)

    @property
    @pulumi.getter(name="sliceDifferentiator")
    def slice_differentiator(self) -> builtins.str:
        """
        Slice differentiator (SD).
        """
        return pulumi.get(self, "slice_differentiator")

    @property
    @pulumi.getter(name="sliceServiceType")
    def slice_service_type(self) -> builtins.int:
        """
        Slice/service type (SST).
        """
        return pulumi.get(self, "slice_service_type")


