# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertProcessingRuleSuppressionArgs', 'AlertProcessingRuleSuppression']

@pulumi.input_type
class AlertProcessingRuleSuppressionArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 scopes: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 condition: Optional[pulumi.Input['AlertProcessingRuleSuppressionConditionArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input['AlertProcessingRuleSuppressionScheduleArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a AlertProcessingRuleSuppression resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Alert Processing Rule should exist. Changing this forces a new Alert Processing Rule to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: A list of resource IDs which will be the target of Alert Processing Rule.
        :param pulumi.Input['AlertProcessingRuleSuppressionConditionArgs'] condition: A `condition` block as defined below.
        :param pulumi.Input[builtins.str] description: Specifies a description for the Alert Processing Rule.
        :param pulumi.Input[builtins.bool] enabled: Should the Alert Processing Rule be enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Alert Processing Rule. Changing this forces a new Alert Processing Rule to be created.
        :param pulumi.Input['AlertProcessingRuleSuppressionScheduleArgs'] schedule: A `schedule` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Alert Processing Rule.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "scopes", scopes)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Alert Processing Rule should exist. Changing this forces a new Alert Processing Rule to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of resource IDs which will be the target of Alert Processing Rule.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['AlertProcessingRuleSuppressionConditionArgs']]:
        """
        A `condition` block as defined below.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['AlertProcessingRuleSuppressionConditionArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a description for the Alert Processing Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Alert Processing Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Alert Processing Rule. Changing this forces a new Alert Processing Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['AlertProcessingRuleSuppressionScheduleArgs']]:
        """
        A `schedule` block as defined below.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['AlertProcessingRuleSuppressionScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Alert Processing Rule.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AlertProcessingRuleSuppressionState:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['AlertProcessingRuleSuppressionConditionArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input['AlertProcessingRuleSuppressionScheduleArgs']] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AlertProcessingRuleSuppression resources.
        :param pulumi.Input['AlertProcessingRuleSuppressionConditionArgs'] condition: A `condition` block as defined below.
        :param pulumi.Input[builtins.str] description: Specifies a description for the Alert Processing Rule.
        :param pulumi.Input[builtins.bool] enabled: Should the Alert Processing Rule be enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Alert Processing Rule. Changing this forces a new Alert Processing Rule to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Alert Processing Rule should exist. Changing this forces a new Alert Processing Rule to be created.
        :param pulumi.Input['AlertProcessingRuleSuppressionScheduleArgs'] schedule: A `schedule` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: A list of resource IDs which will be the target of Alert Processing Rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Alert Processing Rule.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['AlertProcessingRuleSuppressionConditionArgs']]:
        """
        A `condition` block as defined below.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['AlertProcessingRuleSuppressionConditionArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a description for the Alert Processing Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Alert Processing Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Alert Processing Rule. Changing this forces a new Alert Processing Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Alert Processing Rule should exist. Changing this forces a new Alert Processing Rule to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['AlertProcessingRuleSuppressionScheduleArgs']]:
        """
        A `schedule` block as defined below.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['AlertProcessingRuleSuppressionScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of resource IDs which will be the target of Alert Processing Rule.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Alert Processing Rule.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:monitoring/alertProcessingRuleSuppression:AlertProcessingRuleSuppression")
class AlertProcessingRuleSuppression(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[Union['AlertProcessingRuleSuppressionConditionArgs', 'AlertProcessingRuleSuppressionConditionArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['AlertProcessingRuleSuppressionScheduleArgs', 'AlertProcessingRuleSuppressionScheduleArgsDict']]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Alert Processing Rule which suppress notifications.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_alert_processing_rule_suppression = azure.monitoring.AlertProcessingRuleSuppression("example",
            name="example",
            resource_group_name="example",
            scopes=[example.id],
            condition={
                "target_resource_type": {
                    "operator": "Equals",
                    "values": ["Microsoft.Compute/VirtualMachines"],
                },
                "severity": {
                    "operator": "Equals",
                    "values": [
                        "Sev0",
                        "Sev1",
                        "Sev2",
                    ],
                },
            },
            schedule={
                "effective_from": "2022-01-01T01:02:03",
                "effective_until": "2022-02-02T01:02:03",
                "time_zone": "Pacific Standard Time",
                "recurrence": {
                    "dailies": [{
                        "start_time": "17:00:00",
                        "end_time": "09:00:00",
                    }],
                    "weeklies": [{
                        "days_of_weeks": [
                            "Saturday",
                            "Sunday",
                        ],
                    }],
                },
            },
            tags={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AlertsManagement`: 2021-08-08

        ## Import

        Alert Processing Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/alertProcessingRuleSuppression:AlertProcessingRuleSuppression example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.AlertsManagement/actionRules/actionRule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlertProcessingRuleSuppressionConditionArgs', 'AlertProcessingRuleSuppressionConditionArgsDict']] condition: A `condition` block as defined below.
        :param pulumi.Input[builtins.str] description: Specifies a description for the Alert Processing Rule.
        :param pulumi.Input[builtins.bool] enabled: Should the Alert Processing Rule be enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Alert Processing Rule. Changing this forces a new Alert Processing Rule to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Alert Processing Rule should exist. Changing this forces a new Alert Processing Rule to be created.
        :param pulumi.Input[Union['AlertProcessingRuleSuppressionScheduleArgs', 'AlertProcessingRuleSuppressionScheduleArgsDict']] schedule: A `schedule` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: A list of resource IDs which will be the target of Alert Processing Rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Alert Processing Rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertProcessingRuleSuppressionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Alert Processing Rule which suppress notifications.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_alert_processing_rule_suppression = azure.monitoring.AlertProcessingRuleSuppression("example",
            name="example",
            resource_group_name="example",
            scopes=[example.id],
            condition={
                "target_resource_type": {
                    "operator": "Equals",
                    "values": ["Microsoft.Compute/VirtualMachines"],
                },
                "severity": {
                    "operator": "Equals",
                    "values": [
                        "Sev0",
                        "Sev1",
                        "Sev2",
                    ],
                },
            },
            schedule={
                "effective_from": "2022-01-01T01:02:03",
                "effective_until": "2022-02-02T01:02:03",
                "time_zone": "Pacific Standard Time",
                "recurrence": {
                    "dailies": [{
                        "start_time": "17:00:00",
                        "end_time": "09:00:00",
                    }],
                    "weeklies": [{
                        "days_of_weeks": [
                            "Saturday",
                            "Sunday",
                        ],
                    }],
                },
            },
            tags={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AlertsManagement`: 2021-08-08

        ## Import

        Alert Processing Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/alertProcessingRuleSuppression:AlertProcessingRuleSuppression example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.AlertsManagement/actionRules/actionRule1
        ```

        :param str resource_name: The name of the resource.
        :param AlertProcessingRuleSuppressionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertProcessingRuleSuppressionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[Union['AlertProcessingRuleSuppressionConditionArgs', 'AlertProcessingRuleSuppressionConditionArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['AlertProcessingRuleSuppressionScheduleArgs', 'AlertProcessingRuleSuppressionScheduleArgsDict']]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertProcessingRuleSuppressionArgs.__new__(AlertProcessingRuleSuppressionArgs)

            __props__.__dict__["condition"] = condition
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["schedule"] = schedule
            if scopes is None and not opts.urn:
                raise TypeError("Missing required property 'scopes'")
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["tags"] = tags
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure:monitoring/actionRuleSuppression:ActionRuleSuppression")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(AlertProcessingRuleSuppression, __self__).__init__(
            'azure:monitoring/alertProcessingRuleSuppression:AlertProcessingRuleSuppression',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            condition: Optional[pulumi.Input[Union['AlertProcessingRuleSuppressionConditionArgs', 'AlertProcessingRuleSuppressionConditionArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            schedule: Optional[pulumi.Input[Union['AlertProcessingRuleSuppressionScheduleArgs', 'AlertProcessingRuleSuppressionScheduleArgsDict']]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'AlertProcessingRuleSuppression':
        """
        Get an existing AlertProcessingRuleSuppression resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlertProcessingRuleSuppressionConditionArgs', 'AlertProcessingRuleSuppressionConditionArgsDict']] condition: A `condition` block as defined below.
        :param pulumi.Input[builtins.str] description: Specifies a description for the Alert Processing Rule.
        :param pulumi.Input[builtins.bool] enabled: Should the Alert Processing Rule be enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Alert Processing Rule. Changing this forces a new Alert Processing Rule to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Alert Processing Rule should exist. Changing this forces a new Alert Processing Rule to be created.
        :param pulumi.Input[Union['AlertProcessingRuleSuppressionScheduleArgs', 'AlertProcessingRuleSuppressionScheduleArgsDict']] schedule: A `schedule` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: A list of resource IDs which will be the target of Alert Processing Rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Alert Processing Rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertProcessingRuleSuppressionState.__new__(_AlertProcessingRuleSuppressionState)

        __props__.__dict__["condition"] = condition
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["tags"] = tags
        return AlertProcessingRuleSuppression(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional['outputs.AlertProcessingRuleSuppressionCondition']]:
        """
        A `condition` block as defined below.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies a description for the Alert Processing Rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should the Alert Processing Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Alert Processing Rule. Changing this forces a new Alert Processing Rule to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Alert Processing Rule should exist. Changing this forces a new Alert Processing Rule to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.AlertProcessingRuleSuppressionSchedule']]:
        """
        A `schedule` block as defined below.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of resource IDs which will be the target of Alert Processing Rule.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Alert Processing Rule.
        """
        return pulumi.get(self, "tags")

