# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutoscaleSettingArgs', 'AutoscaleSetting']

@pulumi.input_type
class AutoscaleSettingArgs:
    def __init__(__self__, *,
                 profiles: pulumi.Input[Sequence[pulumi.Input['AutoscaleSettingProfileArgs']]],
                 resource_group_name: pulumi.Input[builtins.str],
                 target_resource_id: pulumi.Input[builtins.str],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification: Optional[pulumi.Input['AutoscaleSettingNotificationArgs']] = None,
                 predictive: Optional[pulumi.Input['AutoscaleSettingPredictiveArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a AutoscaleSetting resource.
        :param pulumi.Input[Sequence[pulumi.Input['AutoscaleSettingProfileArgs']]] profiles: Specifies one or more (up to 20) `profile` blocks as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in the AutoScale Setting should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_resource_id: Specifies the resource ID of the resource that the autoscale setting should be added to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] enabled: Specifies whether automatic scaling is enabled for the target resource. Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the AutoScale Setting should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the AutoScale Setting. Changing this forces a new resource to be created.
        :param pulumi.Input['AutoscaleSettingNotificationArgs'] notification: Specifies a `notification` block as defined below.
        :param pulumi.Input['AutoscaleSettingPredictiveArgs'] predictive: A `predictive` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "profiles", profiles)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification is not None:
            pulumi.set(__self__, "notification", notification)
        if predictive is not None:
            pulumi.set(__self__, "predictive", predictive)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def profiles(self) -> pulumi.Input[Sequence[pulumi.Input['AutoscaleSettingProfileArgs']]]:
        """
        Specifies one or more (up to 20) `profile` blocks as defined below.
        """
        return pulumi.get(self, "profiles")

    @profiles.setter
    def profiles(self, value: pulumi.Input[Sequence[pulumi.Input['AutoscaleSettingProfileArgs']]]):
        pulumi.set(self, "profiles", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group in the AutoScale Setting should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the resource ID of the resource that the autoscale setting should be added to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_resource_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether automatic scaling is enabled for the target resource. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the AutoScale Setting should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the AutoScale Setting. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notification(self) -> Optional[pulumi.Input['AutoscaleSettingNotificationArgs']]:
        """
        Specifies a `notification` block as defined below.
        """
        return pulumi.get(self, "notification")

    @notification.setter
    def notification(self, value: Optional[pulumi.Input['AutoscaleSettingNotificationArgs']]):
        pulumi.set(self, "notification", value)

    @property
    @pulumi.getter
    def predictive(self) -> Optional[pulumi.Input['AutoscaleSettingPredictiveArgs']]:
        """
        A `predictive` block as defined below.
        """
        return pulumi.get(self, "predictive")

    @predictive.setter
    def predictive(self, value: Optional[pulumi.Input['AutoscaleSettingPredictiveArgs']]):
        pulumi.set(self, "predictive", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AutoscaleSettingState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification: Optional[pulumi.Input['AutoscaleSettingNotificationArgs']] = None,
                 predictive: Optional[pulumi.Input['AutoscaleSettingPredictiveArgs']] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input['AutoscaleSettingProfileArgs']]]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutoscaleSetting resources.
        :param pulumi.Input[builtins.bool] enabled: Specifies whether automatic scaling is enabled for the target resource. Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the AutoScale Setting should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the AutoScale Setting. Changing this forces a new resource to be created.
        :param pulumi.Input['AutoscaleSettingNotificationArgs'] notification: Specifies a `notification` block as defined below.
        :param pulumi.Input['AutoscaleSettingPredictiveArgs'] predictive: A `predictive` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['AutoscaleSettingProfileArgs']]] profiles: Specifies one or more (up to 20) `profile` blocks as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in the AutoScale Setting should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] target_resource_id: Specifies the resource ID of the resource that the autoscale setting should be added to. Changing this forces a new resource to be created.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification is not None:
            pulumi.set(__self__, "notification", notification)
        if predictive is not None:
            pulumi.set(__self__, "predictive", predictive)
        if profiles is not None:
            pulumi.set(__self__, "profiles", profiles)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether automatic scaling is enabled for the target resource. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the AutoScale Setting should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the AutoScale Setting. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notification(self) -> Optional[pulumi.Input['AutoscaleSettingNotificationArgs']]:
        """
        Specifies a `notification` block as defined below.
        """
        return pulumi.get(self, "notification")

    @notification.setter
    def notification(self, value: Optional[pulumi.Input['AutoscaleSettingNotificationArgs']]):
        pulumi.set(self, "notification", value)

    @property
    @pulumi.getter
    def predictive(self) -> Optional[pulumi.Input['AutoscaleSettingPredictiveArgs']]:
        """
        A `predictive` block as defined below.
        """
        return pulumi.get(self, "predictive")

    @predictive.setter
    def predictive(self, value: Optional[pulumi.Input['AutoscaleSettingPredictiveArgs']]):
        pulumi.set(self, "predictive", value)

    @property
    @pulumi.getter
    def profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutoscaleSettingProfileArgs']]]]:
        """
        Specifies one or more (up to 20) `profile` blocks as defined below.
        """
        return pulumi.get(self, "profiles")

    @profiles.setter
    def profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutoscaleSettingProfileArgs']]]]):
        pulumi.set(self, "profiles", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group in the AutoScale Setting should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the resource ID of the resource that the autoscale setting should be added to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_resource_id", value)


@pulumi.type_token("azure:monitoring/autoscaleSetting:AutoscaleSetting")
class AutoscaleSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification: Optional[pulumi.Input[Union['AutoscaleSettingNotificationArgs', 'AutoscaleSettingNotificationArgsDict']]] = None,
                 predictive: Optional[pulumi.Input[Union['AutoscaleSettingPredictiveArgs', 'AutoscaleSettingPredictiveArgsDict']]] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutoscaleSettingProfileArgs', 'AutoscaleSettingProfileArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a AutoScale Setting which can be applied to Virtual Machine Scale Sets, App Services and other scalable resources.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="autoscalingTest",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctvn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="acctsub",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_linux_virtual_machine_scale_set = azure.compute.LinuxVirtualMachineScaleSet("example",
            name="exampleset",
            location=example.location,
            resource_group_name=example.name,
            upgrade_mode="Manual",
            sku="Standard_F2",
            instances=2,
            admin_username="myadmin",
            admin_ssh_keys=[{
                "username": "myadmin",
                "public_key": "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQDCsTcryUl51Q2VSEHqDRNmceUFo55ZtcIwxl2QITbN1RREti5ml/VTytC0yeBOvnZA4x4CFpdw/lCDPk0yrH9Ei5vVkXmOrExdTlT3qI7YaAzj1tUVlBd4S6LX1F7y6VLActvdHuDDuXZXzCDd/97420jrDfWZqJMlUK/EmCE5ParCeHIRIvmBxcEnGfFIsw8xQZl0HphxWOtJil8qsUWSdMyCiJYYQpMoMliO99X40AUc4/AlsyPyT5ddbKk08YrZ+rKDVHF7o29rh4vi5MmHkVgVQHKiKybWlHq+b71gIAUQk9wrJxD+dqt4igrmDSpIjfjwnd+l5UIn5fJSO5DYV4YT/4hwK7OKmuo7OFHD0WyY5YnkYEMtFgzemnRBdE8ulcT60DQpVgRMXFWHvhyCWy0L6sgj1QWDZlLpvsIvNfHsyhKFMG1frLnMt/nP0+YCcfg+v1JYeCKjeoJxB8DWcRBsjzItY0CGmzP8UYZiYKl/2u+2TgFS5r7NWH11bxoUzjKdaa1NLw+ieA8GlBFfCbfWe6YVB9ggUte4VtYFMZGxOjS2bAiYtfgTKFJv+XqORAwExG6+G2eDxIDyo80/OA9IG7Xv/jwQr7D6KDjDuULFcN/iTxuttoKrHeYz1hf5ZQlBdllwJHYx6fK2g8kha6r2JIQKocvsAXiiONqSfw== hello@world.com",
            }],
            network_interfaces=[{
                "name": "TestNetworkProfile",
                "primary": True,
                "ip_configurations": [{
                    "name": "TestIPConfiguration",
                    "primary": True,
                    "subnet_id": example_subnet.id,
                }],
            }],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "StandardSSD_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_autoscale_setting = azure.monitoring.AutoscaleSetting("example",
            name="myAutoscaleSetting",
            resource_group_name=example.name,
            location=example.location,
            target_resource_id=example_linux_virtual_machine_scale_set.id,
            profiles=[{
                "name": "defaultProfile",
                "capacity": {
                    "default": 1,
                    "minimum": 1,
                    "maximum": 10,
                },
                "rules": [
                    {
                        "metric_trigger": {
                            "metric_name": "Percentage CPU",
                            "metric_resource_id": example_linux_virtual_machine_scale_set.id,
                            "time_grain": "PT1M",
                            "statistic": "Average",
                            "time_window": "PT5M",
                            "time_aggregation": "Average",
                            "operator": "GreaterThan",
                            "threshold": 75,
                            "metric_namespace": "microsoft.compute/virtualmachinescalesets",
                            "dimensions": [{
                                "name": "AppName",
                                "operator": "Equals",
                                "values": ["App1"],
                            }],
                        },
                        "scale_action": {
                            "direction": "Increase",
                            "type": "ChangeCount",
                            "value": 1,
                            "cooldown": "PT1M",
                        },
                    },
                    {
                        "metric_trigger": {
                            "metric_name": "Percentage CPU",
                            "metric_resource_id": example_linux_virtual_machine_scale_set.id,
                            "time_grain": "PT1M",
                            "statistic": "Average",
                            "time_window": "PT5M",
                            "time_aggregation": "Average",
                            "operator": "LessThan",
                            "threshold": 25,
                        },
                        "scale_action": {
                            "direction": "Decrease",
                            "type": "ChangeCount",
                            "value": 1,
                            "cooldown": "PT1M",
                        },
                    },
                ],
            }],
            predictive={
                "scale_mode": "Enabled",
                "look_ahead_time": "PT5M",
            },
            notification={
                "email": {
                    "send_to_subscription_administrator": True,
                    "send_to_subscription_co_administrator": True,
                    "custom_emails": ["admin@contoso.com"],
                },
            })
        ```

        ### Repeating On Weekends)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="autoscalingTest",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctvn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="acctsub",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_linux_virtual_machine_scale_set = azure.compute.LinuxVirtualMachineScaleSet("example",
            name="exampleset",
            location=example.location,
            resource_group_name=example.name,
            upgrade_mode="Manual",
            sku="Standard_F2",
            instances=2,
            admin_username="myadmin",
            admin_ssh_keys=[{
                "username": "myadmin",
                "public_key": "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQDCsTcryUl51Q2VSEHqDRNmceUFo55ZtcIwxl2QITbN1RREti5ml/VTytC0yeBOvnZA4x4CFpdw/lCDPk0yrH9Ei5vVkXmOrExdTlT3qI7YaAzj1tUVlBd4S6LX1F7y6VLActvdHuDDuXZXzCDd/97420jrDfWZqJMlUK/EmCE5ParCeHIRIvmBxcEnGfFIsw8xQZl0HphxWOtJil8qsUWSdMyCiJYYQpMoMliO99X40AUc4/AlsyPyT5ddbKk08YrZ+rKDVHF7o29rh4vi5MmHkVgVQHKiKybWlHq+b71gIAUQk9wrJxD+dqt4igrmDSpIjfjwnd+l5UIn5fJSO5DYV4YT/4hwK7OKmuo7OFHD0WyY5YnkYEMtFgzemnRBdE8ulcT60DQpVgRMXFWHvhyCWy0L6sgj1QWDZlLpvsIvNfHsyhKFMG1frLnMt/nP0+YCcfg+v1JYeCKjeoJxB8DWcRBsjzItY0CGmzP8UYZiYKl/2u+2TgFS5r7NWH11bxoUzjKdaa1NLw+ieA8GlBFfCbfWe6YVB9ggUte4VtYFMZGxOjS2bAiYtfgTKFJv+XqORAwExG6+G2eDxIDyo80/OA9IG7Xv/jwQr7D6KDjDuULFcN/iTxuttoKrHeYz1hf5ZQlBdllwJHYx6fK2g8kha6r2JIQKocvsAXiiONqSfw== hello@world.com",
            }],
            network_interfaces=[{
                "name": "TestNetworkProfile",
                "primary": True,
                "ip_configurations": [{
                    "name": "TestIPConfiguration",
                    "primary": True,
                    "subnet_id": example_subnet.id,
                }],
            }],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "StandardSSD_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_autoscale_setting = azure.monitoring.AutoscaleSetting("example",
            name="myAutoscaleSetting",
            resource_group_name=example.name,
            location=example.location,
            target_resource_id=example_linux_virtual_machine_scale_set.id,
            profiles=[{
                "name": "Weekends",
                "capacity": {
                    "default": 1,
                    "minimum": 1,
                    "maximum": 10,
                },
                "rules": [
                    {
                        "metric_trigger": {
                            "metric_name": "Percentage CPU",
                            "metric_resource_id": example_linux_virtual_machine_scale_set.id,
                            "time_grain": "PT1M",
                            "statistic": "Average",
                            "time_window": "PT5M",
                            "time_aggregation": "Average",
                            "operator": "GreaterThan",
                            "threshold": 90,
                        },
                        "scale_action": {
                            "direction": "Increase",
                            "type": "ChangeCount",
                            "value": 2,
                            "cooldown": "PT1M",
                        },
                    },
                    {
                        "metric_trigger": {
                            "metric_name": "Percentage CPU",
                            "metric_resource_id": example_linux_virtual_machine_scale_set.id,
                            "time_grain": "PT1M",
                            "statistic": "Average",
                            "time_window": "PT5M",
                            "time_aggregation": "Average",
                            "operator": "LessThan",
                            "threshold": 10,
                        },
                        "scale_action": {
                            "direction": "Decrease",
                            "type": "ChangeCount",
                            "value": 2,
                            "cooldown": "PT1M",
                        },
                    },
                ],
                "recurrence": {
                    "timezone": "Pacific Standard Time",
                    "days": [
                        "Saturday",
                        "Sunday",
                    ],
                    "hours": 12,
                    "minutes": 0,
                },
            }],
            notification={
                "email": {
                    "send_to_subscription_administrator": True,
                    "send_to_subscription_co_administrator": True,
                    "custom_emails": ["admin@contoso.com"],
                },
            })
        ```

        ### For Fixed Dates)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="autoscalingTest",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctvn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="acctsub",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_linux_virtual_machine_scale_set = azure.compute.LinuxVirtualMachineScaleSet("example",
            name="exampleset",
            location=example.location,
            resource_group_name=example.name,
            upgrade_mode="Manual",
            sku="Standard_F2",
            instances=2,
            admin_username="myadmin",
            admin_ssh_keys=[{
                "username": "myadmin",
                "public_key": "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQDCsTcryUl51Q2VSEHqDRNmceUFo55ZtcIwxl2QITbN1RREti5ml/VTytC0yeBOvnZA4x4CFpdw/lCDPk0yrH9Ei5vVkXmOrExdTlT3qI7YaAzj1tUVlBd4S6LX1F7y6VLActvdHuDDuXZXzCDd/97420jrDfWZqJMlUK/EmCE5ParCeHIRIvmBxcEnGfFIsw8xQZl0HphxWOtJil8qsUWSdMyCiJYYQpMoMliO99X40AUc4/AlsyPyT5ddbKk08YrZ+rKDVHF7o29rh4vi5MmHkVgVQHKiKybWlHq+b71gIAUQk9wrJxD+dqt4igrmDSpIjfjwnd+l5UIn5fJSO5DYV4YT/4hwK7OKmuo7OFHD0WyY5YnkYEMtFgzemnRBdE8ulcT60DQpVgRMXFWHvhyCWy0L6sgj1QWDZlLpvsIvNfHsyhKFMG1frLnMt/nP0+YCcfg+v1JYeCKjeoJxB8DWcRBsjzItY0CGmzP8UYZiYKl/2u+2TgFS5r7NWH11bxoUzjKdaa1NLw+ieA8GlBFfCbfWe6YVB9ggUte4VtYFMZGxOjS2bAiYtfgTKFJv+XqORAwExG6+G2eDxIDyo80/OA9IG7Xv/jwQr7D6KDjDuULFcN/iTxuttoKrHeYz1hf5ZQlBdllwJHYx6fK2g8kha6r2JIQKocvsAXiiONqSfw== hello@world.com",
            }],
            network_interfaces=[{
                "name": "TestNetworkProfile",
                "primary": True,
                "ip_configurations": [{
                    "name": "TestIPConfiguration",
                    "primary": True,
                    "subnet_id": example_subnet.id,
                }],
            }],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "StandardSSD_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_autoscale_setting = azure.monitoring.AutoscaleSetting("example",
            name="myAutoscaleSetting",
            enabled=True,
            resource_group_name=example.name,
            location=example.location,
            target_resource_id=example_linux_virtual_machine_scale_set.id,
            profiles=[{
                "name": "forJuly",
                "capacity": {
                    "default": 1,
                    "minimum": 1,
                    "maximum": 10,
                },
                "rules": [
                    {
                        "metric_trigger": {
                            "metric_name": "Percentage CPU",
                            "metric_resource_id": example_linux_virtual_machine_scale_set.id,
                            "time_grain": "PT1M",
                            "statistic": "Average",
                            "time_window": "PT5M",
                            "time_aggregation": "Average",
                            "operator": "GreaterThan",
                            "threshold": 90,
                        },
                        "scale_action": {
                            "direction": "Increase",
                            "type": "ChangeCount",
                            "value": 2,
                            "cooldown": "PT1M",
                        },
                    },
                    {
                        "metric_trigger": {
                            "metric_name": "Percentage CPU",
                            "metric_resource_id": example_linux_virtual_machine_scale_set.id,
                            "time_grain": "PT1M",
                            "statistic": "Average",
                            "time_window": "PT5M",
                            "time_aggregation": "Average",
                            "operator": "LessThan",
                            "threshold": 10,
                        },
                        "scale_action": {
                            "direction": "Decrease",
                            "type": "ChangeCount",
                            "value": 2,
                            "cooldown": "PT1M",
                        },
                    },
                ],
                "fixed_date": {
                    "timezone": "Pacific Standard Time",
                    "start": "2020-07-01T00:00:00Z",
                    "end": "2020-07-31T23:59:59Z",
                },
            }],
            notification={
                "email": {
                    "send_to_subscription_administrator": True,
                    "send_to_subscription_co_administrator": True,
                    "custom_emails": ["admin@contoso.com"],
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights`: 2022-10-01

        ## Import

        AutoScale Setting can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/autoscaleSetting:AutoscaleSetting example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Insights/autoScaleSettings/setting1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Specifies whether automatic scaling is enabled for the target resource. Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the AutoScale Setting should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the AutoScale Setting. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AutoscaleSettingNotificationArgs', 'AutoscaleSettingNotificationArgsDict']] notification: Specifies a `notification` block as defined below.
        :param pulumi.Input[Union['AutoscaleSettingPredictiveArgs', 'AutoscaleSettingPredictiveArgsDict']] predictive: A `predictive` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutoscaleSettingProfileArgs', 'AutoscaleSettingProfileArgsDict']]]] profiles: Specifies one or more (up to 20) `profile` blocks as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in the AutoScale Setting should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] target_resource_id: Specifies the resource ID of the resource that the autoscale setting should be added to. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutoscaleSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a AutoScale Setting which can be applied to Virtual Machine Scale Sets, App Services and other scalable resources.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="autoscalingTest",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctvn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="acctsub",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_linux_virtual_machine_scale_set = azure.compute.LinuxVirtualMachineScaleSet("example",
            name="exampleset",
            location=example.location,
            resource_group_name=example.name,
            upgrade_mode="Manual",
            sku="Standard_F2",
            instances=2,
            admin_username="myadmin",
            admin_ssh_keys=[{
                "username": "myadmin",
                "public_key": "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQDCsTcryUl51Q2VSEHqDRNmceUFo55ZtcIwxl2QITbN1RREti5ml/VTytC0yeBOvnZA4x4CFpdw/lCDPk0yrH9Ei5vVkXmOrExdTlT3qI7YaAzj1tUVlBd4S6LX1F7y6VLActvdHuDDuXZXzCDd/97420jrDfWZqJMlUK/EmCE5ParCeHIRIvmBxcEnGfFIsw8xQZl0HphxWOtJil8qsUWSdMyCiJYYQpMoMliO99X40AUc4/AlsyPyT5ddbKk08YrZ+rKDVHF7o29rh4vi5MmHkVgVQHKiKybWlHq+b71gIAUQk9wrJxD+dqt4igrmDSpIjfjwnd+l5UIn5fJSO5DYV4YT/4hwK7OKmuo7OFHD0WyY5YnkYEMtFgzemnRBdE8ulcT60DQpVgRMXFWHvhyCWy0L6sgj1QWDZlLpvsIvNfHsyhKFMG1frLnMt/nP0+YCcfg+v1JYeCKjeoJxB8DWcRBsjzItY0CGmzP8UYZiYKl/2u+2TgFS5r7NWH11bxoUzjKdaa1NLw+ieA8GlBFfCbfWe6YVB9ggUte4VtYFMZGxOjS2bAiYtfgTKFJv+XqORAwExG6+G2eDxIDyo80/OA9IG7Xv/jwQr7D6KDjDuULFcN/iTxuttoKrHeYz1hf5ZQlBdllwJHYx6fK2g8kha6r2JIQKocvsAXiiONqSfw== hello@world.com",
            }],
            network_interfaces=[{
                "name": "TestNetworkProfile",
                "primary": True,
                "ip_configurations": [{
                    "name": "TestIPConfiguration",
                    "primary": True,
                    "subnet_id": example_subnet.id,
                }],
            }],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "StandardSSD_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_autoscale_setting = azure.monitoring.AutoscaleSetting("example",
            name="myAutoscaleSetting",
            resource_group_name=example.name,
            location=example.location,
            target_resource_id=example_linux_virtual_machine_scale_set.id,
            profiles=[{
                "name": "defaultProfile",
                "capacity": {
                    "default": 1,
                    "minimum": 1,
                    "maximum": 10,
                },
                "rules": [
                    {
                        "metric_trigger": {
                            "metric_name": "Percentage CPU",
                            "metric_resource_id": example_linux_virtual_machine_scale_set.id,
                            "time_grain": "PT1M",
                            "statistic": "Average",
                            "time_window": "PT5M",
                            "time_aggregation": "Average",
                            "operator": "GreaterThan",
                            "threshold": 75,
                            "metric_namespace": "microsoft.compute/virtualmachinescalesets",
                            "dimensions": [{
                                "name": "AppName",
                                "operator": "Equals",
                                "values": ["App1"],
                            }],
                        },
                        "scale_action": {
                            "direction": "Increase",
                            "type": "ChangeCount",
                            "value": 1,
                            "cooldown": "PT1M",
                        },
                    },
                    {
                        "metric_trigger": {
                            "metric_name": "Percentage CPU",
                            "metric_resource_id": example_linux_virtual_machine_scale_set.id,
                            "time_grain": "PT1M",
                            "statistic": "Average",
                            "time_window": "PT5M",
                            "time_aggregation": "Average",
                            "operator": "LessThan",
                            "threshold": 25,
                        },
                        "scale_action": {
                            "direction": "Decrease",
                            "type": "ChangeCount",
                            "value": 1,
                            "cooldown": "PT1M",
                        },
                    },
                ],
            }],
            predictive={
                "scale_mode": "Enabled",
                "look_ahead_time": "PT5M",
            },
            notification={
                "email": {
                    "send_to_subscription_administrator": True,
                    "send_to_subscription_co_administrator": True,
                    "custom_emails": ["admin@contoso.com"],
                },
            })
        ```

        ### Repeating On Weekends)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="autoscalingTest",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctvn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="acctsub",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_linux_virtual_machine_scale_set = azure.compute.LinuxVirtualMachineScaleSet("example",
            name="exampleset",
            location=example.location,
            resource_group_name=example.name,
            upgrade_mode="Manual",
            sku="Standard_F2",
            instances=2,
            admin_username="myadmin",
            admin_ssh_keys=[{
                "username": "myadmin",
                "public_key": "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQDCsTcryUl51Q2VSEHqDRNmceUFo55ZtcIwxl2QITbN1RREti5ml/VTytC0yeBOvnZA4x4CFpdw/lCDPk0yrH9Ei5vVkXmOrExdTlT3qI7YaAzj1tUVlBd4S6LX1F7y6VLActvdHuDDuXZXzCDd/97420jrDfWZqJMlUK/EmCE5ParCeHIRIvmBxcEnGfFIsw8xQZl0HphxWOtJil8qsUWSdMyCiJYYQpMoMliO99X40AUc4/AlsyPyT5ddbKk08YrZ+rKDVHF7o29rh4vi5MmHkVgVQHKiKybWlHq+b71gIAUQk9wrJxD+dqt4igrmDSpIjfjwnd+l5UIn5fJSO5DYV4YT/4hwK7OKmuo7OFHD0WyY5YnkYEMtFgzemnRBdE8ulcT60DQpVgRMXFWHvhyCWy0L6sgj1QWDZlLpvsIvNfHsyhKFMG1frLnMt/nP0+YCcfg+v1JYeCKjeoJxB8DWcRBsjzItY0CGmzP8UYZiYKl/2u+2TgFS5r7NWH11bxoUzjKdaa1NLw+ieA8GlBFfCbfWe6YVB9ggUte4VtYFMZGxOjS2bAiYtfgTKFJv+XqORAwExG6+G2eDxIDyo80/OA9IG7Xv/jwQr7D6KDjDuULFcN/iTxuttoKrHeYz1hf5ZQlBdllwJHYx6fK2g8kha6r2JIQKocvsAXiiONqSfw== hello@world.com",
            }],
            network_interfaces=[{
                "name": "TestNetworkProfile",
                "primary": True,
                "ip_configurations": [{
                    "name": "TestIPConfiguration",
                    "primary": True,
                    "subnet_id": example_subnet.id,
                }],
            }],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "StandardSSD_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_autoscale_setting = azure.monitoring.AutoscaleSetting("example",
            name="myAutoscaleSetting",
            resource_group_name=example.name,
            location=example.location,
            target_resource_id=example_linux_virtual_machine_scale_set.id,
            profiles=[{
                "name": "Weekends",
                "capacity": {
                    "default": 1,
                    "minimum": 1,
                    "maximum": 10,
                },
                "rules": [
                    {
                        "metric_trigger": {
                            "metric_name": "Percentage CPU",
                            "metric_resource_id": example_linux_virtual_machine_scale_set.id,
                            "time_grain": "PT1M",
                            "statistic": "Average",
                            "time_window": "PT5M",
                            "time_aggregation": "Average",
                            "operator": "GreaterThan",
                            "threshold": 90,
                        },
                        "scale_action": {
                            "direction": "Increase",
                            "type": "ChangeCount",
                            "value": 2,
                            "cooldown": "PT1M",
                        },
                    },
                    {
                        "metric_trigger": {
                            "metric_name": "Percentage CPU",
                            "metric_resource_id": example_linux_virtual_machine_scale_set.id,
                            "time_grain": "PT1M",
                            "statistic": "Average",
                            "time_window": "PT5M",
                            "time_aggregation": "Average",
                            "operator": "LessThan",
                            "threshold": 10,
                        },
                        "scale_action": {
                            "direction": "Decrease",
                            "type": "ChangeCount",
                            "value": 2,
                            "cooldown": "PT1M",
                        },
                    },
                ],
                "recurrence": {
                    "timezone": "Pacific Standard Time",
                    "days": [
                        "Saturday",
                        "Sunday",
                    ],
                    "hours": 12,
                    "minutes": 0,
                },
            }],
            notification={
                "email": {
                    "send_to_subscription_administrator": True,
                    "send_to_subscription_co_administrator": True,
                    "custom_emails": ["admin@contoso.com"],
                },
            })
        ```

        ### For Fixed Dates)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="autoscalingTest",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctvn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="acctsub",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_linux_virtual_machine_scale_set = azure.compute.LinuxVirtualMachineScaleSet("example",
            name="exampleset",
            location=example.location,
            resource_group_name=example.name,
            upgrade_mode="Manual",
            sku="Standard_F2",
            instances=2,
            admin_username="myadmin",
            admin_ssh_keys=[{
                "username": "myadmin",
                "public_key": "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQDCsTcryUl51Q2VSEHqDRNmceUFo55ZtcIwxl2QITbN1RREti5ml/VTytC0yeBOvnZA4x4CFpdw/lCDPk0yrH9Ei5vVkXmOrExdTlT3qI7YaAzj1tUVlBd4S6LX1F7y6VLActvdHuDDuXZXzCDd/97420jrDfWZqJMlUK/EmCE5ParCeHIRIvmBxcEnGfFIsw8xQZl0HphxWOtJil8qsUWSdMyCiJYYQpMoMliO99X40AUc4/AlsyPyT5ddbKk08YrZ+rKDVHF7o29rh4vi5MmHkVgVQHKiKybWlHq+b71gIAUQk9wrJxD+dqt4igrmDSpIjfjwnd+l5UIn5fJSO5DYV4YT/4hwK7OKmuo7OFHD0WyY5YnkYEMtFgzemnRBdE8ulcT60DQpVgRMXFWHvhyCWy0L6sgj1QWDZlLpvsIvNfHsyhKFMG1frLnMt/nP0+YCcfg+v1JYeCKjeoJxB8DWcRBsjzItY0CGmzP8UYZiYKl/2u+2TgFS5r7NWH11bxoUzjKdaa1NLw+ieA8GlBFfCbfWe6YVB9ggUte4VtYFMZGxOjS2bAiYtfgTKFJv+XqORAwExG6+G2eDxIDyo80/OA9IG7Xv/jwQr7D6KDjDuULFcN/iTxuttoKrHeYz1hf5ZQlBdllwJHYx6fK2g8kha6r2JIQKocvsAXiiONqSfw== hello@world.com",
            }],
            network_interfaces=[{
                "name": "TestNetworkProfile",
                "primary": True,
                "ip_configurations": [{
                    "name": "TestIPConfiguration",
                    "primary": True,
                    "subnet_id": example_subnet.id,
                }],
            }],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "StandardSSD_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_autoscale_setting = azure.monitoring.AutoscaleSetting("example",
            name="myAutoscaleSetting",
            enabled=True,
            resource_group_name=example.name,
            location=example.location,
            target_resource_id=example_linux_virtual_machine_scale_set.id,
            profiles=[{
                "name": "forJuly",
                "capacity": {
                    "default": 1,
                    "minimum": 1,
                    "maximum": 10,
                },
                "rules": [
                    {
                        "metric_trigger": {
                            "metric_name": "Percentage CPU",
                            "metric_resource_id": example_linux_virtual_machine_scale_set.id,
                            "time_grain": "PT1M",
                            "statistic": "Average",
                            "time_window": "PT5M",
                            "time_aggregation": "Average",
                            "operator": "GreaterThan",
                            "threshold": 90,
                        },
                        "scale_action": {
                            "direction": "Increase",
                            "type": "ChangeCount",
                            "value": 2,
                            "cooldown": "PT1M",
                        },
                    },
                    {
                        "metric_trigger": {
                            "metric_name": "Percentage CPU",
                            "metric_resource_id": example_linux_virtual_machine_scale_set.id,
                            "time_grain": "PT1M",
                            "statistic": "Average",
                            "time_window": "PT5M",
                            "time_aggregation": "Average",
                            "operator": "LessThan",
                            "threshold": 10,
                        },
                        "scale_action": {
                            "direction": "Decrease",
                            "type": "ChangeCount",
                            "value": 2,
                            "cooldown": "PT1M",
                        },
                    },
                ],
                "fixed_date": {
                    "timezone": "Pacific Standard Time",
                    "start": "2020-07-01T00:00:00Z",
                    "end": "2020-07-31T23:59:59Z",
                },
            }],
            notification={
                "email": {
                    "send_to_subscription_administrator": True,
                    "send_to_subscription_co_administrator": True,
                    "custom_emails": ["admin@contoso.com"],
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights`: 2022-10-01

        ## Import

        AutoScale Setting can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/autoscaleSetting:AutoscaleSetting example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Insights/autoScaleSettings/setting1
        ```

        :param str resource_name: The name of the resource.
        :param AutoscaleSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutoscaleSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification: Optional[pulumi.Input[Union['AutoscaleSettingNotificationArgs', 'AutoscaleSettingNotificationArgsDict']]] = None,
                 predictive: Optional[pulumi.Input[Union['AutoscaleSettingPredictiveArgs', 'AutoscaleSettingPredictiveArgsDict']]] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutoscaleSettingProfileArgs', 'AutoscaleSettingProfileArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutoscaleSettingArgs.__new__(AutoscaleSettingArgs)

            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["notification"] = notification
            __props__.__dict__["predictive"] = predictive
            if profiles is None and not opts.urn:
                raise TypeError("Missing required property 'profiles'")
            __props__.__dict__["profiles"] = profiles
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
        super(AutoscaleSetting, __self__).__init__(
            'azure:monitoring/autoscaleSetting:AutoscaleSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            notification: Optional[pulumi.Input[Union['AutoscaleSettingNotificationArgs', 'AutoscaleSettingNotificationArgsDict']]] = None,
            predictive: Optional[pulumi.Input[Union['AutoscaleSettingPredictiveArgs', 'AutoscaleSettingPredictiveArgsDict']]] = None,
            profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutoscaleSettingProfileArgs', 'AutoscaleSettingProfileArgsDict']]]]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target_resource_id: Optional[pulumi.Input[builtins.str]] = None) -> 'AutoscaleSetting':
        """
        Get an existing AutoscaleSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Specifies whether automatic scaling is enabled for the target resource. Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the AutoScale Setting should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the AutoScale Setting. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AutoscaleSettingNotificationArgs', 'AutoscaleSettingNotificationArgsDict']] notification: Specifies a `notification` block as defined below.
        :param pulumi.Input[Union['AutoscaleSettingPredictiveArgs', 'AutoscaleSettingPredictiveArgsDict']] predictive: A `predictive` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutoscaleSettingProfileArgs', 'AutoscaleSettingProfileArgsDict']]]] profiles: Specifies one or more (up to 20) `profile` blocks as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group in the AutoScale Setting should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] target_resource_id: Specifies the resource ID of the resource that the autoscale setting should be added to. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutoscaleSettingState.__new__(_AutoscaleSettingState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["notification"] = notification
        __props__.__dict__["predictive"] = predictive
        __props__.__dict__["profiles"] = profiles
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_resource_id"] = target_resource_id
        return AutoscaleSetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether automatic scaling is enabled for the target resource. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the AutoScale Setting should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the AutoScale Setting. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notification(self) -> pulumi.Output[Optional['outputs.AutoscaleSettingNotification']]:
        """
        Specifies a `notification` block as defined below.
        """
        return pulumi.get(self, "notification")

    @property
    @pulumi.getter
    def predictive(self) -> pulumi.Output[Optional['outputs.AutoscaleSettingPredictive']]:
        """
        A `predictive` block as defined below.
        """
        return pulumi.get(self, "predictive")

    @property
    @pulumi.getter
    def profiles(self) -> pulumi.Output[Sequence['outputs.AutoscaleSettingProfile']]:
        """
        Specifies one or more (up to 20) `profile` blocks as defined below.
        """
        return pulumi.get(self, "profiles")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group in the AutoScale Setting should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the resource ID of the resource that the autoscale setting should be added to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_id")

