# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDataCollectionEndpointResult',
    'AwaitableGetDataCollectionEndpointResult',
    'get_data_collection_endpoint',
    'get_data_collection_endpoint_output',
]

@pulumi.output_type
class GetDataCollectionEndpointResult:
    """
    A collection of values returned by getDataCollectionEndpoint.
    """
    def __init__(__self__, configuration_access_endpoint=None, description=None, id=None, immutable_id=None, kind=None, location=None, logs_ingestion_endpoint=None, metrics_ingestion_endpoint=None, name=None, public_network_access_enabled=None, resource_group_name=None, tags=None):
        if configuration_access_endpoint and not isinstance(configuration_access_endpoint, str):
            raise TypeError("Expected argument 'configuration_access_endpoint' to be a str")
        pulumi.set(__self__, "configuration_access_endpoint", configuration_access_endpoint)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if immutable_id and not isinstance(immutable_id, str):
            raise TypeError("Expected argument 'immutable_id' to be a str")
        pulumi.set(__self__, "immutable_id", immutable_id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if logs_ingestion_endpoint and not isinstance(logs_ingestion_endpoint, str):
            raise TypeError("Expected argument 'logs_ingestion_endpoint' to be a str")
        pulumi.set(__self__, "logs_ingestion_endpoint", logs_ingestion_endpoint)
        if metrics_ingestion_endpoint and not isinstance(metrics_ingestion_endpoint, str):
            raise TypeError("Expected argument 'metrics_ingestion_endpoint' to be a str")
        pulumi.set(__self__, "metrics_ingestion_endpoint", metrics_ingestion_endpoint)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_network_access_enabled and not isinstance(public_network_access_enabled, bool):
            raise TypeError("Expected argument 'public_network_access_enabled' to be a bool")
        pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="configurationAccessEndpoint")
    def configuration_access_endpoint(self) -> builtins.str:
        """
        The endpoint used for accessing configuration, e.g., `https://mydce-abcd.eastus-1.control.monitor.azure.com`.
        """
        return pulumi.get(self, "configuration_access_endpoint")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Specifies a description for the Data Collection Endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="immutableId")
    def immutable_id(self) -> builtins.str:
        """
        The immutable ID of the Data Collection Endpoint.
        """
        return pulumi.get(self, "immutable_id")

    @property
    @pulumi.getter
    def kind(self) -> builtins.str:
        """
        The kind of the Data Collection Endpoint. Possible values are `Linux` and `Windows`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure Region where the Data Collection Endpoint should exist.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="logsIngestionEndpoint")
    def logs_ingestion_endpoint(self) -> builtins.str:
        """
        The endpoint used for ingesting logs, e.g., `https://mydce-abcd.eastus-1.ingest.monitor.azure.com`.
        """
        return pulumi.get(self, "logs_ingestion_endpoint")

    @property
    @pulumi.getter(name="metricsIngestionEndpoint")
    def metrics_ingestion_endpoint(self) -> builtins.str:
        """
        The endpoint used for ingesting metrics, e.g., `https://mydce-abcd.eastus-1.metrics.ingest.monitor.azure.com`.
        """
        return pulumi.get(self, "metrics_ingestion_endpoint")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> builtins.bool:
        """
        Whether network access from public internet to the Data Collection Endpoint are allowed. Possible values are `true` and `false`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags which should be assigned to the Data Collection Endpoint.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDataCollectionEndpointResult(GetDataCollectionEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataCollectionEndpointResult(
            configuration_access_endpoint=self.configuration_access_endpoint,
            description=self.description,
            id=self.id,
            immutable_id=self.immutable_id,
            kind=self.kind,
            location=self.location,
            logs_ingestion_endpoint=self.logs_ingestion_endpoint,
            metrics_ingestion_endpoint=self.metrics_ingestion_endpoint,
            name=self.name,
            public_network_access_enabled=self.public_network_access_enabled,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_data_collection_endpoint(name: Optional[builtins.str] = None,
                                 resource_group_name: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataCollectionEndpointResult:
    """
    Use this data source to access information about an existing Data Collection Endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.monitoring.get_data_collection_endpoint(name="example-mdce",
        resource_group_name=example_azurerm_resource_group["name"])
    pulumi.export("endpointId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Insights`: 2023-03-11


    :param builtins.str name: Specifies the name of the Data Collection Endpoint.
    :param builtins.str resource_group_name: Specifies the name of the resource group the Data Collection Endpoint is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:monitoring/getDataCollectionEndpoint:getDataCollectionEndpoint', __args__, opts=opts, typ=GetDataCollectionEndpointResult).value

    return AwaitableGetDataCollectionEndpointResult(
        configuration_access_endpoint=pulumi.get(__ret__, 'configuration_access_endpoint'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        immutable_id=pulumi.get(__ret__, 'immutable_id'),
        kind=pulumi.get(__ret__, 'kind'),
        location=pulumi.get(__ret__, 'location'),
        logs_ingestion_endpoint=pulumi.get(__ret__, 'logs_ingestion_endpoint'),
        metrics_ingestion_endpoint=pulumi.get(__ret__, 'metrics_ingestion_endpoint'),
        name=pulumi.get(__ret__, 'name'),
        public_network_access_enabled=pulumi.get(__ret__, 'public_network_access_enabled'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_data_collection_endpoint_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                        resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataCollectionEndpointResult]:
    """
    Use this data source to access information about an existing Data Collection Endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.monitoring.get_data_collection_endpoint(name="example-mdce",
        resource_group_name=example_azurerm_resource_group["name"])
    pulumi.export("endpointId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Insights`: 2023-03-11


    :param builtins.str name: Specifies the name of the Data Collection Endpoint.
    :param builtins.str resource_group_name: Specifies the name of the resource group the Data Collection Endpoint is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:monitoring/getDataCollectionEndpoint:getDataCollectionEndpoint', __args__, opts=opts, typ=GetDataCollectionEndpointResult)
    return __ret__.apply(lambda __response__: GetDataCollectionEndpointResult(
        configuration_access_endpoint=pulumi.get(__response__, 'configuration_access_endpoint'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        immutable_id=pulumi.get(__response__, 'immutable_id'),
        kind=pulumi.get(__response__, 'kind'),
        location=pulumi.get(__response__, 'location'),
        logs_ingestion_endpoint=pulumi.get(__response__, 'logs_ingestion_endpoint'),
        metrics_ingestion_endpoint=pulumi.get(__response__, 'metrics_ingestion_endpoint'),
        name=pulumi.get(__response__, 'name'),
        public_network_access_enabled=pulumi.get(__response__, 'public_network_access_enabled'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
