# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDataCollectionRuleResult',
    'AwaitableGetDataCollectionRuleResult',
    'get_data_collection_rule',
    'get_data_collection_rule_output',
]

@pulumi.output_type
class GetDataCollectionRuleResult:
    """
    A collection of values returned by getDataCollectionRule.
    """
    def __init__(__self__, data_collection_endpoint_id=None, data_flows=None, data_sources=None, description=None, destinations=None, id=None, identities=None, immutable_id=None, kind=None, location=None, name=None, resource_group_name=None, stream_declarations=None, tags=None):
        if data_collection_endpoint_id and not isinstance(data_collection_endpoint_id, str):
            raise TypeError("Expected argument 'data_collection_endpoint_id' to be a str")
        pulumi.set(__self__, "data_collection_endpoint_id", data_collection_endpoint_id)
        if data_flows and not isinstance(data_flows, list):
            raise TypeError("Expected argument 'data_flows' to be a list")
        pulumi.set(__self__, "data_flows", data_flows)
        if data_sources and not isinstance(data_sources, list):
            raise TypeError("Expected argument 'data_sources' to be a list")
        pulumi.set(__self__, "data_sources", data_sources)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if destinations and not isinstance(destinations, list):
            raise TypeError("Expected argument 'destinations' to be a list")
        pulumi.set(__self__, "destinations", destinations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if immutable_id and not isinstance(immutable_id, str):
            raise TypeError("Expected argument 'immutable_id' to be a str")
        pulumi.set(__self__, "immutable_id", immutable_id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if stream_declarations and not isinstance(stream_declarations, list):
            raise TypeError("Expected argument 'stream_declarations' to be a list")
        pulumi.set(__self__, "stream_declarations", stream_declarations)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataCollectionEndpointId")
    def data_collection_endpoint_id(self) -> builtins.str:
        """
        The resource ID of the Data Collection Endpoint that this rule can be used with.
        """
        return pulumi.get(self, "data_collection_endpoint_id")

    @property
    @pulumi.getter(name="dataFlows")
    def data_flows(self) -> Sequence['outputs.GetDataCollectionRuleDataFlowResult']:
        """
        One or more `data_flow` blocks as defined below.
        """
        return pulumi.get(self, "data_flows")

    @property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> Sequence['outputs.GetDataCollectionRuleDataSourceResult']:
        """
        A `data_sources` block as defined below. This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        """
        return pulumi.get(self, "data_sources")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the Data Collection Rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.GetDataCollectionRuleDestinationResult']:
        """
        Specifies a list of destination names. A `azure_monitor_metrics` data source only allows for stream of kind `Microsoft-InsightsMetrics`.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetDataCollectionRuleIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="immutableId")
    def immutable_id(self) -> builtins.str:
        return pulumi.get(self, "immutable_id")

    @property
    @pulumi.getter
    def kind(self) -> builtins.str:
        """
        The kind of the Data Collection Rule. Possible values are `Linux`, `Windows`,and `AgentDirectToStore`. A rule of kind `Linux` does not allow for `windows_event_log` data sources. And a rule of kind `Windows` does not allow for `syslog` data sources. If kind is not specified, all kinds of data sources are allowed.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure Region where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name which should be used for this data source. This name should be unique across all data sources regardless of type within the Data Collection Rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="streamDeclarations")
    def stream_declarations(self) -> Sequence['outputs.GetDataCollectionRuleStreamDeclarationResult']:
        """
        A `stream_declaration` block as defined below.
        """
        return pulumi.get(self, "stream_declarations")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags which should be assigned to the Data Collection Rule.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDataCollectionRuleResult(GetDataCollectionRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataCollectionRuleResult(
            data_collection_endpoint_id=self.data_collection_endpoint_id,
            data_flows=self.data_flows,
            data_sources=self.data_sources,
            description=self.description,
            destinations=self.destinations,
            id=self.id,
            identities=self.identities,
            immutable_id=self.immutable_id,
            kind=self.kind,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            stream_declarations=self.stream_declarations,
            tags=self.tags)


def get_data_collection_rule(name: Optional[builtins.str] = None,
                             resource_group_name: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataCollectionRuleResult:
    """
    Use this data source to access information about an existing Data Collection Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.monitoring.get_data_collection_rule(name="example-rule",
        resource_group_name=example_azurerm_resource_group["name"])
    pulumi.export("ruleId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Insights`: 2023-03-11


    :param builtins.str name: Specifies the name of the Data Collection Rule.
    :param builtins.str resource_group_name: Specifies the name of the resource group the Data Collection Rule is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:monitoring/getDataCollectionRule:getDataCollectionRule', __args__, opts=opts, typ=GetDataCollectionRuleResult).value

    return AwaitableGetDataCollectionRuleResult(
        data_collection_endpoint_id=pulumi.get(__ret__, 'data_collection_endpoint_id'),
        data_flows=pulumi.get(__ret__, 'data_flows'),
        data_sources=pulumi.get(__ret__, 'data_sources'),
        description=pulumi.get(__ret__, 'description'),
        destinations=pulumi.get(__ret__, 'destinations'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        immutable_id=pulumi.get(__ret__, 'immutable_id'),
        kind=pulumi.get(__ret__, 'kind'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        stream_declarations=pulumi.get(__ret__, 'stream_declarations'),
        tags=pulumi.get(__ret__, 'tags'))
def get_data_collection_rule_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                    resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataCollectionRuleResult]:
    """
    Use this data source to access information about an existing Data Collection Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.monitoring.get_data_collection_rule(name="example-rule",
        resource_group_name=example_azurerm_resource_group["name"])
    pulumi.export("ruleId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Insights`: 2023-03-11


    :param builtins.str name: Specifies the name of the Data Collection Rule.
    :param builtins.str resource_group_name: Specifies the name of the resource group the Data Collection Rule is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:monitoring/getDataCollectionRule:getDataCollectionRule', __args__, opts=opts, typ=GetDataCollectionRuleResult)
    return __ret__.apply(lambda __response__: GetDataCollectionRuleResult(
        data_collection_endpoint_id=pulumi.get(__response__, 'data_collection_endpoint_id'),
        data_flows=pulumi.get(__response__, 'data_flows'),
        data_sources=pulumi.get(__response__, 'data_sources'),
        description=pulumi.get(__response__, 'description'),
        destinations=pulumi.get(__response__, 'destinations'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        immutable_id=pulumi.get(__response__, 'immutable_id'),
        kind=pulumi.get(__response__, 'kind'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        stream_declarations=pulumi.get(__response__, 'stream_declarations'),
        tags=pulumi.get(__response__, 'tags')))
