# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetWorkspaceResult',
    'AwaitableGetWorkspaceResult',
    'get_workspace',
    'get_workspace_output',
]

@pulumi.output_type
class GetWorkspaceResult:
    """
    A collection of values returned by getWorkspace.
    """
    def __init__(__self__, default_data_collection_endpoint_id=None, default_data_collection_rule_id=None, id=None, location=None, name=None, public_network_access_enabled=None, query_endpoint=None, resource_group_name=None, tags=None):
        if default_data_collection_endpoint_id and not isinstance(default_data_collection_endpoint_id, str):
            raise TypeError("Expected argument 'default_data_collection_endpoint_id' to be a str")
        pulumi.set(__self__, "default_data_collection_endpoint_id", default_data_collection_endpoint_id)
        if default_data_collection_rule_id and not isinstance(default_data_collection_rule_id, str):
            raise TypeError("Expected argument 'default_data_collection_rule_id' to be a str")
        pulumi.set(__self__, "default_data_collection_rule_id", default_data_collection_rule_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_network_access_enabled and not isinstance(public_network_access_enabled, bool):
            raise TypeError("Expected argument 'public_network_access_enabled' to be a bool")
        pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if query_endpoint and not isinstance(query_endpoint, str):
            raise TypeError("Expected argument 'query_endpoint' to be a str")
        pulumi.set(__self__, "query_endpoint", query_endpoint)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="defaultDataCollectionEndpointId")
    def default_data_collection_endpoint_id(self) -> builtins.str:
        """
        The ID of the managed default Data Collection Endpoint created with the Azure Monitor Workspace.
        """
        return pulumi.get(self, "default_data_collection_endpoint_id")

    @property
    @pulumi.getter(name="defaultDataCollectionRuleId")
    def default_data_collection_rule_id(self) -> builtins.str:
        """
        The ID of the managed default Data Collection Rule created with the Azure Monitor Workspace.
        """
        return pulumi.get(self, "default_data_collection_rule_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure Region where the Workspace is located.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> builtins.bool:
        """
        Whether network access from public internet to the Workspace are allowed.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="queryEndpoint")
    def query_endpoint(self) -> builtins.str:
        """
        The query endpoint for the Azure Monitor Workspace.
        """
        return pulumi.get(self, "query_endpoint")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags that are assigned to the Workspace.
        """
        return pulumi.get(self, "tags")


class AwaitableGetWorkspaceResult(GetWorkspaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceResult(
            default_data_collection_endpoint_id=self.default_data_collection_endpoint_id,
            default_data_collection_rule_id=self.default_data_collection_rule_id,
            id=self.id,
            location=self.location,
            name=self.name,
            public_network_access_enabled=self.public_network_access_enabled,
            query_endpoint=self.query_endpoint,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_workspace(name: Optional[builtins.str] = None,
                  resource_group_name: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceResult:
    """
    Use this data source to access information about an existing Workspace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.monitoring.get_workspace(name="example-workspace",
        resource_group_name=example_azurerm_resource_group["name"])
    pulumi.export("queryEndpoint", example.query_endpoint)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Monitor`: 2023-04-03


    :param builtins.str name: Specifies the name of the Workspace.
    :param builtins.str resource_group_name: Specifies the name of the resource group the Workspace is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:monitoring/getWorkspace:getWorkspace', __args__, opts=opts, typ=GetWorkspaceResult).value

    return AwaitableGetWorkspaceResult(
        default_data_collection_endpoint_id=pulumi.get(__ret__, 'default_data_collection_endpoint_id'),
        default_data_collection_rule_id=pulumi.get(__ret__, 'default_data_collection_rule_id'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        public_network_access_enabled=pulumi.get(__ret__, 'public_network_access_enabled'),
        query_endpoint=pulumi.get(__ret__, 'query_endpoint'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_workspace_output(name: Optional[pulumi.Input[builtins.str]] = None,
                         resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkspaceResult]:
    """
    Use this data source to access information about an existing Workspace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.monitoring.get_workspace(name="example-workspace",
        resource_group_name=example_azurerm_resource_group["name"])
    pulumi.export("queryEndpoint", example.query_endpoint)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Monitor`: 2023-04-03


    :param builtins.str name: Specifies the name of the Workspace.
    :param builtins.str resource_group_name: Specifies the name of the resource group the Workspace is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:monitoring/getWorkspace:getWorkspace', __args__, opts=opts, typ=GetWorkspaceResult)
    return __ret__.apply(lambda __response__: GetWorkspaceResult(
        default_data_collection_endpoint_id=pulumi.get(__response__, 'default_data_collection_endpoint_id'),
        default_data_collection_rule_id=pulumi.get(__response__, 'default_data_collection_rule_id'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        public_network_access_enabled=pulumi.get(__response__, 'public_network_access_enabled'),
        query_endpoint=pulumi.get(__response__, 'query_endpoint'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
