# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceArgs', 'Workspace']

@pulumi.input_type
class WorkspaceArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Workspace resource.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Azure Monitor Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Azure Monitor Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Azure Monitor Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is public network access enabled? Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Monitor Workspace.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the Resource Group where the Azure Monitor Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the Azure Monitor Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Azure Monitor Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is public network access enabled? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Monitor Workspace.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _WorkspaceState:
    def __init__(__self__, *,
                 default_data_collection_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_data_collection_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 query_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Workspace resources.
        :param pulumi.Input[builtins.str] default_data_collection_endpoint_id: The ID of the managed default Data Collection Endpoint created with the Azure Monitor Workspace.
        :param pulumi.Input[builtins.str] default_data_collection_rule_id: The ID of the managed default Data Collection Rule created with the Azure Monitor Workspace.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Azure Monitor Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Azure Monitor Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is public network access enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] query_endpoint: The query endpoint for the Azure Monitor Workspace.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Azure Monitor Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Monitor Workspace.
        """
        if default_data_collection_endpoint_id is not None:
            pulumi.set(__self__, "default_data_collection_endpoint_id", default_data_collection_endpoint_id)
        if default_data_collection_rule_id is not None:
            pulumi.set(__self__, "default_data_collection_rule_id", default_data_collection_rule_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if query_endpoint is not None:
            pulumi.set(__self__, "query_endpoint", query_endpoint)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="defaultDataCollectionEndpointId")
    def default_data_collection_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the managed default Data Collection Endpoint created with the Azure Monitor Workspace.
        """
        return pulumi.get(self, "default_data_collection_endpoint_id")

    @default_data_collection_endpoint_id.setter
    def default_data_collection_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_data_collection_endpoint_id", value)

    @property
    @pulumi.getter(name="defaultDataCollectionRuleId")
    def default_data_collection_rule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the managed default Data Collection Rule created with the Azure Monitor Workspace.
        """
        return pulumi.get(self, "default_data_collection_rule_id")

    @default_data_collection_rule_id.setter
    def default_data_collection_rule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_data_collection_rule_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the Azure Monitor Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Azure Monitor Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is public network access enabled? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="queryEndpoint")
    def query_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The query endpoint for the Azure Monitor Workspace.
        """
        return pulumi.get(self, "query_endpoint")

    @query_endpoint.setter
    def query_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query_endpoint", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Resource Group where the Azure Monitor Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Monitor Workspace.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:monitoring/workspace:Workspace")
class Workspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Azure Monitor Workspace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_workspace = azure.monitoring.Workspace("example",
            name="example-mamw",
            resource_group_name=example.name,
            location="West Europe",
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Monitor`: 2023-04-03

        ## Import

        Azure Monitor Workspace can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/workspace:Workspace example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Monitor/accounts/azureMonitorWorkspace1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Azure Monitor Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Azure Monitor Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is public network access enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Azure Monitor Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Monitor Workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Monitor Workspace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_workspace = azure.monitoring.Workspace("example",
            name="example-mamw",
            resource_group_name=example.name,
            location="West Europe",
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Monitor`: 2023-04-03

        ## Import

        Azure Monitor Workspace can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/workspace:Workspace example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Monitor/accounts/azureMonitorWorkspace1
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceArgs.__new__(WorkspaceArgs)

            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["default_data_collection_endpoint_id"] = None
            __props__.__dict__["default_data_collection_rule_id"] = None
            __props__.__dict__["query_endpoint"] = None
        super(Workspace, __self__).__init__(
            'azure:monitoring/workspace:Workspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_data_collection_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
            default_data_collection_rule_id: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            query_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Workspace':
        """
        Get an existing Workspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] default_data_collection_endpoint_id: The ID of the managed default Data Collection Endpoint created with the Azure Monitor Workspace.
        :param pulumi.Input[builtins.str] default_data_collection_rule_id: The ID of the managed default Data Collection Rule created with the Azure Monitor Workspace.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Azure Monitor Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Azure Monitor Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is public network access enabled? Defaults to `true`.
        :param pulumi.Input[builtins.str] query_endpoint: The query endpoint for the Azure Monitor Workspace.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Azure Monitor Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Monitor Workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceState.__new__(_WorkspaceState)

        __props__.__dict__["default_data_collection_endpoint_id"] = default_data_collection_endpoint_id
        __props__.__dict__["default_data_collection_rule_id"] = default_data_collection_rule_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["query_endpoint"] = query_endpoint
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return Workspace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultDataCollectionEndpointId")
    def default_data_collection_endpoint_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the managed default Data Collection Endpoint created with the Azure Monitor Workspace.
        """
        return pulumi.get(self, "default_data_collection_endpoint_id")

    @property
    @pulumi.getter(name="defaultDataCollectionRuleId")
    def default_data_collection_rule_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the managed default Data Collection Rule created with the Azure Monitor Workspace.
        """
        return pulumi.get(self, "default_data_collection_rule_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Azure Region where the Azure Monitor Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name which should be used for this Azure Monitor Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is public network access enabled? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="queryEndpoint")
    def query_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The query endpoint for the Azure Monitor Workspace.
        """
        return pulumi.get(self, "query_endpoint")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Resource Group where the Azure Monitor Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Azure Monitor Workspace.
        """
        return pulumi.get(self, "tags")

