# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseVulnerabilityAssessmentRuleBaselineArgs', 'DatabaseVulnerabilityAssessmentRuleBaseline']

@pulumi.input_type
class DatabaseVulnerabilityAssessmentRuleBaselineArgs:
    def __init__(__self__, *,
                 baseline_results: pulumi.Input[Sequence[pulumi.Input['DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs']]],
                 database_name: pulumi.Input[builtins.str],
                 rule_id: pulumi.Input[builtins.str],
                 server_vulnerability_assessment_id: pulumi.Input[builtins.str],
                 baseline_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DatabaseVulnerabilityAssessmentRuleBaseline resource.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs']]] baseline_results: A `baseline_result` block as documented below. Multiple blocks can be defined.
        :param pulumi.Input[builtins.str] database_name: Specifies the name of the MS SQL Database. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] rule_id: The vulnerability assessment rule ID. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server_vulnerability_assessment_id: The Vulnerability Assessment ID of the MS SQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] baseline_name: The name of the vulnerability assessment rule baseline. Valid options are `default` and `master`. `default` implies a baseline on a database level rule and `master` for server level rule. Defaults to `default`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "baseline_results", baseline_results)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "rule_id", rule_id)
        pulumi.set(__self__, "server_vulnerability_assessment_id", server_vulnerability_assessment_id)
        if baseline_name is not None:
            pulumi.set(__self__, "baseline_name", baseline_name)

    @property
    @pulumi.getter(name="baselineResults")
    def baseline_results(self) -> pulumi.Input[Sequence[pulumi.Input['DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs']]]:
        """
        A `baseline_result` block as documented below. Multiple blocks can be defined.
        """
        return pulumi.get(self, "baseline_results")

    @baseline_results.setter
    def baseline_results(self, value: pulumi.Input[Sequence[pulumi.Input['DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs']]]):
        pulumi.set(self, "baseline_results", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the MS SQL Database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[builtins.str]:
        """
        The vulnerability assessment rule ID. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="serverVulnerabilityAssessmentId")
    def server_vulnerability_assessment_id(self) -> pulumi.Input[builtins.str]:
        """
        The Vulnerability Assessment ID of the MS SQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_vulnerability_assessment_id")

    @server_vulnerability_assessment_id.setter
    def server_vulnerability_assessment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "server_vulnerability_assessment_id", value)

    @property
    @pulumi.getter(name="baselineName")
    def baseline_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the vulnerability assessment rule baseline. Valid options are `default` and `master`. `default` implies a baseline on a database level rule and `master` for server level rule. Defaults to `default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "baseline_name")

    @baseline_name.setter
    def baseline_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "baseline_name", value)


@pulumi.input_type
class _DatabaseVulnerabilityAssessmentRuleBaselineState:
    def __init__(__self__, *,
                 baseline_name: Optional[pulumi.Input[builtins.str]] = None,
                 baseline_results: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs']]]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 server_vulnerability_assessment_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseVulnerabilityAssessmentRuleBaseline resources.
        :param pulumi.Input[builtins.str] baseline_name: The name of the vulnerability assessment rule baseline. Valid options are `default` and `master`. `default` implies a baseline on a database level rule and `master` for server level rule. Defaults to `default`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs']]] baseline_results: A `baseline_result` block as documented below. Multiple blocks can be defined.
        :param pulumi.Input[builtins.str] database_name: Specifies the name of the MS SQL Database. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] rule_id: The vulnerability assessment rule ID. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server_vulnerability_assessment_id: The Vulnerability Assessment ID of the MS SQL Server. Changing this forces a new resource to be created.
        """
        if baseline_name is not None:
            pulumi.set(__self__, "baseline_name", baseline_name)
        if baseline_results is not None:
            pulumi.set(__self__, "baseline_results", baseline_results)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if server_vulnerability_assessment_id is not None:
            pulumi.set(__self__, "server_vulnerability_assessment_id", server_vulnerability_assessment_id)

    @property
    @pulumi.getter(name="baselineName")
    def baseline_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the vulnerability assessment rule baseline. Valid options are `default` and `master`. `default` implies a baseline on a database level rule and `master` for server level rule. Defaults to `default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "baseline_name")

    @baseline_name.setter
    def baseline_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "baseline_name", value)

    @property
    @pulumi.getter(name="baselineResults")
    def baseline_results(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs']]]]:
        """
        A `baseline_result` block as documented below. Multiple blocks can be defined.
        """
        return pulumi.get(self, "baseline_results")

    @baseline_results.setter
    def baseline_results(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs']]]]):
        pulumi.set(self, "baseline_results", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the MS SQL Database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The vulnerability assessment rule ID. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="serverVulnerabilityAssessmentId")
    def server_vulnerability_assessment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Vulnerability Assessment ID of the MS SQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_vulnerability_assessment_id")

    @server_vulnerability_assessment_id.setter
    def server_vulnerability_assessment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_vulnerability_assessment_id", value)


@pulumi.type_token("azure:mssql/databaseVulnerabilityAssessmentRuleBaseline:DatabaseVulnerabilityAssessmentRuleBaseline")
class DatabaseVulnerabilityAssessmentRuleBaseline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_name: Optional[pulumi.Input[builtins.str]] = None,
                 baseline_results: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs', 'DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgsDict']]]]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 server_vulnerability_assessment_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Database Vulnerability Assessment Rule Baseline.

        > **Note:** Database Vulnerability Assessment is currently only available for MS SQL databases.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_server = azure.mssql.Server("example",
            name="mysqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="4dm1n157r470r",
            administrator_login_password="4-v3ry-53cr37-p455w0rd")
        example_account = azure.storage.Account("example",
            name="accteststorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS")
        example_container = azure.storage.Container("example",
            name="accteststoragecontainer",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_server_security_alert_policy = azure.mssql.ServerSecurityAlertPolicy("example",
            resource_group_name=example.name,
            server_name=example_server.name,
            state="Enabled")
        example_database = azure.mssql.Database("example",
            name="mysqldatabase",
            server_id=test["id"])
        example_server_vulnerability_assessment = azure.mssql.ServerVulnerabilityAssessment("example",
            server_security_alert_policy_id=example_server_security_alert_policy.id,
            storage_container_path=pulumi.Output.all(
                primary_blob_endpoint=example_account.primary_blob_endpoint,
                name=example_container.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['primary_blob_endpoint']}{resolved_outputs['name']}/")
        ,
            storage_account_access_key=example_account.primary_access_key)
        example_database_vulnerability_assessment_rule_baseline = azure.mssql.DatabaseVulnerabilityAssessmentRuleBaseline("example",
            server_vulnerability_assessment_id=example_server_vulnerability_assessment.id,
            database_name=example_database.name,
            rule_id="VA2065",
            baseline_name="master",
            baseline_results=[
                {
                    "results": [
                        "allowedip1",
                        "123.123.123.123",
                        "123.123.123.123",
                    ],
                },
                {
                    "results": [
                        "allowedip2",
                        "255.255.255.255",
                        "255.255.255.255",
                    ],
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        Database Vulnerability Assessment Rule Baseline can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/databaseVulnerabilityAssessmentRuleBaseline:DatabaseVulnerabilityAssessmentRuleBaseline example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/acceptanceTestResourceGroup1/providers/Microsoft.Sql/servers/mssqlserver/databases/mysqldatabase/vulnerabilityAssessments/Default/rules/VA2065/baselines/master
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] baseline_name: The name of the vulnerability assessment rule baseline. Valid options are `default` and `master`. `default` implies a baseline on a database level rule and `master` for server level rule. Defaults to `default`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs', 'DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgsDict']]]] baseline_results: A `baseline_result` block as documented below. Multiple blocks can be defined.
        :param pulumi.Input[builtins.str] database_name: Specifies the name of the MS SQL Database. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] rule_id: The vulnerability assessment rule ID. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server_vulnerability_assessment_id: The Vulnerability Assessment ID of the MS SQL Server. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseVulnerabilityAssessmentRuleBaselineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Database Vulnerability Assessment Rule Baseline.

        > **Note:** Database Vulnerability Assessment is currently only available for MS SQL databases.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_server = azure.mssql.Server("example",
            name="mysqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="4dm1n157r470r",
            administrator_login_password="4-v3ry-53cr37-p455w0rd")
        example_account = azure.storage.Account("example",
            name="accteststorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS")
        example_container = azure.storage.Container("example",
            name="accteststoragecontainer",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_server_security_alert_policy = azure.mssql.ServerSecurityAlertPolicy("example",
            resource_group_name=example.name,
            server_name=example_server.name,
            state="Enabled")
        example_database = azure.mssql.Database("example",
            name="mysqldatabase",
            server_id=test["id"])
        example_server_vulnerability_assessment = azure.mssql.ServerVulnerabilityAssessment("example",
            server_security_alert_policy_id=example_server_security_alert_policy.id,
            storage_container_path=pulumi.Output.all(
                primary_blob_endpoint=example_account.primary_blob_endpoint,
                name=example_container.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['primary_blob_endpoint']}{resolved_outputs['name']}/")
        ,
            storage_account_access_key=example_account.primary_access_key)
        example_database_vulnerability_assessment_rule_baseline = azure.mssql.DatabaseVulnerabilityAssessmentRuleBaseline("example",
            server_vulnerability_assessment_id=example_server_vulnerability_assessment.id,
            database_name=example_database.name,
            rule_id="VA2065",
            baseline_name="master",
            baseline_results=[
                {
                    "results": [
                        "allowedip1",
                        "123.123.123.123",
                        "123.123.123.123",
                    ],
                },
                {
                    "results": [
                        "allowedip2",
                        "255.255.255.255",
                        "255.255.255.255",
                    ],
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        Database Vulnerability Assessment Rule Baseline can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/databaseVulnerabilityAssessmentRuleBaseline:DatabaseVulnerabilityAssessmentRuleBaseline example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/acceptanceTestResourceGroup1/providers/Microsoft.Sql/servers/mssqlserver/databases/mysqldatabase/vulnerabilityAssessments/Default/rules/VA2065/baselines/master
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseVulnerabilityAssessmentRuleBaselineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseVulnerabilityAssessmentRuleBaselineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_name: Optional[pulumi.Input[builtins.str]] = None,
                 baseline_results: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs', 'DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgsDict']]]]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 server_vulnerability_assessment_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseVulnerabilityAssessmentRuleBaselineArgs.__new__(DatabaseVulnerabilityAssessmentRuleBaselineArgs)

            __props__.__dict__["baseline_name"] = baseline_name
            if baseline_results is None and not opts.urn:
                raise TypeError("Missing required property 'baseline_results'")
            __props__.__dict__["baseline_results"] = baseline_results
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            if rule_id is None and not opts.urn:
                raise TypeError("Missing required property 'rule_id'")
            __props__.__dict__["rule_id"] = rule_id
            if server_vulnerability_assessment_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_vulnerability_assessment_id'")
            __props__.__dict__["server_vulnerability_assessment_id"] = server_vulnerability_assessment_id
        super(DatabaseVulnerabilityAssessmentRuleBaseline, __self__).__init__(
            'azure:mssql/databaseVulnerabilityAssessmentRuleBaseline:DatabaseVulnerabilityAssessmentRuleBaseline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            baseline_name: Optional[pulumi.Input[builtins.str]] = None,
            baseline_results: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs', 'DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgsDict']]]]] = None,
            database_name: Optional[pulumi.Input[builtins.str]] = None,
            rule_id: Optional[pulumi.Input[builtins.str]] = None,
            server_vulnerability_assessment_id: Optional[pulumi.Input[builtins.str]] = None) -> 'DatabaseVulnerabilityAssessmentRuleBaseline':
        """
        Get an existing DatabaseVulnerabilityAssessmentRuleBaseline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] baseline_name: The name of the vulnerability assessment rule baseline. Valid options are `default` and `master`. `default` implies a baseline on a database level rule and `master` for server level rule. Defaults to `default`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs', 'DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgsDict']]]] baseline_results: A `baseline_result` block as documented below. Multiple blocks can be defined.
        :param pulumi.Input[builtins.str] database_name: Specifies the name of the MS SQL Database. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] rule_id: The vulnerability assessment rule ID. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] server_vulnerability_assessment_id: The Vulnerability Assessment ID of the MS SQL Server. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseVulnerabilityAssessmentRuleBaselineState.__new__(_DatabaseVulnerabilityAssessmentRuleBaselineState)

        __props__.__dict__["baseline_name"] = baseline_name
        __props__.__dict__["baseline_results"] = baseline_results
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["server_vulnerability_assessment_id"] = server_vulnerability_assessment_id
        return DatabaseVulnerabilityAssessmentRuleBaseline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="baselineName")
    def baseline_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the vulnerability assessment rule baseline. Valid options are `default` and `master`. `default` implies a baseline on a database level rule and `master` for server level rule. Defaults to `default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "baseline_name")

    @property
    @pulumi.getter(name="baselineResults")
    def baseline_results(self) -> pulumi.Output[Sequence['outputs.DatabaseVulnerabilityAssessmentRuleBaselineBaselineResult']]:
        """
        A `baseline_result` block as documented below. Multiple blocks can be defined.
        """
        return pulumi.get(self, "baseline_results")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the MS SQL Database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[builtins.str]:
        """
        The vulnerability assessment rule ID. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="serverVulnerabilityAssessmentId")
    def server_vulnerability_assessment_id(self) -> pulumi.Output[builtins.str]:
        """
        The Vulnerability Assessment ID of the MS SQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_vulnerability_assessment_id")

