# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetElasticPoolResult',
    'AwaitableGetElasticPoolResult',
    'get_elastic_pool',
    'get_elastic_pool_output',
]

@pulumi.output_type
class GetElasticPoolResult:
    """
    A collection of values returned by getElasticPool.
    """
    def __init__(__self__, enclave_type=None, id=None, license_type=None, location=None, max_size_bytes=None, max_size_gb=None, name=None, per_db_max_capacity=None, per_db_min_capacity=None, resource_group_name=None, server_name=None, skus=None, tags=None, zone_redundant=None):
        if enclave_type and not isinstance(enclave_type, str):
            raise TypeError("Expected argument 'enclave_type' to be a str")
        pulumi.set(__self__, "enclave_type", enclave_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if license_type and not isinstance(license_type, str):
            raise TypeError("Expected argument 'license_type' to be a str")
        pulumi.set(__self__, "license_type", license_type)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if max_size_bytes and not isinstance(max_size_bytes, int):
            raise TypeError("Expected argument 'max_size_bytes' to be a int")
        pulumi.set(__self__, "max_size_bytes", max_size_bytes)
        if max_size_gb and not isinstance(max_size_gb, float):
            raise TypeError("Expected argument 'max_size_gb' to be a float")
        pulumi.set(__self__, "max_size_gb", max_size_gb)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if per_db_max_capacity and not isinstance(per_db_max_capacity, int):
            raise TypeError("Expected argument 'per_db_max_capacity' to be a int")
        pulumi.set(__self__, "per_db_max_capacity", per_db_max_capacity)
        if per_db_min_capacity and not isinstance(per_db_min_capacity, int):
            raise TypeError("Expected argument 'per_db_min_capacity' to be a int")
        pulumi.set(__self__, "per_db_min_capacity", per_db_min_capacity)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if server_name and not isinstance(server_name, str):
            raise TypeError("Expected argument 'server_name' to be a str")
        pulumi.set(__self__, "server_name", server_name)
        if skus and not isinstance(skus, list):
            raise TypeError("Expected argument 'skus' to be a list")
        pulumi.set(__self__, "skus", skus)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if zone_redundant and not isinstance(zone_redundant, bool):
            raise TypeError("Expected argument 'zone_redundant' to be a bool")
        pulumi.set(__self__, "zone_redundant", zone_redundant)

    @property
    @pulumi.getter(name="enclaveType")
    def enclave_type(self) -> builtins.str:
        """
        The type of enclave being used by the elastic pool.
        """
        return pulumi.get(self, "enclave_type")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> builtins.str:
        """
        The license type to apply for this elastic pool.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        Specifies the supported Azure location where the resource exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maxSizeBytes")
    def max_size_bytes(self) -> builtins.int:
        """
        The max data size of the elastic pool in bytes.
        """
        return pulumi.get(self, "max_size_bytes")

    @property
    @pulumi.getter(name="maxSizeGb")
    def max_size_gb(self) -> builtins.float:
        """
        The max data size of the elastic pool in gigabytes.
        """
        return pulumi.get(self, "max_size_gb")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the SKU Name for this Elasticpool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="perDbMaxCapacity")
    def per_db_max_capacity(self) -> builtins.int:
        """
        The maximum capacity any one database can consume.
        """
        return pulumi.get(self, "per_db_max_capacity")

    @property
    @pulumi.getter(name="perDbMinCapacity")
    def per_db_min_capacity(self) -> builtins.int:
        """
        The minimum capacity all databases are guaranteed.
        """
        return pulumi.get(self, "per_db_min_capacity")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> builtins.str:
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter
    def skus(self) -> Sequence['outputs.GetElasticPoolSkusResult']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "skus")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> builtins.bool:
        """
        Whether or not this elastic pool is zone redundant.
        """
        return pulumi.get(self, "zone_redundant")


class AwaitableGetElasticPoolResult(GetElasticPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetElasticPoolResult(
            enclave_type=self.enclave_type,
            id=self.id,
            license_type=self.license_type,
            location=self.location,
            max_size_bytes=self.max_size_bytes,
            max_size_gb=self.max_size_gb,
            name=self.name,
            per_db_max_capacity=self.per_db_max_capacity,
            per_db_min_capacity=self.per_db_min_capacity,
            resource_group_name=self.resource_group_name,
            server_name=self.server_name,
            skus=self.skus,
            tags=self.tags,
            zone_redundant=self.zone_redundant)


def get_elastic_pool(name: Optional[builtins.str] = None,
                     resource_group_name: Optional[builtins.str] = None,
                     server_name: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetElasticPoolResult:
    """
    Use this data source to access information about an existing SQL elastic pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mssql.get_elastic_pool(name="mssqlelasticpoolname",
        resource_group_name="example-resources",
        server_name="example-sql-server")
    pulumi.export("elasticpoolId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Sql`: 2023-08-01-preview


    :param builtins.str name: The name of the elastic pool.
    :param builtins.str resource_group_name: The name of the resource group which contains the elastic pool.
    :param builtins.str server_name: The name of the SQL Server which contains the elastic pool.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['serverName'] = server_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:mssql/getElasticPool:getElasticPool', __args__, opts=opts, typ=GetElasticPoolResult).value

    return AwaitableGetElasticPoolResult(
        enclave_type=pulumi.get(__ret__, 'enclave_type'),
        id=pulumi.get(__ret__, 'id'),
        license_type=pulumi.get(__ret__, 'license_type'),
        location=pulumi.get(__ret__, 'location'),
        max_size_bytes=pulumi.get(__ret__, 'max_size_bytes'),
        max_size_gb=pulumi.get(__ret__, 'max_size_gb'),
        name=pulumi.get(__ret__, 'name'),
        per_db_max_capacity=pulumi.get(__ret__, 'per_db_max_capacity'),
        per_db_min_capacity=pulumi.get(__ret__, 'per_db_min_capacity'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        server_name=pulumi.get(__ret__, 'server_name'),
        skus=pulumi.get(__ret__, 'skus'),
        tags=pulumi.get(__ret__, 'tags'),
        zone_redundant=pulumi.get(__ret__, 'zone_redundant'))
def get_elastic_pool_output(name: Optional[pulumi.Input[builtins.str]] = None,
                            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                            server_name: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetElasticPoolResult]:
    """
    Use this data source to access information about an existing SQL elastic pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mssql.get_elastic_pool(name="mssqlelasticpoolname",
        resource_group_name="example-resources",
        server_name="example-sql-server")
    pulumi.export("elasticpoolId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Sql`: 2023-08-01-preview


    :param builtins.str name: The name of the elastic pool.
    :param builtins.str resource_group_name: The name of the resource group which contains the elastic pool.
    :param builtins.str server_name: The name of the SQL Server which contains the elastic pool.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['serverName'] = server_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:mssql/getElasticPool:getElasticPool', __args__, opts=opts, typ=GetElasticPoolResult)
    return __ret__.apply(lambda __response__: GetElasticPoolResult(
        enclave_type=pulumi.get(__response__, 'enclave_type'),
        id=pulumi.get(__response__, 'id'),
        license_type=pulumi.get(__response__, 'license_type'),
        location=pulumi.get(__response__, 'location'),
        max_size_bytes=pulumi.get(__response__, 'max_size_bytes'),
        max_size_gb=pulumi.get(__response__, 'max_size_gb'),
        name=pulumi.get(__response__, 'name'),
        per_db_max_capacity=pulumi.get(__response__, 'per_db_max_capacity'),
        per_db_min_capacity=pulumi.get(__response__, 'per_db_min_capacity'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        server_name=pulumi.get(__response__, 'server_name'),
        skus=pulumi.get(__response__, 'skus'),
        tags=pulumi.get(__response__, 'tags'),
        zone_redundant=pulumi.get(__response__, 'zone_redundant')))
