# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['JobScheduleArgs', 'JobSchedule']

@pulumi.input_type
class JobScheduleArgs:
    def __init__(__self__, *,
                 job_id: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.str]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a JobSchedule resource.
        :param pulumi.Input[builtins.str] job_id: The ID of the Elastic Job. Changing this forces a new Elastic Job Schedule to be created.
        :param pulumi.Input[builtins.str] type: The type of schedule. Possible values are `Once` and `Recurring`.
        :param pulumi.Input[builtins.bool] enabled: Should the Elastic Job Schedule be enabled? Defaults to `false`.
               
               > **Note:** When `type` is set to `Once` and `enabled` is set to `true`, it's recommended to add `enabled` to `ignore_changes`. This is because Azure will set `enabled` to `false` once the job has executed.
        :param pulumi.Input[builtins.str] end_time: The end time of the schedule. Must be in RFC3339 format.
        :param pulumi.Input[builtins.str] interval: The interval between job executions. Must be in ISO8601 duration format.
        :param pulumi.Input[builtins.str] start_time: The start time of the schedule. Must be in RFC3339 format.
        """
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "type", type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Elastic Job. Changing this forces a new Elastic Job Schedule to be created.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of schedule. Possible values are `Once` and `Recurring`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Elastic Job Schedule be enabled? Defaults to `false`.

        > **Note:** When `type` is set to `Once` and `enabled` is set to `true`, it's recommended to add `enabled` to `ignore_changes`. This is because Azure will set `enabled` to `false` once the job has executed.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The end time of the schedule. Must be in RFC3339 format.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The interval between job executions. Must be in ISO8601 duration format.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The start time of the schedule. Must be in RFC3339 format.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class _JobScheduleState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.str]] = None,
                 job_id: Optional[pulumi.Input[builtins.str]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering JobSchedule resources.
        :param pulumi.Input[builtins.bool] enabled: Should the Elastic Job Schedule be enabled? Defaults to `false`.
               
               > **Note:** When `type` is set to `Once` and `enabled` is set to `true`, it's recommended to add `enabled` to `ignore_changes`. This is because Azure will set `enabled` to `false` once the job has executed.
        :param pulumi.Input[builtins.str] end_time: The end time of the schedule. Must be in RFC3339 format.
        :param pulumi.Input[builtins.str] interval: The interval between job executions. Must be in ISO8601 duration format.
        :param pulumi.Input[builtins.str] job_id: The ID of the Elastic Job. Changing this forces a new Elastic Job Schedule to be created.
        :param pulumi.Input[builtins.str] start_time: The start time of the schedule. Must be in RFC3339 format.
        :param pulumi.Input[builtins.str] type: The type of schedule. Possible values are `Once` and `Recurring`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should the Elastic Job Schedule be enabled? Defaults to `false`.

        > **Note:** When `type` is set to `Once` and `enabled` is set to `true`, it's recommended to add `enabled` to `ignore_changes`. This is because Azure will set `enabled` to `false` once the job has executed.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The end time of the schedule. Must be in RFC3339 format.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The interval between job executions. Must be in ISO8601 duration format.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Elastic Job. Changing this forces a new Elastic Job Schedule to be created.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The start time of the schedule. Must be in RFC3339 format.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of schedule. Possible values are `Once` and `Recurring`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("azure:mssql/jobSchedule:JobSchedule")
class JobSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.str]] = None,
                 job_id: Optional[pulumi.Input[builtins.str]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an Elastic Job Schedule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resource-group",
            location="East US")
        example_server = azure.mssql.Server("example",
            name="example-server",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="4dm1n157r470r",
            administrator_login_password="4-v3ry-53cr37-p455w0rd")
        example_database = azure.mssql.Database("example",
            name="example-db",
            server_id=example_server.id,
            collation="SQL_Latin1_General_CP1_CI_AS",
            sku_name="S1")
        example_job_agent = azure.mssql.JobAgent("example",
            name="example-job-agent",
            location=example.location,
            database_id=example_database.id)
        example_job_credential = azure.mssql.JobCredential("example",
            name="example-job-credential",
            job_agent_id=example_job_agent.id,
            username="my-username",
            password="MyP4ssw0rd!!!")
        example_job = azure.mssql.Job("example",
            name="example-job",
            job_agent_id=example_job_agent.id)
        example_job_schedule = azure.mssql.JobSchedule("example",
            job_id=example_job.id,
            type="Recurring",
            enabled=True,
            end_time="2025-12-01T00:00:00Z",
            interval="PT5M",
            start_time="2025-01-01T00:00:00Z")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        Elastic Job Schedules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/jobSchedule:JobSchedule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Sql/servers/myserver1/jobAgents/myjobagent1/jobs/myjob1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Should the Elastic Job Schedule be enabled? Defaults to `false`.
               
               > **Note:** When `type` is set to `Once` and `enabled` is set to `true`, it's recommended to add `enabled` to `ignore_changes`. This is because Azure will set `enabled` to `false` once the job has executed.
        :param pulumi.Input[builtins.str] end_time: The end time of the schedule. Must be in RFC3339 format.
        :param pulumi.Input[builtins.str] interval: The interval between job executions. Must be in ISO8601 duration format.
        :param pulumi.Input[builtins.str] job_id: The ID of the Elastic Job. Changing this forces a new Elastic Job Schedule to be created.
        :param pulumi.Input[builtins.str] start_time: The start time of the schedule. Must be in RFC3339 format.
        :param pulumi.Input[builtins.str] type: The type of schedule. Possible values are `Once` and `Recurring`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Elastic Job Schedule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resource-group",
            location="East US")
        example_server = azure.mssql.Server("example",
            name="example-server",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="4dm1n157r470r",
            administrator_login_password="4-v3ry-53cr37-p455w0rd")
        example_database = azure.mssql.Database("example",
            name="example-db",
            server_id=example_server.id,
            collation="SQL_Latin1_General_CP1_CI_AS",
            sku_name="S1")
        example_job_agent = azure.mssql.JobAgent("example",
            name="example-job-agent",
            location=example.location,
            database_id=example_database.id)
        example_job_credential = azure.mssql.JobCredential("example",
            name="example-job-credential",
            job_agent_id=example_job_agent.id,
            username="my-username",
            password="MyP4ssw0rd!!!")
        example_job = azure.mssql.Job("example",
            name="example-job",
            job_agent_id=example_job_agent.id)
        example_job_schedule = azure.mssql.JobSchedule("example",
            job_id=example_job.id,
            type="Recurring",
            enabled=True,
            end_time="2025-12-01T00:00:00Z",
            interval="PT5M",
            start_time="2025-01-01T00:00:00Z")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        Elastic Job Schedules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/jobSchedule:JobSchedule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Sql/servers/myserver1/jobAgents/myjobagent1/jobs/myjob1
        ```

        :param str resource_name: The name of the resource.
        :param JobScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 interval: Optional[pulumi.Input[builtins.str]] = None,
                 job_id: Optional[pulumi.Input[builtins.str]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobScheduleArgs.__new__(JobScheduleArgs)

            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["interval"] = interval
            if job_id is None and not opts.urn:
                raise TypeError("Missing required property 'job_id'")
            __props__.__dict__["job_id"] = job_id
            __props__.__dict__["start_time"] = start_time
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(JobSchedule, __self__).__init__(
            'azure:mssql/jobSchedule:JobSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            end_time: Optional[pulumi.Input[builtins.str]] = None,
            interval: Optional[pulumi.Input[builtins.str]] = None,
            job_id: Optional[pulumi.Input[builtins.str]] = None,
            start_time: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'JobSchedule':
        """
        Get an existing JobSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Should the Elastic Job Schedule be enabled? Defaults to `false`.
               
               > **Note:** When `type` is set to `Once` and `enabled` is set to `true`, it's recommended to add `enabled` to `ignore_changes`. This is because Azure will set `enabled` to `false` once the job has executed.
        :param pulumi.Input[builtins.str] end_time: The end time of the schedule. Must be in RFC3339 format.
        :param pulumi.Input[builtins.str] interval: The interval between job executions. Must be in ISO8601 duration format.
        :param pulumi.Input[builtins.str] job_id: The ID of the Elastic Job. Changing this forces a new Elastic Job Schedule to be created.
        :param pulumi.Input[builtins.str] start_time: The start time of the schedule. Must be in RFC3339 format.
        :param pulumi.Input[builtins.str] type: The type of schedule. Possible values are `Once` and `Recurring`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobScheduleState.__new__(_JobScheduleState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["interval"] = interval
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["type"] = type
        return JobSchedule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Should the Elastic Job Schedule be enabled? Defaults to `false`.

        > **Note:** When `type` is set to `Once` and `enabled` is set to `true`, it's recommended to add `enabled` to `ignore_changes`. This is because Azure will set `enabled` to `false` once the job has executed.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[builtins.str]:
        """
        The end time of the schedule. Must be in RFC3339 format.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The interval between job executions. Must be in ISO8601 duration format.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Elastic Job. Changing this forces a new Elastic Job Schedule to be created.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[builtins.str]:
        """
        The start time of the schedule. Must be in RFC3339 format.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of schedule. Possible values are `Once` and `Recurring`.
        """
        return pulumi.get(self, "type")

