# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ManagedInstanceTransparentDataEncryptionArgs', 'ManagedInstanceTransparentDataEncryption']

@pulumi.input_type
class ManagedInstanceTransparentDataEncryptionArgs:
    def __init__(__self__, *,
                 managed_instance_id: pulumi.Input[builtins.str],
                 auto_rotation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedInstanceTransparentDataEncryption resource.
        :param pulumi.Input[builtins.str] managed_instance_id: Specifies the name of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] auto_rotation_enabled: When enabled, the SQL Managed Instance will continuously check the key vault for any new versions of the key being used as the TDE protector. If a new version of the key is detected, the TDE protector on the SQL Managed Instance will be automatically rotated to the latest key version within 60 minutes.
        :param pulumi.Input[builtins.str] key_vault_key_id: To use customer managed keys from Azure Key Vault, provide the AKV Key ID. To use service managed keys, omit this field.
        :param pulumi.Input[builtins.str] managed_hsm_key_id: To use customer managed keys from a managed HSM, provide the Managed HSM Key ID. To use service managed keys, omit this field.
               
               > **Note:** In order to use customer managed keys, the identity of the MSSQL Managed Instance must have the following permissions on the key vault: 'get', 'wrapKey' and 'unwrapKey'
               
               > **Note:** If `managed_instance_id` denotes a secondary instance deployed for disaster recovery purposes, then the `key_vault_key_id` should be the same key used for the primary instance's transparent data encryption. Both primary and secondary instances should be encrypted with same key material.
        """
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if auto_rotation_enabled is not None:
            pulumi.set(__self__, "auto_rotation_enabled", auto_rotation_enabled)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if managed_hsm_key_id is not None:
            pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "managed_instance_id", value)

    @property
    @pulumi.getter(name="autoRotationEnabled")
    def auto_rotation_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When enabled, the SQL Managed Instance will continuously check the key vault for any new versions of the key being used as the TDE protector. If a new version of the key is detected, the TDE protector on the SQL Managed Instance will be automatically rotated to the latest key version within 60 minutes.
        """
        return pulumi.get(self, "auto_rotation_enabled")

    @auto_rotation_enabled.setter
    def auto_rotation_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_rotation_enabled", value)

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        To use customer managed keys from Azure Key Vault, provide the AKV Key ID. To use service managed keys, omit this field.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        To use customer managed keys from a managed HSM, provide the Managed HSM Key ID. To use service managed keys, omit this field.

        > **Note:** In order to use customer managed keys, the identity of the MSSQL Managed Instance must have the following permissions on the key vault: 'get', 'wrapKey' and 'unwrapKey'

        > **Note:** If `managed_instance_id` denotes a secondary instance deployed for disaster recovery purposes, then the `key_vault_key_id` should be the same key used for the primary instance's transparent data encryption. Both primary and secondary instances should be encrypted with same key material.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @managed_hsm_key_id.setter
    def managed_hsm_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_hsm_key_id", value)


@pulumi.input_type
class _ManagedInstanceTransparentDataEncryptionState:
    def __init__(__self__, *,
                 auto_rotation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceTransparentDataEncryption resources.
        :param pulumi.Input[builtins.bool] auto_rotation_enabled: When enabled, the SQL Managed Instance will continuously check the key vault for any new versions of the key being used as the TDE protector. If a new version of the key is detected, the TDE protector on the SQL Managed Instance will be automatically rotated to the latest key version within 60 minutes.
        :param pulumi.Input[builtins.str] key_vault_key_id: To use customer managed keys from Azure Key Vault, provide the AKV Key ID. To use service managed keys, omit this field.
        :param pulumi.Input[builtins.str] managed_hsm_key_id: To use customer managed keys from a managed HSM, provide the Managed HSM Key ID. To use service managed keys, omit this field.
               
               > **Note:** In order to use customer managed keys, the identity of the MSSQL Managed Instance must have the following permissions on the key vault: 'get', 'wrapKey' and 'unwrapKey'
               
               > **Note:** If `managed_instance_id` denotes a secondary instance deployed for disaster recovery purposes, then the `key_vault_key_id` should be the same key used for the primary instance's transparent data encryption. Both primary and secondary instances should be encrypted with same key material.
        :param pulumi.Input[builtins.str] managed_instance_id: Specifies the name of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        if auto_rotation_enabled is not None:
            pulumi.set(__self__, "auto_rotation_enabled", auto_rotation_enabled)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if managed_hsm_key_id is not None:
            pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)
        if managed_instance_id is not None:
            pulumi.set(__self__, "managed_instance_id", managed_instance_id)

    @property
    @pulumi.getter(name="autoRotationEnabled")
    def auto_rotation_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When enabled, the SQL Managed Instance will continuously check the key vault for any new versions of the key being used as the TDE protector. If a new version of the key is detected, the TDE protector on the SQL Managed Instance will be automatically rotated to the latest key version within 60 minutes.
        """
        return pulumi.get(self, "auto_rotation_enabled")

    @auto_rotation_enabled.setter
    def auto_rotation_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_rotation_enabled", value)

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        To use customer managed keys from Azure Key Vault, provide the AKV Key ID. To use service managed keys, omit this field.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        To use customer managed keys from a managed HSM, provide the Managed HSM Key ID. To use service managed keys, omit this field.

        > **Note:** In order to use customer managed keys, the identity of the MSSQL Managed Instance must have the following permissions on the key vault: 'get', 'wrapKey' and 'unwrapKey'

        > **Note:** If `managed_instance_id` denotes a secondary instance deployed for disaster recovery purposes, then the `key_vault_key_id` should be the same key used for the primary instance's transparent data encryption. Both primary and secondary instances should be encrypted with same key material.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @managed_hsm_key_id.setter
    def managed_hsm_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_hsm_key_id", value)

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_instance_id", value)


@pulumi.type_token("azure:mssql/managedInstanceTransparentDataEncryption:ManagedInstanceTransparentDataEncryption")
class ManagedInstanceTransparentDataEncryption(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_rotation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages the transparent data encryption configuration for a MSSQL Managed Instance

        > **Note:** Once transparent data encryption(TDE) is enabled on a MS SQL instance, it is not possible to remove TDE. You will be able to switch between 'ServiceManaged' and 'CustomerManaged' keys, but will not be able to remove encryption. For safety when this resource is deleted, the TDE mode will automatically be set to 'ServiceManaged'. See `key_vault_uri` for more information on how to specify the key types. As SQL Managed Instance only supports a single configuration for encryption settings, this resource will replace the current encryption settings on the server.

        > **Note:** See [documentation](https://docs.microsoft.com/azure/azure-sql/database/transparent-data-encryption-byok-overview) for important information on how handle lifecycle management of the keys to prevent data lockout.

        ## Example Usage

        ### With Service Managed Key

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="EastUs")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctest-vnet1-mssql",
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"],
            location=test["location"])
        example_subnet = azure.network.Subnet("example",
            name="subnet1-mssql",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.0.0/24"],
            delegations=[{
                "name": "managedinstancedelegation",
                "service_delegation": {
                    "name": "Microsoft.Sql/managedInstances",
                    "actions": [
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                        "Microsoft.Network/virtualNetworks/subnets/prepareNetworkPolicies/action",
                        "Microsoft.Network/virtualNetworks/subnets/unprepareNetworkPolicies/action",
                    ],
                },
            }])
        example_managed_instance = azure.mssql.ManagedInstance("example",
            name="mssqlinstance",
            resource_group_name=example.name,
            location=example.location,
            license_type="BasePrice",
            sku_name="GP_Gen5",
            storage_size_in_gb=32,
            subnet_id=example_subnet.id,
            vcores=4,
            administrator_login="missadministrator",
            administrator_login_password="NCC-1701-D",
            identity={
                "type": "SystemAssigned",
            })
        example_managed_instance_transparent_data_encryption = azure.mssql.ManagedInstanceTransparentDataEncryption("example", managed_instance_id=example_managed_instance.id)
        ```

        ### With Customer Managed Key

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="EastUs")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctest-vnet1-mssql",
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"],
            location=test["location"])
        example_subnet = azure.network.Subnet("example",
            name="subnet1-mssql",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.0.0/24"],
            delegations=[{
                "name": "managedinstancedelegation",
                "service_delegation": {
                    "name": "Microsoft.Sql/managedInstances",
                    "actions": [
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                        "Microsoft.Network/virtualNetworks/subnets/prepareNetworkPolicies/action",
                        "Microsoft.Network/virtualNetworks/subnets/unprepareNetworkPolicies/action",
                    ],
                },
            }])
        example_managed_instance = azure.mssql.ManagedInstance("example",
            name="mssqlinstance",
            resource_group_name=example.name,
            location=example.location,
            license_type="BasePrice",
            sku_name="GP_Gen5",
            storage_size_in_gb=32,
            subnet_id=example_subnet.id,
            vcores=4,
            administrator_login="missadministrator",
            administrator_login_password="NCC-1701-D",
            identity={
                "type": "SystemAssigned",
            })
        # Create a key vault with policies for the deployer to create a key & SQL Managed Instance to wrap/unwrap/get key
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            tenant_id=current.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=False,
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Get",
                        "List",
                        "Create",
                        "Delete",
                        "Update",
                        "Recover",
                        "Purge",
                        "GetRotationPolicy",
                    ],
                },
                {
                    "tenant_id": example_managed_instance.identity.tenant_id,
                    "object_id": example_managed_instance.identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "WrapKey",
                        "UnwrapKey",
                    ],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="byok",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_key_vault]))
        example_managed_instance_transparent_data_encryption = azure.mssql.ManagedInstanceTransparentDataEncryption("example",
            managed_instance_id=example_managed_instance.id,
            key_vault_key_id=example_key.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        SQL Managed Instance Transparent Data Encryption can be imported using the resource id, e.g.

        ```sh
        $ pulumi import azure:mssql/managedInstanceTransparentDataEncryption:ManagedInstanceTransparentDataEncryption example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Sql/managedInstances/instance1/encryptionProtector/current
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] auto_rotation_enabled: When enabled, the SQL Managed Instance will continuously check the key vault for any new versions of the key being used as the TDE protector. If a new version of the key is detected, the TDE protector on the SQL Managed Instance will be automatically rotated to the latest key version within 60 minutes.
        :param pulumi.Input[builtins.str] key_vault_key_id: To use customer managed keys from Azure Key Vault, provide the AKV Key ID. To use service managed keys, omit this field.
        :param pulumi.Input[builtins.str] managed_hsm_key_id: To use customer managed keys from a managed HSM, provide the Managed HSM Key ID. To use service managed keys, omit this field.
               
               > **Note:** In order to use customer managed keys, the identity of the MSSQL Managed Instance must have the following permissions on the key vault: 'get', 'wrapKey' and 'unwrapKey'
               
               > **Note:** If `managed_instance_id` denotes a secondary instance deployed for disaster recovery purposes, then the `key_vault_key_id` should be the same key used for the primary instance's transparent data encryption. Both primary and secondary instances should be encrypted with same key material.
        :param pulumi.Input[builtins.str] managed_instance_id: Specifies the name of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceTransparentDataEncryptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the transparent data encryption configuration for a MSSQL Managed Instance

        > **Note:** Once transparent data encryption(TDE) is enabled on a MS SQL instance, it is not possible to remove TDE. You will be able to switch between 'ServiceManaged' and 'CustomerManaged' keys, but will not be able to remove encryption. For safety when this resource is deleted, the TDE mode will automatically be set to 'ServiceManaged'. See `key_vault_uri` for more information on how to specify the key types. As SQL Managed Instance only supports a single configuration for encryption settings, this resource will replace the current encryption settings on the server.

        > **Note:** See [documentation](https://docs.microsoft.com/azure/azure-sql/database/transparent-data-encryption-byok-overview) for important information on how handle lifecycle management of the keys to prevent data lockout.

        ## Example Usage

        ### With Service Managed Key

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="EastUs")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctest-vnet1-mssql",
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"],
            location=test["location"])
        example_subnet = azure.network.Subnet("example",
            name="subnet1-mssql",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.0.0/24"],
            delegations=[{
                "name": "managedinstancedelegation",
                "service_delegation": {
                    "name": "Microsoft.Sql/managedInstances",
                    "actions": [
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                        "Microsoft.Network/virtualNetworks/subnets/prepareNetworkPolicies/action",
                        "Microsoft.Network/virtualNetworks/subnets/unprepareNetworkPolicies/action",
                    ],
                },
            }])
        example_managed_instance = azure.mssql.ManagedInstance("example",
            name="mssqlinstance",
            resource_group_name=example.name,
            location=example.location,
            license_type="BasePrice",
            sku_name="GP_Gen5",
            storage_size_in_gb=32,
            subnet_id=example_subnet.id,
            vcores=4,
            administrator_login="missadministrator",
            administrator_login_password="NCC-1701-D",
            identity={
                "type": "SystemAssigned",
            })
        example_managed_instance_transparent_data_encryption = azure.mssql.ManagedInstanceTransparentDataEncryption("example", managed_instance_id=example_managed_instance.id)
        ```

        ### With Customer Managed Key

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="EastUs")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctest-vnet1-mssql",
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"],
            location=test["location"])
        example_subnet = azure.network.Subnet("example",
            name="subnet1-mssql",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.0.0/24"],
            delegations=[{
                "name": "managedinstancedelegation",
                "service_delegation": {
                    "name": "Microsoft.Sql/managedInstances",
                    "actions": [
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                        "Microsoft.Network/virtualNetworks/subnets/prepareNetworkPolicies/action",
                        "Microsoft.Network/virtualNetworks/subnets/unprepareNetworkPolicies/action",
                    ],
                },
            }])
        example_managed_instance = azure.mssql.ManagedInstance("example",
            name="mssqlinstance",
            resource_group_name=example.name,
            location=example.location,
            license_type="BasePrice",
            sku_name="GP_Gen5",
            storage_size_in_gb=32,
            subnet_id=example_subnet.id,
            vcores=4,
            administrator_login="missadministrator",
            administrator_login_password="NCC-1701-D",
            identity={
                "type": "SystemAssigned",
            })
        # Create a key vault with policies for the deployer to create a key & SQL Managed Instance to wrap/unwrap/get key
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            tenant_id=current.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=False,
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Get",
                        "List",
                        "Create",
                        "Delete",
                        "Update",
                        "Recover",
                        "Purge",
                        "GetRotationPolicy",
                    ],
                },
                {
                    "tenant_id": example_managed_instance.identity.tenant_id,
                    "object_id": example_managed_instance.identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "WrapKey",
                        "UnwrapKey",
                    ],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="byok",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_key_vault]))
        example_managed_instance_transparent_data_encryption = azure.mssql.ManagedInstanceTransparentDataEncryption("example",
            managed_instance_id=example_managed_instance.id,
            key_vault_key_id=example_key.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        SQL Managed Instance Transparent Data Encryption can be imported using the resource id, e.g.

        ```sh
        $ pulumi import azure:mssql/managedInstanceTransparentDataEncryption:ManagedInstanceTransparentDataEncryption example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Sql/managedInstances/instance1/encryptionProtector/current
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceTransparentDataEncryptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceTransparentDataEncryptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_rotation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceTransparentDataEncryptionArgs.__new__(ManagedInstanceTransparentDataEncryptionArgs)

            __props__.__dict__["auto_rotation_enabled"] = auto_rotation_enabled
            __props__.__dict__["key_vault_key_id"] = key_vault_key_id
            __props__.__dict__["managed_hsm_key_id"] = managed_hsm_key_id
            if managed_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_id'")
            __props__.__dict__["managed_instance_id"] = managed_instance_id
        super(ManagedInstanceTransparentDataEncryption, __self__).__init__(
            'azure:mssql/managedInstanceTransparentDataEncryption:ManagedInstanceTransparentDataEncryption',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_rotation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
            managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None,
            managed_instance_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ManagedInstanceTransparentDataEncryption':
        """
        Get an existing ManagedInstanceTransparentDataEncryption resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] auto_rotation_enabled: When enabled, the SQL Managed Instance will continuously check the key vault for any new versions of the key being used as the TDE protector. If a new version of the key is detected, the TDE protector on the SQL Managed Instance will be automatically rotated to the latest key version within 60 minutes.
        :param pulumi.Input[builtins.str] key_vault_key_id: To use customer managed keys from Azure Key Vault, provide the AKV Key ID. To use service managed keys, omit this field.
        :param pulumi.Input[builtins.str] managed_hsm_key_id: To use customer managed keys from a managed HSM, provide the Managed HSM Key ID. To use service managed keys, omit this field.
               
               > **Note:** In order to use customer managed keys, the identity of the MSSQL Managed Instance must have the following permissions on the key vault: 'get', 'wrapKey' and 'unwrapKey'
               
               > **Note:** If `managed_instance_id` denotes a secondary instance deployed for disaster recovery purposes, then the `key_vault_key_id` should be the same key used for the primary instance's transparent data encryption. Both primary and secondary instances should be encrypted with same key material.
        :param pulumi.Input[builtins.str] managed_instance_id: Specifies the name of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceTransparentDataEncryptionState.__new__(_ManagedInstanceTransparentDataEncryptionState)

        __props__.__dict__["auto_rotation_enabled"] = auto_rotation_enabled
        __props__.__dict__["key_vault_key_id"] = key_vault_key_id
        __props__.__dict__["managed_hsm_key_id"] = managed_hsm_key_id
        __props__.__dict__["managed_instance_id"] = managed_instance_id
        return ManagedInstanceTransparentDataEncryption(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRotationEnabled")
    def auto_rotation_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When enabled, the SQL Managed Instance will continuously check the key vault for any new versions of the key being used as the TDE protector. If a new version of the key is detected, the TDE protector on the SQL Managed Instance will be automatically rotated to the latest key version within 60 minutes.
        """
        return pulumi.get(self, "auto_rotation_enabled")

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        To use customer managed keys from Azure Key Vault, provide the AKV Key ID. To use service managed keys, omit this field.
        """
        return pulumi.get(self, "key_vault_key_id")

    @property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        To use customer managed keys from a managed HSM, provide the Managed HSM Key ID. To use service managed keys, omit this field.

        > **Note:** In order to use customer managed keys, the identity of the MSSQL Managed Instance must have the following permissions on the key vault: 'get', 'wrapKey' and 'unwrapKey'

        > **Note:** If `managed_instance_id` denotes a secondary instance deployed for disaster recovery purposes, then the `key_vault_key_id` should be the same key used for the primary instance's transparent data encryption. Both primary and secondary instances should be encrypted with same key material.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_id")

