# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DatabaseIdentity',
    'DatabaseImport',
    'DatabaseLongTermRetentionPolicy',
    'DatabaseShortTermRetentionPolicy',
    'DatabaseThreatDetectionPolicy',
    'DatabaseVulnerabilityAssessmentRuleBaselineBaselineResult',
    'ElasticPoolPerDatabaseSettings',
    'ElasticPoolSku',
    'FailoverGroupPartnerServer',
    'FailoverGroupReadWriteEndpointFailoverPolicy',
    'JobAgentIdentity',
    'JobStepOutputTarget',
    'JobTargetGroupJobTarget',
    'ManagedDatabaseLongTermRetentionPolicy',
    'ManagedDatabasePointInTimeRestore',
    'ManagedInstanceAzureActiveDirectoryAdministrator',
    'ManagedInstanceFailoverGroupPartnerRegion',
    'ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy',
    'ManagedInstanceIdentity',
    'ManagedInstanceVulnerabilityAssessmentRecurringScans',
    'ServerAzureadAdministrator',
    'ServerIdentity',
    'ServerVulnerabilityAssessmentRecurringScans',
    'VirtualMachineAssessment',
    'VirtualMachineAssessmentSchedule',
    'VirtualMachineAutoBackup',
    'VirtualMachineAutoBackupManualSchedule',
    'VirtualMachineAutoPatching',
    'VirtualMachineAvailabilityGroupListenerLoadBalancerConfiguration',
    'VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration',
    'VirtualMachineAvailabilityGroupListenerReplica',
    'VirtualMachineGroupWsfcDomainProfile',
    'VirtualMachineKeyVaultCredential',
    'VirtualMachineSqlInstance',
    'VirtualMachineStorageConfiguration',
    'VirtualMachineStorageConfigurationDataSettings',
    'VirtualMachineStorageConfigurationLogSettings',
    'VirtualMachineStorageConfigurationTempDbSettings',
    'VirtualMachineWsfcDomainCredential',
    'GetDatabaseIdentityResult',
    'GetElasticPoolSkusResult',
    'GetManagedDatabaseLongTermRetentionPolicyResult',
    'GetManagedDatabasePointInTimeRestoreResult',
    'GetManagedInstanceIdentityResult',
    'GetServerIdentityResult',
]

@pulumi.output_type
class DatabaseIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Database.
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this SQL Database. Possible value is `UserAssigned`.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Database.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this SQL Database. Possible value is `UserAssigned`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DatabaseImport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administratorLogin":
            suggest = "administrator_login"
        elif key == "administratorLoginPassword":
            suggest = "administrator_login_password"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "storageKey":
            suggest = "storage_key"
        elif key == "storageKeyType":
            suggest = "storage_key_type"
        elif key == "storageUri":
            suggest = "storage_uri"
        elif key == "storageAccountId":
            suggest = "storage_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseImport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseImport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseImport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 administrator_login: builtins.str,
                 administrator_login_password: builtins.str,
                 authentication_type: builtins.str,
                 storage_key: builtins.str,
                 storage_key_type: builtins.str,
                 storage_uri: builtins.str,
                 storage_account_id: Optional[builtins.str] = None):
        """
        :param builtins.str administrator_login: Specifies the name of the SQL administrator.
        :param builtins.str administrator_login_password: Specifies the password of the SQL administrator.
        :param builtins.str authentication_type: Specifies the type of authentication used to access the server. Valid values are `SQL` or `ADPassword`.
        :param builtins.str storage_key: Specifies the access key for the storage account.
        :param builtins.str storage_key_type: Specifies the type of access key for the storage account. Valid values are `StorageAccessKey` or `SharedAccessKey`.
        :param builtins.str storage_uri: Specifies the blob URI of the .bacpac file.
        :param builtins.str storage_account_id: The resource id for the storage account used to store BACPAC file. If set, private endpoint connection will be created for the storage account. Must match storage account used for storage_uri parameter.
        """
        pulumi.set(__self__, "administrator_login", administrator_login)
        pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "storage_key", storage_key)
        pulumi.set(__self__, "storage_key_type", storage_key_type)
        pulumi.set(__self__, "storage_uri", storage_uri)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)

    @property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> builtins.str:
        """
        Specifies the name of the SQL administrator.
        """
        return pulumi.get(self, "administrator_login")

    @property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> builtins.str:
        """
        Specifies the password of the SQL administrator.
        """
        return pulumi.get(self, "administrator_login_password")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> builtins.str:
        """
        Specifies the type of authentication used to access the server. Valid values are `SQL` or `ADPassword`.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="storageKey")
    def storage_key(self) -> builtins.str:
        """
        Specifies the access key for the storage account.
        """
        return pulumi.get(self, "storage_key")

    @property
    @pulumi.getter(name="storageKeyType")
    def storage_key_type(self) -> builtins.str:
        """
        Specifies the type of access key for the storage account. Valid values are `StorageAccessKey` or `SharedAccessKey`.
        """
        return pulumi.get(self, "storage_key_type")

    @property
    @pulumi.getter(name="storageUri")
    def storage_uri(self) -> builtins.str:
        """
        Specifies the blob URI of the .bacpac file.
        """
        return pulumi.get(self, "storage_uri")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[builtins.str]:
        """
        The resource id for the storage account used to store BACPAC file. If set, private endpoint connection will be created for the storage account. Must match storage account used for storage_uri parameter.
        """
        return pulumi.get(self, "storage_account_id")


@pulumi.output_type
class DatabaseLongTermRetentionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immutableBackupsEnabled":
            suggest = "immutable_backups_enabled"
        elif key == "monthlyRetention":
            suggest = "monthly_retention"
        elif key == "weekOfYear":
            suggest = "week_of_year"
        elif key == "weeklyRetention":
            suggest = "weekly_retention"
        elif key == "yearlyRetention":
            suggest = "yearly_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseLongTermRetentionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseLongTermRetentionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseLongTermRetentionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immutable_backups_enabled: Optional[builtins.bool] = None,
                 monthly_retention: Optional[builtins.str] = None,
                 week_of_year: Optional[builtins.int] = None,
                 weekly_retention: Optional[builtins.str] = None,
                 yearly_retention: Optional[builtins.str] = None):
        """
        :param builtins.str monthly_retention: The monthly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 120 months. e.g. `P1Y`, `P1M`, `P4W` or `P30D`. Defaults to `PT0S`.
        :param builtins.int week_of_year: The week of year to take the yearly backup. Value has to be between `1` and `52`.
        :param builtins.str weekly_retention: The weekly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 520 weeks. e.g. `P1Y`, `P1M`, `P1W` or `P7D`. Defaults to `PT0S`.
        :param builtins.str yearly_retention: The yearly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 10 years. e.g. `P1Y`, `P12M`, `P52W` or `P365D`. Defaults to `PT0S`.
        """
        if immutable_backups_enabled is not None:
            pulumi.set(__self__, "immutable_backups_enabled", immutable_backups_enabled)
        if monthly_retention is not None:
            pulumi.set(__self__, "monthly_retention", monthly_retention)
        if week_of_year is not None:
            pulumi.set(__self__, "week_of_year", week_of_year)
        if weekly_retention is not None:
            pulumi.set(__self__, "weekly_retention", weekly_retention)
        if yearly_retention is not None:
            pulumi.set(__self__, "yearly_retention", yearly_retention)

    @property
    @pulumi.getter(name="immutableBackupsEnabled")
    def immutable_backups_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "immutable_backups_enabled")

    @property
    @pulumi.getter(name="monthlyRetention")
    def monthly_retention(self) -> Optional[builtins.str]:
        """
        The monthly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 120 months. e.g. `P1Y`, `P1M`, `P4W` or `P30D`. Defaults to `PT0S`.
        """
        return pulumi.get(self, "monthly_retention")

    @property
    @pulumi.getter(name="weekOfYear")
    def week_of_year(self) -> Optional[builtins.int]:
        """
        The week of year to take the yearly backup. Value has to be between `1` and `52`.
        """
        return pulumi.get(self, "week_of_year")

    @property
    @pulumi.getter(name="weeklyRetention")
    def weekly_retention(self) -> Optional[builtins.str]:
        """
        The weekly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 520 weeks. e.g. `P1Y`, `P1M`, `P1W` or `P7D`. Defaults to `PT0S`.
        """
        return pulumi.get(self, "weekly_retention")

    @property
    @pulumi.getter(name="yearlyRetention")
    def yearly_retention(self) -> Optional[builtins.str]:
        """
        The yearly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 10 years. e.g. `P1Y`, `P12M`, `P52W` or `P365D`. Defaults to `PT0S`.
        """
        return pulumi.get(self, "yearly_retention")


@pulumi.output_type
class DatabaseShortTermRetentionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionDays":
            suggest = "retention_days"
        elif key == "backupIntervalInHours":
            suggest = "backup_interval_in_hours"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseShortTermRetentionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseShortTermRetentionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseShortTermRetentionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_days: builtins.int,
                 backup_interval_in_hours: Optional[builtins.int] = None):
        """
        :param builtins.int retention_days: Point In Time Restore configuration. Value has to be between `1` and `35`.
        :param builtins.int backup_interval_in_hours: The hours between each differential backup. This is only applicable to live databases but not dropped databases. Value has to be `12` or `24`. Defaults to `12` hours.
        """
        pulumi.set(__self__, "retention_days", retention_days)
        if backup_interval_in_hours is not None:
            pulumi.set(__self__, "backup_interval_in_hours", backup_interval_in_hours)

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> builtins.int:
        """
        Point In Time Restore configuration. Value has to be between `1` and `35`.
        """
        return pulumi.get(self, "retention_days")

    @property
    @pulumi.getter(name="backupIntervalInHours")
    def backup_interval_in_hours(self) -> Optional[builtins.int]:
        """
        The hours between each differential backup. This is only applicable to live databases but not dropped databases. Value has to be `12` or `24`. Defaults to `12` hours.
        """
        return pulumi.get(self, "backup_interval_in_hours")


@pulumi.output_type
class DatabaseThreatDetectionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disabledAlerts":
            suggest = "disabled_alerts"
        elif key == "emailAccountAdmins":
            suggest = "email_account_admins"
        elif key == "emailAddresses":
            suggest = "email_addresses"
        elif key == "retentionDays":
            suggest = "retention_days"
        elif key == "storageAccountAccessKey":
            suggest = "storage_account_access_key"
        elif key == "storageEndpoint":
            suggest = "storage_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseThreatDetectionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseThreatDetectionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseThreatDetectionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled_alerts: Optional[Sequence[builtins.str]] = None,
                 email_account_admins: Optional[builtins.str] = None,
                 email_addresses: Optional[Sequence[builtins.str]] = None,
                 retention_days: Optional[builtins.int] = None,
                 state: Optional[builtins.str] = None,
                 storage_account_access_key: Optional[builtins.str] = None,
                 storage_endpoint: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] disabled_alerts: Specifies a list of alerts which should be disabled. Possible values include `Access_Anomaly`, `Sql_Injection` and `Sql_Injection_Vulnerability`.
        :param builtins.str email_account_admins: Should the account administrators be emailed when this alert is triggered? Possible values are `Enabled` or `Disabled`. Defaults to `Disabled`.
        :param Sequence[builtins.str] email_addresses: A list of email addresses which alerts should be sent to.
        :param builtins.int retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
        :param builtins.str state: The State of the Policy. Possible values are `Enabled` or `Disabled`. Defaults to `Disabled`.
        :param builtins.str storage_account_access_key: Specifies the identifier key of the Threat Detection audit storage account. Required if `state` is `Enabled`.
        :param builtins.str storage_endpoint: Specifies the blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all Threat Detection audit logs. Required if `state` is `Enabled`.
        """
        if disabled_alerts is not None:
            pulumi.set(__self__, "disabled_alerts", disabled_alerts)
        if email_account_admins is not None:
            pulumi.set(__self__, "email_account_admins", email_account_admins)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_endpoint is not None:
            pulumi.set(__self__, "storage_endpoint", storage_endpoint)

    @property
    @pulumi.getter(name="disabledAlerts")
    def disabled_alerts(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of alerts which should be disabled. Possible values include `Access_Anomaly`, `Sql_Injection` and `Sql_Injection_Vulnerability`.
        """
        return pulumi.get(self, "disabled_alerts")

    @property
    @pulumi.getter(name="emailAccountAdmins")
    def email_account_admins(self) -> Optional[builtins.str]:
        """
        Should the account administrators be emailed when this alert is triggered? Possible values are `Enabled` or `Disabled`. Defaults to `Disabled`.
        """
        return pulumi.get(self, "email_account_admins")

    @property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of email addresses which alerts should be sent to.
        """
        return pulumi.get(self, "email_addresses")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[builtins.int]:
        """
        Specifies the number of days to keep in the Threat Detection audit logs.
        """
        return pulumi.get(self, "retention_days")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The State of the Policy. Possible values are `Enabled` or `Disabled`. Defaults to `Disabled`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[builtins.str]:
        """
        Specifies the identifier key of the Threat Detection audit storage account. Required if `state` is `Enabled`.
        """
        return pulumi.get(self, "storage_account_access_key")

    @property
    @pulumi.getter(name="storageEndpoint")
    def storage_endpoint(self) -> Optional[builtins.str]:
        """
        Specifies the blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all Threat Detection audit logs. Required if `state` is `Enabled`.
        """
        return pulumi.get(self, "storage_endpoint")


@pulumi.output_type
class DatabaseVulnerabilityAssessmentRuleBaselineBaselineResult(dict):
    def __init__(__self__, *,
                 results: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] results: A list representing a result of the baseline.
        """
        pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter
    def results(self) -> Sequence[builtins.str]:
        """
        A list representing a result of the baseline.
        """
        return pulumi.get(self, "results")


@pulumi.output_type
class ElasticPoolPerDatabaseSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElasticPoolPerDatabaseSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElasticPoolPerDatabaseSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElasticPoolPerDatabaseSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: builtins.float,
                 min_capacity: builtins.float):
        """
        :param builtins.float max_capacity: The maximum capacity any one database can consume.
        :param builtins.float min_capacity: The minimum capacity all databases are guaranteed.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> builtins.float:
        """
        The maximum capacity any one database can consume.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> builtins.float:
        """
        The minimum capacity all databases are guaranteed.
        """
        return pulumi.get(self, "min_capacity")


@pulumi.output_type
class ElasticPoolSku(dict):
    def __init__(__self__, *,
                 capacity: builtins.int,
                 name: builtins.str,
                 tier: builtins.str,
                 family: Optional[builtins.str] = None):
        """
        :param builtins.int capacity: The scale up/out capacity, representing server's compute units. For more information see the documentation for your Elasticpool configuration: [vCore-based](https://docs.microsoft.com/azure/sql-database/sql-database-vcore-resource-limits-elastic-pools) or [DTU-based](https://docs.microsoft.com/azure/sql-database/sql-database-dtu-resource-limits-elastic-pools).
        :param builtins.str name: Specifies the SKU Name for this Elasticpool. The name of the SKU, will be either `vCore` based or `DTU` based. Possible `DTU` based values are `BasicPool`, `StandardPool`, `PremiumPool` while possible `vCore` based values are `GP_Gen4`, `GP_Gen5`, `GP_Fsv2`, `GP_DC`, `BC_Gen4`, `BC_Gen5`, `BC_DC`, `HS_PRMS`, `HS_MOPRMS`, or `HS_Gen5`.
        :param builtins.str tier: The tier of the particular SKU. Possible values are `GeneralPurpose`, `BusinessCritical`, `Basic`, `Standard`, `Premium`, or `HyperScale`. For more information see the documentation for your Elasticpool configuration: [vCore-based](https://docs.microsoft.com/azure/sql-database/sql-database-vcore-resource-limits-elastic-pools) or [DTU-based](https://docs.microsoft.com/azure/sql-database/sql-database-dtu-resource-limits-elastic-pools).
        :param builtins.str family: The `family` of hardware `Gen4`, `Gen5`, `Fsv2`, `MOPRMS`, `PRMS`, or `DC`.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)
        if family is not None:
            pulumi.set(__self__, "family", family)

    @property
    @pulumi.getter
    def capacity(self) -> builtins.int:
        """
        The scale up/out capacity, representing server's compute units. For more information see the documentation for your Elasticpool configuration: [vCore-based](https://docs.microsoft.com/azure/sql-database/sql-database-vcore-resource-limits-elastic-pools) or [DTU-based](https://docs.microsoft.com/azure/sql-database/sql-database-dtu-resource-limits-elastic-pools).
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specifies the SKU Name for this Elasticpool. The name of the SKU, will be either `vCore` based or `DTU` based. Possible `DTU` based values are `BasicPool`, `StandardPool`, `PremiumPool` while possible `vCore` based values are `GP_Gen4`, `GP_Gen5`, `GP_Fsv2`, `GP_DC`, `BC_Gen4`, `BC_Gen5`, `BC_DC`, `HS_PRMS`, `HS_MOPRMS`, or `HS_Gen5`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> builtins.str:
        """
        The tier of the particular SKU. Possible values are `GeneralPurpose`, `BusinessCritical`, `Basic`, `Standard`, `Premium`, or `HyperScale`. For more information see the documentation for your Elasticpool configuration: [vCore-based](https://docs.microsoft.com/azure/sql-database/sql-database-vcore-resource-limits-elastic-pools) or [DTU-based](https://docs.microsoft.com/azure/sql-database/sql-database-dtu-resource-limits-elastic-pools).
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def family(self) -> Optional[builtins.str]:
        """
        The `family` of hardware `Gen4`, `Gen5`, `Fsv2`, `MOPRMS`, `PRMS`, or `DC`.
        """
        return pulumi.get(self, "family")


@pulumi.output_type
class FailoverGroupPartnerServer(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 location: Optional[builtins.str] = None,
                 role: Optional[builtins.str] = None):
        """
        :param builtins.str id: The ID of a partner SQL server to include in the failover group.
        :param builtins.str location: The location of the partner server.
        :param builtins.str role: The replication role of the partner server. Possible values include `Primary` or `Secondary`.
        """
        pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of a partner SQL server to include in the failover group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        The location of the partner server.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def role(self) -> Optional[builtins.str]:
        """
        The replication role of the partner server. Possible values include `Primary` or `Secondary`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class FailoverGroupReadWriteEndpointFailoverPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "graceMinutes":
            suggest = "grace_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FailoverGroupReadWriteEndpointFailoverPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FailoverGroupReadWriteEndpointFailoverPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FailoverGroupReadWriteEndpointFailoverPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: builtins.str,
                 grace_minutes: Optional[builtins.int] = None):
        """
        :param builtins.str mode: The failover policy of the read-write endpoint for the failover group. Possible values are `Automatic` or `Manual`.
        :param builtins.int grace_minutes: The grace period in minutes, before failover with data loss is attempted for the read-write endpoint. Required when `mode` is `Automatic`.
        """
        pulumi.set(__self__, "mode", mode)
        if grace_minutes is not None:
            pulumi.set(__self__, "grace_minutes", grace_minutes)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The failover policy of the read-write endpoint for the failover group. Possible values are `Automatic` or `Manual`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="graceMinutes")
    def grace_minutes(self) -> Optional[builtins.int]:
        """
        The grace period in minutes, before failover with data loss is attempted for the read-write endpoint. Required when `mode` is `Automatic`.
        """
        return pulumi.get(self, "grace_minutes")


@pulumi.output_type
class JobAgentIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobAgentIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobAgentIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobAgentIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to assign to this Elastic Job Agent.
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Elastic Job Agent. Currently only `UserAssigned` is supported.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        Specifies a list of User Assigned Managed Identity IDs to assign to this Elastic Job Agent.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Elastic Job Agent. Currently only `UserAssigned` is supported.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobStepOutputTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobCredentialId":
            suggest = "job_credential_id"
        elif key == "mssqlDatabaseId":
            suggest = "mssql_database_id"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "schemaName":
            suggest = "schema_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStepOutputTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStepOutputTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStepOutputTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_credential_id: builtins.str,
                 mssql_database_id: builtins.str,
                 table_name: builtins.str,
                 schema_name: Optional[builtins.str] = None):
        """
        :param builtins.str job_credential_id: The ID of the Elastic Job Credential to use when connecting to the output destination.
        :param builtins.str mssql_database_id: The ID of the output database.
        :param builtins.str table_name: The name of the output table.
        :param builtins.str schema_name: The name of the output schema. Defaults to `dbo`.
        """
        pulumi.set(__self__, "job_credential_id", job_credential_id)
        pulumi.set(__self__, "mssql_database_id", mssql_database_id)
        pulumi.set(__self__, "table_name", table_name)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter(name="jobCredentialId")
    def job_credential_id(self) -> builtins.str:
        """
        The ID of the Elastic Job Credential to use when connecting to the output destination.
        """
        return pulumi.get(self, "job_credential_id")

    @property
    @pulumi.getter(name="mssqlDatabaseId")
    def mssql_database_id(self) -> builtins.str:
        """
        The ID of the output database.
        """
        return pulumi.get(self, "mssql_database_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        The name of the output table.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[builtins.str]:
        """
        The name of the output schema. Defaults to `dbo`.
        """
        return pulumi.get(self, "schema_name")


@pulumi.output_type
class JobTargetGroupJobTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverName":
            suggest = "server_name"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "elasticPoolName":
            suggest = "elastic_pool_name"
        elif key == "jobCredentialId":
            suggest = "job_credential_id"
        elif key == "membershipType":
            suggest = "membership_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTargetGroupJobTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTargetGroupJobTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTargetGroupJobTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_name: builtins.str,
                 database_name: Optional[builtins.str] = None,
                 elastic_pool_name: Optional[builtins.str] = None,
                 job_credential_id: Optional[builtins.str] = None,
                 membership_type: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str server_name: The name of the MS SQL Server.
        :param builtins.str database_name: The name of the MS SQL Database.
               
               > **Note:** This cannot be set in combination with `elastic_pool_name`.
        :param builtins.str elastic_pool_name: The name of the MS SQL Elastic Pool.
               
               > **Note:** This cannot be set in combination with `database_name`.
        :param builtins.str job_credential_id: The ID of the job credential to use during execution of jobs.
               
               > **Note:** This is required when `membership_type` is `Include`, unless `database_name` is set.
        :param builtins.str membership_type: The membership type for this job target. Possible values are `Include` and `Exclude`. Defaults to `Include`.
        :param builtins.str type: The job target type. This value is computed based on `server_name`, `database_name`, and `elastic_pool_name`.
        """
        pulumi.set(__self__, "server_name", server_name)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if elastic_pool_name is not None:
            pulumi.set(__self__, "elastic_pool_name", elastic_pool_name)
        if job_credential_id is not None:
            pulumi.set(__self__, "job_credential_id", job_credential_id)
        if membership_type is not None:
            pulumi.set(__self__, "membership_type", membership_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> builtins.str:
        """
        The name of the MS SQL Server.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[builtins.str]:
        """
        The name of the MS SQL Database.

        > **Note:** This cannot be set in combination with `elastic_pool_name`.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="elasticPoolName")
    def elastic_pool_name(self) -> Optional[builtins.str]:
        """
        The name of the MS SQL Elastic Pool.

        > **Note:** This cannot be set in combination with `database_name`.
        """
        return pulumi.get(self, "elastic_pool_name")

    @property
    @pulumi.getter(name="jobCredentialId")
    def job_credential_id(self) -> Optional[builtins.str]:
        """
        The ID of the job credential to use during execution of jobs.

        > **Note:** This is required when `membership_type` is `Include`, unless `database_name` is set.
        """
        return pulumi.get(self, "job_credential_id")

    @property
    @pulumi.getter(name="membershipType")
    def membership_type(self) -> Optional[builtins.str]:
        """
        The membership type for this job target. Possible values are `Include` and `Exclude`. Defaults to `Include`.
        """
        return pulumi.get(self, "membership_type")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The job target type. This value is computed based on `server_name`, `database_name`, and `elastic_pool_name`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ManagedDatabaseLongTermRetentionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immutableBackupsEnabled":
            suggest = "immutable_backups_enabled"
        elif key == "monthlyRetention":
            suggest = "monthly_retention"
        elif key == "weekOfYear":
            suggest = "week_of_year"
        elif key == "weeklyRetention":
            suggest = "weekly_retention"
        elif key == "yearlyRetention":
            suggest = "yearly_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseLongTermRetentionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseLongTermRetentionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseLongTermRetentionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immutable_backups_enabled: Optional[builtins.bool] = None,
                 monthly_retention: Optional[builtins.str] = None,
                 week_of_year: Optional[builtins.int] = None,
                 weekly_retention: Optional[builtins.str] = None,
                 yearly_retention: Optional[builtins.str] = None):
        """
        :param builtins.str monthly_retention: The monthly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 120 months. e.g. `P1Y`, `P1M`, `P4W` or `P30D`. Defaults to `PT0S`.
        :param builtins.int week_of_year: The week of year to take the yearly backup. Value has to be between `1` and `52`.
        :param builtins.str weekly_retention: The weekly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 520 weeks. e.g. `P1Y`, `P1M`, `P1W` or `P7D`. Defaults to `PT0S`.
        :param builtins.str yearly_retention: The yearly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 10 years. e.g. `P1Y`, `P12M`, `P52W` or `P365D`. Defaults to `PT0S`.
        """
        if immutable_backups_enabled is not None:
            pulumi.set(__self__, "immutable_backups_enabled", immutable_backups_enabled)
        if monthly_retention is not None:
            pulumi.set(__self__, "monthly_retention", monthly_retention)
        if week_of_year is not None:
            pulumi.set(__self__, "week_of_year", week_of_year)
        if weekly_retention is not None:
            pulumi.set(__self__, "weekly_retention", weekly_retention)
        if yearly_retention is not None:
            pulumi.set(__self__, "yearly_retention", yearly_retention)

    @property
    @pulumi.getter(name="immutableBackupsEnabled")
    def immutable_backups_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "immutable_backups_enabled")

    @property
    @pulumi.getter(name="monthlyRetention")
    def monthly_retention(self) -> Optional[builtins.str]:
        """
        The monthly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 120 months. e.g. `P1Y`, `P1M`, `P4W` or `P30D`. Defaults to `PT0S`.
        """
        return pulumi.get(self, "monthly_retention")

    @property
    @pulumi.getter(name="weekOfYear")
    def week_of_year(self) -> Optional[builtins.int]:
        """
        The week of year to take the yearly backup. Value has to be between `1` and `52`.
        """
        return pulumi.get(self, "week_of_year")

    @property
    @pulumi.getter(name="weeklyRetention")
    def weekly_retention(self) -> Optional[builtins.str]:
        """
        The weekly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 520 weeks. e.g. `P1Y`, `P1M`, `P1W` or `P7D`. Defaults to `PT0S`.
        """
        return pulumi.get(self, "weekly_retention")

    @property
    @pulumi.getter(name="yearlyRetention")
    def yearly_retention(self) -> Optional[builtins.str]:
        """
        The yearly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 10 years. e.g. `P1Y`, `P12M`, `P52W` or `P365D`. Defaults to `PT0S`.
        """
        return pulumi.get(self, "yearly_retention")


@pulumi.output_type
class ManagedDatabasePointInTimeRestore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restorePointInTime":
            suggest = "restore_point_in_time"
        elif key == "sourceDatabaseId":
            suggest = "source_database_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabasePointInTimeRestore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabasePointInTimeRestore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabasePointInTimeRestore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 restore_point_in_time: builtins.str,
                 source_database_id: builtins.str):
        """
        :param builtins.str restore_point_in_time: The point in time for the restore from `source_database_id`. Changing this forces a new resource to be created.
        :param builtins.str source_database_id: The source database id that will be used to restore from. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "restore_point_in_time", restore_point_in_time)
        pulumi.set(__self__, "source_database_id", source_database_id)

    @property
    @pulumi.getter(name="restorePointInTime")
    def restore_point_in_time(self) -> builtins.str:
        """
        The point in time for the restore from `source_database_id`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "restore_point_in_time")

    @property
    @pulumi.getter(name="sourceDatabaseId")
    def source_database_id(self) -> builtins.str:
        """
        The source database id that will be used to restore from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_database_id")


@pulumi.output_type
class ManagedInstanceAzureActiveDirectoryAdministrator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loginUsername":
            suggest = "login_username"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "principalType":
            suggest = "principal_type"
        elif key == "azureadAuthenticationOnlyEnabled":
            suggest = "azuread_authentication_only_enabled"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceAzureActiveDirectoryAdministrator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceAzureActiveDirectoryAdministrator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceAzureActiveDirectoryAdministrator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 login_username: builtins.str,
                 object_id: builtins.str,
                 principal_type: builtins.str,
                 azuread_authentication_only_enabled: Optional[builtins.bool] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str login_username: The login username of the Azure AD Administrator of this SQL Managed Instance.
        :param builtins.str object_id: The object id of the Azure AD Administrator of this SQL Managed Instance.
        :param builtins.str principal_type: The principal type of the Azure AD Administrator of this SQL Managed Instance. Possible values are `Application`, `Group`, `User`.
        :param builtins.bool azuread_authentication_only_enabled: Specifies whether only Azure AD authentication can be used to log in to this SQL Managed Instance. When `true`, the `administrator_login` and `administrator_login_password` properties can be omitted. Defaults to `false`.
        :param builtins.str tenant_id: The tenant id of the Azure AD Administrator of this SQL Managed Instance. Should be specified if the Azure AD Administrator is homed in a different tenant to the SQL Managed Instance.
        """
        pulumi.set(__self__, "login_username", login_username)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "principal_type", principal_type)
        if azuread_authentication_only_enabled is not None:
            pulumi.set(__self__, "azuread_authentication_only_enabled", azuread_authentication_only_enabled)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="loginUsername")
    def login_username(self) -> builtins.str:
        """
        The login username of the Azure AD Administrator of this SQL Managed Instance.
        """
        return pulumi.get(self, "login_username")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> builtins.str:
        """
        The object id of the Azure AD Administrator of this SQL Managed Instance.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> builtins.str:
        """
        The principal type of the Azure AD Administrator of this SQL Managed Instance. Possible values are `Application`, `Group`, `User`.
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="azureadAuthenticationOnlyEnabled")
    def azuread_authentication_only_enabled(self) -> Optional[builtins.bool]:
        """
        Specifies whether only Azure AD authentication can be used to log in to this SQL Managed Instance. When `true`, the `administrator_login` and `administrator_login_password` properties can be omitted. Defaults to `false`.
        """
        return pulumi.get(self, "azuread_authentication_only_enabled")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The tenant id of the Azure AD Administrator of this SQL Managed Instance. Should be specified if the Azure AD Administrator is homed in a different tenant to the SQL Managed Instance.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ManagedInstanceFailoverGroupPartnerRegion(dict):
    def __init__(__self__, *,
                 location: Optional[builtins.str] = None,
                 role: Optional[builtins.str] = None):
        """
        :param builtins.str location: The Azure Region where the Managed Instance Failover Group should exist. Changing this forces a new resource to be created.
        :param builtins.str role: The partner replication role of the Managed Instance Failover Group.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        """
        The Azure Region where the Managed Instance Failover Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def role(self) -> Optional[builtins.str]:
        """
        The partner replication role of the Managed Instance Failover Group.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "graceMinutes":
            suggest = "grace_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: builtins.str,
                 grace_minutes: Optional[builtins.int] = None):
        """
        :param builtins.str mode: The failover mode. Possible values are `Automatic` or `Manual`.
        :param builtins.int grace_minutes: Applies only if `mode` is `Automatic`. The grace period in minutes before failover with data loss is attempted.
        """
        pulumi.set(__self__, "mode", mode)
        if grace_minutes is not None:
            pulumi.set(__self__, "grace_minutes", grace_minutes)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The failover mode. Possible values are `Automatic` or `Manual`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="graceMinutes")
    def grace_minutes(self) -> Optional[builtins.int]:
        """
        Applies only if `mode` is `Automatic`. The grace period in minutes before failover with data loss is attempted.
        """
        return pulumi.get(self, "grace_minutes")


@pulumi.output_type
class ManagedInstanceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this SQL Managed Instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned`.
        :param Sequence[builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Managed Instance. Required when `type` includes `UserAssigned`.
               
               > **Note:** The assigned `principal_id` and `tenant_id` can be retrieved after the identity `type` has been set to `SystemAssigned` and SQL Managed Instance has been created.
        :param builtins.str principal_id: The Principal ID for the Service Principal associated with the Identity of this SQL Managed Instance.
        :param builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Identity of this SQL Managed Instance.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this SQL Managed Instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Managed Instance. Required when `type` includes `UserAssigned`.

        > **Note:** The assigned `principal_id` and `tenant_id` can be retrieved after the identity `type` has been set to `SystemAssigned` and SQL Managed Instance has been created.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Identity of this SQL Managed Instance.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Identity of this SQL Managed Instance.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ManagedInstanceVulnerabilityAssessmentRecurringScans(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailSubscriptionAdmins":
            suggest = "email_subscription_admins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceVulnerabilityAssessmentRecurringScans. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceVulnerabilityAssessmentRecurringScans.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceVulnerabilityAssessmentRecurringScans.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_subscription_admins: Optional[builtins.bool] = None,
                 emails: Optional[Sequence[builtins.str]] = None,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool email_subscription_admins: Boolean flag which specifies if the schedule scan notification will be sent to the subscription administrators. Defaults to `true`.
        :param Sequence[builtins.str] emails: Specifies an array of e-mail addresses to which the scan notification is sent.
        :param builtins.bool enabled: Boolean flag which specifies if recurring scans is enabled or disabled. Defaults to `false`.
        """
        if email_subscription_admins is not None:
            pulumi.set(__self__, "email_subscription_admins", email_subscription_admins)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="emailSubscriptionAdmins")
    def email_subscription_admins(self) -> Optional[builtins.bool]:
        """
        Boolean flag which specifies if the schedule scan notification will be sent to the subscription administrators. Defaults to `true`.
        """
        return pulumi.get(self, "email_subscription_admins")

    @property
    @pulumi.getter
    def emails(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies an array of e-mail addresses to which the scan notification is sent.
        """
        return pulumi.get(self, "emails")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Boolean flag which specifies if recurring scans is enabled or disabled. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ServerAzureadAdministrator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loginUsername":
            suggest = "login_username"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "azureadAuthenticationOnly":
            suggest = "azuread_authentication_only"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerAzureadAdministrator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerAzureadAdministrator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerAzureadAdministrator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 login_username: builtins.str,
                 object_id: builtins.str,
                 azuread_authentication_only: Optional[builtins.bool] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str login_username: The login username of the Azure AD Administrator of this SQL Server.
        :param builtins.str object_id: The object id of the Azure AD Administrator of this SQL Server.
        :param builtins.bool azuread_authentication_only: Specifies whether only AD Users and administrators (e.g. `azuread_administrator[0].login_username`) can be used to login, or also local database users (e.g. `administrator_login`). When `true`, the `administrator_login` and `administrator_login_password` properties can be omitted.
        :param builtins.str tenant_id: The tenant id of the Azure AD Administrator of this SQL Server.
        """
        pulumi.set(__self__, "login_username", login_username)
        pulumi.set(__self__, "object_id", object_id)
        if azuread_authentication_only is not None:
            pulumi.set(__self__, "azuread_authentication_only", azuread_authentication_only)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="loginUsername")
    def login_username(self) -> builtins.str:
        """
        The login username of the Azure AD Administrator of this SQL Server.
        """
        return pulumi.get(self, "login_username")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> builtins.str:
        """
        The object id of the Azure AD Administrator of this SQL Server.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="azureadAuthenticationOnly")
    def azuread_authentication_only(self) -> Optional[builtins.bool]:
        """
        Specifies whether only AD Users and administrators (e.g. `azuread_administrator[0].login_username`) can be used to login, or also local database users (e.g. `administrator_login`). When `true`, the `administrator_login` and `administrator_login_password` properties can be omitted.
        """
        return pulumi.get(self, "azuread_authentication_only")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The tenant id of the Azure AD Administrator of this SQL Server.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ServerIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this SQL Server. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Server.
               
               > **Note:** This is required when `type` is set to `UserAssigned`
               
               > **Note:** When `type` is set to `SystemAssigned`, the assigned `principal_id` and `tenant_id` can be retrieved after the Microsoft SQL Server has been created. More details are available below.
        :param builtins.str principal_id: The Principal ID for the Service Principal associated with the Identity of this SQL Server.
        :param builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Identity of this SQL Server.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this SQL Server. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Server.

        > **Note:** This is required when `type` is set to `UserAssigned`

        > **Note:** When `type` is set to `SystemAssigned`, the assigned `principal_id` and `tenant_id` can be retrieved after the Microsoft SQL Server has been created. More details are available below.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Identity of this SQL Server.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Identity of this SQL Server.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ServerVulnerabilityAssessmentRecurringScans(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailSubscriptionAdmins":
            suggest = "email_subscription_admins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerVulnerabilityAssessmentRecurringScans. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerVulnerabilityAssessmentRecurringScans.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerVulnerabilityAssessmentRecurringScans.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_subscription_admins: Optional[builtins.bool] = None,
                 emails: Optional[Sequence[builtins.str]] = None,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool email_subscription_admins: Boolean flag which specifies if the schedule scan notification will be sent to the subscription administrators. Defaults to `false`.
        :param Sequence[builtins.str] emails: Specifies an array of email addresses to which the scan notification is sent.
        :param builtins.bool enabled: Boolean flag which specifies if recurring scans is enabled or disabled. Defaults to `false`.
        """
        if email_subscription_admins is not None:
            pulumi.set(__self__, "email_subscription_admins", email_subscription_admins)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="emailSubscriptionAdmins")
    def email_subscription_admins(self) -> Optional[builtins.bool]:
        """
        Boolean flag which specifies if the schedule scan notification will be sent to the subscription administrators. Defaults to `false`.
        """
        return pulumi.get(self, "email_subscription_admins")

    @property
    @pulumi.getter
    def emails(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies an array of email addresses to which the scan notification is sent.
        """
        return pulumi.get(self, "emails")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Boolean flag which specifies if recurring scans is enabled or disabled. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class VirtualMachineAssessment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runImmediately":
            suggest = "run_immediately"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineAssessment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineAssessment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineAssessment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 run_immediately: Optional[builtins.bool] = None,
                 schedule: Optional['outputs.VirtualMachineAssessmentSchedule'] = None):
        """
        :param builtins.bool enabled: Should Assessment be enabled? Defaults to `true`.
        :param builtins.bool run_immediately: Should Assessment be run immediately? Defaults to `false`.
        :param 'VirtualMachineAssessmentScheduleArgs' schedule: An `schedule` block as defined below.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if run_immediately is not None:
            pulumi.set(__self__, "run_immediately", run_immediately)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Should Assessment be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="runImmediately")
    def run_immediately(self) -> Optional[builtins.bool]:
        """
        Should Assessment be run immediately? Defaults to `false`.
        """
        return pulumi.get(self, "run_immediately")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.VirtualMachineAssessmentSchedule']:
        """
        An `schedule` block as defined below.
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class VirtualMachineAssessmentSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "monthlyOccurrence":
            suggest = "monthly_occurrence"
        elif key == "weeklyInterval":
            suggest = "weekly_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineAssessmentSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineAssessmentSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineAssessmentSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: builtins.str,
                 start_time: builtins.str,
                 monthly_occurrence: Optional[builtins.int] = None,
                 weekly_interval: Optional[builtins.int] = None):
        """
        :param builtins.str day_of_week: What day of the week the assessment will be run. Possible values are `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday` and `Wednesday`.
        :param builtins.str start_time: What time the assessment will be run. Must be in the format `HH:mm`.
        :param builtins.int monthly_occurrence: How many months between assessment runs. Valid values are between `1` and `5`.
               
               > **Note:** Either one of `weekly_interval` or `monthly_occurrence` must be specified.
        :param builtins.int weekly_interval: How many weeks between assessment runs. Valid values are between `1` and `6`.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "start_time", start_time)
        if monthly_occurrence is not None:
            pulumi.set(__self__, "monthly_occurrence", monthly_occurrence)
        if weekly_interval is not None:
            pulumi.set(__self__, "weekly_interval", weekly_interval)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> builtins.str:
        """
        What day of the week the assessment will be run. Possible values are `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday` and `Wednesday`.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.str:
        """
        What time the assessment will be run. Must be in the format `HH:mm`.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="monthlyOccurrence")
    def monthly_occurrence(self) -> Optional[builtins.int]:
        """
        How many months between assessment runs. Valid values are between `1` and `5`.

        > **Note:** Either one of `weekly_interval` or `monthly_occurrence` must be specified.
        """
        return pulumi.get(self, "monthly_occurrence")

    @property
    @pulumi.getter(name="weeklyInterval")
    def weekly_interval(self) -> Optional[builtins.int]:
        """
        How many weeks between assessment runs. Valid values are between `1` and `6`.
        """
        return pulumi.get(self, "weekly_interval")


@pulumi.output_type
class VirtualMachineAutoBackup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPeriodInDays":
            suggest = "retention_period_in_days"
        elif key == "storageAccountAccessKey":
            suggest = "storage_account_access_key"
        elif key == "storageBlobEndpoint":
            suggest = "storage_blob_endpoint"
        elif key == "encryptionEnabled":
            suggest = "encryption_enabled"
        elif key == "encryptionPassword":
            suggest = "encryption_password"
        elif key == "manualSchedule":
            suggest = "manual_schedule"
        elif key == "systemDatabasesBackupEnabled":
            suggest = "system_databases_backup_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineAutoBackup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineAutoBackup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineAutoBackup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_period_in_days: builtins.int,
                 storage_account_access_key: builtins.str,
                 storage_blob_endpoint: builtins.str,
                 encryption_enabled: Optional[builtins.bool] = None,
                 encryption_password: Optional[builtins.str] = None,
                 manual_schedule: Optional['outputs.VirtualMachineAutoBackupManualSchedule'] = None,
                 system_databases_backup_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.int retention_period_in_days: Retention period of backups, in days. Valid values are from `1` to `30`.
        :param builtins.str storage_account_access_key: Access key for the storage account where backups will be kept.
        :param builtins.str storage_blob_endpoint: Blob endpoint for the storage account where backups will be kept.
        :param builtins.str encryption_password: Encryption password to use. Setting a password will enable encryption.
        :param 'VirtualMachineAutoBackupManualScheduleArgs' manual_schedule: A `manual_schedule` block as documented below. When this block is present, the schedule type is set to `Manual`. Without this block, the schedule type is set to `Automated`.
        :param builtins.bool system_databases_backup_enabled: Include or exclude system databases from auto backup.
        """
        pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        pulumi.set(__self__, "storage_blob_endpoint", storage_blob_endpoint)
        if encryption_enabled is not None:
            pulumi.set(__self__, "encryption_enabled", encryption_enabled)
        if encryption_password is not None:
            pulumi.set(__self__, "encryption_password", encryption_password)
        if manual_schedule is not None:
            pulumi.set(__self__, "manual_schedule", manual_schedule)
        if system_databases_backup_enabled is not None:
            pulumi.set(__self__, "system_databases_backup_enabled", system_databases_backup_enabled)

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> builtins.int:
        """
        Retention period of backups, in days. Valid values are from `1` to `30`.
        """
        return pulumi.get(self, "retention_period_in_days")

    @property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> builtins.str:
        """
        Access key for the storage account where backups will be kept.
        """
        return pulumi.get(self, "storage_account_access_key")

    @property
    @pulumi.getter(name="storageBlobEndpoint")
    def storage_blob_endpoint(self) -> builtins.str:
        """
        Blob endpoint for the storage account where backups will be kept.
        """
        return pulumi.get(self, "storage_blob_endpoint")

    @property
    @pulumi.getter(name="encryptionEnabled")
    @_utilities.deprecated("""`encryption_enabled` has been deprecated and will be removed in v5.0 of the AzureRM Provider. Encryption is enabled when `encryption_password` is set; otherwise disabled.""")
    def encryption_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "encryption_enabled")

    @property
    @pulumi.getter(name="encryptionPassword")
    def encryption_password(self) -> Optional[builtins.str]:
        """
        Encryption password to use. Setting a password will enable encryption.
        """
        return pulumi.get(self, "encryption_password")

    @property
    @pulumi.getter(name="manualSchedule")
    def manual_schedule(self) -> Optional['outputs.VirtualMachineAutoBackupManualSchedule']:
        """
        A `manual_schedule` block as documented below. When this block is present, the schedule type is set to `Manual`. Without this block, the schedule type is set to `Automated`.
        """
        return pulumi.get(self, "manual_schedule")

    @property
    @pulumi.getter(name="systemDatabasesBackupEnabled")
    def system_databases_backup_enabled(self) -> Optional[builtins.bool]:
        """
        Include or exclude system databases from auto backup.
        """
        return pulumi.get(self, "system_databases_backup_enabled")


@pulumi.output_type
class VirtualMachineAutoBackupManualSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fullBackupFrequency":
            suggest = "full_backup_frequency"
        elif key == "fullBackupStartHour":
            suggest = "full_backup_start_hour"
        elif key == "fullBackupWindowInHours":
            suggest = "full_backup_window_in_hours"
        elif key == "logBackupFrequencyInMinutes":
            suggest = "log_backup_frequency_in_minutes"
        elif key == "daysOfWeeks":
            suggest = "days_of_weeks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineAutoBackupManualSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineAutoBackupManualSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineAutoBackupManualSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 full_backup_frequency: builtins.str,
                 full_backup_start_hour: builtins.int,
                 full_backup_window_in_hours: builtins.int,
                 log_backup_frequency_in_minutes: builtins.int,
                 days_of_weeks: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str full_backup_frequency: Frequency of full backups. Valid values include `Daily` or `Weekly`.
        :param builtins.int full_backup_start_hour: Start hour of a given day during which full backups can take place. Valid values are from `0` to `23`.
        :param builtins.int full_backup_window_in_hours: Duration of the time window of a given day during which full backups can take place, in hours. Valid values are between `1` and `23`.
        :param builtins.int log_backup_frequency_in_minutes: Frequency of log backups, in minutes. Valid values are from `5` to `60`.
        :param Sequence[builtins.str] days_of_weeks: A list of days on which backup can take place. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`
               
               > **Note:** `days_of_week` can only be specified when `manual_schedule` is set to `Weekly`
        """
        pulumi.set(__self__, "full_backup_frequency", full_backup_frequency)
        pulumi.set(__self__, "full_backup_start_hour", full_backup_start_hour)
        pulumi.set(__self__, "full_backup_window_in_hours", full_backup_window_in_hours)
        pulumi.set(__self__, "log_backup_frequency_in_minutes", log_backup_frequency_in_minutes)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)

    @property
    @pulumi.getter(name="fullBackupFrequency")
    def full_backup_frequency(self) -> builtins.str:
        """
        Frequency of full backups. Valid values include `Daily` or `Weekly`.
        """
        return pulumi.get(self, "full_backup_frequency")

    @property
    @pulumi.getter(name="fullBackupStartHour")
    def full_backup_start_hour(self) -> builtins.int:
        """
        Start hour of a given day during which full backups can take place. Valid values are from `0` to `23`.
        """
        return pulumi.get(self, "full_backup_start_hour")

    @property
    @pulumi.getter(name="fullBackupWindowInHours")
    def full_backup_window_in_hours(self) -> builtins.int:
        """
        Duration of the time window of a given day during which full backups can take place, in hours. Valid values are between `1` and `23`.
        """
        return pulumi.get(self, "full_backup_window_in_hours")

    @property
    @pulumi.getter(name="logBackupFrequencyInMinutes")
    def log_backup_frequency_in_minutes(self) -> builtins.int:
        """
        Frequency of log backups, in minutes. Valid values are from `5` to `60`.
        """
        return pulumi.get(self, "log_backup_frequency_in_minutes")

    @property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of days on which backup can take place. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`

        > **Note:** `days_of_week` can only be specified when `manual_schedule` is set to `Weekly`
        """
        return pulumi.get(self, "days_of_weeks")


@pulumi.output_type
class VirtualMachineAutoPatching(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "maintenanceWindowDurationInMinutes":
            suggest = "maintenance_window_duration_in_minutes"
        elif key == "maintenanceWindowStartingHour":
            suggest = "maintenance_window_starting_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineAutoPatching. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineAutoPatching.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineAutoPatching.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: builtins.str,
                 maintenance_window_duration_in_minutes: builtins.int,
                 maintenance_window_starting_hour: builtins.int):
        """
        :param builtins.str day_of_week: The day of week to apply the patch on. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`.
        :param builtins.int maintenance_window_duration_in_minutes: The size of the Maintenance Window in minutes.
        :param builtins.int maintenance_window_starting_hour: The Hour, in the Virtual Machine Time-Zone when the patching maintenance window should begin.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "maintenance_window_duration_in_minutes", maintenance_window_duration_in_minutes)
        pulumi.set(__self__, "maintenance_window_starting_hour", maintenance_window_starting_hour)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> builtins.str:
        """
        The day of week to apply the patch on. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="maintenanceWindowDurationInMinutes")
    def maintenance_window_duration_in_minutes(self) -> builtins.int:
        """
        The size of the Maintenance Window in minutes.
        """
        return pulumi.get(self, "maintenance_window_duration_in_minutes")

    @property
    @pulumi.getter(name="maintenanceWindowStartingHour")
    def maintenance_window_starting_hour(self) -> builtins.int:
        """
        The Hour, in the Virtual Machine Time-Zone when the patching maintenance window should begin.
        """
        return pulumi.get(self, "maintenance_window_starting_hour")


@pulumi.output_type
class VirtualMachineAvailabilityGroupListenerLoadBalancerConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadBalancerId":
            suggest = "load_balancer_id"
        elif key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "probePort":
            suggest = "probe_port"
        elif key == "sqlVirtualMachineIds":
            suggest = "sql_virtual_machine_ids"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineAvailabilityGroupListenerLoadBalancerConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineAvailabilityGroupListenerLoadBalancerConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineAvailabilityGroupListenerLoadBalancerConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 load_balancer_id: builtins.str,
                 private_ip_address: builtins.str,
                 probe_port: builtins.int,
                 sql_virtual_machine_ids: Sequence[builtins.str],
                 subnet_id: builtins.str):
        """
        :param builtins.str load_balancer_id: The ID of the Load Balancer. Changing this forces a new resource to be created.
        :param builtins.str private_ip_address: The private IP Address of the listener. Changing this forces a new resource to be created.
        :param builtins.int probe_port: The probe port of the listener. Changing this forces a new resource to be created.
        :param Sequence[builtins.str] sql_virtual_machine_ids: Specifies a list of SQL Virtual Machine IDs. Changing this forces a new resource to be created.
        :param builtins.str subnet_id: The ID of the Subnet to create the listener. Changing this forces a new resource to be created.
               
               > **Note:** `sql_virtual_machine_ids` should match with the SQL Virtual Machines specified in `replica`.
        """
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "probe_port", probe_port)
        pulumi.set(__self__, "sql_virtual_machine_ids", sql_virtual_machine_ids)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> builtins.str:
        """
        The ID of the Load Balancer. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> builtins.str:
        """
        The private IP Address of the listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="probePort")
    def probe_port(self) -> builtins.int:
        """
        The probe port of the listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "probe_port")

    @property
    @pulumi.getter(name="sqlVirtualMachineIds")
    def sql_virtual_machine_ids(self) -> Sequence[builtins.str]:
        """
        Specifies a list of SQL Virtual Machine IDs. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_virtual_machine_ids")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The ID of the Subnet to create the listener. Changing this forces a new resource to be created.

        > **Note:** `sql_virtual_machine_ids` should match with the SQL Virtual Machines specified in `replica`.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "sqlVirtualMachineId":
            suggest = "sql_virtual_machine_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_ip_address: builtins.str,
                 sql_virtual_machine_id: builtins.str,
                 subnet_id: builtins.str):
        """
        :param builtins.str private_ip_address: The private IP Address of the listener. Changing this forces a new resource to be created.
        :param builtins.str sql_virtual_machine_id: The ID of the Sql Virtual Machine. Changing this forces a new resource to be created.
        :param builtins.str subnet_id: The ID of the Subnet to create the listener. Changing this forces a new resource to be created.
               
               > **Note:** `sql_virtual_machine_id` should match with the SQL Virtual Machines specified in `replica`.
        """
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "sql_virtual_machine_id", sql_virtual_machine_id)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> builtins.str:
        """
        The private IP Address of the listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="sqlVirtualMachineId")
    def sql_virtual_machine_id(self) -> builtins.str:
        """
        The ID of the Sql Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_virtual_machine_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The ID of the Subnet to create the listener. Changing this forces a new resource to be created.

        > **Note:** `sql_virtual_machine_id` should match with the SQL Virtual Machines specified in `replica`.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class VirtualMachineAvailabilityGroupListenerReplica(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverMode":
            suggest = "failover_mode"
        elif key == "readableSecondary":
            suggest = "readable_secondary"
        elif key == "sqlVirtualMachineId":
            suggest = "sql_virtual_machine_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineAvailabilityGroupListenerReplica. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineAvailabilityGroupListenerReplica.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineAvailabilityGroupListenerReplica.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commit: builtins.str,
                 failover_mode: builtins.str,
                 readable_secondary: builtins.str,
                 role: builtins.str,
                 sql_virtual_machine_id: builtins.str):
        """
        :param builtins.str commit: The replica commit mode for the availability group. Possible values are `Synchronous_Commit` and `Asynchronous_Commit`. Changing this forces a new resource to be created.
        :param builtins.str failover_mode: The replica failover mode for the availability group. Possible values are `Manual` and `Automatic`. Changing this forces a new resource to be created.
        :param builtins.str readable_secondary: The replica readable secondary mode for the availability group. Possible values are `No`, `Read_Only` and `All`. Changing this forces a new resource to be created.
        :param builtins.str role: The replica role for the availability group. Possible values are `Primary` and `Secondary`. Changing this forces a new resource to be created.
        :param builtins.str sql_virtual_machine_id: The ID of the SQL Virtual Machine. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "commit", commit)
        pulumi.set(__self__, "failover_mode", failover_mode)
        pulumi.set(__self__, "readable_secondary", readable_secondary)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "sql_virtual_machine_id", sql_virtual_machine_id)

    @property
    @pulumi.getter
    def commit(self) -> builtins.str:
        """
        The replica commit mode for the availability group. Possible values are `Synchronous_Commit` and `Asynchronous_Commit`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "commit")

    @property
    @pulumi.getter(name="failoverMode")
    def failover_mode(self) -> builtins.str:
        """
        The replica failover mode for the availability group. Possible values are `Manual` and `Automatic`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "failover_mode")

    @property
    @pulumi.getter(name="readableSecondary")
    def readable_secondary(self) -> builtins.str:
        """
        The replica readable secondary mode for the availability group. Possible values are `No`, `Read_Only` and `All`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "readable_secondary")

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        The replica role for the availability group. Possible values are `Primary` and `Secondary`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="sqlVirtualMachineId")
    def sql_virtual_machine_id(self) -> builtins.str:
        """
        The ID of the SQL Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_virtual_machine_id")


@pulumi.output_type
class VirtualMachineGroupWsfcDomainProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterSubnetType":
            suggest = "cluster_subnet_type"
        elif key == "clusterBootstrapAccountName":
            suggest = "cluster_bootstrap_account_name"
        elif key == "clusterOperatorAccountName":
            suggest = "cluster_operator_account_name"
        elif key == "organizationalUnitPath":
            suggest = "organizational_unit_path"
        elif key == "sqlServiceAccountName":
            suggest = "sql_service_account_name"
        elif key == "storageAccountPrimaryKey":
            suggest = "storage_account_primary_key"
        elif key == "storageAccountUrl":
            suggest = "storage_account_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineGroupWsfcDomainProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineGroupWsfcDomainProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineGroupWsfcDomainProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_subnet_type: builtins.str,
                 fqdn: builtins.str,
                 cluster_bootstrap_account_name: Optional[builtins.str] = None,
                 cluster_operator_account_name: Optional[builtins.str] = None,
                 organizational_unit_path: Optional[builtins.str] = None,
                 sql_service_account_name: Optional[builtins.str] = None,
                 storage_account_primary_key: Optional[builtins.str] = None,
                 storage_account_url: Optional[builtins.str] = None):
        """
        :param builtins.str cluster_subnet_type: The subnet type of the SQL Virtual Machine cluster. Possible values are `MultiSubnet` and `SingleSubnet`. Changing this forces a new resource to be created.
        :param builtins.str fqdn: The fully qualified name of the domain. Changing this forces a new resource to be created.
        :param builtins.str cluster_bootstrap_account_name: The account name used for creating cluster. Changing this forces a new resource to be created.
        :param builtins.str cluster_operator_account_name: The account name used for operating cluster. Changing this forces a new resource to be created.
        :param builtins.str organizational_unit_path: The organizational Unit path in which the nodes and cluster will be present. Changing this forces a new resource to be created.
        :param builtins.str sql_service_account_name: The account name under which SQL service will run on all participating SQL virtual machines in the cluster. Changing this forces a new resource to be created.
        :param builtins.str storage_account_primary_key: The primary key of the Storage Account.
        :param builtins.str storage_account_url: The SAS URL to the Storage Container of the witness storage account. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "cluster_subnet_type", cluster_subnet_type)
        pulumi.set(__self__, "fqdn", fqdn)
        if cluster_bootstrap_account_name is not None:
            pulumi.set(__self__, "cluster_bootstrap_account_name", cluster_bootstrap_account_name)
        if cluster_operator_account_name is not None:
            pulumi.set(__self__, "cluster_operator_account_name", cluster_operator_account_name)
        if organizational_unit_path is not None:
            pulumi.set(__self__, "organizational_unit_path", organizational_unit_path)
        if sql_service_account_name is not None:
            pulumi.set(__self__, "sql_service_account_name", sql_service_account_name)
        if storage_account_primary_key is not None:
            pulumi.set(__self__, "storage_account_primary_key", storage_account_primary_key)
        if storage_account_url is not None:
            pulumi.set(__self__, "storage_account_url", storage_account_url)

    @property
    @pulumi.getter(name="clusterSubnetType")
    def cluster_subnet_type(self) -> builtins.str:
        """
        The subnet type of the SQL Virtual Machine cluster. Possible values are `MultiSubnet` and `SingleSubnet`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_subnet_type")

    @property
    @pulumi.getter
    def fqdn(self) -> builtins.str:
        """
        The fully qualified name of the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="clusterBootstrapAccountName")
    def cluster_bootstrap_account_name(self) -> Optional[builtins.str]:
        """
        The account name used for creating cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_bootstrap_account_name")

    @property
    @pulumi.getter(name="clusterOperatorAccountName")
    def cluster_operator_account_name(self) -> Optional[builtins.str]:
        """
        The account name used for operating cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_operator_account_name")

    @property
    @pulumi.getter(name="organizationalUnitPath")
    def organizational_unit_path(self) -> Optional[builtins.str]:
        """
        The organizational Unit path in which the nodes and cluster will be present. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "organizational_unit_path")

    @property
    @pulumi.getter(name="sqlServiceAccountName")
    def sql_service_account_name(self) -> Optional[builtins.str]:
        """
        The account name under which SQL service will run on all participating SQL virtual machines in the cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_service_account_name")

    @property
    @pulumi.getter(name="storageAccountPrimaryKey")
    def storage_account_primary_key(self) -> Optional[builtins.str]:
        """
        The primary key of the Storage Account.
        """
        return pulumi.get(self, "storage_account_primary_key")

    @property
    @pulumi.getter(name="storageAccountUrl")
    def storage_account_url(self) -> Optional[builtins.str]:
        """
        The SAS URL to the Storage Container of the witness storage account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_url")


@pulumi.output_type
class VirtualMachineKeyVaultCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultUrl":
            suggest = "key_vault_url"
        elif key == "servicePrincipalName":
            suggest = "service_principal_name"
        elif key == "servicePrincipalSecret":
            suggest = "service_principal_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineKeyVaultCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineKeyVaultCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineKeyVaultCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_url: builtins.str,
                 name: builtins.str,
                 service_principal_name: builtins.str,
                 service_principal_secret: builtins.str):
        """
        :param builtins.str key_vault_url: The Azure Key Vault url. Changing this forces a new resource to be created.
        :param builtins.str name: The credential name.
        :param builtins.str service_principal_name: The service principal name to access key vault. Changing this forces a new resource to be created.
        :param builtins.str service_principal_secret: The service principal name secret to access key vault. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "key_vault_url", key_vault_url)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_principal_name", service_principal_name)
        pulumi.set(__self__, "service_principal_secret", service_principal_secret)

    @property
    @pulumi.getter(name="keyVaultUrl")
    def key_vault_url(self) -> builtins.str:
        """
        The Azure Key Vault url. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_url")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The credential name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="servicePrincipalName")
    def service_principal_name(self) -> builtins.str:
        """
        The service principal name to access key vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_principal_name")

    @property
    @pulumi.getter(name="servicePrincipalSecret")
    def service_principal_secret(self) -> builtins.str:
        """
        The service principal name secret to access key vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_principal_secret")


@pulumi.output_type
class VirtualMachineSqlInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adhocWorkloadsOptimizationEnabled":
            suggest = "adhoc_workloads_optimization_enabled"
        elif key == "instantFileInitializationEnabled":
            suggest = "instant_file_initialization_enabled"
        elif key == "lockPagesInMemoryEnabled":
            suggest = "lock_pages_in_memory_enabled"
        elif key == "maxDop":
            suggest = "max_dop"
        elif key == "maxServerMemoryMb":
            suggest = "max_server_memory_mb"
        elif key == "minServerMemoryMb":
            suggest = "min_server_memory_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineSqlInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineSqlInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineSqlInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adhoc_workloads_optimization_enabled: Optional[builtins.bool] = None,
                 collation: Optional[builtins.str] = None,
                 instant_file_initialization_enabled: Optional[builtins.bool] = None,
                 lock_pages_in_memory_enabled: Optional[builtins.bool] = None,
                 max_dop: Optional[builtins.int] = None,
                 max_server_memory_mb: Optional[builtins.int] = None,
                 min_server_memory_mb: Optional[builtins.int] = None):
        """
        :param builtins.bool adhoc_workloads_optimization_enabled: Specifies if the SQL Server is optimized for adhoc workloads. Possible values are `true` and `false`. Defaults to `false`.
        :param builtins.str collation: Collation of the SQL Server. Defaults to `SQL_Latin1_General_CP1_CI_AS`. Changing this forces a new resource to be created.
        :param builtins.bool instant_file_initialization_enabled: Specifies if Instant File Initialization is enabled for the SQL Server. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        :param builtins.bool lock_pages_in_memory_enabled: Specifies if Lock Pages in Memory is enabled for the SQL Server. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        :param builtins.int max_dop: Maximum Degree of Parallelism of the SQL Server. Possible values are between `0` and `32767`. Defaults to `0`.
        :param builtins.int max_server_memory_mb: Maximum amount memory that SQL Server Memory Manager can allocate to the SQL Server process. Possible values are between `128` and `2147483647` Defaults to `2147483647`.
        :param builtins.int min_server_memory_mb: Minimum amount memory that SQL Server Memory Manager can allocate to the SQL Server process. Possible values are between `0` and `2147483647` Defaults to `0`.
               
               > **Note:** `max_server_memory_mb` must be greater than or equal to `min_server_memory_mb`
        """
        if adhoc_workloads_optimization_enabled is not None:
            pulumi.set(__self__, "adhoc_workloads_optimization_enabled", adhoc_workloads_optimization_enabled)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if instant_file_initialization_enabled is not None:
            pulumi.set(__self__, "instant_file_initialization_enabled", instant_file_initialization_enabled)
        if lock_pages_in_memory_enabled is not None:
            pulumi.set(__self__, "lock_pages_in_memory_enabled", lock_pages_in_memory_enabled)
        if max_dop is not None:
            pulumi.set(__self__, "max_dop", max_dop)
        if max_server_memory_mb is not None:
            pulumi.set(__self__, "max_server_memory_mb", max_server_memory_mb)
        if min_server_memory_mb is not None:
            pulumi.set(__self__, "min_server_memory_mb", min_server_memory_mb)

    @property
    @pulumi.getter(name="adhocWorkloadsOptimizationEnabled")
    def adhoc_workloads_optimization_enabled(self) -> Optional[builtins.bool]:
        """
        Specifies if the SQL Server is optimized for adhoc workloads. Possible values are `true` and `false`. Defaults to `false`.
        """
        return pulumi.get(self, "adhoc_workloads_optimization_enabled")

    @property
    @pulumi.getter
    def collation(self) -> Optional[builtins.str]:
        """
        Collation of the SQL Server. Defaults to `SQL_Latin1_General_CP1_CI_AS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="instantFileInitializationEnabled")
    def instant_file_initialization_enabled(self) -> Optional[builtins.bool]:
        """
        Specifies if Instant File Initialization is enabled for the SQL Server. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "instant_file_initialization_enabled")

    @property
    @pulumi.getter(name="lockPagesInMemoryEnabled")
    def lock_pages_in_memory_enabled(self) -> Optional[builtins.bool]:
        """
        Specifies if Lock Pages in Memory is enabled for the SQL Server. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lock_pages_in_memory_enabled")

    @property
    @pulumi.getter(name="maxDop")
    def max_dop(self) -> Optional[builtins.int]:
        """
        Maximum Degree of Parallelism of the SQL Server. Possible values are between `0` and `32767`. Defaults to `0`.
        """
        return pulumi.get(self, "max_dop")

    @property
    @pulumi.getter(name="maxServerMemoryMb")
    def max_server_memory_mb(self) -> Optional[builtins.int]:
        """
        Maximum amount memory that SQL Server Memory Manager can allocate to the SQL Server process. Possible values are between `128` and `2147483647` Defaults to `2147483647`.
        """
        return pulumi.get(self, "max_server_memory_mb")

    @property
    @pulumi.getter(name="minServerMemoryMb")
    def min_server_memory_mb(self) -> Optional[builtins.int]:
        """
        Minimum amount memory that SQL Server Memory Manager can allocate to the SQL Server process. Possible values are between `0` and `2147483647` Defaults to `0`.

        > **Note:** `max_server_memory_mb` must be greater than or equal to `min_server_memory_mb`
        """
        return pulumi.get(self, "min_server_memory_mb")


@pulumi.output_type
class VirtualMachineStorageConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskType":
            suggest = "disk_type"
        elif key == "storageWorkloadType":
            suggest = "storage_workload_type"
        elif key == "dataSettings":
            suggest = "data_settings"
        elif key == "logSettings":
            suggest = "log_settings"
        elif key == "systemDbOnDataDiskEnabled":
            suggest = "system_db_on_data_disk_enabled"
        elif key == "tempDbSettings":
            suggest = "temp_db_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineStorageConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineStorageConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineStorageConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_type: builtins.str,
                 storage_workload_type: builtins.str,
                 data_settings: Optional['outputs.VirtualMachineStorageConfigurationDataSettings'] = None,
                 log_settings: Optional['outputs.VirtualMachineStorageConfigurationLogSettings'] = None,
                 system_db_on_data_disk_enabled: Optional[builtins.bool] = None,
                 temp_db_settings: Optional['outputs.VirtualMachineStorageConfigurationTempDbSettings'] = None):
        """
        :param builtins.str disk_type: The type of disk configuration to apply to the SQL Server. Valid values include `NEW`, `EXTEND`, or `ADD`.
        :param builtins.str storage_workload_type: The type of storage workload. Valid values include `GENERAL`, `OLTP`, or `DW`.
        :param 'VirtualMachineStorageConfigurationDataSettingsArgs' data_settings: A `storage_settings` block as defined below.
        :param 'VirtualMachineStorageConfigurationLogSettingsArgs' log_settings: A `storage_settings` block as defined below.
        :param builtins.bool system_db_on_data_disk_enabled: Specifies whether to set system databases (except tempDb) location to newly created data storage. Possible values are `true` and `false`. Defaults to `false`.
        :param 'VirtualMachineStorageConfigurationTempDbSettingsArgs' temp_db_settings: An `temp_db_settings` block as defined below.
        """
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "storage_workload_type", storage_workload_type)
        if data_settings is not None:
            pulumi.set(__self__, "data_settings", data_settings)
        if log_settings is not None:
            pulumi.set(__self__, "log_settings", log_settings)
        if system_db_on_data_disk_enabled is not None:
            pulumi.set(__self__, "system_db_on_data_disk_enabled", system_db_on_data_disk_enabled)
        if temp_db_settings is not None:
            pulumi.set(__self__, "temp_db_settings", temp_db_settings)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> builtins.str:
        """
        The type of disk configuration to apply to the SQL Server. Valid values include `NEW`, `EXTEND`, or `ADD`.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="storageWorkloadType")
    def storage_workload_type(self) -> builtins.str:
        """
        The type of storage workload. Valid values include `GENERAL`, `OLTP`, or `DW`.
        """
        return pulumi.get(self, "storage_workload_type")

    @property
    @pulumi.getter(name="dataSettings")
    def data_settings(self) -> Optional['outputs.VirtualMachineStorageConfigurationDataSettings']:
        """
        A `storage_settings` block as defined below.
        """
        return pulumi.get(self, "data_settings")

    @property
    @pulumi.getter(name="logSettings")
    def log_settings(self) -> Optional['outputs.VirtualMachineStorageConfigurationLogSettings']:
        """
        A `storage_settings` block as defined below.
        """
        return pulumi.get(self, "log_settings")

    @property
    @pulumi.getter(name="systemDbOnDataDiskEnabled")
    def system_db_on_data_disk_enabled(self) -> Optional[builtins.bool]:
        """
        Specifies whether to set system databases (except tempDb) location to newly created data storage. Possible values are `true` and `false`. Defaults to `false`.
        """
        return pulumi.get(self, "system_db_on_data_disk_enabled")

    @property
    @pulumi.getter(name="tempDbSettings")
    def temp_db_settings(self) -> Optional['outputs.VirtualMachineStorageConfigurationTempDbSettings']:
        """
        An `temp_db_settings` block as defined below.
        """
        return pulumi.get(self, "temp_db_settings")


@pulumi.output_type
class VirtualMachineStorageConfigurationDataSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultFilePath":
            suggest = "default_file_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineStorageConfigurationDataSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineStorageConfigurationDataSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineStorageConfigurationDataSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_file_path: builtins.str,
                 luns: Sequence[builtins.int]):
        pulumi.set(__self__, "default_file_path", default_file_path)
        pulumi.set(__self__, "luns", luns)

    @property
    @pulumi.getter(name="defaultFilePath")
    def default_file_path(self) -> builtins.str:
        return pulumi.get(self, "default_file_path")

    @property
    @pulumi.getter
    def luns(self) -> Sequence[builtins.int]:
        return pulumi.get(self, "luns")


@pulumi.output_type
class VirtualMachineStorageConfigurationLogSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultFilePath":
            suggest = "default_file_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineStorageConfigurationLogSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineStorageConfigurationLogSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineStorageConfigurationLogSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_file_path: builtins.str,
                 luns: Sequence[builtins.int]):
        pulumi.set(__self__, "default_file_path", default_file_path)
        pulumi.set(__self__, "luns", luns)

    @property
    @pulumi.getter(name="defaultFilePath")
    def default_file_path(self) -> builtins.str:
        return pulumi.get(self, "default_file_path")

    @property
    @pulumi.getter
    def luns(self) -> Sequence[builtins.int]:
        return pulumi.get(self, "luns")


@pulumi.output_type
class VirtualMachineStorageConfigurationTempDbSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultFilePath":
            suggest = "default_file_path"
        elif key == "dataFileCount":
            suggest = "data_file_count"
        elif key == "dataFileGrowthInMb":
            suggest = "data_file_growth_in_mb"
        elif key == "dataFileSizeMb":
            suggest = "data_file_size_mb"
        elif key == "logFileGrowthMb":
            suggest = "log_file_growth_mb"
        elif key == "logFileSizeMb":
            suggest = "log_file_size_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineStorageConfigurationTempDbSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineStorageConfigurationTempDbSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineStorageConfigurationTempDbSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_file_path: builtins.str,
                 luns: Sequence[builtins.int],
                 data_file_count: Optional[builtins.int] = None,
                 data_file_growth_in_mb: Optional[builtins.int] = None,
                 data_file_size_mb: Optional[builtins.int] = None,
                 log_file_growth_mb: Optional[builtins.int] = None,
                 log_file_size_mb: Optional[builtins.int] = None):
        """
        :param builtins.str default_file_path: The SQL Server default path
        :param Sequence[builtins.int] luns: A list of Logical Unit Numbers for the disks.
        :param builtins.int data_file_count: The SQL Server default file count. This value defaults to `8`
        :param builtins.int data_file_growth_in_mb: The SQL Server default file size - This value defaults to `512`
        :param builtins.int data_file_size_mb: The SQL Server default file size - This value defaults to `256`
        :param builtins.int log_file_growth_mb: The SQL Server default file size - This value defaults to `512`
        :param builtins.int log_file_size_mb: The SQL Server default file size - This value defaults to `256`
        """
        pulumi.set(__self__, "default_file_path", default_file_path)
        pulumi.set(__self__, "luns", luns)
        if data_file_count is not None:
            pulumi.set(__self__, "data_file_count", data_file_count)
        if data_file_growth_in_mb is not None:
            pulumi.set(__self__, "data_file_growth_in_mb", data_file_growth_in_mb)
        if data_file_size_mb is not None:
            pulumi.set(__self__, "data_file_size_mb", data_file_size_mb)
        if log_file_growth_mb is not None:
            pulumi.set(__self__, "log_file_growth_mb", log_file_growth_mb)
        if log_file_size_mb is not None:
            pulumi.set(__self__, "log_file_size_mb", log_file_size_mb)

    @property
    @pulumi.getter(name="defaultFilePath")
    def default_file_path(self) -> builtins.str:
        """
        The SQL Server default path
        """
        return pulumi.get(self, "default_file_path")

    @property
    @pulumi.getter
    def luns(self) -> Sequence[builtins.int]:
        """
        A list of Logical Unit Numbers for the disks.
        """
        return pulumi.get(self, "luns")

    @property
    @pulumi.getter(name="dataFileCount")
    def data_file_count(self) -> Optional[builtins.int]:
        """
        The SQL Server default file count. This value defaults to `8`
        """
        return pulumi.get(self, "data_file_count")

    @property
    @pulumi.getter(name="dataFileGrowthInMb")
    def data_file_growth_in_mb(self) -> Optional[builtins.int]:
        """
        The SQL Server default file size - This value defaults to `512`
        """
        return pulumi.get(self, "data_file_growth_in_mb")

    @property
    @pulumi.getter(name="dataFileSizeMb")
    def data_file_size_mb(self) -> Optional[builtins.int]:
        """
        The SQL Server default file size - This value defaults to `256`
        """
        return pulumi.get(self, "data_file_size_mb")

    @property
    @pulumi.getter(name="logFileGrowthMb")
    def log_file_growth_mb(self) -> Optional[builtins.int]:
        """
        The SQL Server default file size - This value defaults to `512`
        """
        return pulumi.get(self, "log_file_growth_mb")

    @property
    @pulumi.getter(name="logFileSizeMb")
    def log_file_size_mb(self) -> Optional[builtins.int]:
        """
        The SQL Server default file size - This value defaults to `256`
        """
        return pulumi.get(self, "log_file_size_mb")


@pulumi.output_type
class VirtualMachineWsfcDomainCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterBootstrapAccountPassword":
            suggest = "cluster_bootstrap_account_password"
        elif key == "clusterOperatorAccountPassword":
            suggest = "cluster_operator_account_password"
        elif key == "sqlServiceAccountPassword":
            suggest = "sql_service_account_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineWsfcDomainCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineWsfcDomainCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineWsfcDomainCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_bootstrap_account_password: builtins.str,
                 cluster_operator_account_password: builtins.str,
                 sql_service_account_password: builtins.str):
        """
        :param builtins.str cluster_bootstrap_account_password: The account password used for creating cluster.
        :param builtins.str cluster_operator_account_password: The account password used for operating cluster.
        :param builtins.str sql_service_account_password: The account password under which SQL service will run on all participating SQL virtual machines in the cluster.
        """
        pulumi.set(__self__, "cluster_bootstrap_account_password", cluster_bootstrap_account_password)
        pulumi.set(__self__, "cluster_operator_account_password", cluster_operator_account_password)
        pulumi.set(__self__, "sql_service_account_password", sql_service_account_password)

    @property
    @pulumi.getter(name="clusterBootstrapAccountPassword")
    def cluster_bootstrap_account_password(self) -> builtins.str:
        """
        The account password used for creating cluster.
        """
        return pulumi.get(self, "cluster_bootstrap_account_password")

    @property
    @pulumi.getter(name="clusterOperatorAccountPassword")
    def cluster_operator_account_password(self) -> builtins.str:
        """
        The account password used for operating cluster.
        """
        return pulumi.get(self, "cluster_operator_account_password")

    @property
    @pulumi.getter(name="sqlServiceAccountPassword")
    def sql_service_account_password(self) -> builtins.str:
        """
        The account password under which SQL service will run on all participating SQL virtual machines in the cluster.
        """
        return pulumi.get(self, "sql_service_account_password")


@pulumi.output_type
class GetDatabaseIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: The list of User Assigned Managed Identity IDs assigned to this Microsoft SQL Database.
        :param builtins.str type: The type of Managed Service Identity that is configured on this Microsoft SQL Database.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        The list of User Assigned Managed Identity IDs assigned to this Microsoft SQL Database.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of Managed Service Identity that is configured on this Microsoft SQL Database.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetElasticPoolSkusResult(dict):
    def __init__(__self__, *,
                 capacity: builtins.int,
                 family: builtins.str,
                 name: builtins.str,
                 tier: builtins.str):
        """
        :param builtins.int capacity: The scale up/out capacity, representing server's compute units.
        :param builtins.str family: The `family` of hardware.
        :param builtins.str name: The name of the elastic pool.
        :param builtins.str tier: The tier of the particular SKU.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> builtins.int:
        """
        The scale up/out capacity, representing server's compute units.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> builtins.str:
        """
        The `family` of hardware.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the elastic pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> builtins.str:
        """
        The tier of the particular SKU.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class GetManagedDatabaseLongTermRetentionPolicyResult(dict):
    def __init__(__self__, *,
                 immutable_backups_enabled: builtins.bool,
                 monthly_retention: builtins.str,
                 week_of_year: builtins.int,
                 weekly_retention: builtins.str,
                 yearly_retention: builtins.str):
        """
        :param builtins.bool immutable_backups_enabled: Specifies if the backups are immutable.
        :param builtins.str monthly_retention: The monthly retention policy for an LTR backup in an ISO 8601 format.
        :param builtins.int week_of_year: The week of year to take the yearly backup.
        :param builtins.str weekly_retention: The weekly retention policy for an LTR backup in an ISO 8601 format.
        :param builtins.str yearly_retention: The yearly retention policy for an LTR backup in an ISO 8601 format.
        """
        pulumi.set(__self__, "immutable_backups_enabled", immutable_backups_enabled)
        pulumi.set(__self__, "monthly_retention", monthly_retention)
        pulumi.set(__self__, "week_of_year", week_of_year)
        pulumi.set(__self__, "weekly_retention", weekly_retention)
        pulumi.set(__self__, "yearly_retention", yearly_retention)

    @property
    @pulumi.getter(name="immutableBackupsEnabled")
    def immutable_backups_enabled(self) -> builtins.bool:
        """
        Specifies if the backups are immutable.
        """
        return pulumi.get(self, "immutable_backups_enabled")

    @property
    @pulumi.getter(name="monthlyRetention")
    def monthly_retention(self) -> builtins.str:
        """
        The monthly retention policy for an LTR backup in an ISO 8601 format.
        """
        return pulumi.get(self, "monthly_retention")

    @property
    @pulumi.getter(name="weekOfYear")
    def week_of_year(self) -> builtins.int:
        """
        The week of year to take the yearly backup.
        """
        return pulumi.get(self, "week_of_year")

    @property
    @pulumi.getter(name="weeklyRetention")
    def weekly_retention(self) -> builtins.str:
        """
        The weekly retention policy for an LTR backup in an ISO 8601 format.
        """
        return pulumi.get(self, "weekly_retention")

    @property
    @pulumi.getter(name="yearlyRetention")
    def yearly_retention(self) -> builtins.str:
        """
        The yearly retention policy for an LTR backup in an ISO 8601 format.
        """
        return pulumi.get(self, "yearly_retention")


@pulumi.output_type
class GetManagedDatabasePointInTimeRestoreResult(dict):
    def __init__(__self__, *,
                 restore_point_in_time: builtins.str,
                 source_database_id: builtins.str):
        """
        :param builtins.str restore_point_in_time: The point in time for the restore from `source_database_id`.
        :param builtins.str source_database_id: The source database ID that is used to restore from.
        """
        pulumi.set(__self__, "restore_point_in_time", restore_point_in_time)
        pulumi.set(__self__, "source_database_id", source_database_id)

    @property
    @pulumi.getter(name="restorePointInTime")
    def restore_point_in_time(self) -> builtins.str:
        """
        The point in time for the restore from `source_database_id`.
        """
        return pulumi.get(self, "restore_point_in_time")

    @property
    @pulumi.getter(name="sourceDatabaseId")
    def source_database_id(self) -> builtins.str:
        """
        The source database ID that is used to restore from.
        """
        return pulumi.get(self, "source_database_id")


@pulumi.output_type
class GetManagedInstanceIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: A list of User Assigned Managed Identity IDs assigned with the Identity of this SQL Managed Instance.
        :param builtins.str principal_id: The Principal ID for the Service Principal associated with the Identity of this SQL Managed Instance.
        :param builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Identity of this SQL Managed Instance.
        :param builtins.str type: The identity type of the SQL Managed Instance.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        A list of User Assigned Managed Identity IDs assigned with the Identity of this SQL Managed Instance.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        """
        The Principal ID for the Service Principal associated with the Identity of this SQL Managed Instance.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The Tenant ID for the Service Principal associated with the Identity of this SQL Managed Instance.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The identity type of the SQL Managed Instance.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServerIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: The list of User Assigned Managed Identity IDs assigned to this Microsoft SQL Server.
        :param builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on this Microsoft SQL Server.
        :param builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity that is configured on this Microsoft SQL Server.
        :param builtins.str type: The type of Managed Service Identity that is configured on this Microsoft SQL Server.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        The list of User Assigned Managed Identity IDs assigned to this Microsoft SQL Server.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on this Microsoft SQL Server.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The Tenant ID of the System Assigned Managed Service Identity that is configured on this Microsoft SQL Server.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of Managed Service Identity that is configured on this Microsoft SQL Server.
        """
        return pulumi.get(self, "type")


