# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServerDnsAliasArgs', 'ServerDnsAlias']

@pulumi.input_type
class ServerDnsAliasArgs:
    def __init__(__self__, *,
                 mssql_server_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ServerDnsAlias resource.
        :param pulumi.Input[builtins.str] mssql_server_id: The ID of the mssql server. Changing this forces a new MSSQL Server DNS Alias to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this MSSQL Server DNS Alias. Changing this forces a new MSSQL Server DNS Alias to be created.
        """
        pulumi.set(__self__, "mssql_server_id", mssql_server_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="mssqlServerId")
    def mssql_server_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the mssql server. Changing this forces a new MSSQL Server DNS Alias to be created.
        """
        return pulumi.get(self, "mssql_server_id")

    @mssql_server_id.setter
    def mssql_server_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mssql_server_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this MSSQL Server DNS Alias. Changing this forces a new MSSQL Server DNS Alias to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ServerDnsAliasState:
    def __init__(__self__, *,
                 dns_record: Optional[pulumi.Input[builtins.str]] = None,
                 mssql_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerDnsAlias resources.
        :param pulumi.Input[builtins.str] dns_record: The fully qualified DNS record for alias.
        :param pulumi.Input[builtins.str] mssql_server_id: The ID of the mssql server. Changing this forces a new MSSQL Server DNS Alias to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this MSSQL Server DNS Alias. Changing this forces a new MSSQL Server DNS Alias to be created.
        """
        if dns_record is not None:
            pulumi.set(__self__, "dns_record", dns_record)
        if mssql_server_id is not None:
            pulumi.set(__self__, "mssql_server_id", mssql_server_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dnsRecord")
    def dns_record(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fully qualified DNS record for alias.
        """
        return pulumi.get(self, "dns_record")

    @dns_record.setter
    def dns_record(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_record", value)

    @property
    @pulumi.getter(name="mssqlServerId")
    def mssql_server_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the mssql server. Changing this forces a new MSSQL Server DNS Alias to be created.
        """
        return pulumi.get(self, "mssql_server_id")

    @mssql_server_id.setter
    def mssql_server_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mssql_server_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this MSSQL Server DNS Alias. Changing this forces a new MSSQL Server DNS Alias to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("azure:mssql/serverDnsAlias:ServerDnsAlias")
class ServerDnsAlias(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mssql_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a MS SQL Server DNS Alias.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_server = azure.mssql.Server("example",
            name="example-sqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="missadministrator",
            administrator_login_password="AdminPassword123!")
        example_server_dns_alias = azure.mssql.ServerDnsAlias("example",
            name="example-dns-alias",
            mssql_server_id=example_server.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        MSSQL Server DNS Aliass can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/serverDnsAlias:ServerDnsAlias example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/dnsAliases/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] mssql_server_id: The ID of the mssql server. Changing this forces a new MSSQL Server DNS Alias to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this MSSQL Server DNS Alias. Changing this forces a new MSSQL Server DNS Alias to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerDnsAliasArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a MS SQL Server DNS Alias.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_server = azure.mssql.Server("example",
            name="example-sqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="missadministrator",
            administrator_login_password="AdminPassword123!")
        example_server_dns_alias = azure.mssql.ServerDnsAlias("example",
            name="example-dns-alias",
            mssql_server_id=example_server.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        MSSQL Server DNS Aliass can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/serverDnsAlias:ServerDnsAlias example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/dnsAliases/default
        ```

        :param str resource_name: The name of the resource.
        :param ServerDnsAliasArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerDnsAliasArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mssql_server_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerDnsAliasArgs.__new__(ServerDnsAliasArgs)

            if mssql_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'mssql_server_id'")
            __props__.__dict__["mssql_server_id"] = mssql_server_id
            __props__.__dict__["name"] = name
            __props__.__dict__["dns_record"] = None
        super(ServerDnsAlias, __self__).__init__(
            'azure:mssql/serverDnsAlias:ServerDnsAlias',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dns_record: Optional[pulumi.Input[builtins.str]] = None,
            mssql_server_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'ServerDnsAlias':
        """
        Get an existing ServerDnsAlias resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] dns_record: The fully qualified DNS record for alias.
        :param pulumi.Input[builtins.str] mssql_server_id: The ID of the mssql server. Changing this forces a new MSSQL Server DNS Alias to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this MSSQL Server DNS Alias. Changing this forces a new MSSQL Server DNS Alias to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerDnsAliasState.__new__(_ServerDnsAliasState)

        __props__.__dict__["dns_record"] = dns_record
        __props__.__dict__["mssql_server_id"] = mssql_server_id
        __props__.__dict__["name"] = name
        return ServerDnsAlias(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dnsRecord")
    def dns_record(self) -> pulumi.Output[builtins.str]:
        """
        The fully qualified DNS record for alias.
        """
        return pulumi.get(self, "dns_record")

    @property
    @pulumi.getter(name="mssqlServerId")
    def mssql_server_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the mssql server. Changing this forces a new MSSQL Server DNS Alias to be created.
        """
        return pulumi.get(self, "mssql_server_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this MSSQL Server DNS Alias. Changing this forces a new MSSQL Server DNS Alias to be created.
        """
        return pulumi.get(self, "name")

