# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualMachineGroupArgs', 'VirtualMachineGroup']

@pulumi.input_type
class VirtualMachineGroupArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 sql_image_offer: pulumi.Input[builtins.str],
                 sql_image_sku: pulumi.Input[builtins.str],
                 wsfc_domain_profile: pulumi.Input['VirtualMachineGroupWsfcDomainProfileArgs'],
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a VirtualMachineGroup resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Microsoft SQL Virtual Machine Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_image_offer: The offer type of the marketplace image cluster to be used by the SQL Virtual Machine Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_image_sku: The sku type of the marketplace image cluster to be used by the SQL Virtual Machine Group. Possible values are `Developer` and `Enterprise`.
        :param pulumi.Input['VirtualMachineGroupWsfcDomainProfileArgs'] wsfc_domain_profile: A `wsfc_domain_profile` block as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Microsoft SQL Virtual Machine Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for the Microsoft SQL Virtual Machine Group. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Microsoft SQL Virtual Machine Group.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sql_image_offer", sql_image_offer)
        pulumi.set(__self__, "sql_image_sku", sql_image_sku)
        pulumi.set(__self__, "wsfc_domain_profile", wsfc_domain_profile)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Microsoft SQL Virtual Machine Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="sqlImageOffer")
    def sql_image_offer(self) -> pulumi.Input[builtins.str]:
        """
        The offer type of the marketplace image cluster to be used by the SQL Virtual Machine Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_image_offer")

    @sql_image_offer.setter
    def sql_image_offer(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sql_image_offer", value)

    @property
    @pulumi.getter(name="sqlImageSku")
    def sql_image_sku(self) -> pulumi.Input[builtins.str]:
        """
        The sku type of the marketplace image cluster to be used by the SQL Virtual Machine Group. Possible values are `Developer` and `Enterprise`.
        """
        return pulumi.get(self, "sql_image_sku")

    @sql_image_sku.setter
    def sql_image_sku(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sql_image_sku", value)

    @property
    @pulumi.getter(name="wsfcDomainProfile")
    def wsfc_domain_profile(self) -> pulumi.Input['VirtualMachineGroupWsfcDomainProfileArgs']:
        """
        A `wsfc_domain_profile` block as defined below.
        """
        return pulumi.get(self, "wsfc_domain_profile")

    @wsfc_domain_profile.setter
    def wsfc_domain_profile(self, value: pulumi.Input['VirtualMachineGroupWsfcDomainProfileArgs']):
        pulumi.set(self, "wsfc_domain_profile", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Microsoft SQL Virtual Machine Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for the Microsoft SQL Virtual Machine Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Microsoft SQL Virtual Machine Group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VirtualMachineGroupState:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sql_image_offer: Optional[pulumi.Input[builtins.str]] = None,
                 sql_image_sku: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 wsfc_domain_profile: Optional[pulumi.Input['VirtualMachineGroupWsfcDomainProfileArgs']] = None):
        """
        Input properties used for looking up and filtering VirtualMachineGroup resources.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Microsoft SQL Virtual Machine Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for the Microsoft SQL Virtual Machine Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Microsoft SQL Virtual Machine Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_image_offer: The offer type of the marketplace image cluster to be used by the SQL Virtual Machine Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_image_sku: The sku type of the marketplace image cluster to be used by the SQL Virtual Machine Group. Possible values are `Developer` and `Enterprise`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Microsoft SQL Virtual Machine Group.
        :param pulumi.Input['VirtualMachineGroupWsfcDomainProfileArgs'] wsfc_domain_profile: A `wsfc_domain_profile` block as defined below.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sql_image_offer is not None:
            pulumi.set(__self__, "sql_image_offer", sql_image_offer)
        if sql_image_sku is not None:
            pulumi.set(__self__, "sql_image_sku", sql_image_sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if wsfc_domain_profile is not None:
            pulumi.set(__self__, "wsfc_domain_profile", wsfc_domain_profile)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Microsoft SQL Virtual Machine Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for the Microsoft SQL Virtual Machine Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Microsoft SQL Virtual Machine Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="sqlImageOffer")
    def sql_image_offer(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The offer type of the marketplace image cluster to be used by the SQL Virtual Machine Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_image_offer")

    @sql_image_offer.setter
    def sql_image_offer(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sql_image_offer", value)

    @property
    @pulumi.getter(name="sqlImageSku")
    def sql_image_sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The sku type of the marketplace image cluster to be used by the SQL Virtual Machine Group. Possible values are `Developer` and `Enterprise`.
        """
        return pulumi.get(self, "sql_image_sku")

    @sql_image_sku.setter
    def sql_image_sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sql_image_sku", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Microsoft SQL Virtual Machine Group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="wsfcDomainProfile")
    def wsfc_domain_profile(self) -> Optional[pulumi.Input['VirtualMachineGroupWsfcDomainProfileArgs']]:
        """
        A `wsfc_domain_profile` block as defined below.
        """
        return pulumi.get(self, "wsfc_domain_profile")

    @wsfc_domain_profile.setter
    def wsfc_domain_profile(self, value: Optional[pulumi.Input['VirtualMachineGroupWsfcDomainProfileArgs']]):
        pulumi.set(self, "wsfc_domain_profile", value)


@pulumi.type_token("azure:mssql/virtualMachineGroup:VirtualMachineGroup")
class VirtualMachineGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sql_image_offer: Optional[pulumi.Input[builtins.str]] = None,
                 sql_image_sku: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 wsfc_domain_profile: Optional[pulumi.Input[Union['VirtualMachineGroupWsfcDomainProfileArgs', 'VirtualMachineGroupWsfcDomainProfileArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Microsoft SQL Virtual Machine Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_machine_group = azure.mssql.VirtualMachineGroup("example",
            name="examplegroup",
            resource_group_name=example.name,
            location=example.location,
            sql_image_offer="SQL2017-WS2016",
            sql_image_sku="Developer",
            wsfc_domain_profile={
                "fqdn": "testdomain.com",
                "cluster_subnet_type": "SingleSubnet",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SqlVirtualMachine`: 2023-10-01

        ## Import

        Microsoft SQL Virtual Machine Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/virtualMachineGroup:VirtualMachineGroup example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/vmgroup1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Microsoft SQL Virtual Machine Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for the Microsoft SQL Virtual Machine Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Microsoft SQL Virtual Machine Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_image_offer: The offer type of the marketplace image cluster to be used by the SQL Virtual Machine Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_image_sku: The sku type of the marketplace image cluster to be used by the SQL Virtual Machine Group. Possible values are `Developer` and `Enterprise`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Microsoft SQL Virtual Machine Group.
        :param pulumi.Input[Union['VirtualMachineGroupWsfcDomainProfileArgs', 'VirtualMachineGroupWsfcDomainProfileArgsDict']] wsfc_domain_profile: A `wsfc_domain_profile` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualMachineGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Microsoft SQL Virtual Machine Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_machine_group = azure.mssql.VirtualMachineGroup("example",
            name="examplegroup",
            resource_group_name=example.name,
            location=example.location,
            sql_image_offer="SQL2017-WS2016",
            sql_image_sku="Developer",
            wsfc_domain_profile={
                "fqdn": "testdomain.com",
                "cluster_subnet_type": "SingleSubnet",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SqlVirtualMachine`: 2023-10-01

        ## Import

        Microsoft SQL Virtual Machine Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/virtualMachineGroup:VirtualMachineGroup example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/vmgroup1
        ```

        :param str resource_name: The name of the resource.
        :param VirtualMachineGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sql_image_offer: Optional[pulumi.Input[builtins.str]] = None,
                 sql_image_sku: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 wsfc_domain_profile: Optional[pulumi.Input[Union['VirtualMachineGroupWsfcDomainProfileArgs', 'VirtualMachineGroupWsfcDomainProfileArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineGroupArgs.__new__(VirtualMachineGroupArgs)

            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sql_image_offer is None and not opts.urn:
                raise TypeError("Missing required property 'sql_image_offer'")
            __props__.__dict__["sql_image_offer"] = sql_image_offer
            if sql_image_sku is None and not opts.urn:
                raise TypeError("Missing required property 'sql_image_sku'")
            __props__.__dict__["sql_image_sku"] = sql_image_sku
            __props__.__dict__["tags"] = tags
            if wsfc_domain_profile is None and not opts.urn:
                raise TypeError("Missing required property 'wsfc_domain_profile'")
            __props__.__dict__["wsfc_domain_profile"] = wsfc_domain_profile
        super(VirtualMachineGroup, __self__).__init__(
            'azure:mssql/virtualMachineGroup:VirtualMachineGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            sql_image_offer: Optional[pulumi.Input[builtins.str]] = None,
            sql_image_sku: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            wsfc_domain_profile: Optional[pulumi.Input[Union['VirtualMachineGroupWsfcDomainProfileArgs', 'VirtualMachineGroupWsfcDomainProfileArgsDict']]] = None) -> 'VirtualMachineGroup':
        """
        Get an existing VirtualMachineGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Microsoft SQL Virtual Machine Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for the Microsoft SQL Virtual Machine Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Microsoft SQL Virtual Machine Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_image_offer: The offer type of the marketplace image cluster to be used by the SQL Virtual Machine Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sql_image_sku: The sku type of the marketplace image cluster to be used by the SQL Virtual Machine Group. Possible values are `Developer` and `Enterprise`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Microsoft SQL Virtual Machine Group.
        :param pulumi.Input[Union['VirtualMachineGroupWsfcDomainProfileArgs', 'VirtualMachineGroupWsfcDomainProfileArgsDict']] wsfc_domain_profile: A `wsfc_domain_profile` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualMachineGroupState.__new__(_VirtualMachineGroupState)

        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sql_image_offer"] = sql_image_offer
        __props__.__dict__["sql_image_sku"] = sql_image_sku
        __props__.__dict__["tags"] = tags
        __props__.__dict__["wsfc_domain_profile"] = wsfc_domain_profile
        return VirtualMachineGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Microsoft SQL Virtual Machine Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for the Microsoft SQL Virtual Machine Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Microsoft SQL Virtual Machine Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="sqlImageOffer")
    def sql_image_offer(self) -> pulumi.Output[builtins.str]:
        """
        The offer type of the marketplace image cluster to be used by the SQL Virtual Machine Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_image_offer")

    @property
    @pulumi.getter(name="sqlImageSku")
    def sql_image_sku(self) -> pulumi.Output[builtins.str]:
        """
        The sku type of the marketplace image cluster to be used by the SQL Virtual Machine Group. Possible values are `Developer` and `Enterprise`.
        """
        return pulumi.get(self, "sql_image_sku")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Microsoft SQL Virtual Machine Group.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="wsfcDomainProfile")
    def wsfc_domain_profile(self) -> pulumi.Output['outputs.VirtualMachineGroupWsfcDomainProfile']:
        """
        A `wsfc_domain_profile` block as defined below.
        """
        return pulumi.get(self, "wsfc_domain_profile")

