# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AccountActiveDirectoryArgs',
    'AccountActiveDirectoryArgsDict',
    'AccountIdentityArgs',
    'AccountIdentityArgsDict',
    'SnapshotPolicyDailyScheduleArgs',
    'SnapshotPolicyDailyScheduleArgsDict',
    'SnapshotPolicyHourlyScheduleArgs',
    'SnapshotPolicyHourlyScheduleArgsDict',
    'SnapshotPolicyMonthlyScheduleArgs',
    'SnapshotPolicyMonthlyScheduleArgsDict',
    'SnapshotPolicyWeeklyScheduleArgs',
    'SnapshotPolicyWeeklyScheduleArgsDict',
    'VolumeDataProtectionBackupPolicyArgs',
    'VolumeDataProtectionBackupPolicyArgsDict',
    'VolumeDataProtectionReplicationArgs',
    'VolumeDataProtectionReplicationArgsDict',
    'VolumeDataProtectionSnapshotPolicyArgs',
    'VolumeDataProtectionSnapshotPolicyArgsDict',
    'VolumeExportPolicyRuleArgs',
    'VolumeExportPolicyRuleArgsDict',
    'VolumeGroupOracleVolumeArgs',
    'VolumeGroupOracleVolumeArgsDict',
    'VolumeGroupOracleVolumeDataProtectionReplicationArgs',
    'VolumeGroupOracleVolumeDataProtectionReplicationArgsDict',
    'VolumeGroupOracleVolumeDataProtectionSnapshotPolicyArgs',
    'VolumeGroupOracleVolumeDataProtectionSnapshotPolicyArgsDict',
    'VolumeGroupOracleVolumeExportPolicyRuleArgs',
    'VolumeGroupOracleVolumeExportPolicyRuleArgsDict',
    'VolumeGroupSapHanaVolumeArgs',
    'VolumeGroupSapHanaVolumeArgsDict',
    'VolumeGroupSapHanaVolumeDataProtectionReplicationArgs',
    'VolumeGroupSapHanaVolumeDataProtectionReplicationArgsDict',
    'VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyArgs',
    'VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyArgsDict',
    'VolumeGroupSapHanaVolumeExportPolicyRuleArgs',
    'VolumeGroupSapHanaVolumeExportPolicyRuleArgsDict',
    'GetAccountIdentityArgs',
    'GetAccountIdentityArgsDict',
]

MYPY = False

if not MYPY:
    class AccountActiveDirectoryArgsDict(TypedDict):
        dns_servers: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of DNS server IP addresses for the Active Directory domain. Only allows `IPv4` address.
        """
        domain: pulumi.Input[builtins.str]
        """
        The name of the Active Directory domain.
        """
        password: pulumi.Input[builtins.str]
        """
        The password associated with the `username`.
        """
        smb_server_name: pulumi.Input[builtins.str]
        """
        The NetBIOS name which should be used for the NetApp SMB Server, which will be registered as a computer account in the AD and used to mount volumes.
        """
        username: pulumi.Input[builtins.str]
        """
        The Username of Active Directory Domain Administrator.
        """
        aes_encryption_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        If enabled, AES encryption will be enabled for SMB communication. Defaults to `false`.
        """
        kerberos_ad_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the active directory machine.
        """
        kerberos_kdc_ip: NotRequired[pulumi.Input[builtins.str]]
        """
        kdc server IP addresses for the active directory machine.

        > **Note:** If you plan on using **Kerberos** volumes, both `ad_name` and `kdc_ip` are required in order to create the volume.
        """
        ldap_over_tls_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether or not the LDAP traffic needs to be secured via TLS. Defaults to `false`.
        """
        ldap_signing_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether or not the LDAP traffic needs to be signed. Defaults to `false`.
        """
        local_nfs_users_with_ldap_allowed: NotRequired[pulumi.Input[builtins.bool]]
        """
        If enabled, NFS client local users can also (in addition to LDAP users) access the NFS volumes. Defaults to `false`.
        """
        organizational_unit: NotRequired[pulumi.Input[builtins.str]]
        """
        The Organizational Unit (OU) within Active Directory where machines will be created. If blank, defaults to `CN=Computers`.
        """
        server_root_ca_certificate: NotRequired[pulumi.Input[builtins.str]]
        """
        When LDAP over SSL/TLS is enabled, the LDAP client is required to have a *base64 encoded Active Directory Certificate Service's self-signed root CA certificate*, this optional parameter is used only for dual protocol with LDAP user-mapping volumes. Required if `ldap_over_tls_enabled` is set to `true`.
        """
        site_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The Active Directory site the service will limit Domain Controller discovery to. If blank, defaults to `Default-First-Site-Name`.
        """
elif False:
    AccountActiveDirectoryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountActiveDirectoryArgs:
    def __init__(__self__, *,
                 dns_servers: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 domain: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 smb_server_name: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str],
                 aes_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 kerberos_ad_name: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_kdc_ip: Optional[pulumi.Input[builtins.str]] = None,
                 ldap_over_tls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ldap_signing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_nfs_users_with_ldap_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 organizational_unit: Optional[pulumi.Input[builtins.str]] = None,
                 server_root_ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 site_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_servers: A list of DNS server IP addresses for the Active Directory domain. Only allows `IPv4` address.
        :param pulumi.Input[builtins.str] domain: The name of the Active Directory domain.
        :param pulumi.Input[builtins.str] password: The password associated with the `username`.
        :param pulumi.Input[builtins.str] smb_server_name: The NetBIOS name which should be used for the NetApp SMB Server, which will be registered as a computer account in the AD and used to mount volumes.
        :param pulumi.Input[builtins.str] username: The Username of Active Directory Domain Administrator.
        :param pulumi.Input[builtins.bool] aes_encryption_enabled: If enabled, AES encryption will be enabled for SMB communication. Defaults to `false`.
        :param pulumi.Input[builtins.str] kerberos_ad_name: Name of the active directory machine.
        :param pulumi.Input[builtins.str] kerberos_kdc_ip: kdc server IP addresses for the active directory machine.
               
               > **Note:** If you plan on using **Kerberos** volumes, both `ad_name` and `kdc_ip` are required in order to create the volume.
        :param pulumi.Input[builtins.bool] ldap_over_tls_enabled: Specifies whether or not the LDAP traffic needs to be secured via TLS. Defaults to `false`.
        :param pulumi.Input[builtins.bool] ldap_signing_enabled: Specifies whether or not the LDAP traffic needs to be signed. Defaults to `false`.
        :param pulumi.Input[builtins.bool] local_nfs_users_with_ldap_allowed: If enabled, NFS client local users can also (in addition to LDAP users) access the NFS volumes. Defaults to `false`.
        :param pulumi.Input[builtins.str] organizational_unit: The Organizational Unit (OU) within Active Directory where machines will be created. If blank, defaults to `CN=Computers`.
        :param pulumi.Input[builtins.str] server_root_ca_certificate: When LDAP over SSL/TLS is enabled, the LDAP client is required to have a *base64 encoded Active Directory Certificate Service's self-signed root CA certificate*, this optional parameter is used only for dual protocol with LDAP user-mapping volumes. Required if `ldap_over_tls_enabled` is set to `true`.
        :param pulumi.Input[builtins.str] site_name: The Active Directory site the service will limit Domain Controller discovery to. If blank, defaults to `Default-First-Site-Name`.
        """
        pulumi.set(__self__, "dns_servers", dns_servers)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "smb_server_name", smb_server_name)
        pulumi.set(__self__, "username", username)
        if aes_encryption_enabled is not None:
            pulumi.set(__self__, "aes_encryption_enabled", aes_encryption_enabled)
        if kerberos_ad_name is not None:
            pulumi.set(__self__, "kerberos_ad_name", kerberos_ad_name)
        if kerberos_kdc_ip is not None:
            pulumi.set(__self__, "kerberos_kdc_ip", kerberos_kdc_ip)
        if ldap_over_tls_enabled is not None:
            pulumi.set(__self__, "ldap_over_tls_enabled", ldap_over_tls_enabled)
        if ldap_signing_enabled is not None:
            pulumi.set(__self__, "ldap_signing_enabled", ldap_signing_enabled)
        if local_nfs_users_with_ldap_allowed is not None:
            pulumi.set(__self__, "local_nfs_users_with_ldap_allowed", local_nfs_users_with_ldap_allowed)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if server_root_ca_certificate is not None:
            pulumi.set(__self__, "server_root_ca_certificate", server_root_ca_certificate)
        if site_name is not None:
            pulumi.set(__self__, "site_name", site_name)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of DNS server IP addresses for the Active Directory domain. Only allows `IPv4` address.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Active Directory domain.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The password associated with the `username`.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="smbServerName")
    def smb_server_name(self) -> pulumi.Input[builtins.str]:
        """
        The NetBIOS name which should be used for the NetApp SMB Server, which will be registered as a computer account in the AD and used to mount volumes.
        """
        return pulumi.get(self, "smb_server_name")

    @smb_server_name.setter
    def smb_server_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "smb_server_name", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        The Username of Active Directory Domain Administrator.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="aesEncryptionEnabled")
    def aes_encryption_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, AES encryption will be enabled for SMB communication. Defaults to `false`.
        """
        return pulumi.get(self, "aes_encryption_enabled")

    @aes_encryption_enabled.setter
    def aes_encryption_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "aes_encryption_enabled", value)

    @property
    @pulumi.getter(name="kerberosAdName")
    def kerberos_ad_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the active directory machine.
        """
        return pulumi.get(self, "kerberos_ad_name")

    @kerberos_ad_name.setter
    def kerberos_ad_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_ad_name", value)

    @property
    @pulumi.getter(name="kerberosKdcIp")
    def kerberos_kdc_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        kdc server IP addresses for the active directory machine.

        > **Note:** If you plan on using **Kerberos** volumes, both `ad_name` and `kdc_ip` are required in order to create the volume.
        """
        return pulumi.get(self, "kerberos_kdc_ip")

    @kerberos_kdc_ip.setter
    def kerberos_kdc_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_kdc_ip", value)

    @property
    @pulumi.getter(name="ldapOverTlsEnabled")
    def ldap_over_tls_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether or not the LDAP traffic needs to be secured via TLS. Defaults to `false`.
        """
        return pulumi.get(self, "ldap_over_tls_enabled")

    @ldap_over_tls_enabled.setter
    def ldap_over_tls_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ldap_over_tls_enabled", value)

    @property
    @pulumi.getter(name="ldapSigningEnabled")
    def ldap_signing_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether or not the LDAP traffic needs to be signed. Defaults to `false`.
        """
        return pulumi.get(self, "ldap_signing_enabled")

    @ldap_signing_enabled.setter
    def ldap_signing_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ldap_signing_enabled", value)

    @property
    @pulumi.getter(name="localNfsUsersWithLdapAllowed")
    def local_nfs_users_with_ldap_allowed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, NFS client local users can also (in addition to LDAP users) access the NFS volumes. Defaults to `false`.
        """
        return pulumi.get(self, "local_nfs_users_with_ldap_allowed")

    @local_nfs_users_with_ldap_allowed.setter
    def local_nfs_users_with_ldap_allowed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_nfs_users_with_ldap_allowed", value)

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Organizational Unit (OU) within Active Directory where machines will be created. If blank, defaults to `CN=Computers`.
        """
        return pulumi.get(self, "organizational_unit")

    @organizational_unit.setter
    def organizational_unit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organizational_unit", value)

    @property
    @pulumi.getter(name="serverRootCaCertificate")
    def server_root_ca_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When LDAP over SSL/TLS is enabled, the LDAP client is required to have a *base64 encoded Active Directory Certificate Service's self-signed root CA certificate*, this optional parameter is used only for dual protocol with LDAP user-mapping volumes. Required if `ldap_over_tls_enabled` is set to `true`.
        """
        return pulumi.get(self, "server_root_ca_certificate")

    @server_root_ca_certificate.setter
    def server_root_ca_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_root_ca_certificate", value)

    @property
    @pulumi.getter(name="siteName")
    def site_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Active Directory site the service will limit Domain Controller discovery to. If blank, defaults to `Default-First-Site-Name`.
        """
        return pulumi.get(self, "site_name")

    @site_name.setter
    def site_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "site_name", value)


if not MYPY:
    class AccountIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        The identity type, which can be `SystemAssigned` or `UserAssigned`. Only one type at a time is supported by Azure NetApp Files.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The identity id of the user assigned identity to use when type is `UserAssigned`
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
elif False:
    AccountIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: The identity type, which can be `SystemAssigned` or `UserAssigned`. Only one type at a time is supported by Azure NetApp Files.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: The identity id of the user assigned identity to use when type is `UserAssigned`
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The identity type, which can be `SystemAssigned` or `UserAssigned`. Only one type at a time is supported by Azure NetApp Files.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The identity id of the user assigned identity to use when type is `UserAssigned`
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class SnapshotPolicyDailyScheduleArgsDict(TypedDict):
        hour: pulumi.Input[builtins.int]
        """
        Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        """
        minute: pulumi.Input[builtins.int]
        """
        Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        """
        snapshots_to_keep: pulumi.Input[builtins.int]
        """
        How many hourly snapshots to keep, valid range is from 0 to 255.
        """
elif False:
    SnapshotPolicyDailyScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SnapshotPolicyDailyScheduleArgs:
    def __init__(__self__, *,
                 hour: pulumi.Input[builtins.int],
                 minute: pulumi.Input[builtins.int],
                 snapshots_to_keep: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] hour: Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        :param pulumi.Input[builtins.int] minute: Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        :param pulumi.Input[builtins.int] snapshots_to_keep: How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "minute", minute)
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)

    @property
    @pulumi.getter
    def hour(self) -> pulumi.Input[builtins.int]:
        """
        Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter
    def minute(self) -> pulumi.Input[builtins.int]:
        """
        Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "minute", value)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> pulumi.Input[builtins.int]:
        """
        How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "snapshots_to_keep", value)


if not MYPY:
    class SnapshotPolicyHourlyScheduleArgsDict(TypedDict):
        minute: pulumi.Input[builtins.int]
        """
        Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        """
        snapshots_to_keep: pulumi.Input[builtins.int]
        """
        How many hourly snapshots to keep, valid range is from 0 to 255.
        """
elif False:
    SnapshotPolicyHourlyScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SnapshotPolicyHourlyScheduleArgs:
    def __init__(__self__, *,
                 minute: pulumi.Input[builtins.int],
                 snapshots_to_keep: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] minute: Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        :param pulumi.Input[builtins.int] snapshots_to_keep: How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        pulumi.set(__self__, "minute", minute)
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)

    @property
    @pulumi.getter
    def minute(self) -> pulumi.Input[builtins.int]:
        """
        Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "minute", value)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> pulumi.Input[builtins.int]:
        """
        How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "snapshots_to_keep", value)


if not MYPY:
    class SnapshotPolicyMonthlyScheduleArgsDict(TypedDict):
        days_of_months: pulumi.Input[Sequence[pulumi.Input[builtins.int]]]
        """
        List of the days of the month when the snapshots will be created, valid range is from 1 to 30.
        """
        hour: pulumi.Input[builtins.int]
        """
        Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        """
        minute: pulumi.Input[builtins.int]
        """
        Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        """
        snapshots_to_keep: pulumi.Input[builtins.int]
        """
        How many hourly snapshots to keep, valid range is from 0 to 255.
        """
elif False:
    SnapshotPolicyMonthlyScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SnapshotPolicyMonthlyScheduleArgs:
    def __init__(__self__, *,
                 days_of_months: pulumi.Input[Sequence[pulumi.Input[builtins.int]]],
                 hour: pulumi.Input[builtins.int],
                 minute: pulumi.Input[builtins.int],
                 snapshots_to_keep: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] days_of_months: List of the days of the month when the snapshots will be created, valid range is from 1 to 30.
        :param pulumi.Input[builtins.int] hour: Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        :param pulumi.Input[builtins.int] minute: Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        :param pulumi.Input[builtins.int] snapshots_to_keep: How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        pulumi.set(__self__, "days_of_months", days_of_months)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "minute", minute)
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)

    @property
    @pulumi.getter(name="daysOfMonths")
    def days_of_months(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.int]]]:
        """
        List of the days of the month when the snapshots will be created, valid range is from 1 to 30.
        """
        return pulumi.get(self, "days_of_months")

    @days_of_months.setter
    def days_of_months(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.int]]]):
        pulumi.set(self, "days_of_months", value)

    @property
    @pulumi.getter
    def hour(self) -> pulumi.Input[builtins.int]:
        """
        Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter
    def minute(self) -> pulumi.Input[builtins.int]:
        """
        Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "minute", value)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> pulumi.Input[builtins.int]:
        """
        How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "snapshots_to_keep", value)


if not MYPY:
    class SnapshotPolicyWeeklyScheduleArgsDict(TypedDict):
        days_of_weeks: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        List of the week days using English names when the snapshots will be created.
        """
        hour: pulumi.Input[builtins.int]
        """
        Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        """
        minute: pulumi.Input[builtins.int]
        """
        Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        """
        snapshots_to_keep: pulumi.Input[builtins.int]
        """
        How many hourly snapshots to keep, valid range is from 0 to 255.
        """
elif False:
    SnapshotPolicyWeeklyScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SnapshotPolicyWeeklyScheduleArgs:
    def __init__(__self__, *,
                 days_of_weeks: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 hour: pulumi.Input[builtins.int],
                 minute: pulumi.Input[builtins.int],
                 snapshots_to_keep: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] days_of_weeks: List of the week days using English names when the snapshots will be created.
        :param pulumi.Input[builtins.int] hour: Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        :param pulumi.Input[builtins.int] minute: Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        :param pulumi.Input[builtins.int] snapshots_to_keep: How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "minute", minute)
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)

    @property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of the week days using English names when the snapshots will be created.
        """
        return pulumi.get(self, "days_of_weeks")

    @days_of_weeks.setter
    def days_of_weeks(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "days_of_weeks", value)

    @property
    @pulumi.getter
    def hour(self) -> pulumi.Input[builtins.int]:
        """
        Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter
    def minute(self) -> pulumi.Input[builtins.int]:
        """
        Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "minute", value)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> pulumi.Input[builtins.int]:
        """
        How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "snapshots_to_keep", value)


if not MYPY:
    class VolumeDataProtectionBackupPolicyArgsDict(TypedDict):
        backup_policy_id: pulumi.Input[builtins.str]
        """
        Resource ID of the backup policy to apply to the volume.
        """
        backup_vault_id: pulumi.Input[builtins.str]
        """
        Resource ID of the backup backup vault to associate this volume to.
        """
        policy_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Enables the backup policy on the volume, defaults to `true`.

        For more information on Azure NetApp Files Backup feature please see [Understand Azure NetApp Files backup](https://learn.microsoft.com/en-us/azure/azure-netapp-files/backup-introduction)
        """
elif False:
    VolumeDataProtectionBackupPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeDataProtectionBackupPolicyArgs:
    def __init__(__self__, *,
                 backup_policy_id: pulumi.Input[builtins.str],
                 backup_vault_id: pulumi.Input[builtins.str],
                 policy_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] backup_policy_id: Resource ID of the backup policy to apply to the volume.
        :param pulumi.Input[builtins.str] backup_vault_id: Resource ID of the backup backup vault to associate this volume to.
        :param pulumi.Input[builtins.bool] policy_enabled: Enables the backup policy on the volume, defaults to `true`.
               
               For more information on Azure NetApp Files Backup feature please see [Understand Azure NetApp Files backup](https://learn.microsoft.com/en-us/azure/azure-netapp-files/backup-introduction)
        """
        pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        pulumi.set(__self__, "backup_vault_id", backup_vault_id)
        if policy_enabled is not None:
            pulumi.set(__self__, "policy_enabled", policy_enabled)

    @property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID of the backup policy to apply to the volume.
        """
        return pulumi.get(self, "backup_policy_id")

    @backup_policy_id.setter
    def backup_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "backup_policy_id", value)

    @property
    @pulumi.getter(name="backupVaultId")
    def backup_vault_id(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID of the backup backup vault to associate this volume to.
        """
        return pulumi.get(self, "backup_vault_id")

    @backup_vault_id.setter
    def backup_vault_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "backup_vault_id", value)

    @property
    @pulumi.getter(name="policyEnabled")
    def policy_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables the backup policy on the volume, defaults to `true`.

        For more information on Azure NetApp Files Backup feature please see [Understand Azure NetApp Files backup](https://learn.microsoft.com/en-us/azure/azure-netapp-files/backup-introduction)
        """
        return pulumi.get(self, "policy_enabled")

    @policy_enabled.setter
    def policy_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "policy_enabled", value)


if not MYPY:
    class VolumeDataProtectionReplicationArgsDict(TypedDict):
        remote_volume_location: pulumi.Input[builtins.str]
        """
        Location of the primary volume. Changing this forces a new resource to be created.
        """
        remote_volume_resource_id: pulumi.Input[builtins.str]
        """
        Resource ID of the primary volume.
        """
        replication_frequency: pulumi.Input[builtins.str]
        """
        Replication frequency, supported values are '10minutes', 'hourly', 'daily', values are case sensitive.

        A full example of the `data_protection_replication` attribute can be found in the `./examples/netapp/volume_crr` directory within the GitHub Repository

        > **Note:** `data_protection_replication` can be defined only once per secondary volume, adding a second instance of it is not supported.
        """
        endpoint_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The endpoint type, default value is `dst` for destination.
        """
elif False:
    VolumeDataProtectionReplicationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeDataProtectionReplicationArgs:
    def __init__(__self__, *,
                 remote_volume_location: pulumi.Input[builtins.str],
                 remote_volume_resource_id: pulumi.Input[builtins.str],
                 replication_frequency: pulumi.Input[builtins.str],
                 endpoint_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] remote_volume_location: Location of the primary volume. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] remote_volume_resource_id: Resource ID of the primary volume.
        :param pulumi.Input[builtins.str] replication_frequency: Replication frequency, supported values are '10minutes', 'hourly', 'daily', values are case sensitive.
               
               A full example of the `data_protection_replication` attribute can be found in the `./examples/netapp/volume_crr` directory within the GitHub Repository
               
               > **Note:** `data_protection_replication` can be defined only once per secondary volume, adding a second instance of it is not supported.
        :param pulumi.Input[builtins.str] endpoint_type: The endpoint type, default value is `dst` for destination.
        """
        pulumi.set(__self__, "remote_volume_location", remote_volume_location)
        pulumi.set(__self__, "remote_volume_resource_id", remote_volume_resource_id)
        pulumi.set(__self__, "replication_frequency", replication_frequency)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)

    @property
    @pulumi.getter(name="remoteVolumeLocation")
    def remote_volume_location(self) -> pulumi.Input[builtins.str]:
        """
        Location of the primary volume. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "remote_volume_location")

    @remote_volume_location.setter
    def remote_volume_location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "remote_volume_location", value)

    @property
    @pulumi.getter(name="remoteVolumeResourceId")
    def remote_volume_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID of the primary volume.
        """
        return pulumi.get(self, "remote_volume_resource_id")

    @remote_volume_resource_id.setter
    def remote_volume_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "remote_volume_resource_id", value)

    @property
    @pulumi.getter(name="replicationFrequency")
    def replication_frequency(self) -> pulumi.Input[builtins.str]:
        """
        Replication frequency, supported values are '10minutes', 'hourly', 'daily', values are case sensitive.

        A full example of the `data_protection_replication` attribute can be found in the `./examples/netapp/volume_crr` directory within the GitHub Repository

        > **Note:** `data_protection_replication` can be defined only once per secondary volume, adding a second instance of it is not supported.
        """
        return pulumi.get(self, "replication_frequency")

    @replication_frequency.setter
    def replication_frequency(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "replication_frequency", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint type, default value is `dst` for destination.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_type", value)


if not MYPY:
    class VolumeDataProtectionSnapshotPolicyArgsDict(TypedDict):
        snapshot_policy_id: pulumi.Input[builtins.str]
        """
        Resource ID of the snapshot policy to apply to the volume.

        A full example of the `data_protection_snapshot_policy` attribute usage can be found in the `./examples/netapp/nfsv3_volume_with_snapshot_policy` directory within the GitHub Repository

        > **Note:** `data_protection_snapshot_policy` block can be used alone or with data_protection_replication in the primary volume only, if enabling it in the secondary, an error will be thrown.
        """
elif False:
    VolumeDataProtectionSnapshotPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeDataProtectionSnapshotPolicyArgs:
    def __init__(__self__, *,
                 snapshot_policy_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] snapshot_policy_id: Resource ID of the snapshot policy to apply to the volume.
               
               A full example of the `data_protection_snapshot_policy` attribute usage can be found in the `./examples/netapp/nfsv3_volume_with_snapshot_policy` directory within the GitHub Repository
               
               > **Note:** `data_protection_snapshot_policy` block can be used alone or with data_protection_replication in the primary volume only, if enabling it in the secondary, an error will be thrown.
        """
        pulumi.set(__self__, "snapshot_policy_id", snapshot_policy_id)

    @property
    @pulumi.getter(name="snapshotPolicyId")
    def snapshot_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID of the snapshot policy to apply to the volume.

        A full example of the `data_protection_snapshot_policy` attribute usage can be found in the `./examples/netapp/nfsv3_volume_with_snapshot_policy` directory within the GitHub Repository

        > **Note:** `data_protection_snapshot_policy` block can be used alone or with data_protection_replication in the primary volume only, if enabling it in the secondary, an error will be thrown.
        """
        return pulumi.get(self, "snapshot_policy_id")

    @snapshot_policy_id.setter
    def snapshot_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "snapshot_policy_id", value)


if not MYPY:
    class VolumeExportPolicyRuleArgsDict(TypedDict):
        allowed_clients: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of allowed clients IPv4 addresses.
        """
        rule_index: pulumi.Input[builtins.int]
        """
        The index number of the rule.
        """
        kerberos5_read_only_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is Kerberos 5 read-only access permitted to this volume?
        """
        kerberos5_read_write_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is Kerberos 5 read/write permitted to this volume?
        """
        kerberos5i_read_only_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is Kerberos 5i read-only permitted to this volume?
        """
        kerberos5i_read_write_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is Kerberos 5i read/write permitted to this volume?
        """
        kerberos5p_read_only_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is Kerberos 5p read-only permitted to this volume?
        """
        kerberos5p_read_write_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is Kerberos 5p read/write permitted to this volume?
        """
        protocols_enabled: NotRequired[pulumi.Input[builtins.str]]
        """
        A list of allowed protocols. Valid values include `CIFS`, `NFSv3`, or `NFSv4.1`. Only one value is supported at this time. This replaces the previous arguments: `cifs_enabled`, `nfsv3_enabled` and `nfsv4_enabled`.
        """
        root_access_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is root access permitted to this volume?
        """
        unix_read_only: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is the file system on unix read only?
        """
        unix_read_write: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is the file system on unix read and write?
        """
elif False:
    VolumeExportPolicyRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeExportPolicyRuleArgs:
    def __init__(__self__, *,
                 allowed_clients: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 rule_index: pulumi.Input[builtins.int],
                 kerberos5_read_only_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 kerberos5_read_write_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 kerberos5i_read_only_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 kerberos5i_read_write_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 kerberos5p_read_only_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 kerberos5p_read_write_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 protocols_enabled: Optional[pulumi.Input[builtins.str]] = None,
                 root_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 unix_read_only: Optional[pulumi.Input[builtins.bool]] = None,
                 unix_read_write: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_clients: A list of allowed clients IPv4 addresses.
        :param pulumi.Input[builtins.int] rule_index: The index number of the rule.
        :param pulumi.Input[builtins.bool] kerberos5_read_only_enabled: Is Kerberos 5 read-only access permitted to this volume?
        :param pulumi.Input[builtins.bool] kerberos5_read_write_enabled: Is Kerberos 5 read/write permitted to this volume?
        :param pulumi.Input[builtins.bool] kerberos5i_read_only_enabled: Is Kerberos 5i read-only permitted to this volume?
        :param pulumi.Input[builtins.bool] kerberos5i_read_write_enabled: Is Kerberos 5i read/write permitted to this volume?
        :param pulumi.Input[builtins.bool] kerberos5p_read_only_enabled: Is Kerberos 5p read-only permitted to this volume?
        :param pulumi.Input[builtins.bool] kerberos5p_read_write_enabled: Is Kerberos 5p read/write permitted to this volume?
        :param pulumi.Input[builtins.str] protocols_enabled: A list of allowed protocols. Valid values include `CIFS`, `NFSv3`, or `NFSv4.1`. Only one value is supported at this time. This replaces the previous arguments: `cifs_enabled`, `nfsv3_enabled` and `nfsv4_enabled`.
        :param pulumi.Input[builtins.bool] root_access_enabled: Is root access permitted to this volume?
        :param pulumi.Input[builtins.bool] unix_read_only: Is the file system on unix read only?
        :param pulumi.Input[builtins.bool] unix_read_write: Is the file system on unix read and write?
        """
        pulumi.set(__self__, "allowed_clients", allowed_clients)
        pulumi.set(__self__, "rule_index", rule_index)
        if kerberos5_read_only_enabled is not None:
            pulumi.set(__self__, "kerberos5_read_only_enabled", kerberos5_read_only_enabled)
        if kerberos5_read_write_enabled is not None:
            pulumi.set(__self__, "kerberos5_read_write_enabled", kerberos5_read_write_enabled)
        if kerberos5i_read_only_enabled is not None:
            pulumi.set(__self__, "kerberos5i_read_only_enabled", kerberos5i_read_only_enabled)
        if kerberos5i_read_write_enabled is not None:
            pulumi.set(__self__, "kerberos5i_read_write_enabled", kerberos5i_read_write_enabled)
        if kerberos5p_read_only_enabled is not None:
            pulumi.set(__self__, "kerberos5p_read_only_enabled", kerberos5p_read_only_enabled)
        if kerberos5p_read_write_enabled is not None:
            pulumi.set(__self__, "kerberos5p_read_write_enabled", kerberos5p_read_write_enabled)
        if protocols_enabled is not None:
            pulumi.set(__self__, "protocols_enabled", protocols_enabled)
        if root_access_enabled is not None:
            pulumi.set(__self__, "root_access_enabled", root_access_enabled)
        if unix_read_only is not None:
            pulumi.set(__self__, "unix_read_only", unix_read_only)
        if unix_read_write is not None:
            pulumi.set(__self__, "unix_read_write", unix_read_write)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of allowed clients IPv4 addresses.
        """
        return pulumi.get(self, "allowed_clients")

    @allowed_clients.setter
    def allowed_clients(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "allowed_clients", value)

    @property
    @pulumi.getter(name="ruleIndex")
    def rule_index(self) -> pulumi.Input[builtins.int]:
        """
        The index number of the rule.
        """
        return pulumi.get(self, "rule_index")

    @rule_index.setter
    def rule_index(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "rule_index", value)

    @property
    @pulumi.getter(name="kerberos5ReadOnlyEnabled")
    def kerberos5_read_only_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Kerberos 5 read-only access permitted to this volume?
        """
        return pulumi.get(self, "kerberos5_read_only_enabled")

    @kerberos5_read_only_enabled.setter
    def kerberos5_read_only_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "kerberos5_read_only_enabled", value)

    @property
    @pulumi.getter(name="kerberos5ReadWriteEnabled")
    def kerberos5_read_write_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Kerberos 5 read/write permitted to this volume?
        """
        return pulumi.get(self, "kerberos5_read_write_enabled")

    @kerberos5_read_write_enabled.setter
    def kerberos5_read_write_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "kerberos5_read_write_enabled", value)

    @property
    @pulumi.getter(name="kerberos5iReadOnlyEnabled")
    def kerberos5i_read_only_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Kerberos 5i read-only permitted to this volume?
        """
        return pulumi.get(self, "kerberos5i_read_only_enabled")

    @kerberos5i_read_only_enabled.setter
    def kerberos5i_read_only_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "kerberos5i_read_only_enabled", value)

    @property
    @pulumi.getter(name="kerberos5iReadWriteEnabled")
    def kerberos5i_read_write_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Kerberos 5i read/write permitted to this volume?
        """
        return pulumi.get(self, "kerberos5i_read_write_enabled")

    @kerberos5i_read_write_enabled.setter
    def kerberos5i_read_write_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "kerberos5i_read_write_enabled", value)

    @property
    @pulumi.getter(name="kerberos5pReadOnlyEnabled")
    def kerberos5p_read_only_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Kerberos 5p read-only permitted to this volume?
        """
        return pulumi.get(self, "kerberos5p_read_only_enabled")

    @kerberos5p_read_only_enabled.setter
    def kerberos5p_read_only_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "kerberos5p_read_only_enabled", value)

    @property
    @pulumi.getter(name="kerberos5pReadWriteEnabled")
    def kerberos5p_read_write_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is Kerberos 5p read/write permitted to this volume?
        """
        return pulumi.get(self, "kerberos5p_read_write_enabled")

    @kerberos5p_read_write_enabled.setter
    def kerberos5p_read_write_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "kerberos5p_read_write_enabled", value)

    @property
    @pulumi.getter(name="protocolsEnabled")
    def protocols_enabled(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A list of allowed protocols. Valid values include `CIFS`, `NFSv3`, or `NFSv4.1`. Only one value is supported at this time. This replaces the previous arguments: `cifs_enabled`, `nfsv3_enabled` and `nfsv4_enabled`.
        """
        return pulumi.get(self, "protocols_enabled")

    @protocols_enabled.setter
    def protocols_enabled(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocols_enabled", value)

    @property
    @pulumi.getter(name="rootAccessEnabled")
    def root_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is root access permitted to this volume?
        """
        return pulumi.get(self, "root_access_enabled")

    @root_access_enabled.setter
    def root_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "root_access_enabled", value)

    @property
    @pulumi.getter(name="unixReadOnly")
    def unix_read_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the file system on unix read only?
        """
        return pulumi.get(self, "unix_read_only")

    @unix_read_only.setter
    def unix_read_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unix_read_only", value)

    @property
    @pulumi.getter(name="unixReadWrite")
    def unix_read_write(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the file system on unix read and write?
        """
        return pulumi.get(self, "unix_read_write")

    @unix_read_write.setter
    def unix_read_write(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unix_read_write", value)


if not MYPY:
    class VolumeGroupOracleVolumeArgsDict(TypedDict):
        capacity_pool_id: pulumi.Input[builtins.str]
        """
        The ID of the Capacity Pool. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        export_policy_rules: pulumi.Input[Sequence[pulumi.Input['VolumeGroupOracleVolumeExportPolicyRuleArgsDict']]]
        """
        One or more `export_policy_rule` blocks as defined below.
        """
        name: pulumi.Input[builtins.str]
        """
        The name which should be used for this volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        protocols: pulumi.Input[builtins.str]
        """
        The target volume protocol expressed as a list. Changing this forces a new Application Volume Group to be created and data will be lost. Supported values for Application Volume Group include `NFSv3` or `NFSv4.1`.
        """
        security_style: pulumi.Input[builtins.str]
        """
        Volume security style. Possible values are `ntfs` and `unix`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        service_level: pulumi.Input[builtins.str]
        """
        Volume security style. Possible values are `Premium`, `Standard` and `Ultra`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        snapshot_directory_visible: pulumi.Input[builtins.bool]
        """
        Specifies whether the .snapshot (NFS clients) path of a volume is visible. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        storage_quota_in_gb: pulumi.Input[builtins.int]
        """
        The maximum Storage Quota allowed for a file system in Gigabytes.
        """
        subnet_id: pulumi.Input[builtins.str]
        """
        The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        throughput_in_mibps: pulumi.Input[builtins.float]
        """
        Throughput of this volume in Mibps.
        """
        volume_path: pulumi.Input[builtins.str]
        """
        A unique file path for the volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        volume_spec_name: pulumi.Input[builtins.str]
        """
        Volume specification name. Possible values are `ora-data1` through `ora-data8`, `ora-log`, `ora-log-mirror`, `ora-backup` and `ora-binary`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        data_protection_replication: NotRequired[pulumi.Input['VolumeGroupOracleVolumeDataProtectionReplicationArgsDict']]
        """
        A `data_protection_replication` block as defined below. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        data_protection_snapshot_policy: NotRequired[pulumi.Input['VolumeGroupOracleVolumeDataProtectionSnapshotPolicyArgsDict']]
        """
        A `data_protection_snapshot_policy` block as defined below.
        """
        encryption_key_source: NotRequired[pulumi.Input[builtins.str]]
        """
        The encryption key source, it can be `Microsoft.NetApp` for platform managed keys or `Microsoft.KeyVault` for customer-managed keys. This is required with `key_vault_private_endpoint_id`. Changing this forces a new resource to be created.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the Application Volume Group.
        """
        key_vault_private_endpoint_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Private Endpoint ID for Key Vault, which is required when using customer-managed keys. This is required with `encryption_key_source`. Changing this forces a new resource to be created.
        """
        mount_ip_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        network_features: NotRequired[pulumi.Input[builtins.str]]
        """
        Indicates which network feature to use, accepted values are `Basic` or `Standard`, it defaults to `Basic` if not defined. This is a feature in public preview and for more information about it and how to register, please refer to [Configure network features for an Azure NetApp Files volume](https://docs.microsoft.com/en-us/azure/azure-netapp-files/configure-network-features). This is required if enabling customer managed keys encryption scenario.
        """
        proximity_placement_group_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the proximity placement group (PPG). Changing this forces a new Application Volume Group to be created and data will be lost. 

        > **Note:** For Oracle application, it is required to have PPG enabled so Azure NetApp Files can pin the volumes next to your compute resources, please check [Requirements and considerations for application volume group for Oracle](https://learn.microsoft.com/en-us/azure/azure-netapp-files/application-volume-group-oracle-considerations) for details and other requirements. Note that this cannot be used together with `zone`.
        """
        tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        A mapping of tags which should be assigned to the Application Volume Group.
        """
        zone: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the Availability Zone in which the Volume should be located. Possible values are `1`, `2` and `3`, depending on the Azure region. Changing this forces a new resource to be created. This feature is currently in preview, for more information on how to enable it, please refer to [Manage availability zone volume placement for Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/manage-availability-zone-volume-placement). Note that this cannot be used together with `proximity_placement_group_id`.
        """
elif False:
    VolumeGroupOracleVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeGroupOracleVolumeArgs:
    def __init__(__self__, *,
                 capacity_pool_id: pulumi.Input[builtins.str],
                 export_policy_rules: pulumi.Input[Sequence[pulumi.Input['VolumeGroupOracleVolumeExportPolicyRuleArgs']]],
                 name: pulumi.Input[builtins.str],
                 protocols: pulumi.Input[builtins.str],
                 security_style: pulumi.Input[builtins.str],
                 service_level: pulumi.Input[builtins.str],
                 snapshot_directory_visible: pulumi.Input[builtins.bool],
                 storage_quota_in_gb: pulumi.Input[builtins.int],
                 subnet_id: pulumi.Input[builtins.str],
                 throughput_in_mibps: pulumi.Input[builtins.float],
                 volume_path: pulumi.Input[builtins.str],
                 volume_spec_name: pulumi.Input[builtins.str],
                 data_protection_replication: Optional[pulumi.Input['VolumeGroupOracleVolumeDataProtectionReplicationArgs']] = None,
                 data_protection_snapshot_policy: Optional[pulumi.Input['VolumeGroupOracleVolumeDataProtectionSnapshotPolicyArgs']] = None,
                 encryption_key_source: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_private_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 mount_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 network_features: Optional[pulumi.Input[builtins.str]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] capacity_pool_id: The ID of the Capacity Pool. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupOracleVolumeExportPolicyRuleArgs']]] export_policy_rules: One or more `export_policy_rule` blocks as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] protocols: The target volume protocol expressed as a list. Changing this forces a new Application Volume Group to be created and data will be lost. Supported values for Application Volume Group include `NFSv3` or `NFSv4.1`.
        :param pulumi.Input[builtins.str] security_style: Volume security style. Possible values are `ntfs` and `unix`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] service_level: Volume security style. Possible values are `Premium`, `Standard` and `Ultra`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.bool] snapshot_directory_visible: Specifies whether the .snapshot (NFS clients) path of a volume is visible. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.int] storage_quota_in_gb: The maximum Storage Quota allowed for a file system in Gigabytes.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.float] throughput_in_mibps: Throughput of this volume in Mibps.
        :param pulumi.Input[builtins.str] volume_path: A unique file path for the volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] volume_spec_name: Volume specification name. Possible values are `ora-data1` through `ora-data8`, `ora-log`, `ora-log-mirror`, `ora-backup` and `ora-binary`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input['VolumeGroupOracleVolumeDataProtectionReplicationArgs'] data_protection_replication: A `data_protection_replication` block as defined below. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input['VolumeGroupOracleVolumeDataProtectionSnapshotPolicyArgs'] data_protection_snapshot_policy: A `data_protection_snapshot_policy` block as defined below.
        :param pulumi.Input[builtins.str] encryption_key_source: The encryption key source, it can be `Microsoft.NetApp` for platform managed keys or `Microsoft.KeyVault` for customer-managed keys. This is required with `key_vault_private_endpoint_id`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] id: The ID of the Application Volume Group.
        :param pulumi.Input[builtins.str] key_vault_private_endpoint_id: The Private Endpoint ID for Key Vault, which is required when using customer-managed keys. This is required with `encryption_key_source`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] network_features: Indicates which network feature to use, accepted values are `Basic` or `Standard`, it defaults to `Basic` if not defined. This is a feature in public preview and for more information about it and how to register, please refer to [Configure network features for an Azure NetApp Files volume](https://docs.microsoft.com/en-us/azure/azure-netapp-files/configure-network-features). This is required if enabling customer managed keys encryption scenario.
        :param pulumi.Input[builtins.str] proximity_placement_group_id: The ID of the proximity placement group (PPG). Changing this forces a new Application Volume Group to be created and data will be lost. 
               
               > **Note:** For Oracle application, it is required to have PPG enabled so Azure NetApp Files can pin the volumes next to your compute resources, please check [Requirements and considerations for application volume group for Oracle](https://learn.microsoft.com/en-us/azure/azure-netapp-files/application-volume-group-oracle-considerations) for details and other requirements. Note that this cannot be used together with `zone`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Application Volume Group.
        :param pulumi.Input[builtins.str] zone: Specifies the Availability Zone in which the Volume should be located. Possible values are `1`, `2` and `3`, depending on the Azure region. Changing this forces a new resource to be created. This feature is currently in preview, for more information on how to enable it, please refer to [Manage availability zone volume placement for Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/manage-availability-zone-volume-placement). Note that this cannot be used together with `proximity_placement_group_id`.
        """
        pulumi.set(__self__, "capacity_pool_id", capacity_pool_id)
        pulumi.set(__self__, "export_policy_rules", export_policy_rules)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "security_style", security_style)
        pulumi.set(__self__, "service_level", service_level)
        pulumi.set(__self__, "snapshot_directory_visible", snapshot_directory_visible)
        pulumi.set(__self__, "storage_quota_in_gb", storage_quota_in_gb)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "throughput_in_mibps", throughput_in_mibps)
        pulumi.set(__self__, "volume_path", volume_path)
        pulumi.set(__self__, "volume_spec_name", volume_spec_name)
        if data_protection_replication is not None:
            pulumi.set(__self__, "data_protection_replication", data_protection_replication)
        if data_protection_snapshot_policy is not None:
            pulumi.set(__self__, "data_protection_snapshot_policy", data_protection_snapshot_policy)
        if encryption_key_source is not None:
            pulumi.set(__self__, "encryption_key_source", encryption_key_source)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if key_vault_private_endpoint_id is not None:
            pulumi.set(__self__, "key_vault_private_endpoint_id", key_vault_private_endpoint_id)
        if mount_ip_addresses is not None:
            pulumi.set(__self__, "mount_ip_addresses", mount_ip_addresses)
        if network_features is not None:
            pulumi.set(__self__, "network_features", network_features)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="capacityPoolId")
    def capacity_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Capacity Pool. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "capacity_pool_id")

    @capacity_pool_id.setter
    def capacity_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "capacity_pool_id", value)

    @property
    @pulumi.getter(name="exportPolicyRules")
    def export_policy_rules(self) -> pulumi.Input[Sequence[pulumi.Input['VolumeGroupOracleVolumeExportPolicyRuleArgs']]]:
        """
        One or more `export_policy_rule` blocks as defined below.
        """
        return pulumi.get(self, "export_policy_rules")

    @export_policy_rules.setter
    def export_policy_rules(self, value: pulumi.Input[Sequence[pulumi.Input['VolumeGroupOracleVolumeExportPolicyRuleArgs']]]):
        pulumi.set(self, "export_policy_rules", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name which should be used for this volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocols(self) -> pulumi.Input[builtins.str]:
        """
        The target volume protocol expressed as a list. Changing this forces a new Application Volume Group to be created and data will be lost. Supported values for Application Volume Group include `NFSv3` or `NFSv4.1`.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> pulumi.Input[builtins.str]:
        """
        Volume security style. Possible values are `ntfs` and `unix`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "security_style")

    @security_style.setter
    def security_style(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "security_style", value)

    @property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> pulumi.Input[builtins.str]:
        """
        Volume security style. Possible values are `Premium`, `Standard` and `Ultra`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "service_level")

    @service_level.setter
    def service_level(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_level", value)

    @property
    @pulumi.getter(name="snapshotDirectoryVisible")
    def snapshot_directory_visible(self) -> pulumi.Input[builtins.bool]:
        """
        Specifies whether the .snapshot (NFS clients) path of a volume is visible. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "snapshot_directory_visible")

    @snapshot_directory_visible.setter
    def snapshot_directory_visible(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "snapshot_directory_visible", value)

    @property
    @pulumi.getter(name="storageQuotaInGb")
    def storage_quota_in_gb(self) -> pulumi.Input[builtins.int]:
        """
        The maximum Storage Quota allowed for a file system in Gigabytes.
        """
        return pulumi.get(self, "storage_quota_in_gb")

    @storage_quota_in_gb.setter
    def storage_quota_in_gb(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "storage_quota_in_gb", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="throughputInMibps")
    def throughput_in_mibps(self) -> pulumi.Input[builtins.float]:
        """
        Throughput of this volume in Mibps.
        """
        return pulumi.get(self, "throughput_in_mibps")

    @throughput_in_mibps.setter
    def throughput_in_mibps(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "throughput_in_mibps", value)

    @property
    @pulumi.getter(name="volumePath")
    def volume_path(self) -> pulumi.Input[builtins.str]:
        """
        A unique file path for the volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "volume_path")

    @volume_path.setter
    def volume_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "volume_path", value)

    @property
    @pulumi.getter(name="volumeSpecName")
    def volume_spec_name(self) -> pulumi.Input[builtins.str]:
        """
        Volume specification name. Possible values are `ora-data1` through `ora-data8`, `ora-log`, `ora-log-mirror`, `ora-backup` and `ora-binary`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "volume_spec_name")

    @volume_spec_name.setter
    def volume_spec_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "volume_spec_name", value)

    @property
    @pulumi.getter(name="dataProtectionReplication")
    def data_protection_replication(self) -> Optional[pulumi.Input['VolumeGroupOracleVolumeDataProtectionReplicationArgs']]:
        """
        A `data_protection_replication` block as defined below. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "data_protection_replication")

    @data_protection_replication.setter
    def data_protection_replication(self, value: Optional[pulumi.Input['VolumeGroupOracleVolumeDataProtectionReplicationArgs']]):
        pulumi.set(self, "data_protection_replication", value)

    @property
    @pulumi.getter(name="dataProtectionSnapshotPolicy")
    def data_protection_snapshot_policy(self) -> Optional[pulumi.Input['VolumeGroupOracleVolumeDataProtectionSnapshotPolicyArgs']]:
        """
        A `data_protection_snapshot_policy` block as defined below.
        """
        return pulumi.get(self, "data_protection_snapshot_policy")

    @data_protection_snapshot_policy.setter
    def data_protection_snapshot_policy(self, value: Optional[pulumi.Input['VolumeGroupOracleVolumeDataProtectionSnapshotPolicyArgs']]):
        pulumi.set(self, "data_protection_snapshot_policy", value)

    @property
    @pulumi.getter(name="encryptionKeySource")
    def encryption_key_source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The encryption key source, it can be `Microsoft.NetApp` for platform managed keys or `Microsoft.KeyVault` for customer-managed keys. This is required with `key_vault_private_endpoint_id`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_key_source")

    @encryption_key_source.setter
    def encryption_key_source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encryption_key_source", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Application Volume Group.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="keyVaultPrivateEndpointId")
    def key_vault_private_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Private Endpoint ID for Key Vault, which is required when using customer-managed keys. This is required with `encryption_key_source`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_private_endpoint_id")

    @key_vault_private_endpoint_id.setter
    def key_vault_private_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_private_endpoint_id", value)

    @property
    @pulumi.getter(name="mountIpAddresses")
    def mount_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "mount_ip_addresses")

    @mount_ip_addresses.setter
    def mount_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "mount_ip_addresses", value)

    @property
    @pulumi.getter(name="networkFeatures")
    def network_features(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates which network feature to use, accepted values are `Basic` or `Standard`, it defaults to `Basic` if not defined. This is a feature in public preview and for more information about it and how to register, please refer to [Configure network features for an Azure NetApp Files volume](https://docs.microsoft.com/en-us/azure/azure-netapp-files/configure-network-features). This is required if enabling customer managed keys encryption scenario.
        """
        return pulumi.get(self, "network_features")

    @network_features.setter
    def network_features(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_features", value)

    @property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the proximity placement group (PPG). Changing this forces a new Application Volume Group to be created and data will be lost. 

        > **Note:** For Oracle application, it is required to have PPG enabled so Azure NetApp Files can pin the volumes next to your compute resources, please check [Requirements and considerations for application volume group for Oracle](https://learn.microsoft.com/en-us/azure/azure-netapp-files/application-volume-group-oracle-considerations) for details and other requirements. Note that this cannot be used together with `zone`.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Application Volume Group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Availability Zone in which the Volume should be located. Possible values are `1`, `2` and `3`, depending on the Azure region. Changing this forces a new resource to be created. This feature is currently in preview, for more information on how to enable it, please refer to [Manage availability zone volume placement for Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/manage-availability-zone-volume-placement). Note that this cannot be used together with `proximity_placement_group_id`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class VolumeGroupOracleVolumeDataProtectionReplicationArgsDict(TypedDict):
        remote_volume_location: pulumi.Input[builtins.str]
        """
        Location of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        remote_volume_resource_id: pulumi.Input[builtins.str]
        """
        Resource ID of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        replication_frequency: pulumi.Input[builtins.str]
        """
        Replication frequency. Possible values are `10minutes`, `daily` and `hourly`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        endpoint_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The endpoint type. Possible values are `dst` and `src`. Defaults to `dst`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
elif False:
    VolumeGroupOracleVolumeDataProtectionReplicationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeGroupOracleVolumeDataProtectionReplicationArgs:
    def __init__(__self__, *,
                 remote_volume_location: pulumi.Input[builtins.str],
                 remote_volume_resource_id: pulumi.Input[builtins.str],
                 replication_frequency: pulumi.Input[builtins.str],
                 endpoint_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] remote_volume_location: Location of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] remote_volume_resource_id: Resource ID of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] replication_frequency: Replication frequency. Possible values are `10minutes`, `daily` and `hourly`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] endpoint_type: The endpoint type. Possible values are `dst` and `src`. Defaults to `dst`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        pulumi.set(__self__, "remote_volume_location", remote_volume_location)
        pulumi.set(__self__, "remote_volume_resource_id", remote_volume_resource_id)
        pulumi.set(__self__, "replication_frequency", replication_frequency)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)

    @property
    @pulumi.getter(name="remoteVolumeLocation")
    def remote_volume_location(self) -> pulumi.Input[builtins.str]:
        """
        Location of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "remote_volume_location")

    @remote_volume_location.setter
    def remote_volume_location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "remote_volume_location", value)

    @property
    @pulumi.getter(name="remoteVolumeResourceId")
    def remote_volume_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "remote_volume_resource_id")

    @remote_volume_resource_id.setter
    def remote_volume_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "remote_volume_resource_id", value)

    @property
    @pulumi.getter(name="replicationFrequency")
    def replication_frequency(self) -> pulumi.Input[builtins.str]:
        """
        Replication frequency. Possible values are `10minutes`, `daily` and `hourly`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "replication_frequency")

    @replication_frequency.setter
    def replication_frequency(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "replication_frequency", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint type. Possible values are `dst` and `src`. Defaults to `dst`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_type", value)


if not MYPY:
    class VolumeGroupOracleVolumeDataProtectionSnapshotPolicyArgsDict(TypedDict):
        snapshot_policy_id: pulumi.Input[builtins.str]
        """
        Resource ID of the snapshot policy to apply to the volume.
        """
elif False:
    VolumeGroupOracleVolumeDataProtectionSnapshotPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeGroupOracleVolumeDataProtectionSnapshotPolicyArgs:
    def __init__(__self__, *,
                 snapshot_policy_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] snapshot_policy_id: Resource ID of the snapshot policy to apply to the volume.
        """
        pulumi.set(__self__, "snapshot_policy_id", snapshot_policy_id)

    @property
    @pulumi.getter(name="snapshotPolicyId")
    def snapshot_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID of the snapshot policy to apply to the volume.
        """
        return pulumi.get(self, "snapshot_policy_id")

    @snapshot_policy_id.setter
    def snapshot_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "snapshot_policy_id", value)


if not MYPY:
    class VolumeGroupOracleVolumeExportPolicyRuleArgsDict(TypedDict):
        allowed_clients: pulumi.Input[builtins.str]
        """
        A comma-sperated list of allowed client IPv4 addresses.
        """
        nfsv3_enabled: pulumi.Input[builtins.bool]
        """
        Enables NFSv3. Please note that this cannot be enabled if volume has NFSv4.1 as its protocol.
        """
        nfsv41_enabled: pulumi.Input[builtins.bool]
        """
        Enables NFSv4.1. Please note that this cannot be enabled if volume has NFSv3 as its protocol.
        """
        rule_index: pulumi.Input[builtins.int]
        """
        The index number of the rule, must start at 1 and maximum 5.
        """
        root_access_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is root access permitted to this volume? Defaults to `true`.
        """
        unix_read_only: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is the file system on unix read only? Defaults to `false.
        """
        unix_read_write: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is the file system on unix read and write? Defaults to `true`.
        """
elif False:
    VolumeGroupOracleVolumeExportPolicyRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeGroupOracleVolumeExportPolicyRuleArgs:
    def __init__(__self__, *,
                 allowed_clients: pulumi.Input[builtins.str],
                 nfsv3_enabled: pulumi.Input[builtins.bool],
                 nfsv41_enabled: pulumi.Input[builtins.bool],
                 rule_index: pulumi.Input[builtins.int],
                 root_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 unix_read_only: Optional[pulumi.Input[builtins.bool]] = None,
                 unix_read_write: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] allowed_clients: A comma-sperated list of allowed client IPv4 addresses.
        :param pulumi.Input[builtins.bool] nfsv3_enabled: Enables NFSv3. Please note that this cannot be enabled if volume has NFSv4.1 as its protocol.
        :param pulumi.Input[builtins.bool] nfsv41_enabled: Enables NFSv4.1. Please note that this cannot be enabled if volume has NFSv3 as its protocol.
        :param pulumi.Input[builtins.int] rule_index: The index number of the rule, must start at 1 and maximum 5.
        :param pulumi.Input[builtins.bool] root_access_enabled: Is root access permitted to this volume? Defaults to `true`.
        :param pulumi.Input[builtins.bool] unix_read_only: Is the file system on unix read only? Defaults to `false.
        :param pulumi.Input[builtins.bool] unix_read_write: Is the file system on unix read and write? Defaults to `true`.
        """
        pulumi.set(__self__, "allowed_clients", allowed_clients)
        pulumi.set(__self__, "nfsv3_enabled", nfsv3_enabled)
        pulumi.set(__self__, "nfsv41_enabled", nfsv41_enabled)
        pulumi.set(__self__, "rule_index", rule_index)
        if root_access_enabled is not None:
            pulumi.set(__self__, "root_access_enabled", root_access_enabled)
        if unix_read_only is not None:
            pulumi.set(__self__, "unix_read_only", unix_read_only)
        if unix_read_write is not None:
            pulumi.set(__self__, "unix_read_write", unix_read_write)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> pulumi.Input[builtins.str]:
        """
        A comma-sperated list of allowed client IPv4 addresses.
        """
        return pulumi.get(self, "allowed_clients")

    @allowed_clients.setter
    def allowed_clients(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "allowed_clients", value)

    @property
    @pulumi.getter(name="nfsv3Enabled")
    def nfsv3_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Enables NFSv3. Please note that this cannot be enabled if volume has NFSv4.1 as its protocol.
        """
        return pulumi.get(self, "nfsv3_enabled")

    @nfsv3_enabled.setter
    def nfsv3_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "nfsv3_enabled", value)

    @property
    @pulumi.getter(name="nfsv41Enabled")
    def nfsv41_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Enables NFSv4.1. Please note that this cannot be enabled if volume has NFSv3 as its protocol.
        """
        return pulumi.get(self, "nfsv41_enabled")

    @nfsv41_enabled.setter
    def nfsv41_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "nfsv41_enabled", value)

    @property
    @pulumi.getter(name="ruleIndex")
    def rule_index(self) -> pulumi.Input[builtins.int]:
        """
        The index number of the rule, must start at 1 and maximum 5.
        """
        return pulumi.get(self, "rule_index")

    @rule_index.setter
    def rule_index(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "rule_index", value)

    @property
    @pulumi.getter(name="rootAccessEnabled")
    def root_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is root access permitted to this volume? Defaults to `true`.
        """
        return pulumi.get(self, "root_access_enabled")

    @root_access_enabled.setter
    def root_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "root_access_enabled", value)

    @property
    @pulumi.getter(name="unixReadOnly")
    def unix_read_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the file system on unix read only? Defaults to `false.
        """
        return pulumi.get(self, "unix_read_only")

    @unix_read_only.setter
    def unix_read_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unix_read_only", value)

    @property
    @pulumi.getter(name="unixReadWrite")
    def unix_read_write(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the file system on unix read and write? Defaults to `true`.
        """
        return pulumi.get(self, "unix_read_write")

    @unix_read_write.setter
    def unix_read_write(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unix_read_write", value)


if not MYPY:
    class VolumeGroupSapHanaVolumeArgsDict(TypedDict):
        capacity_pool_id: pulumi.Input[builtins.str]
        """
        The ID of the Capacity Pool. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        export_policy_rules: pulumi.Input[Sequence[pulumi.Input['VolumeGroupSapHanaVolumeExportPolicyRuleArgsDict']]]
        """
        One or more `export_policy_rule` blocks as defined below.
        """
        name: pulumi.Input[builtins.str]
        """
        The name which should be used for this volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        protocols: pulumi.Input[builtins.str]
        """
        The target volume protocol expressed as a list. Changing this forces a new Application Volume Group to be created and data will be lost. Supported values for Application Volume Group include `NFSv3` or `NFSv4.1`, multi-protocol is not supported and there are certain rules on which protocol is supporteed per volume spec, please check [Configure application volume groups for the SAP HANA REST API](https://learn.microsoft.com/en-us/azure/azure-netapp-files/configure-application-volume-group-sap-hana-api) document for details.
        """
        security_style: pulumi.Input[builtins.str]
        """
        Volume security style. Possible values are `ntfs` and `unix`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        service_level: pulumi.Input[builtins.str]
        """
        Volume security style. Possible values are `Premium`, `Standard` and `Ultra`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        snapshot_directory_visible: pulumi.Input[builtins.bool]
        """
        Specifies whether the .snapshot (NFS clients) path of a volume is visible. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        storage_quota_in_gb: pulumi.Input[builtins.int]
        """
        The maximum Storage Quota allowed for a file system in Gigabytes.
        """
        subnet_id: pulumi.Input[builtins.str]
        """
        The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        throughput_in_mibps: pulumi.Input[builtins.float]
        """
        Throughput of this volume in Mibps.
        """
        volume_path: pulumi.Input[builtins.str]
        """
        A unique file path for the volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        volume_spec_name: pulumi.Input[builtins.str]
        """
        Volume specification name. Possible values are `data`, `log`, `shared`, `data-backup` and `log-backup`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        data_protection_replication: NotRequired[pulumi.Input['VolumeGroupSapHanaVolumeDataProtectionReplicationArgsDict']]
        """
        A `data_protection_replication` block as defined below. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        data_protection_snapshot_policy: NotRequired[pulumi.Input['VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyArgsDict']]
        """
        A `data_protection_snapshot_policy` block as defined below.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the Application Volume Group.
        """
        mount_ip_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        proximity_placement_group_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the proximity placement group. Changing this forces a new Application Volume Group to be created and data will be lost. For SAP-HANA application, it is required to have PPG enabled so Azure NetApp Files can pin the volumes next to your compute resources, please check [Requirements and considerations for application volume group for SAP HANA](https://learn.microsoft.com/en-us/azure/azure-netapp-files/application-volume-group-considerations) for details and other requirements.
        """
        tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        A mapping of tags which should be assigned to the Application Volume Group.
        """
elif False:
    VolumeGroupSapHanaVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeGroupSapHanaVolumeArgs:
    def __init__(__self__, *,
                 capacity_pool_id: pulumi.Input[builtins.str],
                 export_policy_rules: pulumi.Input[Sequence[pulumi.Input['VolumeGroupSapHanaVolumeExportPolicyRuleArgs']]],
                 name: pulumi.Input[builtins.str],
                 protocols: pulumi.Input[builtins.str],
                 security_style: pulumi.Input[builtins.str],
                 service_level: pulumi.Input[builtins.str],
                 snapshot_directory_visible: pulumi.Input[builtins.bool],
                 storage_quota_in_gb: pulumi.Input[builtins.int],
                 subnet_id: pulumi.Input[builtins.str],
                 throughput_in_mibps: pulumi.Input[builtins.float],
                 volume_path: pulumi.Input[builtins.str],
                 volume_spec_name: pulumi.Input[builtins.str],
                 data_protection_replication: Optional[pulumi.Input['VolumeGroupSapHanaVolumeDataProtectionReplicationArgs']] = None,
                 data_protection_snapshot_policy: Optional[pulumi.Input['VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyArgs']] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 mount_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] capacity_pool_id: The ID of the Capacity Pool. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupSapHanaVolumeExportPolicyRuleArgs']]] export_policy_rules: One or more `export_policy_rule` blocks as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] protocols: The target volume protocol expressed as a list. Changing this forces a new Application Volume Group to be created and data will be lost. Supported values for Application Volume Group include `NFSv3` or `NFSv4.1`, multi-protocol is not supported and there are certain rules on which protocol is supporteed per volume spec, please check [Configure application volume groups for the SAP HANA REST API](https://learn.microsoft.com/en-us/azure/azure-netapp-files/configure-application-volume-group-sap-hana-api) document for details.
        :param pulumi.Input[builtins.str] security_style: Volume security style. Possible values are `ntfs` and `unix`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] service_level: Volume security style. Possible values are `Premium`, `Standard` and `Ultra`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.bool] snapshot_directory_visible: Specifies whether the .snapshot (NFS clients) path of a volume is visible. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.int] storage_quota_in_gb: The maximum Storage Quota allowed for a file system in Gigabytes.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.float] throughput_in_mibps: Throughput of this volume in Mibps.
        :param pulumi.Input[builtins.str] volume_path: A unique file path for the volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] volume_spec_name: Volume specification name. Possible values are `data`, `log`, `shared`, `data-backup` and `log-backup`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input['VolumeGroupSapHanaVolumeDataProtectionReplicationArgs'] data_protection_replication: A `data_protection_replication` block as defined below. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input['VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyArgs'] data_protection_snapshot_policy: A `data_protection_snapshot_policy` block as defined below.
        :param pulumi.Input[builtins.str] id: The ID of the Application Volume Group.
        :param pulumi.Input[builtins.str] proximity_placement_group_id: The ID of the proximity placement group. Changing this forces a new Application Volume Group to be created and data will be lost. For SAP-HANA application, it is required to have PPG enabled so Azure NetApp Files can pin the volumes next to your compute resources, please check [Requirements and considerations for application volume group for SAP HANA](https://learn.microsoft.com/en-us/azure/azure-netapp-files/application-volume-group-considerations) for details and other requirements.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Application Volume Group.
        """
        pulumi.set(__self__, "capacity_pool_id", capacity_pool_id)
        pulumi.set(__self__, "export_policy_rules", export_policy_rules)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "security_style", security_style)
        pulumi.set(__self__, "service_level", service_level)
        pulumi.set(__self__, "snapshot_directory_visible", snapshot_directory_visible)
        pulumi.set(__self__, "storage_quota_in_gb", storage_quota_in_gb)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "throughput_in_mibps", throughput_in_mibps)
        pulumi.set(__self__, "volume_path", volume_path)
        pulumi.set(__self__, "volume_spec_name", volume_spec_name)
        if data_protection_replication is not None:
            pulumi.set(__self__, "data_protection_replication", data_protection_replication)
        if data_protection_snapshot_policy is not None:
            pulumi.set(__self__, "data_protection_snapshot_policy", data_protection_snapshot_policy)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mount_ip_addresses is not None:
            pulumi.set(__self__, "mount_ip_addresses", mount_ip_addresses)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="capacityPoolId")
    def capacity_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Capacity Pool. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "capacity_pool_id")

    @capacity_pool_id.setter
    def capacity_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "capacity_pool_id", value)

    @property
    @pulumi.getter(name="exportPolicyRules")
    def export_policy_rules(self) -> pulumi.Input[Sequence[pulumi.Input['VolumeGroupSapHanaVolumeExportPolicyRuleArgs']]]:
        """
        One or more `export_policy_rule` blocks as defined below.
        """
        return pulumi.get(self, "export_policy_rules")

    @export_policy_rules.setter
    def export_policy_rules(self, value: pulumi.Input[Sequence[pulumi.Input['VolumeGroupSapHanaVolumeExportPolicyRuleArgs']]]):
        pulumi.set(self, "export_policy_rules", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name which should be used for this volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocols(self) -> pulumi.Input[builtins.str]:
        """
        The target volume protocol expressed as a list. Changing this forces a new Application Volume Group to be created and data will be lost. Supported values for Application Volume Group include `NFSv3` or `NFSv4.1`, multi-protocol is not supported and there are certain rules on which protocol is supporteed per volume spec, please check [Configure application volume groups for the SAP HANA REST API](https://learn.microsoft.com/en-us/azure/azure-netapp-files/configure-application-volume-group-sap-hana-api) document for details.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> pulumi.Input[builtins.str]:
        """
        Volume security style. Possible values are `ntfs` and `unix`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "security_style")

    @security_style.setter
    def security_style(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "security_style", value)

    @property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> pulumi.Input[builtins.str]:
        """
        Volume security style. Possible values are `Premium`, `Standard` and `Ultra`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "service_level")

    @service_level.setter
    def service_level(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_level", value)

    @property
    @pulumi.getter(name="snapshotDirectoryVisible")
    def snapshot_directory_visible(self) -> pulumi.Input[builtins.bool]:
        """
        Specifies whether the .snapshot (NFS clients) path of a volume is visible. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "snapshot_directory_visible")

    @snapshot_directory_visible.setter
    def snapshot_directory_visible(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "snapshot_directory_visible", value)

    @property
    @pulumi.getter(name="storageQuotaInGb")
    def storage_quota_in_gb(self) -> pulumi.Input[builtins.int]:
        """
        The maximum Storage Quota allowed for a file system in Gigabytes.
        """
        return pulumi.get(self, "storage_quota_in_gb")

    @storage_quota_in_gb.setter
    def storage_quota_in_gb(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "storage_quota_in_gb", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="throughputInMibps")
    def throughput_in_mibps(self) -> pulumi.Input[builtins.float]:
        """
        Throughput of this volume in Mibps.
        """
        return pulumi.get(self, "throughput_in_mibps")

    @throughput_in_mibps.setter
    def throughput_in_mibps(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "throughput_in_mibps", value)

    @property
    @pulumi.getter(name="volumePath")
    def volume_path(self) -> pulumi.Input[builtins.str]:
        """
        A unique file path for the volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "volume_path")

    @volume_path.setter
    def volume_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "volume_path", value)

    @property
    @pulumi.getter(name="volumeSpecName")
    def volume_spec_name(self) -> pulumi.Input[builtins.str]:
        """
        Volume specification name. Possible values are `data`, `log`, `shared`, `data-backup` and `log-backup`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "volume_spec_name")

    @volume_spec_name.setter
    def volume_spec_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "volume_spec_name", value)

    @property
    @pulumi.getter(name="dataProtectionReplication")
    def data_protection_replication(self) -> Optional[pulumi.Input['VolumeGroupSapHanaVolumeDataProtectionReplicationArgs']]:
        """
        A `data_protection_replication` block as defined below. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "data_protection_replication")

    @data_protection_replication.setter
    def data_protection_replication(self, value: Optional[pulumi.Input['VolumeGroupSapHanaVolumeDataProtectionReplicationArgs']]):
        pulumi.set(self, "data_protection_replication", value)

    @property
    @pulumi.getter(name="dataProtectionSnapshotPolicy")
    def data_protection_snapshot_policy(self) -> Optional[pulumi.Input['VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyArgs']]:
        """
        A `data_protection_snapshot_policy` block as defined below.
        """
        return pulumi.get(self, "data_protection_snapshot_policy")

    @data_protection_snapshot_policy.setter
    def data_protection_snapshot_policy(self, value: Optional[pulumi.Input['VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyArgs']]):
        pulumi.set(self, "data_protection_snapshot_policy", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Application Volume Group.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="mountIpAddresses")
    def mount_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "mount_ip_addresses")

    @mount_ip_addresses.setter
    def mount_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "mount_ip_addresses", value)

    @property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the proximity placement group. Changing this forces a new Application Volume Group to be created and data will be lost. For SAP-HANA application, it is required to have PPG enabled so Azure NetApp Files can pin the volumes next to your compute resources, please check [Requirements and considerations for application volume group for SAP HANA](https://learn.microsoft.com/en-us/azure/azure-netapp-files/application-volume-group-considerations) for details and other requirements.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Application Volume Group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class VolumeGroupSapHanaVolumeDataProtectionReplicationArgsDict(TypedDict):
        remote_volume_location: pulumi.Input[builtins.str]
        """
        Location of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        remote_volume_resource_id: pulumi.Input[builtins.str]
        """
        Resource ID of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        replication_frequency: pulumi.Input[builtins.str]
        """
        eplication frequency. Possible values are `10minutes`, `daily` and `hourly`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        endpoint_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The endpoint type. Possible values are `dst` and `src`. Defaults to `dst`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
elif False:
    VolumeGroupSapHanaVolumeDataProtectionReplicationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeGroupSapHanaVolumeDataProtectionReplicationArgs:
    def __init__(__self__, *,
                 remote_volume_location: pulumi.Input[builtins.str],
                 remote_volume_resource_id: pulumi.Input[builtins.str],
                 replication_frequency: pulumi.Input[builtins.str],
                 endpoint_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] remote_volume_location: Location of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] remote_volume_resource_id: Resource ID of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] replication_frequency: eplication frequency. Possible values are `10minutes`, `daily` and `hourly`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] endpoint_type: The endpoint type. Possible values are `dst` and `src`. Defaults to `dst`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        pulumi.set(__self__, "remote_volume_location", remote_volume_location)
        pulumi.set(__self__, "remote_volume_resource_id", remote_volume_resource_id)
        pulumi.set(__self__, "replication_frequency", replication_frequency)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)

    @property
    @pulumi.getter(name="remoteVolumeLocation")
    def remote_volume_location(self) -> pulumi.Input[builtins.str]:
        """
        Location of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "remote_volume_location")

    @remote_volume_location.setter
    def remote_volume_location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "remote_volume_location", value)

    @property
    @pulumi.getter(name="remoteVolumeResourceId")
    def remote_volume_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "remote_volume_resource_id")

    @remote_volume_resource_id.setter
    def remote_volume_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "remote_volume_resource_id", value)

    @property
    @pulumi.getter(name="replicationFrequency")
    def replication_frequency(self) -> pulumi.Input[builtins.str]:
        """
        eplication frequency. Possible values are `10minutes`, `daily` and `hourly`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "replication_frequency")

    @replication_frequency.setter
    def replication_frequency(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "replication_frequency", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint type. Possible values are `dst` and `src`. Defaults to `dst`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_type", value)


if not MYPY:
    class VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyArgsDict(TypedDict):
        snapshot_policy_id: pulumi.Input[builtins.str]
        """
        Resource ID of the snapshot policy to apply to the volume.
        """
elif False:
    VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyArgs:
    def __init__(__self__, *,
                 snapshot_policy_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] snapshot_policy_id: Resource ID of the snapshot policy to apply to the volume.
        """
        pulumi.set(__self__, "snapshot_policy_id", snapshot_policy_id)

    @property
    @pulumi.getter(name="snapshotPolicyId")
    def snapshot_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID of the snapshot policy to apply to the volume.
        """
        return pulumi.get(self, "snapshot_policy_id")

    @snapshot_policy_id.setter
    def snapshot_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "snapshot_policy_id", value)


if not MYPY:
    class VolumeGroupSapHanaVolumeExportPolicyRuleArgsDict(TypedDict):
        allowed_clients: pulumi.Input[builtins.str]
        """
        A comma-sperated list of allowed client IPv4 addresses.
        """
        nfsv3_enabled: pulumi.Input[builtins.bool]
        """
        Enables NFSv3. Please note that this cannot be enabled if volume has NFSv4.1 as its protocol.
        """
        nfsv41_enabled: pulumi.Input[builtins.bool]
        """
        Enables NFSv4.1. Please note that this cannot be enabled if volume has NFSv3 as its protocol.
        """
        rule_index: pulumi.Input[builtins.int]
        """
        The index number of the rule, must start at 1 and maximum 5.
        """
        root_access_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is root access permitted to this volume? Defaults to `true`.
        """
        unix_read_only: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is the file system on unix read only? Defaults to `false.
        """
        unix_read_write: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is the file system on unix read and write? Defaults to `true`.
        """
elif False:
    VolumeGroupSapHanaVolumeExportPolicyRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeGroupSapHanaVolumeExportPolicyRuleArgs:
    def __init__(__self__, *,
                 allowed_clients: pulumi.Input[builtins.str],
                 nfsv3_enabled: pulumi.Input[builtins.bool],
                 nfsv41_enabled: pulumi.Input[builtins.bool],
                 rule_index: pulumi.Input[builtins.int],
                 root_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 unix_read_only: Optional[pulumi.Input[builtins.bool]] = None,
                 unix_read_write: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] allowed_clients: A comma-sperated list of allowed client IPv4 addresses.
        :param pulumi.Input[builtins.bool] nfsv3_enabled: Enables NFSv3. Please note that this cannot be enabled if volume has NFSv4.1 as its protocol.
        :param pulumi.Input[builtins.bool] nfsv41_enabled: Enables NFSv4.1. Please note that this cannot be enabled if volume has NFSv3 as its protocol.
        :param pulumi.Input[builtins.int] rule_index: The index number of the rule, must start at 1 and maximum 5.
        :param pulumi.Input[builtins.bool] root_access_enabled: Is root access permitted to this volume? Defaults to `true`.
        :param pulumi.Input[builtins.bool] unix_read_only: Is the file system on unix read only? Defaults to `false.
        :param pulumi.Input[builtins.bool] unix_read_write: Is the file system on unix read and write? Defaults to `true`.
        """
        pulumi.set(__self__, "allowed_clients", allowed_clients)
        pulumi.set(__self__, "nfsv3_enabled", nfsv3_enabled)
        pulumi.set(__self__, "nfsv41_enabled", nfsv41_enabled)
        pulumi.set(__self__, "rule_index", rule_index)
        if root_access_enabled is not None:
            pulumi.set(__self__, "root_access_enabled", root_access_enabled)
        if unix_read_only is not None:
            pulumi.set(__self__, "unix_read_only", unix_read_only)
        if unix_read_write is not None:
            pulumi.set(__self__, "unix_read_write", unix_read_write)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> pulumi.Input[builtins.str]:
        """
        A comma-sperated list of allowed client IPv4 addresses.
        """
        return pulumi.get(self, "allowed_clients")

    @allowed_clients.setter
    def allowed_clients(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "allowed_clients", value)

    @property
    @pulumi.getter(name="nfsv3Enabled")
    def nfsv3_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Enables NFSv3. Please note that this cannot be enabled if volume has NFSv4.1 as its protocol.
        """
        return pulumi.get(self, "nfsv3_enabled")

    @nfsv3_enabled.setter
    def nfsv3_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "nfsv3_enabled", value)

    @property
    @pulumi.getter(name="nfsv41Enabled")
    def nfsv41_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Enables NFSv4.1. Please note that this cannot be enabled if volume has NFSv3 as its protocol.
        """
        return pulumi.get(self, "nfsv41_enabled")

    @nfsv41_enabled.setter
    def nfsv41_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "nfsv41_enabled", value)

    @property
    @pulumi.getter(name="ruleIndex")
    def rule_index(self) -> pulumi.Input[builtins.int]:
        """
        The index number of the rule, must start at 1 and maximum 5.
        """
        return pulumi.get(self, "rule_index")

    @rule_index.setter
    def rule_index(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "rule_index", value)

    @property
    @pulumi.getter(name="rootAccessEnabled")
    def root_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is root access permitted to this volume? Defaults to `true`.
        """
        return pulumi.get(self, "root_access_enabled")

    @root_access_enabled.setter
    def root_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "root_access_enabled", value)

    @property
    @pulumi.getter(name="unixReadOnly")
    def unix_read_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the file system on unix read only? Defaults to `false.
        """
        return pulumi.get(self, "unix_read_only")

    @unix_read_only.setter
    def unix_read_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unix_read_only", value)

    @property
    @pulumi.getter(name="unixReadWrite")
    def unix_read_write(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the file system on unix read and write? Defaults to `true`.
        """
        return pulumi.get(self, "unix_read_write")

    @unix_read_write.setter
    def unix_read_write(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unix_read_write", value)


if not MYPY:
    class GetAccountIdentityArgsDict(TypedDict):
        principal_id: builtins.str
        tenant_id: builtins.str
        type: builtins.str
        identity_ids: NotRequired[Sequence[builtins.str]]
elif False:
    GetAccountIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetAccountIdentityArgs:
    def __init__(__self__, *,
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None):
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: builtins.str):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: builtins.str):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: builtins.str):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[Sequence[builtins.str]]):
        pulumi.set(self, "identity_ids", value)


