# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAccountEncryptionResult',
    'AwaitableGetAccountEncryptionResult',
    'get_account_encryption',
    'get_account_encryption_output',
]

@pulumi.output_type
class GetAccountEncryptionResult:
    """
    A collection of values returned by getAccountEncryption.
    """
    def __init__(__self__, encryption_key=None, id=None, netapp_account_id=None, system_assigned_identity_principal_id=None, user_assigned_identity_id=None):
        if encryption_key and not isinstance(encryption_key, str):
            raise TypeError("Expected argument 'encryption_key' to be a str")
        pulumi.set(__self__, "encryption_key", encryption_key)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if netapp_account_id and not isinstance(netapp_account_id, str):
            raise TypeError("Expected argument 'netapp_account_id' to be a str")
        pulumi.set(__self__, "netapp_account_id", netapp_account_id)
        if system_assigned_identity_principal_id and not isinstance(system_assigned_identity_principal_id, str):
            raise TypeError("Expected argument 'system_assigned_identity_principal_id' to be a str")
        pulumi.set(__self__, "system_assigned_identity_principal_id", system_assigned_identity_principal_id)
        if user_assigned_identity_id and not isinstance(user_assigned_identity_id, str):
            raise TypeError("Expected argument 'user_assigned_identity_id' to be a str")
        pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> builtins.str:
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="netappAccountId")
    def netapp_account_id(self) -> builtins.str:
        return pulumi.get(self, "netapp_account_id")

    @property
    @pulumi.getter(name="systemAssignedIdentityPrincipalId")
    def system_assigned_identity_principal_id(self) -> builtins.str:
        return pulumi.get(self, "system_assigned_identity_principal_id")

    @property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> builtins.str:
        return pulumi.get(self, "user_assigned_identity_id")


class AwaitableGetAccountEncryptionResult(GetAccountEncryptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountEncryptionResult(
            encryption_key=self.encryption_key,
            id=self.id,
            netapp_account_id=self.netapp_account_id,
            system_assigned_identity_principal_id=self.system_assigned_identity_principal_id,
            user_assigned_identity_id=self.user_assigned_identity_id)


def get_account_encryption(netapp_account_id: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountEncryptionResult:
    """
    Use this data source to access information about an existing NetApp Account Encryption Resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.netapp.get_account_encryption(netapp_account_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.NetApp/netAppAccounts/account1")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.NetApp`: 2025-01-01


    :param builtins.str netapp_account_id: The ID of the NetApp account where customer managed keys-based encryption is enabled.
    """
    __args__ = dict()
    __args__['netappAccountId'] = netapp_account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:netapp/getAccountEncryption:getAccountEncryption', __args__, opts=opts, typ=GetAccountEncryptionResult).value

    return AwaitableGetAccountEncryptionResult(
        encryption_key=pulumi.get(__ret__, 'encryption_key'),
        id=pulumi.get(__ret__, 'id'),
        netapp_account_id=pulumi.get(__ret__, 'netapp_account_id'),
        system_assigned_identity_principal_id=pulumi.get(__ret__, 'system_assigned_identity_principal_id'),
        user_assigned_identity_id=pulumi.get(__ret__, 'user_assigned_identity_id'))
def get_account_encryption_output(netapp_account_id: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountEncryptionResult]:
    """
    Use this data source to access information about an existing NetApp Account Encryption Resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.netapp.get_account_encryption(netapp_account_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.NetApp/netAppAccounts/account1")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.NetApp`: 2025-01-01


    :param builtins.str netapp_account_id: The ID of the NetApp account where customer managed keys-based encryption is enabled.
    """
    __args__ = dict()
    __args__['netappAccountId'] = netapp_account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:netapp/getAccountEncryption:getAccountEncryption', __args__, opts=opts, typ=GetAccountEncryptionResult)
    return __ret__.apply(lambda __response__: GetAccountEncryptionResult(
        encryption_key=pulumi.get(__response__, 'encryption_key'),
        id=pulumi.get(__response__, 'id'),
        netapp_account_id=pulumi.get(__response__, 'netapp_account_id'),
        system_assigned_identity_principal_id=pulumi.get(__response__, 'system_assigned_identity_principal_id'),
        user_assigned_identity_id=pulumi.get(__response__, 'user_assigned_identity_id')))
