# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccountActiveDirectory',
    'AccountIdentity',
    'SnapshotPolicyDailySchedule',
    'SnapshotPolicyHourlySchedule',
    'SnapshotPolicyMonthlySchedule',
    'SnapshotPolicyWeeklySchedule',
    'VolumeDataProtectionBackupPolicy',
    'VolumeDataProtectionReplication',
    'VolumeDataProtectionSnapshotPolicy',
    'VolumeExportPolicyRule',
    'VolumeGroupOracleVolume',
    'VolumeGroupOracleVolumeDataProtectionReplication',
    'VolumeGroupOracleVolumeDataProtectionSnapshotPolicy',
    'VolumeGroupOracleVolumeExportPolicyRule',
    'VolumeGroupSapHanaVolume',
    'VolumeGroupSapHanaVolumeDataProtectionReplication',
    'VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy',
    'VolumeGroupSapHanaVolumeExportPolicyRule',
    'GetAccountIdentityResult',
    'GetSnapshotPolicyDailyScheduleResult',
    'GetSnapshotPolicyHourlyScheduleResult',
    'GetSnapshotPolicyMonthlyScheduleResult',
    'GetSnapshotPolicyWeeklyScheduleResult',
    'GetVolumeDataProtectionBackupPolicyResult',
    'GetVolumeDataProtectionReplicationResult',
    'GetVolumeGroupOracleVolumeResult',
    'GetVolumeGroupOracleVolumeDataProtectionReplicationResult',
    'GetVolumeGroupOracleVolumeDataProtectionSnapshotPolicyResult',
    'GetVolumeGroupOracleVolumeExportPolicyRuleResult',
    'GetVolumeGroupSapHanaVolumeResult',
    'GetVolumeGroupSapHanaVolumeDataProtectionReplicationResult',
    'GetVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyResult',
    'GetVolumeGroupSapHanaVolumeExportPolicyRuleResult',
]

@pulumi.output_type
class AccountActiveDirectory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServers":
            suggest = "dns_servers"
        elif key == "smbServerName":
            suggest = "smb_server_name"
        elif key == "aesEncryptionEnabled":
            suggest = "aes_encryption_enabled"
        elif key == "kerberosAdName":
            suggest = "kerberos_ad_name"
        elif key == "kerberosKdcIp":
            suggest = "kerberos_kdc_ip"
        elif key == "ldapOverTlsEnabled":
            suggest = "ldap_over_tls_enabled"
        elif key == "ldapSigningEnabled":
            suggest = "ldap_signing_enabled"
        elif key == "localNfsUsersWithLdapAllowed":
            suggest = "local_nfs_users_with_ldap_allowed"
        elif key == "organizationalUnit":
            suggest = "organizational_unit"
        elif key == "serverRootCaCertificate":
            suggest = "server_root_ca_certificate"
        elif key == "siteName":
            suggest = "site_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountActiveDirectory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountActiveDirectory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountActiveDirectory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_servers: Sequence[builtins.str],
                 domain: builtins.str,
                 password: builtins.str,
                 smb_server_name: builtins.str,
                 username: builtins.str,
                 aes_encryption_enabled: Optional[builtins.bool] = None,
                 kerberos_ad_name: Optional[builtins.str] = None,
                 kerberos_kdc_ip: Optional[builtins.str] = None,
                 ldap_over_tls_enabled: Optional[builtins.bool] = None,
                 ldap_signing_enabled: Optional[builtins.bool] = None,
                 local_nfs_users_with_ldap_allowed: Optional[builtins.bool] = None,
                 organizational_unit: Optional[builtins.str] = None,
                 server_root_ca_certificate: Optional[builtins.str] = None,
                 site_name: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] dns_servers: A list of DNS server IP addresses for the Active Directory domain. Only allows `IPv4` address.
        :param builtins.str domain: The name of the Active Directory domain.
        :param builtins.str password: The password associated with the `username`.
        :param builtins.str smb_server_name: The NetBIOS name which should be used for the NetApp SMB Server, which will be registered as a computer account in the AD and used to mount volumes.
        :param builtins.str username: The Username of Active Directory Domain Administrator.
        :param builtins.bool aes_encryption_enabled: If enabled, AES encryption will be enabled for SMB communication. Defaults to `false`.
        :param builtins.str kerberos_ad_name: Name of the active directory machine.
        :param builtins.str kerberos_kdc_ip: kdc server IP addresses for the active directory machine.
               
               > **Note:** If you plan on using **Kerberos** volumes, both `ad_name` and `kdc_ip` are required in order to create the volume.
        :param builtins.bool ldap_over_tls_enabled: Specifies whether or not the LDAP traffic needs to be secured via TLS. Defaults to `false`.
        :param builtins.bool ldap_signing_enabled: Specifies whether or not the LDAP traffic needs to be signed. Defaults to `false`.
        :param builtins.bool local_nfs_users_with_ldap_allowed: If enabled, NFS client local users can also (in addition to LDAP users) access the NFS volumes. Defaults to `false`.
        :param builtins.str organizational_unit: The Organizational Unit (OU) within Active Directory where machines will be created. If blank, defaults to `CN=Computers`.
        :param builtins.str server_root_ca_certificate: When LDAP over SSL/TLS is enabled, the LDAP client is required to have a *base64 encoded Active Directory Certificate Service's self-signed root CA certificate*, this optional parameter is used only for dual protocol with LDAP user-mapping volumes. Required if `ldap_over_tls_enabled` is set to `true`.
        :param builtins.str site_name: The Active Directory site the service will limit Domain Controller discovery to. If blank, defaults to `Default-First-Site-Name`.
        """
        pulumi.set(__self__, "dns_servers", dns_servers)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "smb_server_name", smb_server_name)
        pulumi.set(__self__, "username", username)
        if aes_encryption_enabled is not None:
            pulumi.set(__self__, "aes_encryption_enabled", aes_encryption_enabled)
        if kerberos_ad_name is not None:
            pulumi.set(__self__, "kerberos_ad_name", kerberos_ad_name)
        if kerberos_kdc_ip is not None:
            pulumi.set(__self__, "kerberos_kdc_ip", kerberos_kdc_ip)
        if ldap_over_tls_enabled is not None:
            pulumi.set(__self__, "ldap_over_tls_enabled", ldap_over_tls_enabled)
        if ldap_signing_enabled is not None:
            pulumi.set(__self__, "ldap_signing_enabled", ldap_signing_enabled)
        if local_nfs_users_with_ldap_allowed is not None:
            pulumi.set(__self__, "local_nfs_users_with_ldap_allowed", local_nfs_users_with_ldap_allowed)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if server_root_ca_certificate is not None:
            pulumi.set(__self__, "server_root_ca_certificate", server_root_ca_certificate)
        if site_name is not None:
            pulumi.set(__self__, "site_name", site_name)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[builtins.str]:
        """
        A list of DNS server IP addresses for the Active Directory domain. Only allows `IPv4` address.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        The name of the Active Directory domain.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        The password associated with the `username`.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="smbServerName")
    def smb_server_name(self) -> builtins.str:
        """
        The NetBIOS name which should be used for the NetApp SMB Server, which will be registered as a computer account in the AD and used to mount volumes.
        """
        return pulumi.get(self, "smb_server_name")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        The Username of Active Directory Domain Administrator.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="aesEncryptionEnabled")
    def aes_encryption_enabled(self) -> Optional[builtins.bool]:
        """
        If enabled, AES encryption will be enabled for SMB communication. Defaults to `false`.
        """
        return pulumi.get(self, "aes_encryption_enabled")

    @property
    @pulumi.getter(name="kerberosAdName")
    def kerberos_ad_name(self) -> Optional[builtins.str]:
        """
        Name of the active directory machine.
        """
        return pulumi.get(self, "kerberos_ad_name")

    @property
    @pulumi.getter(name="kerberosKdcIp")
    def kerberos_kdc_ip(self) -> Optional[builtins.str]:
        """
        kdc server IP addresses for the active directory machine.

        > **Note:** If you plan on using **Kerberos** volumes, both `ad_name` and `kdc_ip` are required in order to create the volume.
        """
        return pulumi.get(self, "kerberos_kdc_ip")

    @property
    @pulumi.getter(name="ldapOverTlsEnabled")
    def ldap_over_tls_enabled(self) -> Optional[builtins.bool]:
        """
        Specifies whether or not the LDAP traffic needs to be secured via TLS. Defaults to `false`.
        """
        return pulumi.get(self, "ldap_over_tls_enabled")

    @property
    @pulumi.getter(name="ldapSigningEnabled")
    def ldap_signing_enabled(self) -> Optional[builtins.bool]:
        """
        Specifies whether or not the LDAP traffic needs to be signed. Defaults to `false`.
        """
        return pulumi.get(self, "ldap_signing_enabled")

    @property
    @pulumi.getter(name="localNfsUsersWithLdapAllowed")
    def local_nfs_users_with_ldap_allowed(self) -> Optional[builtins.bool]:
        """
        If enabled, NFS client local users can also (in addition to LDAP users) access the NFS volumes. Defaults to `false`.
        """
        return pulumi.get(self, "local_nfs_users_with_ldap_allowed")

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[builtins.str]:
        """
        The Organizational Unit (OU) within Active Directory where machines will be created. If blank, defaults to `CN=Computers`.
        """
        return pulumi.get(self, "organizational_unit")

    @property
    @pulumi.getter(name="serverRootCaCertificate")
    def server_root_ca_certificate(self) -> Optional[builtins.str]:
        """
        When LDAP over SSL/TLS is enabled, the LDAP client is required to have a *base64 encoded Active Directory Certificate Service's self-signed root CA certificate*, this optional parameter is used only for dual protocol with LDAP user-mapping volumes. Required if `ldap_over_tls_enabled` is set to `true`.
        """
        return pulumi.get(self, "server_root_ca_certificate")

    @property
    @pulumi.getter(name="siteName")
    def site_name(self) -> Optional[builtins.str]:
        """
        The Active Directory site the service will limit Domain Controller discovery to. If blank, defaults to `Default-First-Site-Name`.
        """
        return pulumi.get(self, "site_name")


@pulumi.output_type
class AccountIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: The identity type, which can be `SystemAssigned` or `UserAssigned`. Only one type at a time is supported by Azure NetApp Files.
        :param Sequence[builtins.str] identity_ids: The identity id of the user assigned identity to use when type is `UserAssigned`
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The identity type, which can be `SystemAssigned` or `UserAssigned`. Only one type at a time is supported by Azure NetApp Files.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The identity id of the user assigned identity to use when type is `UserAssigned`
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class SnapshotPolicyDailySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotPolicyDailySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotPolicyDailySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotPolicyDailySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hour: builtins.int,
                 minute: builtins.int,
                 snapshots_to_keep: builtins.int):
        """
        :param builtins.int hour: Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        :param builtins.int minute: Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        :param builtins.int snapshots_to_keep: How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "minute", minute)
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)

    @property
    @pulumi.getter
    def hour(self) -> builtins.int:
        """
        Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def minute(self) -> builtins.int:
        """
        Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        """
        return pulumi.get(self, "minute")

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> builtins.int:
        """
        How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        return pulumi.get(self, "snapshots_to_keep")


@pulumi.output_type
class SnapshotPolicyHourlySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotPolicyHourlySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotPolicyHourlySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotPolicyHourlySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 minute: builtins.int,
                 snapshots_to_keep: builtins.int):
        """
        :param builtins.int minute: Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        :param builtins.int snapshots_to_keep: How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        pulumi.set(__self__, "minute", minute)
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)

    @property
    @pulumi.getter
    def minute(self) -> builtins.int:
        """
        Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        """
        return pulumi.get(self, "minute")

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> builtins.int:
        """
        How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        return pulumi.get(self, "snapshots_to_keep")


@pulumi.output_type
class SnapshotPolicyMonthlySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysOfMonths":
            suggest = "days_of_months"
        elif key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotPolicyMonthlySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotPolicyMonthlySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotPolicyMonthlySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_of_months: Sequence[builtins.int],
                 hour: builtins.int,
                 minute: builtins.int,
                 snapshots_to_keep: builtins.int):
        """
        :param Sequence[builtins.int] days_of_months: List of the days of the month when the snapshots will be created, valid range is from 1 to 30.
        :param builtins.int hour: Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        :param builtins.int minute: Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        :param builtins.int snapshots_to_keep: How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        pulumi.set(__self__, "days_of_months", days_of_months)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "minute", minute)
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)

    @property
    @pulumi.getter(name="daysOfMonths")
    def days_of_months(self) -> Sequence[builtins.int]:
        """
        List of the days of the month when the snapshots will be created, valid range is from 1 to 30.
        """
        return pulumi.get(self, "days_of_months")

    @property
    @pulumi.getter
    def hour(self) -> builtins.int:
        """
        Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def minute(self) -> builtins.int:
        """
        Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        """
        return pulumi.get(self, "minute")

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> builtins.int:
        """
        How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        return pulumi.get(self, "snapshots_to_keep")


@pulumi.output_type
class SnapshotPolicyWeeklySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysOfWeeks":
            suggest = "days_of_weeks"
        elif key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotPolicyWeeklySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotPolicyWeeklySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotPolicyWeeklySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_of_weeks: Sequence[builtins.str],
                 hour: builtins.int,
                 minute: builtins.int,
                 snapshots_to_keep: builtins.int):
        """
        :param Sequence[builtins.str] days_of_weeks: List of the week days using English names when the snapshots will be created.
        :param builtins.int hour: Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        :param builtins.int minute: Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        :param builtins.int snapshots_to_keep: How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "minute", minute)
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)

    @property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Sequence[builtins.str]:
        """
        List of the week days using English names when the snapshots will be created.
        """
        return pulumi.get(self, "days_of_weeks")

    @property
    @pulumi.getter
    def hour(self) -> builtins.int:
        """
        Hour of the day that the snapshots will be created, valid range is from 0 to 23.
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def minute(self) -> builtins.int:
        """
        Minute of the hour that the snapshots will be created, valid range is from 0 to 59.
        """
        return pulumi.get(self, "minute")

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> builtins.int:
        """
        How many hourly snapshots to keep, valid range is from 0 to 255.
        """
        return pulumi.get(self, "snapshots_to_keep")


@pulumi.output_type
class VolumeDataProtectionBackupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupPolicyId":
            suggest = "backup_policy_id"
        elif key == "backupVaultId":
            suggest = "backup_vault_id"
        elif key == "policyEnabled":
            suggest = "policy_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeDataProtectionBackupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeDataProtectionBackupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeDataProtectionBackupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_policy_id: builtins.str,
                 backup_vault_id: builtins.str,
                 policy_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str backup_policy_id: Resource ID of the backup policy to apply to the volume.
        :param builtins.str backup_vault_id: Resource ID of the backup backup vault to associate this volume to.
        :param builtins.bool policy_enabled: Enables the backup policy on the volume, defaults to `true`.
               
               For more information on Azure NetApp Files Backup feature please see [Understand Azure NetApp Files backup](https://learn.microsoft.com/en-us/azure/azure-netapp-files/backup-introduction)
        """
        pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        pulumi.set(__self__, "backup_vault_id", backup_vault_id)
        if policy_enabled is not None:
            pulumi.set(__self__, "policy_enabled", policy_enabled)

    @property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> builtins.str:
        """
        Resource ID of the backup policy to apply to the volume.
        """
        return pulumi.get(self, "backup_policy_id")

    @property
    @pulumi.getter(name="backupVaultId")
    def backup_vault_id(self) -> builtins.str:
        """
        Resource ID of the backup backup vault to associate this volume to.
        """
        return pulumi.get(self, "backup_vault_id")

    @property
    @pulumi.getter(name="policyEnabled")
    def policy_enabled(self) -> Optional[builtins.bool]:
        """
        Enables the backup policy on the volume, defaults to `true`.

        For more information on Azure NetApp Files Backup feature please see [Understand Azure NetApp Files backup](https://learn.microsoft.com/en-us/azure/azure-netapp-files/backup-introduction)
        """
        return pulumi.get(self, "policy_enabled")


@pulumi.output_type
class VolumeDataProtectionReplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "remoteVolumeLocation":
            suggest = "remote_volume_location"
        elif key == "remoteVolumeResourceId":
            suggest = "remote_volume_resource_id"
        elif key == "replicationFrequency":
            suggest = "replication_frequency"
        elif key == "endpointType":
            suggest = "endpoint_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeDataProtectionReplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeDataProtectionReplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeDataProtectionReplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 remote_volume_location: builtins.str,
                 remote_volume_resource_id: builtins.str,
                 replication_frequency: builtins.str,
                 endpoint_type: Optional[builtins.str] = None):
        """
        :param builtins.str remote_volume_location: Location of the primary volume. Changing this forces a new resource to be created.
        :param builtins.str remote_volume_resource_id: Resource ID of the primary volume.
        :param builtins.str replication_frequency: Replication frequency, supported values are '10minutes', 'hourly', 'daily', values are case sensitive.
               
               A full example of the `data_protection_replication` attribute can be found in the `./examples/netapp/volume_crr` directory within the GitHub Repository
               
               > **Note:** `data_protection_replication` can be defined only once per secondary volume, adding a second instance of it is not supported.
        :param builtins.str endpoint_type: The endpoint type, default value is `dst` for destination.
        """
        pulumi.set(__self__, "remote_volume_location", remote_volume_location)
        pulumi.set(__self__, "remote_volume_resource_id", remote_volume_resource_id)
        pulumi.set(__self__, "replication_frequency", replication_frequency)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)

    @property
    @pulumi.getter(name="remoteVolumeLocation")
    def remote_volume_location(self) -> builtins.str:
        """
        Location of the primary volume. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "remote_volume_location")

    @property
    @pulumi.getter(name="remoteVolumeResourceId")
    def remote_volume_resource_id(self) -> builtins.str:
        """
        Resource ID of the primary volume.
        """
        return pulumi.get(self, "remote_volume_resource_id")

    @property
    @pulumi.getter(name="replicationFrequency")
    def replication_frequency(self) -> builtins.str:
        """
        Replication frequency, supported values are '10minutes', 'hourly', 'daily', values are case sensitive.

        A full example of the `data_protection_replication` attribute can be found in the `./examples/netapp/volume_crr` directory within the GitHub Repository

        > **Note:** `data_protection_replication` can be defined only once per secondary volume, adding a second instance of it is not supported.
        """
        return pulumi.get(self, "replication_frequency")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[builtins.str]:
        """
        The endpoint type, default value is `dst` for destination.
        """
        return pulumi.get(self, "endpoint_type")


@pulumi.output_type
class VolumeDataProtectionSnapshotPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotPolicyId":
            suggest = "snapshot_policy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeDataProtectionSnapshotPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeDataProtectionSnapshotPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeDataProtectionSnapshotPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshot_policy_id: builtins.str):
        """
        :param builtins.str snapshot_policy_id: Resource ID of the snapshot policy to apply to the volume.
               
               A full example of the `data_protection_snapshot_policy` attribute usage can be found in the `./examples/netapp/nfsv3_volume_with_snapshot_policy` directory within the GitHub Repository
               
               > **Note:** `data_protection_snapshot_policy` block can be used alone or with data_protection_replication in the primary volume only, if enabling it in the secondary, an error will be thrown.
        """
        pulumi.set(__self__, "snapshot_policy_id", snapshot_policy_id)

    @property
    @pulumi.getter(name="snapshotPolicyId")
    def snapshot_policy_id(self) -> builtins.str:
        """
        Resource ID of the snapshot policy to apply to the volume.

        A full example of the `data_protection_snapshot_policy` attribute usage can be found in the `./examples/netapp/nfsv3_volume_with_snapshot_policy` directory within the GitHub Repository

        > **Note:** `data_protection_snapshot_policy` block can be used alone or with data_protection_replication in the primary volume only, if enabling it in the secondary, an error will be thrown.
        """
        return pulumi.get(self, "snapshot_policy_id")


@pulumi.output_type
class VolumeExportPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedClients":
            suggest = "allowed_clients"
        elif key == "ruleIndex":
            suggest = "rule_index"
        elif key == "kerberos5ReadOnlyEnabled":
            suggest = "kerberos5_read_only_enabled"
        elif key == "kerberos5ReadWriteEnabled":
            suggest = "kerberos5_read_write_enabled"
        elif key == "kerberos5iReadOnlyEnabled":
            suggest = "kerberos5i_read_only_enabled"
        elif key == "kerberos5iReadWriteEnabled":
            suggest = "kerberos5i_read_write_enabled"
        elif key == "kerberos5pReadOnlyEnabled":
            suggest = "kerberos5p_read_only_enabled"
        elif key == "kerberos5pReadWriteEnabled":
            suggest = "kerberos5p_read_write_enabled"
        elif key == "protocolsEnabled":
            suggest = "protocols_enabled"
        elif key == "rootAccessEnabled":
            suggest = "root_access_enabled"
        elif key == "unixReadOnly":
            suggest = "unix_read_only"
        elif key == "unixReadWrite":
            suggest = "unix_read_write"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeExportPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeExportPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeExportPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_clients: Sequence[builtins.str],
                 rule_index: builtins.int,
                 kerberos5_read_only_enabled: Optional[builtins.bool] = None,
                 kerberos5_read_write_enabled: Optional[builtins.bool] = None,
                 kerberos5i_read_only_enabled: Optional[builtins.bool] = None,
                 kerberos5i_read_write_enabled: Optional[builtins.bool] = None,
                 kerberos5p_read_only_enabled: Optional[builtins.bool] = None,
                 kerberos5p_read_write_enabled: Optional[builtins.bool] = None,
                 protocols_enabled: Optional[builtins.str] = None,
                 root_access_enabled: Optional[builtins.bool] = None,
                 unix_read_only: Optional[builtins.bool] = None,
                 unix_read_write: Optional[builtins.bool] = None):
        """
        :param Sequence[builtins.str] allowed_clients: A list of allowed clients IPv4 addresses.
        :param builtins.int rule_index: The index number of the rule.
        :param builtins.bool kerberos5_read_only_enabled: Is Kerberos 5 read-only access permitted to this volume?
        :param builtins.bool kerberos5_read_write_enabled: Is Kerberos 5 read/write permitted to this volume?
        :param builtins.bool kerberos5i_read_only_enabled: Is Kerberos 5i read-only permitted to this volume?
        :param builtins.bool kerberos5i_read_write_enabled: Is Kerberos 5i read/write permitted to this volume?
        :param builtins.bool kerberos5p_read_only_enabled: Is Kerberos 5p read-only permitted to this volume?
        :param builtins.bool kerberos5p_read_write_enabled: Is Kerberos 5p read/write permitted to this volume?
        :param builtins.str protocols_enabled: A list of allowed protocols. Valid values include `CIFS`, `NFSv3`, or `NFSv4.1`. Only one value is supported at this time. This replaces the previous arguments: `cifs_enabled`, `nfsv3_enabled` and `nfsv4_enabled`.
        :param builtins.bool root_access_enabled: Is root access permitted to this volume?
        :param builtins.bool unix_read_only: Is the file system on unix read only?
        :param builtins.bool unix_read_write: Is the file system on unix read and write?
        """
        pulumi.set(__self__, "allowed_clients", allowed_clients)
        pulumi.set(__self__, "rule_index", rule_index)
        if kerberos5_read_only_enabled is not None:
            pulumi.set(__self__, "kerberos5_read_only_enabled", kerberos5_read_only_enabled)
        if kerberos5_read_write_enabled is not None:
            pulumi.set(__self__, "kerberos5_read_write_enabled", kerberos5_read_write_enabled)
        if kerberos5i_read_only_enabled is not None:
            pulumi.set(__self__, "kerberos5i_read_only_enabled", kerberos5i_read_only_enabled)
        if kerberos5i_read_write_enabled is not None:
            pulumi.set(__self__, "kerberos5i_read_write_enabled", kerberos5i_read_write_enabled)
        if kerberos5p_read_only_enabled is not None:
            pulumi.set(__self__, "kerberos5p_read_only_enabled", kerberos5p_read_only_enabled)
        if kerberos5p_read_write_enabled is not None:
            pulumi.set(__self__, "kerberos5p_read_write_enabled", kerberos5p_read_write_enabled)
        if protocols_enabled is not None:
            pulumi.set(__self__, "protocols_enabled", protocols_enabled)
        if root_access_enabled is not None:
            pulumi.set(__self__, "root_access_enabled", root_access_enabled)
        if unix_read_only is not None:
            pulumi.set(__self__, "unix_read_only", unix_read_only)
        if unix_read_write is not None:
            pulumi.set(__self__, "unix_read_write", unix_read_write)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> Sequence[builtins.str]:
        """
        A list of allowed clients IPv4 addresses.
        """
        return pulumi.get(self, "allowed_clients")

    @property
    @pulumi.getter(name="ruleIndex")
    def rule_index(self) -> builtins.int:
        """
        The index number of the rule.
        """
        return pulumi.get(self, "rule_index")

    @property
    @pulumi.getter(name="kerberos5ReadOnlyEnabled")
    def kerberos5_read_only_enabled(self) -> Optional[builtins.bool]:
        """
        Is Kerberos 5 read-only access permitted to this volume?
        """
        return pulumi.get(self, "kerberos5_read_only_enabled")

    @property
    @pulumi.getter(name="kerberos5ReadWriteEnabled")
    def kerberos5_read_write_enabled(self) -> Optional[builtins.bool]:
        """
        Is Kerberos 5 read/write permitted to this volume?
        """
        return pulumi.get(self, "kerberos5_read_write_enabled")

    @property
    @pulumi.getter(name="kerberos5iReadOnlyEnabled")
    def kerberos5i_read_only_enabled(self) -> Optional[builtins.bool]:
        """
        Is Kerberos 5i read-only permitted to this volume?
        """
        return pulumi.get(self, "kerberos5i_read_only_enabled")

    @property
    @pulumi.getter(name="kerberos5iReadWriteEnabled")
    def kerberos5i_read_write_enabled(self) -> Optional[builtins.bool]:
        """
        Is Kerberos 5i read/write permitted to this volume?
        """
        return pulumi.get(self, "kerberos5i_read_write_enabled")

    @property
    @pulumi.getter(name="kerberos5pReadOnlyEnabled")
    def kerberos5p_read_only_enabled(self) -> Optional[builtins.bool]:
        """
        Is Kerberos 5p read-only permitted to this volume?
        """
        return pulumi.get(self, "kerberos5p_read_only_enabled")

    @property
    @pulumi.getter(name="kerberos5pReadWriteEnabled")
    def kerberos5p_read_write_enabled(self) -> Optional[builtins.bool]:
        """
        Is Kerberos 5p read/write permitted to this volume?
        """
        return pulumi.get(self, "kerberos5p_read_write_enabled")

    @property
    @pulumi.getter(name="protocolsEnabled")
    def protocols_enabled(self) -> Optional[builtins.str]:
        """
        A list of allowed protocols. Valid values include `CIFS`, `NFSv3`, or `NFSv4.1`. Only one value is supported at this time. This replaces the previous arguments: `cifs_enabled`, `nfsv3_enabled` and `nfsv4_enabled`.
        """
        return pulumi.get(self, "protocols_enabled")

    @property
    @pulumi.getter(name="rootAccessEnabled")
    def root_access_enabled(self) -> Optional[builtins.bool]:
        """
        Is root access permitted to this volume?
        """
        return pulumi.get(self, "root_access_enabled")

    @property
    @pulumi.getter(name="unixReadOnly")
    def unix_read_only(self) -> Optional[builtins.bool]:
        """
        Is the file system on unix read only?
        """
        return pulumi.get(self, "unix_read_only")

    @property
    @pulumi.getter(name="unixReadWrite")
    def unix_read_write(self) -> Optional[builtins.bool]:
        """
        Is the file system on unix read and write?
        """
        return pulumi.get(self, "unix_read_write")


@pulumi.output_type
class VolumeGroupOracleVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityPoolId":
            suggest = "capacity_pool_id"
        elif key == "exportPolicyRules":
            suggest = "export_policy_rules"
        elif key == "securityStyle":
            suggest = "security_style"
        elif key == "serviceLevel":
            suggest = "service_level"
        elif key == "snapshotDirectoryVisible":
            suggest = "snapshot_directory_visible"
        elif key == "storageQuotaInGb":
            suggest = "storage_quota_in_gb"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "throughputInMibps":
            suggest = "throughput_in_mibps"
        elif key == "volumePath":
            suggest = "volume_path"
        elif key == "volumeSpecName":
            suggest = "volume_spec_name"
        elif key == "dataProtectionReplication":
            suggest = "data_protection_replication"
        elif key == "dataProtectionSnapshotPolicy":
            suggest = "data_protection_snapshot_policy"
        elif key == "encryptionKeySource":
            suggest = "encryption_key_source"
        elif key == "keyVaultPrivateEndpointId":
            suggest = "key_vault_private_endpoint_id"
        elif key == "mountIpAddresses":
            suggest = "mount_ip_addresses"
        elif key == "networkFeatures":
            suggest = "network_features"
        elif key == "proximityPlacementGroupId":
            suggest = "proximity_placement_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeGroupOracleVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeGroupOracleVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeGroupOracleVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_pool_id: builtins.str,
                 export_policy_rules: Sequence['outputs.VolumeGroupOracleVolumeExportPolicyRule'],
                 name: builtins.str,
                 protocols: builtins.str,
                 security_style: builtins.str,
                 service_level: builtins.str,
                 snapshot_directory_visible: builtins.bool,
                 storage_quota_in_gb: builtins.int,
                 subnet_id: builtins.str,
                 throughput_in_mibps: builtins.float,
                 volume_path: builtins.str,
                 volume_spec_name: builtins.str,
                 data_protection_replication: Optional['outputs.VolumeGroupOracleVolumeDataProtectionReplication'] = None,
                 data_protection_snapshot_policy: Optional['outputs.VolumeGroupOracleVolumeDataProtectionSnapshotPolicy'] = None,
                 encryption_key_source: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 key_vault_private_endpoint_id: Optional[builtins.str] = None,
                 mount_ip_addresses: Optional[Sequence[builtins.str]] = None,
                 network_features: Optional[builtins.str] = None,
                 proximity_placement_group_id: Optional[builtins.str] = None,
                 tags: Optional[Mapping[str, builtins.str]] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param builtins.str capacity_pool_id: The ID of the Capacity Pool. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param Sequence['VolumeGroupOracleVolumeExportPolicyRuleArgs'] export_policy_rules: One or more `export_policy_rule` blocks as defined below.
        :param builtins.str name: The name which should be used for this volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.str protocols: The target volume protocol expressed as a list. Changing this forces a new Application Volume Group to be created and data will be lost. Supported values for Application Volume Group include `NFSv3` or `NFSv4.1`.
        :param builtins.str security_style: Volume security style. Possible values are `ntfs` and `unix`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.str service_level: Volume security style. Possible values are `Premium`, `Standard` and `Ultra`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.bool snapshot_directory_visible: Specifies whether the .snapshot (NFS clients) path of a volume is visible. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.int storage_quota_in_gb: The maximum Storage Quota allowed for a file system in Gigabytes.
        :param builtins.str subnet_id: The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.float throughput_in_mibps: Throughput of this volume in Mibps.
        :param builtins.str volume_path: A unique file path for the volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.str volume_spec_name: Volume specification name. Possible values are `ora-data1` through `ora-data8`, `ora-log`, `ora-log-mirror`, `ora-backup` and `ora-binary`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param 'VolumeGroupOracleVolumeDataProtectionReplicationArgs' data_protection_replication: A `data_protection_replication` block as defined below. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param 'VolumeGroupOracleVolumeDataProtectionSnapshotPolicyArgs' data_protection_snapshot_policy: A `data_protection_snapshot_policy` block as defined below.
        :param builtins.str encryption_key_source: The encryption key source, it can be `Microsoft.NetApp` for platform managed keys or `Microsoft.KeyVault` for customer-managed keys. This is required with `key_vault_private_endpoint_id`. Changing this forces a new resource to be created.
        :param builtins.str id: The ID of the Application Volume Group.
        :param builtins.str key_vault_private_endpoint_id: The Private Endpoint ID for Key Vault, which is required when using customer-managed keys. This is required with `encryption_key_source`. Changing this forces a new resource to be created.
        :param builtins.str network_features: Indicates which network feature to use, accepted values are `Basic` or `Standard`, it defaults to `Basic` if not defined. This is a feature in public preview and for more information about it and how to register, please refer to [Configure network features for an Azure NetApp Files volume](https://docs.microsoft.com/en-us/azure/azure-netapp-files/configure-network-features). This is required if enabling customer managed keys encryption scenario.
        :param builtins.str proximity_placement_group_id: The ID of the proximity placement group (PPG). Changing this forces a new Application Volume Group to be created and data will be lost. 
               
               > **Note:** For Oracle application, it is required to have PPG enabled so Azure NetApp Files can pin the volumes next to your compute resources, please check [Requirements and considerations for application volume group for Oracle](https://learn.microsoft.com/en-us/azure/azure-netapp-files/application-volume-group-oracle-considerations) for details and other requirements. Note that this cannot be used together with `zone`.
        :param Mapping[str, builtins.str] tags: A mapping of tags which should be assigned to the Application Volume Group.
        :param builtins.str zone: Specifies the Availability Zone in which the Volume should be located. Possible values are `1`, `2` and `3`, depending on the Azure region. Changing this forces a new resource to be created. This feature is currently in preview, for more information on how to enable it, please refer to [Manage availability zone volume placement for Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/manage-availability-zone-volume-placement). Note that this cannot be used together with `proximity_placement_group_id`.
        """
        pulumi.set(__self__, "capacity_pool_id", capacity_pool_id)
        pulumi.set(__self__, "export_policy_rules", export_policy_rules)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "security_style", security_style)
        pulumi.set(__self__, "service_level", service_level)
        pulumi.set(__self__, "snapshot_directory_visible", snapshot_directory_visible)
        pulumi.set(__self__, "storage_quota_in_gb", storage_quota_in_gb)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "throughput_in_mibps", throughput_in_mibps)
        pulumi.set(__self__, "volume_path", volume_path)
        pulumi.set(__self__, "volume_spec_name", volume_spec_name)
        if data_protection_replication is not None:
            pulumi.set(__self__, "data_protection_replication", data_protection_replication)
        if data_protection_snapshot_policy is not None:
            pulumi.set(__self__, "data_protection_snapshot_policy", data_protection_snapshot_policy)
        if encryption_key_source is not None:
            pulumi.set(__self__, "encryption_key_source", encryption_key_source)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if key_vault_private_endpoint_id is not None:
            pulumi.set(__self__, "key_vault_private_endpoint_id", key_vault_private_endpoint_id)
        if mount_ip_addresses is not None:
            pulumi.set(__self__, "mount_ip_addresses", mount_ip_addresses)
        if network_features is not None:
            pulumi.set(__self__, "network_features", network_features)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="capacityPoolId")
    def capacity_pool_id(self) -> builtins.str:
        """
        The ID of the Capacity Pool. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "capacity_pool_id")

    @property
    @pulumi.getter(name="exportPolicyRules")
    def export_policy_rules(self) -> Sequence['outputs.VolumeGroupOracleVolumeExportPolicyRule']:
        """
        One or more `export_policy_rule` blocks as defined below.
        """
        return pulumi.get(self, "export_policy_rules")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name which should be used for this volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> builtins.str:
        """
        The target volume protocol expressed as a list. Changing this forces a new Application Volume Group to be created and data will be lost. Supported values for Application Volume Group include `NFSv3` or `NFSv4.1`.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> builtins.str:
        """
        Volume security style. Possible values are `ntfs` and `unix`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "security_style")

    @property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> builtins.str:
        """
        Volume security style. Possible values are `Premium`, `Standard` and `Ultra`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "service_level")

    @property
    @pulumi.getter(name="snapshotDirectoryVisible")
    def snapshot_directory_visible(self) -> builtins.bool:
        """
        Specifies whether the .snapshot (NFS clients) path of a volume is visible. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "snapshot_directory_visible")

    @property
    @pulumi.getter(name="storageQuotaInGb")
    def storage_quota_in_gb(self) -> builtins.int:
        """
        The maximum Storage Quota allowed for a file system in Gigabytes.
        """
        return pulumi.get(self, "storage_quota_in_gb")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="throughputInMibps")
    def throughput_in_mibps(self) -> builtins.float:
        """
        Throughput of this volume in Mibps.
        """
        return pulumi.get(self, "throughput_in_mibps")

    @property
    @pulumi.getter(name="volumePath")
    def volume_path(self) -> builtins.str:
        """
        A unique file path for the volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "volume_path")

    @property
    @pulumi.getter(name="volumeSpecName")
    def volume_spec_name(self) -> builtins.str:
        """
        Volume specification name. Possible values are `ora-data1` through `ora-data8`, `ora-log`, `ora-log-mirror`, `ora-backup` and `ora-binary`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "volume_spec_name")

    @property
    @pulumi.getter(name="dataProtectionReplication")
    def data_protection_replication(self) -> Optional['outputs.VolumeGroupOracleVolumeDataProtectionReplication']:
        """
        A `data_protection_replication` block as defined below. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "data_protection_replication")

    @property
    @pulumi.getter(name="dataProtectionSnapshotPolicy")
    def data_protection_snapshot_policy(self) -> Optional['outputs.VolumeGroupOracleVolumeDataProtectionSnapshotPolicy']:
        """
        A `data_protection_snapshot_policy` block as defined below.
        """
        return pulumi.get(self, "data_protection_snapshot_policy")

    @property
    @pulumi.getter(name="encryptionKeySource")
    def encryption_key_source(self) -> Optional[builtins.str]:
        """
        The encryption key source, it can be `Microsoft.NetApp` for platform managed keys or `Microsoft.KeyVault` for customer-managed keys. This is required with `key_vault_private_endpoint_id`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_key_source")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Application Volume Group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyVaultPrivateEndpointId")
    def key_vault_private_endpoint_id(self) -> Optional[builtins.str]:
        """
        The Private Endpoint ID for Key Vault, which is required when using customer-managed keys. This is required with `encryption_key_source`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_private_endpoint_id")

    @property
    @pulumi.getter(name="mountIpAddresses")
    def mount_ip_addresses(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "mount_ip_addresses")

    @property
    @pulumi.getter(name="networkFeatures")
    def network_features(self) -> Optional[builtins.str]:
        """
        Indicates which network feature to use, accepted values are `Basic` or `Standard`, it defaults to `Basic` if not defined. This is a feature in public preview and for more information about it and how to register, please refer to [Configure network features for an Azure NetApp Files volume](https://docs.microsoft.com/en-us/azure/azure-netapp-files/configure-network-features). This is required if enabling customer managed keys encryption scenario.
        """
        return pulumi.get(self, "network_features")

    @property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[builtins.str]:
        """
        The ID of the proximity placement group (PPG). Changing this forces a new Application Volume Group to be created and data will be lost. 

        > **Note:** For Oracle application, it is required to have PPG enabled so Azure NetApp Files can pin the volumes next to your compute resources, please check [Requirements and considerations for application volume group for Oracle](https://learn.microsoft.com/en-us/azure/azure-netapp-files/application-volume-group-oracle-considerations) for details and other requirements. Note that this cannot be used together with `zone`.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A mapping of tags which should be assigned to the Application Volume Group.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        Specifies the Availability Zone in which the Volume should be located. Possible values are `1`, `2` and `3`, depending on the Azure region. Changing this forces a new resource to be created. This feature is currently in preview, for more information on how to enable it, please refer to [Manage availability zone volume placement for Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/manage-availability-zone-volume-placement). Note that this cannot be used together with `proximity_placement_group_id`.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class VolumeGroupOracleVolumeDataProtectionReplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "remoteVolumeLocation":
            suggest = "remote_volume_location"
        elif key == "remoteVolumeResourceId":
            suggest = "remote_volume_resource_id"
        elif key == "replicationFrequency":
            suggest = "replication_frequency"
        elif key == "endpointType":
            suggest = "endpoint_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeGroupOracleVolumeDataProtectionReplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeGroupOracleVolumeDataProtectionReplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeGroupOracleVolumeDataProtectionReplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 remote_volume_location: builtins.str,
                 remote_volume_resource_id: builtins.str,
                 replication_frequency: builtins.str,
                 endpoint_type: Optional[builtins.str] = None):
        """
        :param builtins.str remote_volume_location: Location of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.str remote_volume_resource_id: Resource ID of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.str replication_frequency: Replication frequency. Possible values are `10minutes`, `daily` and `hourly`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.str endpoint_type: The endpoint type. Possible values are `dst` and `src`. Defaults to `dst`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        pulumi.set(__self__, "remote_volume_location", remote_volume_location)
        pulumi.set(__self__, "remote_volume_resource_id", remote_volume_resource_id)
        pulumi.set(__self__, "replication_frequency", replication_frequency)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)

    @property
    @pulumi.getter(name="remoteVolumeLocation")
    def remote_volume_location(self) -> builtins.str:
        """
        Location of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "remote_volume_location")

    @property
    @pulumi.getter(name="remoteVolumeResourceId")
    def remote_volume_resource_id(self) -> builtins.str:
        """
        Resource ID of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "remote_volume_resource_id")

    @property
    @pulumi.getter(name="replicationFrequency")
    def replication_frequency(self) -> builtins.str:
        """
        Replication frequency. Possible values are `10minutes`, `daily` and `hourly`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "replication_frequency")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[builtins.str]:
        """
        The endpoint type. Possible values are `dst` and `src`. Defaults to `dst`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "endpoint_type")


@pulumi.output_type
class VolumeGroupOracleVolumeDataProtectionSnapshotPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotPolicyId":
            suggest = "snapshot_policy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeGroupOracleVolumeDataProtectionSnapshotPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeGroupOracleVolumeDataProtectionSnapshotPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeGroupOracleVolumeDataProtectionSnapshotPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshot_policy_id: builtins.str):
        """
        :param builtins.str snapshot_policy_id: Resource ID of the snapshot policy to apply to the volume.
        """
        pulumi.set(__self__, "snapshot_policy_id", snapshot_policy_id)

    @property
    @pulumi.getter(name="snapshotPolicyId")
    def snapshot_policy_id(self) -> builtins.str:
        """
        Resource ID of the snapshot policy to apply to the volume.
        """
        return pulumi.get(self, "snapshot_policy_id")


@pulumi.output_type
class VolumeGroupOracleVolumeExportPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedClients":
            suggest = "allowed_clients"
        elif key == "nfsv3Enabled":
            suggest = "nfsv3_enabled"
        elif key == "nfsv41Enabled":
            suggest = "nfsv41_enabled"
        elif key == "ruleIndex":
            suggest = "rule_index"
        elif key == "rootAccessEnabled":
            suggest = "root_access_enabled"
        elif key == "unixReadOnly":
            suggest = "unix_read_only"
        elif key == "unixReadWrite":
            suggest = "unix_read_write"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeGroupOracleVolumeExportPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeGroupOracleVolumeExportPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeGroupOracleVolumeExportPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_clients: builtins.str,
                 nfsv3_enabled: builtins.bool,
                 nfsv41_enabled: builtins.bool,
                 rule_index: builtins.int,
                 root_access_enabled: Optional[builtins.bool] = None,
                 unix_read_only: Optional[builtins.bool] = None,
                 unix_read_write: Optional[builtins.bool] = None):
        """
        :param builtins.str allowed_clients: A comma-sperated list of allowed client IPv4 addresses.
        :param builtins.bool nfsv3_enabled: Enables NFSv3. Please note that this cannot be enabled if volume has NFSv4.1 as its protocol.
        :param builtins.bool nfsv41_enabled: Enables NFSv4.1. Please note that this cannot be enabled if volume has NFSv3 as its protocol.
        :param builtins.int rule_index: The index number of the rule, must start at 1 and maximum 5.
        :param builtins.bool root_access_enabled: Is root access permitted to this volume? Defaults to `true`.
        :param builtins.bool unix_read_only: Is the file system on unix read only? Defaults to `false.
        :param builtins.bool unix_read_write: Is the file system on unix read and write? Defaults to `true`.
        """
        pulumi.set(__self__, "allowed_clients", allowed_clients)
        pulumi.set(__self__, "nfsv3_enabled", nfsv3_enabled)
        pulumi.set(__self__, "nfsv41_enabled", nfsv41_enabled)
        pulumi.set(__self__, "rule_index", rule_index)
        if root_access_enabled is not None:
            pulumi.set(__self__, "root_access_enabled", root_access_enabled)
        if unix_read_only is not None:
            pulumi.set(__self__, "unix_read_only", unix_read_only)
        if unix_read_write is not None:
            pulumi.set(__self__, "unix_read_write", unix_read_write)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> builtins.str:
        """
        A comma-sperated list of allowed client IPv4 addresses.
        """
        return pulumi.get(self, "allowed_clients")

    @property
    @pulumi.getter(name="nfsv3Enabled")
    def nfsv3_enabled(self) -> builtins.bool:
        """
        Enables NFSv3. Please note that this cannot be enabled if volume has NFSv4.1 as its protocol.
        """
        return pulumi.get(self, "nfsv3_enabled")

    @property
    @pulumi.getter(name="nfsv41Enabled")
    def nfsv41_enabled(self) -> builtins.bool:
        """
        Enables NFSv4.1. Please note that this cannot be enabled if volume has NFSv3 as its protocol.
        """
        return pulumi.get(self, "nfsv41_enabled")

    @property
    @pulumi.getter(name="ruleIndex")
    def rule_index(self) -> builtins.int:
        """
        The index number of the rule, must start at 1 and maximum 5.
        """
        return pulumi.get(self, "rule_index")

    @property
    @pulumi.getter(name="rootAccessEnabled")
    def root_access_enabled(self) -> Optional[builtins.bool]:
        """
        Is root access permitted to this volume? Defaults to `true`.
        """
        return pulumi.get(self, "root_access_enabled")

    @property
    @pulumi.getter(name="unixReadOnly")
    def unix_read_only(self) -> Optional[builtins.bool]:
        """
        Is the file system on unix read only? Defaults to `false.
        """
        return pulumi.get(self, "unix_read_only")

    @property
    @pulumi.getter(name="unixReadWrite")
    def unix_read_write(self) -> Optional[builtins.bool]:
        """
        Is the file system on unix read and write? Defaults to `true`.
        """
        return pulumi.get(self, "unix_read_write")


@pulumi.output_type
class VolumeGroupSapHanaVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityPoolId":
            suggest = "capacity_pool_id"
        elif key == "exportPolicyRules":
            suggest = "export_policy_rules"
        elif key == "securityStyle":
            suggest = "security_style"
        elif key == "serviceLevel":
            suggest = "service_level"
        elif key == "snapshotDirectoryVisible":
            suggest = "snapshot_directory_visible"
        elif key == "storageQuotaInGb":
            suggest = "storage_quota_in_gb"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "throughputInMibps":
            suggest = "throughput_in_mibps"
        elif key == "volumePath":
            suggest = "volume_path"
        elif key == "volumeSpecName":
            suggest = "volume_spec_name"
        elif key == "dataProtectionReplication":
            suggest = "data_protection_replication"
        elif key == "dataProtectionSnapshotPolicy":
            suggest = "data_protection_snapshot_policy"
        elif key == "mountIpAddresses":
            suggest = "mount_ip_addresses"
        elif key == "proximityPlacementGroupId":
            suggest = "proximity_placement_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeGroupSapHanaVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeGroupSapHanaVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeGroupSapHanaVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_pool_id: builtins.str,
                 export_policy_rules: Sequence['outputs.VolumeGroupSapHanaVolumeExportPolicyRule'],
                 name: builtins.str,
                 protocols: builtins.str,
                 security_style: builtins.str,
                 service_level: builtins.str,
                 snapshot_directory_visible: builtins.bool,
                 storage_quota_in_gb: builtins.int,
                 subnet_id: builtins.str,
                 throughput_in_mibps: builtins.float,
                 volume_path: builtins.str,
                 volume_spec_name: builtins.str,
                 data_protection_replication: Optional['outputs.VolumeGroupSapHanaVolumeDataProtectionReplication'] = None,
                 data_protection_snapshot_policy: Optional['outputs.VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy'] = None,
                 id: Optional[builtins.str] = None,
                 mount_ip_addresses: Optional[Sequence[builtins.str]] = None,
                 proximity_placement_group_id: Optional[builtins.str] = None,
                 tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str capacity_pool_id: The ID of the Capacity Pool. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param Sequence['VolumeGroupSapHanaVolumeExportPolicyRuleArgs'] export_policy_rules: One or more `export_policy_rule` blocks as defined below.
        :param builtins.str name: The name which should be used for this volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.str protocols: The target volume protocol expressed as a list. Changing this forces a new Application Volume Group to be created and data will be lost. Supported values for Application Volume Group include `NFSv3` or `NFSv4.1`, multi-protocol is not supported and there are certain rules on which protocol is supporteed per volume spec, please check [Configure application volume groups for the SAP HANA REST API](https://learn.microsoft.com/en-us/azure/azure-netapp-files/configure-application-volume-group-sap-hana-api) document for details.
        :param builtins.str security_style: Volume security style. Possible values are `ntfs` and `unix`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.str service_level: Volume security style. Possible values are `Premium`, `Standard` and `Ultra`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.bool snapshot_directory_visible: Specifies whether the .snapshot (NFS clients) path of a volume is visible. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.int storage_quota_in_gb: The maximum Storage Quota allowed for a file system in Gigabytes.
        :param builtins.str subnet_id: The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.float throughput_in_mibps: Throughput of this volume in Mibps.
        :param builtins.str volume_path: A unique file path for the volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.str volume_spec_name: Volume specification name. Possible values are `data`, `log`, `shared`, `data-backup` and `log-backup`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param 'VolumeGroupSapHanaVolumeDataProtectionReplicationArgs' data_protection_replication: A `data_protection_replication` block as defined below. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param 'VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyArgs' data_protection_snapshot_policy: A `data_protection_snapshot_policy` block as defined below.
        :param builtins.str id: The ID of the Application Volume Group.
        :param builtins.str proximity_placement_group_id: The ID of the proximity placement group. Changing this forces a new Application Volume Group to be created and data will be lost. For SAP-HANA application, it is required to have PPG enabled so Azure NetApp Files can pin the volumes next to your compute resources, please check [Requirements and considerations for application volume group for SAP HANA](https://learn.microsoft.com/en-us/azure/azure-netapp-files/application-volume-group-considerations) for details and other requirements.
        :param Mapping[str, builtins.str] tags: A mapping of tags which should be assigned to the Application Volume Group.
        """
        pulumi.set(__self__, "capacity_pool_id", capacity_pool_id)
        pulumi.set(__self__, "export_policy_rules", export_policy_rules)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "security_style", security_style)
        pulumi.set(__self__, "service_level", service_level)
        pulumi.set(__self__, "snapshot_directory_visible", snapshot_directory_visible)
        pulumi.set(__self__, "storage_quota_in_gb", storage_quota_in_gb)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "throughput_in_mibps", throughput_in_mibps)
        pulumi.set(__self__, "volume_path", volume_path)
        pulumi.set(__self__, "volume_spec_name", volume_spec_name)
        if data_protection_replication is not None:
            pulumi.set(__self__, "data_protection_replication", data_protection_replication)
        if data_protection_snapshot_policy is not None:
            pulumi.set(__self__, "data_protection_snapshot_policy", data_protection_snapshot_policy)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mount_ip_addresses is not None:
            pulumi.set(__self__, "mount_ip_addresses", mount_ip_addresses)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="capacityPoolId")
    def capacity_pool_id(self) -> builtins.str:
        """
        The ID of the Capacity Pool. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "capacity_pool_id")

    @property
    @pulumi.getter(name="exportPolicyRules")
    def export_policy_rules(self) -> Sequence['outputs.VolumeGroupSapHanaVolumeExportPolicyRule']:
        """
        One or more `export_policy_rule` blocks as defined below.
        """
        return pulumi.get(self, "export_policy_rules")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name which should be used for this volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> builtins.str:
        """
        The target volume protocol expressed as a list. Changing this forces a new Application Volume Group to be created and data will be lost. Supported values for Application Volume Group include `NFSv3` or `NFSv4.1`, multi-protocol is not supported and there are certain rules on which protocol is supporteed per volume spec, please check [Configure application volume groups for the SAP HANA REST API](https://learn.microsoft.com/en-us/azure/azure-netapp-files/configure-application-volume-group-sap-hana-api) document for details.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> builtins.str:
        """
        Volume security style. Possible values are `ntfs` and `unix`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "security_style")

    @property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> builtins.str:
        """
        Volume security style. Possible values are `Premium`, `Standard` and `Ultra`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "service_level")

    @property
    @pulumi.getter(name="snapshotDirectoryVisible")
    def snapshot_directory_visible(self) -> builtins.bool:
        """
        Specifies whether the .snapshot (NFS clients) path of a volume is visible. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "snapshot_directory_visible")

    @property
    @pulumi.getter(name="storageQuotaInGb")
    def storage_quota_in_gb(self) -> builtins.int:
        """
        The maximum Storage Quota allowed for a file system in Gigabytes.
        """
        return pulumi.get(self, "storage_quota_in_gb")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="throughputInMibps")
    def throughput_in_mibps(self) -> builtins.float:
        """
        Throughput of this volume in Mibps.
        """
        return pulumi.get(self, "throughput_in_mibps")

    @property
    @pulumi.getter(name="volumePath")
    def volume_path(self) -> builtins.str:
        """
        A unique file path for the volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "volume_path")

    @property
    @pulumi.getter(name="volumeSpecName")
    def volume_spec_name(self) -> builtins.str:
        """
        Volume specification name. Possible values are `data`, `log`, `shared`, `data-backup` and `log-backup`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "volume_spec_name")

    @property
    @pulumi.getter(name="dataProtectionReplication")
    def data_protection_replication(self) -> Optional['outputs.VolumeGroupSapHanaVolumeDataProtectionReplication']:
        """
        A `data_protection_replication` block as defined below. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "data_protection_replication")

    @property
    @pulumi.getter(name="dataProtectionSnapshotPolicy")
    def data_protection_snapshot_policy(self) -> Optional['outputs.VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy']:
        """
        A `data_protection_snapshot_policy` block as defined below.
        """
        return pulumi.get(self, "data_protection_snapshot_policy")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Application Volume Group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mountIpAddresses")
    def mount_ip_addresses(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "mount_ip_addresses")

    @property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[builtins.str]:
        """
        The ID of the proximity placement group. Changing this forces a new Application Volume Group to be created and data will be lost. For SAP-HANA application, it is required to have PPG enabled so Azure NetApp Files can pin the volumes next to your compute resources, please check [Requirements and considerations for application volume group for SAP HANA](https://learn.microsoft.com/en-us/azure/azure-netapp-files/application-volume-group-considerations) for details and other requirements.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A mapping of tags which should be assigned to the Application Volume Group.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class VolumeGroupSapHanaVolumeDataProtectionReplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "remoteVolumeLocation":
            suggest = "remote_volume_location"
        elif key == "remoteVolumeResourceId":
            suggest = "remote_volume_resource_id"
        elif key == "replicationFrequency":
            suggest = "replication_frequency"
        elif key == "endpointType":
            suggest = "endpoint_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeGroupSapHanaVolumeDataProtectionReplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeGroupSapHanaVolumeDataProtectionReplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeGroupSapHanaVolumeDataProtectionReplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 remote_volume_location: builtins.str,
                 remote_volume_resource_id: builtins.str,
                 replication_frequency: builtins.str,
                 endpoint_type: Optional[builtins.str] = None):
        """
        :param builtins.str remote_volume_location: Location of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.str remote_volume_resource_id: Resource ID of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.str replication_frequency: eplication frequency. Possible values are `10minutes`, `daily` and `hourly`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param builtins.str endpoint_type: The endpoint type. Possible values are `dst` and `src`. Defaults to `dst`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        pulumi.set(__self__, "remote_volume_location", remote_volume_location)
        pulumi.set(__self__, "remote_volume_resource_id", remote_volume_resource_id)
        pulumi.set(__self__, "replication_frequency", replication_frequency)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)

    @property
    @pulumi.getter(name="remoteVolumeLocation")
    def remote_volume_location(self) -> builtins.str:
        """
        Location of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "remote_volume_location")

    @property
    @pulumi.getter(name="remoteVolumeResourceId")
    def remote_volume_resource_id(self) -> builtins.str:
        """
        Resource ID of the primary volume. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "remote_volume_resource_id")

    @property
    @pulumi.getter(name="replicationFrequency")
    def replication_frequency(self) -> builtins.str:
        """
        eplication frequency. Possible values are `10minutes`, `daily` and `hourly`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "replication_frequency")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[builtins.str]:
        """
        The endpoint type. Possible values are `dst` and `src`. Defaults to `dst`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "endpoint_type")


@pulumi.output_type
class VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotPolicyId":
            suggest = "snapshot_policy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshot_policy_id: builtins.str):
        """
        :param builtins.str snapshot_policy_id: Resource ID of the snapshot policy to apply to the volume.
        """
        pulumi.set(__self__, "snapshot_policy_id", snapshot_policy_id)

    @property
    @pulumi.getter(name="snapshotPolicyId")
    def snapshot_policy_id(self) -> builtins.str:
        """
        Resource ID of the snapshot policy to apply to the volume.
        """
        return pulumi.get(self, "snapshot_policy_id")


@pulumi.output_type
class VolumeGroupSapHanaVolumeExportPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedClients":
            suggest = "allowed_clients"
        elif key == "nfsv3Enabled":
            suggest = "nfsv3_enabled"
        elif key == "nfsv41Enabled":
            suggest = "nfsv41_enabled"
        elif key == "ruleIndex":
            suggest = "rule_index"
        elif key == "rootAccessEnabled":
            suggest = "root_access_enabled"
        elif key == "unixReadOnly":
            suggest = "unix_read_only"
        elif key == "unixReadWrite":
            suggest = "unix_read_write"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeGroupSapHanaVolumeExportPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeGroupSapHanaVolumeExportPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeGroupSapHanaVolumeExportPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_clients: builtins.str,
                 nfsv3_enabled: builtins.bool,
                 nfsv41_enabled: builtins.bool,
                 rule_index: builtins.int,
                 root_access_enabled: Optional[builtins.bool] = None,
                 unix_read_only: Optional[builtins.bool] = None,
                 unix_read_write: Optional[builtins.bool] = None):
        """
        :param builtins.str allowed_clients: A comma-sperated list of allowed client IPv4 addresses.
        :param builtins.bool nfsv3_enabled: Enables NFSv3. Please note that this cannot be enabled if volume has NFSv4.1 as its protocol.
        :param builtins.bool nfsv41_enabled: Enables NFSv4.1. Please note that this cannot be enabled if volume has NFSv3 as its protocol.
        :param builtins.int rule_index: The index number of the rule, must start at 1 and maximum 5.
        :param builtins.bool root_access_enabled: Is root access permitted to this volume? Defaults to `true`.
        :param builtins.bool unix_read_only: Is the file system on unix read only? Defaults to `false.
        :param builtins.bool unix_read_write: Is the file system on unix read and write? Defaults to `true`.
        """
        pulumi.set(__self__, "allowed_clients", allowed_clients)
        pulumi.set(__self__, "nfsv3_enabled", nfsv3_enabled)
        pulumi.set(__self__, "nfsv41_enabled", nfsv41_enabled)
        pulumi.set(__self__, "rule_index", rule_index)
        if root_access_enabled is not None:
            pulumi.set(__self__, "root_access_enabled", root_access_enabled)
        if unix_read_only is not None:
            pulumi.set(__self__, "unix_read_only", unix_read_only)
        if unix_read_write is not None:
            pulumi.set(__self__, "unix_read_write", unix_read_write)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> builtins.str:
        """
        A comma-sperated list of allowed client IPv4 addresses.
        """
        return pulumi.get(self, "allowed_clients")

    @property
    @pulumi.getter(name="nfsv3Enabled")
    def nfsv3_enabled(self) -> builtins.bool:
        """
        Enables NFSv3. Please note that this cannot be enabled if volume has NFSv4.1 as its protocol.
        """
        return pulumi.get(self, "nfsv3_enabled")

    @property
    @pulumi.getter(name="nfsv41Enabled")
    def nfsv41_enabled(self) -> builtins.bool:
        """
        Enables NFSv4.1. Please note that this cannot be enabled if volume has NFSv3 as its protocol.
        """
        return pulumi.get(self, "nfsv41_enabled")

    @property
    @pulumi.getter(name="ruleIndex")
    def rule_index(self) -> builtins.int:
        """
        The index number of the rule, must start at 1 and maximum 5.
        """
        return pulumi.get(self, "rule_index")

    @property
    @pulumi.getter(name="rootAccessEnabled")
    def root_access_enabled(self) -> Optional[builtins.bool]:
        """
        Is root access permitted to this volume? Defaults to `true`.
        """
        return pulumi.get(self, "root_access_enabled")

    @property
    @pulumi.getter(name="unixReadOnly")
    def unix_read_only(self) -> Optional[builtins.bool]:
        """
        Is the file system on unix read only? Defaults to `false.
        """
        return pulumi.get(self, "unix_read_only")

    @property
    @pulumi.getter(name="unixReadWrite")
    def unix_read_write(self) -> Optional[builtins.bool]:
        """
        Is the file system on unix read and write? Defaults to `true`.
        """
        return pulumi.get(self, "unix_read_write")


@pulumi.output_type
class GetAccountIdentityResult(dict):
    def __init__(__self__, *,
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None):
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "identity_ids")


@pulumi.output_type
class GetSnapshotPolicyDailyScheduleResult(dict):
    def __init__(__self__, *,
                 hour: builtins.int,
                 minute: builtins.int,
                 snapshots_to_keep: builtins.int):
        """
        :param builtins.int hour: Hour of the day that the snapshots will be created.
        :param builtins.int minute: Minute of the hour that the snapshots will be created.
        :param builtins.int snapshots_to_keep: How many hourly snapshots to keep.
        """
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "minute", minute)
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)

    @property
    @pulumi.getter
    def hour(self) -> builtins.int:
        """
        Hour of the day that the snapshots will be created.
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def minute(self) -> builtins.int:
        """
        Minute of the hour that the snapshots will be created.
        """
        return pulumi.get(self, "minute")

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> builtins.int:
        """
        How many hourly snapshots to keep.
        """
        return pulumi.get(self, "snapshots_to_keep")


@pulumi.output_type
class GetSnapshotPolicyHourlyScheduleResult(dict):
    def __init__(__self__, *,
                 minute: builtins.int,
                 snapshots_to_keep: builtins.int):
        """
        :param builtins.int minute: Minute of the hour that the snapshots will be created.
        :param builtins.int snapshots_to_keep: How many hourly snapshots to keep.
        """
        pulumi.set(__self__, "minute", minute)
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)

    @property
    @pulumi.getter
    def minute(self) -> builtins.int:
        """
        Minute of the hour that the snapshots will be created.
        """
        return pulumi.get(self, "minute")

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> builtins.int:
        """
        How many hourly snapshots to keep.
        """
        return pulumi.get(self, "snapshots_to_keep")


@pulumi.output_type
class GetSnapshotPolicyMonthlyScheduleResult(dict):
    def __init__(__self__, *,
                 days_of_months: Sequence[builtins.int],
                 hour: builtins.int,
                 minute: builtins.int,
                 snapshots_to_keep: builtins.int):
        """
        :param builtins.int hour: Hour of the day that the snapshots will be created.
        :param builtins.int minute: Minute of the hour that the snapshots will be created.
        :param builtins.int snapshots_to_keep: How many hourly snapshots to keep.
        """
        pulumi.set(__self__, "days_of_months", days_of_months)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "minute", minute)
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)

    @property
    @pulumi.getter(name="daysOfMonths")
    def days_of_months(self) -> Sequence[builtins.int]:
        return pulumi.get(self, "days_of_months")

    @property
    @pulumi.getter
    def hour(self) -> builtins.int:
        """
        Hour of the day that the snapshots will be created.
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def minute(self) -> builtins.int:
        """
        Minute of the hour that the snapshots will be created.
        """
        return pulumi.get(self, "minute")

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> builtins.int:
        """
        How many hourly snapshots to keep.
        """
        return pulumi.get(self, "snapshots_to_keep")


@pulumi.output_type
class GetSnapshotPolicyWeeklyScheduleResult(dict):
    def __init__(__self__, *,
                 days_of_weeks: Sequence[builtins.str],
                 hour: builtins.int,
                 minute: builtins.int,
                 snapshots_to_keep: builtins.int):
        """
        :param Sequence[builtins.str] days_of_weeks: List of the week days using English names when the snapshots will be created.
        :param builtins.int hour: Hour of the day that the snapshots will be created.
        :param builtins.int minute: Minute of the hour that the snapshots will be created.
        :param builtins.int snapshots_to_keep: How many hourly snapshots to keep.
        """
        pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "minute", minute)
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)

    @property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Sequence[builtins.str]:
        """
        List of the week days using English names when the snapshots will be created.
        """
        return pulumi.get(self, "days_of_weeks")

    @property
    @pulumi.getter
    def hour(self) -> builtins.int:
        """
        Hour of the day that the snapshots will be created.
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def minute(self) -> builtins.int:
        """
        Minute of the hour that the snapshots will be created.
        """
        return pulumi.get(self, "minute")

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> builtins.int:
        """
        How many hourly snapshots to keep.
        """
        return pulumi.get(self, "snapshots_to_keep")


@pulumi.output_type
class GetVolumeDataProtectionBackupPolicyResult(dict):
    def __init__(__self__, *,
                 backup_policy_id: builtins.str,
                 backup_vault_id: builtins.str,
                 policy_enabled: builtins.bool):
        """
        :param builtins.str backup_policy_id: The Resource ID of the backup policy.
        :param builtins.str backup_vault_id: The Resource ID of the backup backup vault.
        :param builtins.bool policy_enabled: Backup policy is enabled or not.
        """
        pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        pulumi.set(__self__, "backup_vault_id", backup_vault_id)
        pulumi.set(__self__, "policy_enabled", policy_enabled)

    @property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> builtins.str:
        """
        The Resource ID of the backup policy.
        """
        return pulumi.get(self, "backup_policy_id")

    @property
    @pulumi.getter(name="backupVaultId")
    def backup_vault_id(self) -> builtins.str:
        """
        The Resource ID of the backup backup vault.
        """
        return pulumi.get(self, "backup_vault_id")

    @property
    @pulumi.getter(name="policyEnabled")
    def policy_enabled(self) -> builtins.bool:
        """
        Backup policy is enabled or not.
        """
        return pulumi.get(self, "policy_enabled")


@pulumi.output_type
class GetVolumeDataProtectionReplicationResult(dict):
    def __init__(__self__, *,
                 endpoint_type: builtins.str,
                 remote_volume_location: builtins.str,
                 remote_volume_resource_id: builtins.str,
                 replication_frequency: builtins.str):
        """
        :param builtins.str endpoint_type: The endpoint type.
        :param builtins.str remote_volume_location: Location of the primary volume.
        :param builtins.str remote_volume_resource_id: Resource ID of the primary volume.
        :param builtins.str replication_frequency: Frequency of replication.
        """
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "remote_volume_location", remote_volume_location)
        pulumi.set(__self__, "remote_volume_resource_id", remote_volume_resource_id)
        pulumi.set(__self__, "replication_frequency", replication_frequency)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> builtins.str:
        """
        The endpoint type.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="remoteVolumeLocation")
    def remote_volume_location(self) -> builtins.str:
        """
        Location of the primary volume.
        """
        return pulumi.get(self, "remote_volume_location")

    @property
    @pulumi.getter(name="remoteVolumeResourceId")
    def remote_volume_resource_id(self) -> builtins.str:
        """
        Resource ID of the primary volume.
        """
        return pulumi.get(self, "remote_volume_resource_id")

    @property
    @pulumi.getter(name="replicationFrequency")
    def replication_frequency(self) -> builtins.str:
        """
        Frequency of replication.
        """
        return pulumi.get(self, "replication_frequency")


@pulumi.output_type
class GetVolumeGroupOracleVolumeResult(dict):
    def __init__(__self__, *,
                 capacity_pool_id: builtins.str,
                 data_protection_replications: Sequence['outputs.GetVolumeGroupOracleVolumeDataProtectionReplicationResult'],
                 data_protection_snapshot_policies: Sequence['outputs.GetVolumeGroupOracleVolumeDataProtectionSnapshotPolicyResult'],
                 encryption_key_source: builtins.str,
                 export_policy_rules: Sequence['outputs.GetVolumeGroupOracleVolumeExportPolicyRuleResult'],
                 id: builtins.str,
                 key_vault_private_endpoint_id: builtins.str,
                 mount_ip_addresses: Sequence[builtins.str],
                 name: builtins.str,
                 network_features: builtins.str,
                 protocols: Sequence[builtins.str],
                 proximity_placement_group_id: builtins.str,
                 security_style: builtins.str,
                 service_level: builtins.str,
                 snapshot_directory_visible: builtins.bool,
                 storage_quota_in_gb: builtins.int,
                 subnet_id: builtins.str,
                 tags: Mapping[str, builtins.str],
                 throughput_in_mibps: builtins.float,
                 volume_path: builtins.str,
                 volume_spec_name: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.str capacity_pool_id: The ID of the Capacity Pool.
        :param Sequence['GetVolumeGroupOracleVolumeDataProtectionSnapshotPolicyArgs'] data_protection_snapshot_policies: A `data_protection_snapshot_policy` block as defined below.
        :param builtins.str encryption_key_source: The encryption key source.
        :param Sequence['GetVolumeGroupOracleVolumeExportPolicyRuleArgs'] export_policy_rules: A `export_policy_rule` block as defined below.
        :param builtins.str id: Volume ID.
        :param builtins.str key_vault_private_endpoint_id: The Private Endpoint ID for Key Vault when using customer managed keys.
        :param Sequence[builtins.str] mount_ip_addresses: A `mount_ip_addresses` block as defined below.
        :param builtins.str name: The name of this Application Volume Group for Oracle application.
        :param builtins.str network_features: Network feature in use at the time of volume creation.
        :param Sequence[builtins.str] protocols: A `protocols` block as defined below.
        :param builtins.str proximity_placement_group_id: The ID of the proximity placement group.
        :param builtins.str security_style: Volume security style.
        :param builtins.str service_level: The target performance of the file system.
        :param builtins.bool snapshot_directory_visible: Is the .snapshot (NFS clients) path of a volume visible?
        :param builtins.int storage_quota_in_gb: The maximum Storage Quota allowed for a file system in Gigabytes.
        :param builtins.str subnet_id: The ID of the Subnet the NetApp Volume resides in.
        :param Mapping[str, builtins.str] tags: A mapping of tags assigned to the Application Volume Group.
        :param builtins.float throughput_in_mibps: Throughput of this volume in Mibps.
        :param builtins.str volume_path: A unique file path for the volume.
        :param builtins.str volume_spec_name: Volume spec name.
        """
        pulumi.set(__self__, "capacity_pool_id", capacity_pool_id)
        pulumi.set(__self__, "data_protection_replications", data_protection_replications)
        pulumi.set(__self__, "data_protection_snapshot_policies", data_protection_snapshot_policies)
        pulumi.set(__self__, "encryption_key_source", encryption_key_source)
        pulumi.set(__self__, "export_policy_rules", export_policy_rules)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key_vault_private_endpoint_id", key_vault_private_endpoint_id)
        pulumi.set(__self__, "mount_ip_addresses", mount_ip_addresses)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_features", network_features)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        pulumi.set(__self__, "security_style", security_style)
        pulumi.set(__self__, "service_level", service_level)
        pulumi.set(__self__, "snapshot_directory_visible", snapshot_directory_visible)
        pulumi.set(__self__, "storage_quota_in_gb", storage_quota_in_gb)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "throughput_in_mibps", throughput_in_mibps)
        pulumi.set(__self__, "volume_path", volume_path)
        pulumi.set(__self__, "volume_spec_name", volume_spec_name)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="capacityPoolId")
    def capacity_pool_id(self) -> builtins.str:
        """
        The ID of the Capacity Pool.
        """
        return pulumi.get(self, "capacity_pool_id")

    @property
    @pulumi.getter(name="dataProtectionReplications")
    def data_protection_replications(self) -> Sequence['outputs.GetVolumeGroupOracleVolumeDataProtectionReplicationResult']:
        return pulumi.get(self, "data_protection_replications")

    @property
    @pulumi.getter(name="dataProtectionSnapshotPolicies")
    def data_protection_snapshot_policies(self) -> Sequence['outputs.GetVolumeGroupOracleVolumeDataProtectionSnapshotPolicyResult']:
        """
        A `data_protection_snapshot_policy` block as defined below.
        """
        return pulumi.get(self, "data_protection_snapshot_policies")

    @property
    @pulumi.getter(name="encryptionKeySource")
    def encryption_key_source(self) -> builtins.str:
        """
        The encryption key source.
        """
        return pulumi.get(self, "encryption_key_source")

    @property
    @pulumi.getter(name="exportPolicyRules")
    def export_policy_rules(self) -> Sequence['outputs.GetVolumeGroupOracleVolumeExportPolicyRuleResult']:
        """
        A `export_policy_rule` block as defined below.
        """
        return pulumi.get(self, "export_policy_rules")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Volume ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyVaultPrivateEndpointId")
    def key_vault_private_endpoint_id(self) -> builtins.str:
        """
        The Private Endpoint ID for Key Vault when using customer managed keys.
        """
        return pulumi.get(self, "key_vault_private_endpoint_id")

    @property
    @pulumi.getter(name="mountIpAddresses")
    def mount_ip_addresses(self) -> Sequence[builtins.str]:
        """
        A `mount_ip_addresses` block as defined below.
        """
        return pulumi.get(self, "mount_ip_addresses")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of this Application Volume Group for Oracle application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFeatures")
    def network_features(self) -> builtins.str:
        """
        Network feature in use at the time of volume creation.
        """
        return pulumi.get(self, "network_features")

    @property
    @pulumi.getter
    def protocols(self) -> Sequence[builtins.str]:
        """
        A `protocols` block as defined below.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> builtins.str:
        """
        The ID of the proximity placement group.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> builtins.str:
        """
        Volume security style.
        """
        return pulumi.get(self, "security_style")

    @property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> builtins.str:
        """
        The target performance of the file system.
        """
        return pulumi.get(self, "service_level")

    @property
    @pulumi.getter(name="snapshotDirectoryVisible")
    def snapshot_directory_visible(self) -> builtins.bool:
        """
        Is the .snapshot (NFS clients) path of a volume visible?
        """
        return pulumi.get(self, "snapshot_directory_visible")

    @property
    @pulumi.getter(name="storageQuotaInGb")
    def storage_quota_in_gb(self) -> builtins.int:
        """
        The maximum Storage Quota allowed for a file system in Gigabytes.
        """
        return pulumi.get(self, "storage_quota_in_gb")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The ID of the Subnet the NetApp Volume resides in.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the Application Volume Group.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="throughputInMibps")
    def throughput_in_mibps(self) -> builtins.float:
        """
        Throughput of this volume in Mibps.
        """
        return pulumi.get(self, "throughput_in_mibps")

    @property
    @pulumi.getter(name="volumePath")
    def volume_path(self) -> builtins.str:
        """
        A unique file path for the volume.
        """
        return pulumi.get(self, "volume_path")

    @property
    @pulumi.getter(name="volumeSpecName")
    def volume_spec_name(self) -> builtins.str:
        """
        Volume spec name.
        """
        return pulumi.get(self, "volume_spec_name")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetVolumeGroupOracleVolumeDataProtectionReplicationResult(dict):
    def __init__(__self__, *,
                 endpoint_type: builtins.str,
                 remote_volume_location: builtins.str,
                 remote_volume_resource_id: builtins.str,
                 replication_frequency: builtins.str):
        """
        :param builtins.str endpoint_type: The endpoint type.
        :param builtins.str remote_volume_location: Location of the primary volume.
        :param builtins.str remote_volume_resource_id: Resource ID of the primary volume.
        :param builtins.str replication_frequency: Replication frequency.
        """
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "remote_volume_location", remote_volume_location)
        pulumi.set(__self__, "remote_volume_resource_id", remote_volume_resource_id)
        pulumi.set(__self__, "replication_frequency", replication_frequency)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> builtins.str:
        """
        The endpoint type.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="remoteVolumeLocation")
    def remote_volume_location(self) -> builtins.str:
        """
        Location of the primary volume.
        """
        return pulumi.get(self, "remote_volume_location")

    @property
    @pulumi.getter(name="remoteVolumeResourceId")
    def remote_volume_resource_id(self) -> builtins.str:
        """
        Resource ID of the primary volume.
        """
        return pulumi.get(self, "remote_volume_resource_id")

    @property
    @pulumi.getter(name="replicationFrequency")
    def replication_frequency(self) -> builtins.str:
        """
        Replication frequency.
        """
        return pulumi.get(self, "replication_frequency")


@pulumi.output_type
class GetVolumeGroupOracleVolumeDataProtectionSnapshotPolicyResult(dict):
    def __init__(__self__, *,
                 snapshot_policy_id: builtins.str):
        """
        :param builtins.str snapshot_policy_id: Resource ID of the snapshot policy to apply to the volume.
        """
        pulumi.set(__self__, "snapshot_policy_id", snapshot_policy_id)

    @property
    @pulumi.getter(name="snapshotPolicyId")
    def snapshot_policy_id(self) -> builtins.str:
        """
        Resource ID of the snapshot policy to apply to the volume.
        """
        return pulumi.get(self, "snapshot_policy_id")


@pulumi.output_type
class GetVolumeGroupOracleVolumeExportPolicyRuleResult(dict):
    def __init__(__self__, *,
                 allowed_clients: builtins.str,
                 nfsv3_enabled: builtins.bool,
                 nfsv41_enabled: builtins.bool,
                 root_access_enabled: builtins.bool,
                 rule_index: builtins.int,
                 unix_read_only: builtins.bool,
                 unix_read_write: builtins.bool):
        """
        :param builtins.str allowed_clients: A list of allowed clients IPv4 addresses.
        :param builtins.bool nfsv3_enabled: Is the NFSv3 protocol enabled?
        :param builtins.bool nfsv41_enabled: Is the NFSv4.1 enabled?
        :param builtins.bool root_access_enabled: Is root access permitted to this volume?
        :param builtins.int rule_index: The index number of the rule.
        :param builtins.bool unix_read_only: Is the file system on unix read only?.
        :param builtins.bool unix_read_write: Is the file system on unix read and write?.
        """
        pulumi.set(__self__, "allowed_clients", allowed_clients)
        pulumi.set(__self__, "nfsv3_enabled", nfsv3_enabled)
        pulumi.set(__self__, "nfsv41_enabled", nfsv41_enabled)
        pulumi.set(__self__, "root_access_enabled", root_access_enabled)
        pulumi.set(__self__, "rule_index", rule_index)
        pulumi.set(__self__, "unix_read_only", unix_read_only)
        pulumi.set(__self__, "unix_read_write", unix_read_write)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> builtins.str:
        """
        A list of allowed clients IPv4 addresses.
        """
        return pulumi.get(self, "allowed_clients")

    @property
    @pulumi.getter(name="nfsv3Enabled")
    def nfsv3_enabled(self) -> builtins.bool:
        """
        Is the NFSv3 protocol enabled?
        """
        return pulumi.get(self, "nfsv3_enabled")

    @property
    @pulumi.getter(name="nfsv41Enabled")
    def nfsv41_enabled(self) -> builtins.bool:
        """
        Is the NFSv4.1 enabled?
        """
        return pulumi.get(self, "nfsv41_enabled")

    @property
    @pulumi.getter(name="rootAccessEnabled")
    def root_access_enabled(self) -> builtins.bool:
        """
        Is root access permitted to this volume?
        """
        return pulumi.get(self, "root_access_enabled")

    @property
    @pulumi.getter(name="ruleIndex")
    def rule_index(self) -> builtins.int:
        """
        The index number of the rule.
        """
        return pulumi.get(self, "rule_index")

    @property
    @pulumi.getter(name="unixReadOnly")
    def unix_read_only(self) -> builtins.bool:
        """
        Is the file system on unix read only?.
        """
        return pulumi.get(self, "unix_read_only")

    @property
    @pulumi.getter(name="unixReadWrite")
    def unix_read_write(self) -> builtins.bool:
        """
        Is the file system on unix read and write?.
        """
        return pulumi.get(self, "unix_read_write")


@pulumi.output_type
class GetVolumeGroupSapHanaVolumeResult(dict):
    def __init__(__self__, *,
                 capacity_pool_id: builtins.str,
                 data_protection_replications: Sequence['outputs.GetVolumeGroupSapHanaVolumeDataProtectionReplicationResult'],
                 data_protection_snapshot_policies: Sequence['outputs.GetVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyResult'],
                 export_policy_rules: Sequence['outputs.GetVolumeGroupSapHanaVolumeExportPolicyRuleResult'],
                 id: builtins.str,
                 mount_ip_addresses: Sequence[builtins.str],
                 name: builtins.str,
                 protocols: Sequence[builtins.str],
                 proximity_placement_group_id: builtins.str,
                 security_style: builtins.str,
                 service_level: builtins.str,
                 snapshot_directory_visible: builtins.bool,
                 storage_quota_in_gb: builtins.int,
                 subnet_id: builtins.str,
                 tags: Mapping[str, builtins.str],
                 throughput_in_mibps: builtins.float,
                 volume_path: builtins.str,
                 volume_spec_name: builtins.str):
        """
        :param builtins.str capacity_pool_id: The ID of the Capacity Pool.
        :param Sequence['GetVolumeGroupSapHanaVolumeDataProtectionReplicationArgs'] data_protection_replications: A `data_protection_replication` block as defined below.
        :param Sequence['GetVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyArgs'] data_protection_snapshot_policies: A `data_protection_snapshot_policy` block as defined below.
        :param Sequence['GetVolumeGroupSapHanaVolumeExportPolicyRuleArgs'] export_policy_rules: A `export_policy_rule` block as defined below.
        :param builtins.str id: Volume ID.
        :param Sequence[builtins.str] mount_ip_addresses: A `mount_ip_addresses` block as defined below.
        :param builtins.str name: The name of this Application Volume Group for SAP HANA application.
        :param Sequence[builtins.str] protocols: A `protocols` block as defined below.
        :param builtins.str proximity_placement_group_id: The ID of the proximity placement group.
        :param builtins.str security_style: Volume security style.
        :param builtins.str service_level: The target performance of the file system.
        :param builtins.bool snapshot_directory_visible: Is the .snapshot (NFS clients) path of a volume visible?
        :param builtins.int storage_quota_in_gb: The maximum Storage Quota allowed for a file system in Gigabytes.
        :param builtins.str subnet_id: The ID of the Subnet the NetApp Volume resides in.
        :param Mapping[str, builtins.str] tags: A mapping of tags assigned to the Application Volume Group.
        :param builtins.float throughput_in_mibps: Throughput of this volume in Mibps.
        :param builtins.str volume_path: A unique file path for the volume.
        :param builtins.str volume_spec_name: Volume spec name.
        """
        pulumi.set(__self__, "capacity_pool_id", capacity_pool_id)
        pulumi.set(__self__, "data_protection_replications", data_protection_replications)
        pulumi.set(__self__, "data_protection_snapshot_policies", data_protection_snapshot_policies)
        pulumi.set(__self__, "export_policy_rules", export_policy_rules)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mount_ip_addresses", mount_ip_addresses)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        pulumi.set(__self__, "security_style", security_style)
        pulumi.set(__self__, "service_level", service_level)
        pulumi.set(__self__, "snapshot_directory_visible", snapshot_directory_visible)
        pulumi.set(__self__, "storage_quota_in_gb", storage_quota_in_gb)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "throughput_in_mibps", throughput_in_mibps)
        pulumi.set(__self__, "volume_path", volume_path)
        pulumi.set(__self__, "volume_spec_name", volume_spec_name)

    @property
    @pulumi.getter(name="capacityPoolId")
    def capacity_pool_id(self) -> builtins.str:
        """
        The ID of the Capacity Pool.
        """
        return pulumi.get(self, "capacity_pool_id")

    @property
    @pulumi.getter(name="dataProtectionReplications")
    def data_protection_replications(self) -> Sequence['outputs.GetVolumeGroupSapHanaVolumeDataProtectionReplicationResult']:
        """
        A `data_protection_replication` block as defined below.
        """
        return pulumi.get(self, "data_protection_replications")

    @property
    @pulumi.getter(name="dataProtectionSnapshotPolicies")
    def data_protection_snapshot_policies(self) -> Sequence['outputs.GetVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyResult']:
        """
        A `data_protection_snapshot_policy` block as defined below.
        """
        return pulumi.get(self, "data_protection_snapshot_policies")

    @property
    @pulumi.getter(name="exportPolicyRules")
    def export_policy_rules(self) -> Sequence['outputs.GetVolumeGroupSapHanaVolumeExportPolicyRuleResult']:
        """
        A `export_policy_rule` block as defined below.
        """
        return pulumi.get(self, "export_policy_rules")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Volume ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mountIpAddresses")
    def mount_ip_addresses(self) -> Sequence[builtins.str]:
        """
        A `mount_ip_addresses` block as defined below.
        """
        return pulumi.get(self, "mount_ip_addresses")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of this Application Volume Group for SAP HANA application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> Sequence[builtins.str]:
        """
        A `protocols` block as defined below.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> builtins.str:
        """
        The ID of the proximity placement group.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> builtins.str:
        """
        Volume security style.
        """
        return pulumi.get(self, "security_style")

    @property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> builtins.str:
        """
        The target performance of the file system.
        """
        return pulumi.get(self, "service_level")

    @property
    @pulumi.getter(name="snapshotDirectoryVisible")
    def snapshot_directory_visible(self) -> builtins.bool:
        """
        Is the .snapshot (NFS clients) path of a volume visible?
        """
        return pulumi.get(self, "snapshot_directory_visible")

    @property
    @pulumi.getter(name="storageQuotaInGb")
    def storage_quota_in_gb(self) -> builtins.int:
        """
        The maximum Storage Quota allowed for a file system in Gigabytes.
        """
        return pulumi.get(self, "storage_quota_in_gb")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The ID of the Subnet the NetApp Volume resides in.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the Application Volume Group.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="throughputInMibps")
    def throughput_in_mibps(self) -> builtins.float:
        """
        Throughput of this volume in Mibps.
        """
        return pulumi.get(self, "throughput_in_mibps")

    @property
    @pulumi.getter(name="volumePath")
    def volume_path(self) -> builtins.str:
        """
        A unique file path for the volume.
        """
        return pulumi.get(self, "volume_path")

    @property
    @pulumi.getter(name="volumeSpecName")
    def volume_spec_name(self) -> builtins.str:
        """
        Volume spec name.
        """
        return pulumi.get(self, "volume_spec_name")


@pulumi.output_type
class GetVolumeGroupSapHanaVolumeDataProtectionReplicationResult(dict):
    def __init__(__self__, *,
                 endpoint_type: builtins.str,
                 remote_volume_location: builtins.str,
                 remote_volume_resource_id: builtins.str,
                 replication_frequency: builtins.str):
        """
        :param builtins.str endpoint_type: The endpoint type.
        :param builtins.str remote_volume_location: Location of the primary volume.
        :param builtins.str remote_volume_resource_id: Resource ID of the primary volume.
        :param builtins.str replication_frequency: Replication frequency.
        """
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "remote_volume_location", remote_volume_location)
        pulumi.set(__self__, "remote_volume_resource_id", remote_volume_resource_id)
        pulumi.set(__self__, "replication_frequency", replication_frequency)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> builtins.str:
        """
        The endpoint type.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="remoteVolumeLocation")
    def remote_volume_location(self) -> builtins.str:
        """
        Location of the primary volume.
        """
        return pulumi.get(self, "remote_volume_location")

    @property
    @pulumi.getter(name="remoteVolumeResourceId")
    def remote_volume_resource_id(self) -> builtins.str:
        """
        Resource ID of the primary volume.
        """
        return pulumi.get(self, "remote_volume_resource_id")

    @property
    @pulumi.getter(name="replicationFrequency")
    def replication_frequency(self) -> builtins.str:
        """
        Replication frequency.
        """
        return pulumi.get(self, "replication_frequency")


@pulumi.output_type
class GetVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyResult(dict):
    def __init__(__self__, *,
                 snapshot_policy_id: builtins.str):
        """
        :param builtins.str snapshot_policy_id: Resource ID of the snapshot policy to apply to the volume.
        """
        pulumi.set(__self__, "snapshot_policy_id", snapshot_policy_id)

    @property
    @pulumi.getter(name="snapshotPolicyId")
    def snapshot_policy_id(self) -> builtins.str:
        """
        Resource ID of the snapshot policy to apply to the volume.
        """
        return pulumi.get(self, "snapshot_policy_id")


@pulumi.output_type
class GetVolumeGroupSapHanaVolumeExportPolicyRuleResult(dict):
    def __init__(__self__, *,
                 allowed_clients: builtins.str,
                 nfsv3_enabled: builtins.bool,
                 nfsv41_enabled: builtins.bool,
                 root_access_enabled: builtins.bool,
                 rule_index: builtins.int,
                 unix_read_only: builtins.bool,
                 unix_read_write: builtins.bool):
        """
        :param builtins.str allowed_clients: A list of allowed clients IPv4 addresses.
        :param builtins.bool nfsv3_enabled: Is the NFSv3 protocol enabled?
        :param builtins.bool nfsv41_enabled: Is the NFSv4.1 enabled?
        :param builtins.bool root_access_enabled: Is root access permitted to this volume?
        :param builtins.int rule_index: The index number of the rule.
        :param builtins.bool unix_read_only: Is the file system on unix read only?.
        :param builtins.bool unix_read_write: Is the file system on unix read and write?.
        """
        pulumi.set(__self__, "allowed_clients", allowed_clients)
        pulumi.set(__self__, "nfsv3_enabled", nfsv3_enabled)
        pulumi.set(__self__, "nfsv41_enabled", nfsv41_enabled)
        pulumi.set(__self__, "root_access_enabled", root_access_enabled)
        pulumi.set(__self__, "rule_index", rule_index)
        pulumi.set(__self__, "unix_read_only", unix_read_only)
        pulumi.set(__self__, "unix_read_write", unix_read_write)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> builtins.str:
        """
        A list of allowed clients IPv4 addresses.
        """
        return pulumi.get(self, "allowed_clients")

    @property
    @pulumi.getter(name="nfsv3Enabled")
    def nfsv3_enabled(self) -> builtins.bool:
        """
        Is the NFSv3 protocol enabled?
        """
        return pulumi.get(self, "nfsv3_enabled")

    @property
    @pulumi.getter(name="nfsv41Enabled")
    def nfsv41_enabled(self) -> builtins.bool:
        """
        Is the NFSv4.1 enabled?
        """
        return pulumi.get(self, "nfsv41_enabled")

    @property
    @pulumi.getter(name="rootAccessEnabled")
    def root_access_enabled(self) -> builtins.bool:
        """
        Is root access permitted to this volume?
        """
        return pulumi.get(self, "root_access_enabled")

    @property
    @pulumi.getter(name="ruleIndex")
    def rule_index(self) -> builtins.int:
        """
        The index number of the rule.
        """
        return pulumi.get(self, "rule_index")

    @property
    @pulumi.getter(name="unixReadOnly")
    def unix_read_only(self) -> builtins.bool:
        """
        Is the file system on unix read only?.
        """
        return pulumi.get(self, "unix_read_only")

    @property
    @pulumi.getter(name="unixReadWrite")
    def unix_read_write(self) -> builtins.bool:
        """
        Is the file system on unix read and write?.
        """
        return pulumi.get(self, "unix_read_write")


