# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SnapshotPolicyArgs', 'SnapshotPolicy']

@pulumi.input_type
class SnapshotPolicyArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[builtins.str],
                 enabled: pulumi.Input[builtins.bool],
                 resource_group_name: pulumi.Input[builtins.str],
                 daily_schedule: Optional[pulumi.Input['SnapshotPolicyDailyScheduleArgs']] = None,
                 hourly_schedule: Optional[pulumi.Input['SnapshotPolicyHourlyScheduleArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 monthly_schedule: Optional[pulumi.Input['SnapshotPolicyMonthlyScheduleArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 weekly_schedule: Optional[pulumi.Input['SnapshotPolicyWeeklyScheduleArgs']] = None):
        """
        The set of arguments for constructing a SnapshotPolicy resource.
        :param pulumi.Input[builtins.str] account_name: The name of the NetApp Account in which the NetApp Snapshot Policy should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] enabled: Defines that the NetApp Snapshot Policy is enabled or not.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group where the NetApp Snapshot Policy should be created. Changing this forces a new resource to be created.
        :param pulumi.Input['SnapshotPolicyDailyScheduleArgs'] daily_schedule: Sets a daily snapshot schedule. A `daily_schedule` block as defined below.
        :param pulumi.Input['SnapshotPolicyHourlyScheduleArgs'] hourly_schedule: Sets an hourly snapshot schedule. A `hourly_schedule` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input['SnapshotPolicyMonthlyScheduleArgs'] monthly_schedule: Sets a monthly snapshot schedule. A `monthly_schedule` block as defined below.
        :param pulumi.Input[builtins.str] name: The name of the NetApp Snapshot Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['SnapshotPolicyWeeklyScheduleArgs'] weekly_schedule: Sets a weekly snapshot schedule. A `weekly_schedule` block as defined below.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if daily_schedule is not None:
            pulumi.set(__self__, "daily_schedule", daily_schedule)
        if hourly_schedule is not None:
            pulumi.set(__self__, "hourly_schedule", hourly_schedule)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if monthly_schedule is not None:
            pulumi.set(__self__, "monthly_schedule", monthly_schedule)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the NetApp Account in which the NetApp Snapshot Policy should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Defines that the NetApp Snapshot Policy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group where the NetApp Snapshot Policy should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> Optional[pulumi.Input['SnapshotPolicyDailyScheduleArgs']]:
        """
        Sets a daily snapshot schedule. A `daily_schedule` block as defined below.
        """
        return pulumi.get(self, "daily_schedule")

    @daily_schedule.setter
    def daily_schedule(self, value: Optional[pulumi.Input['SnapshotPolicyDailyScheduleArgs']]):
        pulumi.set(self, "daily_schedule", value)

    @property
    @pulumi.getter(name="hourlySchedule")
    def hourly_schedule(self) -> Optional[pulumi.Input['SnapshotPolicyHourlyScheduleArgs']]:
        """
        Sets an hourly snapshot schedule. A `hourly_schedule` block as defined below.
        """
        return pulumi.get(self, "hourly_schedule")

    @hourly_schedule.setter
    def hourly_schedule(self, value: Optional[pulumi.Input['SnapshotPolicyHourlyScheduleArgs']]):
        pulumi.set(self, "hourly_schedule", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="monthlySchedule")
    def monthly_schedule(self) -> Optional[pulumi.Input['SnapshotPolicyMonthlyScheduleArgs']]:
        """
        Sets a monthly snapshot schedule. A `monthly_schedule` block as defined below.
        """
        return pulumi.get(self, "monthly_schedule")

    @monthly_schedule.setter
    def monthly_schedule(self, value: Optional[pulumi.Input['SnapshotPolicyMonthlyScheduleArgs']]):
        pulumi.set(self, "monthly_schedule", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the NetApp Snapshot Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional[pulumi.Input['SnapshotPolicyWeeklyScheduleArgs']]:
        """
        Sets a weekly snapshot schedule. A `weekly_schedule` block as defined below.
        """
        return pulumi.get(self, "weekly_schedule")

    @weekly_schedule.setter
    def weekly_schedule(self, value: Optional[pulumi.Input['SnapshotPolicyWeeklyScheduleArgs']]):
        pulumi.set(self, "weekly_schedule", value)


@pulumi.input_type
class _SnapshotPolicyState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[builtins.str]] = None,
                 daily_schedule: Optional[pulumi.Input['SnapshotPolicyDailyScheduleArgs']] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 hourly_schedule: Optional[pulumi.Input['SnapshotPolicyHourlyScheduleArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 monthly_schedule: Optional[pulumi.Input['SnapshotPolicyMonthlyScheduleArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 weekly_schedule: Optional[pulumi.Input['SnapshotPolicyWeeklyScheduleArgs']] = None):
        """
        Input properties used for looking up and filtering SnapshotPolicy resources.
        :param pulumi.Input[builtins.str] account_name: The name of the NetApp Account in which the NetApp Snapshot Policy should be created. Changing this forces a new resource to be created.
        :param pulumi.Input['SnapshotPolicyDailyScheduleArgs'] daily_schedule: Sets a daily snapshot schedule. A `daily_schedule` block as defined below.
        :param pulumi.Input[builtins.bool] enabled: Defines that the NetApp Snapshot Policy is enabled or not.
        :param pulumi.Input['SnapshotPolicyHourlyScheduleArgs'] hourly_schedule: Sets an hourly snapshot schedule. A `hourly_schedule` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input['SnapshotPolicyMonthlyScheduleArgs'] monthly_schedule: Sets a monthly snapshot schedule. A `monthly_schedule` block as defined below.
        :param pulumi.Input[builtins.str] name: The name of the NetApp Snapshot Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group where the NetApp Snapshot Policy should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['SnapshotPolicyWeeklyScheduleArgs'] weekly_schedule: Sets a weekly snapshot schedule. A `weekly_schedule` block as defined below.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if daily_schedule is not None:
            pulumi.set(__self__, "daily_schedule", daily_schedule)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if hourly_schedule is not None:
            pulumi.set(__self__, "hourly_schedule", hourly_schedule)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if monthly_schedule is not None:
            pulumi.set(__self__, "monthly_schedule", monthly_schedule)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the NetApp Account in which the NetApp Snapshot Policy should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> Optional[pulumi.Input['SnapshotPolicyDailyScheduleArgs']]:
        """
        Sets a daily snapshot schedule. A `daily_schedule` block as defined below.
        """
        return pulumi.get(self, "daily_schedule")

    @daily_schedule.setter
    def daily_schedule(self, value: Optional[pulumi.Input['SnapshotPolicyDailyScheduleArgs']]):
        pulumi.set(self, "daily_schedule", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines that the NetApp Snapshot Policy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="hourlySchedule")
    def hourly_schedule(self) -> Optional[pulumi.Input['SnapshotPolicyHourlyScheduleArgs']]:
        """
        Sets an hourly snapshot schedule. A `hourly_schedule` block as defined below.
        """
        return pulumi.get(self, "hourly_schedule")

    @hourly_schedule.setter
    def hourly_schedule(self, value: Optional[pulumi.Input['SnapshotPolicyHourlyScheduleArgs']]):
        pulumi.set(self, "hourly_schedule", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="monthlySchedule")
    def monthly_schedule(self) -> Optional[pulumi.Input['SnapshotPolicyMonthlyScheduleArgs']]:
        """
        Sets a monthly snapshot schedule. A `monthly_schedule` block as defined below.
        """
        return pulumi.get(self, "monthly_schedule")

    @monthly_schedule.setter
    def monthly_schedule(self, value: Optional[pulumi.Input['SnapshotPolicyMonthlyScheduleArgs']]):
        pulumi.set(self, "monthly_schedule", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the NetApp Snapshot Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group where the NetApp Snapshot Policy should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional[pulumi.Input['SnapshotPolicyWeeklyScheduleArgs']]:
        """
        Sets a weekly snapshot schedule. A `weekly_schedule` block as defined below.
        """
        return pulumi.get(self, "weekly_schedule")

    @weekly_schedule.setter
    def weekly_schedule(self, value: Optional[pulumi.Input['SnapshotPolicyWeeklyScheduleArgs']]):
        pulumi.set(self, "weekly_schedule", value)


@pulumi.type_token("azure:netapp/snapshotPolicy:SnapshotPolicy")
class SnapshotPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[builtins.str]] = None,
                 daily_schedule: Optional[pulumi.Input[Union['SnapshotPolicyDailyScheduleArgs', 'SnapshotPolicyDailyScheduleArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 hourly_schedule: Optional[pulumi.Input[Union['SnapshotPolicyHourlyScheduleArgs', 'SnapshotPolicyHourlyScheduleArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 monthly_schedule: Optional[pulumi.Input[Union['SnapshotPolicyMonthlyScheduleArgs', 'SnapshotPolicyMonthlyScheduleArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 weekly_schedule: Optional[pulumi.Input[Union['SnapshotPolicyWeeklyScheduleArgs', 'SnapshotPolicyWeeklyScheduleArgsDict']]] = None,
                 __props__=None):
        """
        Manages a NetApp Snapshot Policy.

        ## NetApp Snapshot Policy Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="resource-group-01",
            location="East US")
        example_account = azure.netapp.Account("example",
            name="netappaccount-01",
            location=example.location,
            resource_group_name=example.name)
        example_snapshot_policy = azure.netapp.SnapshotPolicy("example",
            name="snapshotpolicy-01",
            location=example.location,
            resource_group_name=example.name,
            account_name=example_account.name,
            enabled=True,
            hourly_schedule={
                "snapshots_to_keep": 4,
                "minute": 15,
            },
            daily_schedule={
                "snapshots_to_keep": 2,
                "hour": 20,
                "minute": 15,
            },
            weekly_schedule={
                "snapshots_to_keep": 1,
                "days_of_weeks": [
                    "Monday",
                    "Friday",
                ],
                "hour": 23,
                "minute": 0,
            },
            monthly_schedule={
                "snapshots_to_keep": 1,
                "days_of_months": [
                    1,
                    15,
                    20,
                    30,
                ],
                "hour": 5,
                "minute": 45,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetApp`: 2025-01-01

        ## Import

        NetApp Snapshot Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/snapshotPolicy:SnapshotPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.NetApp/netAppAccounts/account1/snapshotPolicies/snapshotpolicy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_name: The name of the NetApp Account in which the NetApp Snapshot Policy should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SnapshotPolicyDailyScheduleArgs', 'SnapshotPolicyDailyScheduleArgsDict']] daily_schedule: Sets a daily snapshot schedule. A `daily_schedule` block as defined below.
        :param pulumi.Input[builtins.bool] enabled: Defines that the NetApp Snapshot Policy is enabled or not.
        :param pulumi.Input[Union['SnapshotPolicyHourlyScheduleArgs', 'SnapshotPolicyHourlyScheduleArgsDict']] hourly_schedule: Sets an hourly snapshot schedule. A `hourly_schedule` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SnapshotPolicyMonthlyScheduleArgs', 'SnapshotPolicyMonthlyScheduleArgsDict']] monthly_schedule: Sets a monthly snapshot schedule. A `monthly_schedule` block as defined below.
        :param pulumi.Input[builtins.str] name: The name of the NetApp Snapshot Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group where the NetApp Snapshot Policy should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['SnapshotPolicyWeeklyScheduleArgs', 'SnapshotPolicyWeeklyScheduleArgsDict']] weekly_schedule: Sets a weekly snapshot schedule. A `weekly_schedule` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnapshotPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a NetApp Snapshot Policy.

        ## NetApp Snapshot Policy Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="resource-group-01",
            location="East US")
        example_account = azure.netapp.Account("example",
            name="netappaccount-01",
            location=example.location,
            resource_group_name=example.name)
        example_snapshot_policy = azure.netapp.SnapshotPolicy("example",
            name="snapshotpolicy-01",
            location=example.location,
            resource_group_name=example.name,
            account_name=example_account.name,
            enabled=True,
            hourly_schedule={
                "snapshots_to_keep": 4,
                "minute": 15,
            },
            daily_schedule={
                "snapshots_to_keep": 2,
                "hour": 20,
                "minute": 15,
            },
            weekly_schedule={
                "snapshots_to_keep": 1,
                "days_of_weeks": [
                    "Monday",
                    "Friday",
                ],
                "hour": 23,
                "minute": 0,
            },
            monthly_schedule={
                "snapshots_to_keep": 1,
                "days_of_months": [
                    1,
                    15,
                    20,
                    30,
                ],
                "hour": 5,
                "minute": 45,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetApp`: 2025-01-01

        ## Import

        NetApp Snapshot Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/snapshotPolicy:SnapshotPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.NetApp/netAppAccounts/account1/snapshotPolicies/snapshotpolicy1
        ```

        :param str resource_name: The name of the resource.
        :param SnapshotPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[builtins.str]] = None,
                 daily_schedule: Optional[pulumi.Input[Union['SnapshotPolicyDailyScheduleArgs', 'SnapshotPolicyDailyScheduleArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 hourly_schedule: Optional[pulumi.Input[Union['SnapshotPolicyHourlyScheduleArgs', 'SnapshotPolicyHourlyScheduleArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 monthly_schedule: Optional[pulumi.Input[Union['SnapshotPolicyMonthlyScheduleArgs', 'SnapshotPolicyMonthlyScheduleArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 weekly_schedule: Optional[pulumi.Input[Union['SnapshotPolicyWeeklyScheduleArgs', 'SnapshotPolicyWeeklyScheduleArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotPolicyArgs.__new__(SnapshotPolicyArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["daily_schedule"] = daily_schedule
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["hourly_schedule"] = hourly_schedule
            __props__.__dict__["location"] = location
            __props__.__dict__["monthly_schedule"] = monthly_schedule
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["weekly_schedule"] = weekly_schedule
        super(SnapshotPolicy, __self__).__init__(
            'azure:netapp/snapshotPolicy:SnapshotPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[builtins.str]] = None,
            daily_schedule: Optional[pulumi.Input[Union['SnapshotPolicyDailyScheduleArgs', 'SnapshotPolicyDailyScheduleArgsDict']]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            hourly_schedule: Optional[pulumi.Input[Union['SnapshotPolicyHourlyScheduleArgs', 'SnapshotPolicyHourlyScheduleArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            monthly_schedule: Optional[pulumi.Input[Union['SnapshotPolicyMonthlyScheduleArgs', 'SnapshotPolicyMonthlyScheduleArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            weekly_schedule: Optional[pulumi.Input[Union['SnapshotPolicyWeeklyScheduleArgs', 'SnapshotPolicyWeeklyScheduleArgsDict']]] = None) -> 'SnapshotPolicy':
        """
        Get an existing SnapshotPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_name: The name of the NetApp Account in which the NetApp Snapshot Policy should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SnapshotPolicyDailyScheduleArgs', 'SnapshotPolicyDailyScheduleArgsDict']] daily_schedule: Sets a daily snapshot schedule. A `daily_schedule` block as defined below.
        :param pulumi.Input[builtins.bool] enabled: Defines that the NetApp Snapshot Policy is enabled or not.
        :param pulumi.Input[Union['SnapshotPolicyHourlyScheduleArgs', 'SnapshotPolicyHourlyScheduleArgsDict']] hourly_schedule: Sets an hourly snapshot schedule. A `hourly_schedule` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SnapshotPolicyMonthlyScheduleArgs', 'SnapshotPolicyMonthlyScheduleArgsDict']] monthly_schedule: Sets a monthly snapshot schedule. A `monthly_schedule` block as defined below.
        :param pulumi.Input[builtins.str] name: The name of the NetApp Snapshot Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group where the NetApp Snapshot Policy should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['SnapshotPolicyWeeklyScheduleArgs', 'SnapshotPolicyWeeklyScheduleArgsDict']] weekly_schedule: Sets a weekly snapshot schedule. A `weekly_schedule` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotPolicyState.__new__(_SnapshotPolicyState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["daily_schedule"] = daily_schedule
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["hourly_schedule"] = hourly_schedule
        __props__.__dict__["location"] = location
        __props__.__dict__["monthly_schedule"] = monthly_schedule
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["weekly_schedule"] = weekly_schedule
        return SnapshotPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the NetApp Account in which the NetApp Snapshot Policy should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> pulumi.Output[Optional['outputs.SnapshotPolicyDailySchedule']]:
        """
        Sets a daily snapshot schedule. A `daily_schedule` block as defined below.
        """
        return pulumi.get(self, "daily_schedule")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Defines that the NetApp Snapshot Policy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="hourlySchedule")
    def hourly_schedule(self) -> pulumi.Output[Optional['outputs.SnapshotPolicyHourlySchedule']]:
        """
        Sets an hourly snapshot schedule. A `hourly_schedule` block as defined below.
        """
        return pulumi.get(self, "hourly_schedule")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="monthlySchedule")
    def monthly_schedule(self) -> pulumi.Output[Optional['outputs.SnapshotPolicyMonthlySchedule']]:
        """
        Sets a monthly snapshot schedule. A `monthly_schedule` block as defined below.
        """
        return pulumi.get(self, "monthly_schedule")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the NetApp Snapshot Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group where the NetApp Snapshot Policy should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> pulumi.Output[Optional['outputs.SnapshotPolicyWeeklySchedule']]:
        """
        Sets a weekly snapshot schedule. A `weekly_schedule` block as defined below.
        """
        return pulumi.get(self, "weekly_schedule")

