# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeGroupSapHanaArgs', 'VolumeGroupSapHana']

@pulumi.input_type
class VolumeGroupSapHanaArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[builtins.str],
                 application_identifier: pulumi.Input[builtins.str],
                 group_description: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 volumes: pulumi.Input[Sequence[pulumi.Input['VolumeGroupSapHanaVolumeArgs']]],
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VolumeGroupSapHana resource.
        :param pulumi.Input[builtins.str] account_name: Name of the account where the application volume group belong to. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] application_identifier: The SAP System ID, maximum 3 characters, e.g. `SH9`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] group_description: Volume group description. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupSapHanaVolumeArgs']]] volumes: One or more `volume` blocks as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Application Volume Group. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "application_identifier", application_identifier)
        pulumi.set(__self__, "group_description", group_description)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "volumes", volumes)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the account where the application volume group belong to. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="applicationIdentifier")
    def application_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The SAP System ID, maximum 3 characters, e.g. `SH9`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "application_identifier")

    @application_identifier.setter
    def application_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_identifier", value)

    @property
    @pulumi.getter(name="groupDescription")
    def group_description(self) -> pulumi.Input[builtins.str]:
        """
        Volume group description. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "group_description")

    @group_description.setter
    def group_description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "group_description", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Input[Sequence[pulumi.Input['VolumeGroupSapHanaVolumeArgs']]]:
        """
        One or more `volume` blocks as defined below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: pulumi.Input[Sequence[pulumi.Input['VolumeGroupSapHanaVolumeArgs']]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Application Volume Group. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _VolumeGroupSapHanaState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[builtins.str]] = None,
                 application_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 group_description: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupSapHanaVolumeArgs']]]] = None):
        """
        Input properties used for looking up and filtering VolumeGroupSapHana resources.
        :param pulumi.Input[builtins.str] account_name: Name of the account where the application volume group belong to. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] application_identifier: The SAP System ID, maximum 3 characters, e.g. `SH9`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] group_description: Volume group description. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Application Volume Group. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupSapHanaVolumeArgs']]] volumes: One or more `volume` blocks as defined below.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if application_identifier is not None:
            pulumi.set(__self__, "application_identifier", application_identifier)
        if group_description is not None:
            pulumi.set(__self__, "group_description", group_description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the account where the application volume group belong to. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="applicationIdentifier")
    def application_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SAP System ID, maximum 3 characters, e.g. `SH9`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "application_identifier")

    @application_identifier.setter
    def application_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_identifier", value)

    @property
    @pulumi.getter(name="groupDescription")
    def group_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Volume group description. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "group_description")

    @group_description.setter
    def group_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_description", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Application Volume Group. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupSapHanaVolumeArgs']]]]:
        """
        One or more `volume` blocks as defined below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupSapHanaVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.type_token("azure:netapp/volumeGroupSapHana:VolumeGroupSapHana")
class VolumeGroupSapHana(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[builtins.str]] = None,
                 application_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 group_description: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupSapHanaVolumeArgs', 'VolumeGroupSapHanaVolumeArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_random as random

        example = random.RandomString("example",
            length=12,
            special=True)
        admin_username = "exampleadmin"
        admin_password = example.result
        example_resource_group = azure.core.ResourceGroup("example",
            name=f"{prefix}-resources",
            location=location)
        example_virtual_network = azure.network.VirtualNetwork("example",
            name=f"{prefix}-vnet",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            address_spaces=["10.88.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name=f"{prefix}-delegated-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.88.2.0/24"],
            delegations=[{
                "name": "testdelegation",
                "service_delegation": {
                    "name": "Microsoft.Netapp/volumes",
                    "actions": [
                        "Microsoft.Network/networkinterfaces/*",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                    ],
                },
            }])
        example1 = azure.network.Subnet("example1",
            name=f"{prefix}-hosts-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.88.1.0/24"])
        example_placement_group = azure.proximity.PlacementGroup("example",
            name=f"{prefix}-ppg",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name)
        example_availability_set = azure.compute.AvailabilitySet("example",
            name=f"{prefix}-avset",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            proximity_placement_group_id=example_placement_group.id)
        example_network_interface = azure.network.NetworkInterface("example",
            name=f"{prefix}-nic",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example1.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name=f"{prefix}-vm",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            size="Standard_M8ms",
            admin_username=admin_username,
            admin_password=admin_password,
            disable_password_authentication=False,
            proximity_placement_group_id=example_placement_group.id,
            availability_set_id=example_availability_set.id,
            network_interface_ids=[example_network_interface.id],
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            os_disk={
                "storage_account_type": "Standard_LRS",
                "caching": "ReadWrite",
            })
        example_account = azure.netapp.Account("example",
            name=f"{prefix}-netapp-account",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            opts = pulumi.ResourceOptions(depends_on=[
                    example_subnet,
                    example1,
                ]))
        example_pool = azure.netapp.Pool("example",
            name=f"{prefix}-netapp-pool",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            account_name=example_account.name,
            service_level="Standard",
            size_in_tb=8,
            qos_type="Manual")
        example_volume_group_sap_hana = azure.netapp.VolumeGroupSapHana("example",
            name=f"{prefix}-netapp-volumegroup",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            account_name=example_account.name,
            group_description="Test volume group",
            application_identifier="TST",
            volumes=[
                {
                    "name": f"{prefix}-netapp-volume-1",
                    "volume_path": "my-unique-file-path-1",
                    "service_level": "Standard",
                    "capacity_pool_id": example_pool.id,
                    "subnet_id": example_subnet.id,
                    "proximity_placement_group_id": example_placement_group.id,
                    "volume_spec_name": "data",
                    "storage_quota_in_gb": 1024,
                    "throughput_in_mibps": 24,
                    "protocols": "NFSv4.1",
                    "security_style": "unix",
                    "snapshot_directory_visible": False,
                    "export_policy_rules": [{
                        "rule_index": 1,
                        "allowed_clients": "0.0.0.0/0",
                        "nfsv3_enabled": False,
                        "nfsv41_enabled": True,
                        "unix_read_only": False,
                        "unix_read_write": True,
                        "root_access_enabled": False,
                    }],
                    "tags": {
                        "foo": "bar",
                    },
                },
                {
                    "name": f"{prefix}-netapp-volume-2",
                    "volume_path": "my-unique-file-path-2",
                    "service_level": "Standard",
                    "capacity_pool_id": example_pool.id,
                    "subnet_id": example_subnet.id,
                    "proximity_placement_group_id": example_placement_group.id,
                    "volume_spec_name": "log",
                    "storage_quota_in_gb": 1024,
                    "throughput_in_mibps": 24,
                    "protocols": "NFSv4.1",
                    "security_style": "unix",
                    "snapshot_directory_visible": False,
                    "export_policy_rules": [{
                        "rule_index": 1,
                        "allowed_clients": "0.0.0.0/0",
                        "nfsv3_enabled": False,
                        "nfsv41_enabled": True,
                        "unix_read_only": False,
                        "unix_read_write": True,
                        "root_access_enabled": False,
                    }],
                    "tags": {
                        "foo": "bar",
                    },
                },
                {
                    "name": f"{prefix}-netapp-volume-3",
                    "volume_path": "my-unique-file-path-3",
                    "service_level": "Standard",
                    "capacity_pool_id": example_pool.id,
                    "subnet_id": example_subnet.id,
                    "proximity_placement_group_id": example_placement_group.id,
                    "volume_spec_name": "shared",
                    "storage_quota_in_gb": 1024,
                    "throughput_in_mibps": 24,
                    "protocols": "NFSv4.1",
                    "security_style": "unix",
                    "snapshot_directory_visible": False,
                    "export_policy_rules": [{
                        "rule_index": 1,
                        "allowed_clients": "0.0.0.0/0",
                        "nfsv3_enabled": False,
                        "nfsv41_enabled": True,
                        "unix_read_only": False,
                        "unix_read_write": True,
                        "root_access_enabled": False,
                    }],
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    example_linux_virtual_machine,
                    example_placement_group,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetApp`: 2025-01-01

        ## Import

        Application Volume Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/volumeGroupSapHana:VolumeGroupSapHana example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mytest-rg/providers/Microsoft.NetApp/netAppAccounts/netapp-account-test/volumeGroups/netapp-volumegroup-test
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_name: Name of the account where the application volume group belong to. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] application_identifier: The SAP System ID, maximum 3 characters, e.g. `SH9`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] group_description: Volume group description. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Application Volume Group. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupSapHanaVolumeArgs', 'VolumeGroupSapHanaVolumeArgsDict']]]] volumes: One or more `volume` blocks as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeGroupSapHanaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_random as random

        example = random.RandomString("example",
            length=12,
            special=True)
        admin_username = "exampleadmin"
        admin_password = example.result
        example_resource_group = azure.core.ResourceGroup("example",
            name=f"{prefix}-resources",
            location=location)
        example_virtual_network = azure.network.VirtualNetwork("example",
            name=f"{prefix}-vnet",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            address_spaces=["10.88.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name=f"{prefix}-delegated-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.88.2.0/24"],
            delegations=[{
                "name": "testdelegation",
                "service_delegation": {
                    "name": "Microsoft.Netapp/volumes",
                    "actions": [
                        "Microsoft.Network/networkinterfaces/*",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                    ],
                },
            }])
        example1 = azure.network.Subnet("example1",
            name=f"{prefix}-hosts-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.88.1.0/24"])
        example_placement_group = azure.proximity.PlacementGroup("example",
            name=f"{prefix}-ppg",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name)
        example_availability_set = azure.compute.AvailabilitySet("example",
            name=f"{prefix}-avset",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            proximity_placement_group_id=example_placement_group.id)
        example_network_interface = azure.network.NetworkInterface("example",
            name=f"{prefix}-nic",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example1.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name=f"{prefix}-vm",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            size="Standard_M8ms",
            admin_username=admin_username,
            admin_password=admin_password,
            disable_password_authentication=False,
            proximity_placement_group_id=example_placement_group.id,
            availability_set_id=example_availability_set.id,
            network_interface_ids=[example_network_interface.id],
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            os_disk={
                "storage_account_type": "Standard_LRS",
                "caching": "ReadWrite",
            })
        example_account = azure.netapp.Account("example",
            name=f"{prefix}-netapp-account",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            opts = pulumi.ResourceOptions(depends_on=[
                    example_subnet,
                    example1,
                ]))
        example_pool = azure.netapp.Pool("example",
            name=f"{prefix}-netapp-pool",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            account_name=example_account.name,
            service_level="Standard",
            size_in_tb=8,
            qos_type="Manual")
        example_volume_group_sap_hana = azure.netapp.VolumeGroupSapHana("example",
            name=f"{prefix}-netapp-volumegroup",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            account_name=example_account.name,
            group_description="Test volume group",
            application_identifier="TST",
            volumes=[
                {
                    "name": f"{prefix}-netapp-volume-1",
                    "volume_path": "my-unique-file-path-1",
                    "service_level": "Standard",
                    "capacity_pool_id": example_pool.id,
                    "subnet_id": example_subnet.id,
                    "proximity_placement_group_id": example_placement_group.id,
                    "volume_spec_name": "data",
                    "storage_quota_in_gb": 1024,
                    "throughput_in_mibps": 24,
                    "protocols": "NFSv4.1",
                    "security_style": "unix",
                    "snapshot_directory_visible": False,
                    "export_policy_rules": [{
                        "rule_index": 1,
                        "allowed_clients": "0.0.0.0/0",
                        "nfsv3_enabled": False,
                        "nfsv41_enabled": True,
                        "unix_read_only": False,
                        "unix_read_write": True,
                        "root_access_enabled": False,
                    }],
                    "tags": {
                        "foo": "bar",
                    },
                },
                {
                    "name": f"{prefix}-netapp-volume-2",
                    "volume_path": "my-unique-file-path-2",
                    "service_level": "Standard",
                    "capacity_pool_id": example_pool.id,
                    "subnet_id": example_subnet.id,
                    "proximity_placement_group_id": example_placement_group.id,
                    "volume_spec_name": "log",
                    "storage_quota_in_gb": 1024,
                    "throughput_in_mibps": 24,
                    "protocols": "NFSv4.1",
                    "security_style": "unix",
                    "snapshot_directory_visible": False,
                    "export_policy_rules": [{
                        "rule_index": 1,
                        "allowed_clients": "0.0.0.0/0",
                        "nfsv3_enabled": False,
                        "nfsv41_enabled": True,
                        "unix_read_only": False,
                        "unix_read_write": True,
                        "root_access_enabled": False,
                    }],
                    "tags": {
                        "foo": "bar",
                    },
                },
                {
                    "name": f"{prefix}-netapp-volume-3",
                    "volume_path": "my-unique-file-path-3",
                    "service_level": "Standard",
                    "capacity_pool_id": example_pool.id,
                    "subnet_id": example_subnet.id,
                    "proximity_placement_group_id": example_placement_group.id,
                    "volume_spec_name": "shared",
                    "storage_quota_in_gb": 1024,
                    "throughput_in_mibps": 24,
                    "protocols": "NFSv4.1",
                    "security_style": "unix",
                    "snapshot_directory_visible": False,
                    "export_policy_rules": [{
                        "rule_index": 1,
                        "allowed_clients": "0.0.0.0/0",
                        "nfsv3_enabled": False,
                        "nfsv41_enabled": True,
                        "unix_read_only": False,
                        "unix_read_write": True,
                        "root_access_enabled": False,
                    }],
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    example_linux_virtual_machine,
                    example_placement_group,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetApp`: 2025-01-01

        ## Import

        Application Volume Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/volumeGroupSapHana:VolumeGroupSapHana example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mytest-rg/providers/Microsoft.NetApp/netAppAccounts/netapp-account-test/volumeGroups/netapp-volumegroup-test
        ```

        :param str resource_name: The name of the resource.
        :param VolumeGroupSapHanaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeGroupSapHanaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[builtins.str]] = None,
                 application_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 group_description: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupSapHanaVolumeArgs', 'VolumeGroupSapHanaVolumeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeGroupSapHanaArgs.__new__(VolumeGroupSapHanaArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if application_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'application_identifier'")
            __props__.__dict__["application_identifier"] = application_identifier
            if group_description is None and not opts.urn:
                raise TypeError("Missing required property 'group_description'")
            __props__.__dict__["group_description"] = group_description
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if volumes is None and not opts.urn:
                raise TypeError("Missing required property 'volumes'")
            __props__.__dict__["volumes"] = volumes
        super(VolumeGroupSapHana, __self__).__init__(
            'azure:netapp/volumeGroupSapHana:VolumeGroupSapHana',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[builtins.str]] = None,
            application_identifier: Optional[pulumi.Input[builtins.str]] = None,
            group_description: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupSapHanaVolumeArgs', 'VolumeGroupSapHanaVolumeArgsDict']]]]] = None) -> 'VolumeGroupSapHana':
        """
        Get an existing VolumeGroupSapHana resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_name: Name of the account where the application volume group belong to. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] application_identifier: The SAP System ID, maximum 3 characters, e.g. `SH9`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] group_description: Volume group description. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Application Volume Group. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupSapHanaVolumeArgs', 'VolumeGroupSapHanaVolumeArgsDict']]]] volumes: One or more `volume` blocks as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeGroupSapHanaState.__new__(_VolumeGroupSapHanaState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["application_identifier"] = application_identifier
        __props__.__dict__["group_description"] = group_description
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["volumes"] = volumes
        return VolumeGroupSapHana(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the account where the application volume group belong to. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="applicationIdentifier")
    def application_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The SAP System ID, maximum 3 characters, e.g. `SH9`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "application_identifier")

    @property
    @pulumi.getter(name="groupDescription")
    def group_description(self) -> pulumi.Output[builtins.str]:
        """
        Volume group description. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "group_description")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Application Volume Group. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Sequence['outputs.VolumeGroupSapHanaVolume']]:
        """
        One or more `volume` blocks as defined below.
        """
        return pulumi.get(self, "volumes")

