# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExpressRouteCircuitArgs', 'ExpressRouteCircuit']

@pulumi.input_type
class ExpressRouteCircuitArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 sku: pulumi.Input['ExpressRouteCircuitSkuArgs'],
                 allow_classic_operations: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_key: Optional[pulumi.Input[builtins.str]] = None,
                 bandwidth_in_gbps: Optional[pulumi.Input[builtins.float]] = None,
                 bandwidth_in_mbps: Optional[pulumi.Input[builtins.int]] = None,
                 express_route_port_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peering_location: Optional[pulumi.Input[builtins.str]] = None,
                 rate_limiting_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 service_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ExpressRouteCircuit resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the ExpressRoute circuit. Changing this forces a new resource to be created.
        :param pulumi.Input['ExpressRouteCircuitSkuArgs'] sku: A `sku` block for the ExpressRoute circuit as documented below.
        :param pulumi.Input[builtins.bool] allow_classic_operations: Allow the circuit to interact with classic (RDFE) resources. Defaults to `false`.
        :param pulumi.Input[builtins.str] authorization_key: The authorization key. This can be used to set up an ExpressRoute Circuit with an ExpressRoute Port from another subscription.
        :param pulumi.Input[builtins.float] bandwidth_in_gbps: The bandwidth in Gbps of the circuit being created on the Express Route Port.
               
               > **Note:** The `express_route_port_id` and the `bandwidth_in_gbps` should be set together and they conflict with `service_provider_name`, `peering_location` and `bandwidth_in_mbps`.
        :param pulumi.Input[builtins.int] bandwidth_in_mbps: The bandwidth in Mbps of the circuit being created on the Service Provider.
               
               > **Note:** Once you increase your bandwidth, you will not be able to decrease it to its previous value.
               
               > **Note:** The `service_provider_name`, the `peering_location` and the `bandwidth_in_mbps` should be set together and they conflict with `express_route_port_id` and `bandwidth_in_gbps`.
        :param pulumi.Input[builtins.str] express_route_port_id: The ID of the Express Route Port this Express Route Circuit is based on. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the ExpressRoute circuit. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] peering_location: The name of the peering location and **not** the Azure resource location. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] rate_limiting_enabled: Enable [rate limiting](https://learn.microsoft.com/en-us/azure/expressroute/rate-limit) for the circuit. Only works with ExpressRoute Ports. Defaults to `false`.
        :param pulumi.Input[builtins.str] service_provider_name: The name of the ExpressRoute Service Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if allow_classic_operations is not None:
            pulumi.set(__self__, "allow_classic_operations", allow_classic_operations)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if bandwidth_in_gbps is not None:
            pulumi.set(__self__, "bandwidth_in_gbps", bandwidth_in_gbps)
        if bandwidth_in_mbps is not None:
            pulumi.set(__self__, "bandwidth_in_mbps", bandwidth_in_mbps)
        if express_route_port_id is not None:
            pulumi.set(__self__, "express_route_port_id", express_route_port_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peering_location is not None:
            pulumi.set(__self__, "peering_location", peering_location)
        if rate_limiting_enabled is not None:
            pulumi.set(__self__, "rate_limiting_enabled", rate_limiting_enabled)
        if service_provider_name is not None:
            pulumi.set(__self__, "service_provider_name", service_provider_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the ExpressRoute circuit. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Input['ExpressRouteCircuitSkuArgs']:
        """
        A `sku` block for the ExpressRoute circuit as documented below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['ExpressRouteCircuitSkuArgs']):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="allowClassicOperations")
    def allow_classic_operations(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow the circuit to interact with classic (RDFE) resources. Defaults to `false`.
        """
        return pulumi.get(self, "allow_classic_operations")

    @allow_classic_operations.setter
    def allow_classic_operations(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_classic_operations", value)

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The authorization key. This can be used to set up an ExpressRoute Circuit with an ExpressRoute Port from another subscription.
        """
        return pulumi.get(self, "authorization_key")

    @authorization_key.setter
    def authorization_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_key", value)

    @property
    @pulumi.getter(name="bandwidthInGbps")
    def bandwidth_in_gbps(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The bandwidth in Gbps of the circuit being created on the Express Route Port.

        > **Note:** The `express_route_port_id` and the `bandwidth_in_gbps` should be set together and they conflict with `service_provider_name`, `peering_location` and `bandwidth_in_mbps`.
        """
        return pulumi.get(self, "bandwidth_in_gbps")

    @bandwidth_in_gbps.setter
    def bandwidth_in_gbps(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "bandwidth_in_gbps", value)

    @property
    @pulumi.getter(name="bandwidthInMbps")
    def bandwidth_in_mbps(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The bandwidth in Mbps of the circuit being created on the Service Provider.

        > **Note:** Once you increase your bandwidth, you will not be able to decrease it to its previous value.

        > **Note:** The `service_provider_name`, the `peering_location` and the `bandwidth_in_mbps` should be set together and they conflict with `express_route_port_id` and `bandwidth_in_gbps`.
        """
        return pulumi.get(self, "bandwidth_in_mbps")

    @bandwidth_in_mbps.setter
    def bandwidth_in_mbps(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "bandwidth_in_mbps", value)

    @property
    @pulumi.getter(name="expressRoutePortId")
    def express_route_port_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Express Route Port this Express Route Circuit is based on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_port_id")

    @express_route_port_id.setter
    def express_route_port_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "express_route_port_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the ExpressRoute circuit. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peeringLocation")
    def peering_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the peering location and **not** the Azure resource location. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peering_location")

    @peering_location.setter
    def peering_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peering_location", value)

    @property
    @pulumi.getter(name="rateLimitingEnabled")
    def rate_limiting_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable [rate limiting](https://learn.microsoft.com/en-us/azure/expressroute/rate-limit) for the circuit. Only works with ExpressRoute Ports. Defaults to `false`.
        """
        return pulumi.get(self, "rate_limiting_enabled")

    @rate_limiting_enabled.setter
    def rate_limiting_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "rate_limiting_enabled", value)

    @property
    @pulumi.getter(name="serviceProviderName")
    def service_provider_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the ExpressRoute Service Provider. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_provider_name")

    @service_provider_name.setter
    def service_provider_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_provider_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ExpressRouteCircuitState:
    def __init__(__self__, *,
                 allow_classic_operations: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_key: Optional[pulumi.Input[builtins.str]] = None,
                 bandwidth_in_gbps: Optional[pulumi.Input[builtins.float]] = None,
                 bandwidth_in_mbps: Optional[pulumi.Input[builtins.int]] = None,
                 express_route_port_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peering_location: Optional[pulumi.Input[builtins.str]] = None,
                 rate_limiting_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_key: Optional[pulumi.Input[builtins.str]] = None,
                 service_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_provider_provisioning_state: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input['ExpressRouteCircuitSkuArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ExpressRouteCircuit resources.
        :param pulumi.Input[builtins.bool] allow_classic_operations: Allow the circuit to interact with classic (RDFE) resources. Defaults to `false`.
        :param pulumi.Input[builtins.str] authorization_key: The authorization key. This can be used to set up an ExpressRoute Circuit with an ExpressRoute Port from another subscription.
        :param pulumi.Input[builtins.float] bandwidth_in_gbps: The bandwidth in Gbps of the circuit being created on the Express Route Port.
               
               > **Note:** The `express_route_port_id` and the `bandwidth_in_gbps` should be set together and they conflict with `service_provider_name`, `peering_location` and `bandwidth_in_mbps`.
        :param pulumi.Input[builtins.int] bandwidth_in_mbps: The bandwidth in Mbps of the circuit being created on the Service Provider.
               
               > **Note:** Once you increase your bandwidth, you will not be able to decrease it to its previous value.
               
               > **Note:** The `service_provider_name`, the `peering_location` and the `bandwidth_in_mbps` should be set together and they conflict with `express_route_port_id` and `bandwidth_in_gbps`.
        :param pulumi.Input[builtins.str] express_route_port_id: The ID of the Express Route Port this Express Route Circuit is based on. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the ExpressRoute circuit. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] peering_location: The name of the peering location and **not** the Azure resource location. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] rate_limiting_enabled: Enable [rate limiting](https://learn.microsoft.com/en-us/azure/expressroute/rate-limit) for the circuit. Only works with ExpressRoute Ports. Defaults to `false`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the ExpressRoute circuit. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] service_key: The string needed by the service provider to provision the ExpressRoute circuit.
        :param pulumi.Input[builtins.str] service_provider_name: The name of the ExpressRoute Service Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] service_provider_provisioning_state: The ExpressRoute circuit provisioning state from your chosen service provider. Possible values are `NotProvisioned`, `Provisioning`, `Provisioned`, and `Deprovisioning`.
        :param pulumi.Input['ExpressRouteCircuitSkuArgs'] sku: A `sku` block for the ExpressRoute circuit as documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if allow_classic_operations is not None:
            pulumi.set(__self__, "allow_classic_operations", allow_classic_operations)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if bandwidth_in_gbps is not None:
            pulumi.set(__self__, "bandwidth_in_gbps", bandwidth_in_gbps)
        if bandwidth_in_mbps is not None:
            pulumi.set(__self__, "bandwidth_in_mbps", bandwidth_in_mbps)
        if express_route_port_id is not None:
            pulumi.set(__self__, "express_route_port_id", express_route_port_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peering_location is not None:
            pulumi.set(__self__, "peering_location", peering_location)
        if rate_limiting_enabled is not None:
            pulumi.set(__self__, "rate_limiting_enabled", rate_limiting_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_key is not None:
            pulumi.set(__self__, "service_key", service_key)
        if service_provider_name is not None:
            pulumi.set(__self__, "service_provider_name", service_provider_name)
        if service_provider_provisioning_state is not None:
            pulumi.set(__self__, "service_provider_provisioning_state", service_provider_provisioning_state)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="allowClassicOperations")
    def allow_classic_operations(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow the circuit to interact with classic (RDFE) resources. Defaults to `false`.
        """
        return pulumi.get(self, "allow_classic_operations")

    @allow_classic_operations.setter
    def allow_classic_operations(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_classic_operations", value)

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The authorization key. This can be used to set up an ExpressRoute Circuit with an ExpressRoute Port from another subscription.
        """
        return pulumi.get(self, "authorization_key")

    @authorization_key.setter
    def authorization_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_key", value)

    @property
    @pulumi.getter(name="bandwidthInGbps")
    def bandwidth_in_gbps(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The bandwidth in Gbps of the circuit being created on the Express Route Port.

        > **Note:** The `express_route_port_id` and the `bandwidth_in_gbps` should be set together and they conflict with `service_provider_name`, `peering_location` and `bandwidth_in_mbps`.
        """
        return pulumi.get(self, "bandwidth_in_gbps")

    @bandwidth_in_gbps.setter
    def bandwidth_in_gbps(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "bandwidth_in_gbps", value)

    @property
    @pulumi.getter(name="bandwidthInMbps")
    def bandwidth_in_mbps(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The bandwidth in Mbps of the circuit being created on the Service Provider.

        > **Note:** Once you increase your bandwidth, you will not be able to decrease it to its previous value.

        > **Note:** The `service_provider_name`, the `peering_location` and the `bandwidth_in_mbps` should be set together and they conflict with `express_route_port_id` and `bandwidth_in_gbps`.
        """
        return pulumi.get(self, "bandwidth_in_mbps")

    @bandwidth_in_mbps.setter
    def bandwidth_in_mbps(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "bandwidth_in_mbps", value)

    @property
    @pulumi.getter(name="expressRoutePortId")
    def express_route_port_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Express Route Port this Express Route Circuit is based on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_port_id")

    @express_route_port_id.setter
    def express_route_port_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "express_route_port_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the ExpressRoute circuit. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peeringLocation")
    def peering_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the peering location and **not** the Azure resource location. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peering_location")

    @peering_location.setter
    def peering_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peering_location", value)

    @property
    @pulumi.getter(name="rateLimitingEnabled")
    def rate_limiting_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable [rate limiting](https://learn.microsoft.com/en-us/azure/expressroute/rate-limit) for the circuit. Only works with ExpressRoute Ports. Defaults to `false`.
        """
        return pulumi.get(self, "rate_limiting_enabled")

    @rate_limiting_enabled.setter
    def rate_limiting_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "rate_limiting_enabled", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the ExpressRoute circuit. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The string needed by the service provider to provision the ExpressRoute circuit.
        """
        return pulumi.get(self, "service_key")

    @service_key.setter
    def service_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_key", value)

    @property
    @pulumi.getter(name="serviceProviderName")
    def service_provider_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the ExpressRoute Service Provider. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_provider_name")

    @service_provider_name.setter
    def service_provider_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_provider_name", value)

    @property
    @pulumi.getter(name="serviceProviderProvisioningState")
    def service_provider_provisioning_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ExpressRoute circuit provisioning state from your chosen service provider. Possible values are `NotProvisioned`, `Provisioning`, `Provisioned`, and `Deprovisioning`.
        """
        return pulumi.get(self, "service_provider_provisioning_state")

    @service_provider_provisioning_state.setter
    def service_provider_provisioning_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_provider_provisioning_state", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['ExpressRouteCircuitSkuArgs']]:
        """
        A `sku` block for the ExpressRoute circuit as documented below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['ExpressRouteCircuitSkuArgs']]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:network/expressRouteCircuit:ExpressRouteCircuit")
class ExpressRouteCircuit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_classic_operations: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_key: Optional[pulumi.Input[builtins.str]] = None,
                 bandwidth_in_gbps: Optional[pulumi.Input[builtins.float]] = None,
                 bandwidth_in_mbps: Optional[pulumi.Input[builtins.int]] = None,
                 express_route_port_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peering_location: Optional[pulumi.Input[builtins.str]] = None,
                 rate_limiting_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['ExpressRouteCircuitSkuArgs', 'ExpressRouteCircuitSkuArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an ExpressRoute circuit.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="exprtTest",
            location="West Europe")
        example_express_route_circuit = azure.network.ExpressRouteCircuit("example",
            name="expressRoute1",
            resource_group_name=example.name,
            location=example.location,
            service_provider_name="Equinix",
            peering_location="Silicon Valley",
            bandwidth_in_mbps=50,
            sku={
                "tier": "Standard",
                "family": "MeteredData",
            },
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        ExpressRoute circuits can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/expressRouteCircuit:ExpressRouteCircuit myExpressRoute /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/expressRouteCircuits/myExpressRoute
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_classic_operations: Allow the circuit to interact with classic (RDFE) resources. Defaults to `false`.
        :param pulumi.Input[builtins.str] authorization_key: The authorization key. This can be used to set up an ExpressRoute Circuit with an ExpressRoute Port from another subscription.
        :param pulumi.Input[builtins.float] bandwidth_in_gbps: The bandwidth in Gbps of the circuit being created on the Express Route Port.
               
               > **Note:** The `express_route_port_id` and the `bandwidth_in_gbps` should be set together and they conflict with `service_provider_name`, `peering_location` and `bandwidth_in_mbps`.
        :param pulumi.Input[builtins.int] bandwidth_in_mbps: The bandwidth in Mbps of the circuit being created on the Service Provider.
               
               > **Note:** Once you increase your bandwidth, you will not be able to decrease it to its previous value.
               
               > **Note:** The `service_provider_name`, the `peering_location` and the `bandwidth_in_mbps` should be set together and they conflict with `express_route_port_id` and `bandwidth_in_gbps`.
        :param pulumi.Input[builtins.str] express_route_port_id: The ID of the Express Route Port this Express Route Circuit is based on. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the ExpressRoute circuit. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] peering_location: The name of the peering location and **not** the Azure resource location. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] rate_limiting_enabled: Enable [rate limiting](https://learn.microsoft.com/en-us/azure/expressroute/rate-limit) for the circuit. Only works with ExpressRoute Ports. Defaults to `false`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the ExpressRoute circuit. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] service_provider_name: The name of the ExpressRoute Service Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ExpressRouteCircuitSkuArgs', 'ExpressRouteCircuitSkuArgsDict']] sku: A `sku` block for the ExpressRoute circuit as documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExpressRouteCircuitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ExpressRoute circuit.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="exprtTest",
            location="West Europe")
        example_express_route_circuit = azure.network.ExpressRouteCircuit("example",
            name="expressRoute1",
            resource_group_name=example.name,
            location=example.location,
            service_provider_name="Equinix",
            peering_location="Silicon Valley",
            bandwidth_in_mbps=50,
            sku={
                "tier": "Standard",
                "family": "MeteredData",
            },
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        ExpressRoute circuits can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/expressRouteCircuit:ExpressRouteCircuit myExpressRoute /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/expressRouteCircuits/myExpressRoute
        ```

        :param str resource_name: The name of the resource.
        :param ExpressRouteCircuitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExpressRouteCircuitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_classic_operations: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_key: Optional[pulumi.Input[builtins.str]] = None,
                 bandwidth_in_gbps: Optional[pulumi.Input[builtins.float]] = None,
                 bandwidth_in_mbps: Optional[pulumi.Input[builtins.int]] = None,
                 express_route_port_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peering_location: Optional[pulumi.Input[builtins.str]] = None,
                 rate_limiting_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['ExpressRouteCircuitSkuArgs', 'ExpressRouteCircuitSkuArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExpressRouteCircuitArgs.__new__(ExpressRouteCircuitArgs)

            __props__.__dict__["allow_classic_operations"] = allow_classic_operations
            __props__.__dict__["authorization_key"] = None if authorization_key is None else pulumi.Output.secret(authorization_key)
            __props__.__dict__["bandwidth_in_gbps"] = bandwidth_in_gbps
            __props__.__dict__["bandwidth_in_mbps"] = bandwidth_in_mbps
            __props__.__dict__["express_route_port_id"] = express_route_port_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["peering_location"] = peering_location
            __props__.__dict__["rate_limiting_enabled"] = rate_limiting_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["service_provider_name"] = service_provider_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["service_key"] = None
            __props__.__dict__["service_provider_provisioning_state"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["authorizationKey", "serviceKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ExpressRouteCircuit, __self__).__init__(
            'azure:network/expressRouteCircuit:ExpressRouteCircuit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_classic_operations: Optional[pulumi.Input[builtins.bool]] = None,
            authorization_key: Optional[pulumi.Input[builtins.str]] = None,
            bandwidth_in_gbps: Optional[pulumi.Input[builtins.float]] = None,
            bandwidth_in_mbps: Optional[pulumi.Input[builtins.int]] = None,
            express_route_port_id: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            peering_location: Optional[pulumi.Input[builtins.str]] = None,
            rate_limiting_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            service_key: Optional[pulumi.Input[builtins.str]] = None,
            service_provider_name: Optional[pulumi.Input[builtins.str]] = None,
            service_provider_provisioning_state: Optional[pulumi.Input[builtins.str]] = None,
            sku: Optional[pulumi.Input[Union['ExpressRouteCircuitSkuArgs', 'ExpressRouteCircuitSkuArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'ExpressRouteCircuit':
        """
        Get an existing ExpressRouteCircuit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_classic_operations: Allow the circuit to interact with classic (RDFE) resources. Defaults to `false`.
        :param pulumi.Input[builtins.str] authorization_key: The authorization key. This can be used to set up an ExpressRoute Circuit with an ExpressRoute Port from another subscription.
        :param pulumi.Input[builtins.float] bandwidth_in_gbps: The bandwidth in Gbps of the circuit being created on the Express Route Port.
               
               > **Note:** The `express_route_port_id` and the `bandwidth_in_gbps` should be set together and they conflict with `service_provider_name`, `peering_location` and `bandwidth_in_mbps`.
        :param pulumi.Input[builtins.int] bandwidth_in_mbps: The bandwidth in Mbps of the circuit being created on the Service Provider.
               
               > **Note:** Once you increase your bandwidth, you will not be able to decrease it to its previous value.
               
               > **Note:** The `service_provider_name`, the `peering_location` and the `bandwidth_in_mbps` should be set together and they conflict with `express_route_port_id` and `bandwidth_in_gbps`.
        :param pulumi.Input[builtins.str] express_route_port_id: The ID of the Express Route Port this Express Route Circuit is based on. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the ExpressRoute circuit. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] peering_location: The name of the peering location and **not** the Azure resource location. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] rate_limiting_enabled: Enable [rate limiting](https://learn.microsoft.com/en-us/azure/expressroute/rate-limit) for the circuit. Only works with ExpressRoute Ports. Defaults to `false`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the ExpressRoute circuit. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] service_key: The string needed by the service provider to provision the ExpressRoute circuit.
        :param pulumi.Input[builtins.str] service_provider_name: The name of the ExpressRoute Service Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] service_provider_provisioning_state: The ExpressRoute circuit provisioning state from your chosen service provider. Possible values are `NotProvisioned`, `Provisioning`, `Provisioned`, and `Deprovisioning`.
        :param pulumi.Input[Union['ExpressRouteCircuitSkuArgs', 'ExpressRouteCircuitSkuArgsDict']] sku: A `sku` block for the ExpressRoute circuit as documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExpressRouteCircuitState.__new__(_ExpressRouteCircuitState)

        __props__.__dict__["allow_classic_operations"] = allow_classic_operations
        __props__.__dict__["authorization_key"] = authorization_key
        __props__.__dict__["bandwidth_in_gbps"] = bandwidth_in_gbps
        __props__.__dict__["bandwidth_in_mbps"] = bandwidth_in_mbps
        __props__.__dict__["express_route_port_id"] = express_route_port_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["peering_location"] = peering_location
        __props__.__dict__["rate_limiting_enabled"] = rate_limiting_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["service_key"] = service_key
        __props__.__dict__["service_provider_name"] = service_provider_name
        __props__.__dict__["service_provider_provisioning_state"] = service_provider_provisioning_state
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        return ExpressRouteCircuit(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowClassicOperations")
    def allow_classic_operations(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Allow the circuit to interact with classic (RDFE) resources. Defaults to `false`.
        """
        return pulumi.get(self, "allow_classic_operations")

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The authorization key. This can be used to set up an ExpressRoute Circuit with an ExpressRoute Port from another subscription.
        """
        return pulumi.get(self, "authorization_key")

    @property
    @pulumi.getter(name="bandwidthInGbps")
    def bandwidth_in_gbps(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        The bandwidth in Gbps of the circuit being created on the Express Route Port.

        > **Note:** The `express_route_port_id` and the `bandwidth_in_gbps` should be set together and they conflict with `service_provider_name`, `peering_location` and `bandwidth_in_mbps`.
        """
        return pulumi.get(self, "bandwidth_in_gbps")

    @property
    @pulumi.getter(name="bandwidthInMbps")
    def bandwidth_in_mbps(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The bandwidth in Mbps of the circuit being created on the Service Provider.

        > **Note:** Once you increase your bandwidth, you will not be able to decrease it to its previous value.

        > **Note:** The `service_provider_name`, the `peering_location` and the `bandwidth_in_mbps` should be set together and they conflict with `express_route_port_id` and `bandwidth_in_gbps`.
        """
        return pulumi.get(self, "bandwidth_in_mbps")

    @property
    @pulumi.getter(name="expressRoutePortId")
    def express_route_port_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the Express Route Port this Express Route Circuit is based on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_port_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the ExpressRoute circuit. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peeringLocation")
    def peering_location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the peering location and **not** the Azure resource location. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peering_location")

    @property
    @pulumi.getter(name="rateLimitingEnabled")
    def rate_limiting_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable [rate limiting](https://learn.microsoft.com/en-us/azure/expressroute/rate-limit) for the circuit. Only works with ExpressRoute Ports. Defaults to `false`.
        """
        return pulumi.get(self, "rate_limiting_enabled")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the ExpressRoute circuit. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> pulumi.Output[builtins.str]:
        """
        The string needed by the service provider to provision the ExpressRoute circuit.
        """
        return pulumi.get(self, "service_key")

    @property
    @pulumi.getter(name="serviceProviderName")
    def service_provider_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the ExpressRoute Service Provider. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_provider_name")

    @property
    @pulumi.getter(name="serviceProviderProvisioningState")
    def service_provider_provisioning_state(self) -> pulumi.Output[builtins.str]:
        """
        The ExpressRoute circuit provisioning state from your chosen service provider. Possible values are `NotProvisioned`, `Provisioning`, `Provisioned`, and `Deprovisioning`.
        """
        return pulumi.get(self, "service_provider_provisioning_state")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output['outputs.ExpressRouteCircuitSku']:
        """
        A `sku` block for the ExpressRoute circuit as documented below.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

