# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExpressRoutePortArgs', 'ExpressRoutePort']

@pulumi.input_type
class ExpressRoutePortArgs:
    def __init__(__self__, *,
                 bandwidth_in_gbps: pulumi.Input[builtins.int],
                 encapsulation: pulumi.Input[builtins.str],
                 peering_location: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 billing_type: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input['ExpressRoutePortIdentityArgs']] = None,
                 link1: Optional[pulumi.Input['ExpressRoutePortLink1Args']] = None,
                 link2: Optional[pulumi.Input['ExpressRoutePortLink2Args']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ExpressRoutePort resource.
        :param pulumi.Input[builtins.int] bandwidth_in_gbps: Bandwidth of the Express Route Port in Gbps. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] encapsulation: The encapsulation method used for the Express Route Port. Changing this forces a new Express Route Port to be created. Possible values are: `Dot1Q`, `QinQ`.
        :param pulumi.Input[builtins.str] peering_location: The name of the peering location that this Express Route Port is physically mapped to. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Express Route Port should exist. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] billing_type: The billing type of the Express Route Port. Possible values are `MeteredData` and `UnlimitedData`. Defaults to `MeteredData`.
        :param pulumi.Input['ExpressRoutePortIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input['ExpressRoutePortLink1Args'] link1: A list of `link` blocks as defined below.
        :param pulumi.Input['ExpressRoutePortLink2Args'] link2: A list of `link` blocks as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Express Route Port should exist. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Express Route Port. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Express Route Port.
        """
        pulumi.set(__self__, "bandwidth_in_gbps", bandwidth_in_gbps)
        pulumi.set(__self__, "encapsulation", encapsulation)
        pulumi.set(__self__, "peering_location", peering_location)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if billing_type is not None:
            pulumi.set(__self__, "billing_type", billing_type)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if link1 is not None:
            pulumi.set(__self__, "link1", link1)
        if link2 is not None:
            pulumi.set(__self__, "link2", link2)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="bandwidthInGbps")
    def bandwidth_in_gbps(self) -> pulumi.Input[builtins.int]:
        """
        Bandwidth of the Express Route Port in Gbps. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "bandwidth_in_gbps")

    @bandwidth_in_gbps.setter
    def bandwidth_in_gbps(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "bandwidth_in_gbps", value)

    @property
    @pulumi.getter
    def encapsulation(self) -> pulumi.Input[builtins.str]:
        """
        The encapsulation method used for the Express Route Port. Changing this forces a new Express Route Port to be created. Possible values are: `Dot1Q`, `QinQ`.
        """
        return pulumi.get(self, "encapsulation")

    @encapsulation.setter
    def encapsulation(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "encapsulation", value)

    @property
    @pulumi.getter(name="peeringLocation")
    def peering_location(self) -> pulumi.Input[builtins.str]:
        """
        The name of the peering location that this Express Route Port is physically mapped to. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "peering_location")

    @peering_location.setter
    def peering_location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "peering_location", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Express Route Port should exist. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The billing type of the Express Route Port. Possible values are `MeteredData` and `UnlimitedData`. Defaults to `MeteredData`.
        """
        return pulumi.get(self, "billing_type")

    @billing_type.setter
    def billing_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "billing_type", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ExpressRoutePortIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ExpressRoutePortIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def link1(self) -> Optional[pulumi.Input['ExpressRoutePortLink1Args']]:
        """
        A list of `link` blocks as defined below.
        """
        return pulumi.get(self, "link1")

    @link1.setter
    def link1(self, value: Optional[pulumi.Input['ExpressRoutePortLink1Args']]):
        pulumi.set(self, "link1", value)

    @property
    @pulumi.getter
    def link2(self) -> Optional[pulumi.Input['ExpressRoutePortLink2Args']]:
        """
        A list of `link` blocks as defined below.
        """
        return pulumi.get(self, "link2")

    @link2.setter
    def link2(self, value: Optional[pulumi.Input['ExpressRoutePortLink2Args']]):
        pulumi.set(self, "link2", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Express Route Port should exist. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Express Route Port. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Express Route Port.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ExpressRoutePortState:
    def __init__(__self__, *,
                 bandwidth_in_gbps: Optional[pulumi.Input[builtins.int]] = None,
                 billing_type: Optional[pulumi.Input[builtins.str]] = None,
                 encapsulation: Optional[pulumi.Input[builtins.str]] = None,
                 ethertype: Optional[pulumi.Input[builtins.str]] = None,
                 guid: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input['ExpressRoutePortIdentityArgs']] = None,
                 link1: Optional[pulumi.Input['ExpressRoutePortLink1Args']] = None,
                 link2: Optional[pulumi.Input['ExpressRoutePortLink2Args']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mtu: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peering_location: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ExpressRoutePort resources.
        :param pulumi.Input[builtins.int] bandwidth_in_gbps: Bandwidth of the Express Route Port in Gbps. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] billing_type: The billing type of the Express Route Port. Possible values are `MeteredData` and `UnlimitedData`. Defaults to `MeteredData`.
        :param pulumi.Input[builtins.str] encapsulation: The encapsulation method used for the Express Route Port. Changing this forces a new Express Route Port to be created. Possible values are: `Dot1Q`, `QinQ`.
        :param pulumi.Input[builtins.str] ethertype: The EtherType of the Express Route Port.
        :param pulumi.Input[builtins.str] guid: The resource GUID of the Express Route Port.
        :param pulumi.Input['ExpressRoutePortIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input['ExpressRoutePortLink1Args'] link1: A list of `link` blocks as defined below.
        :param pulumi.Input['ExpressRoutePortLink2Args'] link2: A list of `link` blocks as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Express Route Port should exist. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] mtu: The maximum transmission unit of the Express Route Port.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Express Route Port. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] peering_location: The name of the peering location that this Express Route Port is physically mapped to. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Express Route Port should exist. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Express Route Port.
        """
        if bandwidth_in_gbps is not None:
            pulumi.set(__self__, "bandwidth_in_gbps", bandwidth_in_gbps)
        if billing_type is not None:
            pulumi.set(__self__, "billing_type", billing_type)
        if encapsulation is not None:
            pulumi.set(__self__, "encapsulation", encapsulation)
        if ethertype is not None:
            pulumi.set(__self__, "ethertype", ethertype)
        if guid is not None:
            pulumi.set(__self__, "guid", guid)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if link1 is not None:
            pulumi.set(__self__, "link1", link1)
        if link2 is not None:
            pulumi.set(__self__, "link2", link2)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peering_location is not None:
            pulumi.set(__self__, "peering_location", peering_location)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="bandwidthInGbps")
    def bandwidth_in_gbps(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Bandwidth of the Express Route Port in Gbps. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "bandwidth_in_gbps")

    @bandwidth_in_gbps.setter
    def bandwidth_in_gbps(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "bandwidth_in_gbps", value)

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The billing type of the Express Route Port. Possible values are `MeteredData` and `UnlimitedData`. Defaults to `MeteredData`.
        """
        return pulumi.get(self, "billing_type")

    @billing_type.setter
    def billing_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "billing_type", value)

    @property
    @pulumi.getter
    def encapsulation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The encapsulation method used for the Express Route Port. Changing this forces a new Express Route Port to be created. Possible values are: `Dot1Q`, `QinQ`.
        """
        return pulumi.get(self, "encapsulation")

    @encapsulation.setter
    def encapsulation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encapsulation", value)

    @property
    @pulumi.getter
    def ethertype(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The EtherType of the Express Route Port.
        """
        return pulumi.get(self, "ethertype")

    @ethertype.setter
    def ethertype(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ethertype", value)

    @property
    @pulumi.getter
    def guid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource GUID of the Express Route Port.
        """
        return pulumi.get(self, "guid")

    @guid.setter
    def guid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "guid", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ExpressRoutePortIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ExpressRoutePortIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def link1(self) -> Optional[pulumi.Input['ExpressRoutePortLink1Args']]:
        """
        A list of `link` blocks as defined below.
        """
        return pulumi.get(self, "link1")

    @link1.setter
    def link1(self, value: Optional[pulumi.Input['ExpressRoutePortLink1Args']]):
        pulumi.set(self, "link1", value)

    @property
    @pulumi.getter
    def link2(self) -> Optional[pulumi.Input['ExpressRoutePortLink2Args']]:
        """
        A list of `link` blocks as defined below.
        """
        return pulumi.get(self, "link2")

    @link2.setter
    def link2(self, value: Optional[pulumi.Input['ExpressRoutePortLink2Args']]):
        pulumi.set(self, "link2", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Express Route Port should exist. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum transmission unit of the Express Route Port.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Express Route Port. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peeringLocation")
    def peering_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the peering location that this Express Route Port is physically mapped to. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "peering_location")

    @peering_location.setter
    def peering_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peering_location", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Express Route Port should exist. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Express Route Port.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:network/expressRoutePort:ExpressRoutePort")
class ExpressRoutePort(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth_in_gbps: Optional[pulumi.Input[builtins.int]] = None,
                 billing_type: Optional[pulumi.Input[builtins.str]] = None,
                 encapsulation: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ExpressRoutePortIdentityArgs', 'ExpressRoutePortIdentityArgsDict']]] = None,
                 link1: Optional[pulumi.Input[Union['ExpressRoutePortLink1Args', 'ExpressRoutePortLink1ArgsDict']]] = None,
                 link2: Optional[pulumi.Input[Union['ExpressRoutePortLink2Args', 'ExpressRoutePortLink2ArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peering_location: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Express Route Port.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West US")
        example_express_route_port = azure.network.ExpressRoutePort("example",
            name="port1",
            resource_group_name=example.name,
            location=example.location,
            peering_location="Airtel-Chennai-CLS",
            bandwidth_in_gbps=10,
            encapsulation="Dot1Q")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Express Route Ports can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/expressRoutePort:ExpressRoutePort example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/expressRoutePorts/port1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] bandwidth_in_gbps: Bandwidth of the Express Route Port in Gbps. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] billing_type: The billing type of the Express Route Port. Possible values are `MeteredData` and `UnlimitedData`. Defaults to `MeteredData`.
        :param pulumi.Input[builtins.str] encapsulation: The encapsulation method used for the Express Route Port. Changing this forces a new Express Route Port to be created. Possible values are: `Dot1Q`, `QinQ`.
        :param pulumi.Input[Union['ExpressRoutePortIdentityArgs', 'ExpressRoutePortIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Union['ExpressRoutePortLink1Args', 'ExpressRoutePortLink1ArgsDict']] link1: A list of `link` blocks as defined below.
        :param pulumi.Input[Union['ExpressRoutePortLink2Args', 'ExpressRoutePortLink2ArgsDict']] link2: A list of `link` blocks as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Express Route Port should exist. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Express Route Port. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] peering_location: The name of the peering location that this Express Route Port is physically mapped to. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Express Route Port should exist. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Express Route Port.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExpressRoutePortArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Express Route Port.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West US")
        example_express_route_port = azure.network.ExpressRoutePort("example",
            name="port1",
            resource_group_name=example.name,
            location=example.location,
            peering_location="Airtel-Chennai-CLS",
            bandwidth_in_gbps=10,
            encapsulation="Dot1Q")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Express Route Ports can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/expressRoutePort:ExpressRoutePort example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/expressRoutePorts/port1
        ```

        :param str resource_name: The name of the resource.
        :param ExpressRoutePortArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExpressRoutePortArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth_in_gbps: Optional[pulumi.Input[builtins.int]] = None,
                 billing_type: Optional[pulumi.Input[builtins.str]] = None,
                 encapsulation: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ExpressRoutePortIdentityArgs', 'ExpressRoutePortIdentityArgsDict']]] = None,
                 link1: Optional[pulumi.Input[Union['ExpressRoutePortLink1Args', 'ExpressRoutePortLink1ArgsDict']]] = None,
                 link2: Optional[pulumi.Input[Union['ExpressRoutePortLink2Args', 'ExpressRoutePortLink2ArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 peering_location: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExpressRoutePortArgs.__new__(ExpressRoutePortArgs)

            if bandwidth_in_gbps is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth_in_gbps'")
            __props__.__dict__["bandwidth_in_gbps"] = bandwidth_in_gbps
            __props__.__dict__["billing_type"] = billing_type
            if encapsulation is None and not opts.urn:
                raise TypeError("Missing required property 'encapsulation'")
            __props__.__dict__["encapsulation"] = encapsulation
            __props__.__dict__["identity"] = identity
            __props__.__dict__["link1"] = link1
            __props__.__dict__["link2"] = link2
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if peering_location is None and not opts.urn:
                raise TypeError("Missing required property 'peering_location'")
            __props__.__dict__["peering_location"] = peering_location
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["ethertype"] = None
            __props__.__dict__["guid"] = None
            __props__.__dict__["mtu"] = None
        super(ExpressRoutePort, __self__).__init__(
            'azure:network/expressRoutePort:ExpressRoutePort',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth_in_gbps: Optional[pulumi.Input[builtins.int]] = None,
            billing_type: Optional[pulumi.Input[builtins.str]] = None,
            encapsulation: Optional[pulumi.Input[builtins.str]] = None,
            ethertype: Optional[pulumi.Input[builtins.str]] = None,
            guid: Optional[pulumi.Input[builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ExpressRoutePortIdentityArgs', 'ExpressRoutePortIdentityArgsDict']]] = None,
            link1: Optional[pulumi.Input[Union['ExpressRoutePortLink1Args', 'ExpressRoutePortLink1ArgsDict']]] = None,
            link2: Optional[pulumi.Input[Union['ExpressRoutePortLink2Args', 'ExpressRoutePortLink2ArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            mtu: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            peering_location: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'ExpressRoutePort':
        """
        Get an existing ExpressRoutePort resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] bandwidth_in_gbps: Bandwidth of the Express Route Port in Gbps. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] billing_type: The billing type of the Express Route Port. Possible values are `MeteredData` and `UnlimitedData`. Defaults to `MeteredData`.
        :param pulumi.Input[builtins.str] encapsulation: The encapsulation method used for the Express Route Port. Changing this forces a new Express Route Port to be created. Possible values are: `Dot1Q`, `QinQ`.
        :param pulumi.Input[builtins.str] ethertype: The EtherType of the Express Route Port.
        :param pulumi.Input[builtins.str] guid: The resource GUID of the Express Route Port.
        :param pulumi.Input[Union['ExpressRoutePortIdentityArgs', 'ExpressRoutePortIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Union['ExpressRoutePortLink1Args', 'ExpressRoutePortLink1ArgsDict']] link1: A list of `link` blocks as defined below.
        :param pulumi.Input[Union['ExpressRoutePortLink2Args', 'ExpressRoutePortLink2ArgsDict']] link2: A list of `link` blocks as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Express Route Port should exist. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] mtu: The maximum transmission unit of the Express Route Port.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Express Route Port. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] peering_location: The name of the peering location that this Express Route Port is physically mapped to. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Express Route Port should exist. Changing this forces a new Express Route Port to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Express Route Port.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExpressRoutePortState.__new__(_ExpressRoutePortState)

        __props__.__dict__["bandwidth_in_gbps"] = bandwidth_in_gbps
        __props__.__dict__["billing_type"] = billing_type
        __props__.__dict__["encapsulation"] = encapsulation
        __props__.__dict__["ethertype"] = ethertype
        __props__.__dict__["guid"] = guid
        __props__.__dict__["identity"] = identity
        __props__.__dict__["link1"] = link1
        __props__.__dict__["link2"] = link2
        __props__.__dict__["location"] = location
        __props__.__dict__["mtu"] = mtu
        __props__.__dict__["name"] = name
        __props__.__dict__["peering_location"] = peering_location
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return ExpressRoutePort(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bandwidthInGbps")
    def bandwidth_in_gbps(self) -> pulumi.Output[builtins.int]:
        """
        Bandwidth of the Express Route Port in Gbps. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "bandwidth_in_gbps")

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The billing type of the Express Route Port. Possible values are `MeteredData` and `UnlimitedData`. Defaults to `MeteredData`.
        """
        return pulumi.get(self, "billing_type")

    @property
    @pulumi.getter
    def encapsulation(self) -> pulumi.Output[builtins.str]:
        """
        The encapsulation method used for the Express Route Port. Changing this forces a new Express Route Port to be created. Possible values are: `Dot1Q`, `QinQ`.
        """
        return pulumi.get(self, "encapsulation")

    @property
    @pulumi.getter
    def ethertype(self) -> pulumi.Output[builtins.str]:
        """
        The EtherType of the Express Route Port.
        """
        return pulumi.get(self, "ethertype")

    @property
    @pulumi.getter
    def guid(self) -> pulumi.Output[builtins.str]:
        """
        The resource GUID of the Express Route Port.
        """
        return pulumi.get(self, "guid")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ExpressRoutePortIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def link1(self) -> pulumi.Output['outputs.ExpressRoutePortLink1']:
        """
        A list of `link` blocks as defined below.
        """
        return pulumi.get(self, "link1")

    @property
    @pulumi.getter
    def link2(self) -> pulumi.Output['outputs.ExpressRoutePortLink2']:
        """
        A list of `link` blocks as defined below.
        """
        return pulumi.get(self, "link2")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Express Route Port should exist. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[builtins.str]:
        """
        The maximum transmission unit of the Express Route Port.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Express Route Port. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peeringLocation")
    def peering_location(self) -> pulumi.Output[builtins.str]:
        """
        The name of the peering location that this Express Route Port is physically mapped to. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "peering_location")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Express Route Port should exist. Changing this forces a new Express Route Port to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Express Route Port.
        """
        return pulumi.get(self, "tags")

